/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

var globalalert = new AlertPopup();
var globalcreate= new CreatePopup();
function AlertPopup() {	
	this.header;
	this.buttons;
	this.text;
	this.div;
	this.closecb;
	this.cbok;
	this.cbcancel;
	this.cbyes;
	this.cbno;
	this.cbseries;
	this.cbappointment;
	this.cbnocomment;
	this.visibleButtons=[];
}
AlertPopup.SERIESBUTTON=50;
AlertPopup.OK=1;
AlertPopup.CANCEL=2;
AlertPopup.YES=4;
AlertPopup.NO=8;
AlertPopup.APPOINTMENT=16;
AlertPopup.SERIES=32;
AlertPopup.NOCOMMENT=64;
AlertPopup.EDIT=128;
AlertPopup.CONTINUE=256;
AlertPopup.VERSION=67;
AlertPopup.OKCANCEL=3;
AlertPopup.YESNO=12;
AlertPopup.CONTINUECANCEL=258;

AlertPopup.open = function () {
	globalalert.visibleButtons = [];
    /*
     * remove keydown event just in case!
     */
    removeDOMEvent(body, "keydown", AlertPopup.key_down);
    if ("Hover" in window) Hover.disable();
	showNode("disable_background_window");
	$("disable_background_window").style.display="block";
	showNode("disable_confirm_window");
	$("disable_confirm_window").style.display="block";
	/*
	 * enable / disable required buttons
	 */
	if ((globalalert.buttons %  2) >= 1) { 
        $("alert_window_ok").style.display="block";
        setFocus($("alert_window_ok"));
        globalalert.visibleButtons.push({id: "alert_window_ok", evt: AlertPopup.commitok});
    } else { 
        $("alert_window_ok").style.display="none"; 
    }
	if ((globalalert.buttons %  4) >= 2) { 
		$("alert_window_cancel").style.display="block"; 
		globalalert.visibleButtons.push({id: "alert_window_cancel", evt: AlertPopup.commitcancel});
	} else { 
		$("alert_window_cancel").style.display="none"; 
	}
	if ((globalalert.buttons %  8) >= 4) { 
		$("alert_window_yes").style.display="block"; 
		setFocus($("alert_window_yes"));
		globalalert.visibleButtons.push({id: "alert_window_yes", evt: AlertPopup.commityes});
	} else { 
		$("alert_window_yes").style.display="none"; 
	}
	if ((globalalert.buttons % 16) >= 8) { 
		$("alert_window_no").style.display="block";
		globalalert.visibleButtons.push({id: "alert_window_no", evt: AlertPopup.commitno});
	} else { 
		$("alert_window_no").style.display="none"; 
	}	
	if ((globalalert.buttons % 64) >= 32) { 
		$("alert_window_series").style.display="block";
		globalalert.visibleButtons.push({id: "alert_window_series", evt: AlertPopup.commitseries});
	} else { 
		$("alert_window_series").style.display="none"; 
	}
	if ((globalalert.buttons % 32) >= 16) { 
		$("alert_window_appointment").style.display="block"; 
		globalalert.visibleButtons.push({id: "alert_window_appointment", evt: AlertPopup.commitappointment});
	} else { 
		$("alert_window_appointment").style.display="none"; 
	}
	if ((globalalert.buttons % 128) >= 64) { 
		$("alert_window_nocomment").style.display="block"; 
		globalalert.visibleButtons.push({id: "alert_window_nocomment", evt: AlertPopup.commitnocomment});
	} else { 
		$("alert_window_nocomment").style.display="none"; 
	}
	if ((globalalert.buttons % 256) >= 128) { 
		$("alert_window_edit").style.display="block"; 
		globalalert.visibleButtons.push({id: "alert_window_edit", evt: AlertPopup.commitedit});
	} else { 
		$("alert_window_edit").style.display="none"; 
	}
    if ((globalalert.buttons % 512) >= 256) { 
        $("alert_window_continue").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_continue", evt: AlertPopup.commitcontinue});
    } else { 
        $("alert_window_continue").style.display="none"; 
    }
    if (globalalert.SHOWAGAIN) { 
        $("alert_window_showagain").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_showagain_value", evt: function() {}});
    } else { 
        $("alert_window_showagain").style.display="none"; 
    }
	showNode("alert_window");
	$("alert_window-h-c").firstChild.data = globalalert.header;
	removeChildNodes($("alert_window_text"));
	if (globalalert.div) {		
		$("alert_window_text").appendChild(globalalert.div);
	} else {
		var nText = globalalert.text.split("\n");
		for (var i in nText) {
			$("alert_window_text").appendChild(document.createTextNode(nText[i]));
			$("alert_window_text").appendChild(newnode("br"));
		}
	}
	centerPopupWindow($("alert_window"));	
	$("alert_window").style.display="block";
	addDOMEvent(body, "keydown", AlertPopup.key_down);
}
AlertPopup.close = function () {
    if ("Hover" in window) Hover.enable();
	if (globalalert.closecb) { 
		globalalert.closecb(); 
	}
	removeDOMEvent(body, "keydown", AlertPopup.key_down);
	hideNode("alert_window");
	$("alert_window").style.display="none";	
	hideNode("disable_confirm_window");
	$("disable_confirm_window").style.display="none";
	var childs=	$("disable_background_window").childNodes;
	var closeall=true;
	for(var i=0;i<childs.length;i++) {
		if(childs[i].tagName && childs[i].tagName == "DIV") {
			if(childs[i].style.display && childs[i].style.display != "none" ) {
				closeall=false;
			}
		}
	}
	globalalert.visibleButtons = {};
	if(closeall) {
		hideNode("disable_background_window");
		$("disable_background_window").style.display="none";
	}
}
AlertPopup.commityes = function () {
	if(globalalert.cbyes) { globalalert.cbyes(); }
	AlertPopup.close();
}
AlertPopup.commitno = function () {
	if(globalalert.cbno) { globalalert.cbno(); }
	AlertPopup.close();
}
AlertPopup.commitcancel = function () {
	if(globalalert.cbcancel) { globalalert.cbcancel(); }
	AlertPopup.close();
}
AlertPopup.commitok = function () {
	if(globalalert.cbok) { globalalert.cbok(); }
	AlertPopup.close();
}
AlertPopup.commitseries = function () {
	if(globalalert.cbseries) { globalalert.cbseries(); }
	AlertPopup.close();
}
AlertPopup.commitnocomment = function () {
	if(globalalert.cbnocomment) { globalalert.cbnocomment(); }
	AlertPopup.close();
}
AlertPopup.commitappointment = function () {
	if(globalalert.cbappointment) { globalalert.cbappointment(); }
	AlertPopup.close();
}
AlertPopup.commitedit = function () {
	if(globalalert.cbedit) { globalalert.cbedit(); }
	AlertPopup.close();
}
AlertPopup.key_down = function(e) {
    switch (e.keyCode || e.which) {
    	case 27: // esc
    	    AlertPopup.close();
    	    break;
        case 9: // tab
            if (!globalalert.visibleButtons.length) break;
            if (focusedElement != null) {               
                for (var i=0; i<globalalert.visibleButtons.length; i++) {
                    if (globalalert.visibleButtons[i].id == focusedElement.id) {
                        if (i+1 < globalalert.visibleButtons.length) {
                            setFocus($(globalalert.visibleButtons[i+1].id));
                        } else {
                            setFocus($(globalalert.visibleButtons[0].id));
                        }
                        break;
                    }
                }
            } else {
                setFocus($(globalalert.visibleButtons[0].id));
            }
            break;
        case 32: // space
        case 13: // enter 
            if (!globalalert.visibleButtons.length) break;
            if (focusedElement != null) {               
                for (var i=0; i<globalalert.visibleButtons.length; i++) {
                    if (globalalert.visibleButtons[i].id == focusedElement.id) {
                        globalalert.visibleButtons[i].evt();
                        break;
                    }
                }
            }
            break;         
        default:
            return;        
    }
    stopEvent(e);
    return false;
}
AlertPopup.prototype = 
{
	setOK : function (cb) {
		this.cbok=cb;
	},
	setCancel : function (cb) {
		this.cbcancel=cb;
	},
	setYes : function (cb) {
		this.cbyes=cb;
	},
	setNo : function (cb) {
		this.cbno=cb;
	},
	setSeries: function (cb) {
		this.cbseries=cb;
	},
	setAppointment: function (cb) {
		this.cbappointment=cb;
	},
	setClose: function (cb) {
		this.closecb=cb;
	},
	setNoComment : function(cb) {
		this.cbnocomment=cb;
	},
	setEdit: function(cb) {
		this.cbedit=cb;
	}
}


function CreatePopup() {	
	this.header;
	this.buttons;
	this.text;
	this.inputtext;
	this.inputvalue;
	this.closecb;
	this.cbok;
	this.cbcancel;
	this.cbadvanced;
	this.cbnocomment;
}
CreatePopup.OK=1;
CreatePopup.CANCEL=2;
CreatePopup.NOCOMMENT=4;
CreatePopup.VERSION=7;
CreatePopup.ADVANCED=64;
CreatePopup.ALL=67;

CreatePopup.open = function () {
	showNode("disable_background_window");
	$("disable_background_window").style.display="block";
	showNode("disable_confirm_window");
	$("disable_confirm_window").style.display="block"
	if ((globalcreate.buttons %  4) >= 2) { $("create_window_cancel").style.display="block"; } else { $("create_window_cancel").style.display="none"; }
	if ((globalcreate.buttons %  8) >= 4) { $("create_window_nocomment").style.display="block"; } else { $("create_window_nocomment").style.display="none"; }
	if ((globalcreate.buttons %  2) >= 1) { $("create_window_ok").style.display="block"; } else { $("create_window_ok").style.display="none"; }
	
	if ((globalcreate.buttons % 128) >= 64) { $("create_window_advanced").style.display="block"; } else { $("create_window_advanced").style.display="none"; }
	
	$("create_window-h-c").firstChild.data = globalcreate.header;
	$("create_window_text").firstChild.data = globalcreate.text;
	if(globalcreate.inputtype == "input") {
		$("create_window_table_textarea").style.display="none";
		$("create_window_table_text_input").style.display="block";
		if (globalcreate.inputtext) {
			$("create_window_text_input").style.display="";
		    $("create_window_text_input").firstChild.data = globalcreate.inputtext;
		} else {
			$("create_window_text_input").style.display="none";
		}	
		$("create_window_text_field").value=globalcreate.inputvalue;
		setTimeout(function() { 
			if ($("create_window_text_field") && $("create_window_text_field").focus()) $("create_window_text_field").focus(); 
		},500);
	} else if(globalcreate.inputtype == "textarea") {
		$("create_window_table_textarea").style.display="block";
		$("create_window_table_text_input").style.display="none";
		$("create_window_textarea").firstChild.data = globalcreate.inputtext;	
		$("create_window_textarea_field").value=globalcreate.inputvalue;
		setTimeout(function() { 
			if ($("create_window_textarea_field") && $("create_window_textarea_field").focus()) $("create_window_textarea_field").focus(); 
		},500);
	}
	showNode("create_window");
	centerPopupWindow($("create_window"));
	$("create_window").style.display="block";
}
CreatePopup.close = function () {
	if(globalcreate.closecb) { globalcreate.closecb(); }
	hideNode("create_window");
	$("create_window").style.display="none";	
	hideNode("disable_confirm_window");
	$("disable_confirm_window").style.display="none";
	var childs=	$("disable_background_window").childNodes;
	var closeall=true;
	for(var i=0;i<childs.length;i++) {
		if(childs[i].tagName && childs[i].tagName == "DIV") {
			if(childs[i].style.display && childs[i].style.display != "none" ) {
			
				closeall=false;
			}
		}
	}
	if(closeall) {
		hideNode("disable_background_window");
		$("disable_background_window").style.display="none";
	}
}
CreatePopup.commitcancel = function () {
	if(globalcreate.cbcancel) { globalcreate.cbcancel(); }
	CreatePopup.close();
}
CreatePopup.commitok = function () {
	if(globalcreate.cbok) { globalcreate.cbok(); }
	CreatePopup.close();
}
CreatePopup.commitnocomment = function () {
	if(globalcreate.cbnocomment) { globalcreate.cbnocomment(); }
	CreatePopup.close();
}
CreatePopup.commitadvanced = function () {
	if(globalcreate.cbadvanced) { globalcreate.cbadvanced(); }
	CreatePopup.close();
}

CreatePopup.prototype = 
{
	setOK : function (cb) {
		this.cbok=cb;
	},
	setCancel : function (cb) {
		this.cbcancel=cb;
	},
	setAdvanced: function (cb) {
		this.cbadvanced=cb;
	},
	setClose: function (cb) {
		this.closecb=cb;
	},
	setNoComment : function (cb) {
		this.cbnocomment=cb;
	}
}
function newAlert(headertitle,alerttext,okcb,div) {
	globalalert.header=headertitle;
	globalalert.buttons=CreatePopup.OK;
	globalalert.text=alerttext;
	globalalert.div=div;
	globalalert.closecb=null;
	globalalert.cbok=okcb;
	globalalert.cbcancel=null;
	globalalert.cbnocomment=null;
	globalalert.cbyes=null;
	globalalert.cbno=null;
	AlertPopup.open();
}
function newConfirm(headertitle,contenttext,buttons,cbok,cbcancel,cbyes,cbno,cbseries,cbappointment,cbclose,cbnocomment,cbedit,div) {
	globalalert.header=headertitle;
	globalalert.buttons=buttons;
	globalalert.text=contenttext;
	globalalert.div=div;
	globalalert.closecb=cbclose;
	globalalert.cbok=cbok;
	globalalert.cbappointment=cbappointment;
	globalalert.cbseries=cbseries;
	globalalert.cbcancel=cbcancel;
	globalalert.cbedit=cbedit;
	globalalert.cbyes=cbyes;
	globalalert.cbno=cbno;
	globalalert.cbnocomment=cbnocomment;
	AlertPopup.open();	
}
function newInput(headertitle,contenttext,inputtext,inputvalue,buttons,cbok,cbcancel,cbadvanced,cbclose,
																					inputType,cbnocomment) {
	globalcreate.header=headertitle;
	globalcreate.text=contenttext;
	globalcreate.inputtext=inputtext;
	if(inputvalue)
		globalcreate.inputvalue=inputvalue;
	else
		globalcreate.inputvalue="";
	globalcreate.buttons=buttons;
	globalcreate.closecb=cbclose;
	globalcreate.cbok=cbok;
	globalcreate.cbcancel=cbcancel;
	globalcreate.cbnocomment=cbnocomment;
	globalcreate.cbadvanced=cbadvanced;
	if(inputType)
		globalcreate.inputtype=inputType;
	else
		globalcreate.inputvalue="input";
	CreatePopup.open();	
}
function newAppointmentObject(appointmentobject,myok,mycancel,myadvanced,myclose) {
	if(appointmentobject.start_date && appointmentobject.end_date) {
		var mystring=formatDate(appointmentobject.start_date,"datetime")+ " - "+formatDate(appointmentobject.end_date,"datetime"); 
		newInput(_("New Appointment"),mystring, pgettext("description", "Title"),"",CreatePopup.ALL,myok,mycancel,myadvanced,myclose);
	}
}
register("Loaded",function() {
	addOnClose($('alert_window'),function () { 
		AlertPopup.close();
	});
	addOnClose($('create_window'),function () { 
		CreatePopup.close(); 
	});
});
fileloaded();