<?xml version="1.0" encoding="UTF-8"?>

<!-- 

	All content on this website (including text, images, source
	code and any other original works), unless otherwise noted,
	is licensed under a Creative Commons License.
	
	http://creativecommons.org/licenses/by-nc-sa/2.5/
	
	Copyright (C) 2004-2010 Open-Xchange, Inc.
	Mail: info@open-xchange.com 
	
	@author Viktor Pracht <viktor.pracht@open-xchange.com>

 -->

<stylesheet version="2.0"
            xmlns="http://www.w3.org/1999/XSL/Transform"
            xmlns:h="http://www.w3.org/1999/xhtml"
            xmlns:ox="http://localhost/html/dtd/ox.dtd"
            xmlns:saxon="http://saxon.sf.net/"
            xmlns:date="http://exslt.org/dates-and-times"
            exclude-result-prefixes="saxon date"
            extension-element-prefixes="saxon date">
	<output method="text" encoding="UTF-8"/>
	<param name="root"/>

	<template match="/">
		<for-each select="//h:title">
			<variable name="pos" select="concat(substring-after(document-uri(/), $root), ':', saxon:line-number())"/>
			<call-template name="i18n-output">
				<with-param name="text" select="text()"/>
				<with-param name="pos" select="$pos"/>
			</call-template>
		</for-each>
		<for-each select="//*[@ox:i18n]">
			<variable name="text" select="text()"/>
			<variable name="node" select="."/>
			<variable name="pos" select="concat(substring-after(document-uri(/), $root), ':', saxon:line-number())"/>
			<if test="not(string(@ox:i18n))">
				<call-template name="i18n-output">
					<with-param name="text" select="$text"/>
					<with-param name="pos" select="$pos"/>
				</call-template>
			</if>
			<for-each select="tokenize(@ox:i18n, ',')">
				<if test="not(.)">
					<call-template name="i18n-output">
						<with-param name="text" select="$text"/>
						<with-param name="pos" select="$pos"/>
					</call-template>
				</if>
				<if test=".">
					<variable name="name" select="."/>
					<call-template name="i18n-output">
						<with-param name="text" select="$node/@*[name() = $name]"/>
						<with-param name="pos" select="$pos"/>
					</call-template>
				</if>
			</for-each>
		</for-each>
		<for-each select="//@ox:help">
			<variable name="pos" select="concat(substring-after(document-uri(/), $root), ':', saxon:line-number())"/>
			<call-template name="i18n-output">
				<with-param name="text" select="."/>
				<with-param name="pos" select="$pos"/>
			</call-template>
		</for-each>
		<for-each select="//ox:popupwindow">
			<variable name="pos" select="concat(substring-after(document-uri(/), $root), ':', saxon:line-number())"/>
			<call-template name="i18n-output">
				<with-param name="text" select="@caption"/>
				<with-param name="pos" select="$pos"/>
			</call-template>
		</for-each>
	</template>

	<template name="i18n-output">
		<param name="text"/>
		<param name="pos"/>
		<if test="count($text) > 1">
			<message>Invalid i18n at <value-of select="$pos"/></message>
		</if>
#: <value-of select="$pos"/>
        <if test="contains($text, '|')">
            <call-template name="output-msg">
                <with-param name="name" select="'msgctxt'"/>
                <with-param name="text" select="substring-before($text, '|')"/>
            </call-template>
            <call-template name="output-msg">
                <with-param name="name" select="'msgid'"/>
                <with-param name="text" select="substring-after($text, '|')"/>
            </call-template>
        </if>
        <if test="not(contains($text, '|'))">
            <call-template name="output-msg">
                <with-param name="name" select="'msgid'"/>
                <with-param name="text" select="$text"/>
            </call-template>
        </if>
msgstr ""
	</template>

    <template name="output-msg">
        <param name="name"/>
        <param name="text"/>
        <text>&#10;</text>
        <value-of select="$name"/>
        <text> "</text>
        <if test="contains($text, '&#10;')">"&#10;"</if>
        <call-template name="escape">
            <with-param name="text" select="$text"/>
        </call-template>"
    </template>

	<template name="escape">
		<param name="text"/>
		<variable name="line" select="substring-before($text, '&#10;')"/>
        <if test="$line">
            <value-of select="replace($line, '&quot;', '\\&quot;')"/>
            <text>\n"&#10;"</text>
            <call-template name="escape">
				<with-param name="text" select="substring-after($text, '&#10;')"/>
			</call-template>
		</if>
		<if test="not($line)"><value-of select="replace($text, '&quot;', '\\&quot;')"/></if>
	</template>
	
</stylesheet>