/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class BooleanFn
extends SystemFunction {
    public static final int BOOLEAN = 0;
    public static final int NOT = 1;
    public static final int TRUE = 2;
    public static final int FALSE = 3;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        switch (this.operation) {
            case 0: 
            case 1: {
                return super.simplify(staticContext);
            }
            case 2: {
                return BooleanValue.TRUE;
            }
            case 3: {
                return BooleanValue.FALSE;
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation");
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (this.operation == 0 || this.operation == 1) {
            XPathException xPathException = TypeChecker.ebvError(this.argument[0], staticContext.getConfiguration().getTypeHierarchy());
            if (xPathException != null) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
            this.argument[0] = ExpressionTool.unsortedIfHomogeneous(optimizer, this.argument[0], false);
        }
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (expression == this) {
            if (this.operation == 0) {
                if (this.argument[0] instanceof ValueComparison) {
                    ValueComparison valueComparison = (ValueComparison)this.argument[0];
                    if (valueComparison.getResultWhenEmpty() == null) {
                        valueComparison.setResultWhenEmpty(BooleanValue.FALSE);
                    }
                    valueComparison.setParentExpression(this.getParentExpression());
                    return this.argument[0];
                }
                if (typeHierarchy.isSubType(this.argument[0].getItemType(typeHierarchy), Type.BOOLEAN_TYPE) && this.argument[0].getCardinality() == 16384) {
                    if (this.argument[0] instanceof ComputedExpression) {
                        ((ComputedExpression)this.argument[0]).setParentExpression(this.getParentExpression());
                    }
                    return this.argument[0];
                }
            } else if (this.operation == 1) {
                if (this.argument[0] instanceof ValueComparison) {
                    ValueComparison valueComparison = ((ValueComparison)this.argument[0]).negate();
                    valueComparison.setParentExpression(this.getParentExpression());
                    return valueComparison.optimize(optimizer, staticContext, itemType);
                }
                if (this.argument[0] instanceof BooleanExpression) {
                    Expression expression2 = ((BooleanExpression)this.argument[0]).negate(staticContext);
                    if (expression2 instanceof ComputedExpression) {
                        ((ComputedExpression)expression2).setParentExpression(this.getParentExpression());
                    }
                    return expression2.optimize(optimizer, staticContext, itemType);
                }
                if (this.argument[0] instanceof BooleanFn) {
                    BooleanFn booleanFn = (BooleanFn)this.argument[0];
                    if (booleanFn.operation == 0) {
                        this.argument[0] = booleanFn.argument[0];
                        this.adoptChildExpression(this.argument[0]);
                    } else {
                        if (booleanFn.argument[0] instanceof ComputedExpression) {
                            ((ComputedExpression)booleanFn.argument[0]).setParentExpression(this.getParentExpression());
                        }
                        return booleanFn.argument[0];
                    }
                }
            }
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            switch (this.operation) {
                case 0: {
                    return this.argument[0].effectiveBooleanValue(xPathContext);
                }
                case 1: {
                    return !this.argument[0].effectiveBooleanValue(xPathContext);
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
            throw new UnsupportedOperationException("Unknown boolean operation");
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }
}

