
# norootforbuild

Name:           open-xchange-gui-wizard-plugin
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-1.5.0-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%if %{?fedora_version} <= 8
BuildRequires:  java-devel-icedtea saxon
%endif
%endif
Version:        6.16.1.0
%define         ox_release 3
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Open-Xchange GUI Wizard Server Plug-In
Requires:       open-xchange-server
#

%package gui
Group:          Applications/Productivity
Requires:       open-xchange-gui >= 6.16.1.0
Summary:        Open-Xchange GUI Wizard Plug-In

%description
Open-Xchange GUI Wizard Plug-In

Authors:
--------
    Open-Xchange

%description gui
Open-Xchange GUI Wizard Plug-In

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif

ant -Dguiprefix=%{docroot}/ox6 -Dlib.dir=/opt/open-xchange/lib -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange install

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/etc/groupware/settings
%config(noreplace) /opt/open-xchange/etc/groupware/settings/open-xchange-gui-wizard-plugin.properties
%files gui
%defattr(-,root,root)
%{docroot}/ox6/plugins/com.openexchange.wizard

%changelog
* Wed Apr 21 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15797 : Wizard: unable to subscribe to Web.de and GMX
* Fri Apr 16 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15891 : [L3] webmail users without global adressbook can't set own contact attributes
* Tue Apr 13 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15729 : New subscriptions done through wizard get parent folder permissions.
  - Fixed bug #15742 : [L3] Using newly created external mail account requires relogin/config refresh
  - Fixed bug #15748 : Wording was corrected.
  - Fixed bug #15773 : wizard: "do not show on start" some times not translated
* Tue Apr 13 2010 - ben.pahne@open-xchange.com
  - Fixed bug #15745 : [L3] Inconsistent field names in personal settings in wizard and GUI setup area
* Tue Apr 13 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15751 : save button disabled but fields active in case of an successfull saved xing account
  - Fixed bug #15772 : wizard: bracket missing State business
  - Fixed bug #15779 : [L3] wizard: creds. get saved even if they are wrong for services with external mail accounts
  - Fixed bug #15792 : subscribe to web.de throws JS error
* Thu Mar 11 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15586 : Unable to stop wizard from starting after login
* Thu Mar 04 2010 - viktor.pracht@open-xchange.com
  - Fixed external pages from other plugins
* Tue Mar 02 2010 - ben.pahne@open-xchange.com
  - TA2748 for US4204 : Two New Services MSN and T-Online
  - TA2749 for US4204 : Improved mobility handling, config-switch for each device
  - TA2750 for US4204 : i18n changes
* Wed Feb 24 2010 - ben.pahne@open-xchange.com
  - TA2690 for US4180 : Create a configfile and export important wizard settings
  - TA2691 for US4180 : Replace static Open-Xchange title with the title from the configuration
* Thu Feb 18 2010 - ben.pahne@open-xchange.com
  - Fixed bug #14857 : Wizard throws ugly error message when creating a duplicate subscription
  - Fixed bug #14931 : Wizard buttons are clickable even if they are shown disabled
  - Fixed bug #14859 : Wizard settings are not visible immediately after finishing the wizard
  - Fixed bug #15180 : [L3] Wizzard status messages not translated
* Wed Feb 17 2010 - ben.pahne@open-xchange.com
  - Fixed bug #15409 : Upsell information is always shown at the wizard 
* Tue Feb 16 2010 - ben.pahne@open-xchange.com
  - Fixed bug #15189 : GUI Wizard does not take care of ENABLE_INTERNAL_USER_EDIT setting
  - Fixed bug #14868 : Wizard pops up after login even if deactivated before
  - Fixed bug #15407 : Wizard shows mobility part, even if no usm or usm-online-help is installed
* Thu Feb 04 2010 - ben.pahne@open-xchange.com
  - TA2535 of US4098 : Make a progress bar
  - TA2536 of US4098 : Make highlight icons
* Tue Jan 26 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15447 : Wizard pops up below the bottom browser border
* Mon Jan 25 2010 - ben.pahne@open-xchange.com
  - TA2087 of US3847 : Each device gets its own frame on the mobility tab 
  - TA2288 of US3976 : New Tab called Upsell Layer
  - TA2289 of US3976 : Create Icon for Upsell Layer
* Tue Jan 12 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #14954 : Wizard radiobuttons don't have any defaults with IE
  - Fixed bug #15043 : Publication link produced by the wizard link to dead pages
* Fri Dec 04 2009 - stefan.preuss@open-xchange.com
  - It's no longer required to press a save button on the 'Personal Data' tab
* Fri Nov 27 2009 - choeger@open-xchange.com
  - Fixed bug #14989 -  open-xchange-gui-wizard-plugin does not work on SLES and RHEL
* Wed Nov 25 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14971 : Subscribing to web.de does not work through the wizard
* Wed Nov 25 2009 - choeger@open-xchange.com
  - Fixed bug #14920 :  Wizard package deploys server related configuration file
* Fri Nov 20 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14921 : Wizard: Unable to configure external mail accounts if Pub/Sub is disabled
* Thu Nov 19 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14841 : Wizard throws SQL error, Column 'spam_handler' cannot be null
* Thu Nov 19 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14916 : Wizard broken with IE7
