/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Ben Pahne <ben.pahne@open-xchange.com>
 * 
 */


var wizzard;
var wizzardPath = "plugins/com.openexchange.wizard/";
var wizzardTemplate = wizzardPath+"wizard.html";
var wizzardCSS = wizzardPath+"wizard.css";
var wizzardConfig = wizzardPath+"config.js";
var wizzardImages = "../../"+wizzardPath+"images/";

function getAccountName(name) {
    return String(name).replace(/@.*$/, "").
        replace(/[\t\n\f\r!"#$%&'()*+,.\/:;<=>?@\[\\\]^`{|}~]/, " ");
}

/**
 * ******************************* FACEBOOK MINITAB
 * 
 */

function MiniTabFacebook(){
	this.name = "facebook";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"facebook_mini_d.png")});
	this.node = null;
	this.fields = [ "wizzard.facebook.user", "wizzard.facebook.pass", "wizzard.facebook.save" ];
	
	this.draw = function () {
		
		reDrawImageGrid();
		
		var image = this.image;
		
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);
		
		if (this.node == null){
		

			var ctable2 = newnode('table',{ minHeight: "5em", borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"facebook_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ document.createTextNode(_("Subscribe to a Facebook account. Your facebook contacts will be synchronized into a newly created folder and will be kept up to date.")) ])]));				
			ctable2.appendChild(ctbody2);
			
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');				
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [document.createTextNode(_("Username"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.facebook.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.facebook.pass" })])]));			

			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.facebook.save", id:"wizzard.facebook.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.facebook.save").disabled == false){
					Self.saveData();
				}
			});
			ctable.appendChild(ctbody);

			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("facebook_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"facebook_mini_o.png");
	}
	this.saveData = function (){
		var fields = this.fields;
		var validError  = false;
		var image = this.image;
		setWizardFieldsDisabled(fields, true);		
		if (document.getElementById("wizzard.facebook.user").value == "" || document.getElementById("wizzard.facebook.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {			
			body.style.cursor="wait";					
			var parentFolder;
			oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
				parentFolder = checkfolder;					         			            
				var data = { "title": "Facebook "+ document.getElementById("wizzard.facebook.user").value,
				   		"module":"contacts",	
				   		"permissions": [{ bits: 403710016, // all admin
				   		                  entity: configGetKey("identifier"),
				   		                  group: false }],
				   		"subscribed":1 }
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
	    				var moreData = {"source":"com.openexchange.subscribe.crawler.facebook",
	    								"folder":reply.data,
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data},"com.openexchange.subscribe.crawler.facebook":{"login": document.getElementById("wizzard.facebook.user").value,"password": document.getElementById("wizzard.facebook.pass").value}}		    				
	    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
				    			function(reply) {
				    				drawError(_("Loading Data. This may take a while."));
	    							ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
							    			function(reply) {
				    							body.style.cursor="default";
							    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
							    				image.src= getFullImgSrc(wizzardImages+"facebook_mini_ok.png");							    				
							    				if (oMainFolderTree){
							    					oMainFolderTree.update();
							    				}			 				    					
							    			},
						                    function(reply) {
							    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
							    				body.style.cursor="default";
							    				setWizardFieldsDisabled(fields, false);
							    				wizDeleteFolder(fid, timestamp);							    				
						                    	return true;
						                    });
				    			},
			                    function(reply) {
				    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);				    				
			                    	return true;
			                    });	
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			});				
		}		
	}
}

/**
 * ******************************* TONLINE MINITAB
 * 
 */

function MiniTabTOnline(withSub){
	this.name = "tonline";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"tonline_mini_d.png")});
	this.node = null;
	this.withSub = withSub ? withSub : false;
	this.fields = [ "wizzard.tonline.user", "wizzard.tonline.pass", "wizzard.tonline.save" ];
	
	this.draw = function () {
		reDrawImageGrid();
		var image = this.image;
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);

		if (this.node == null){

			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');
			
			//#. %1$s is the product name
			
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"tonline_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a T-Online account and use your T-Online E-Mails with %1$s."), oxProductInfo.product_name)) ])])); 				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0", cellspacing:"0"});
			var ctbody = newnode('tbody');	
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap",paddingTop: "10px"} , 0, [document.createTextNode(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.tonline.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.tonline.pass" })])]));

			//var testcon = wizButton(newnode("input", { marginTop: "5px",marginRight: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: "wizzard.tonline.test", id:"wizzard.tonline.test", value: _("Test connection") }));
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", id:"wizzard.tonline.save", name:"wizzard.tonline.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.tonline.save").disabled == false){
					Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
				}	
			});
			
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("tonline_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"tonline_mini_o.png");
	}
	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.tonline.user").value == "" || document.getElementById("wizzard.tonline.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
	    	ox.JSON.put(AjaxRoot + "/account?action=validate&session=" + session, data, 
	    			function(reply) {	    				
	    				//drawError(reply.data ? _("The connection was successfully tested. You can now save this service.") : _("Connection failed. Please check your settings."));
	    				if (callback) callback();
        				body.style.cursor="default";		        				
	    			},
                    function(reply) {
	    				drawError(_("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
		}	
	}
	this.saveData = function (data){		
		var image = this.image;	
		var fields = this.fields;
		if (document.getElementById("wizzard.tonline.user").value == "" || document.getElementById("wizzard.tonline.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		
														
			ox.JSON.put(AjaxRoot + "/account?action=new&session=" + session, data, 
    			function(reply) {
    				drawError(reply.data ? _("The T-Online E-Mail account has been subscribed successfully.") : _("Connection failed. Please check your settings."));
    				body.style.cursor="default";
    				image.src= getFullImgSrc(wizzardImages+"tonline_mini_ok.png");
    				triggerEvent("OX_Refresh");
                    if (mail_accounts) {
                        reply.data.pop3_expunge_on_quit =
                            !reply.data.pop3_expunge_on_quit;
                        mail_accounts.append([reply.data]);
                    }
    			},
                function(reply) {
    				drawError(reply.error ? ((reply.error == "Found two mail accounts with same email address %1$s for user %2$s in context %3$s.") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Connection failed. Please check your settings."));
    				body.style.cursor="default";
    				setWizardFieldsDisabled(fields, false);
                	return true;
                });
		}		
	}
	this.getData = function (){
        var name = document.getElementById("wizzard.tonline.user").value;
		var data = {
                "name": "T-Online Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.tonline.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.tonline.user").value,
				"password": document.getElementById("wizzard.tonline.pass").value,
				"transport_secure":true,
				"transport_server": wizard_tonline_transport_service,
				"transport_port": wizard_tonline_transport_service_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"					
			}					

			data["personal"]=document.getElementById("wizzard.tonline.user").value;
			data["mail_protocol"]="pop3";
			data["mail_server"]=wizard_tonline_pop_server;
			data["mail_port"]=wizard_tonline_pop_port;
			data["pop3_refresh_rate"]="3";
			data["pop3_expunge_on_quit"]=false;
			data["pop3_delete_write_through"]=false;
			data["pop3_storage"] = "mailaccount";
			
		
		return data;
	}
}

/**
 * ******************************* MSN MINITAB
 * 
 */

function MiniTabMSN(withSub){	
	this.name = "msn";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"msn_mini_d.png")});
	this.node = null;
	this.withSub = withSub ? withSub : false;
	this.fields = [ "wizzard.msn.user", "wizzard.msn.pass", "wizzard.msn.save" ];
	
	this.draw = function () {
		reDrawImageGrid();
		var image = this.image;
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);

		if (this.node == null){

			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');
			
			//#. %1$s is the product name
			
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"msn_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a MSN account and use your MSN E-Mails with %1$s."), oxProductInfo.product_name)) ])])); 				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0", cellspacing:"0"});
			var ctbody = newnode('tbody');	
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap",paddingTop: "10px"} , 0, [document.createTextNode(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.msn.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.msn.pass" })])]));
			/*
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "15px"} , 0, [document.createTextNode(_("Type of connection"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px"}, { type:"radio", className:"noBorderRadio", id:"wizzard.msn.connection:1", name:"wizzard.gmx.connection",value:"imap", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("Imap")) ])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.msn.connection:2", name:"wizzard.gmx.connection", value:"pop" }), document.createTextNode(_("POP3")) ])]));			
			
			*/
			//var testcon = wizButton(newnode("input", { marginTop: "5px",marginRight: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: "wizzard.msn.test", id:"wizzard.msn.test", value: _("Test connection") }));
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", id:"wizzard.msn.save", name:"wizzard.msn.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.msn.save").disabled == false){
					Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
				}	
			});
			
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("msn_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"msn_mini_o.png");
	}
	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.msn.user").value == "" || document.getElementById("wizzard.msn.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {			
			body.style.cursor="wait";
	    	ox.JSON.put(AjaxRoot + "/account?action=validate&session=" + session, data, 
	    			function(reply) {	    				
	    				//drawError(reply.data ? _("The connection was successfully tested. You can now save this service.") : _("Connection failed. Please check your settings."));
	    				if (callback) callback();
        				body.style.cursor="default";	
	    			},
                    function(reply) {
	    				drawError(_("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
		}	
	}
	this.saveData = function (data){	
		var image = this.image;	
		var fields = this.fields;
		if (document.getElementById("wizzard.msn.user").value == "" || document.getElementById("wizzard.msn.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {			
			body.style.cursor="wait";		
			ox.JSON.put(AjaxRoot + "/account?action=new&session=" + session, data, 
    			function(reply) {				
    				drawError(reply.data ? _("The MSN E-Mail account has been subscribed successfully.") : _("Connection failed. Please check your settings."));
    				body.style.cursor="default";
    				image.src= getFullImgSrc(wizzardImages+"msn_mini_ok.png");
    				triggerEvent("OX_Refresh");
                    if (mail_accounts) {
                        reply.data.pop3_expunge_on_quit =
                            !reply.data.pop3_expunge_on_quit;
                        mail_accounts.append([reply.data]);
                    }
    			},
                function(reply) {
    				drawError(reply.error ? ((reply.error == "Found two mail accounts with same email address %1$s for user %2$s in context %3$s.") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Connection failed. Please check your settings."));
    				body.style.cursor="default";
    				setWizardFieldsDisabled(fields, false);
                	return true;
                });
		}		
	}
	this.getData = function (){
        var name = document.getElementById("wizzard.msn.user").value;
		var data = {
                "name": "MSN Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.msn.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.msn.user").value,
				"password": document.getElementById("wizzard.msn.pass").value,
				"transport_secure":true,
				"transport_server": wizard_gmx_transport_service,
				"transport_port": wizard_gmx_transport_service_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"					
			}					

			data["personal"]=document.getElementById("wizzard.msn.user").value;
			data["mail_protocol"]="pop3";
			data["mail_server"]=wizard_msn_pop_server;
			data["mail_port"]=wizard_msn_pop_port;
			data["pop3_refresh_rate"]="3";
			data["pop3_expunge_on_quit"]=false;
			data["pop3_delete_write_through"]=false;
			data["pop3_storage"] = "mailaccount";
			
		return data;
	}
}

/**
 * ******************************* GMX MINITAB
 * 
 */

function MiniTabGMX(withSub){
	this.name = "gmx";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"gmx_mini_d.png")});
	this.node = null;
	this.withSub = withSub ? withSub : false;
	this.fields = [ "wizzard.gmx.user", "wizzard.gmx.pass", "wizzard.gmx.connection:1", "wizzard.gmx.connection:2",
	                "wizzard.gmx.import:1", "wizzard.gmx.import:2", "wizzard.gmx.import:3", "wizzard.gmx.save"];
	
	/*
	this.imap_server = "imap.gmx.com";
	this.imap_port = "993";

	this.smtp_server = "mail.gmx.com";
	this.smtp_port = "465"; // or 587
	
	this.pop3_server = "pop.gmx.com";
	this.pop3_port = "995";
	*/
	
	this.draw = function () {
		reDrawImageGrid();
		var image = this.image;
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);

		if (this.node == null){

			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');
			
			//#. %1$s is the product name
			
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"gmx_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a GMX account and use your GMX E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])])); 				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0", cellspacing:"0"});
			var ctbody = newnode('tbody');	
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap",paddingTop: "10px"} , 0, [document.createTextNode(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.gmx.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.gmx.pass" })])]));
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "15px"} , 0, [document.createTextNode(_("Type of connection"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px"}, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.connection:1", name:"wizzard.gmx.connection",value:"imap", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("Imap")) ])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.connection:2", name:"wizzard.gmx.connection", value:"pop" }), document.createTextNode(_("POP3")) ])]));			
			
			if (this.withSub == false){
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:1", name:"wizzard.gmx.import", value:"mailsandcontacts", disabled:"true" }), document.createTextNode(_("E-Mails and contacts")) ])]));			
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:2", name:"wizzard.gmx.import", value:"mails", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails only")) ])]));			
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:3", name:"wizzard.gmx.import", value:"contacts", disabled:"true" }), document.createTextNode(_("Contacts only")) ])]));
			} else {
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:1", name:"wizzard.gmx.import", value:"mailsandcontacts", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails and contacts")) ])]));			
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:2", name:"wizzard.gmx.import", value:"mails" }), document.createTextNode(_("E-Mails only")) ])]));			
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:3", name:"wizzard.gmx.import", value:"contacts" }), document.createTextNode(_("Contacts only")) ])]));
			}

			
			//var testcon = wizButton(newnode("input", { marginTop: "5px",marginRight: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: "wizzard.gmx.test", id:"wizzard.gmx.test", value: _("Test connection") }));
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.gmx.save", id:"wizzard.gmx.save" , value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.gmx.save").disabled == false){
					Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); }); 
				}	
			});
			
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("gmx_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"gmx_mini_o.png");
	}
	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.gmx.user").value == "" || document.getElementById("wizzard.gmx.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
	    	ox.JSON.put(AjaxRoot + "/account?action=validate&session=" + session, data, 
	    			function(reply) {	    				
	    				//drawError(reply.data ? _("The connection was successfully tested. You can now save this service.") : _("Connection failed. Please check your settings."));
	    				if (callback) callback();
        				body.style.cursor="default";		        				
	    			},
                    function(reply) {
	    				drawError(_("Connection failed. Please check your settings."));	    				
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
		}	
	}
	this.saveData = function (data){
		var image = this.image;
		var fields = this.fields;
		if (document.getElementById("wizzard.gmx.user").value == "" || document.getElementById("wizzard.gmx.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		
		
			function callMeBack (aid){
				var title = "GMX "+ document.getElementById("wizzard.gmx.user").value;
				var parentFolder;
				oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
					parentFolder = checkfolder;					         			            
					var data = { "title": "GMX "+ document.getElementById("wizzard.gmx.user").value,
					   		"module":"contacts",	
	                        "permissions": [{ bits: 403710016, // all admin
                                              entity: configGetKey("identifier"),
                                              group: false }],
					   		"subscribed":1 }
					ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
		    			function(reply) {
							var timestamp = reply.timestamp;
							var fid = reply.data;
		    				var moreData = {"source":"com.openexchange.subscribe.crawler.gmx",
		    								"folder":reply.data,
		    								"entityModule":"contacts",
		    								"entity": {"folder":reply.data},"com.openexchange.subscribe.crawler.gmx":{"login": document.getElementById("wizzard.gmx.user").value,"password": document.getElementById("wizzard.gmx.pass").value}}		    				
		    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
					    			function(reply) {	    				
					    				drawError(_("Loading Data. This may take a while."));
		    							ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
								    			function(reply) {
								    				body.style.cursor="default";
								    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
								    				image.src= getFullImgSrc(wizzardImages+"gmx_mini_ok.png");

								    				if (oMainFolderTree){
								    					oMainFolderTree.update();
								    				}			 				    					
								    			},
							                    function(reply) {
								    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
								    				body.style.cursor="default";
								    				setWizardFieldsDisabled(fields, false);
								    				wizDeleteFolder(fid, timestamp);
								    				wizDeleteMailAccount(aid);
							                    	return true;
							                    });					    				
					    			},
				                    function(reply) {
					    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });	
		    			},
	                    function(reply) {
		    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
		    				body.style.cursor="default";
		    				setWizardFieldsDisabled(fields, false);
	                    	return true;
	                    });	
				});
			}
			
			
			if (document.getElementById("wizzard.gmx.import:1").checked || document.getElementById("wizzard.gmx.import:2").checked){						
				ox.JSON.put(AjaxRoot + "/account?action=new&session=" + session, data, 
	    			function(reply) {
	    				drawError(reply.data ? _("The GMX E-Mail account has been subscribed successfully.") : _("Connection failed. Please check your settings."));
        				body.style.cursor="default";
        				triggerEvent("OX_Refresh");
                        if (mail_accounts) {
                            reply.data.pop3_expunge_on_quit =
                                !reply.data.pop3_expunge_on_quit;
                            mail_accounts.append([reply.data]);
                        }
        				if (document.getElementById("wizzard.gmx.import:1").checked){
        					callMeBack(reply.data.id);
        				}
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "Found two mail accounts with same email address %1$s for user %2$s in context %3$s.") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
	    	} else if (document.getElementById("wizzard.gmx.import:3").checked){
	    		callMeBack();
	    	}

	    	
		}		
	}
	this.getData = function (){
        var name = document.getElementById("wizzard.gmx.user").value;
		var data = {
                "name": "GMX Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.gmx.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.gmx.user").value,
				"password": document.getElementById("wizzard.gmx.pass").value,
				"transport_secure":true,
				"transport_server": wizard_gmx_transport_service,
				"transport_port": wizard_gmx_transport_service_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"					
			}					
			if (document.getElementById("wizzard.gmx.connection:1").checked) {
				data["mail_protocol"]="imap";
				data["mail_server"]=wizard_gmx_imap_server;
				data["mail_port"]=wizard_gmx_imap_port;
			} else {
				data["personal"]=document.getElementById("wizzard.gmx.user").value;
				data["mail_protocol"]="pop3";
				data["mail_server"]=wizard_gmx_pop_server;
				data["mail_port"]=wizard_gmx_pop_port;
				data["pop3_refresh_rate"]="3";
				data["pop3_expunge_on_quit"]=false;
				data["pop3_delete_write_through"]=false;
				data["pop3_storage"] = "mailaccount";
			}
		
		return data;
	}
}

/**
 * ******************************* GMAIL MINITAB
 * 
 */

function MiniTabGmail(withSub){
	this.name = "gmail";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"gmail_mini_d.png")});
	this.node = null;
	this.withSub = withSub;
	this.fields = [ "wizzard.gmail.user", "wizzard.gmail.pass", "wizzard.gmail.connection:1", "wizzard.gmail.connection:2",
	               "wizzard.gmail.import:1", "wizzard.gmail.import:2", "wizzard.gmail.import:3", "wizzard.gmail.save" ];
	
	/*
	this.imap_server = "imap.gmail.com";
	this.imap_port = "993";

	this.smtp_server = "smtp.gmail.com";
	this.smtp_port = "465"; // or 587
	
	this.pop3_server = "pop.gmail.com";
	this.pop3_port = "995";
	*/
	
	this.draw = function () {
		reDrawImageGrid();	
		var image = this.image;
		var base = document.getElementById("wizzardServicesTank");			
		removeChildNodes(base);
		
		if (this.node == null){
		
			//#. %1$s is the product name
			
			var ctable2 = newnode('table', { borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px" } , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"gmail_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Google E-Mail account and use your Google E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [document.createTextNode(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.gmail.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.gmail.pass" })])]));			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Type of connection"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.connection:1", name:"wizzard.gmail.connection", value:"imap", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("Imap")) ])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [  newnode("td", { paddingTop: "5px"} , 0),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.connection:2", name:"wizzard.gmail.connection", value:"pop" }), document.createTextNode(_("POP3")) ])]));	
			
			if (this.withSub == false){
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.import:1", name:"wizzard.gmail.import", value:"mailsandcontacts", disabled:"true" }), document.createTextNode(_("E-Mails and contacts")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.import:2", name:"wizzard.gmail.import", value:"mails", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails only")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.import:3", name:"wizzard.gmail.import", value:"contacts", disabled:"true" }), document.createTextNode(_("Contacts only")) ])]));
			} else {
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.import:1", name:"wizzard.gmail.import", value:"mailsandcontacts", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails and contacts")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.import:2", name:"wizzard.gmail.import", value:"mails" }), document.createTextNode(_("E-Mails only")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.import:3", name:"wizzard.gmail.import", value:"contacts" }), document.createTextNode(_("Contacts only")) ])]));
			}
			
			//var testcon = wizButton(newnode("input", { marginTop: "5px",marginRight: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: "wizzard.gmail.test", id:"wizzard.gmail.test", value: _("Test connection") }));
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", id:"wizzard.gmail.save", name:"wizzard.gmail.save", value: _("Save") }));	
			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.gmail.save").disabled == false){
					Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
				}
			});

			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("gmail_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"gmail_mini_o.png");
	}
	this.getData = function (){
        var name = document.getElementById("wizzard.gmail.user").value;
		var data = {
                "name": "Google Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.gmail.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.gmail.user").value,
				"password": document.getElementById("wizzard.gmail.pass").value,
				"transport_secure":true,
				"transport_server":wizard_gmail_transport_service,
				"transport_port":wizard_gmail_transport_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"
			}					
			if (document.getElementById("wizzard.gmail.connection:1").checked) {
				data["mail_protocol"]="imap";
				data["mail_server"]=wizard_gmail_imap_server;
				data["mail_port"]=wizard_gmail_imap_port;
			} else {
				data["personal"]=document.getElementById("wizzard.gmail.user").value;
				data["mail_protocol"]="pop3";
				data["mail_server"]=wizard_gmail_pop_server;
				data["mail_port"]=wizard_gmail_pop_port;
				data["pop3_refresh_rate"]="3";
				data["pop3_expunge_on_quit"]=false;
				data["pop3_delete_write_through"]=false;	
				data["pop3_storage"] = "mailaccount";
			}
		return data;
	}
	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.gmail.user").value == "" || document.getElementById("wizzard.gmail.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";			
	    	ox.JSON.put(AjaxRoot + "/account?action=validate&session=" + session, data, 
	    			function(reply) {	    				
	    				//drawError(reply.data ? _("The connection was successfully tested. You can now save this service.") : _("Connection failed. Please check your settings."));
	    				if (callback) callback();
        				body.style.cursor="default";		        				
	    			},
                    function(reply) {
	    				drawError(_("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
		}
	}
	this.saveData = function (data){
		var image = this.image;	
		var fields = this.fields;
		if (document.getElementById("wizzard.gmail.user").value == "" || document.getElementById("wizzard.gmail.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			function callMeBack (aid){
				var title = "Google "+ document.getElementById("wizzard.gmail.user").value;				
				var parentFolder;
				oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
					parentFolder = checkfolder;					         			            
					var data = { "title": "Google "+ document.getElementById("wizzard.gmail.user").value,
					   		"module":"contacts",	
	                        "permissions": [{ bits: 403710016, // all admin
                                              entity: configGetKey("identifier"),
                                              group: false }],
					   		"subscribed":1 }
					ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
		    			function(reply) {
							var timestamp = reply.timestamp;
							var fid = reply.data;

		    				var moreData = {"source":"com.openexchange.subscribe.crawler.googlemail",
		    								"folder":reply.data,
		    								"entityModule":"contacts",
		    								"entity": {"folder":reply.data},"com.openexchange.subscribe.crawler.googlemail":{"login": document.getElementById("wizzard.gmail.user").value,"password": document.getElementById("wizzard.gmail.pass").value}}		    				
		    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
					    			function(reply) {
			    						drawError(_("Loading Data. This may take a while."));
			    						ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
						    			
			    						function(reply) {
			    							body.style.cursor="default";
						    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
						    				image.src= getFullImgSrc(wizzardImages+"gmail_mini_ok.png");					    				

						    				if (oMainFolderTree){
						    					oMainFolderTree.update();
						    				}			 				    					
						    			},
					                    function(reply) {
						    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
						    				body.style.cursor="default";
						    				setWizardFieldsDisabled(fields, false);
						    				wizDeleteFolder(fid, timestamp);
						    				wizDeleteMailAccount(aid);
					                    	return true;
					                    });			    					
					    				
					    			},
				                    function(reply) {
					    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });	
		    			},
	                    function(reply) {
		    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
		    				body.style.cursor="default";
		    				setWizardFieldsDisabled(fields, false);
	                    	return true;
	                    });	
				});
			}
			
			
			if (document.getElementById("wizzard.gmail.import:1").checked || document.getElementById("wizzard.gmail.import:2").checked){																
				ox.JSON.put(AjaxRoot + "/account?action=new&session=" + session, data, 
	    			function(reply) {
	    				drawError(reply.data ? _("The Google E-Mail account has been subscribed successfully.") : _("Connection failed. Please check your settings."));
        				body.style.cursor="default";
        				triggerEvent("OX_Refresh");
                        if (mail_accounts) {
                            reply.data.pop3_expunge_on_quit =
                                !reply.data.pop3_expunge_on_quit;
                            mail_accounts.append([reply.data]);
                        }
        				if (document.getElementById("wizzard.gmail.import:1").checked){
        					callMeBack(reply.data.id);
        				}
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "Found two mail accounts with same email address %1$s for user %2$s in context %3$s.") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
	    	} else if (document.getElementById("wizzard.gmail.import:3").checked){
				callMeBack();
			}		    	
		}
	}
}

/**
* ******************************* YAHOO MINITAB
* 
*/

function MiniTabYahoo(withSub){
	this.name = "yahoo";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"yahoo_mini_d.png")});
	this.node = null;
	this.withSub = withSub;
	this.fields = [ "wizzard.yahoo.user", "wizzard.yahoo.pass", "wizzard.yahoo.connection:1", "wizzard.yahoo.connection:2",
	                "wizzard.yahoo.import:1", "wizzard.yahoo.import:2", "wizzard.yahoo.import:3", "wizzard.yahoo.save" ];
	
	/*
	this.smtp_server = "plus.smtp.mail.yahoo.com";
	this.smtp_server = "smtp.mail.yahoo.com";
	this.smtp_port = "465"; // or 587
	
	this.pop3_server = "plus.pop.mail.yahoo.com";	
	this.pop3_server = "pop.mail.yahoo.com";
	this.pop3_port = "995";
	*/
	
	this.draw = function () {
		reDrawImageGrid();
		var image = this.image;
		
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);
		
		if (this.node == null){
		
			//#. %1$s is the product name
			
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"yahoo_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Yahoo account and use your Yahoo E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [document.createTextNode(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.yahoo.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.yahoo.pass" })])]));			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "15px", verticalAlign: "top" } , { rowSpan: 2 }, [document.createTextNode(_("Do you have a Yahoo Plus account?"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.connection:1", name:"wizzard.yahoo.connection", value:"pop", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("No")) ])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	// first td <- rowspan
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.connection:2", name:"wizzard.yahoo.connection", value:"poppro" }), document.createTextNode(_("Yes")) ])]));			

			if (this.withSub == false){
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.import:1", name:"wizzard.yahoo.import", value:"mailsandcontacts", disabled:"true" }), document.createTextNode(_("E-Mails and contacts")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.import:2", name:"wizzard.yahoo.import", value:"mails", value:"mails", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails only")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.import:3", name:"wizzard.yahoo.import", value:"contacts", disabled:"true" }), document.createTextNode(_("Contacts only")) ])]));
			} else {
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.import:1", name:"wizzard.yahoo.import", value:"mailsandcontacts", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails and contacts")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.import:2", name:"wizzard.yahoo.import", value:"mails", value:"mails" }), document.createTextNode(_("E-Mails only")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.import:3", name:"wizzard.yahoo.import", value:"contacts" }), document.createTextNode(_("Contacts only")) ])]));
			}
			//var testcon = wizButton(newnode("input", { marginTop: "5px",marginRight: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: "wizzard.yahoo.test", id:"wizzard.yahoo.test", value: _("Test connection") }));
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.yahoo.save", id:"wizzard.yahoo.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));
			
			var Self = this;
			addDOMEvent(save, "click", function(){
				if (document.getElementById("wizzard.yahoo.save").disabled == false){
					Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
				}
			});	
					
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);	
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("yahoo_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"yahoo_mini_o.png");
	}
	this.getData = function(){
        var name = document.getElementById("wizzard.yahoo.user").value;
		var data = {
                "name": "Yahoo Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.yahoo.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.yahoo.user").value,
				"password": document.getElementById("wizzard.yahoo.pass").value,
				"transport_secure":true,
				"transport_port":wizard_yahoo_transport_service_port,
				"transport_credentials":false,
				"tree":false,				
				"spam_handler":"NoSpamHandler",
				"personal":document.getElementById("wizzard.yahoo.user").value,
				"mail_protocol":"pop3",
				"mail_port":wizard_yahoo_pop_port,
				"pop3_refresh_rate":"3",
				"pop3_expunge_on_quit":false,
				"pop3_delete_write_through":false,
				"pop3_storage":"mailaccount"
			}					
			if (document.getElementById("wizzard.yahoo.connection:2").checked) {
				data["transport_server"]=wizard_yahoo_plus_transport_service;
				data["mail_server"]=wizard_yahoo_plus_pop_server;
			} else {
				data["transport_server"]=wizard_yahoo_transport_service;
				data["mail_server"]=wizard_yahoo_pop_service;						
			}
		return data;
	}
	this.testData = function (data, callback) {
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.yahoo.user").value == "" || document.getElementById("wizzard.yahoo.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";			
	    	ox.JSON.put(AjaxRoot + "/account?action=validate&session=" + session, data, 
	    			function(reply) {	    				
	    				//drawError(reply.data ? _("The connection was successfully tested. You can now save this service.") : _("Connection failed. Please check your settings."));
	    				if (callback) callback();
        				body.style.cursor="default";		        				
	    			},
                    function(reply) {
	    				drawError(_("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
		}	
	}
	this.saveData = function(data) {				
		var validError  = false;
		var fields = this.fields;
		var image = this.image;	
		if (document.getElementById("wizzard.yahoo.user").value == "" || document.getElementById("wizzard.yahoo.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			var aid = 0;
			function callMeBack(aid){
				var parentFolder;
				oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
					parentFolder = checkfolder;					         			            
					var data = { "title": "Yahoo "+ document.getElementById("wizzard.yahoo.user").value,
					   		"module":"contacts",	
	                        "permissions": [{ bits: 403710016, // all admin
                                              entity: configGetKey("identifier"),
                                              group: false }],
					   		"subscribed":1 }
					ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
		    			function(reply) {		    				
							var timestamp = reply.timestamp;
							var fid = reply.data;
							var moreData = {"source":"com.openexchange.subscribe.crawler.yahoocom",
		    								"folder":fid,
		    								"entityModule":"contacts",
		    								"entity": {"folder":fid},"com.openexchange.subscribe.crawler.yahoocom":{"login": document.getElementById("wizzard.yahoo.user").value,"password": document.getElementById("wizzard.yahoo.pass").value}}		    				
		    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
					    			function(reply) {	    					    					
					    				drawError(_("Loading Data. This may take a while."));
										ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
								    			function(reply) {
								    				body.style.cursor="default";
								    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
								    				image.src= getFullImgSrc(wizzardImages+"yahoo_mini_ok.png");
								    				
								    				if (oMainFolderTree){
								    					oMainFolderTree.update();
								    				}			 				    					
								    			},
							                    function(reply) {
								    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
								    				body.style.cursor="default";
								    				setWizardFieldsDisabled(fields, false);
								    				wizDeleteFolder(fid, timestamp);
								    				wizDeleteMailAccount(aid);
							                    	return true;
							                    });		    						    					
					    			},
				                    function(reply) {
					    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });	
		    			},
	                    function(reply) {
		    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
		    				body.style.cursor="default";
		    				setWizardFieldsDisabled(fields, false);
	                    	return true;
	                    });	
				});
			}
			
			if (document.getElementById("wizzard.yahoo.import:1").checked || document.getElementById("wizzard.yahoo.import:2").checked){						
				ox.JSON.put(AjaxRoot + "/account?action=new&session=" + session, data, 
	    			function(reply) {
	    				drawError(reply.data ? _("The Yahoo E-Mail service has been saved successfully.") : _("Connection failed. Please check your settings."));
        				body.style.cursor="default";
        				triggerEvent("OX_Refresh");
                        if (mail_accounts) {
                            reply.data.pop3_expunge_on_quit =
                                !reply.data.pop3_expunge_on_quit;
                            mail_accounts.append([reply.data]);
                        }
        				if (document.getElementById("wizzard.yahoo.import:1").checked){
        					callMeBack(reply.data.id);
        				}
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "Found two mail accounts with same email address %1$s for user %2$s in context %3$s.") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
	    				validError = true;
                    	return true;
                    });
	    	} else if (document.getElementById("wizzard.yahoo.import:3").checked){
				callMeBack();
			}		    	
		}
	}
}

/**
* ******************************* WEBDE MINITAB
* 
*/

function MiniTabWebde(withSub){
	this.name = "webde";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"webde_mini_d.png")});
	this.node = null;
	this.withSub = withSub;
	this.fields = [ "wizzard.webde.user", "wizzard.webde.pass", "wizzard.webde.connection:1", "wizzard.webde.connection:2",
	                "wizzard.webde.import:1", "wizzard.webde.import:2", "wizzard.webde.import:3", "wizzard.webde.save"];
	
	/*
	this.imap_server = "imap.webde.com";
	this.imap_port = "993";

	this.smtp_server = "mail.webde.com";
	this.smtp_port = "465"; // or 587
	
	this.pop3_server = "pop.webde.com";
	this.pop3_port = "995";
	*/
	
	this.draw = function () {
		reDrawImageGrid();
		var image = this.image;	
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);
		
		if (this.node == null){
		
			//#. %1$s is the product name
			
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"webde_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Web.de account and use your E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [document.createTextNode(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.webde.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.webde.pass" })])]));			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Type of connection"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.connection:1", name:"wizzard.webde.connection", value:"imap", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("Imap")) ])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.connection:2", name:"wizzard.webde.connection", value:"pop" }), document.createTextNode(_("POP3")) ])]));			

			if (this.withSub == false){
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.import:1", name:"wizzard.webde.import", value:"mailsandcontacts", disabled:"true" }), document.createTextNode(_("E-Mails and contacts")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.import:2", name:"wizzard.webde.import", value:"mails", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails only")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.import:3", name:"wizzard.webde.import", value:"contacts", disabled:"true" }), document.createTextNode(_("Contacts only")) ])]));

			} else {
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [document.createTextNode(_("Import"))]),
			                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.import:1", name:"wizzard.webde.import", value:"mailsandcontacts", checked:"true", defaultChecked:"defaultChecked" }), document.createTextNode(_("E-Mails and contacts")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.import:2", name:"wizzard.webde.import", value:"mails" }), document.createTextNode(_("E-Mails only")) ])]));
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
			                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.import:3", name:"wizzard.webde.import", value:"contacts" }), document.createTextNode(_("Contacts only")) ])]));
			}
			//var testcon = wizButton(newnode("input", { marginTop: "5px",marginRight: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: "wizzard.webde.test", id:"wizzard.webde.test", value: _("Test connection") }));
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.webde.save", id:"wizzard.webde.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.webde.save").disabled == false){
					Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
				}
			});

			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);	
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("webde_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"webde_mini_o.png");
	}
	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.webde.user").value == "" || document.getElementById("wizzard.webde.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
	    	ox.JSON.put(AjaxRoot + "/account?action=validate&session=" + session, data, 
	    			function(reply) {	    				
	    				//drawError(reply.data ? _("The connection was successfully tested. You can now save this service.") : _("Connection failed. Please check your settings."));
	    				if (callback) callback();
        				body.style.cursor="default";		        				
	    			},
                    function(reply) {
	    				drawError(_("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });
		}	
	}
	this.saveData = function (data){
		var validError  = false;
		var image = this.image;
		var fields = this.fields;
		if (document.getElementById("wizzard.webde.user").value == "" || document.getElementById("wizzard.webde.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			
			function callMeBack(aid){
				var title = "Web.de "+ document.getElementById("wizzard.webde.user").value;
				
				var parentFolder;
				oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
					parentFolder = checkfolder;					         			            
					var data = { "title": "Web.de "+ document.getElementById("wizzard.webde.user").value,
					   		"module":"contacts",	
	                        "permissions": [{ bits: 403710016, // all admin
                                              entity: configGetKey("identifier"),
                                              group: false }],
					   		"subscribed":1 }
					ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
		    			function(reply) {
							var timestamp = reply.timestamp;
							var fid = reply.data;
		    				var moreData = {"source":"com.openexchange.subscribe.crawler.webde",
		    								"folder":reply.data,
		    								"entityModule":"contacts",
		    								"entity": {"folder":reply.data},"com.openexchange.subscribe.crawler.webde":{"login": document.getElementById("wizzard.webde.user").value,"password": document.getElementById("wizzard.webde.pass").value}}		    				
		    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
					    			function(reply) {
		    					
					    				drawError(_("Loading Data. This may take a while."));
										ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
								    			function(reply) {
								    				body.style.cursor="default";
								    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
								    				image.src= getFullImgSrc(wizzardImages+"webde_mini_ok.png");

								    				if (oMainFolderTree){
								    					oMainFolderTree.update();
								    				}			 				    					
								    			},
							                    function(reply) {
								    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
								    				body.style.cursor="default";
								    				setWizardFieldsDisabled(fields, false);
								    				wizDeleteFolder(fid, timestamp);
								    				wizDeleteMailAccount(aid);
							                    	return true;
							                    });	
					    			},
				                    function(reply) {
					    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });	
		    			},
	                    function(reply) {
		    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
		    				body.style.cursor="default";
		    				setWizardFieldsDisabled(fields, false);
	                    	return true;
	                    });	
				});				
			}
			
			if (document.getElementById("wizzard.webde.import:1").checked || document.getElementById("wizzard.webde.import:2").checked){						
				ox.JSON.put(AjaxRoot + "/account?action=new&session=" + session, data, 
	    			function(reply) {
	    				drawError(reply.data ? _("The Web.de E-Mail service has been saved successfully.") : _("Connection failed. Please check your settings."));
        				body.style.cursor="default";
        				triggerEvent("OX_Refresh");
                        if (mail_accounts) {
                            reply.data.pop3_expunge_on_quit =
                                !reply.data.pop3_expunge_on_quit;
                            mail_accounts.append([reply.data]);
                        }
        				if(document.getElementById("wizzard.webde.import:1").checked ){
        					callMeBack(reply.data.id);
        				}      				
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "Found two mail accounts with same email address %1$s for user %2$s in context %3$s.") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Connection failed. Please check your settings."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
	    				validError = true;
                    	return true;
                    });
	    	}else if(document.getElementById("wizzard.webde.import:3").checked ){
				callMeBack();
			} 
		}		
	}
	this.getData = function (){
        var name = document.getElementById("wizzard.webde.user").value;
		var data = {
                "name": "Web de Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.webde.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.webde.user").value,
				"password": document.getElementById("wizzard.webde.pass").value,				
				"transport_secure":false,
				"transport_server":wizard_webde_transport_service,
				"transport_port":wizard_webde_transport_service_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"								
			}					
			if (document.getElementById("wizzard.webde.connection:1").checked) {
				data["mail_protocol"]="imap";
				data["mail_server"]=wizard_webde_imap_server;
				data["mail_port"]=wizard_webde_imap_port;
			} else {
				data["personal"]=document.getElementById("wizzard.webde.user").value;
				data["mail_protocol"]="pop3";
				data["mail_server"]=wizard_webde_pop_server;
				data["mail_port"]=wizard_webde_pop_port;
				data["pop3_refresh_rate"]="15";
				data["pop3_expunge_on_quit"]=false;
				data["pop3_delete_write_through"]=false;	
				data["pop3_storage"] = "mailaccount";
			}
		
		return data;
	}
}

/**
* ******************************* LINKEDIN MINITAB
* 
*/

function MiniTabLinkedin(){
	this.name = "linkedin";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"linkedin_mini_d.png")});
	this.node = null;
	this.fields = [ "wizzard.linkedin.user", "wizzard.linkedin.pass", "wizzard.linkedin.save" ]
	
	this.draw = function () {
		
		reDrawImageGrid();
		
		var image = this.image;
		
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);
		
		if (this.node == null){
		
			//#. %1$s is the product name
			
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"linkedin_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Linkedin account and use your Linkedin contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [document.createTextNode(_("Username"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.linkedin.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.linkedin.pass" })])]));			

			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", id:"wizzard.linkedin.save", name:"wizzard.linkedin.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.linkedin.save").disabled == false){
					Self.saveData();
				}
			});
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);	
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("linkedin_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"linkedin_mini_o.png");
	}
	this.saveData = function (){
		var validError  = false;
		var image = this.image;
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		
		if (document.getElementById("wizzard.linkedin.user").value == "" || document.getElementById("wizzard.linkedin.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		

			var title = "Linkedin "+ document.getElementById("wizzard.linkedin.user").value;
			
			var parentFolder;
			oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
				parentFolder = checkfolder;					         			            
				var data = { "title": "Linkedin "+ document.getElementById("wizzard.linkedin.user").value,
				   		"module":"contacts",	
                        "permissions": [{ bits: 403710016, // all admin
                                          entity: configGetKey("identifier"),
                                          group: false }],
				   		"subscribed":1 }
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
						var moreData = {"source":"com.openexchange.subscribe.linkedin",
	    								"folder":reply.data,
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data},"com.openexchange.subscribe.linkedin":{"login": document.getElementById("wizzard.linkedin.user").value,"password": document.getElementById("wizzard.linkedin.pass").value}}		    				
	    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
				    			function(reply) {
		    						drawError(_("Loading Data. This may take a while."));
		    						ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
					    			
		    						function(reply) {
		    							body.style.cursor="default";
					    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
					    				image.src= getFullImgSrc(wizzardImages+"linkedin_mini_ok.png");
					    				
					    				document.getElementById("wizzard.linkedin.save").disabled = true;

					    				if (oMainFolderTree){
					    					oMainFolderTree.update();
					    				}			 				    					
					    			},
				                    function(reply) {
					    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });		    							
				    			},
			                    function(reply) {
				    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);			                    	
				    				return true;
			                    });	
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			});				
		}		
	}
}

/**
* ******************************* XING MINITAB
* 
*/

function MiniTabXing(){
	this.name = "xing";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"xing_mini_d.png")});
	this.node = null;
	this.fields = [ "wizzard.xing.user", "wizzard.xing.pass", "wizzard.xing.save" ];
	
	this.draw = function () {
		
		reDrawImageGrid();
		
		var image = this.image;
		
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);
		
		if (this.node == null){
		
			//#. %1$s is the product name
			
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"xing_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Xing account and use your Xing contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [document.createTextNode(_("Username"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.xing.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [document.createTextNode(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.xing.pass" })])]));			

			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.xing.save", id:"wizzard.xing.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.xing.save").disabled == false){
					Self.saveData();
				}
			});
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);	
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("xing_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"xing_mini_o.png");
	}
	this.saveData = function (){
		var validError  = false;
		var image = this.image;
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		
		if (document.getElementById("wizzard.xing.user").value == "" || document.getElementById("wizzard.xing.pass").value == ""){
			drawError(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		
			var title = "Xing "+ document.getElementById("wizzard.xing.user").value;			
			var parentFolder;
			oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
				parentFolder = checkfolder;					         			            
				var data = { "title": "Xing "+ document.getElementById("wizzard.xing.user").value,
				   		"module":"contacts",	
                        "permissions": [{ bits: 403710016, // all admin
                                          entity: configGetKey("identifier"),
                                          group: false }],
				   		"subscribed":1 }
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
						var moreData = {"source":"com.openexchange.subscribe.xing",
	    								"folder":reply.data,
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data},"com.openexchange.subscribe.xing":{"login": document.getElementById("wizzard.xing.user").value,"password": document.getElementById("wizzard.xing.pass").value}}		    				
	    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
				    			function(reply) {
		    						drawError(_("Loading Data. This may take a while."));
		    						ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
					    			
		    						function(reply) {
		    							body.style.cursor="default";
					    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
					    				image.src= getFullImgSrc(wizzardImages+"xing_mini_ok.png");
					    				
					    				document.getElementById("wizzard.xing.save").disabled = true;
					    				
					    				if (oMainFolderTree){
					    					oMainFolderTree.update();
					    				}			 				    					
					    			},
				                    function(reply) {
					    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });		    								
				    			},
			                    function(reply) {
				    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);
			                    	return true;
			                    });
						
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			});				
		}		
	}
}

/**
* ******************************* OXMF MINITAB
* 
*/

function MiniTabOXMF(){
	this.name = "oxmf";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"oxmf_mini_d.png")});
	this.node = null;
	this.fields = [ "wizzard.oxmf.url", "wizzard.oxmf.save" ];
	
	this.draw = function () {
		
		reDrawImageGrid();
		
		var image = this.image;
		
		var base = document.getElementById("wizzardServicesTank");		
		removeChildNodes(base);
		
		if (this.node == null){
		
			//#. %1$s is the product name
			
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {src: getFullImgSrc(wizzardImages+"oxmf_mini_d.png")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to another %1$s publication. The contacts of this publication will be saved to a new %1$s folder."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [
			    newnode("td", { whiteSpace:"nowrap", paddingTop: "10px"} , 0, [document.createTextNode(_("URL"))]),
		        newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.oxmf.url" })])]));
			
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.oxmf.save", id:"wizzard.oxmf.save", value: _("Save") }));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"}, 0, [ save])]));

			var Self = this;
			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.oxmf.save").disabled == false){
					Self.saveData();
				}
			});

			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);		
		if (image.src.lastIndexOf("oxmf_mini_ok.png") == -1)
			image.src= getFullImgSrc(wizzardImages+"oxmf_mini_o.png");
	}
	this.saveData = function (){
		var validError  = false;
		var image = this.image;
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		var url = document.getElementById("wizzard.oxmf.url").value;
		if (url == ""){
			drawError(_("Provide a valid URL address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		
			
			var title = url.substr(0,url.lastIndexOf("?"));
			title = "OXMF " + title.substr(title.lastIndexOf("/")+1);
			
			var parentFolder;
			oMainFolderTree.cache.get_folder(getUrlEncodedString(configGetKey("folder.contacts")),function (checkfolder){
				parentFolder = checkfolder;					         			            
				var data = { "title": title,
				   		"module":"contacts",	
                        "permissions": [{ bits: 403710016, // all admin
                                          entity: configGetKey("identifier"),
                                          group: false }],
				   		"subscribed":1 }
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
						var moreData = {"source":"com.openexchange.subscribe.microformats.contacts.http",
	    								"folder":reply.data,
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data},
	    								"com.openexchange.subscribe.microformats.contacts.http":{"url": url}}		    				
	    				
						ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
				    			function(reply) {
		    						drawError(_("Loading Data. This may take a while."));
		    						ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
					    			
		    						function(reply) {
										body.style.cursor="default";
					    				drawError(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
					    				image.src= getFullImgSrc(wizzardImages+"oxmf_mini_ok.png");
					    				
					    				document.getElementById("wizzard.oxmf.save").disabled = true;

					    				if (oMainFolderTree){
					    					oMainFolderTree.update();
					    				}		 				    					
					    			},
				                    function(reply) {
					    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });
				    			},
			                    function(reply) {
				    				drawError(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);
			                    	return true;
			                    });	
	    			},
                    function(reply) {
	    				drawError(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			});				
		}		
	}
}

function WiztabWelcome() {
	this.name = "welcome";	
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.headerImage = newnode("img", {padding: "5px", paddingBottom:"25px" }, {id: "wizzardStartImage", src: getFullImgSrc(wizzardImages+"start_a.png")});
	this.draw = function (wizzard) {
		
		var image = document.getElementById("wizzardStartImage");		
		image.src= getFullImgSrc(wizzardImages+"start_a.png");
		
		//#. %1$s is the product name
        var title = $("popup.wizzard.header").getElementsByTagName("span")[0];
        removeChildNodes(title);
        if (!this.title) {
            this.title = addTranslated(format(
                _("%1$s Wizard"), oxProductInfo.product_name));
        }
        title.appendChild(this.title);
		
		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(document.createTextNode(_("Instructions")));

		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
		//#. %1$s is the product name
		base.appendChild( newnode("div",{fontSize:"130%", fontWeight:"bold",paddingTop:"15px"},0,[ addTranslated(format(_("Welcome to %1$s."), oxProductInfo.product_name))] ));
		base.appendChild(newnode("br"));
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "0px"} , {colSpan:2}, [ document.createTextNode(_("This wizard will guide you through some basic settings around your account. You can access this wizard later by clicking on the respective entry in the help menu. Click Start if you want to start the wizard now. Click Cancel if you want to make the settings later.")) ])
        ]));
				
		var order = wizzard.getWizorder();		
		for (var cnt=0;cnt <order.length;cnt++){
			var tab = wizzard.getWiztabAtPosition(order[cnt]);
			if (tab.visible == true && tab.welcome_node != null){
				ctbody.appendChild(tab.welcome_node);
			}
		}
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "10px"} , {colSpan:2}, [ document.createTextNode(_("Press the start button to launch the wizard.")) ])
        ]));
		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		// back (disbaled)
		$("popup.wizzard.back").disabled = true;		
		$("popup.wizzard.back").style.display="none";
		// next = start
		$("popup.wizzard.next").value = _("Start");
		$("popup.wizzard.next").style.display="inline";
		// cancel
		$("popup.wizzard.closebutton").value = _("Close");

	}
	this.next = function (callback) {
		
		var image = document.getElementById("wizzardStartImage");		
		image.src= getFullImgSrc(wizzardImages+"start.png");
		
		$("popup.wizzard.back").disabled = false;
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").style.display="inline";
		callback();
	}
	this.previous = function (callback) {
		callback();
	}	
}

function WiztabPersonalData() {
	this.name = "personaldata";
	/* is this tab currently active, shown to the user*/
	this.enabled = false;
	/* is this even visible to the user*/
	this.visible = true;	
	/* the position on the wizzard */
	this.position = 0;
	/* has this tab been saved, is the configuration working*/
	this.errorOccured = false;		
	/* the user data object and the timestamp when we got it*/
	this.old_user_data = null;
	this.dataChanged = false;
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardFacebookImage", src: getFullImgSrc(wizzardImages+"user_d.png")});
	/* the small info node on the welcome page */
	this.welcome_node = newnode("tr", 0 , 0, [
	            		  newnode("td", {paddingTop: "15px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"user_mini.png")}) ]),
	            		  newnode("td", {width:"100%",paddingTop: "15px"} , 0, [ document.createTextNode(_("Complete your account information")) ])]);
	
	this.draw = function (wizzard) {
		
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		
		setWizzardTitle(_("Step 1. Complete your account information"));
		
		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(document.createTextNode(_("Personal Data")));
		
		var image = document.getElementById("wizzardFacebookImage");		
		image.src= getFullImgSrc(wizzardImages+"user_a.png");
		
		this.loadData();

		
	}	
	this.next = function (callback) {
		
		var image = document.getElementById("wizzardFacebookImage");		
		image.src= getFullImgSrc(wizzardImages+"user.png");
		
		if (this.dataChanged) 
			this.saveData(callback);
		else 
			callback();	
	}
	this.previous = function (callback) {
		
		var image = document.getElementById("wizzardFacebookImage");		
		image.src= getFullImgSrc(wizzardImages+"user_d.png");
		
		this.dataChanged = false;		
		callback();
	}
	this.loadData = function(loadOnly) {
        var Self = this;
        ox.JSON.get(AjaxRoot + "/user?action=get&id=" +
            configGetKey("identifier") + "&session=" + session,
            function(reply) {
            	Self.old_user_data = clone(reply.data);
            	Self.old_user_data.timestamp = reply.timestamp;
        		if (!loadOnly) Self.placeData(reply.data);
    		});
	}
	this.placeData = function(pdata){
	   
		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		var Self = this;

		ctbody.appendChild( newnode("tr", 0 , 0, [
             		                             newnode("td", { paddingTop: "20px"} , 0, [document.createTextNode(_("First name"))]),
             		                             newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "first_name", value: (pdata.first_name != undefined) ? pdata.first_name : "" })]),

             		                             newnode("td", { paddingTop: "20px"} , 0, [document.createTextNode(_("Last name"))]),
             		                             newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "last_name", value: (pdata.last_name != undefined) ? pdata.last_name : "" })])
             		                             
             		                             ]));

		ctbody.appendChild( newnode("tr", 0 , 0, [
		                                          	 newnode("td", { paddingTop: "6px"} , 0, [document.createTextNode(_("Middle name"))]),
                     		                     newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "second_name", value: (pdata.second_name != undefined) ? pdata.second_name : "" })]),

             		                             newnode("td", { paddingTop: "6px"} , 0, [document.createTextNode(_("Street"))]),
              		                             newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "street_home", value: (pdata.street_home != undefined) ? pdata.street_home : "" })])

             		                                             		                             
                     		                     ]));
	
		ctbody.appendChild( newnode("tr", 0 , 0, [
		                                          
	             		                             newnode("td", { paddingTop: "6px"} , 0, [document.createTextNode(_("ZIP / City"))]),
	             		                             newnode("td", { paddingTop: "6px"} , 0, [
	             		                                 newnode("input", { width:"4em", marginLeft: "10px", marginRight: "0.5em" }, { type:"text", name: "postal_code_home", value: (pdata.postal_code_home != undefined) ? pdata.postal_code_home : "" }),
	                                                     newnode("input", { width:"9.5em", marginLeft: "-2px" }, { type:"text", name: "city_home", value: (pdata.city_home != undefined) ? pdata.city_home : "" })
	             		                             ]),

	             		                             
	                     		                     newnode("td", { paddingTop: "5px"} , 0, [document.createTextNode(_("State"))]),
	                     		                     newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "state_home", value: (pdata.state_home != undefined) ? pdata.state_home : "" })])

	             		                             
	             		                             ]));

		ctbody.appendChild( newnode("tr", 0 , 0, [
               	                     
	                                              	 newnode("td", { paddingTop: "20px"} , 0, [document.createTextNode(_("Company"))]),
	                         		                 newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "company", value: (pdata.company != undefined) ? pdata.company : "" })]),

	                         		                 
		                                          	 newnode("td", { paddingTop: "20px"} , 0, [document.createTextNode(_("Street (business)"))]),
		                                          	 newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "street_business", value: (pdata.street_business != undefined) ? pdata.street_business : "" })])

	                         		                 
	                     		                     ]));

		ctbody.appendChild( newnode("tr", 0 , 0, [

	             		                             newnode("td", { paddingTop: "6px"} , 0, [document.createTextNode(_("ZIP / City (business)"))]),
	             		                             newnode("td", { paddingTop: "6px"} , 0, [
	             		                                 newnode("input", { width:"4em", marginLeft: "10px", marginRight: "0.5em" }, { type:"text", name: "postal_code_business", value: (pdata.postal_code_business != undefined) ? pdata.postal_code_business : "" }),
	                                                     newnode("input", { width:"9.5em", marginLeft: "-2px" }, { type:"text", name: "city_business", value: (pdata.city_business != undefined) ? pdata.city_business : "" })
	             		                             ]),

	             		                             newnode("td", { paddingTop: "6px"} , 0, [document.createTextNode(_("State (business)"))]),
	                     		                     newnode("td", { paddingTop: "6px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "state_business", value: (pdata.state_business != undefined) ? pdata.state_business : "" })])
          		                                             		                             
		                                          	 ]));

		ctbody.appendChild( newnode("tr", 0 , 0, [
		                                          
	                         		                 newnode("td", { paddingTop: "20px"} , 0, [document.createTextNode(_("Phone (business)"))]),
	                         		                 newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "telephone_business1", value: (pdata.telephone_business1 != undefined) ? pdata.telephone_business1 : "" })]),

                             		             newnode("td", { paddingTop: "20px"} , 0, [document.createTextNode(_("Fax (business)"))]),
                             		             newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "fax_business", value: (pdata.fax_business != undefined) ? pdata.fax_business : "" })])
                             		                             
                             		             ]));	

		ctbody.appendChild( newnode("tr", 0 , 0, [

		                                          	 newnode("td", { paddingTop: "6px"} , 0, [document.createTextNode(_("Phone (private)"))]),
                             		             newnode("td", { paddingTop: "6px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "telephone_home1", value: (pdata.telephone_home1 != undefined) ? pdata.telephone_home1 : "" })]),

                             		             
                                               	 newnode("td", { paddingTop: "6px"} , 0, [document.createTextNode(_("Mobile"))]),
                         		                 newnode("td", { paddingTop: "6px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "cellular_telephone1", value: (pdata.cellular_telephone1 != undefined) ? pdata.cellular_telephone1 : "" })])

                         		                 
                         		                 ]));				
			
//		var save_button = wizButton(newnode("input", 0 , { className: "wizzardBlankButton", type:"button", name: "wizzard.personaldata.save", value: _("Save information") }));
//		ctbody.appendChild( newnode("tr", 0 , 0, [
//	                             		         newnode("td", { textAlign:"right", paddingTop: "20px"} , {colSpan: 4} , [save_button])
//	                             		                             
//	                             		         ]));	
//		
//		
//		addDOMEvent(save_button, "click", function() { Self.saveData(); });
				
		ctable.appendChild(ctbody);
		
		// adding change event to input field
		var inElems = ctbody.getElementsByTagName("input");
		for (var i in inElems) {
			inElems[i].onchange = function() { 
				Self.dataChanged = true; 
			}
		}		
		
		base.appendChild(ctable);
	    base.appendChild(newnode("div", {height: "20px"}, 0));		

	} 
	this.saveData = function (callback) {
		var base = document.getElementById("wizzardConten");		
		var ba = base.getElementsByTagName("input");
		
		var newData = new Object();						
		for (var i=0; i < ba.length; i++) {
			newData[ba[i].name] = (ba[i].value == "") ? "" : ba[i].value;
		}						
		OXContactMapping.createObject(newData);	
		
		var Self = this;
		var last_mod = this.old_user_data.timestamp;
		
		function getErrorMsg(reply) {
			if (reply.error == "You do not have permission to create objects in this folder %1$d in context %2$d with user %3$d") {
				return _("You do not have the necessary permissions to edit your own information.");
			} else {
				return formatError(reply);
			}
		}
		
		ox.JSON.put(AjaxRoot + "/user?action=update&session=" + session + "&id="+configGetKey("identifier")+"&timestamp="+last_mod, newData,
				function(reply) {					
					last_mod = reply.timestamp || last_mod;
					var cacheData = clone(newData);
					cacheData.timestamp = last_mod;
					Self.old_user_data = cacheData;
					Self.loadData(true);
					if (reply.error != null) {
						drawError(getErrorMsg(reply));
					} else {
						callback();
					}
				}, function(reply) {
					if (reply.error != null) {
						drawError(getErrorMsg(reply));
					} else {
						callback();
					}
				}
		);
		
		this.dataChanged = false;
	}
}

function WiztabServices() {
	this.name = "services";
	this.template_name = "popup.wizzard.tab.mail";
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardGmailImage", src: getFullImgSrc(wizzardImages+"services_d.png")});
	this.enabled = false;
	this.visible = true;
	this.position = 0;	
	this.minitabs = new Object();
	this.countTab = 0;
	this.withSub = false;
	
	//#. %1$s is the product name
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"services_mini.png")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ addTranslated(format(_("Subscribe to your everyday web services and mail accounts and use them within %1$s"), oxProductInfo.product_name)) ])
	                                        ]);
	
	this.draw = function (wizzard) {
		
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		
		var Self = this;
		
		function drawServices (){
			var base = document.getElementById("wizzardConten");		
			removeChildNodes(base);
			
			var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [   newnode("td", { width:"30%", verticalAlign:"top" } , { id: "wizzardImageTank"}, [ Self.drawTabGrid() ]),
	                		                             newnode("td", { width:"70%", verticalAlign:"top" } , { id: "wizzardServicesTank"} , [])]));
			
			ctable.appendChild(ctbody);
			base.appendChild(ctable);

			// now, the mini tabs and their container (i.e. "wizzardImageTank") are drawn
            if (Self.minitabs[0] != null) {
                    // draw/activate first tab
                    Self.minitabs[0].draw();
            }
		
		}	

		
		if (this.countTab == 0){
			if (Self.withSub == true){
				ox.JSON.get(AjaxRoot + "/subscriptionSources/?action=all"
					    + "&columns=id,displayName,icon,module,formDescription&session=" + session,
				    function(reply) {
						if (reply != null) {
							// loop subscription sources [mail first]
							for (var i in reply.data) {
								var name = reply.data[i][1];
								switch (name) {
									case "GoogleMail": Self.addMiniTab(new MiniTabGmail(Self.withSub)); break;
									case "gmx.de": Self.addMiniTab(new MiniTabGMX(Self.withSub)); break;
									case "web.de": Self.addMiniTab(new MiniTabWebde(Self.withSub)); break;
									case "yahoo.com": Self.addMiniTab(new MiniTabYahoo(Self.withSub)); break;
								}
							}
							
							if (wizzardwithMSNService){ Self.addMiniTab(new MiniTabMSN()); }
							if (wizzardwithTOnlineService){ Self.addMiniTab(new MiniTabTOnline()); }  
							
							// loop again [other sources]
							for (var i in reply.data) {
								if (Self.withSub == true){
									var name = reply.data[i][1];
									switch (name) {
										case "Facebook": Self.addMiniTab(new MiniTabFacebook()); break;
										case "LinkedIn": Self.addMiniTab(new MiniTabLinkedin()); break;
										case "OXMF Contacts": Self.addMiniTab(new MiniTabOXMF()); break;
										case "XING": Self.addMiniTab(new MiniTabXing()); break;
									}
								}
							}
							// draw
							drawServices();
						}
			        }
				);
			} else {
				Self.addMiniTab(new MiniTabGmail(Self.withSub));
				Self.addMiniTab(new MiniTabGMX(Self.withSub));
				Self.addMiniTab(new MiniTabWebde(Self.withSub));
				Self.addMiniTab(new MiniTabYahoo(Self.withSub));
				
				if (wizzardwithMSNService){ Self.addMiniTab(new MiniTabMSN()); }
				if (wizzardwithTOnlineService){ Self.addMiniTab(new MiniTabTOnline()); }
				
				drawServices();
			}
		} else {
			drawServices();
		}
		
		setWizzardTitle(_("Step 2. Subscribe services"));

		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(document.createTextNode(_("Services")));
		
		var image = document.getElementById("wizzardGmailImage");		
		image.src= getFullImgSrc(wizzardImages+"services_a.png");
		
	}
	this.addMiniTab = function (miniTab){
		this.minitabs[this.countTab] = miniTab;
		this.countTab++;
	}
	this.drawTabGrid = function (){
		
		//#. %1$s is the product name
		var imageTank = newnode('div', {width: "100%"}, 0); 
		imageTank.appendChild( newnode('div', {paddingTop: "15px", paddingBottom: "10px", width: "100%", fontWeight:"bold"}, 0, [addTranslated(format(_("%1$s can subscribe other web services. Select a service you want to use with %1$s."), oxProductInfo.product_name))]));		
		var factor = 4;
		for (var cnt=0; cnt < (this.countTab/factor); cnt++){					
			var base = newnode('div', {width: "100%", height: "100%"}, 0);			
			for (var cnt2 = cnt*factor; cnt2 < ((cnt*factor)+factor); cnt2++){
				if (this.minitabs[cnt2] != null){
					base.appendChild(this.minitabs[cnt2].image);
					this.minitabs[cnt2].position = cnt2;
				}
			}
			imageTank.appendChild(base);
		}
	
		for (var cnt=0; cnt < (this.countTab/factor); cnt++){
			for (var cnt2 = cnt*factor; cnt2 < ((cnt*factor)+factor); cnt2++){
				if (this.minitabs[cnt2] != null){					
					var cb = this.minitabs[cnt2];
					addDOMEvent(this.minitabs[cnt2].image, "click", (function (cb) { return function () { 
						cb.draw();
						
					}}) (cb) );
				}
			}
		}
		
		return imageTank;
	}
	this.next = function (callback) {
		
		var image = document.getElementById("wizzardGmailImage");		
		image.src= getFullImgSrc(wizzardImages+"services.png");
		callback();
	}
	this.previous = function (callback) {
		
		var image = document.getElementById("wizzardGmailImage");		
		image.src= getFullImgSrc(wizzardImages+"services_d.png");
		callback()
	}	
}

function WiztabPublish() {
	this.name = "publish";
	this.template_name = "popup.wizzard.tab.mail";
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardGMXImage", src: getFullImgSrc(wizzardImages+"puplish_d.png")});
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.node = null;
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"puplish_mini.png")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ document.createTextNode(_("Publish your contacts and share them with other people on the net")) ])
	                                        ]);
	
	this.draw = function (wizzard) {

		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		
		setWizzardTitle(_("Step 3. Publish your contacts"));

		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(document.createTextNode(_("Publications")));

		
		var plus = newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"plus_mini.png")});
		
		var plustable = ctable = newnode('table',{borderCollapse:"collapse", width:"100%"},{ cellpadding:"0",cellspacing:"0"},[
		    newnode('tbody',0,0, [
                 newnode("tr", 0 , 0, [ 
	                newnode("td", { paddingTop:"15px", width:"100%", verticalAlign:"middle", fontWeight:"bold" } , {colSpan:"2"}, [ document.createTextNode(_("Contacts can be exchanged with other Internet users by publishing a contacts folder. The publish function provides a URL that can be sent by E-Mail.")) ])
	             ]),
		         newnode("tr", 0 , 0, [ 
		            newnode("td", { paddingTop:"15px", verticalAlign:"middle" } , 0, [plus]),
		            newnode("td", { paddingTop:"15px", width:"100%", verticalAlign:"middle" } , 0, [ document.createTextNode(_("Create a new publication")) ])
		         ])
		    ])]);

		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		ctbody.appendChild( newnode("tr", 0 , 0, [   newnode("td", { width:"30%", verticalAlign:"top" } , { id: "wizzardPublishImageTank"},[plustable]),
                		                             newnode("td", { width:"70%", verticalAlign:"top", paddingLeft:"35px" } , { id: "wizzardPublishServicesTank"} , [])
                		                             ]));		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		var initFolder = false;
		var Self = this;
		addDOMEvent(plus, "click", function() {						
			hideErrorBox();
			var newBase = document.getElementById("wizzardPublishServicesTank");
			removeChildNodes(newBase);
			if (initFolder == false ){
				newContactFolderTree = new cFolderTree(	$('folder_tree_info'),		
				function (ofolder){
					Self.drawSetup(ofolder.oxfolder.data.id,ofolder.oxfolder.data.title);
					Self.showFolderPopup();
				},
				false,
				oMainFolderTree.cache,
				optFolderState.getState('folder_tree_info'));
				newContactFolderTree.enabled_modules = {contacts:true};	
												
				newContactFolderTree.load();
				newContactFolderTree.setSaveConfiguration(optFolderState);
				initFolder = true;
			}
			Self.showFolderPopup();
		});		
		
		var image = document.getElementById("wizzardGMXImage");		
		image.src= getFullImgSrc(wizzardImages+"puplish_a.png");

	}
	this.showFolderPopup = function(){
		if ($("TreeDialogImportForlder").style.display == "none"){
			$("TreeDialogImportForlder").style.display = "block";
			$("TreeDialogImportForlder").style.top = "230px";
			$("TreeDialogImportForlder").style.left = "420px";
		}else{
			$("TreeDialogImportForlder").style.display = "none";
		}
	}
	this.next = function (callback) {
		var image = document.getElementById("wizzardGMXImage");		
		image.src= getFullImgSrc(wizzardImages+"puplish.png");
		callback();
	}
	this.previous = function (callback) {
		var image = document.getElementById("wizzardGMXImage");		
		image.src= getFullImgSrc(wizzardImages+"puplish_d.png");
		callback();
	}
	this.drawSetup = function (folderId, folderTitle){

		var base = document.getElementById("wizzardPublishServicesTank");
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody', 0, { id:"wizzard.publish.content"});	

		ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td", { paddingTop: "15px", paddingBottom: "15px"} , {colSpan: 2} , [ document.createTextNode(_("The site name will be the name of the publication. A template will be saved in your infostore folder with the given template name. You can change this template later whenever you want.")) ])]));

		ctbody.appendChild( newnode("tr", 0 , 0, [
	                                               	 newnode("td", { paddingTop: "5px"} , 0, [document.createTextNode(_("Folder"))]),
	                             		             newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { id:"wizzard.publish.folder",value:folderTitle, name:folderId,type:"text",disabled:"disabled" })])]));
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
	                                               	 newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [document.createTextNode(_("Site name"))]),
	                             		             newnode("td", { width:"100%",paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { id:"wizzard.publish.site", type:"text" })])]));

		ctbody.appendChild( newnode("tr", 0 , 0, [
	                                               	 newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [document.createTextNode(_("Template name"))]),
	                             		             newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.publish.template" })])]));
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
		                                          newnode("td", {whiteSpace:"nowrap", paddingTop: "5px"} , {}, [ document.createTextNode(_("Add cipher code")) ]),
		                                          newnode("td", {paddingTop: "5px"} , {}, [ newnode("input", { marginLeft:"10px" }, { id:"wizzard.publish.cipher", type:"checkbox", checked:"false", defaultChecked:"defaultChecked", className:"noborder" }) ])
		                                        ]));

		
		
		var saveButton = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: _("Save"), value: _("Save publication") }));

		ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td", { paddingTop: "15px", paddingBottom: "15px"} , {colSpan: 2, id:"wizzard.publication.savebutton"} , [ saveButton ])]));
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		var Self = this;
		addDOMEvent(saveButton, "click", function() {	
			
			var folderId = document.getElementById("wizzard.publish.folder").name;
			var folderName = document.getElementById("wizzard.publish.folder").value;
			
			var site = document.getElementById("wizzard.publish.site").value;
			var template = document.getElementById("wizzard.publish.template").value;

			var cipher = (document.getElementById("wizzard.publish.cipher").checked == true ) ? true : false;
			
			
			if (site == null || template == null) {
				drawError(_("Please provide a site name and a template name."));
			} else {
				var data = { "target":"com.openexchange.publish.microformats.contacts.online",
						"entityModule":"contacts",
						"entity":{"folder":folderId},
						"com.openexchange.publish.microformats.contacts.online":{"siteName":site,"template":template,
						"protected": cipher,
						"url":""}};
					
				ox.JSON.put(AjaxRoot + "/publications?action=new&session=" + session, data,
					function(reply){							
						var url = "";
						if (reply.data != null){													
							ox.JSON.get(AjaxRoot + "/publications?action=get&id="+reply.data+"&session=" + session,
						            function(reply) {
										// do we already hav a protocol? if not add it!
										if (!reply.data["com.openexchange.publish.microformats.contacts.online"].url.match(/^http/)) {
											url = "http://"+window.location.host;
										}
										url += reply.data["com.openexchange.publish.microformats.contacts.online"].url;
										
										document.getElementById("wizzard.publication.savebutton").style.display="none";	
										var newBase = document.getElementById("wizzard.publish.content");
										
										newBase.appendChild( newnode("tr", 0 , 0, [
                                           	 newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [document.createTextNode(_("URL"))]),
                         		             newnode("td", { width:"100%",paddingTop: "5px",paddingLeft:"15px"} , 0, [newnode("a",0,{ href: url, target: "_blank"}, [ document.createTextNode(reply.data["com.openexchange.publish.microformats.contacts.online"].url)])])]));										

										
										newBase.appendChild( newnode("tr", 0 , 0, [newnode("td", { width:"100%",paddingTop: "30px", fontStyle:"italic"} , {colSpan: 2}, [document.createTextNode(_("You can create additional publications by clicking the plus icon again."))])]));
				
									},
						            function(error) {
						            	return true;
						            });	
						}
						drawError((reply.error != null) ? formatError(reply) : (_("This publication has been saved.")));
						triggerEvent("OX_Refresh");
					}, function(reply){
						
						if (reply.error.indexOf("has already been taken (Field") != -1 ){
							drawError(_("A publication with this name already exists."));
						} else if (reply.error.indexOf("You do not have the permissions to undertake the chosen action") != -1){
							drawError(_("You do not have the permissions to publish this folder."));	
						} else if (reply.error != null){
							drawError(formatError(reply));
						} else {
							drawError(_("An unknown error occurred."));
						};
					}
				);
			}
			
		});
	
	}
}


function WiztabMobile() {
	this.name = "mobile";
	this.template_name = "popup.wizzard.tab.mail";	
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardMobileImage", src: getFullImgSrc(wizzardImages+"mobile_d.png")});
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.node = null;
	
	//#. %1$s is the product name
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"mobile_mini.png")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ addTranslated(format(_("Configure your handheld device to synchronize it with %1$s"), oxProductInfo.product_name)) ])
	                                        ]);
	
	this.draw = function (wizzard) {
		
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		
		setWizzardTitle(_("Step 4. Configure your handheld"));

		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(document.createTextNode(_("Handhelds and mobile devices")));
		
		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
		
		//var ms_link = "[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/docs/OX6-OXtender-for-Business-Mobility-[language].pdf";
		function ms_openDocument(link) {
			var ms_language = (configGetKey("language") || "en_US").split("_");
			var ms_object = { 
					language:  
						(function() {
							switch(ms_language[0]) {
								case "de": return "German";
								case "fr": return "French";
								case "nl": return "Dutch";
								case "es": return "Spanish";
								default  : return "English";
							}
						})()
			};
			return link.format(ms_object);
		}

		
		var winmobile_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-winmobile-[language].html");
		var winmobile = newnode("a", { } , { className:"linkstyle", href: winmobile_link, target: "mobilityiFrame" }, [ document.createTextNode(_("Windows Mobile 6, 6.1, 6.5")) ]);
		
		var nokias60_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-nokias60-[language].html");
		var nokias60 = newnode("a", { } , { className:"linkstyle", href: nokias60_link, target: "mobilityiFrame" }, [ document.createTextNode(_("Nokia Symbian S60 (N97, E51)")) ]);
				
		var iphone_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-iphone-[language].html");
		var iphone = newnode("a", { } , { className:"linkstyle", href: iphone_link, target: "mobilityiFrame" }, [ document.createTextNode(_("Apple iPhone (2G, 3G, 3Gs)")) ]);
		
		var blackberry_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-blackberry-[language].html");
		var blackberry = newnode("a", { } , { className:"linkstyle", href: blackberry_link, target: "mobilityiFrame" }, [ document.createTextNode(_("BlackBerry")) ]);

		var doc_all_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/docs/OX6-OXtender-for-Business-Mobility-[language].pdf");
		var doc_all = newnode("a", { } , { className:"linkstyle", href: doc_all_link, target: "_blank" }, [ document.createTextNode(_("Download all manuals as PDF")) ]);
		
		
		var mobilityiFrame = newnode("iframe", { width:"510px", height: "320px" }, { scrolling: "auto", frameBorder: "0", src: winmobile_link, id: "mobilityiFrame", name: "mobilityiFrame" });
		
		
		//#. %1$s is the product name
		var mobilityBase = newnode("td", { width:"100%", verticalAlign:"middle", fontWeight:"bold" } , {colSpan:2}, [ addTranslated(format(_("You can use your mobile device with %1$s. The following devices are supported."), oxProductInfo.product_name))])     

		if (wizzardMobilityNokia){
			mobilityBase.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"15px", width:"100%", verticalAlign:"middle" } ,{colSpan:"2",className:"linkstyle"}, [ nokias60 ] )]));    
		}
		if (wizzardMobilityWindowsMobile){
			mobilityBase.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ winmobile ] )]));    
		}
		if (wizzardMobilityiPhone){
			mobilityBase.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ iphone ])]));    
		}
		if (wizzardMobilityBlackBerry){
			mobilityBase.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ blackberry ])]));    
		}
		
		//             newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2"}, [ document.createTextNode(_("Palm (Palm 750, Palm Pre)")) ] )]), 
		//             newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2"}, [ document.createTextNode(_("Android 1.5 (G1)")) ] )]),

		
		mobilityBase.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", height: "120px", verticalAlign:"bottom" } , {colSpan:"2",className:"linkstyle"}, [ doc_all ])]));    
		
	    var plustable = ctable = newnode('table',{ borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"},[newnode('tbody',0,0, [ newnode("tr", 0 , 0, [ mobilityBase ])])]);
	       		
		var ctable = newnode('table',{ marginTop:"15px", borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		ctbody.appendChild( newnode("tr", 0 , 0, [  newnode("td", { width:"30%", verticalAlign:"top" } , { id: "wizzardPublishImageTank"},[plustable]),
		                                            newnode("td", { height:"320px", width:"70%", verticalAlign:"top" } , { id: "wizzardServicesTank", className:"iFrameWindow" } , [ mobilityiFrame ])
                		                         ]));		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		var image = document.getElementById("wizzardMobileImage");		
		image.src= getFullImgSrc(wizzardImages+"mobile_a.png");
		
	}
	this.next = function (callback) {
		
		var image = document.getElementById("wizzardMobileImage");		
		image.src= getFullImgSrc(wizzardImages+"mobile.png");
		callback();
	}
	this.previous = function (callback) {
		
		var image = document.getElementById("wizzardMobileImage");		
		image.src= getFullImgSrc(wizzardImages+"mobile_d.png");
		callback();
	}	
}

function WiztabUpsale() {
	this.name = "upsell";
	this.template_name = "popup.wizzard.tab.mail";
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardUpsellImage", src: getFullImgSrc(wizzardImages+"upsell_d.png")});
	this.enabled = false;
	this.visible = true;
	this.position = 0;	
	this.minitabs = new Object();
	this.countTab = 0;
	this.withSub = false;
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox", src: getFullImgSrc(wizzardImages+"upsell_mini.png")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ document.createTextNode(_("Additional services")) ])
	                                        ]);
	
	this.draw = function (wizzard) {
		
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		
		setWizzardTitle(_("Upsell option"));

		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(document.createTextNode(_("Additional services")));
		
		var image = document.getElementById("wizzardUpsellImage");		
		image.src= getFullImgSrc(wizzardImages+"upsell_a.png");
		
		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%", marginTop:"15px"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	


		ctbody.appendChild( newnode("tr", 0 , 0, [   newnode("td", { width:"30%", verticalAlign:"top", fontWeight:"bold" } , {colSpan:2}, [ document.createTextNode(_("Enhance your feature set with the add-ons available on this page. Click one of the icons to get further information.")) ]), 
                		                             newnode("td", { height:"320px", width:"70%", verticalAlign:"top" } , { id: "wizzardServicesTank", className:"iFrameWindow" } , [ newnode("iframe", { width:"510px", height: "320px" }, { scrolling: "auto", frameBorder: "0", src: wizardUpsellLayerTabUrl, id: "upselliFrame"}) ])]));
    		                              
                		                              
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
	}
	this.addMiniTab = function (miniTab){
		this.minitabs[this.countTab] = miniTab;
		this.countTab++;
	}
	this.next = function (callback) {
		
		var image = document.getElementById("wizzardUpsellImage");		
		image.src= getFullImgSrc(wizzardImages+"upsell.png");
		callback();
	}
	this.previous = function (callback) {
		
		var image = document.getElementById("wizzardUpsellImage");		
		image.src= getFullImgSrc(wizzardImages+"upsell_d.png");
		callback()
	}	
}


function WiztabDone() {
	this.name = "done";
	this.template_name = "popup.wizzard.tab.finish";
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.headerImage = newnode("img", {padding: "5px", paddingBottom:"25px" }, {id: "wizzardEndImage", src: getFullImgSrc(wizzardImages+"done_d.png")});
	this.draw = function (wizzard) {	
		$("popup.wizzard.back").value = _("Previous");
		$("popup.wizzard.next").style.display = "none";
		$("popup.wizzard.closebutton").value = _("Close");
		$("popup.wizzard.closebutton").style.color = "";
		
		setWizzardTitle(_("Wizard"));
		
		var image = document.getElementById("wizzardEndImage");		
		image.src= getFullImgSrc(wizzardImages+"done.png");
		
		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(document.createTextNode(_("Finish")));

		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
        var hideWizard = configContainsKey("gui.wizard.launchOnStart") &&
            !configGetKey("gui.wizard.launchOnStart");
        var check_box = newnode("input", { paddingLeft:"15px", paddingRight:"5px" }, { id:"wizzard.done.checkclose", type:"checkbox", checked: hideWizard, className:"noborder" });
		
		base.appendChild(newnode("br"));
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		//#. %1$s is the product name
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "0px"} , {colSpan:2}, [ addTranslated(format(_("You have successfully completed the %1$s Wizard. You can launch the wizard anytime by clicking on the respective entry in the help menu."), oxProductInfo.product_name)) ])
        ]));
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "15px"} , {}, [ check_box ]),
          newnode("td", {paddingTop: "15px", width:"100%", fontWeight:"bold"} , {}, [ document.createTextNode(_("Do not show this wizard again")) ])
        ]));
		
		//#. %1$s is the product name
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "15px"} , {colSpan:2}, [ addTranslated(format(_("Thank You for using %1$s."), oxProductInfo.product_name)) ])
        ]));
		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);

		
		addDOMEvent(check_box, "click", function() {
            $("popup.wizzard.hide").checked = check_box.checked;
			if (check_box.checked == true){
				configSetKey("gui.wizard.launchOnStart", false);
			} else {
				configSetKey("gui.wizard.launchOnStart", true);
			}
			triggerEvent("OX_Save_Configuration",true,false);
		});		
		
	}
	this.next = function (callback) {	
		$("popup.wizzard.next").style.display = "inline";
		
		callback();
	}
	this.previous = function (callback) {
		
		var image = document.getElementById("wizzardEndImage");		
		image.src= getFullImgSrc(wizzardImages+"done_d.png");
		
		$("popup.wizzard.closebutton").value = _("Close");
		$("popup.wizzard.next").style.display = "inline";
		callback();
	}	
}

/**
 * 
 * The Main Wizzard
 * 
 */

function plugin_wizzard_init() {
		
	var wizzard = new Wizzard();
	this.wizzard = wizzard;
	wizzard.addWiztab(new WiztabWelcome());
	wizzard.addWiztab(new WiztabPersonalData());
	wizzard.addWiztab(new WiztabServices());
	wizzard.addWiztab(new WiztabPublish());
	wizzard.addWiztab(new WiztabMobile());
	wizzard.addWiztab(new WiztabUpsale());
	
	var tabs = temporary.services.getProviders("com.openexchange.wizard");
	for (var i = 0; i < tabs.length; i++) wizzard.addWiztab(tabs[i]);
	    
	wizzard.addWiztab(new WiztabDone());
	wizzard.initWizzard();
	
	$("popup.wizzard.hide").checked =
	    configContainsKey("gui.wizard.launchOnStart") &&
        !configGetKey("gui.wizard.launchOnStart");
	
	showNode("disable_background_window");
	$("disable_background_window").style.display="block";
	$("disable_background_window").appendChild($("popup.wizzard"));

	wizzard.drawActiveTab();
	
	showNode("popup.wizzard");	
	$("popup.wizzard").style.display="block";
	setTimeout(function() { centerPopupWindow($("popup.wizzard")); }, 0);
}
function plugin_wizzard_close() { 
	$("popup.wizzard").style.display="none";
	hideNode("disable_background_window");
	$("disable_background_window").style.display="none";
}

function hideErrorBox(){
	var base = document.getElementById("wizzardErrorBox");
	if (base.style.display == "block"){
		removeChildNodes(base);
		base.style.display = "none";
	}	
}

function drawError(textmessage){
	var base = document.getElementById("wizzardErrorBox");
	removeChildNodes(base);
	base.appendChild( document.createTextNode(textmessage) );
	base.style.display = "block";
}

function plugin_wizzard_next() {
	hideErrorBox();
	this.wizzard.getActiveWiztab().next(function(error) {
		if (error == null){
			this.wizzard.selectNextTab();
		} else {
			drawError(error);
		}
	});
}

function plugin_wizzard_previous() {
	hideErrorBox()
	var error = this.wizzard.getActiveWiztab().previous( function(error) {
		if (error == null) {
			this.wizzard.selectPreviousTab();
		} else {
			var base = document.getElementById("wizzardErrorBox");		
			base.appendChild( document.createTextNode(error) );
			base.style.display = "block";
		}
	});
}
function setWizzardTitle(title) {
	var title = new I18nNode(_(title));
	removeChildNodes($("popup.wizzard.header").getElementsByTagName("span")[0]);
	$("popup.wizzard.header").getElementsByTagName("span")[0].appendChild(title.node);
}

function reDrawImageGrid() {
	hideErrorBox();	
	var at = this.wizzard.getActiveWiztab()
	for (var i = 0; i < at.countTab; i++){
		if (at.minitabs[i].image.src.lastIndexOf("_o.png") != -1){
			var x = at.minitabs[i].image.src;
			at.minitabs[i].image.src = x.replace(/o.png/g,"d.png");
		}
	}
}

function wizDeleteFolder(fid, timestamp){
	
	json.put(AjaxRoot + "/folders?action=delete&session=" + session+"&timestamp=" + timestamp,[fid],null,function (arg){
	});
}

function wizDeleteMailAccount(id){
	if (id && id >= 0){
        json.put(AjaxRoot + "/account?action=delete&session=" + session, [id],
            null, function (reply){
                if (mail_accounts) mail_accounts.removeIDs([id]);
            });
	}
}

function wizButton(button){
	 var node = newnode("div",{flt:"left"},{ className:"fakeButton background-color-default cursorPointer whiteground"},[newnode("div",{},{className:"fakeButtonBottom"},[newnode("div",{},{className:"fakeButtonLeft"},[newnode("div",{},{className:"fakeButtonRight"},[
          newnode("div",{},{className:"fakeButtonTopLeft"},[newnode("div",{},{className:"fakeButtonTopRight"},[newnode("div",{},{className:"fakeButtonBottomLeft"},[newnode("div",{},{className:"fakeButtonBottomRight"},[button])])])])
       ])])])]);
	return node;
}


/**
 *  The Wizzard 
 *  The Wizzard is the main container with all tabs
 */

function Wizzard() {
	this.wiztabs = new Object();
	this.wizorder = new Array();
	this.selected = null;
	this.wizzardNode = null;
	this.activeError = "";
 }

Wizzard.prototype = {
	length : 0,
	addWiztab : function(wiztab) {
		 var Self = this;
		 var validTab = false;
		 
		 var modules = configGetKey("availableModules");	 
        switch (wiztab.name) {
            case "services":
                if (!wizardTabServices) break;
				for (var i in modules){				 
					if (modules[i] == "com.openexchange.subscribe"){
						validTab = true;
						wiztab.withSub = true;
					}
					if (modules[i] == "mailaccount" && configGetKey("modules.mail.module") != null ){
						validTab = true;
					}				 
				}
                break;
            case "publish":
				if (!wizardTabPuplish) break;
				for (var i in modules){
					if (modules[i] == "com.openexchange.publish"){
						validTab = true; 
					}
				}
                break;
            case "upsell":
                validTab = wizardTabUpsell;
                break;
            case "mobile":
                if (!wizardTabMobility) break;
				for (var i in modules){
					if (modules[i] == "com.openexchange.usm.eas"){
						validTab = true;
					}
				}
                break;
            case "personaldata":
                if (!wizardTabPersonalData) break;
                for (var i in modules) {              
                    if (modules[i] == "com.openexchange.user.personaldata") {
                        validTab = true;
                    }
                }
                break;
            default:
                validTab = true;
        }
		
		 if (validTab){
			 if (Self.length == 0) {
				wiztab.enabled = true;
				Self.selected = wiztab.name;
			 }
			 Self.wizorder.push(wiztab.name);
			 wiztab.position=Self.length;
			 Self.wiztabs[wiztab.name] = wiztab;
			 Self.length++;
		 }
	},
	selectWiztab : function(wiztab){
		this.unselectAllWiztabs();
		wiztab.enabled = true;
		this.selected = wiztab.name;
	},
	unselectAllWiztabs : function(){
		var Self = this;
		Self.selected = null;
		for (var i in Self.wiztabs)	{
		  if (Self.wiztabs[i].enabled == true)
			  Self.wiztabs[i].enabled = false;
		}
	},
	initWizzard : function (){
		removeChildNodes($("popup.wizzard.content"));
		if (null == this.wizzardNode) {	
			var template = $("popup.wizzard.tab.mail").cloneNode(true);
			template.appendChild(this.drawWiztabHeader());
			template.style.display="block";
			this.wizzardNode = template;
		}
		showNode(this.wizzardNode);
		$("popup.wizzard.content").appendChild(this.wizzardNode);
	},
	drawActiveTab : function (){
		this.getActiveWiztab().draw(this);
	},
	selectNextTab : function () {
		var currentPosition = this.getActiveWiztab().position;
		if (currentPosition == this.wizorder.length-1){
			plugin_wizzard_close();
		} else {
			this.selectWiztab(this.getWiztab(this.wizorder[(currentPosition+1)]));
			this.drawActiveTab();
		}
	},
	selectPreviousTab : function () {
		var currentPosition = this.getActiveWiztab().position;
		if (currentPosition > 0){
			this.selectWiztab(this.getWiztab(this.wizorder[(currentPosition-1)]));
			this.drawActiveTab();
		}
	},
	getWiztabAtPosition : function (pos){
		return this.wiztabs[pos];
	},
	getWizorder : function (){
		return this.wizorder;
	},
	getAllWiztabs : function (){
		return this.wiztabs;
	},
	getWiztab : function (wiztab) {
		return this.wiztabs[wiztab];
	},
	getActiveWiztab : function () {
		return this.wiztabs[this.selected];
	},
	drawWiztabHeader : function (){
		var base = newnode("div", {width: "100%", height: "100%", background:"#ffffff"}, {id: "wiztabbase"});
		var iTank = newnode("div", {paddingTop: "10px"} , {id:"wizzardImageContainer"});
		var order = this.getWizorder();		
		for (var cnt=0;cnt <order.length;cnt++){
			var tab = this.getWiztabAtPosition(order[cnt]);
			if (tab.visible == true){
				iTank.appendChild(tab.headerImage);
				if (cnt != (order.length -1)){
					iTank.appendChild(newnode("img", {verticalAlign:"top", paddingTop: "35px"}, { src: getFullImgSrc(wizzardImages+"arrow_right.png")}));
				}	
			}
		}
		base.appendChild( newnode("div", {paddingLeft: "20px"} , 0 , [iTank]));		
		base.appendChild( newnode("div", {paddingLeft: "20px",paddingRight: "20px"} , { id:"wizzardHeader"}, [ newnode("div", 0 , {className:"wizzardHeader", id:"wizzardHeaderTitle"} ), newnode("div", {display:"none"} , {className:"wizzardErrorBox",id: "wizzardErrorBox"})]));
		base.appendChild( newnode("div", {paddingLeft: "26px",paddingRight: "20px"} , 0, [ newnode("div", 0 , {id:"wizzardConten"} )]));

		return base;
	}

}

function setWizardFieldsDisabled(fields, disabled) {
	$l = fields.length;
	for (var i=0; i < $l; i++) {
		if ($ALL(fields[i])) {
			$ALL(fields[i]).disabled = disabled;
		}
	}
}


function storeHTMLFile(node) {
	function getIDs(obj) {
		function recursive(obj) {
			for(var i=obj.firstChild; i!=null; i=i.nextSibling) {
				if(i.nodeType==1) { 
					idValue=i.id;
					if(idValue) { 
						if(allnodes[i.id]) {
							alert("Internal Error: ID \"" + i.id + "\" used multiple times!");
							allnodes[i.id] = "Duplicate ID";
						} else {
							allnodes[i.id]=i; 
						}
					}
					recursive(i);
				}
			}
		}
		if(obj.id) { allnodes[obj.id]=obj; } 
		recursive(obj);
	}
	var el=document.createElement("div");
	el.innerHTML=node;	
	getIDs(el);
}
/*
function loadJSFile(page) {
	if(debug) { debugJSLoad(page)}  
	else {
		jsarray[jsarray.length]=page;
		loadFile(page,jsload.add(storeJSFile),page);
	}
}
*/
function loadFile(page, cb, cb2) {
	var xmlhttp = JSON.prototype.getXmlHttp();
	function callback() {
		if (xmlhttp.readyState != 4) return;
		xmlhttp.onreadystatechange = emptyFunction; // fixes IE memory leak
		var s = xmlhttp.responseText;
		cb(s);				
		cb2();
	}
	xmlhttp.onreadystatechange = callback;
	xmlhttp.open("GET",page, true);
	xmlhttp.send("");
}


function launchWizard(){	
	loadFile(wizzardCSS, function (node) { 
		var d=newnode("style",null,{type : "text/css"},[]);
		if(!IE) {
			d.appendChild(document.createTextNode(node));
		} else {
			d.styleSheet.cssText = node;	
		}
		body.parentNode.getElementsByTagName("head")[0].appendChild(d);
		
	},  function () { });
	loadFile(wizzardTemplate, function (node) { storeHTMLFile(node); },  function () { 
		
		addDOMEvent($("popup.wizzard.close"), "click", function() { plugin_wizzard_close();	});
		addDOMEvent($("popup.wizzard.closebutton"), "click", plugin_wizzard_close);
		addDOMEvent($("popup.wizzard.next"), "click", function() { plugin_wizzard_next(); });
		addDOMEvent($("popup.wizzard.back"), "click", function() { plugin_wizzard_previous(); });
		
		var parent = $("popup.wizzard");
        addDOMEvent($("popup.wizzard.header"), "mousedown", function(e) {
            if (e.button != LeftButton) return;
            moving = parent;
            offsetX = parent.offsetLeft - e.clientX;
            offsetY = parent.offsetTop - e.clientY;
            parent.style.cursor = "move";
            function moveHandler(e) {
                var topposition=(e.clientY + offsetY);
                var leftposition=(e.clientX + offsetX);
                if(topposition<0) {
                    topposition=0;
                }
                else if(topposition+parent.offsetHeight > $("body").offsetHeight) {
                    topposition=$("body").offsetHeight-parent.offsetHeight;
                }
                if(leftposition<0) {
                    leftposition=0;
                }
                else if(leftposition+parent.offsetWidth > $("body").offsetWidth) {
                    leftposition=$("body").offsetWidth-parent.offsetWidth;
                }
                moving.style.left = leftposition + "px";
                moving.style.top = topposition + "px";
                stopEvent(e);
            }
            function upHandler(e) {
                if (moving && e.button == LeftButton) {
                    moving = null;
                    parent.style.cursor = "auto";
                    removeDOMEvent(body, "mousemove", moveHandler);
                    removeDOMEvent(body, "mouseup", upHandler);
                    //removeDOMEvent(body, "mouseout", upHandler);
                    stopEvent(e);
                }
            }
            addDOMEvent(body, "mousemove", moveHandler);
            addDOMEvent(body, "mouseup", upHandler);
            //addDOMEvent(body, "mouseout", upHandler);
            cancelDefault(e);
        });
		
		
		
		$("popup.wizzard.hidediv").appendChild(addTranslated(_("Do not show on start")));
		
		addDOMEvent($("popup.wizzard.hide"), "click", function() {
            var check = document.getElementById("wizzard.done.checkclose");
            if (check) check.checked = $("popup.wizzard.hide").checked;
			if ($("popup.wizzard.hide").checked == true){
				configSetKey("gui.wizard.launchOnStart", false);
			} else {
				configSetKey("gui.wizard.launchOnStart", true);
			}
			triggerEvent("OX_Save_Configuration",true,false);
		});
		
		loadFile(wizzardConfig, function (node) { 
			var d=newnode("script",null,{type : "text/javascript", text: node },[]);
			body.parentNode.getElementsByTagName("head")[0].appendChild(d);
			
			if (wizardLaunchOnStart && (!configContainsKey("gui.wizard.launchOnStart") || configGetKey("gui.wizard.launchOnStart") != false )){
				plugin_wizzard_init();
			}
			HelpMenu.addText(_("Wizard"), function (){ plugin_wizzard_init(); });		
			
		},  function () { });
		
	});
}

temporary.services.consume("com.openexchange.wizard", launchWizard);
