/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * 
 */
 
/**
 * Shows the linked Objects
 * @param {String} id of the div for Livegrid
 * @param {int} object id from current view
 * @param {Function} module from current view (1:calendar, 4:tasks, 7:contacts, 19:mail, 137:infostore)
 * @param {String} optional: id of the TabDiv for view the count
 */
var currentLinkingLiveGrid = null;
function LinkingObject(linkingViewDiv, id, module, countDiv) {
	this.list = $(linkingViewDiv);
	this.listHeader = $(linkingViewDiv + "Header");
	this.countDiv = null;
	if(countDiv) {
		this.countDiv = $(countDiv);
	}
	this.id = id;
	this.module = module;
	this.linkingGrid = null;
	this.moduleKey = new Array();
	this.moduleKey[1] = new Array(); 	// needs now for Linking
	this.moduleKey[4] = new Array(); 	// needs now for Linking
	this.moduleKey[7] = new Array(); 	// needs now for Linking
	this.moduleKey[13] = new Array();
	this.moduleKey[17] = new Array();
	this.moduleKey[18] = new Array();
	this.moduleKey[19] = new Array();
	this.moduleKey[137] = new Array();	// needs now for Linking
	this.multipleArray = new Array();
	this.IDsArray = new Array();
	this.columnsFromLinkindObject = new Array();
	
	this.actionModule = new Array();
	this.actionModule[1] = "calendar"
	this.actionModule[4] = "tasks";
	this.actionModule[7] = "contacts";
	this.actionModule[19] = "mail";
	this.actionModule[137] = "infostore";
	
	this.moduleLabel = new Array();
	this.moduleLabel[1] = "Calendar"
	this.moduleLabel[4] = "Tasks";
	this.moduleLabel[7] = "Contacts";
	this.moduleLabel[13] = "Project";
	this.moduleLabel[17] = "Forum";
	this.moduleLabel[18] = "Pin board";
	this.moduleLabel[19] = "E-Mail";
	this.moduleLabel[137] = "InfoStore";
	
	this.storage = null;
	this.objects = null;
	
	if(this.id) {
		this.getStorage();
	}
	
	
}
LinkingObject.prototype = {
	
	countLinkingObjects : function(reset) {	
		if(reset) {
			this.countDiv.firstChild.data = "0";
		} else {
			this.countDiv.firstChild.data = this.objects.data.length;
		}		
	},
	
	makeLiveGrid : function() {
			this.list.innerHTML = "";
			
			this.linkingGrid = new LiveGrid([
				
				{
				text: _("Item"),
				sortable: true,
				set: LiveGrid.defaultSet,
				clear: LiveGrid.makeClear("..."),
				index:3
				}, {
					text: _("Module"),
					sortable: true,
					width: "25%",
					set: LiveGrid.defaultSet,
					clear: LiveGrid.makeClear("..."),
					index:4
				}/*, {
					text: _("Folder"),
					sortable: true,
					width: "25%",
					set: function(div,folderid) {
						if (div) {
							var div = div;
							var folderid = folderid;
							oMainFolderTree.getFolderPath(folderid,function(path){
								var path = path.slice(0, path.length-1);
								div.innerHTML =  separateFilenameFromPath(path);
							});
						}
					},
					clear: LiveGrid.makeClear("..."),
					index:5
				}*/
		
			], new Selection(), "links");
			
			this.listHeader.appendChild(this.linkingGrid.getHeader());
			this.linkingGrid.getTable(this.list);
			
			this.linkingGrid.events.register("Activated", 
				function(ids) {
					if (!ids || ids == 0) return;
					(menucheckRight("WRITE")) ? triggerEvent("OX_Object_Edit_Linking",ids) :
						triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
				}
			);
			
			this.linkingGrid.events.register("Selected", function(ids){
				if (ids == 1) {
					triggerEvent("SubSelectedLinking",ids);
				}
			});
	}, 
	getStorage: function() {
		var Self = this;
		json.get(AjaxRoot + "/link?action=all&session=" + session + "&folder=" +
				activefolder + "&id=" + Self.id + "&module=" + Self.module, null,
				function(reply) {
					if(reply.data) {
						//storageCache.current = reply;
						Self.objects = reply;
						if(reply.data && reply.data.length > 0) {
							
							if(Self.countDiv) {
								Self.countLinkingObjects();
							}
						} else {
							if(Self.countDiv) {
								Self.countLinkingObjects("reset");
							}
						}
					} else {
						if(Self.countDiv) {
							Self.countLinkingObjects("reset");
						}
					}
				}
			)
	}, 
	resetArrays: function() {
		this.moduleKey[1] 	= [];
		this.moduleKey[4] 	= [];
		this.moduleKey[7] 	= [];
		this.moduleKey[13] 	= [];
		this.moduleKey[17] 	= [];
		this.moduleKey[18] 	= [];
		this.moduleKey[19] 	= [];
		this.moduleKey[137] = [];
		this.indexLinkingObject = 0;
		this.columnsFromLinkindObject = [];
		this.multipleArray = [];
	},
	enableLinkingLivegrid: function() {
		this.resetArrays();
		var Self = this;
		Self.storage = new Storage(0, [],'',0,0,function(x) {return x.folder + "." + x.id; },function(x){return {id:x[0],folder:x[1],dlist:x[2]};});
		Self.linkingGrid.enable(Self.storage);
		if(this.objects && this.objects.data) {
			for(var i = 0; i < this.objects.data.length; i++) {
				if(this.id == this.objects.data[i].id2 && this.module == this.objects.data[i].module2) {
					this.moduleKey[this.objects.data[i].module1].push(this.objects.data[i]);			
				} else {
					this.moduleKey[this.objects.data[i].module2].push(this.objects.data[i]);
				}
			}
			
			for(key in this.moduleKey) {
				if(this.moduleKey[key].length > 0) {
					this.IDsArray = [];
					for(var t=0; t < this.moduleKey[key].length; t++) {
						this.tmpObject = {};
						if(this.id == this.moduleKey[key][t].id2 && this.module == this.moduleKey[key][t].module2) {
							this.tmpObject.id = this.moduleKey[key][t].id1;
							this.tmpObject.folder = this.moduleKey[key][t].folder1;
						} else {
							this.tmpObject.id = this.moduleKey[key][t].id2;
							this.tmpObject.folder = this.moduleKey[key][t].folder2;
						}
						this.IDsArray.push(this.tmpObject);
					}
					
					this.columnsFromLinkindObject[this.indexLinkingObject] = {};
					this.columnsFromLinkindObject[this.indexLinkingObject].module = this.moduleLabel[key];
					this.columnsFromLinkindObject[this.indexLinkingObject].folder = this.moduleKey[key][0].folder2;
					this.indexLinkingObject++;
					this.columns = "";
					switch (key) {
						case "1"	 : 	this.columns = "1,20,1,200";
										//Appointment
										break;
										
						case "4"	 : 	this.columns = "1,20,1,200";
										//Task
										break;
									
						case "7" 	: 	this.columns = "1,20,602,500";
										//Contacts
										//602 Distribution Flag, for disable Follow Link Funktion if it is "true"
										
										break;
									
						case "137" : 	this.columns = "1,20,1,700";
										//infostore
										break;
									
						default 	: 	break;
					}
					
					this.multipleArray.push ({
										action: "list",
										module: this.actionModule[key],
										columns: this.columns,
										data : this.IDsArray							
										});
										
					
				}
			}
			
					
			json.put(AjaxRoot + "/multiple?session="+session +"&continue=true", 
								Self.multipleArray, 
								null, 
								function(cb){					
									if(cb){
										if(cb.length > 0) {
											var idsForStorage = new Array();
											var storageArray = [];
											for(var m = 0; m < cb.length; m++) {
												if(cb[m].error_id != undefined)
												{
													triggerEvent("OX_New_Error", 4, formatError(cb[m]));													
												}
												else
												{
													var tmpModule 	= Self.columnsFromLinkindObject[m].module;
													var tmpFolderId	= Self.columnsFromLinkindObject[m].folder;
													for(var v = 0; v < cb[m].data.length; v++) {
														var tmpArrayForGrid = cb[m].data[v];
														tmpArrayForGrid.push(_(tmpModule));
														tmpArrayForGrid.push(tmpFolderId);
														storageArray.push(tmpArrayForGrid);
													}
												}										
											}
											if(Self.linkingGrid) {
												Self.storage.append(storageArray);	
												Self.linkingGrid.enable(Self.storage);
												//storageCache.current = Self.storage;
												currentLinkingLiveGrid = Self.linkingGrid;
											}
										}
									}
								}
			);
		}
	},
	disableLinkingLivegrid: function() {
		if(this.linkingGrid && this.linkingGrid.storage)
		this.linkingGrid.disable();
		currentLinkingLiveGrid = null;
		triggerEvent("SubSelectedLinking",0);
	}
	
}

register("OX_Object_Edit_Linking",
	function(ids)
	{
		//ids.folder;
		//ids.id;
		oMainFolderTree.cache.get_folder(ids[0].folder,function (oFolder){
		
		//triggerEvent("OX_Direct_Linking",modulename,oIdObj)
		//menufollowLink(oFolder.data.sModule,linkedObject);
		
		if(menuhasRight(ids,"WRITE")) {		
			switch(oFolder.oxfolder.data.module) {
				
				case "calendar" :	appointmentPopup=newWindow("newAppointment.html#modul=edit&view="+currentCalendarView+"&id="+ids[0].id+"&folder_id="+ids[0].folder, getWindowOptions(), ids[0]);
									appointmentPopup.focus();
									break;
									
				case "infostore" :	propertiesPopUp = newWindow("newInfoItemMain.html#edit_id="+ids[0].id + "&folder="+ids[0].folder, getWindowOptions(), ids[0]);
									propertiesPopUp.focus();
									break
									
				case "tasks" :		editTask = newWindow("newTask.html#modul=edit&id=" 
										+ ids[0].id
										+ "&session=" 
										+ session 
										+ "&folder=" 
										+ ids[0].folder, getWindowOptions(), ids[0]);
									editTask.focus();
									
									break;
									
				case "contacts" :	var oldDistrbutionFlag = isDistributionListSelected;
									(ids[0].dlist == true) ? isDistributionListSelected = 1 : isDistributionListSelected = 0;
									//contactDetailId = ids[0].id;
									if(isDistributionListSelected == 1) {
										openContactPopup("modul=edit&id="+ids[0].id+"&folder="+ids[0].folder+"&session="+session+ "&currentView="+objContactFunctions.lastView, 'newDistributionList.html', ids[0]);
									} else {
										openContactPopup("modul=edit&id="+ids[0].id+"&folder="+ids[0].folder+"&session="+session+ "&currentView="+objContactFunctions.lastView, 'newContact.html', ids[0]);
									}
									isDistributionListSelected = oldDistrbutionFlag;
									break;
									
				default	: 	break;	
			}
		} else {
			triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
		}
		
		
	});
	}
);

register("OX_Linking_Follow",
	function()
	{
		var linkedObject = currentLinkingLiveGrid.selection.getID();

		function cb_getpathForLinking(oNode) {
			oMainFolderTree.cache.get_folder(oMainFolderTree.getFolderID(oNode.id),function (oFolder){
				menufollowLink(oFolder.oxfolder.data.module,linkedObject);
			});
		}		
		setActiveFolder(linkedObject['folder'],cb_getpathForLinking);	
		
	}	
);

register("OX_Linking_Delete",
	function()
	{
		function cbyes() {
			var arrModules = new Array();
			arrModules['calendar'] = 1;
			arrModules['tasks'] = 4;
			arrModules['contacts'] = 7;
			arrModules['mail'] = 19;
			arrModules['infostore'] = 137;
			
		
			var linkedObject = new Object();	
			var linkedArrayDel = new Array();
			var objData = new Object();
			objData.data = new Array();
			var ids = currentLinkingLiveGrid.selection.getSelected();
			var lengthSelected = ids.length;
			
			for(var i = 0; i < lengthSelected; i++) {
				linkedArrayDel.push(ids[i].id);
				oMainFolderTree.cache.get_folder(ids[0].folder,function (oFolder){
				linkedArrayDel.push(arrModules[oFolder.oxfolder.data.module]);
				linkedArrayDel.push(ids[i].folder);
				objData.data[i] = linkedArrayDel;
				});
			}		
			//objData.data = linkedArrayDel;
		
			json.put(AjaxRoot + "/link?action=delete&session=" + session + "&module="+arrModules[activemodule]+"&id="+menuselectedobjects[0].id+"&folder="+(menuselectedobjects[0].folder || menuselectedobjects[0].folder_id), 
							objData,  null,
							function(notDeletedLinks)			
							{				
								window.setTimeout(function() {
									triggerEvent("OX_Link_deleted");
								})
								
								//menuswitchContactView('overview');
							}	
						);
		
			
			
			//triggerEvent("OX_Direct_Linking",modulename,oIdObj)
			//menufollowLink(oFolder.data.sModule,linkedObject);
		}
		newConfirm(_("Delete Link"),_("Do you really want to delete the link?"),AlertPopup.YESNO,null,null,cbyes,null);
	}	
);
fileloaded();