/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2006 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com._4psa;


/**
 * {@link Constants} - Constants for VoipNow SOAP interface.
 * 
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class Constants {

    /**
     * No initialization.
     */
    private Constants() {
        super();
    }
    
    /**
     * <code>http://4psa.com/AccountMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_ACCOUNT_MESSAGES = "http://4psa.com/AccountMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/BillingData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_BILLING_DATA = "http://4psa.com/BillingData.xsd/" + Version.getVersion();

    /**
     *<code> http://4psa.com/BillingMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_BILLING_MESSAGES = "http://4psa.com/BillingMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/BillingMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_BILLING_MESSAGES_INFO = "http://4psa.com/BillingMessagesInfo.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ChannelData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_CHANNEL_DATA = "http://4psa.com/ChannelData.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ChannelMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_CHANNEL_MESSAGES = "http://4psa.com/ChannelMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ChannelMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_CHANNEL_MESSAGES_INFO = "http://4psa.com/ChannelMessagesInfo.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ClientData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_CLIENT_DATA = "http://4psa.com/ClientData.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ClientMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_CLIENT_MESSAGES = "http://4psa.com/ClientMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ClientMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_CLIENT_MESSAGES_INFO = "http://4psa.com/ClientMessagesInfo.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/Common.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_COMMON = "http://4psa.com/Common.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ExtensionData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_EXTENSION_DATA = "http://4psa.com/ExtensionData.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ExtensionMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_EXTENSION_MESSAGES = "http://4psa.com/ExtensionMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ExtensionMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_EXTENSION_MESSAGES_INFO = "http://4psa.com/ExtensionMessagesInfo.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/GlobalOpMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_GLOBAL_OP_MESSAGES = "http://4psa.com/GlobalOpMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/HeaderData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_HEADER_DATA = "http://4psa.com/HeaderData.xsd/" + Version.getVersion();

    /**
     *<code> http://4psa.com/PBXData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_PBX_DATA = "http://4psa.com/PBXData.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/PBXMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_PBX_MESSAGES = "http://4psa.com/PBXMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/PBXMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_PBX_MESSAGES_INFO = "http://4psa.com/PBXMessagesInfo.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ReportData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_REPORT_DATA = "http://4psa.com/ReportData.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ReportMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_REPORT_MESSAGES = "http://4psa.com/ReportMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ReportMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_REPORT_MESSAGES_INFO = "http://4psa.com/ReportMessagesInfo.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ResellerData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_RESELLER_DATA = "http://4psa.com/ResellerData.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ResellerMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_RESELLER_MESSAGES = "http://4psa.com/ResellerMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/ResellerMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_RESELLER_MESSAGES_INFO = "http://4psa.com/ResellerMessagesInfo.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/SSOData.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_SSO_DATA = "http://4psa.com/SSOData.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/SSOMessages.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_SSO_MESSAGES = "http://4psa.com/SSOMessages.xsd/" + Version.getVersion();

    /**
     * <code>http://4psa.com/SSOMessagesInfo.xsd/</code> + &lt;version&gt;
     */
    public static final String QNAME_SSO_MESSAGES_INFO = "http://4psa.com/SSOMessagesInfo.xsd/" + Version.getVersion();

}
