
# norootforbuild

Name:           open-xchange-subscribe-crawler
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant open-xchange-common >= 6.16.1.0 open-xchange-global >= 6.16.1.0 open-xchange-subscribe >= 6.16.1.0 open-xchange-server >= 6.16.1.0 open-xchange-genconf >= 6.16.1.0 open-xchange-xml >= 6.16.1.0 open-xchange-threadpool >= 6.16.1.0
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  open-xchange-xerces-ibm
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  open-xchange-xerces-sun
BuildRequires:  java-sdk-1.5.0-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%if %{?fedora_version} <= 8
BuildRequires:  java-devel-icedtea saxon
%endif
%endif
Version:	6.16.1.0
%define		ox_release 3
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Subscriptions for OXMF feeds
Requires:       open-xchange-common >= 6.16.1.0 open-xchange-global >= 6.16.1.0 open-xchange-subscribe >= 6.16.1.0 open-xchange >= 6.16.1.0 open-xchange-genconf >= 6.16.1.0 open-xchange-xml >= 6.16.1.0 open-xchange-threadpool >= 6.16.1.0
Conflicts:   open-xchange-subscribe-linkedin < 6.16.1.0
Conflicts:   open-xchange-subscribe-xing < 6.16.1.0
Obsoletes:   open-xchange-subscribe-linkedin
Obsoletes:   open-xchange-subscribe-xing
%if 0%{?sles_version} >= 10
Requires:   open-xchange-xerces-ibm
Conflicts:  open-xchange-xerces-sun
%else
Requires:   open-xchange-xerces-sun
Conflicts:  open-xchange-xerces-ibm
%endif
#

%description
Subscribe Crawler feeds
  
Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true

ant -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange install

%post

if [ ${1:-0} -eq 2 ]; then
   . /opt/open-xchange/etc/oxfunctions.sh
   ox_update_permissions "/opt/open-xchange/etc/groupware/crawlers" open-xchange:open-xchange 755
   for file in /opt/open-xchange/etc/groupware/crawlers/*; do
       ox_update_permissions "$file" open-xchange:open-xchange 644
   done
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/etc/groupware/
%dir /opt/open-xchange/bundles/
%dir /opt/open-xchange/sbin/
%dir /opt/open-xchange/etc/*/osgi/bundle.d/
%dir %attr(-,open-xchange,open-xchange) /opt/open-xchange/etc/groupware/crawlers
%config(noreplace) /opt/open-xchange/etc/groupware/*.properties
%config(noreplace) %attr(-,open-xchange,open-xchange) /opt/open-xchange/etc/groupware/crawlers/*
/opt/open-xchange/bundles/*
/opt/open-xchange/etc/*/osgi/bundle.d/*
/opt/open-xchange/sbin/*
