/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spamassassin.spamc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.Deflater;

public class Spamc {
    private static final String CURRENT_PROTOCOL_VERSION = "1.3";
    private String protocolVersion = "1.3";
    private boolean assumeBsmtp = false;
    private static final int DEFAULT_PORT = 783;
    private static final String DEFAULT_HOST = "localhost";
    private List hosts;
    private boolean randomize = false;
    private int port = 783;
    private boolean useUnixSockets = false;
    private String unixSocketPath = null;
    private boolean useSsl = false;
    private static final long DEFAULT_TIMEOUT_SECONDS = 600L;
    private long timeoutSeconds = 600L;
    private static final int DEFAULT_CONNECT_RETRIES = 3;
    private int connectRetries = 3;
    private boolean failover = true;
    private static final int DEFAULT_RETRY_SLEEP_SECONDS = 1;
    private int retrySleepSeconds = 1;
    private static final long BYTES_PER_KB = 1024L;
    private static final long DEFAULT_MAX_SIZE_BYTES = 512000L;
    private long maxSize = 512000L;
    private boolean compress = false;
    private String userName = System.getProperty("user.name");
    private static final int MIN_TCP_PORT = 0;
    private static final int MAX_TCP_PORT = 65535;
    private static final List VALID_PROTOCOL_VERSIONS = new ArrayList();
    private static final int MILLIS_PER_SECOND = 1000;
    private static final String SSL_SOCKET_FACTORY_CLASS_NAME = "SSLSocketFactory";
    private static final String CONFIG_FILE_NAME = "spamc.conf";
    private static final String SSL_PACKAGE_NAME = "javax.net.ssl";
    private static Package sslPackage;
    private static boolean useExitCode;
    private static Collection options;
    private static Map shortArgumentsMap;
    private static Map longArgumentsMap;
    private static String learnType;
    private static String reportType;

    public Spamc() {
    }

    public Spamc(List hosts) {
        this();
        this.setHosts(hosts);
    }

    public void setHost(String host) {
        if (this.hosts == null) {
            this.hosts = new ArrayList();
        } else {
            this.hosts.clear();
        }
        this.hosts.add(host);
    }

    public void setHosts(List hosts) {
        this.hosts = hosts;
    }

    public void setHosts(String[] hosts) {
        if (this.hosts == null) {
            this.hosts = new ArrayList();
        } else {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (int i = 0; i < hosts.length; ++i) {
                this.hosts.add(hosts[i]);
            }
        }
    }

    public List getHosts() {
        return this.hosts;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public boolean getRandomize() {
        return this.randomize;
    }

    public void setPort(int port) throws IllegalArgumentException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port number: " + port);
        }
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUseUnixSockets(boolean useUnixSockets) {
        if (useUnixSockets) {
            throw new IllegalArgumentException("Unix socket support is not implemented");
        }
        this.useUnixSockets = useUnixSockets;
    }

    public void setAssumeBSMTP(boolean bsmtp) {
        if (bsmtp) {
            throw new IllegalArgumentException("BSMTP support is not implemented");
        }
        this.assumeBsmtp = bsmtp;
    }

    public boolean getAssumeBSMTP() {
        return this.assumeBsmtp;
    }

    public boolean getUseUnixSockets() {
        return this.useUnixSockets;
    }

    public void setUnixSocketPath(String path) {
        this.unixSocketPath = path;
    }

    public String getUnixSocketPath() {
        return this.unixSocketPath;
    }

    public void setConnectRetries(int connectRetries) {
        this.connectRetries = connectRetries;
    }

    public int getConnectRetries() {
        return this.connectRetries;
    }

    public void setRetrySleep(int sleepSeconds) {
        this.retrySleepSeconds = sleepSeconds;
    }

    public int getRetrySleep() {
        return this.retrySleepSeconds;
    }

    public void setMaxSize(long bytes) {
        this.maxSize = bytes;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public boolean getFailover() {
        return this.failover;
    }

    public void setUseSSL(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean getUseSSL() {
        return this.useSsl;
    }

    public void setTimeout(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public long getTimeout() {
        return this.timeoutSeconds;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    private boolean isSameOrNewerProtocolVersion(String protocolVersion) throws IllegalArgumentException {
        if (protocolVersion == null) {
            throw new IllegalArgumentException("Protocol version not set");
        }
        int currentIndex = VALID_PROTOCOL_VERSIONS.indexOf(this.getProtocolVersion());
        if (currentIndex == -1) {
            throw new IllegalStateException("Invalid current protocol version:" + this.getProtocolVersion());
        }
        int checkIndex = VALID_PROTOCOL_VERSIONS.indexOf(protocolVersion);
        if (checkIndex == -1) {
            throw new IllegalArgumentException("Invalid protocol version: " + protocolVersion);
        }
        return currentIndex >= checkIndex;
    }

    private static String getSimpleClassName() {
        String className = Spamc.class.getName();
        String packageName = Spamc.class.getPackage().getName();
        return className.substring(packageName.length() + 1);
    }

    public void setProtocolVersion(String protocolVersion) throws IllegalArgumentException {
        if (protocolVersion == null || protocolVersion.length() == 0) {
            throw new IllegalArgumentException("Protocol version not set");
        }
        if (!VALID_PROTOCOL_VERSIONS.contains(protocolVersion)) {
            throw new IllegalArgumentException("Invalid protocol version: " + protocolVersion);
        }
        this.protocolVersion = protocolVersion;
        if (!this.isSameOrNewerProtocolVersion("1.4")) {
            this.setCompress(false);
        }
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setCompress(boolean compress) throws IllegalArgumentException {
        if (compress && !this.isSameOrNewerProtocolVersion("1.4")) {
            throw new IllegalArgumentException("Compression is not supported for protocol version " + this.getProtocolVersion());
        }
        this.compress = compress;
    }

    public boolean getCompress() {
        return this.compress;
    }

    private SpamdResponse sendCommand(String command) throws IOException, UnknownHostException {
        return this.sendCommand(command, null);
    }

    private SpamdResponse sendCommand(String command, String message) throws IllegalArgumentException, UnknownHostException, IOException {
        if (message == null) {
            throw new IllegalArgumentException("Message contents not set");
        }
        return this.sendCommand(command, null, message);
    }

    private String constructQuery(String command, Map headers, String message) {
        long contentLength;
        StringBuffer query = new StringBuffer();
        query.append(command);
        query.append(' ');
        query.append("SPAMC/");
        query.append(this.getProtocolVersion());
        query.append("\r\n");
        HashMap<String, String> newHeaders = new HashMap<String, String>();
        if (headers != null) {
            newHeaders.putAll(headers);
        }
        if (this.getUserName() != null && this.getUserName().length() > 0) {
            newHeaders.put("User", this.getUserName());
        }
        if (this.getCompress()) {
            newHeaders.put("Compress", "zlib");
        }
        if (message != null && message.length() > 0) {
            query.append("\r\n");
            if (this.getCompress()) {
                Deflater compresser = new Deflater();
                compresser.setInput(message.getBytes());
                compresser.finish();
                byte[] compressedMessage = new byte[message.length()];
                long contentLength2 = compresser.deflate(compressedMessage);
                throw new IllegalStateException("Compression is not supported");
            }
            contentLength = message.getBytes().length;
            query.append(message);
        } else {
            contentLength = 0L;
        }
        newHeaders.put("Content-length", Long.toString(contentLength));
        for (Map.Entry entry : newHeaders.entrySet()) {
            query.append((String)entry.getKey());
            query.append(": ");
            query.append((String)entry.getValue());
            query.append("\r\n");
        }
        return query.toString();
    }

    private SpamdResponse sendCommand(String command, Map headers, String message) throws UnknownHostException, IOException {
        String query = this.constructQuery(command, headers, message);
        return new SpamdResponse(this.getQueryResponse(query));
    }

    private List getAllHostAddresses() throws IllegalStateException, UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (this.getHosts() == null || this.getHosts().isEmpty()) {
            this.setHost(DEFAULT_HOST);
        }
        StringBuffer commaSeparatedHosts = new StringBuffer();
        for (int i = 0; i < this.getHosts().size(); ++i) {
            String host = (String)this.getHosts().get(i);
            if (i > 0) {
                commaSeparatedHosts.append(',');
            }
            commaSeparatedHosts.append(host);
            try {
                addresses.addAll(Arrays.asList(InetAddress.getAllByName(host)));
                continue;
            }
            catch (UnknownHostException e) {
                System.err.println(InetAddress.class.getName() + ".getAllByName(" + host + ") failed");
            }
        }
        if (addresses.isEmpty()) {
            throw new UnknownHostException("could not resolve any hosts (" + commaSeparatedHosts + "): no such host");
        }
        if (this.getRandomize()) {
            Collections.shuffle(addresses);
        }
        return addresses;
    }

    private Socket setupTransport() throws IOException, UnknownHostException {
        if (this.getUseUnixSockets()) {
            throw new IllegalStateException("Unix sockets are not supported");
        }
        Socket socket = new Socket();
        IOException lastException = null;
        List addresses = this.getAllHostAddresses();
        if (addresses.isEmpty()) {
            throw new IllegalStateException("No destination address");
        }
        int retryCount = 0;
        int addressIndex = 0;
        do {
            InetAddress address = (InetAddress)addresses.get(addressIndex);
            try {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(address, this.getPort());
                socket.connect(inetSocketAddress, (int)this.getTimeout() * 1000);
            }
            catch (IOException e) {
                lastException = e;
                System.err.println(Socket.class.getName() + ".connect(SocketAddress, int) to spamd at " + address + " failed, retrying (#" + ++retryCount + " of " + this.getConnectRetries() + ")");
                if (++addressIndex >= addresses.size()) {
                    addressIndex = 0;
                }
                try {
                    Thread.sleep(this.getTimeout() * 1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
        } while (this.getFailover() && socket == null && retryCount < addresses.size() && retryCount < this.getConnectRetries());
        if (socket == null) {
            System.err.println("connection attempt to spamd aborted after " + this.getConnectRetries() + " retries");
            throw lastException;
        }
        if (this.getUseSSL()) {
            if (sslPackage == null) {
                throw new IllegalStateException("SSL is not available");
            }
            try {
                Class<?> sslSocketFactory = Class.forName("javax.net.ssl.SSLSocketFactory");
                Method getDefault = sslSocketFactory.getMethod("getDefault", new Class[]{null});
                Object defaultSocketFactory = getDefault.invoke(null, new Object[]{null});
                Class[] parameterTypes = new Class[]{Socket.class, String.class, Integer.TYPE, Boolean.TYPE};
                Method createSocket = sslSocketFactory.getMethod("createSocket", parameterTypes);
                Object[] args = new Object[]{socket, socket.getInetAddress().getHostName(), new Integer(socket.getPort()), Boolean.TRUE};
                socket = (Socket)createSocket.invoke(defaultSocketFactory, args);
            }
            catch (ClassNotFoundException e) {
                IllegalStateException ise = new IllegalStateException("Class javax.net.ssl.SSLSocketFactory could not be loaded");
                ise.initCause(e);
                throw ise;
            }
            catch (NoSuchMethodException e) {
                IllegalStateException ise = new IllegalStateException(e.getMessage());
                ise.initCause(e);
                throw ise;
            }
            catch (InvocationTargetException e) {
                IllegalStateException ise = new IllegalStateException(e.getMessage());
                ise.initCause(e);
                throw ise;
            }
            catch (IllegalAccessException e) {
                IllegalStateException ise = new IllegalStateException(e.getMessage());
                ise.initCause(e);
                throw ise;
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryResponse(String query) throws UnknownHostException, IOException, IllegalStateException {
        Socket socket = this.setupTransport();
        OutputStream out = null;
        BufferedReader in = null;
        StringBuffer response = new StringBuffer();
        try {
            String s;
            out = socket.getOutputStream();
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.write(query.getBytes());
            out.flush();
            socket.shutdownOutput();
            while ((s = in.readLine()) != null) {
                response.append(s).append("\r\n");
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    public SpamdResponse check(String message) throws UnknownHostException, IOException {
        return this.sendCommand("CHECK", message);
    }

    public SpamdResponse symbols(String message) throws UnknownHostException, IOException {
        return this.sendCommand("SYMBOLS", message);
    }

    public SpamdResponse report(String message) throws UnknownHostException, IOException {
        return this.sendCommand("REPORT", message);
    }

    public SpamdResponse reportIfSpam(String message) throws UnknownHostException, IOException {
        return this.sendCommand("REPORT_IFSPAM", message);
    }

    public SpamdResponse skip(String message) throws UnknownHostException, IOException {
        return this.sendCommand("SKIP", message);
    }

    public SpamdResponse ping() throws UnknownHostException, IOException {
        return this.sendCommand("PING");
    }

    public SpamdResponse process(String message) throws UnknownHostException, IOException {
        return this.sendCommand("PROCESS", message);
    }

    public SpamdResponse tell(String message, boolean spam, boolean setLocal, boolean setRemote, boolean removeLocal, boolean removeRemote) throws IllegalArgumentException, IOException {
        if (setLocal && removeLocal) {
            throw new IllegalArgumentException("Can't both set and remove local");
        }
        if (setRemote && removeRemote) {
            throw new IllegalArgumentException("Can't both set and remove remote");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (spam) {
            headers.put("Message-class", "spam");
        } else {
            headers.put("Message-class", "ham");
        }
        StringBuffer setValue = new StringBuffer();
        StringBuffer removeValue = new StringBuffer();
        if (setLocal) {
            setValue.append("local");
        } else if (removeLocal) {
            removeValue.append("local");
        }
        if (setRemote) {
            if (setValue.length() > 0) {
                setValue.append(", ");
            }
            setValue.append("remote");
        } else if (removeRemote) {
            if (removeValue.length() > 0) {
                removeValue.append(", ");
            }
            removeValue.append("remote");
        }
        headers.put("Set", setValue.toString());
        headers.put("Remove", removeValue.toString());
        return this.sendCommand("TELL", headers, message);
    }

    public SpamdResponse headers(String message) throws UnknownHostException, IOException {
        return this.sendCommand("HEADERS", message);
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String[] combineArgs(File userConfig, String[] args) throws ConfigurationException {
        ArrayList<String> combined;
        block8: {
            File configFile;
            boolean userDefinedConfigFile;
            combined = new ArrayList<String>();
            if (userConfig == null) {
                userDefinedConfigFile = false;
                configFile = new File(CONFIG_FILE_NAME);
            } else {
                userDefinedConfigFile = true;
                configFile = userConfig;
            }
            try {
                BufferedReader reader = new BufferedReader(new FileReader(configFile));
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line.startsWith("#") || line.startsWith("\r") || line.startsWith("\n")) continue;
                    String[] tokens = line.split("\\s");
                    for (int i = 0; i < tokens.length; ++i) {
                        combined.add(tokens[i]);
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                if (!userDefinedConfigFile) break block8;
                throw new ConfigurationException("Failed to open config file: " + configFile.getPath());
            }
        }
        for (int i = 0; i < args.length; ++i) {
            combined.add(args[i]);
        }
        String[] combinedArray = new String[combined.size()];
        for (int i = 0; i < combined.size(); ++i) {
            combinedArray[i] = (String)combined.get(i);
        }
        return combinedArray;
    }

    private static void printVersion() {
        System.out.print("SpamAssassin Client version " + Spamc.class.getPackage().getImplementationVersion() + "\n");
        if (sslPackage != null) {
            System.out.print("  compiled with SSL support (" + sslPackage.getImplementationVersion() + ")\n");
        }
    }

    private static void printUsage() {
        Spamc.printVersion();
        System.out.print("\nUsage: " + Spamc.getSimpleClassName() + " [options] [" + "-e" + " command [args]] < message\n" + "\n" + "Options:\n" + "  " + "-d" + ", " + "--dest" + " host[,host2]\n" + "                      Specify one or more hosts to connect to.\n" + "                      [default: " + DEFAULT_HOST + "]\n" + "  " + "-H" + " , " + "--randomize" + "    Randomize IP addresses for the looked-up\n" + "                      hostname.\n" + "  " + "-p" + ", " + "--port" + " port     Specify port for connection to spamd.\n" + "                      [default: " + 783 + "]\n" + "  " + "-S" + ", " + "--ssl" + "           Use SSL to talk to spamd.\n" + "  " + "-U" + ", " + "--socket" + " path   Connect to spamd via UNIX domain sockets.\n" + "  " + "-F" + ", " + "--config" + " path   Use this configuration file.\n" + "  " + "-t" + ", " + "--timeout" + " timeout\n" + "                      Timeout in seconds for communications to\n" + "                      spamd. [default: " + 600L + "]\n" + "  " + "--connect-retries" + " retries\n" + "                      Try connecting to spamd this many times\n" + "                      [default: " + 3 + "]\n" + "  " + "--retry-sleep" + " sleep Sleep for this time between attempts to\n" + "                      connect to spamd, in seconds [default: " + 1 + "]\n" + "  " + "-s" + ", " + "--max-size" + " size Specify maximum message size, in bytes.\n" + "                      [default: " + 500L + "k]\n" + "  " + "-u" + ", " + "--username" + " username\n" + "                      User for spamd to process this message under.\n" + "                      [default: current user]\n" + "  " + "-L" + ", " + "--learntype" + " learntype\n" + "                      Learn message as " + "spam" + ", " + "ham" + " or " + "forget" + " to\n" + "                      forget or unlearn the message.\n" + "  " + "-C" + ", " + "--reporttype" + " reporttype\n" + "                      Report message to collaborative filtering\n" + "                      databases.  Report type should be '" + "report" + "' for\n" + "                      spam or '" + "revoke" + "' for ham.\n" + "  " + "-B" + ", " + "--bsmtp" + "         Assume input is a single BSMTP-formatted\n" + "                      message.\n" + "  " + "-c" + ", " + "--check" + "         Just print the summary line and set an exit\n" + "                      code.\n" + "  " + "-y" + ", " + "--tests" + "         Just print the names of the tests hit.\n" + "  " + "-r" + ", " + "--full-spam" + "     Print full report for messages identified as\n" + "                      spam.\n" + "  " + "-R" + ", " + "--full" + "          Print full report for all messages.\n" + "  " + "--headers" + "           Rewrite only the message headers.\n" + "  " + "-E" + ", " + "--exitcode" + "      Filter as normal, and set an exit code.\n" + "  " + "-x" + ", " + "--no-safe-fallback" + "\n" + "                      Don't fallback safely.\n" + "  " + "-l" + ", " + "--log-to-stderr" + " Log errors and warnings to stderr.\n" + "  " + "-e" + ", " + "--pipe-to" + " command [args]\n" + "                      Pipe the output to the given command instead\n" + "                      of stdout. This must be the last option.\n" + "  " + "-h" + ", " + "--help" + "          Print this help message and exit.\n" + "  " + "-V" + ", " + "--version" + "       Print spamc version and exit.\n" + "  " + "-K" + "                  Keepalive check of spamd.\n" + "  " + "-z" + "                  Compress mail message sent to spamd.\n" + "  " + "-f" + "                  (Now default, ignored.)\n" + "\n");
    }

    private static void initOptions() {
        if (options == null) {
            options = new ArrayList();
        }
        options.add(new DestinationOption());
        options.add(new RandomizeOption());
        options.add(new PortOption());
        options.add(new SSLOption());
        options.add(new SocketOption());
        options.add(new ConfigOption());
        options.add(new TimeoutOption());
        options.add(new ConnectRetriesOption());
        options.add(new RetrySleepOption());
        options.add(new MaxSizeOption());
        options.add(new UsernameOption());
        options.add(new LearnTypeOption());
        options.add(new ReportTypeOption());
        options.add(new BSMTPOption());
        options.add(new CheckOption());
        options.add(new TestsOption());
        options.add(new FullSpamOption());
        options.add(new FullOption());
        options.add(new HeadersOption());
        options.add(new ExitCodeOption());
        options.add(new NoSafeFallbackOption());
        options.add(new LogToStderrOption());
        options.add(new PipeToOption());
        options.add(new HelpOption());
        options.add(new VersionOption());
        options.add(new CompressOption());
        options.add(new KeepAliveOption());
        Iterator iterator = options.iterator();
        if (shortArgumentsMap == null) {
            shortArgumentsMap = new HashMap();
        }
        if (longArgumentsMap == null) {
            longArgumentsMap = new HashMap();
        }
        while (iterator.hasNext()) {
            AbstractOption option = (AbstractOption)iterator.next();
            if (option.getShortName() != null) {
                shortArgumentsMap.put(option.getShortName(), option);
            }
            if (option.getLongName() == null) continue;
            longArgumentsMap.put(option.getLongName(), option);
        }
    }

    private static void setLearnType(String learnType) {
        Spamc.learnType = learnType;
    }

    private static String getLearnType() {
        return learnType;
    }

    private static void setReportType(String reportType) {
        Spamc.reportType = reportType;
    }

    private static String getReportType() {
        return reportType;
    }

    private static long readArgs(Spamc spamc, String[] args) throws UsageException {
        long flags = 0x10000000L;
        if (options == null) {
            Spamc.initOptions();
        }
        String optionalArg = null;
        for (int i = 0; i < args.length; ++i) {
            optionalArg = i + 1 < args.length ? args[i + 1] : null;
            AbstractOption option = null;
            if (shortArgumentsMap.containsKey(args[i])) {
                option = (AbstractOption)shortArgumentsMap.get(args[i]);
            } else if (longArgumentsMap.containsKey(args[i])) {
                option = (AbstractOption)longArgumentsMap.get(args[i]);
            }
            if (option == null) {
                throw new OptionNotFoundException(i, args[i].length(), args[i]);
            }
            if (option.hasArgument()) {
                if (optionalArg == null) {
                    throw new NoArgumentException(i, args[i].length(), args[i]);
                }
                flags = option.apply(optionalArg, spamc, flags);
                ++i;
            } else {
                flags = option.apply(spamc, flags);
            }
            if (option.keepRunning()) continue;
            return flags;
        }
        if ((flags & 0x200000L) > 0L) {
            if ((flags & 0x20000000L) > 0L) {
                throw new UsageException("Learning excludes check only");
            }
            if ((flags & 0x80000L) > 0L) {
                throw new UsageException("Learning excludes ping");
            }
            if ((flags & 0x2000000L) > 0L) {
                throw new UsageException("Learning excludes report if spam");
            }
            if ((flags & 0x4000000L) > 0L) {
                throw new UsageException("Learning excludes report");
            }
            if ((flags & 0x1000000L) > 0L) {
                throw new UsageException("Learning excludes symbols");
            }
            if ((flags & 0x100000L) > 0L) {
                throw new UsageException("Learning excludes reporting to collaborative filtering databases");
            }
        }
        return flags;
    }

    static {
        VALID_PROTOCOL_VERSIONS.add("1.0");
        VALID_PROTOCOL_VERSIONS.add("1.1");
        VALID_PROTOCOL_VERSIONS.add("1.2");
        VALID_PROTOCOL_VERSIONS.add(CURRENT_PROTOCOL_VERSION);
        try {
            Class.forName("javax.net.ssl.SSLContext");
            sslPackage = Package.getPackage(SSL_PACKAGE_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        useExitCode = false;
        options = null;
        shortArgumentsMap = null;
        longArgumentsMap = null;
        learnType = null;
        reportType = null;
    }

    public static class ExitCodes {
        public static final int EX_OK = 0;
        public static final int EX__BASE = 64;
        public static final int EX_USAGE = 64;
        public static final int EX_DATAERR = 65;
        public static final int EX_NOINPUT = 66;
        public static final int EX_NOUSER = 67;
        public static final int EX_NOHOST = 68;
        public static final int EX_UNAVAILABLE = 69;
        public static final int EX_SOFTWARE = 70;
        public static final int EX_OSERR = 71;
        public static final int EX_OSFILE = 72;
        public static final int EX_CANTCREAT = 73;
        public static final int EX_IOERR = 74;
        public static final int EX_TEMPFAIL = 75;
        public static final int EX_PROTOCOL = 76;
        public static final int EX_NOPERM = 77;
        public static final int EX_CONFIG = 78;
        public static final int EX_NOTSPAM = 0;
        public static final int EX_ISSPAM = 1;
        public static final int EX_TOOBIG = 866;
    }

    private static class NoArgumentException
    extends ArgumentUsageException {
        private String option;

        protected NoArgumentException() {
        }

        protected NoArgumentException(int argumentIndex, int charIndex, String option) {
            super(argumentIndex, charIndex);
            this.option = option;
            while (this.option.charAt(0) == '-') {
                this.option = this.option.substring(1);
            }
        }

        public String getMessage() {
            return this.getMessagePrefix() + "no argument for option " + this.option;
        }
    }

    private static class OptionNotFoundException
    extends ArgumentUsageException {
        private String option;

        protected OptionNotFoundException(int argumentIndex, int charIndex, String option) {
            super(argumentIndex, charIndex);
            this.option = option;
            while (this.option.charAt(0) == '-') {
                this.option = this.option.substring(1);
            }
        }

        public String getMessage() {
            return this.getMessagePrefix() + "option not found " + this.option;
        }
    }

    private static class ArgumentUsageException
    extends UsageException {
        private int argumentIndex = -1;
        private int charIndex = -1;
        private String message = "";

        protected ArgumentUsageException() {
        }

        protected ArgumentUsageException(int argumentIndex, int charIndex) {
            this.argumentIndex = argumentIndex;
            this.charIndex = charIndex;
        }

        protected ArgumentUsageException(int argumentIndex, int charIndex, String message) {
            this(argumentIndex, charIndex);
            this.message = message;
        }

        protected String getMessagePrefix() {
            return "Error in argument " + (this.argumentIndex + 1) + ", char " + (this.charIndex + 1) + ": ";
        }

        public String getMessage() {
            return this.getMessagePrefix() + this.message;
        }
    }

    private static class UsageException
    extends Exception {
        protected UsageException() {
        }

        protected UsageException(String message) {
            super(message);
        }
    }

    private static class KeepAliveOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-K";
        protected static final long FLAG = 524288L;

        protected KeepAliveOption() {
            super(SHORT_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            return flags | 0x80000L;
        }
    }

    private static class SafeFallbackOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-f";
        protected static final long FLAG = 0x10000000L;

        protected SafeFallbackOption() {
            super(SHORT_ARG, false);
        }
    }

    private static class CompressOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-z";
        protected static final long FLAG = 65536L;

        protected CompressOption() {
            super(SHORT_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            spamc.setCompress(true);
            return flags | 0x10000L;
        }
    }

    private static class HelpOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-h";
        private static final String LONG_ARG = "--help";

        protected HelpOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected void apply(Spamc ignored) {
            Spamc.printUsage();
        }

        protected boolean keepRunning() {
            return false;
        }
    }

    private static class VersionOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-V";
        private static final String LONG_ARG = "--version";

        protected VersionOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected void apply(Spamc ignored) {
            Spamc.printVersion();
        }

        protected boolean keepRunning() {
            return false;
        }
    }

    private static class PipeToOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-e";
        private static final String LONG_ARG = "--pipe-to";

        protected PipeToOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }
    }

    private static class LogToStderrOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-l";
        private static final String LONG_ARG = "--log-to-stderr";
        protected static final long FLAG = 0x400000L;

        protected LogToStderrOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            return flags | 0x400000L;
        }
    }

    private static class NoSafeFallbackOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-x";
        private static final String LONG_ARG = "--no-safe-fallback";

        protected NoSafeFallbackOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            return flags & 0xFFFFFFFFEFFFFFFFL;
        }
    }

    private static class ExitCodeOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-E";
        private static final String LONG_ARG = "--exitcode";

        protected ExitCodeOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected void apply(Spamc spamc) {
            useExitCode = true;
        }
    }

    private static class HeadersOption
    extends AbstractOption {
        private static final String LONG_ARG = "--headers";
        protected static final long FLAG = 32768L;

        protected HeadersOption() {
            super(LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            return flags | 0x8000L;
        }
    }

    private static class FullOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-R";
        private static final String LONG_ARG = "--full";
        protected static final long FLAG = 0x4000000L;

        protected FullOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            return flags | 0x4000000L;
        }
    }

    private static class FullSpamOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-r";
        private static final String LONG_ARG = "--full-spam";
        protected static final long FLAG = 0x2000000L;

        protected FullSpamOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            return flags | 0x2000000L;
        }
    }

    private static class TestsOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-y";
        private static final String LONG_ARG = "--tests";
        private static final long FLAG = 0x1000000L;

        protected TestsOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            return flags | 0x1000000L;
        }
    }

    private static class CheckOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-c";
        private static final String LONG_ARG = "--check";
        protected static final long FLAG = 0x20000000L;

        protected CheckOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            useExitCode = true;
            return flags | 0x20000000L;
        }
    }

    private static class BSMTPOption
    extends AbstractOption {
        private static final String BSMTP_1 = "-B";
        private static final String BSMTP_2 = "--bsmtp";
        private static final long FLAG = 1L;

        protected BSMTPOption() {
            super(BSMTP_1, BSMTP_2, false);
        }

        protected void apply(Spamc spamc) {
            spamc.setAssumeBSMTP(true);
        }

        protected long getFlag() {
            return 1L;
        }
    }

    private static class ReportTypeOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-C";
        private static final String LONG_ARG = "--reporttype";
        private static final String REPORT = "report";
        private static final String REVOKE = "revoke";
        protected static final long FLAG = 0x100000L;

        protected ReportTypeOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String reportType, Spamc spamc, long flags) throws UsageException {
            long newFlags = super.apply(reportType, spamc, flags);
            if (!REPORT.equals(reportType) && !REVOKE.equals(reportType)) {
                throw new UsageException("Please specifiy a legal report type");
            }
            Spamc.setReportType(reportType);
            return newFlags | 0x100000L;
        }
    }

    private static class LearnTypeOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-L";
        private static final String LONG_ARG = "--learntype";
        private static final String FORGET = "forget";
        private static final String HAM = "ham";
        private static final String SPAM = "spam";
        protected static final long FLAG = 0x200000L;

        protected LearnTypeOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String learntype, Spamc spamc, long flags) throws UsageException {
            long newFlags = super.apply(learntype, spamc, flags);
            if (!(SPAM.equals(learntype) || HAM.equals(learntype) || FORGET.equals(learntype))) {
                throw new UsageException("Please specifiy a legal learn type");
            }
            Spamc.setLearnType(learntype);
            return newFlags | 0x200000L;
        }
    }

    private static class UsernameOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-u";
        private static final String LONG_ARG = "--username";

        protected UsernameOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String userName, Spamc spamc, long flags) throws UsageException {
            super.apply(userName, spamc, flags);
            spamc.setUserName(userName);
            return flags;
        }
    }

    private static class MaxSizeOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-s";
        private static final String LONG_ARG = "--max-size";

        protected MaxSizeOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String size, Spamc spamc, long flags) throws UsageException {
            super.apply(size, spamc, flags);
            spamc.setMaxSize(Long.parseLong(size));
            return flags;
        }
    }

    private static class RetrySleepOption
    extends AbstractOption {
        private static final String LONG_ARG = "--retry-sleep";

        protected RetrySleepOption() {
            super(LONG_ARG, true);
        }

        protected long apply(String sleep, Spamc spamc, long flags) throws UsageException {
            super.apply(sleep, spamc, flags);
            spamc.setRetrySleep(Integer.parseInt(sleep));
            return flags;
        }
    }

    private static class ConnectRetriesOption
    extends AbstractOption {
        private static final String LONG_ARG = "--connect-retries";

        protected ConnectRetriesOption() {
            super(LONG_ARG, true);
        }

        protected long apply(String retries, Spamc spamc, long flags) throws UsageException {
            super.apply(retries, spamc, flags);
            spamc.setConnectRetries(Integer.parseInt(retries));
            return flags;
        }
    }

    private static class TimeoutOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-t";
        private static final String LONG_ARG = "--timeout";

        protected TimeoutOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String timeout, Spamc spamc, long flags) throws UsageException {
            super.apply(timeout, spamc, flags);
            spamc.setTimeout(Integer.parseInt(timeout));
            return flags;
        }
    }

    private static class ConfigOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-F";
        private static final String LONG_ARG = "--config";

        protected ConfigOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }
    }

    private static class SocketOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-U";
        private static final String LONG_ARG = "--socket";

        protected SocketOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String path, Spamc spamc, long flags) throws UsageException {
            super.apply(path, spamc, flags);
            spamc.setUseUnixSockets(true);
            spamc.setUnixSocketPath(path);
            return flags;
        }
    }

    private static class SSLOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-S";
        private static final String LONG_ARG = "--ssl";
        private static final long FLAG = 0x8000000L;

        protected SSLOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) {
            spamc.setUseSSL(true);
            return flags | 0x8000000L;
        }
    }

    private static class PortOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-p";
        private static final String LONG_ARG = "--port";

        protected PortOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String port, Spamc spamc, long flags) throws UsageException {
            long newFlags = super.apply(port, spamc, flags);
            spamc.setPort(Integer.parseInt(port));
            return newFlags;
        }
    }

    private static class RandomizeOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-H";
        private static final String LONG_ARG = "--randomize";
        private static final long FLAG = 0x800000L;

        protected RandomizeOption() {
            super(SHORT_ARG, LONG_ARG, false);
        }

        protected long apply(Spamc spamc, long flags) throws UsageException {
            long newFlags = super.apply(spamc, flags);
            spamc.setRandomize(true);
            return newFlags;
        }
    }

    private static class DestinationOption
    extends AbstractOption {
        private static final String SHORT_ARG = "-d";
        private static final String LONG_ARG = "--dest";

        protected DestinationOption() {
            super(SHORT_ARG, LONG_ARG, true);
        }

        protected long apply(String hosts, Spamc spamc, long flags) throws UsageException {
            long newFlags = super.apply(hosts, spamc, flags);
            String[] splitHosts = hosts.split(",");
            spamc.setHosts(splitHosts);
            return newFlags;
        }
    }

    private static abstract class AbstractOption {
        protected static final String SHORT_ARG = null;
        protected static final String LONG_ARG = null;
        private String shortName;
        private String longName;
        private boolean hasArgument;

        protected AbstractOption(String longName, boolean hasArgument) {
            this.longName = longName;
            this.hasArgument = hasArgument;
        }

        protected AbstractOption(String shortName, String longName, boolean hasArgument) {
            this(longName, hasArgument);
            this.shortName = shortName;
        }

        protected String getShortName() {
            return this.shortName;
        }

        protected String getLongName() {
            return this.longName;
        }

        protected boolean hasArgument() {
            return this.hasArgument;
        }

        protected long apply(Spamc spamc, long flags) throws UsageException {
            return flags;
        }

        protected long apply(String argument, Spamc spamc, long flags) throws UsageException {
            if (this.hasArgument() && (argument == null || argument.trim().length() == 0)) {
                throw new NoArgumentException();
            }
            return flags;
        }

        protected boolean keepRunning() {
            return true;
        }
    }

    private static class ConfigurationException
    extends Exception {
        protected ConfigurationException(String message) {
            super(message);
        }

        public static int getExitCode() {
            return 78;
        }
    }

    private static class Headers {
        private static final String MESSAGE_CLASS = "Message-class";
        private static final String MESSAGE_CLASS_SPAM = "spam";
        private static final String MESSAGE_CLASS_HAM = "ham";
        private static final String SET = "Set";
        private static final String REMOVE = "Remove";
        private static final String SET_REMOVE_LOCAL = "local";
        private static final String SET_REMOVE_REMOTE = "remote";
        private static final String CONTENT_LENGTH = "Content-length";
        private static final String SPAM = "Spam";
        private static final String USER = "User";
        private static final String COMPRESS = "Compress";
        private static final String ZLIB = "zlib";

        private Headers() {
        }
    }

    public static class ProtocolVersions {
        public static final String V1_0 = "1.0";
        public static final String V1_1 = "1.1";
        public static final String V1_2 = "1.2";
        public static final String V1_3 = "1.3";
        public static final String V1_4 = "1.4";
    }

    public class SpamdResponse {
        private String rawResponse;
        private String protocolVersion;
        private int responseCode;
        private String responseMessage;
        private Map headers = new HashMap();
        private String processedMessage;
        private final Pattern firstLinePattern = Pattern.compile("^SPAMD/\\d+\\.\\d+\\s+\\d+.*");

        protected SpamdResponse(String response) throws IllegalArgumentException {
            this.rawResponse = response;
            if (response == null) {
                throw new IllegalArgumentException("Response not set");
            }
            String[] lines = response.split("\r\n");
            if (!this.firstLinePattern.matcher(lines[0]).matches()) {
                throw new IllegalArgumentException("Invalid first response line: " + lines[0]);
            }
            this.parseFirstLine(lines[0]);
            StringBuffer processedMessage = new StringBuffer();
            for (int lineIndex = this.parseHeaders(lines); lineIndex < lines.length; ++lineIndex) {
                processedMessage.append(lines[lineIndex]).append("\r\n");
            }
            this.processedMessage = processedMessage.toString();
        }

        private final void parseFirstLine(String firstLine) {
            String[] words = firstLine.split("\\s", 3);
            this.protocolVersion = words[0].substring(words[0].indexOf(47) + 1);
            this.responseCode = Integer.parseInt(words[1]);
            this.responseMessage = words[2];
        }

        private final int parseHeaders(String[] lines) {
            int colonPosition;
            int i;
            for (i = 1; i < lines.length && (colonPosition = lines[i].indexOf(58)) != -1; ++i) {
                String name = lines[i].substring(0, colonPosition);
                String value = lines[i].substring(colonPosition + 1).trim();
                this.headers.put(name, value);
            }
            return ++i;
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        public CharSequence getRawResponse() {
            return this.rawResponse;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public CharSequence getResponseMessage() {
            return this.responseMessage;
        }

        public String getProcessedMessage() {
            return this.processedMessage;
        }

        public Map getHeaders() {
            return this.headers;
        }

        private String getSpamHeaderValue() {
            return (String)this.getHeaders().get("Spam");
        }

        public boolean isSpam() {
            String spamHeaderValue = this.getSpamHeaderValue();
            if (spamHeaderValue == null) {
                return false;
            }
            return spamHeaderValue.startsWith("True");
        }

        public double getScore() throws NumberFormatException {
            String spamHeaderValue = this.getSpamHeaderValue();
            if (spamHeaderValue == null) {
                return 0.0;
            }
            int semicolonPosition = spamHeaderValue.indexOf(59);
            if (semicolonPosition == -1) {
                return 0.0;
            }
            int slashPosition = spamHeaderValue.indexOf(47);
            if (slashPosition == -1) {
                slashPosition = spamHeaderValue.length();
            }
            String score = spamHeaderValue.substring(semicolonPosition + 1, slashPosition).trim();
            return Double.parseDouble(score);
        }

        public double getThreshold() throws NumberFormatException {
            String spamHeaderValue = this.getSpamHeaderValue();
            if (spamHeaderValue == null) {
                return 0.0;
            }
            int slashPosition = spamHeaderValue.indexOf(47);
            if (slashPosition == -1) {
                return 0.0;
            }
            String threshold = spamHeaderValue.substring(slashPosition + 1).trim();
            return Double.parseDouble(threshold);
        }
    }

    private static class Commands {
        protected static final String CHECK = "CHECK";
        protected static final String SYMBOLS = "SYMBOLS";
        protected static final String REPORT = "REPORT";
        protected static final String REPORT_IFSPAM = "REPORT_IFSPAM";
        protected static final String SKIP = "SKIP";
        protected static final String PING = "PING";
        protected static final String PROCESS = "PROCESS";
        protected static final String TELL = "TELL";
        protected static final String HEADERS = "HEADERS";

        private Commands() {
        }
    }
}

