/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.groupware.tx.osgi;

import java.sql.Connection;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tx.DBProvider;
import com.openexchange.groupware.tx.TransactionException;
import com.openexchange.server.osgiservice.WhiteboardFactoryService;
import com.openexchange.tools.global.OXCloseable;

/**
 * {@link WhiteboardDBProvider}
 * 
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
public class WhiteboardDBProvider implements DBProvider{

    
    public static class Factory implements WhiteboardFactoryService<DBProvider> {

        public DBProvider create(BundleContext context, Collection<OXCloseable> closeables) {
            WhiteboardDBProvider provider = new WhiteboardDBProvider(context);
            return provider;
        }

        public Class<DBProvider> getType() {
            return DBProvider.class;
        }

    }

    private BundleContext context;

    public WhiteboardDBProvider(BundleContext context) {
        this.context = context;
    }

    public Connection getReadConnection(Context ctx) throws TransactionException {
        DBProvider provider = null;
        ServiceReference reference = null;
        try {
            reference = getReference();
            provider = getProvider(reference);
            return provider.getReadConnection(ctx);
        } finally {
            releaseProvider(reference);
        }
    }

    public Connection getWriteConnection(Context ctx) throws TransactionException {
        DBProvider provider = null;
        ServiceReference reference = null;
        try {
            reference = getReference();
            provider = getProvider(reference);
            return provider.getWriteConnection(ctx);
        } finally {
            releaseProvider(reference);
        }
    }

    public void releaseReadConnection(Context ctx, Connection con) {
        DBProvider provider = null;
        ServiceReference reference = null;
        try {
            reference = getReference();
            provider = getProvider(reference);
            provider.releaseReadConnection(ctx, con);
        } finally {
            releaseProvider(reference);
        }
    }

    public void releaseWriteConnection(Context ctx, Connection con) {
        DBProvider provider = null;
        ServiceReference reference = null;
        try {
            reference = getReference();
            provider = getProvider(reference);
            provider.releaseWriteConnection(ctx, con);
        } finally {
            releaseProvider(reference);
        }
    }

    private void releaseProvider(ServiceReference reference) {
        context.ungetService(reference);
    }

    private DBProvider getProvider(ServiceReference reference) {
        return (DBProvider) context.getService(reference);
    }

    private ServiceReference getReference() {
        return context.getServiceReference(DBProvider.class.getName());
    }

}
