/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.session.Session;

/**
 * {@link SimMessagingService}
 * 
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public class SimMessagingService implements MessagingService {

 
    private String displayName;

    private DynamicFormDescription formDescription;

    private String id;

    private final Map<Integer, MessagingAccountAccess> accountAccessMap;

    private final Map<Integer, MessagingAccountTransport> accountTransportMap;

    private MessagingAccountManager accManager;

    private List<MessagingAction> capabilities;

    public SimMessagingService() {
        super();
        accountAccessMap = new HashMap<Integer, MessagingAccountAccess>();
        accountTransportMap = new HashMap<Integer, MessagingAccountTransport>();
    }

    public MessagingAccountManager getAccountManager() {
        return accManager;
    }

    public List<MessagingAction> getMessageActions() {
        return capabilities;
    }

    public String getDisplayName() {
        return displayName;
    }

    public DynamicFormDescription getFormDescription() {
        return formDescription;
    }

    public String getId() {
        return id;
    }

    public void setMessageActions(final List<MessagingAction> capabilities) {
        this.capabilities = capabilities;
    }

    public void setDisplayName(final String displayName) {
        this.displayName = displayName;
    }

    public void setFormDescription(final DynamicFormDescription formDescription) {
        this.formDescription = formDescription;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public void setAccountManager(final MessagingAccountManager accManager) {
        this.accManager = accManager;
    }

    public MessagingAccountAccess getAccountAccess(final int accountId, final Session session) throws MessagingException {
        final MessagingAccountAccess accountAccess = accountAccessMap.get(Integer.valueOf(accountId));
        if (null == accountAccess) {
            // TODO: Throw appropriate error
        }
        return accountAccess;
    }

    public void setAccountAccess(final int accountId, final MessagingAccountAccess accountAccess) {
        accountAccessMap.put(Integer.valueOf(accountId), accountAccess);
    }

    public MessagingAccountTransport getAccountTransport(final int accountId, final Session session) throws MessagingException {
        final MessagingAccountTransport accountTransport = accountTransportMap.get(Integer.valueOf(accountId));
        if (null == accountTransport) {
            // TODO: Throw appropriate error
        }
        return accountTransport;
    }

    public void setAccountTransport(final int accountId, final MessagingAccountTransport accountTransport) {
        accountTransportMap.put(Integer.valueOf(accountId), accountTransport);
    }

}
