/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.freeutils.charset.EscapedByteLookupCharset;
import net.freeutils.charset.GSMCharset;

public class PackedGSMCharset
extends GSMCharset {
    static final int BUFFER_SIZE = 256;

    protected PackedGSMCharset(String canonicalName, String[] aliases, int[] byteToChar, int[] byteToCharEscaped, int[][] charToByte, int[][] charToByteEscaped) {
        super(canonicalName, aliases, byteToChar, byteToCharEscaped, charToByte, charToByteEscaped);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder((Charset)this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder((Charset)this);
    }

    public static byte[] unpack(byte[] in) {
        byte[] out = new byte[in.length * 8 / 7];
        int len = out.length;
        int current = 0;
        int bitpos = 0;
        for (int i = 0; i < len; ++i) {
            out[i] = (byte)((in[current] & 0xFF) >> bitpos & 0x7F);
            if (bitpos >= 2) {
                int n = i;
                out[n] = (byte)(out[n] | (byte)(in[++current] << 8 - bitpos & 0x7F));
            }
            if ((bitpos = (bitpos + 7) % 8) != 0) continue;
            ++current;
        }
        if (len % 8 == 0 && len > 0 && out[len - 1] == 0) {
            byte[] fixed = new byte[len - 1];
            System.arraycopy(out, 0, fixed, 0, len - 1);
            out = fixed;
        }
        return out;
    }

    public static byte[] pack(byte[] in) {
        byte[] out = new byte[(int)Math.ceil((float)(in.length * 7) / 8.0f)];
        int len = in.length;
        int current = 0;
        int bitpos = 0;
        for (int i = 0; i < len; ++i) {
            byte b = (byte)(in[i] & 0x7F);
            int n = current++;
            out[n] = (byte)(out[n] | (byte)((b & 0xFF) << bitpos));
            if (bitpos >= 2) {
                int n2 = current;
                out[n2] = (byte)(out[n2] | b >> 8 - bitpos);
            }
            if ((bitpos = (bitpos + 7) % 8) != 0) continue;
            ++current;
        }
        return out;
    }

    protected class Decoder
    extends EscapedByteLookupCharset.Decoder {
        int bitpos;
        byte current;
        int unpackedCount;
        ByteBuffer buf;

        protected Decoder(Charset cs) {
            super(cs, 1.1428572f, 2.0f);
            this.buf = ByteBuffer.allocate(256);
            this.implReset();
        }

        protected void implReset() {
            this.bitpos = 0;
            this.current = 0;
            this.unpackedCount = 0;
            this.buf.limit(0);
        }

        protected CoderResult implFlush(CharBuffer out) {
            int pos;
            if (this.unpackedCount % 8 == 0 && (pos = out.position()) > 0 && out.get(pos - 1) == '@') {
                out.position(pos - 1);
            }
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (true) {
                CoderResult result;
                if (this.buf.hasRemaining()) {
                    result = super.decodeLoop(this.buf, out);
                    if (this.buf.hasRemaining() || result.isError()) {
                        return result;
                    }
                }
                this.buf.clear();
                result = this.unpack(in, this.buf);
                this.buf.flip();
                if (!this.buf.hasRemaining()) {
                    return result;
                }
                this.unpackedCount += this.buf.remaining();
            }
        }

        protected CoderResult unpack(ByteBuffer in, ByteBuffer out) {
            int remaining = out.remaining();
            while (remaining-- > 0) {
                if (!in.hasRemaining() && this.bitpos != 1) {
                    return CoderResult.UNDERFLOW;
                }
                if (this.bitpos == 0) {
                    this.current = in.get();
                }
                byte b = (byte)((this.current & 0xFF) >> this.bitpos & 0x7F);
                if (this.bitpos >= 2) {
                    this.current = in.get();
                    b = (byte)(b | (byte)(this.current << 8 - this.bitpos & 0x7F));
                }
                this.bitpos = (this.bitpos + 7) % 8;
                out.put(b);
            }
            return CoderResult.OVERFLOW;
        }
    }

    protected class Encoder
    extends EscapedByteLookupCharset.Encoder {
        int bitpos;
        byte current;
        ByteBuffer buf;

        protected Encoder(Charset cs) {
            super(cs, 0.875f, 2.0f);
            this.buf = ByteBuffer.allocate(256);
            this.implReset();
        }

        protected void implReset() {
            this.bitpos = 0;
            this.current = 0;
            this.buf.limit(0);
        }

        protected CoderResult implFlush(ByteBuffer out) {
            CoderResult result = this.pack(this.buf, out);
            if (this.bitpos != 0) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.current);
            }
            return result;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            CoderResult result;
            do {
                if (this.buf.hasRemaining() && (result = this.pack(this.buf, out)) == CoderResult.OVERFLOW) {
                    return result;
                }
                this.buf.clear();
                result = super.encodeLoop(in, this.buf);
                this.buf.flip();
            } while (this.buf.hasRemaining() && !result.isError());
            return result;
        }

        protected CoderResult pack(ByteBuffer in, ByteBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                byte b = (byte)(in.get() & 0x7F);
                this.current = (byte)(this.current | (byte)((b & 0xFF) << this.bitpos));
                if (this.bitpos >= 2) {
                    out.put(this.current);
                    this.current = 0;
                    this.current = (byte)(this.current | b >> 8 - this.bitpos);
                }
                this.bitpos = (this.bitpos + 7) % 8;
                if (this.bitpos != 0) continue;
                out.put(this.current);
                this.current = 0;
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

