
# norootforbuild
%define         configfiles     configfiles.list
%define 	brokenrhino	""

Name:           open-xchange-gui
BuildArch: 	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant ant-nodeps ant-apache-regexp ant-trax gettext-devel
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%define 	brokenrhino	"-DhasBrokenRhino=true"
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-1.5.0-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%define 	brokenrhino	"-DhasBrokenRhino=true"
%endif
%if %{?fedora_version} <= 8
BuildRequires:  java-devel-icedtea saxon
%endif
%endif
Version:	6.16.1.0
%define		ox_release 3
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        Creative Commons Attribution-Noncommercial-Share Alike 2.5 Generic
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Package containing the AJAX gui
%if 0%{?suse_version}
Requires:	apache2
%endif
%if 0%{?fedora_version} || 0%{?rhel_version}
Requires:	httpd
%endif
Requires:	open-xchange-gui-theme-default
#

#----------------------------------------------------------------------
%package -n     open-xchange-gui-themes-default
Group:          Applications/Productivity
Summary:        Package containing the default themes
Requires:	open-xchange-gui
Provides:	open-xchange-gui-theme-default

%description -n open-xchange-gui-themes-default
Package containing the default themes

Authors:
--------
    Open-Xchange

%package -n     open-xchange-themes-default
Group:          Applications/Productivity
Summary:        Package containing the default themes
Requires:	open-xchange-settings-extensions, open-xchange-common
Provides:	open-xchange-theme-default

%description -n open-xchange-themes-default
Package containing the default themes

Authors:
--------
    Open-Xchange


%description
Package containing the AJAX gui

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif

export ANT_OPTS="-Dfile.encoding=UTF-8 -Djavax.xml.transform.TransformerFactory=net.sf.saxon.TransformerFactoryImpl"
ant %{brokenrhino} -lib lib -Ddestdir=%{buildroot} -Dhtdoc=%{docroot}/ox6 -Dhelplocation=help install
ant %{brokenrhino} -lib lib -Ddestdir=%{buildroot} -Dhtdoc=%{docroot}/ox6 -Dhelplocation=help install-themes

rm -f %{configfiles}
find %{buildroot}/%{docroot}/ox6 -type f -not -name languages.js -printf '"%p"\n' > %{configfiles}
perl -pi -e 's;%{buildroot}/;;' %{configfiles}


%post -n open-xchange-themes-default
if [ ${1:-0} -eq 1 ]; then
	. /opt/open-xchange/etc/oxfunctions.sh
	pfile=/opt/open-xchange/etc/groupware/settings/themes.properties
	if ! ox_exists_property "modules/themes/default" $pfile; then
		ox_set_property "modules/themes/default" "Cool Water (Default)" $pfile
	fi
	if ! ox_exists_property "modules/themes/light_breeze" $pfile; then
		ox_set_property "modules/themes/light_breeze" "Light Breeze" $pfile
	fi
fi

%postun -n open-xchange-themes-default
if [ ${1:-0} -eq 0 ]; then
	. /opt/open-xchange/etc/oxfunctions.sh
	pfile=/opt/open-xchange/etc/groupware/settings/themes.properties
	ox_remove_property "modules/themes/default" $pfile
	ox_remove_property "modules/themes/light_breeze" $pfile
fi

%clean
%{__rm} -rf %{buildroot}

%files -f %{configfiles}
%defattr(-,root,root)
%dir %{docroot}/ox6
%config(noreplace) %{docroot}/ox6/lang/languages.js
%doc ChangeLog

%files -n open-xchange-gui-themes-default
%defattr(-,root,root)
%{docroot}/ox6/themes/default
%{docroot}/ox6/themes/light_breeze

%files -n open-xchange-themes-default
%defattr(-,root,root)
%doc ChangeLog

%changelog
* Wed Apr 14 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15774 : [L3] Inconsistent field names in personal settings in wizard and GUI setup area
  - Fixed bug #15885 : Phone (private) combobox cannot be changed at contact detail view
* Tue Apr 13 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15686 : [L3] Spam mails aren't moved to Spam folder in gmail Account
  - Fixed bug #15702 : [L3] Overlapping publication/subscription dialogue menu
* Tue Apr 06 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15703 : [L3] - "Change confirmation" button has no effect in shared calendar
* Thu Mar 25 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15648 : [L3] unified inbox can not be set for the primary email account with the checkbox in the mail accounts list
  - Fixed bug #15649 : [L3] unified inbox error: Das Pflichtfeld Login wurde nicht festgelegt
* Fri Mar 12 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15591 : gui plugin cannot change window title
* Wed Mar 10 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15564 : Window does not close when create/edit an appointment in team view
  - Fixed bug #15565 : Unable to delete appointments in team view
* Fri Mar 05 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15552 : Double click on minicalendar throws JS error
  - Fixed bug #15290 : Problem with calendar folders with "/" character
* Thu Mar 04 2010 - stefan.preuss@open-xchange.com
  - TA2797 for US4225 : Implement H-Split for RSS-Feed messages
* Thu Mar 04 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15547 : unable to login with IE7
* Wed Mar 03 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15521 : Twitter links don't work when the corresponding tweet is selected
  - Fixed bug #15536 : Printing a single mail in list-view prints only the headers
  - Fixed bug #15535 : Google Chrome must not trigger a warning
  - Fixed bug #12020 : Passwordchange does not show a (error) message when one password field is empty
* Wed Mar 03 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15518 : Facebook messaging popup does not post anything when calling it through the context menu
  - Fixed bug #14258 : Multimail panel headline shows "Rules" at the action part
  - Fixed bug #15534 : External participants status not shown in Hover
* Tue Mar 02 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15533 : Print function in Mail Module
  - Fixed the wrong selected sender address when replying to a message out of a unified folder
* Mon Mar 01 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15280 : Unable to expand folder tree
  - Fixed bug #15482 : Facebook messaging "post" triggers js error
  - Fixed bug #15496 : [Dev] Only send incremental updates for generic forms
  - Fixed bug #15489 : No visual feedback when accepting/declining an invitation E-Mail
* Mon Mar 01 2010 - stefan.preuss@open-xchange.com
  - TA2742 for US4190 : Hyperlinks in Twitter and Facebook messages should be clickable
  - Fixed bug #15473 : Some RSS feeds are shown with 1970-01-01 as publishing date
* Fri Feb 26 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15483 : No Real Names displayed in Participant search
  - Fixed bug #15235 : Appointments need to be marked first (lmb), before you can open the context menu via the rmb
* Fri Feb 26 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15488 : Display of the "This mail contains an invitation to an appointment." field only works when HTML E-Mails are allowed
  - Added an orange label "Preview" to the messaging configuration node.
  - Fixed bug #15498 : [Dev] OXCache crashes when a list request returns an error.
* Wed Feb 24 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15310 : Grid shows mails from a different folder
* Tue Feb 23 2010 - matthias.biggeleben@open-xchange.com
  - Fixed bug #15436 : Moving an appointment by dragging it onto the mini calendar leads to incorrect results
  - Fixed bug #15368 : Large black cursor shown for a short while in E-Mail
  - Fixed bug #15435 : [Safari] Pasting content in new mail windows causes error message
  - Fixed bug #14472 : [L3] Tasks: Mysterious footer information after marking a task as done
  - Fixed bug #15111 : Autogenerated mail content is added below default signatures
* Tue Feb 23 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15352 : [L3] When adding external participants to appointments with IDN-domains a warning is shown
* Mon Feb 22 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #12161 : Calendar: Selection in mini calendar not updated when changing the week in mini calendar
  - Fixed bug #15299 : Exception thrown when moving an appointment in calendar list view
* Mon Feb 22 2010 - matthias.biggeleben@open-xchange.com
  - Fixed bug #15155 : Unable to change start date of a recurring appointment
* Fri Feb 19 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #14883 : Infostore "Version" grid does not update after adding another version
* Fri Feb 19 2010 - viktor.pracht@open-xchange.com
  - Added messaging folder icons to both themes.
* Thu Feb 18 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15388 : Decline comments from one appt appear in other appt
* Thu Feb 18 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15411 :  IE7: No scrollbars shown on overlay foldertrees
* Wed Feb 17 2010 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14472 : [L3] Tasks: Mysterious footer information after marking a task as done
  - Fixed bug #15284 : [L3] Task reminder pops up after every login attempt
* Wed Feb 17 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15357 : [L3] App. can not be saved in format "tt-MMM-jj"
  - Fixed bug #15370 : Missing dependency for open-xchange-messaging-json
* Tue Feb 16 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15286 : E-Mail Hover don't work anymore
  - Fixed bug #15080 : [L3] IE7 icons stay on the screen after moving email
  - Fixed bug #15141 : [L3] Security warning in IE7/IE8 when creating a new window in OX GUI
* Tue Feb 16 2010 - matthias.biggeleben@open-xchange.com
  - Fixed bug #15155 : Unable to change start date of a recurring appointment
* Mon Feb 15 2010 - viktor.pracht@open-xchange.com
  - TA2506 for US3998 : [iCal] Extend GUI to handle incoming iMIP requests
* Fri Feb 12 2010 - viktor.pracht@open-xchange.com
  - TA2573 for US4135 : [Social Messaging] GUI implementation
  - Fixed bug #15203 : Private folders do not work when no imap server is available
* Thu Feb 11 2010 - matthias.biggeleben@open-xchange.com
  - TA2581 for US4138 : Implement fine-coarsed time grid (up to 5min)
  - TA2582 for US4138 : Prevent duplicates in team member list
* Wed Feb 10 2010 - matthias.biggeleben@open-xchange.com
  - Fixed bug #15050 : [L3] Team-Day-View should display the "reserved" appointment when overlapping
  - Fixed bug #15263 : [L3] Additional line added when sending HTML-mails
  - Fixed bug #15071 : [L3] Switching the time range within team view displays the day view from 00:00
* Wed Feb 10 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #14126 : Appointments with resources don't show the "group appointment" icon
* Mon Feb 08 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #14957 : Startpage Selection does not work
  - Fixed bug #14959 : Error when changing folder permissions
* Fri Feb 05 2010 - stefan.preuss@open-xchange.com
  - US3031 : TinyMCE features to be activated on user basis
  - TA2503 : Allow creation of mixed folder types (aka virtual folder)
* Thu Feb 04 2010 - viktor.pracht@open-xchange.com
  - TA2508 for US4087 : [Social Mesasging] Implement GUI
* Mon Feb 01 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15304 : [L3] Unlovely formatting of the "To:" and "Cc:" columns of printed e-mail
* Mon Jan 25 2010 - viktor.pracht@open-xchange.com
  - TA2405 for US3948 : Extended logging on login
* Fri Jan 15 2010 - choeger@open-xchange.com
  - Fixed bug #15207 : open-xchange-themes-default package does not contain any useful files
    checked in missing post(inst|rm)
* Wed Jan 13 2010 - stefan.preuss@open-xchange.com
  - Updated TinyMCE to Version 3.2.7
  - Fixed bug #15012 : subscription tab available for the global adress book
  - Fixed bug #15152 : Invalid i18n for id="mail.vsplit.foldername" when logging in with e-mail vsplit module as default
* Tue Jan 12 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15092 : User interface shows "Unified INBOX" while folders is named "Unified mail"
  - Fixed bug #15186 : Naming for confirmation status defaults are misleading
* Mon Jan 11 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15182 : Chrome/Safari: Pressing Escape does not revoke inplace editing changes
* Fri Jan 08 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15121 : "Sent" and "Drafts" folder lists do not contain recipients and send date
  - TA2267 for US3947 : Make the inplace editing and selection of appointments more comfortable
  - TA2270 for US3954 : Viewing appointments in a shared folder should display the confirmation status of the folder owner
* Tue Dec 22 2009 - stefan.preuss@open-xchange.com
  - TA2025 of US3839 : Remove any references to the old team workweek (file and functions)
  - Fixed bug #15076 : [L3] Team view doesn't remember selected team
* Fri Dec 18 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14521 : List of groups is disordered
* Wed Dec 16 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #15097 : [L3] Mails are sent twice using IE7 and IE8
* Tue Dec 08 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #15025 : [L3] changed DefaultSenderAddress isn't used by mailer
* Mon Dec 07 2009 - viktor.pracht@open-xchange.com
  - US3686 : Faxes and voicemails as mails
* Mon Nov 30 2009 - stefan.preuss@open-xchange.com
  - TA505 for US541 : Newly assigned tasks will be also shown in the confirmation dialog
* Mon Nov 30 2009 - matthias.biggeleben@open-xchange.com
  - TA2026 for US3805 : Merge team work week-view into 'new' team view
* Wed Nov 25 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14865 : E-Mails are occasionally not shown in Split view
* Wed Nov 25 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14914 : infostore H-Split detail section does not update when accessing the module through portal page
* Tue Nov 24 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14955 : GUI is translated to browser language after first login
  - TA1980 for US3705 : Customization of the New Mail window
* Mon Nov 23 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14945 : Groups plugin does not show groups members at detail livegrid
* Mon Nov 23 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14958 : Unable to add additional user to folder after saving
* Fri Nov 20 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14915 : "beta" feature is referenced in subscription module
* Thu Nov 19 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14917 : Team view 'Detail' button does not work correctly with IE7/IE8
  - Fixed bug #14912 : Teamview: Cannot visually create an appointment by dnd with negative ranges
  - Fixed bug #14913 : Teamview: Sorting team members might lead to wrong results
* Thu Nov 19 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14926 : [L3]: confirmation for changing rights should be shown longer
  - Fixed bug #14643 : Contact hovering in the phone list view ist enabled, although it is disabled in the configs
* Thu Nov 19 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14930 : "Download OXtender" panel section appears at annoying places
* Wed Nov 18 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14901 : Wizard shows red "Cancel" button
* Wed Nov 18 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14902 : Wizard Cancel/Close buttons switch
  - Fixed bug #14904 : Wizard loses "Start" button when leaving on the last page via "X" click
  - Fixed bug #14906 : Wizard: Service buttons move around
  - Fixed bug #14909 : E-Mail: Empty newlines will be removed when replying to an E-Mail
  - Fixed bug #14911 : GUI does not load (stops at 90%)
* Tue Nov 17 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14875 : Confirmation boxes for tasks show "appointments" and "show in calendar" even for tasks
  - Fixed bug #14852 : Switch from List to H-Split doesn't show content
  - Fixed bug #14874 : Different confirmation dialogs for tasks, panel vs. context menu
  - Fixed bug #14894 : selection lost after switching from list to H/V-Split
  - Fixed bug #14591 : Additional requests are made when the oxcache size limit is hit
* Tue Nov 17 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14881 : Panel "Save as" is active even if no mail is selected, throws JS error
* Tue Nov 17 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14378 : Only one E-Mail address of a contact shown when searching for distribution lists members
* Tue Nov 17 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14870 : Wizard: boxes for data too small
  - Fixed bug #14855 : Wizards publication foldertree duplicates its content everytime it is triggered 
  - Fixed bug #14886 : [Safari] Service Icons in Wizard move around
* Mon Nov 16 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14860 : Unable to accept/decline a appointment
* Mon Nov 16 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14852 : Switch from Infostore List to H-Split doesn't show content
  - Fixed bug #14864 : Unable to add participant to an appointment
  - Fixed bug #14866 : Adding one user both as participant and resource at once leads to duplicate entries
  - Fixed bug #14863 : Yellow "insert here" bar occurs when clicking a contact/user in team view
  - Fixed bug #14877 : Unable to add Ressource / participant to teamview
  - Fixed bug #14873 : Appointment is saved as "null" when removing the title but keeping the location
  - Fixed bug #14839 : The display name is unnecessarily quoted in mails
* Mon Nov 16 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14862 : Wizard: "Phone (business)" in wizard doesn't display the value
* Mon Nov 16 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14872 : Appointment without title causes JS error at the confirmation dialog
  - Fixed bug #14876 : Web Mail Only Users Import Error
* Thu Nov 12 2009 - viktor.pracht@open-xchange.com
  - TA1492 for US3214 : Include OxUpdater in OX server so it can be easy deployed by hosting companies
  - Fixed bug #14849 : JS Error when switching from "Sent" to "Spam" folder
* Thu Nov 12 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14817 : Wizard creates folders for failed subscriptions
  - Fixed bug #14818 : Wizard creates multiple folders and subscriptions when modifying it
  - Fixed bug #14816 : Wizard linkedin.com subscriptions create incorrectly named folder
  - Fixed bug #14819 : Wizard should not add OXMF URL to the foldername
  - Fixed bug #14814 : Wizard shows thin yellow line after successfully saving
  - Fixed bug #14813 : Wizard throws concurrent modification error when saving data twice
* Thu Nov 12 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14848 : Hovers don't contain valid participant or attachment information
* Thu Nov 12 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14847 : Switching from team view to detail view freezes the calendar view
* Wed Nov 11 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #11663 : Removal of multi-selected attachments does not work in popup windows
* Wed Nov 11 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #9263 : "OX Modules" section one pixel too high
  - Fixed bug #10507 : "Version" expand button is shown in wrong state when switching tabs
  - Fixed bug #10849 : delete unread mail doesn't update folder tree
* Tue Nov 10 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14825 : No Hover in teamview but Exeption
  - Fixed bug #13189 : No visual feedback after importing a second ics or vcard file
  - Fixed bug #7122 : Infobox not updated after uploading files
* Tue Nov 10 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #10742 : Calendar Team View: View does not update after changing the member list
  - Fixed bug #14388 : Participants tab of an appointment sometimes shows "0"
* Mon Nov 09 2009 - viktor.pracht@open-xchange.com
  - US3317 : New accept/decline dialog shows the location
  - Fixed bug #14842 : Wizard throws error on creating folder for subscription
* Mon Nov 09 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14378 : Only one E-Mail address of a contact shown when searching for distribution lists members
* Fri Nov 06 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14788 : Deleting an appointment does not work in team view
  - Fixed bug #14789 : Flags cannot be set at the team view
  - Fixed bug #14791 : 'Today' button and the minicalendar itself have no influence to the team view
  - Fixed bug #14785 : Team view jumps back to the first day when creating an appointment via drag&drop
  - Fixed bug #14728 : Creating an appointment with participant at team view not intuitive
  - Fixed bug #14790 : No "do you really want to delete" popup is shown in team view
  - Fixed bug #14786 : Moving an appointment to another folder in team view throws a concurrent modification error
  - Fixed bug #14678 : Popups appear below minicalendar
  - Fixed bug #14695 : Unable to select signatures in "New Mail" window
  - Fixed bug #14771 : team view goes beyond time frame
  - Fixed bug #14650 : Mouse hover seems disabled after a search
* Fri Nov 06 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14470 : Theme background of attachment names is not colored
  - TA1736 for US3297 : Make current Madhouse-New-Icons the new defau theme
* Fri Nov 06 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14807 : Share indicator for folders is only shown after a relogin when setting a publication
* Thu Nov 05 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14113 : Moving infostore folders twice hide the moved folder
  - Fixed bug #14766 : Doubleclicking a .txt attachment at a forwarded E-Mail opens it at the mail window
  - Fixed bug #14806 : "conArr.content_type is undefined" When opening an e-mail at a popup
* Thu Nov 05 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14605 : "New" windows use default theme path for icons
  - TA1561 for US3245 : Shared and published folders are marked
* Wed Nov 04 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14444 :  Livegrids (E-Mail) jump to the first entry after scrolling a while
  - Fixed bug #14605 :  "New" windows use default theme path for icons
* Wed Nov 04 2009 - matthias.biggeleben@open-xchange.com
  - TA1735 for US3244 : New scalable team view
* Wed Nov 04 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13189 : No visual feedback after importing a second ics or vcard file
* Mon Nov 02 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14464 : UWA Widget uses different CSS class ids for title than OX modules
  - Fixed bug #14503 : [Mad House Theme] Selection buttons cannot be recognized
* Mon Nov 02 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14576 : Import appointment "successful" with Error message and importer accepts the appointment
* Mon Nov 02 2009 - markus.wagner@open-xchange.com
  - Fixed bug #7264 : [IE7] E-Mail: linebreak/space between single mails in listview (thanks to matthias.biggeleben and martin.braun for debugging)
* Fri Oct 30 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14731 : text attachment from attached email not shown
* Wed Oct 28 2009 - stefan.preuss@open-xchange.com
  - TA1708 for US3251 : UI checks config parameter to enable/disable new template-based print view 
* Wed Oct 28 2009 - viktor.pracht@open-xchange.com
  - TA1705 for US3264 : User can change the personal name
* Tue Oct 27 2009 - viktor.pracht@open-xchange.com
  - US2894 : Hooks for new columns in LiveGrids
* Tue Oct 27 2009 - stefan.preuss@open-xchange.com
  - TA1433 for US3012 : Implement multi-selection in team week view 
* Fri Oct 23 2009 - viktor.pracht@open-xchange.com
  - TA1661 for US3251 : Print the work week view via templates
  - TA1663 for US3253 : Print the week view via templates
  - TA1665 for US3250 : Print the month view via templates
* Fri Oct 23 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14705 : Two sender addresses are shown in 'New E-Mail' where one lacks the displayname when sending
  - Fixed bug #14707 : Mysterious birthday information, if not filled in
* Thu Oct 22 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14652 : [L3] Sorting in recipients dialogue doesn't work
  - Fixed bug #11789 : Availability: "Show Team Members" misleading
* Wed Oct 21 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14693 : FF: "Priority:" label has a linebreak
  - Fixed bug #14692 : Unable to download multiple attachments as zip file via context menu
  - Fixed bug #14690 : Loading custom default folders takes ages at the configuration
  - Fixed bug #14687 : Default folder icons are not set after configuring them
  - Fixed bug #14689 : Error messages thrown when not selecting all custom default mail folders  
  - Fixed bug #14685 : Wrong displayname/mail config is used when selecting external sender
  - Fixed bug #14536 : Forwarding multiple E-Mails does not work with Safari, throws json error
* Wed Oct 21 2009 - matthias.biggeleben@open-xchange.com
  - TA1594 for US3233 : New scalable team view
* Tue Oct 20 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14674 : New confirmation dialog fields to small
  - US2897 : Implementation of separate JSON user interface in the OX6 UI
* Tue Oct 20 2009 - stefan.preuss@open-xchange.com
  - TA1575 for US2063 : User should be able to save selected attachments as zip file 
* Mon Oct 19 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14651 : Error in Quick filter bar
  - Fixed bug #13706 : Multiple fields cannot be empty when creating a new mail account, throws SQL errors
  - TA1571 for US994 : Implement edit options for default folders for trash, drafts, etc.
* Mon Oct 19 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14665 : "acceptdenyobject is undefined" after login
* Fri Oct 16 2009 - stefan.preuss@open-xchange.com
  - TA1361 for US3205 : Day- and Workweek-View must show at least 5 whole day appointments
  - TA1607 for US2073 : Display confirmation message of appointments within hovers
* Thu Oct 15 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14482 : Hovers of appointments in calendars without read right (or private appointments) in team view show NaN creation date information
* Thu Oct 15 2009 - viktor.pracht@open-xchange.com
  - US2779 : A single confirmation dialog for multiple appointments
* Wed Oct 14 2009 - matthias.biggeleben@open-xchange.com
  - TA1569 for US2263 : Implement new folder context menu items for Pub&Sub
  - TA256 for US925 : D&S-RMB: User can send contacts via Email as vCard
* Wed Oct 14 2009 - stefan.preuss@open-xchange.com
  - TA1573 for US1604 : User should see the number of objects in a folder at the head-line of each view
  - TA1550 for US2226 : Show modal info dialog when saving a new mail account
* Mon Oct 12 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14649 : Typo in ox.pot 
  - Fixed bug #14036 : Creating, forwarding and replying E-Mail from a secondary account uses primary account data
  - TA1572 for US2843 : Implement new mail account field 'Your name'   
* Mon Oct 12 2009 - matthias.biggeleben@open-xchange.com
  - TA526 for US961 : D&S-RMB: User gets context menu entry "Mark as" for emails
  - TA1568 for US2262 : Forbid editing system account
* Fri Oct 09 2009 - viktor.pracht@open-xchange.com
  - US3127 : Replace XSLT with E4X
  - US3130 : Partial builds for the GUI
* Thu Oct 08 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #11781 : E-Mail: Largest font not working as expected in e-mail editor
  - Fixed bug #14566 : Gray background for quoted text not consistent through all email compose modes
  - Fixed bug #14599 : [L3] email, font size can not be changed after cut and paste
  - Fixed bug #14645 : Drafts are not saved and restored as the user would expect
* Thu Oct 08 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14427 : scrolling down in unified inbox only works the second time
* Wed Oct 07 2009 - stefan.preuss@open-xchange.com
  - TA1543 for US3195 : Added additional fields 'Company Street, Company City and Department' to contact search
* Mon Oct 05 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14493 : Calendar workweek view shows one year too much
  - Fixed bug #14628 : Tag list in the configuration does not show a scrollbar
  - Fixed bug #14547 : private appointments are incorrectly listed in public calendar when using "view list" and "work week" (thanks to janny_buh@yahoo.it)
  - TA1363 for US205 : Week-View should display all whole-day appointments 
* Mon Oct 05 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14612 : Unable to create "gaps" in a E-Mail quoting of a multipart HTML mail when sending e-mail in plain-text mode
* Wed Sep 30 2009 - stefan.preuss@open-xchange.com
  - TA1476 for US2186 : Add new user options to change the contact collector settings 
* Tue Sep 29 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14606 : Spellchecker can not be activated through GUI settings
  - Fixed bug #14590 : Gui Problems disabling webmail and tasks
* Fri Sep 25 2009 - stefan.preuss@open-xchange.com
  - TA1500 for US3139 : 'Beta' should be replaced by 'New'
  - Fixed bug #14587 : Task information is not shown in h-split after unselecting a task and selecting it again
  - Fixed bug #14588 : Task H-Split details are not shown initially when switching there from another module
* Thu Sep 24 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14565 : Scrollbar at the bottom when answering or forwarding a mail
* Wed Sep 23 2009 - stefan.preuss@open-xchange.com
  - TA552 for US412 : Use server setting to enable/disable the integrated spellchecker of the WYSIWYG editor
* Thu Sep 17 2009 - stefan.preuss@open-xchange.com
  - TA1357 for US1012 : Add new user option to select landing page after login
  - TA1359 for US1012 : Implement 'jump' to the selected landing page right after the user logged in 
* Tue Sep 15 2009 - stefan.preuss@open-xchange.com
  - TA1263 for US2776 : Ignore configuration save error on logout when the session isn't valid anymore
* Mon Sep 14 2009 - stefan.preuss@open-xchange.com
  - TA1354 for US2775 : Remove warning dialog when leaving the OX main page 
* Thu Sep 10 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14491 : "Error: Folder 0 does not exist in context 1" while clicking to mail preferences in config tree
* Wed Sep 09 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14481 : Pressing Shift+Tab at the "Subject" field positions the cursor at the body field
  - Fixed bug #14483 : On "reply" and "reply all" Firefox 3.5.1 shows a huge blinking cursor
* Tue Sep 08 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #13529 : [L3] The function Indent / Outdent doesn't work in the HTML editor of the compose new e-mail window
  - Fixed bug #13469 : Cursor in E-Mail popup disappears if underlying groupware window refreshes
* Fri Sep 04 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13218 : "Adding a participant" icon should be blue
  - Fixed bug #12268 : Wrong time format (24h instead of 12h) within week view for en_XX
  - Fixed bug #10022 : Able to cut folder twice
  - Fixed bug #12611 : No error message if task due date is earlier than start date
  - Fixed bug #12789 : CW 1 2008 instead of 2009 displayed
* Thu Sep 03 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14447 : Unable to add specific user to folder permissions
* Wed Sep 02 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #12525 : switching signatures in new mail produce multiple signatures in mail text
  - Fixed bug #11768 : Mail signatures are transformed
* Wed Sep 02 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #10423 : email adress changeable for users
  - Fixed bug #11591 : Unable to remove value in estimated and actual duration in task
  - Fixed bug #14442 : multiple deletion does end up in showing the wrong email afterwards
* Tue Sep 01 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14414 : Participant list in task h-split shows duplicate empty entries after switching from portal page, expanding and collapsing the details section
  - Fixed bug #14426 : Reply locates the cursor below the inserted text if no signature is available
  - Fixed bug #14429 : Cursor starts at the mail signature if its configured as "show above text"
  - Fixed bug #14431 : [Safari] Monospace fonts are too small
  - Fixed bug #12668 : edit distribution list second time opens edit contact window
* Tue Sep 01 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14380 : folder are collapsed after changing sth. in the configuration
  - Fixed bug #13066 : Unable to view appointments in day view prior to 1970
  - Fixed bug #14433 : Contacts: After edit a contact, view is switched to cards view
  - Fixed bug #14386 : No permission check on folders for the "import" RMB entry
  - Fixed bug #14351 :  Inconsistent handling of "own" right when using doubleclick
* Tue Sep 01 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12885 : Read Acknowledgement vs. Return Receipt vs. Delivery Receipt 
  - Fixed bug #12945 : Whole-day appointments are not on top at calendar month view
  - Fixed bug #13356 : Unable to modify appointment title in-place if the appointment does not have a title
  - Fixed bug #13346 : E-Mail autocomplete incomplete when using the mouse to select single recipients
  - Fixed bug #11171 : Cursor postion by Autocomplete Function (E-Mail Modul)
  - Fixed bug #14205 : Unable to change confirmation using the context menu in a folder with no write permission 
  - Fixed bug #14277 : Popups of file attachments don't contain scrollbars, except at E-Mail
  - Fixed bug #9294 : E-Mail: Select recipients popup not displayed as specified
  - Fixed bug #7755 : Posibility to move hoverboxes under the headline bar
* Mon Aug 31 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14167 : [Safari] Reply All - Cursor should start in body field
  - Fixed bug #14165 : [Safari] New Mail - Tabbing does not go into body field
  - Fixed bug #14228 : Change Confirmation in tasks is enabled even if no task is present or selected
  - Fixed bug #12882 : Webmailer overwrites clipboard
  - Fixed bug #14267 : FF3.5: Scroll position of E-Mail is not reset when switching to another mail
  - Fixed bug #12822 : No monospace font used with Safari
* Mon Aug 31 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14413 : "Save" is enabled when multiselecting E-Mail
  - Fixed bug #12741 : Can't open more than one attached email
  - Fixed bug #13856 : next mail not selected when you are on the last mail in the list
  - Fixed bug #12903 : When creating a contact from an email address, the surrounding "" should be ignored
  - Fixed bug #12732 : minicalendar gets displayed without content
  - Fixed bug #14322 : Text for Publication Warning
  - Fixed bug #13240 : Notification checkbox has no effect
  - Fixed bug #14424 : POP3 settings dialog enables "keep on server" and "delete messages on local storage" boxes after saving even if they are not enabled
  - Fixed bug #13461 : Mysterious error popup after creating contact, changing contact view and then changing language
  - Fixed bug #14418 : Detail button is not shown in contacts card view if panel has only two lines
  - Fixed bug #14294 : text modification
* Mon Aug 31 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14376 : Search function have problems with edits results
  - Fixed bug #14419 : Location multiplies in WW View
* Mon Aug 31 2009 - ben.pahne@open-xchange.com
  - Fixed bug #13871 : Safari: Popup corners with different color
* Sat Aug 29 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14411 : Participant selection dialog broken in folder permissions and distribution lists 
  - Fixed bug #14096 : Attached E-Mails are not removed when selecting another E-Mail with attached E-Mail
  - Fixed bug #14412 : "Delete" is greyed out at the context menu when multiselecting E-Mail
* Fri Aug 28 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14397 : Contact livegrids don't update after modifying an entry
  - Fixed bug #14391 : InfoStore Publish offers OXMF Contacts
  - Fixed bug #14400 : Error messages of plugins do not go away
  - Fixed bug #14367 : "Object not found" error when a hover is triggered to a deleted object
* Fri Aug 28 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14166 : New HTML Mail - Cursor starts in body field
  - Fixed bug #14167 : [Safari] Reply All - Cursor should start in body field
  - Fixed bug #14410 : Adding contacts to a objects does not longer work when adding those contacts after a contact search
  - Fixed bug #14406 : Adding a external contact to a appointment or task shows it temporary as blue instead of red at the participants list
  - Fixed bug #14409 : "Options" checkbox in E-Mail does not work when panel is in 4+ row mode
* Fri Aug 28 2009 - stefan.preuss@open-xchange.com
  - TA1233 for US2448 : Show additional information created by and modified by in hovers
  - Fixed bug #13209 : Signature list loses focus after editing or adding a signature via the popup menu
  - Fixed bug #14381 : Editing and saving a signature doesn't refresh the preview
  - Fixed bug #13345 : Hyperlinks at the "Signature" preview page are opened on the current window, not on a _blank one
* Thu Aug 27 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14379 : Unable to accept/decline tasks via context menu
  - Partially fixed bug #14396 : POP3 can't deactivate option to leave messages on server  
  - Fixed bug #14383 : Team view does not update after creating a appointment
  - Fixed bug #14347 : Checkboxes on the panel are not working when using 2-row panel
  - Fixed bug #14266 : BCC field can not be managed with two line pannel
  - Fixed bug #10508 : No "Hand" cursor shown when panels can be collapsed
* Thu Aug 27 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #13637 : Vacation notice broken when being saved without addresses in action commands
* Thu Aug 27 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #7307 : Tasks/Calendar: Participants dialogue: GUI-Spec not implemented completely
  - Fixed bug #14166 : New HTML Mail - Cursor starts in body field
* Wed Aug 26 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14226 : 2-row panel shows "Edit" and "Print" at the calendar view
* Wed Aug 26 2009 - ben.pahne@open-xchange.com
  - TA1072 for US1040 : Add new option 'Import' to the folder RMB menu
  - TA1071 for US1040 : Implement folder selection dialog on the Import page in the user setup
  - TA1125 for US2577 : Erstelle neuen Theme und im CVS/packaging bereitstel
  - Fixed bug #14384 : Import folder popup opens at a random location 
  - Fixed bug #14385 : "Import" entry missing for task folders
* Wed Aug 26 2009 - stefan.preuss@open-xchange.com
  - TA1081 for US532 : Double click on time grid in day team-view should open new appointment window and pre-select date and time 
  - TA1081 for US532 : Double click on days in week team-view should open new appointment window and pre-select date and time
  - Fixed DE127 : Default confirmation status for new appointments is wrong
  - Fixed bug #14393 : Change text for calendar options
* Wed Aug 26 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #14318 :  Publish/Subscribe Dialogs only for supported Foldertypes
  - Fixed bug #14214 :  [dev] Pubsub dialog boxes are not using the typical dropdown boxes
* Tue Aug 25 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #14377 : New distribution list participant dialog lacks a folder selector
  - Fixed bug #12568 : No "dummy" picture shown for contacts where the contact image has been removed
  - Fixed bug #14051 : Contact picture in hover over function not updated after changing it
  - Fixed bug #12122 : Previous displayed data is shown when switching to a nonexistant appointment
  - Fixed bug #11981 : Panel "New" section is shown with expand arrow even if no further icons are present
* Tue Aug 25 2009 - stefan.preuss@open-xchange.com
  - TA1085 for US532 : Add shown members in team views to list of participants when creating an appointment clicking on the 'New' button in the panel 
* Tue Aug 25 2009 - viktor.pracht@open-xchange.com
  - TA1043 for US2086 : Customer Commitment: Suche über Kontakte berücksichtigt mehr Felder durch ein Drop-Down Menü
* Mon Aug 24 2009 - viktor.pracht@open-xchange.com
  - TA1121 for US2576 : Customer Commitment: User kann Zeitraster in der Tagesansicht (Teamview) konfigurieren
  - Fixed bug #11620 :  Mail recepient selected through auto complete overwrites first mail address
* Mon Aug 24 2009 - stefan.preuss@open-xchange.com
  - TA1089 for US1085 : Implement hover in the team day-view
  - TA1090 for US1085 : Implement hover in the team work week-view
  - TA1091 for US1085 : Implement hover in the availability view of the new appointment window
* Mon Aug 24 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #9300 : Distribution List: 'Add from adress book' gui window got wrong aligned 'add' and 'remove' buttons
  - Fixed bug #13053 : Contacts are added to distributionlists even if they have been removed from the recipient selection  
* Fri Aug 21 2009 - matthias.biggeleben@open-xchange.com
  - Fixed bug #9679 : Displayname auto-complete is broken after switching via shift+tab
* Fri Aug 21 2009 - stefan.preuss@open-xchange.com
  - Partially fixed bug #14264 : [L3] High SQL load with very long running queries on prg_contacts table
* Thu Aug 20 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #12503 : [L3] Shared calendar: You do not have the appropriate permissions to modify this object
  - Fixed bug #13798 : error: DLMB in global address book, you do not have write permissions for the object
* Wed Aug 19 2009 - ben.pahne@open-xchange.com
  - TA1075 for US2120 :	Implement new option 'Export' to folder RMB menu
* Wed Aug 19 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #11406 : [L3] Week view displays recurring appointments twice
* Mon Aug 17 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14329 : Typo in .pot
  - TA1078 for US459 : User only want's to see the working time at the Team view
* Mon Aug 17 2009 - viktor.pracht@open-xchange.com
  - Fixed bug #12563 :  Change display of Task estimated/current duration
* Fri Aug 14 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13204 : no alt tag on month view icon in minicalendar
* Thu Aug 13 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14295 : [L3] "Send as link" for mail folders should be removed
* Wed Aug 12 2009 - ben.pahne@open-xchange.org
  - TA1045 for US2172 : Add a new calendar option so a user can decide wether he want's to be added automatically to a new appointment in a public folder
* Wed Aug 12 2009 - stefan.preuss@open-xchange.com
 - TA1065 for US2172 : Implement new user option in the new appointment window
* Tue Aug 11 2009 - stefan.preuss@open-xchange.com
  - TA1040 for US2457 : Set default for publish secret to "on"
  - TA1037 for US2457 : Add Privacy Warning to publish settings page (static, English)
  - Fixed bug #14297 : Missing warning when publishing personal data without a password
* Fri Aug 07 2009 - ben.pahne@open-xchange.org
  - TA1025 for US2503: Save/Export E-Mails as eml file
* Tue Aug 04 2009 - ben.pahne@open-xchange.org
  - TA992 for US2488 : Add switches for default confirm status to UI options
* Tue Aug 04 2009 - stefan.preuss@open-xchange.com
  - TA1028 for US2395 : The location will be shown in the title of an appointment in each view
* Thu Jul 30 2009 - ben.pahne@open-xchange.org
  - TA541 for US439 : Selecting a date from the minicalendar doesn't change the currently selected calendar view
* Wed Jul 29 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #11915 : Print button active even if nothing selected
  - Fixed bug #14245 : Typo in ox.pot
* Tue Jul 28 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14227 : Contacts and Infostore module dont show the enhancement arrows anymore
* Mon Jul 27 2009 - stefan.preuss@open-xchange.com
  - TA995 for US2065 : Panel can be reduced to at least 2 rows
  - Fixed bug #14080 : Update OX "About" information
* Thu Jul 23 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #14210 : [L3] Using "--access-infostore off" deactivates option "Send as link"
* Tue Jul 14 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #14131 : [L3] Different behaviour for opening a infostore file from hover or from context menu
* Mon Jul 13 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13762 : [L3] "Mark as" doesn't actualise the unread message counter
* Fri Jul 10 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11210 : [rally] Calendar: no conflict check for a whole day, daily, series appointment
* Fri Jul 10 2009 - ben.pahne@open-xchange.org
  - Fixed bug #14108 : Very bad UI performance in IE7
* Tue Jul 07 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #14110 : Unable to remove attachments from objects
* Mon Jul 06 2009 - ben.pahne@open-xchange.org
  - Fixed bug #14091 : Sidepanel cannot be collapsed with IE8, folders disappear and won't come back 
  - Fixed bug #14087 : IE8: E-Mail autocomplete does not work
* Mon Jul 06 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #14086 : IE8: UI tries to remove objects multiple times, depending on the amount of recently removed objects
  - Fixed bug #14100 : IE8: Unable to change confirmation status on tasks, E-Mail related error is thrown
  - Fixed bug #12623 : Updates requests return objects that timestamps are greater OR EQUAL given timestamp
* Wed Jul 01 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14044 : UI tries to save contactcollector related information while the module is not installed
  - Fixed bug #14002 : Tasks: Setting "percentage_completed" to 0 does not set the field
  - Fixed bug #12779 : [L3] Inconsistent folder tree after clearing trash folder
* Tue Jun 30 2009 - stefan.preuss@open-xchange.com
  - Changed to new version handling
  - Fixed bug #13452 : Task hovers sometimes show no priority bar, invalid url
  - Fixed bug #14037 : Unable to chose different sender address in webmailer
  - Fixed bug #14040 : RMB menus don't work for recurring appointments if the selected appointment is => the second occurrence
  - Fixed bug #13453 : Task hovers show "Start date" and "End date" even if no start/end date is set for the task
  - Fixed bug #13573 : Read acknowledge E-Mail is sent by the default E-Mail account but not by the one which triggered the E-Mail
* Mon Jun 29 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13828 : user can't change the appointment-confirmation at shared folder
  - Fixed bug #13792 : E-Mail module not locked if E-Mail backend is unreachable
  - Fixed bug #13195 : Default reminder value is not set for appointments created via Drag&Drop
* Mon Jun 29 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13945 : No permission check for publishing folders
  - Fixed bug #13637 : Vacation notice broken when being saved without addresses in action commands
* Fri Jun 26 2009 - stefan.preuss@open-xchange.com
  - Fixed DE62 : Error found in US942: First Attachment is always selected and the Attachment section is active at the Panel
  - Fixed bug #13548 : Strange chaching of contact pictures
  - Fixed bug #13735 : Selecting a top-level "E-Mail" node of a secondary mail account displays the inbox of the primary mail account
* Fri Jun 26 2009 - ben.pahne@open-xchange.org
  - Fixed bug #12828 : [L3] Theming: Logout button white spots from the corners can not be removed
  - Fixed bug #13982 : Firefox for Mac: Add picture button misaligned
* Fri Jun 26 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8501 : Wrong icon during moving private appointments to public folders
* Thu Jun 25 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #9060 : Public, Shared and Infostore folders are translated to english instead of french
  - Fixed right click for context menus on Macs
* Wed Jun 24 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13977 : Appointment status not correctly shown in work week
* Tue Jun 23 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13961 : [L3] Error on loading contact list when composing new email
  - Fixed bug #11583 : Refreshing detail view disables action buttons at the panel
  - Fixed bug #12779 : [L3] Inconsistent folder tree after clearing trash folder
* Tue Jun 23 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13530 : [L3] Undo / Redo in the HTML editor of the compose e-mail window doesn't work as excpected
  - Fixed bug #13933 : E-Mail autocomplete does not select the result if only one address is shown
* Mon Jun 22 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13930 : FF: GUI hangs when sorting by flags and switching to V-Split
  - Fixed bug #13766 : Multimail plugin fills preset IMAP information when canceling a POP3 creation and create a new account
  - Partially fixed bug #13625 : [L3] Search for tagged contacts and dates doesn't work
  - Fixed bug #13940 : Seamonkey: Oversized right arrow in multilevel context menus
* Fri Jun 19 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12725 : Different click-behavior by RMB on foldertree
  - Fixed bug #13936 : "Save" button disappears in folder properties when switching back from a pubsub tab
* Fri Jun 19 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13713 : Participant count not updated at the tab when moving a contact to the minicalendar
* Thu Jun 18 2009 - ben.pahne@open-xchange.org
  - Fixed bug #13907 : Frame at group preview window looks ugly
* Thu Jun 18 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13607 : [L3] Contact disappears after moving it to a folder with no permission
  - Fixed bug #13885 : It's possible to RMB a empty livegrid and "edit" or delete nonexisting objects
  - Fixed bug #13720 : Date format entry contains "label|"
* Thu Jun 18 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13558 : Contact search which result contact has no display name shows no result
  - Fixed bug #12856 : Resetting search in task H-Split does not work, displays initial search result
  - Fixed bug #13610 : After contact searching and clearing the result text stays
  - Fixed bug #13613 : Clearing a calendar search in list view switches over to calendar view
  - Fixed bug #13372 : Can't search distribution lists in webmail address book
  - Fixed bug #13904 : Reply/Forward window hangs if original mail does not longer exist
  - Fixed bug #13894 : Appointment with resource is missing group icon
  - Fixed bug #13889 : To/CC/BCC are not completely shown when expanding the header information bar
  - Fixed bug #13884 : icalendar attachments cannot be "saved as", always open the new appointment window
  - Fixed bug #13707 : After creating a new mail account, the first entry at the account list is selected, but the data of the newly created account is shown
* Wed Jun 17 2009 - ben.pahne@open-xchange.org
  - Fixed bug #13906 : folder tree selection pop up not in new pop up design
* Wed Jun 17 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13877 : Changed behaviour of Drag&Drop of mails; Mail is not selected automatically after click
  - Fixed bug #13905 : Pubsub configuration UI shows bundle names instead of site names
* Tue Jun 16 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13908 : New group "All users" is still translated as "Alle Gruppen und Benutzer" at the UI
  - Fixed bug #13896 : Participants list within popups should be arranged in alphabetical order
* Mon Jun 15 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12996 : contacts: hover does not show the company name
  - Fixed bug #13460 : (Cards View) Display name doesn't contain company, if no first and last name is entered
  - Fixed bug #12463 : Appoinment change exception are not removed if the time slot for the series is changed.
  - Fixed bug #13634 : admin user is not able to write emails when the mail box is enabled
* Mon Jun 15 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13841 : IE7: Unable to add publications or subscriptions
* Wed Jun 10 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13857 : Collapsed sidebar "dragpoints" can be used, lead to empty sidebar
* Wed Jun 10 2009 - ben.pahne@open-xchange.org
  - TA848 for US1418 : Use counter is implemented
* Wed Jun 10 2009 - Viktor.Pracht@open-xchange.org
  - TA784 for US1855 : Konsolodierung der V-Split-Plugin-API
* Tue Jun 09 2009 - ben.pahne@open-xchange.org
  - Fixed bug #13546 : Safari Browser: Button for adding attachments is too short
  - Fixed bug #13545 : Firefox for Mac: Attachment popup has scrollbar
  - Fixed bug #13543 : Safari Browser: Search button of the contact pictures popup still not fully shown
  - Fixed bug #12283 : Contacts: "Add picture" popup undersized
* Tue Jun 09 2009 - stefan.preuss@open-xchange.com
  - TA816 for US1600 : User can collapse the side panel  
  - Fixed bug #13854 : IE6 compat GUI does not load in most cases
* Mon Jun 08 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13674 : [L3] Delete exception of a recurring appointment cannot be created
  - Fixed bug #13770 : [L3] "Standalone" Mode for UWA-Widgets has no effect
* Fri Jun 05 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13825 : Weekly recurring appointments lose series pattern in option panel
* Thu Jun 04 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11610 : rmb menu popups up
  - Fixed bug #13673 : JS error when selecting a contact in cards view
  - Fixed bug #13686 : E-Mail search pattern not selectable
  - Fixed bug #13687 : Unable to select "Mark as" for mails
  - Fixed bug #13693 : Autocomplete popups don't show up on searches at the panel
  - Fixed bug #13744 : IE7: Context menus in mail, tasks, calendar, infostore don't work, show strange layout
  - Fixed bug #13691 : "New Distributionlist" menu entry missing
  - Fixed bug #13709 : Unable to create new mail filter rule
  - Fixed bug #13756 : Link to published site should open in new browser window
  - Fixed bug #13751 : Publish tab contains default URL 'undefined'
  - Fixed bug #13818 : IE: RMB on contact card only works once
* Thu Jun 04 2009 - ben.pahne@open-xchange.org
  - Fixed bug #13728 : corners of about pop up broken
  - Fixed bug #13542 : Safari Browser: Missing corner images at all popup dialogs
* Thu Jun 04 2009 - stefan.preuss@open-xchange.com
  - TA820 for US1863 : Confirmation status of appointments should be more present
  - Fixed bug #13636 : Appointments cannot be deleted from certain Calendar views
  - Fixed bug #13658 : error message not available in gui error log
  - Fixed bug #13820 : IE8: Contact cards view lacks a scrollbar
* Wed Jun 03 2009 - stefan.preuss@open-xchange.com
  - TA326 for US342 : Click on calendar background should deselect any selected appointment
* Fri May 29 2009 - choeger@open-xchange.com
  - Fixed bug #13561 : [L3] default extras link can't be removed by configuration
    extras gui plugin moved to open-xchange-configjump-generic-gui
* Fri May 29 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13717 : Unable to login if the credentials for the primary E-Mail account are invalid or E-Mail backend is unavailable
  - TA814 for US942 : First Attachment is always selected and the Attachment section is active at the Panel
  - Fixed bug #13653 : Vertical scrollbar within details window is got out of place
* Fri May 29 2009 - ben.pahne@open-xchange.com
  - Fixed bug #13719 : IE8: Hover borders look pretty strange
  - Fixed bug #13692 : Conflict dialog are surrounded by an ugly border
* Fri May 29 2009 - stefan.preuss@open-xchange.com
  - TA815 for US1460 : Import of vCard and iCal files should be more visible
  - Fixed DE65 : Error found in US1460: Usability für iCal/v-Card Import aus Email
* Thu May 28 2009 - stefan.preuss@open-xchange.com
  - TA634 for US1635 : Add missing POP3 fields to UI files
  - TA681 for US1511 : Implement "Check Connection" button in the user options
* Wed May 27 2009 - Viktor.Pracht@open-xchange.org
  - TA676 for US1564 : Publishing addresses in microformatted HTML
* Tue May 26 2009 - ben.pahne@open-xchange.com
  - Task TA601 : TinyMCE berücksichtigt neue Default-Einstellungen für Schriftart- und Größe
  - Defect DE50 :  Error found in US1405: Change Default font for the HTML-Editor
  - Task TA602 : GUI berücksichtigt Schalter zum deaktivieren der Schnellauswahl in den Kontaktansichten
* Mon May 25 2009 - Viktor.Pracht@open-xchange.org
  - TA672, TA673, TA674, TA675 for US1647: (2) Subscribe to XING
* Wed May 20 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13702 : Context menus don't work in E-Mail VSplit
* Tue May 19 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13690 : Unable to create new subfolders below 'Public Folders'
* Tue May 19 2009 - stefan.preuss@open-xchange.com
  - Task TA678: Implement disabling of multiple e-mail accounts
  - Task TA679: Add BETA image / text to view / feature (User Story: US1645)
* Tue May 19 2009 - ben.pahne@open-xchange.com
  - Fixed bug #13688 : Tasks hover shows wrong attachment information
  - Fixed bug #13695 : Unable to move pop windows
  - Fixed bug #13694 : Popup window header gets broken after closing it using the 'x' and open it again
* Thu May 14 2009 - stefan.preuss@open-xchange.com
  - Task TA596 : UI informs user about storing POP3 mails in primary mail account
* Wed May 13 2009 - stefan.preuss@open-xchange.com
  - Updated TinyMCE editor to Version 3.2.2.3
* Tue May 12 2009 - Viktor.Pracht@open-xchange.org
  - Refactored popup menus.
* Fri May 08 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13609 : [L3] Version sorting within H-Split for Infostore items doesn't work - sorting function might not be needed
  - Fixed bug #13567 : [L3] "Show Infobox" overlays mini calendar
  - Fixed bug #13443 : [L3] IE8: Unable to add attachments to an E-Mail
  - Fixed bug #13541 : [L3] Direct link send thru TinyMCE does not work in other email clients
  - Fixed bug #13357 : Possible to add non-system users to folder shared, throws error when saving
* Fri May 08 2009 - ben.pahne@open-xchange.com
  - Task TA600: Neue Benutzeroption "Default-Font" einbauen
* Wed May 06 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13602 : Reply all puts 'Cc' addresses into the 'To' field
  - User Story US1510: User can set different SMTP auth credentials
* Wed May 06 2009 - ben.pahne@open-xchange.com
  - Task TA598 : Removed Unused images
  - Task TA598 : Combined first images for image-map
* Tue Apr 28 2009 - ben.pahne@open-xchange.com
  - Fixed bug #13547 : Strange attachment information in hover-over popup of an appointment
* Tue Apr 21 2009 - stefan.preuss@open-xchange.com
  - User Story US1516: User Max can send messages over external mail accounts
* Mon Apr 20 2009 - stefan.preuss@open-xchange.com
  - User Story US296: Resize column user name in the folder rights management tab
  - User Story US1518: User Max can subscribe and unsubscribe folders of external mail accounts
  - Fixed missing e-mail icons on root mail folders
  - Fixed refresh of unread message counter on all visible folders
  - Added possibility to choose POP3 mail server type when creating an external mail account 
* Fri Apr 17 2009 - stefan.preuss@open-xchange.com
  - User Story US1312: Preferences tree supports multiple mail accounts per user
  - User Story US1508: Linking: Remove linking within the web frontend
* Tue Apr 07 2009 - stefan.preuss@open-xchange.com
  - Partially fixed bug #13353 : i18N - Setting - E-Mail - Automatically select first E-Mail? not localized
* Wed Mar 18 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12276 : JSON error when moving a contact to the minicalendar via drag&drop
  - Fixed bug #12275 : Moving E-Mail to the minicalendar does not add E-Mail subject to the appointment description
  - Fixed bug #13204 : no alt tag on month view icon in minicalendar
  - Fixed bug #11520 : Mail list exeeds H-Split list section when browser window is resized to slow
  - Fixed bug #12936 : Print not possible in E-Mail popup window
* Tue Mar 17 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13399 : Calendar WW View - Column headers overlap when browser gets smaller
  - Fixed bug #13390 : IE: E-Mail subject reminder dialog shown 'null' string
  - Fixed bug #13405 : IE: reminder dialog shown 'null' string
  - Fixed bug #13391 : No scrollbars shown for E-Mail 'Show Source'
* Mon Mar 16 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13387 : Unable to print a mail in detail view
  - Fixed bug #13392 : flag a recurring appointment exception throws 500 Internal Server Error
* Fri Mar 13 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13383 : Pattern for searching in recipient dialog when writing new email is not sent to server
* Tue Mar 10 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12429 : Grid selects first item in list after moving an item into another folder
  - Fixed bug #9944 : comment text will not be displayed in the correct format
  - Fixed bug #12750 : One additional line before signature while writing a new e-mail
  - Fixed bug #10379 : Calendar: Search button in select participants popup needs to be clicked twice
* Mon Mar 09 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13355 : IE: Day and Workweek view have broken timeframes after changing the calendar interval to 60 Minutes
* Mon Mar 09 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13162 : Unable to create new team
* Fri Mar 06 2009 - stefan.preuss@open-xchange.com
  - Added missing stylesheets in the new/edit windows
  - Optimized the loading process in the new/edit windows
  - New/edit windows will open centered now
  - Fixed bug #9545 : Comments field too small
  - Fixed bug #9233 : Firefox print preview for single mails requested
  - Fixed #bug 13341 : Printouts of E-Mails do not contain information about attachments
* Thu Mar 05 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13320 : E-Mail is always deleted permanently when deleting in popup view
* Wed Mar 04 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12726 : Mail is not marked as read when clicking on the mail
  - Fixed bug #7460 : Calendar: RMB-delete, Das Objekt hat sich mittlerweile geändert
  - Fixed bug #13309 : Remove Field from GUI: OX6 HTTP API never returns FileMD5SUM
  - Fixed bug #9480 : dragpoint can be moved above table header
  - Fixed bug #10402 : InfoStore Hover: Filesize wrong formatted
  - Fixed bug #10821 : Elements hidden in french GUI when resolution < 1024x768
* Wed Mar 04 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13310 : Opening a calendar entry from the start page shows the appointment with several data missing
  - Fixed bug #13308 : [FF2] comments not shown in contact detail view
  - Fixed bug #13307 : Enter Key doesn't work by Inline Editing of Replied Mails
* Wed Mar 04 2009 - Ben.Pahne@open-xchange.org
  - Fixed bug #11637 : birthday not saved in personal data
  - Fixed bug #11754 - Icons are missing at Panel for Mailfilters
* Tue Mar 03 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #11462 : Mails marked as unread are not set read
  - Fixed bug #13163 : Folder popup within participant dialog is broken
* Tue Mar 03 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13227 : Contact search does not honor names
  - Fixed bug #9545 : Comments field too small
* Mon Mar 02 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #6809 : Quoting in mail behaves strange
* Mon Mar 02 2009 - Ben.Pahne@open-xchange.com
  - Fixed bug #13298 - [IE6] Broken Hover in IE6
* Fri Feb 27 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13210 : Default signature is marked with "X" instead of a real word
* Thu Feb 26 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13276 : Typo in GUI pot
* Wed Feb 25 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13261 : moving an object doesn't trigger an updated
  - Hopefully fixed the mysterious "too much recursion" bug.
  - Fixed bug #11824 : [L3] Hovers are displayed not completely at the browser window
* Mon Feb 23 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13250 : Header of mail grid not localized
  - Fixed bug #12910 : [L3] Deleted mails show up in trash folder only after GUI refresh
  - Fixed bug #9053 : Multi-day appointments show wrong times in month view
* Mon Feb 23 2009 - ben.pahne@open-xchange.org
  - Fixed bug #12826 : [L3] Theming: New documents pop-up large icons - implemented, application does not load them
  - Fixed bug #5735 : two different icons for the same funktion "settings"
  - Fixed bug #12825 : [L3] Theming: Start page content boxes top background same as tabs
  - Fixed bug #12933 : Cursor is set to 'To' field when replying to a E-Mail
* Fri Feb 20 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12969 : [L3] Cursor pointer differ for Mails and Contacts
  - Fixed bug #11627 : IE6 Download-Popup window does not close after download from infostore is canceled or finished
* Thu Feb 19 2009 - Viktor.Pracht@open-xchange.org
  - Requirement #2614 : Colour in "availability" tab of new appointment popup
  - Requirement #3263 : Series button is disabled when editing an exception
* Thu Feb 19 2009 - ben.pahne@open-xchange.com
  - Requirement #3345 : Set default values in series dialog based on selected start date
* Wed Feb 18 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13113 : [L3] Search field for participants not evaluated when creating appointments
  - Fixed bug #13225 : email: setting "Sender as "To", all recipients to "Cc."" takes all into to
  - Fixed bug #13213 : Terminology of new Option "Sender as "To", all recipients to "Cc."" isn't correct
  - Requirement #1154 : You can import an iCal attached to a message as new appointment
  - Requirement #1155 : You can import a vCard attached to a message as new contact
* Wed Feb 18 2009 - Viktor.Pracht@open-xchange.org
  - Requirement #3249 : Card view: more fields are considered for the display
* Tue Feb 17 2009 - stefan.preuss@open-xchange.com
  - Partially fixed bug #10755 : [L3] Subject should become a non mandatory field for the creation of new appointment
  - Fixed bug #13113 : [L3] Search field for participants not evaluated when creating appointments
  - Fixed bug #13212 : Unable to access new E-Mail from the portal page
  - Fixed bug #13137 : [L3] eml files can't be downloaded
  - Partially fixed bug #12157 : Configuration/Startpage/Layout: "Hide" not translated into German
  - Fixed bug #13119 : [L3] Underscores in signatures not diplayed in new line under IE
  - Requirement #3334: Add "Today" button to each headline in all calendar views
* Tue Feb 17 2009 - ben.pahne@open-xchange.com
  - Requirement #3329 : New "Create new Contact" window field order
* Mon Feb 16 2009 - ben.pahne@open-xchange.com
  - Requirement #3326 : New icons with a lock for disabled modules
* Fri Feb 13 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13181 : [Safari] InfoStore: Pressing "Send as Link" has no effect
  - Requirement #3314 : Click on CW in month view jumps to the selected week in the week view
  - Requirement #3315 : Folder "Public InfoStore" isn't grayed out even though you don't have read access
  - Requirement #3318 : Detail printing of infostore objects should be possible when only one object is selected in grid
  - Fixed bug #12867 : Infostore 'Print' function always prints the selected Infostore item in list view, not the Infoitem details
  - Fixed bug #13139 : [L3] Mail signature window in config tree doesn't show a scroll bar
* Fri Feb 13 2009 - ben.pahne@open-xchange.com
  - Requirement #3312 : Red delete button instead of a blue one
  - Requirement #3316 : Icon for easy access for configuration
  - Requirement #3319 : New calendar icons with the current date
* Thu Feb 12 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13185 : Folder Dialog for new Infostore item is broken
* Thu Feb 12 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13187 : Vacation rule without flag vacation set is editable and wrongly displayed
* Wed Feb 11 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13167 : drag and drop emails from one to another folder makes the GUI to not respond to any requests
  - Fixed bug #13166 : after deleting an email the next selected email is not in your view any more
* Tue Feb 10 2009 - stefan.preuss@open-xchange.com
  - Requirement #3268 : Signatures: Add V-Split with preview pane in the user options
  - Requirement #3270 : UWA-Options: Make link and text configurable
  - Requirement #3276 : Add new user option if the first e-mail should be selected when the user enters a folder the first time
  - Requirement #3278 : Add 'Feature_Not_Available' events on participants functions in panel for PIM and Webmail only
  - Requirement #3279 : Add 'Feature_Not_Available' events on attachments functions in panel for PIM and Webmail only
  - Requirement #3280 : Change the current shown headline of total and unread messages in the mail module 
* Mon Feb 09 2009 - stefan.preuss@open-xchange.com
  - Requirement #3180 : When doing a search the headline of the list views should change
  - Requirement #3313 : Implement color change on each second row in Grids
  - Fixed bug #12911 : [L3] Wrong time for example time in timezone settings
  - Fixed bug #12779 : [L3] Inconsistent folder tree after clearing trash folder
* Mon Feb 09 2009 - ben.pahne@open-xchange.com
  - Requirement #3179 : Merge animated 'loading' icon into 'refresh' icon with new icons
* Fri Feb 06 2009 - ben.pahne@open-xchange.com
  - Requirement #3178 : Add new user option to change the 'Reply All' address handling
  - Fixed bug #13141 : Normal Logout process activates "Do you want to leave this site" PopUp
* Fri Feb 06 2009 - stefan.preuss@open-xchange.com
  - Requirement #1146 : External participants can be invited to an appointment
* Thu Feb 05 2009 - stefan.preuss@open-xchange.com
  - Requirement #3181 : Get first and last name ('good guess') when adding an e-mail address to the address book
* Wed Feb 04 2009 - ben.pahne@open-xchange.com
  - Requirement #3161 : Create a solutions for Safari to get the login manager to work
* Fri Jan 30 2009 - ben.pahne@open-xchange.com
  - Requirement #3139 : Add new user option to set the default reminder value when creating a new appointment
* Thu Jan 29 2009 - ben.pahne@open-xchange.com
  - Requirement #2626 : Show number of existing versions on the version tab of the infostore hover
  - Requirement #2627 : Show number of links on the linkage tab of each hover which can be linked
* Thu Jan 29 2009 - stefan.preuss@open-xchange.com
  - Requirement #3078 : At the minicalendar, it is possible to open the Monthview
  - Added mouseover and click on CW numbers in the month view to allow direct jump into week view
  - Added some layout improvements on the availability tab of the new appointment window   
* Thu Jan 29 2009 - Viktor.Pracht@open-xchange.org
  - Requirement #1269 : Checkbox to search for contacts in all folders
* Wed Jan 28 2009 - stefan.preuss@open-xchange.com
  - Requirement #1161 :  Clicking on button 'Today' displays the current day in the current selected view
  - Fixed bug #12853 : IE7: JS Error thrown when following a directlink
  - Fixed bug #13073 : Settings for E-Mail notification are not saved througout the session
  - Fixed bug #13007 : Card view cuts display name
* Mon Jan 26 2009 - stefan.preuss@open-xchange.com
  - Requirement #3109 : Show warning dialog on sending a message when subject is empty 
* Mon Jan 26 2009 - Viktor.Pracht@open-xchange.org
  - Requirement #2617 : Linie für horizontales ziehen vorhanden
  - Requirement #3079 : Durch Selektionsfarbe eines Termins in der View ist der Termin nicht mehr lesbar
* Mon Jan 26 2009 - stefan.preuss@open-xchange.com
  - Requirement #3106 : Add 'Send as link' to the folder RMB menu
  - Requirement #3105 : Provide download dialog when clicking on the 'paper-clip' within the infostore list views
* Fri Jan 23 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13042 : Notification configuration has wrong caption
  - Requirement #183 : E-Mail Address Collection: Provide user option to enable/disable the collection of addresses
* Fri Jan 23 2009 - Viktor.Pracht@open-xchange.org
  - Implemented requirement #142 : Highlight the colomn which is sorted in all list views
* Thu Jan 22 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12722 : [L3] Unread message counter did not update immidiately for Trash folder after moving messages to Inbox
  - Fixed bug #9529 : IE5 shows no "This Browser is not supported" message
  - Requirement #2091 : Browser-Check: Add checkbox to hide the dialog
  - Requirement #2902 : Browser-Check: Save checkbox status to cookie
  - Requirement #2903 : Browser-Check: Provide key support on OK button  
* Thu Jan 22 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13003 : French translation broken, Syntax error: missing ; before statement
* Tue Jan 20 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #13003 : French translation broken, Syntax error: missing ; before statement
* Mon Jan 19 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12982 : [L3] Double-click of message in IE7 displays blank details popup
* Mon Jan 19 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12998 : calendar: sort by end date breaks sorting
  - Fixed bug #12995 : Search results show "all appointments from all calendars" after deleting in search results
  - Fixed bug #12986 : IE6: Red border not shown when creating appointment without description
* Fri Jan 16 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12918 : [L3] Folder icon of subfolder disappears while clicking RMB "Cut" twice
  - Fixed bug #12970 : [L3] Mailbox quota does not show up when the 'Check infobox' is checked
* Thu Jan 15 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12932 : IE: Webmailer shows annoying popups when jumping to the content field via Tab
  - Fixed bug #12846 : Removing link on infostore item throws JS Error
  - Fixed bug #12961 : [L3] Spam button on email Detail page does nothing
* Wed Jan 14 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12928 : IE7: Modifying a distributionlist in detail view throws error message
  - Fixed bug #12941 : Participant search results shown twice after switching to team selection dialog
  - Fixed bug #12940 : 404 Errors when accessing login page
  - Fixed bug #12934 : IE: Search filter list for E-Mail gets misaligned when hovering the entries
  - Fixed bug #12919 : contacts: private icon not shown in cards view
* Mon Jan 12 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12746 : Cannot delete one mail after another using DEL key
  - Fixed bug #12891 : [L3] Rename "Cancel" to "Close" in Email Detail Popup
* Mon Jan 12 2009 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12755 : GUI Plugin API: init function gets called twice when using it with oxIFrame
* Wed Jan 07 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #9891 : Contacts: Wording in delete confirmation popups not so nice
  - Fixed bug #12823 : [L3] Theming: Navigation Icons background change of image needed
* Mon Jan 05 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #12740 : Email list: icon answered overwrites forward
  - Fixed bug #12824 : [L3] Theming: Locked input fields wrong background color define
  - Fixed bug #12827 : [L3] Theming: Activity animated icon - implemented, application loads inappropriate icon
  - Fixed bug #12401 : [L3] Menue too small when creating new Mail filter
  - Fixed bug #11311 : [L3] Field values within tasks aren't saved correctly
  - Fixed bug #10981 : [L3] Mail attachment selection via context menu only works if no context menu has already been opened
  - Fixed bug #12858 : [L3] Business and Private contact data not consistent for Country and State
  - Fixed bug #12598 : Inplace editing in Safari triggers appointment to be created twice  
  - Fixed bug #12745 : moving email per drag and drop jumps to the first email in email list and not to the next
* Fri Dec 19 2008 - stefan.preuss@open-xchange.com
  - Requirement #1228 : Configuration of notification mails sending is possible
* Wed Dec 17 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12775 : Printing does not work in Infostore H-Split, Calendar List view
  - Fixed bug #12409 : The option "Delivery receipt" is no longer checked when editing a draft
* Wed Dec 17 2008 - markus.wagner@open-xchange.com
  - Fixed bug #12788 : DnD an appointment in the week view resets start and end time
* Tue Dec 16 2008 - choeger@open-xchange.com
  - Fixed bug #12756 : 6.7.0-${pversion} shown for SP5 RC1 GUI as version string
    Added accidently removed PVERSION inclusion again
* Tue Dec 16 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12764 : Calendar List view shows start date as end date
* Mon Dec 15 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12503 : [L3] Shared calendar: You do not have the appropriate permissions to modify this object
  - Fixed bug #11328 : [L3] Copied/duplicated tasks or contacts don't contain links and attachments
  - Fixed bug #12752 : Automatic scrolling (up) of foldertree isn't possible
  - Disable add/remove attachment buttons in the new window when module Infostore isn't available for the user
* Tue Dec 09 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12717 : mail.hsplit.foldername warning in webmail context when refreshing with F5
  - Fixed bug #12158 : Infostore: Missing space between links and number of links in detail view
  - Fixed bug #12718 : IE6: Enter H-Split from start page leaves details empty
* Mon Dec 08 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11880 : E-Mail: Possible functions are strange when opening attached e-mail
  - Fixed bug #11280 : Tasks with due date > 1 year are not shown at the start page
  - Fixed bug #11638 : wrong description of recurring appointment
  - Fixed bug #11489 : theming: images are always used from the default theme
* Fri Dec 05 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12252 : Error message during autosave of email which has attachments
  - Fixed bug #9668 : Calendar week views: Wrong "today" day will be shown on sunday's if calendar view is set to 'week - view'
* Thu Dec 04 2008 - stefan.preuss@open-xchange.com
  - Updated tinyMCE WYSIWYG editor to latest release 3.2.1.1
* Tue Dec 02 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12457 : InfoStore: Inconsistent Path Display
* Mon Dec 01 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12201 : minicalendar and work week not consistent
  - Fixed bug #12204 : UWA configuration layout problem on 1024x768 with french language
  - Fixed bug #11982 : IE6 shows warning message about insecure items on SSL link when accessing the configuration on a "webmail" context
  - Fixed bug #11680 : Multiple day appointments are one day longer in calendar list view
  - Fixed bug #12652 : Unable to create subfolders of shared folders
  - Fixed bug #10885 : resizing causes javascript error
  - Fixed bug #12633 : Task H-Split does not show the "tag" attribute
  - Fixed bug #11745 : InfoStore: InfoItem accessed from start page asks to be deleted two times
  - Fixed bug #12647 : JSON attribute error message on logout
* Mon Dec 01 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12468 : No error message shown when trying to move task or appointment to a shared folder
* Thu Nov 27 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12631 : [L3] Mail won't be deleted when opened under IE6 and FF2/3
  - Fixed bug #12632 : [L3] Mail opened when it should be deleted
  - Fixed bug #12613 : Different behaviour of calendar views "week" and "month"
  - Fixed bug #12065 : Team View - Work Week shows only first day as busy for all day apps
* Tue Nov 25 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11522 : [L3] Unable to open two e-mails in separate window
  - Fixed bug #11636 : tasks: external participant without display name is shown as undefined
  - Fixed bug #11902 : no browser context menu in infostore comment field
  - Fixed bug #12101 : Confirmation to delete the whole series shown for a exception does only delete the single exception
  - Fixed bug #11831 : Modifying a exception of a appointment shows "change series/appointment" dialog
* Mon Nov 24 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11894 : OX6 SP5: email hover marks mail as read
  - Fixed bug #11734 : Availability of a markup-side indicator for checked/unchecked status of the subscribe mailfolder checkbox
  - Fixed bug #12605 : Quota bars trigger JS Error in IE6 on special condition
  - Fixed bug #12606 : IE6: Quota text information are not fully shown
  - Fixed bug #12088 : Moving a E-Mail to a folder without ACL write permission does not show error message at the UI
* Fri Nov 21 2008 - Viktor.Pracht@open-xchange.org
  - Added JsDoc source documentation
* Fri Nov 21 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12597 : Missing delete dialogue for recurring appointments in calendar week view
* Thu Nov 20 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12579 : Strange Success Message on change personal data
* Thu Nov 20 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12489 : Error message thrown during change of recurring appointment
  - Fixed bug #12537 : Serial task is not recurring and stops after the first occurence
  - Fixed bug #11975 : unable to remove due date and start date from tasks
* Wed Nov 19 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12566 : Myself always added to edit dialog of appointments in a shared folder
* Wed Nov 19 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12570 : frensh translation broken
* Tue Nov 18 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12536 : Task estimated/current duration is incorrect if it is > 1 Day
* Fri Nov 14 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11974 : Pre-set time is 00:00 when creating new appointment via doubleclick
  - Fixed bug #12524 : new signature window (layer) too small
  - Fixed bug #12523 : creating a contact directly with drag n drop from an email broken
  - Fixed bug #12427 : InfoStore: Versions tab doesn't show number of versions but current version
  - Fixed bug #12141 : panel arrow does not disapear for NEW icons when all are present
* Thu Nov 13 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #9964 : [L3] Quota based on messages is not supported
  - Fixed bug #11707 : contacts: selection get lost when switching from list to card view
* Wed Nov 12 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12507 : Calendar interval is not effective when leaving the configuration page via a click to the module
  - Fixed bug #12511 : Team WorkWeek view not clickable
  - Fixed bug #12165 : [Vul] [Dev] /ajax/contacts?action=image requires session ID
* Tue Nov 11 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12369 : [Vul] Session hijacking in Open-Xchange
  - Fixed bug #12498 : Deleting a folder with a mail inside the trash folder brings up folder not found error
* Mon Nov 10 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12480 : GUI build broken on SLES, Debian and RHEL because of too old gettext version
  - Fixed bug #12444 : [L3] Adding participants to appointment while changing it fails
  - Fixed bug #12379 : Calendar Work Week: Doubleclick does not open an appointment
  - Partially fixed bug #11311 : [L3] Field values within tasks aren't saved correctly
  - Fixed bug #12404 : [L3] Screen is moving when changes are saved
* Fri Nov 07 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12477 : When changing task recurrences , GUI does not send all needed information
* Thu Nov 06 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11870 : hover: participants are displayed as undefined
  - Fixed bug #11665 : Multiselect delete does not work in distributionlist
  - Fixed bug #12160 : InfoStore: Send as link: "Link / URL" vs. "Direct Link"
* Thu Nov 06 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12398 : folder undefined in group plugin
* Wed Nov 05 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12421 : [L3] Appointment series cannot be edited
  - Fixed bug #12264 : [L3] appointment recurrence change not saved
  - Fixed bug #9072 : Cursor does not change its symbol when hover over an arrow in the contact-detail-view
* Wed Nov 05 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12473 : Strange behaviour of some input fields in the OX groupware
* Tue Nov 04 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12413 : Calendar: Month list view hides appointments on 2008-10-31
* Mon Nov 03 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12341 : [L3] No notification mail for moved (drag&drop) appointments
  - Fixed bug #12454 : Reminders are always set 625days in the past
* Mon Nov 03 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12444 : [L3] Adding participants to appointment while changing it fails
* Fri Oct 31 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12435 : Language is english, Setting is German
* Thu Oct 30 2008 - ben.pahne@open-xchange.com
  - Fixed bug #12423 - E-Mail: Selecting a color flag from the panel has no effect
* Thu Oct 30 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12425 : Reminder is shown as "undefined Minutes"
  - Fixed bug #12430 : IE7: InfoStore grid distorted
* Wed Oct 29 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11658 : [L3] Unable to move a mailfolder to INBOX level
  - Fixed bug #12417 : Can't search for participants
* Wed Oct 29 2008 - ben.pahne@open-xchange.com
  - Fixed bug #12283 - Contacts "Add picture" popup undersized
  - Fixed bug #12230 - Unable to add external member to a distribution list if the E-Mail address contains a _ (Underscore)
* Tue Oct 28 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12309 : [L3] No icon in case of more than one whole day appointments in month view
  - Fixed bug #12155 : typos in pot
  - Fixed bug #12273 : Unable to save a encapsulated E-Mail attachment to the infostore
* Tue Oct 28 2008 - Viktor.Pracht@open-xchange.org
  - Fixed deleting of mails with and without copying to the trash folder
  - Fixed bug #11785 : Duplicate Hovers are displayed when triggering another Hover
  - Fixed bug #12397 : Resource Management module livegrid headline broken, seems to be i18n
  - Fixed bug #12402 : [L3] Time calculation in reminder Popup not correct
* Mon Oct 27 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12324 : [L3] "From" select field within New Mail window doesn't show all addresses
  - Fixed bug #11296 : Inconsistent usage of displayname and surname,givenname in participant selection dialogs
  - Fixed bug #12383 : Infostore Portal Overview only shows creator where it should display author of last modification
* Mon Oct 27 2008 - ben.pahne@open-xchange.com
  - Fixed bug #12208 : Scrollbar of the hover not on the most right position
* Mon Oct 27 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11668 : Configpages are empty sometimes
* Thu Oct 23 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11743 : a new folder below "öffentliche Ordner" gets no rights for all users but create subolders
  - Fixed bug #11317 : hand mouse button icon but no action on klick in folder tree
  - Requirement #2616 : Creator of an appointment will be shown in the conflicting dialog
  - Requirement #2625 : Show status of conflicting appointment at the conflict dialog
* Thu Oct 23 2008 - Viktor.Pracht@open-xchange.org
  - Requirement #2624 : Adding groups and resources to team views
* Wed Oct 22 2008 - stefan.preuss@open-xchange.com
  - Requirement #1184 : The path information of the current location is shown
  - Requirement #1182 : Display who created and who last changed an object in InfoStore
  - Fixed bug #12261 : [L3] Wrong folder icon for newly created folder
  - Fixed bug #12284 : Folder description does not get translated for rootfolders
* Tue Oct 21 2008 - stefan.preuss@open-xchange.com
  - Requirement #1643 : Auto search in participant and address book dialog can be disabled
  - Requirement #2630 : Admin can setup a minimum search pattern length for the participant and address book dialog
  - Requirement #81 : Sorting mails loses track of active e-mail
* Mon Oct 20 2008 - stefan.preuss@open-xchange.com
  - Requirement #1695 : Detail view is removed at the E-Mail Module
  - Fixed bug #12247 : can't jump from startpage to detail email view
* Fri Oct 17 2008 - stefan.preuss@open-xchange.com
  - Requirement #1121 : Detail view isn't available at the InfoStore module
  - Fixed bug #12339 : [L3] task can not be printed in detail view when % done is set
* Fri Oct 17 2008 - Viktor.Pracht@open-xchange.org
  - Requirement #2666 : Prepare GUI framework for i18n
  - Requirement #1043 : GUI plugins integrate in the i18n infrastructure of the GUI
* Wed Oct 15 2008 - stefan.preuss@open-xchange.com
  - Requirement #1131 : New function at the Panel, Section Task "Mark as done" is available
  - Requirement #1130 : A new function at the RMB menu at all list views "Mark as done" is available
* Tue Oct 14 2008 - stefan.preuss@open-xchange.com
  - Requirement #1120 : Detail view isn't available at the task module
  - Requirement #1129 : Displaying of participants of tasks at the H-Split/Detail view
  - Requirement #1125 : Display end date of tasks in red which are overdue  
  - Requirement #1126 : Display task which marked as done slashed and greyed out
  - Requirement #1123 : The default list view is changed for task
* Sun Oct 12 2008 - ben.pahne@open-xchange.com
  - Fixed bug #12360 : can't delete infoitem when entered from startpage
  - Fixed bug #10580 : Contacts find-as-you-type searches global
* Tue Oct 07 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11729 : February 2009 is not shown in calendar month view when switching months, not possible to create apps via month view
* Mon Oct 06 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12263 : [L3] appointment frozen after edit
* Thu Oct 02 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12260 : [L3] note not saved on duplicat tasks
  - Fixed bug #12262 : [L3] Can not create Subfolder in Infostore
* Wed Oct 01 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12147 : [L3] Email sort setting gets lost for H-split when changing modules
* Mon Sep 29 2008 - stefan.preuss@open-xchange.com
  - Requirement #1352 : Typo in series dialog
* Thu Sep 25 2008 - stefan.preuss@open-xchange.com
  - Added checkbox to each row within the tasks list views to change the status quickly
* Tue Sep 23 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12213 : Wrong end time is shown in calendar after moving appointment via drag & drop to an other day
  - Requirement #212 : Birthday appointment are created directly from contact module
* Mon Sep 22 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #10829 : Start page does not show all my infostore updates
  - Re-Added the missing space around the E-Mail content at the detail views
  - Fixed bug #11103 : [L3] Distribution list gets not cleared on cancel
  - Requirement #212 : User wants to see full folder path and unread counter in the list views
* Mon Sep 22 2008 - choeger@open-xchange.com
  - Fixed bug #12076 : Warning message "Javascript disabled" has broken umlauts
    added -Dfile.encoding=UTF-8 to ANT_OPTS
* Sun Sep 21 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12192 : [L3] "Broken" e-mail address isn't saved within a distribution list
  - Fixed bug #11454 : [L3] IE7: Foldername not selected automatically when creting new subfolder
  - Fixed bug #11022 : [L3] - Translation after changing default language setting for folders wrong
  - Fixed bug #12189 : [L3] Hover of empty distribution list shows data from previous selected contact
* Fri Sep 19 2008 - Viktor.Pracht@open-xchange.org
  - Fixed the GUI part of bug #12183 : [L3] Errror message for a SIEVE "body" rule
  - Fixed bug #12187 : [L3] [IE6] Date format settings dialog broken
  - Fixed bug #12191 : [L3] External e-mail address for a distribution list doesn't work...
  - Fixed bug #12188 : [L3] - HTML-Mails not displayed correctly
  - Fixed bug #12134 : [L3] New Versions of documents in Infostore not updated
* Thu Sep 18 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12178 : E-Mail: forwarding message with an empty subject as attachment not possible
  - Fixed bug #12185 : Direct Link in notification mails broken when opened for the second time
* Thu Sep 18 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #10846 : Changing a filestore item in detail mode destroys detail view of this item for the current session
* Wed Sep 17 2008 - Viktor.Pracht@open-xchange.org
  - Reverted fix for bug #11809 : Termiology of "Discard" at Mailfilters are not correct
* Tue Sep 16 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12159 : IE7: Configuartion/User: Unable to open edit password dialogue due to javascript error
* Mon Sep 15 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #10597 : InfoStore: Printing doesn't include linebreaks
* Fri Sep 12 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12053 : IE6: HTML Editor font/size selectors shown through participants/file popups when clicking them
  - Fixed bug #11676 : Metadata fields are set to "undefined" when editing a infoitem upload via webdav
  - Fixed bug #11978 : IE6: New/Edit Infostore windows throws JS error
  - Fixed bug #8068 : We should place a "favicon.ico" file into the apache doc root
* Fri Sep 12 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12150 : right click menu doesn't close
  - Reopened bug #11610 : rmb menu popups up
  - Fixed bug #12151 : Missing confirmation for saved settings in Mailfilter modul
  - Fixed bug #10553 : Attached e-mail messages not visible in hover's attachment section
* Thu Sep 11 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11893 : E-Mail list hangs up
  - Fixed a problem that useless list request made on a folder or view change
  - Fixed a problem of wrong shown sort options within the v-split
  - Fixed bug #11506 : Subject not shown during drag and drop
  - Fixed bug #12147 : [L3] email sort setting gets lost for h-split when changing folders
  - Fixed bug #12144 : [L3] To field not displaying the recipient email address
* Thu Sep 11 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11990 : can not create sieve rule with "" in tag
  - Fixed bug #10504 : Reminder for tasks shows 01.01.1970 00:00
  - Fixed bug #10506 : PMG: Empty space between "move" and "close" closes the portal item
* Wed Sep 10 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11610 : rmb menu popups up
  - Fixed bug #10014 : Unable to remove attachment when forwarding E-Mail
  - Fixed bug #10035 : Autocomplete - Scrolling of search results
* Wed Sep 10 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11512 : No chance to reload blocked images when opening e-mail in separate window
  - Detail message pop-up uses ObjectCache now
  - Fixed a problem that the LiveGrid requested single columns more then once 
* Tue Sep 09 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11516 : Calendar: Unnecessary space between icons in week view
  - Fixed bug #12131 : "Mark as" for Mails doesn't work if Mail is doubleclicked
  - Fixed bug #12132 : "Mark as" Mail overview has less options than "Mark as" in opened Mail
  - Fixed bug #11513 : Calendar week view: Appointment changed although no changes were made
* Tue Sep 09 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12076 : Warning message "Javascript disabled" has broken umlauts
* Mon Sep 08 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #7531 : (mail) the forwarded mail icon is not indicated for a forwarded mail
  - Fixed bug #11239 : GUI writes read-only settings in preferences tree
  - Fixed bug #11243 : confusing messages when logout
  - Fixed bug #12075 : minicalendar does not highlight the direct link day but the current
  - Fixed bug #11514 : IE7: E-Mail: Print preview is missing something in the header
  - Fixed bug #11508 : IE7: Collapsed V-Split header misaligned
  - Fixed bug #12110 : In month view created appointment starts at 0 o'clock
  - Fixed bug #12107 : can't expand group in hover
  - Fixed bug #12087 : JS Error in mail detail window
  - Fixed bug #10822 : Unnecessary scrollbars in empty list when resolution < 1024x768
* Mon Sep 08 2008 - Viktor.Pracht@open-xchnage.org
  - Fixed bug #9855 : Infostore: Number of versions is not shown behind the "Versions" string
* Fri Sep 05 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12112 : [L3] Selecting a E-Mail with OX-Directlink leads to severe JS error in IE6/IE7
  - Fixed bug #11618 : Directlinking broken on first acess, works when selecting a second element with direct link
  - Fixed bug #11900 : Directlinking does not work correctly with IE6, redirect to "wrong browser" startpage
  - Fixed bug #11641 : E-Mail: Direct links sometimes open in the e-mail i-frame
  - Fixed bug #11806 : Opening a linked object for editing doesn't deactivate the address and tool bar in new browser window
  - Fixed bug #11779 : IE7: Arrow in cascading "New Subfolder" contextt menu not aligned correctly
  - Fixed bug #11788 : Availability: "Occupied" vs. "Absent on business"
  - Fixed bug #11777 : IE7: Checkboxes in new e-mail panel have grey border
  - Removed GUI testing themes "Ochre" and "Darksagreen"
* Tue Sep 02 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #10892 : PMG, Start Page, External modules: relogin needed if curently enabled modules were saved automatically
  - Fixed bug #10715 : Typographic incorrect apostrophs in display names cause syntax error when adding user to distribution list
  - Fixed bug #11887 : [L3] clicking triangle next to the column name does not sort the search result
  - Fixed bug #11679 : [L3] Week number in mini calendar always links to private calendar
  - Fixed bug #11706 : [L3] calendar: the minicalendar day does not move when day view headline changes
* Mon Sep 01 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8929 : Create Object with attachment, press save again
* Mon Sep 01 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12081 : Anchors in HTML E-Mail lead to new Browser window with attached anchor to OX URL
* Fri Aug 29 2008 - ben.pahne@open-xchange.com
  - Improved Contact Hover Layout
  - Fixed a bug with broken Infostore hovers
* Fri Aug 29 2008 - stefan.preuss@open-xchange.com
  - Added enabled modules check. After login, the first available and enabled module will be activated and selected.
  - Added imap availability check during the login process. If the server isn't available the user will get an error dialog and the module will be disabled.  
* Thu Aug 28 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #10753 : Increasing number of requests when using "Infobox" Inbox link
  - Fixed a problem that you could send infostore items as link or attachment even though the module mail has been disabled
* Wed Aug 27 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11994 : Mailfilter empty "Move to folder" fills "undefined" to the sieve rule
  - Fixed timescales in team and availability views.
* Wed Aug 27 2008 - ben.pahne@open-xchange.com
  - Task Hover now using the ObjectCache
  - Contact Hover now using the ObjectCache
  - Infostore Hover now using the ObjectCache
* Wed Aug 27 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11291 : Unable to remove comments from recurring objects
  - Fixed bug #10570 : Signature field does not respond when jumping there via TAB
* Tue Aug 26 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11993 : Mailfilter empty "Redirect to" throws exception
  - Fixed bug #12064 : Dateformat string do not get translated when loggin in
  - Fixed bug #12066 : [L3] Cannot add attachement to newly created appointment
* Tue Aug 26 2008 - ben.pahne@open-xchange.com
  - Improved Hover Tab Images with shadows
* Mon Aug 25 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11875 : email hover: to much numbers behind the decimal point
* Mon Aug 25 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #4199 : [Error] Error code when email not accessible is misleading
  - Fixed bug #11837 : Moving a mail in detail view does not jump to another view
  - Fixed bug #11838 : E-Mail folder content does not reload when renaming a folder
  - Fixed bug #11983 : [L3] The hand cursor is not displayed in the tag pop-up
  - E-Mail Hover now using the ObjectCache
* Thu Aug 21 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11867 : scrollbar in hover not completely visible
  - Fixed bug #11750 : Hover tab positions do not reset when opening another hover, no content shown
* Thu Aug 21 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11918 : [L3] Cannot edit yet created distribution list
  - Fixed bug #11818 : Contacts - Double-click on a distribution list opens contact editor, not the list editor
  - Disabled E-Mail hover by default and set delay time to 'Long'
* Thu Aug 21 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #12033 : Endless loop after changing a object on a infostore search result list
  - Fixed bug #12025 : Self.collection is null when switching mail folder view while content has not been loaded completeley
* Wed Aug 20 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11802 : Fixed column width missing in the date picker dialog
  - Fixed bug #11893 : E-Mail list hangs up
* Wed Aug 20 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #9971 : CalendarCommonCollection.getWritePermission Unexpected SQL Error
* Tue Aug 19 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11590 : Infostore search shows wrong documents in list view
  - Fixed bug #12019 : Passwordchange "Old password" inputfield is not a password-field
  - Fixed bug #12026 : my filter rules make ox filter gui hang
  - Fixed bug #12021 : [L3] Deleted mail is requested after refresh
* Tue Aug 19 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12016 : Cannot create subfolder under the root folder/public folder
  - Fixed bug #11678 : newDistributionList.html wants to get non existing css file
  - Fixed bug #11770 : E-Mail: Huge font chosen for printout of plain text mails
* Mon Aug 18 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #12004 : typo and error message
  - Fixed bug #11020 : [L3] Double click on attachment within contact triggers error message
  - Fixed bug #11362 : [L3]- Moving serial apps. in listview broken
  - Fixed bug #12005 : Rewrite sentence in pot
  - Fixed bug #11744 : new personal subfolder get created with rights for "Alle Benutzer und Gruppen"
  - Fixed bug #12009 : Typo in pot
  - Fixed bug #11935 : tasks: missing icon in resolved group
  - Fixed bug #12006 : cannot create mail folder on UW IMAP
  - Added additional information when sending a direct link
  - Partially fixed bug #11951 : [L3] The customer should be able to set a logout URL
  - Made logout, session expire and direct links configurable 
* Mon Aug 18 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #10749 : [L3] Hours should be displayed bold if interval has been set to 60 minutes
  - Fixed bug #11938 : iframes broken on internet explorer
  - Fixed bug #11999 : Mailfilter condition "Matches" and "Matches SIEVE regex" are interchanged
  - Fixed bug #11931 : No user confirmation when deleting groups
  - Fixed bug #11310 : Calendar list view drops 30.03.2008 when moving backwards using the arrow keys
  - Fixed bug #11995 : Mailfilter action "Send vacation notice" triggers exception
  - Fixed bug #11961 : New filter rule is inserted behind vacation rule
* Fri Aug 15 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11457 : E-Mail "View" panel does not get a expand arrow if set to <4 rows
  - Fixed bug #11769 : E-Mail: Missing image for "Show Source" in context menu
  - Fixed bug #11972 : [L3] All of future tasks/appointments show up regardless of the setting
  - Fixed bug #10209 : [L3] polish currency zloty is missing in tasks
  - Fixed bug #11566 : [L3] currency for new tasks is always EUR
  - Fixed bug #11511 : [Always] Tasks: Wrong icon for external participants in detail view
  - Fixed bug #11155 : [Always] Infostore "New Folder" is not shown if the Userstore is collapsed
  - Fixed bug #11384 : Contacts: could not flag a contact in phone list view
  - Fixed bug #11632 : day of week not translated on the startpage
  - Fixed bug #11336 : [L3] Saving a changed appointment into a folder without read permission fails
* Fri Aug 15 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11590 : Infostore search shows wrong documents in list view
  - Fixed bug #11107 : [Always] Calendar Week View: The object has changed in the mean time on object modification
* Thu Aug 14 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #7277 : Calendar views get misaligned with different font sizes
  - Fixed bug #11748 : Change Password: when you leave the page, you are asked if you want to save even if you changed nothing
  - Fixed bug #11809 : Termiology of "Discard" at Mailfilters are not correct
  - Fixed bug #11945 : missleading description "Automatic reply active"
  - Fixed bug #11955 : no feedback while saving vacation notice
  - Fixed bug #11704 : Folder selection for mail filter too small
  - Fixed bug #11954 : Unable to read checkbox content when creating a filter rule
  - Fixed bug #11944 : Vacation text area is very small
* Thu Aug 14 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11464 : delete task in detail view doesn't switch to list view
  - Fixed bug #11791 : E-Mail: Direct links to infoitem not working when composing html mails
  - Fixed bug #11456 : [L3] HTML editor overlaps priority selection box
* Wed Aug 13 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11808 : Mailfilter action "Tag mail with" is missing at Dropdown list
  - Fixed bug #11930 : Unable to delete resources via plugin
  - Fixed bug #11960 : No deletion of Vacation rules, Spam rules and old mailfilter rules possible
  - Fixed bug #11801 : Calendar views show 24hours format even if language is english and date is predefined
* Wed Aug 13 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11952 : [L3] In the Email module, while saving the the attachment to Infostore, the 'Infostore Item' window does not close. The attachment gets saved to Infostore
  - Fixed bug #11909 : E-Mail-Module - Change order of functions at E-Mail-Section (Spam-Button)
  - Fixed bug #11913 : [L3] Number of calendar weeks too small in Mini calendar
  - Fixed bug #11888 : [L3] Emails in Draft folder shall be handled as draft
* Tue Aug 12 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11911 : Switching from mail filter to another module and back breaks the GUI
  - Fixed bug #11923 : JSON error when editing a group after creating a new one
  - Fixed bug #11924 : Unable to change a existing group twice
* Mon Aug 11 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11612 : Unable to test password change plugin, activating user password edit seems noop
  - Fixed bug #11906 : mail filter rule isn't correctly saved
* Fri Aug 08 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11850 : Remove Browser Warning for Safari
  - Fixed bug #8367 : L3: layout problems on 1920x1200
* Thu Aug 07 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11867 : scrollbar in hover not completely visible
  - Fixed bug #11853 : wrong taborder in new contact private tab
* Thu Aug 07 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11753 : Possible to remove other user's / contacts from global address book
* Wed Aug 06 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11570 : search in infostore ends in infinite loop
* Tue Aug 05 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11634 : IE: null in input box when personal data isn't set
* Mon Aug 04 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11804 : Mailfilter kills SPAM rule
* Mon Aug 04 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11776 : Personal data settings display name should be marked as mandatory
  - Fixed bug #11387 : No (visual) selection in "select tags" dialog
  - Fixed bug #11510 : Error while displaying e-mail hover with direct link
* Fri Aug 01 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11710 : Hover corners of tabs are not transparent
* Wed Jul 30 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11626 : Wasteful question when clicking through the config options
* Tue Jul 29 2008 - Viktor.Pracht@open-xchange.org
  - Implemented a group administration plugin
  - Implemented a resource administration plugin
* Tue Jul 29 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11738 : Success message on changing personal data even if it fails to save them
* Tue Jul 29 2008 - ben.pahne@open-xchange.com
  - Fixed bug #11760 : Broken Hover Tabbing in Contacts
* Mon Jul 28 2008 - ben.pahne@open-xchange.com
  - Requirement #205 : Add of tabbing to hover windows
* Thu Jul 24 2008 - stefan.preuss@open-xchange.com
  - Requirement #236 : Added sub-context menu to select folder type when creating a new folder
  - Fixed bug #11441 : Unable to create subfolder in a folder that is shared to another user...
  - Fixed bug #11408 : Unable to create subfolder although having sufficient access rights to parent
* Wed Jul 23 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11626 : Wasteful question when clicking through the config options
* Mon Jul 14 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11601 : Invalid picture path for unflagged objects
  - Requirement #238 : Add subscribe folder dialog
* Mon Jul 14 2008 - stefan.preuss@open-xchange.com
  - Requirement #215 : Re-Ordering of some panel functions
* Thu Jul 10 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #8963 : Icons in two-column panel sections are not equal aligned
  - Fixed bug #11461 : long title and location breaks confirmation dialog
  - Fixed bug #11444 : Conflict Dialog: English date formats cause strange line breaks
  - Fixed bug #10701 : Option unclear: Number of appointments which are shown in ... view  
  - Fixed bug #11599 : JS Error in Infostore, seems to break several functionality
* Thu Jul 10 2008 - ben.pahne@open-xchange.org
  - Fixed bug #11589 : Can't save personal data with birthday
* Thu Jul 10 2008 - antje.faber@open-xchange.com
  - Fixed bug #11598 : day view broken with german language
* Thu Jul 10 2008 - stefan.preuss@open-xchange.com
  - Fixed bug #11556 : Unable to open attached E-Mail messages in forwarded E-Mails
  - Fixed bug #11616 : normal appointments marked as recurring
  - Fixed bug #11511 : Tasks: Wrong icon for external participants in detail view
* Wed Jul 09 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11568 : unusable time dropdowns in availability tab
  - Fixed bug #11264 : Typos in English GUI
* Wed Jul 09 2008 - ben.pahne@open-xchange.org
  - Added new Plugin Passwordchange & Userdatachange
* Tue Jul 08 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11576 : Unable to create new appointments via GUI
* Fri Jul 04 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11499 : [L3] Search in shared calendar folder doesn't work
  - Fixed bug #10854 : dnd selects folder
  - Fixed bug #10802 : Availibilty screen does not scroll correctly with a larger number of participants
  - Fixed bug #9874 : IE7: Calendar/Team work week view not aligned correctly
  - Fixed bug #10853 : New Appointment, Availability Tab: Labels are misaligned
* Thu Jul 03 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11557 : Unable to create a new appointment with preset values when opening "new appointment" via doubleclick
  - Fixed bug #11544 : mailfilter: while setting vacation "Error while communicating with the sieve server"
* Thu Jul 03 2008 - stefan.preuss@open-xchange.org
  - Added iframe stylesheet for mail detail views
* Wed Jul 02 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #9921 : no difference between "0 minute" reminder and "no reminder"
  - Fixed bug #11442 : no name in contacts hover
  - Fixed bug #11537 : JS error after saving a global addres book entry
  - Fixed bug #11549 : Wrong date in email
  - Fixed bug #11553 : Unable to print in contacts detail view
  - Fixed bug #11551 : IE6: JS-Error in new appointment window
  - Fixed bug #11517 : E-Mail: Delivery receipt is being sent again and again
  - Fixed bug #11452 : Deleting a contact in detail view doesn't jump back to default view
  - Fixed bug #11284 : Calendar: External participants cause error message when viewing the appointment
* Tue Jul 01 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11540 : mailfilter: filter with action move to mailfolder, the folder then is shown as undefined
* Tue Jul 01 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11100 : [L3] distribution list: custom form, no valid email check
  - Partially fixed bug #11499 : [L3] Search in shared calendar folder doesn't work
  - Fixed bug #11427 : [L3] groups and resources are shown within private contact folders
  - Fixed bug #7260 : Email: Field "Organization" missing
  - Fixed bug #11409 : Typo in Error message on save on exit
* Mon Jun 30 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11535 : mailfilter: Fehlermeldung: Ausnahmefehler beim Parsen von JSON...
  - Fixed bug #11404 : Appointment cannot be modified (after changing the date format)
* Mon Jun 30 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11103 : [L3] distribution list gets not cleared on cancel
  - Fixed bug #11101 : [L3] distribution list: custom form, cursor from underlying window is visible
  - Fixed bug #10906 : [L3] no cursor visible in the UWA new mask
  - Fixed bug #11361 : [L3] Hover is shown although the background is deactivated
  - Fixed bug #11213 : [L3] "Attachment" panel section stays active when switching folder
  - Fixed bug #10607 : "today button" too short for french caption
  - Re-added missing disabled background image
* Fri Jun 27 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11084 : [L3] hover language does not change when switching from English to German
  - Fixed bug #11082 : [L3] calendar: double click on all day appointment opens two windows in week view
  - Fixed bug #11081 : [L3] settings: email signatures without name possible but not shown afterwards
  - Fixed bug #11066 : [L3] Header titles are wrapped in the infostore view for Japanese
  - Fixed bug #11097 : [L3] distribution list: custom form, contacts field can be edited without effect
* Thu Jun 26 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11523 : Unable to delete a E-Mail in detail view when accessed via portal page
  - Fixed a problem that deleting a message from the detail pop-up window doesn't refresh the underlaying view
* Thu Jun 26 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11519 : sieve filter could not be saved
* Wed Jun 25 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11449 : Unable to add a user to a groupware object with current user +1 user id
  - Fixed bug #11458 : E-Mail "From" is not shown in collapsed mail header
  - Fixed bug #11459 : Switching from folder properties to configuration triggers blank page
  - Fixed bug #11503 : missing border in minicalendar
  - Fixed bug #11447 : IE7: E-Mail / V-Split: Sort order dropdown arrow moved down one line
  - Fixed bug #11501 : Imageblocker bar is not shown when accessing a E-Mail via startpage
  - Fixed bug #11505 : E-Mail list and body part stops loading with JS error
* Wed Jun 25 2008 - Viktor.Pracht@open-xchange.org
  - Fixed bug #11502 : IE7: error when login, groupware unusable
  - Fixed bug #11488 : No new/changed appointment notification at the UI without relogin
* Mon Jun 23 2008 - choeger@open-xchange.com
  - Fixed bug #11119 : ox he gui is installed in wrong location on centos and rhel
* Mon Jun 23 2008 - stefan.preuss@open-xchange.org
  - Requirement #1270: In the card view selection "ALL" won't be translated. 
  - Requirement #1884: E-Mail: Must be possible to print the detail message in all list views 
* Thu Jun 19 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11374 : IE7: No space between foldername and "unread counter" in the foldertree
* Wed Jun 18 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11433 : E-Mail: Sending a delivery receipt doesn't work
  - Fixed bug #11394 : [Always] Switching to a shared calendar keeps displaying my own calendar
  - Fixed bug #11434 : Long appointment titles overlap in conflict dialogs
  - Fixed bug #11435 : After a conflict I cannot save the appointment any more
  - Fixed bug #11425 : Scrollbars for multiple recipients are not shown in E-Mail Views
  - Fixed bug #11353 : edit distribution list in phonelist view fails
  - Fixed bug #11406 : IE7: Week view displays recurring appointments twice
  - Fixed bug #11391 : Clickable region in "Picture" menu at the panel is misleading
* Wed Jun 18 2008 - jan.finsel@open-xchange.org
  - Fixed bug #11165 : E-Mail: After deleting an E-Mail the selection always jumps back to the first message in the list
* Wed Jun 18 2008 - Viktor.Pracht@open-xchange.org
  - Implemented a mail filter plugin.
* Tue Jun 17 2008 - jan@open-xchange.org
  - Fixed bug in infostore, tasks and contacts with edit in Livegrid and reload 
  - Fixed bug #11377 : whole day appointment not shown as free
* Tue Jun 17 2008 - stefan.preuss@open-xchange.org
  - Requirement #1722: Changed folder properties and folder rights management handling
* Fri Jun 13 2008 - stefan.preuss@open-xchange.org
  - Requirement #851 : Change logout message
* Thu Jun 12 2008 - jan@open-xchange.org
  - Fixed bug #10758 : [L3] print button is shown even if no object is selected
  - Fixed bug #11251 : Unable to assign flags after a flag has been assigned
  - Fixed bug #11354 : delete distribution list not possible
  - Fixed bug #11393 : E-mail body not displayed when switching between h-split / v-split view
  - Fixed bug #11399 : NumberFormatException instead of error message when trying to delete a locked infoitem
  - Fixed bug #11400 : Attachment counter wrong in contacts
* Thu Jun 12 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11385 : IE7: Javascript error when e-mail containing direct link is displayed
  - Fixed bug #11388 : date representation in month list and calendar view not consistent
  - Fixed bug #11374 : IE7: No space between foldername and "unread counter" in the foldertree
  - Fixed bug #11375 : Icon for unread mails missing
  - Requirement #176 : Display warning if message might be E-Mail scam
  - Requirement #221 : Click on root folder 'E-Mail' should directly select the 'Inbox' 
  - Requirement #229 : Should be possible to disable the animation at the mini calendar  
* Wed Jun 11 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11381 : IE7: E-Mail unusable after e-mail was autosaved and draft folder is active
  - Fixed bug #11382 : IE7: Theme dropdown not displayed in configuration/options, configuration cannot be saved
  - Fixed bug #11379 : IE7: Rename folder quite unusable due to misplaced scrollbar
* Wed Jun 11 2008 - jan@open-xchange.org
  - Fixed bug #11380 : Printing not possible in e-mail, tasks, contacts, infostore
  - Fixed bug #11407 : Continuous Errors in Webfrontend
  - Fixed bug #11386 : Attachments not displayed or displayed wrong in tasks
  - Fixed bug #11395 : Unable to view e-mail in detail view
  - Fixed bug #8868  : sort mails my unread/read is not working right
  - Fixed bug #9194  : Deleting task in list view causes shuffling positions of tasks in list
  - Fixed bug #11410 : Some fields are empty when switching from vsplit view to detail view
* Tue Jun 10 2008 - jan@open-xchange.org
  - Fixed bug #11390 : Calendar - After changing my record in the global addres book, foreign entries are shown
  - Fixed bug #11384 : could not flag a contact in phone list view
* Tue Jun 10 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11373 : Unable to edit draft
* Mon Jun 09 2008 - jan@open-xchange.org
  - Fixed bug #11279 : Deleting contacts reports "invalid value in attribute 'timestamp' value 'undefined'" errTor
  - Fixed bug #11285 : Moving contacts to other folders does not work
  - Fixed bug #11063 : Groupware UI throws "too much recursion" error if E-Mail module is unavailable
  - Fixed bug #11295 : Deleting of contacts is not possible.
  - Fixed bug #9458  : IE7: E-Mail: Javascript error when opening the e-mail window
  - Fixed bug #11080 : [L3] infostore: menu options not grayed out after getting a document is locked error
  - Fixed bug #11191 : Fast switching from H-Split to List view hides the list contents
  - Fixed bug #11279 : Fixed bug #11279 in tasks too...
* Mon Jun 09 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11198 : JS error when opening "New Contact" window on IE6
  - Fixed bug #8402 : Configuration tree does not update when modifying IMAP folders.
* Fri Jun 06 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11351 : Typos in pot file GUI
* Fri Jun 06 2008 - jan@open-xchange.org
  - Fixed bug #11356 : Detail Request was not unregistered in ObjectCache
  - Fixed bug #4336 : Mail->New Flags can not be set and are not displayed
  - Fixed bug #7439 : "Mark as" selection is not updated when switching E-Mail view
* Thu Jun 05 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11343 : E-Mail: Some header information won't be shown after selecting multiple messages
  - Fixed bug #11342 : Clicking an email in h-split/v-split twice let attachments disappear
  - Fixed bug #11345 : E-Mail: Unable to send infostore object as attachment
  - Fixed bug #11350 : E-Mail: JS Error when reading an E-Mail having any other priority than normal
* Tue Jun 03 2008 - stefan.preuss@open-xchange.org
  - Added new feature: multi-message forward
  - Fixed grid refresh after you marked a message as Spam or Ham
  -  Warnhinweis beim Lesen von potenziellen Phishing-Mails in der Detailansicht Pim - GUI disables Participants Dialog 
* Mon Jun 02 2008 - jan@open-xchange.org
  - Fixed bug #11166 : E-Mail: Selecting an E-Mail to read it renders the message four times
* Mon Jun 02 2008 - stefan.preuss@open-xchange.org
  - Warnhinweis beim Lesen von potenziellen Phishing-Mails in der Detailansicht Host (Admin) can change product name
  - Requirement #1483: Terminology: 'Ham' should be changed into 'No Spam'
* Fri May 30 2008 - stefan.preuss@open-xchange.org
  - Requirement #1080: Hoster (Admin) can change the About dialog
* Thu May 29 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11241 : Distribution list detail view does not open correctly
  - Fixed bug #11278 : Uploaded contact images are not shown at any view
  - Fixed bug #11196 : Unable to save E-Mail attachment to Infostore
* Tue May 27 2008 - jan@open-xchange.org
  - Fixed bug #11263 : Image loading blocker does not block css embedded images
  - Fixed bug #11312 : Theme- and Availability issue
* Wed May 21 2008 - jan@open-xchange.org
  - Fixed bug #10798 : Custom calendar view lacks a search field
* Mon May 19 2008 - jan@open-xchange.org
  - Fixed bug #11183 : search result gets lost when INBOX is refreshed
* Mon May 19 2008 - stefan.preuss@open-xchange.org
  - Requirement #362 : New user option to enable/disable auto save drafts
  - Requirement #187 : Auto save new messages to drafts folder
* Tue May 13 2008 - stefan.preuss@open-xchange.org
  - Requirement #691: New Option to enable / disable pre-loading of external images
  - Re-Design of the E-Mail settings page. Added new tabs 'Common, Compose and Display'
  - Requirement #85: Conflicts without title and username are useless
* Mon May 05 2008 - stefan.preuss@open-xchange.org
  - Fixed a problem when loading blocked images if a message contains both, in-line and external linked images
* Wed Apr 30 2008 - jan@open-xchange.org
  - Fixed bug #11121 : participant as resource isn't shown in groupware
  - Partially fixed bug #11166 : E-Mail: Selecting an E-Mail to read it renders the message four times
* Wed Apr 30 2008 - stefan.preuss@open-xchange.org
  - Requirement #372 : Add Image Privacy Warn-Dialog
* Mon Apr 28 2008 - stefan.preuss@open-xchange.org
  - Fixed an auto numbering problem when creating new E-Mail folders. Some mail server doesn't allow "()" characters within the folder name.
  - Fixed bug #11200 : "Add participant" hover does not close on IE browsers
  - Fixed bug #11199 : Empty fields in tasks show "null" in IE6
  - Fixed bug #11114 : Default values for test estimated/current duration and cost are set to "0"
  - Fixed bug #11197 : Unable to reply/forward mail with IE6
* Fri Apr 25 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #10982 : create-appointment window won't close automatically after saving
  - Fixed bug #11163 : month view shows wrong time format
* Thu Apr 24 2008 - jan@open-xchange.org
  - Fixed bug #11204 : Task participants are not shown
* Tue Apr 22 2008 - jan@open-xchange.org
  - Fixed bug #11182 : setting the time to 23:00 in new appointment window changes date
  - Fixed bug #11120 : Them selector shows "Ocre" as current theme after upgrading
* Tue Apr 22 2008 - stefan.preuss@open-xchange.org
  - Requirement #179 : Default view for Spam folder must be configureable
  - Fixed bug #11133 : Print of a E-Mail does not show the senders E-Mail address
  - Fixed bug #11170 : scrollbar in edit contact window
  - Fixed bug #11128 : Two-line notifcation after them change overlays frame
  - Partially fixed bug #11087 : UWA-Modules - Change information text for the link to the website
  - Fixed bug #11049 : Selenium tests fail because "saveAttachedFile" accesses parent frame
  - Fixed bug #11045 : Attachments: file size in detail view always displayed in KB
* Tue Apr 22 2008 - stefan.preuss@open-xchange.org
  - Requirement #83 : Visual feedback adding participants needed
* Mon Apr 21 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #9258 : L3: imap, deleted flag not implemented
  - Requirement #850: Reduced and/or removed paddings from the mini calendar at the side panel
* Fri Apr 18 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11159 : Task status is shown as "undefined" when creating tasks via webdav/xml 
* Tue Apr 01 2008 - jan@open-xchange.org
  - Fixed bug #11102 : Appointments not shown on calendar month view on weekends
* Wed Mar 26 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #11029 : propagation of folder rights on the root folder is confusing
  - Fixed bug #10704 : [L3] email folder "$ bla $" not displayed in folder tree and not selectable in the settings tree
* Wed Mar 19 2008 - jan@open-xchange.org
  - Fixed bug #11078 : could not link objects
* Mon Mar 17 2008 - stefan.preuss@open-xchange.org
 - Fixed bug #11032 : team work week shows wrong appointments when changing the team
 - Fixed bug #11065 : Tasks without start/due date are put to 01.01.1970
* Mon Mar 17 2008 - suphi.basdemir@open-xchange.com
 - Fixed bug #9421 : Actual day not highlighetd in WorkWeek View
* Fri Mar 14 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #10804 : [L3] HTML code of printout refers to "print/print.css" which doesn't exist
  - Fixed bug #10918 : Error when opening an e-mail in a folder with special characters, e.g. "Test & Test"
* Mon Mar 10 2008 - andreas.mayer@open-xchange.com
  - Fixed bug #10560 : Mini Calendar does not change the current day after 24 hours
* Wed Feb 27 2008 - andreas.mayer@open-xchange.com
  - Fixed bug #10643 : Calendar: appointment in team calendar is shown one day longer in work week view
* Tue Feb 26 2008 - andreas.mayer@open-xchange.com
  - Fixed bug #10768 : Inplace editing: Text selection should be reseted on mouse click
* Mon Feb 25 2008 - jan@open-xchange.org
  - Fixed bug #10957 : [L3] Cache overflow in calendar module
* Thu Feb 21 2008 - andreas.mayer@open-xchange.com
  - Fixed bug #10784 : "row has no properties" js error message on portal page (re)load
* Wed Feb 20 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #10757 : [L3] To and From not correctly displayed in email view
* Tue Feb 19 2008 - suphi.basdemir@open-xchange.com
  - Fixed bug #10919 : [L3] language selection is not sorted by alphabet
  - Fixed bug #10548 : contact can not be saved when birthday is 01.01.1970
* Wed Feb 13 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #10824 : Directlinks to infostore-item not working when your signature contains an URL
  - Fixed a Firefox problem that a click on an direct link sometimes doesn't work.
* Wed Jan 16 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #10770 : E-Mail: Last 'Save' Dialog pops up again when switching back to Module E-Mail
  - Fixed bug #10776 : [L3] first line of html emails are chopped
* Tue Jan 15 2008 - jan@open-xchange.org
  - Searching for Infostore items now search in all folders 
  - Optimized the slider handling
  - Fixed the 'inset' effect on panel buttons
* Tue Jan 15 2008 - stefan.preuss@open-xchange.org
  - Fixed bug #10766 : E-Mail: Direct links not marked under special circumstances
  - Changed the warning message when using a not supported browser
* Tue Dec 18 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10586 : E-Mail text not shown correctly when replying to a E-Mail with auto-signature enabled
  - Fixed bug #10599 : Collapsed E-Mail header in H/V-Split provides wrong Receipient E-Mail when clicking the Sender
  - Partially fixed bug #10633 : English Texts on German Start Page
* Mon Dec 17 2007 - suphi.basdemir@open-xchange.com
  - Key control for combobox, alphabetic scroll to item
* Mon Dec 10 2007 - jan@open-xchange.org
  - Fixed bug #10595 : IE7, E-Mail: Alert will be shown when ICQ6 is installed and you select a special pre-formatted message in LiveGrid
* Fri Dec 07 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10206 : E-Mail, Table header of drafts folder shows "Gesendet" which is wrong
  - Fixed bug #9361 : Sorting emails impossible in drafts folder
  - Fixed bug #9460 : [IE6] Recipient selection at "New E-Mail" is overlapped by dropdown menus
  - Partially fixed bug #10500 : L3: underscore in city names
  - Fixed bug #10078 : IE7: Calendar: "Members of <Team>" popup not aligned correctly
  - Fixed bug #10569 : Hovers do not work at "webmail" and "basic" modularization option
  - Fixed bug #10574 : "json is undefined" when switching tabs in contact detail view in "Webmail" configuration
* Fri Dec 07 2007 - jan@open-xchange.org
  - Fixed bug #10541 : Calendar hover lacks "Created by" information on 'Others' section
  - Fixed bug #10270 : PMG: Too logn filenames break hover shape / are cut
  - Fixed bug #10540 : IE7: Black dot in infoitem hovers
* Thu Dec 06 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10542 : Configjump for E-Mail popup detail view throws JS error
  - Partially fixed bug #10496 : Typos in GUI pot
  - Fixed bug #10556 : "Date" not always correct in expanded e-mail headers
  - Fixed bug #9526 : Select participants popups: temporary list of added users displays internal users with wron icon
  - Fixed bug #10557 : E-Mail: Signature selection broken in new e-mail window
  - Fixed bug #10536 : E-Mail: "Find as you type" for recipients searches for one character on second address in same field
  - Fixed bug #10554 : E-Mail: "Priority" information lost when editing saved draft
* Tue Dec 04 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug 10533 : IE7: Contacts: Error when opening empty contact folder in 'card' view
* Tue Dec 04 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10525 : Contact Hover: Clicking on E-Mail Adress with Umlauts causes JS error in New E-Mail window
  - Fixed bug #10519 : Text jumps around in help hover popup menu
  - Fixed bug #10527 : IE: "Open" attachment does not work for mail popup detail windows
  - Fixed bug #10528 : IE: Show Source does not work for mail pop-up detail
  - Fixed bug #10529 : IE: Opening attached E-Mail does not work when accessing forwarded E-Mail directly
* Mon Dec 03 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug 10509 : Broken special character in po file
* Mon Dec 03 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10308 : [FF] "Permission denied to get property HTMLDivElement.parentNode" Exception thrown when moving the mouse over the hover participant accept/decline textbox
* Mon Dec 03 2007 - jan@open-xchange.org
  - Fixed bug #10518 : IE6: Hover indicators are not cleared when moving to other indicator position
* Thu Nov 29 2007 - jan@open-xchange.org
  - Fixed bug in Infostore Hover with Title Content 
* Thu Nov 29 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9502 : Folder tree: E-mail unread counter copied to other e-mail folder after switching folders rapidly
* Wed Nov 28 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10425 : Calendar: "Display as" dropdown not visible completely in appointment popup
  - Fixed bug #10361 : IE6, Route Planing broken for google maps when using umlauts or sonderzeichen
* Wed Nov 28 2007 - jan@open-xchange.org
  - Fixed bug #10008 : Tasks: Reminder for tasks shows calendar icon
* Wed Nov 28 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10114 : Configuration/E-Mail: "Forward E-Mails as" radio buttons have wrong width
* Tue Nov 27 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10282 : PMG: Missing icon for tasks "history"
* Mon Nov 26 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #10396 : IE7: Flags not visible in InfoStore H split view
  - Fixed bug #10364 : IE7: Start page: Unused space at bottom compared to Firefox
  - Partially fixed bug #10326 : Start page: Number of elements to show only correct for e-mail module
  - Fixed bug #10380 : Configuration / Folder preferences: Pseudo-reselection after removing an user from the list
  - Fixed bug #9560 : [IE] Teamview gets broken on multi-day appointments
  - Fixed bug #10394 : folder "Shared folder" not expanded automatically
  - Fixed bug #9965 : GUI shows expand/colapse icon if subfolders are not subscribed
* Mon Nov 26 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10399 : contacts, card view, vertical scrolling causes horizontal scrolling
  - Fixed bug #10398 : Contacts: Card view always shows one column too much
  - Fixed bug #10088 : Move object to the same folder
  - Fixed bug #10089 : E-Mail many recipients in to field cause too long input fields
  - Fixed bug #9916 : Garbage in appointment window when creating whole day appointment
* Mon Nov 26 2007 - jan@open-xchange.org
  - Fixed bug #10057 : IE7: Calendar: "Team hinzufügen" menu cut off
  - Fixed bug #9829  : Calendar - Displaying of From and Until times at the availability overview
  - Fixed bug #10090 : E-Mail attachments: "Save" vs. "Save as" in panel and context menu
  - Fixed bug #9030  : Configuration/E-Mail: "Line wrap after"...
  - Fixed bug #9440  : Printing lists without selection leads to empty print output
  - Fixed bug #9544  : Appointment confirmation window: Bad visibility if appointment title and location are long
  - Fixed bug #9753  : long appointment title leads to line break of header in detail view
* Mon Nov 26 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10350 : Delete UWA module configuration shows "portlet"
* Fri Nov 23 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #10388 : IE6: unnecessary line on start page
  - Fixed bug #10342 : IE7: Configuration folder tree always scrolls to top when selecting new folder
  - Fixed bug #10370 : Infostore: Version comments show <BR> instead of linebreaks
  - Fixed bug #10379 : Calendar: Search button in select participants popup needs to be clicked twice
* Fri Nov 23 2007 - jan@open-xchange.com
  - Fixed bug #10376 : Calendar: Availability view shows wrong freebusy states for external participants
  - Fixed bug #10378 : Calendar: Wrong icon for external participants in availability view
  - Fixed bug #10389 : wrong tooltip "Expand"
  - Fixed bug #10371 : IE7: Highlighted menu entries are shifted to the right
  - Fixed bug #10351 : Customized weekview, 8 days, show appt. on wrong day
  - Fixed bug #10384 : E-Mail: "Find as you type" search doesn't include display name in search by "From"
  - Fixed bug #10353 : IE6/7: login via https shows warning
  - Fixed bug #9308 : ie6/ie7 configuration-related? jscripterrors
  - Fixed bug #10402 : InfoStore Hover: Filesize wrong formatted
* Fri Nov 23 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10390 : IE6: "About" popup, layout broken
  - Fixed bug #10368 : Infobox header too high
  - Fixed bug #10347 : E-Mail search changes search-criterion when switching views but doesn't clear inputfield
  - Partially fixed bug #10369 : translation mistake in Configuration/Calendar/Preferences
* Thu Nov 22 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #10283 : PMG: Adding module to empty start page causes JS-Error
  - Fixed bug #10229 : PMG: IE6: shows "1" after task title on portal page
  - Fixed bug #10228 : PMG: IE6: does not show vertical align bars after switching from a module to portal page
  - Fixed bug #9928 : ACL "Rights" tab shown on new folder creation at INBOX level (Dovecot, no ACL)
  - Fixed bug #9791 : IMAP Folders - query if rights shall be inherited even if ACLs not available
  - Fixed bug #10366 : today button occurs error while minicalendar is moving
  - Fixed bug #10289 : PMG: Start Page, Calendar module, time not completely displayed
* Thu Nov 22 2007 - jan@open-xchange.org
  - Fixed bug #10365 : E-Mail popup window: "Hover is not defined" when trying to show additional items in panel
  - Fixed bug #10355 : Send draft of a replied E-Mail does not work
* Thu Nov 22 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10362 : Contacts: Wrong drag & drop behaviour on multi selection in cards view
  - Fixed bug #9901 : minicalendar is not updated if you manual enter the birthday
  - Fixed bug #9692 : Anzeigen als dropwdown causes scrollbar
  - Fixed bug #9484 : IE7: Contacts: Input fields on wrong location
* Wed Nov 21 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10348 : Contacts, searchresults not cleared when changing from contacts to other module and back again
  - Fixed bug #10258 : [L3] Fehlermeldung: Das Objekt hat sich mittlerweile geändert.
  - Fixed bug #10129 : PMG: mini calendar not updated after creating a new appointment
* Wed Nov 21 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9889 : Contacts: Display name not constructed when dragging the strings into the textboxes
  - Fixed bug #10252 : Unable to open original e-mail (as attachment) of two-times forwarded mail via "open" button
  - Fixed bug #10189 : Wrong folder for contact created by moving mail address from email in PimpMyGUI
* Wed Nov 21 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #10281 : PMG: Bad visibility of objects, mostly hidden information on 1024x768
  - Fixed bug #10296 : PMG: Start page not automatically updated
  - Fixed bug #9927 : creating two email folder needs GUI reload for the second one
* Tue Nov 20 2007 - jan@open-xchange.org
  - Fixed bug #10065 : Calendar: Error during drag and create apppointments when moving cursor out of the calendar area
  - Fixed bug #9202  : "Edit_appointment" popup misleading
  - Fixed bug #10295 : Wrong implementation of description field expanding for calendar hovers
  - Fixed bug #10298 : Wrong implementation of description field expanding for infostore hovers
  - Fixed bug #10299 : Wrong implementation of description field expanding for tasks hovers
  - Fixed bug #10302 : PMG: "jump to options" context menu misaligned
  - Fixed bug #10331 : IE7: Slider in hovers doesn't reset to first position
  - Fixed bug #10334 : Hovers jump into visible area only once
  - Fixed bug #10338 : Calendar day team view one pixel too small
  - Fixed bug #10268 : PMG: List of participants grows out of shape when a scrollbar is shown
  - Fixed bug #10309 : PMG: Configuration/Options "Reload current view every" not updated
  - Fixed bug #9202 : "Edit_appointment" popup misleading
* Tue Nov 20 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10031 : Button and Header in "Edit Appointment" Dialog not correct
* Tue Nov 20 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10314 : Logout does not point to start page when following a document link
  - Fixed bug #10323 : other display name in hover than in contact module
  - Fixed bug, delete contact information like lastname or firstname
  - Fixed bug #10328 : Unable to compose mail if address has been chosen from a (contact) hover
  - Fixed bug #10330 : Unlogical naming of the slider description for contact hovers
  - Fixed bug #10339 : Contacts: Unable to disable hovers
  - Fixed bug #10333 : Misalligned elements at distribution list hover
* Tue Nov 20 2007 - jan@open-xchange.org
  - Fixed bug #10346 : Hover "fade-in" duration seems to be switched at the configuration
  - Fixed bug #8910  : IE7, no scrollbar in calendar dayview if there is no appointment on the current day
  - Fixed bug #9327  : impossible to assign flags from drop down menu after selecting multiple info items
  - Fixed bug #10062 : Calendar: Team view does not update on reload
  - Fixed bug #10207 : [L3] polish words in panel overlap
  - Fixed bug #9880  : Gap shown in panel after opening a Infostore link in new browser window
  - Fixed bug #9891  : Contacts: Wording in delete confirmation popups not so nice
  - Fixed bug #9290  : Calendar team view: "Add Team" misleading
* Mon Nov 19 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10275 : PMG: Route-Planer country mapping seems to be imprecise
  - Fixed bug #10266 : PMG: "New Appointment" window does not show confirm message when clicking "cancel"
* Mon Nov 19 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10245 : PMG: frame only around highlighted text in the folder tree
  - Fixed bug #10284 : PMG: module switcher not completely localized
  - Fixed bug #10287 : PMG: Configuration, Signatur section shows scrollbar
  - Fixed bug #10294 : No implementation of UWA information text at the configuration option
  - Partially fixed bug #10293 : PMG: Configuration/Contacts/Preferences not localized correctly
  - Removed additional languages due to PMG release (will be re-added later).
* Mon Nov 19 2007 - jan@open-xchange.org
  - Fixed bug #10271 : PMG: Missing description of hover fields for versions
  - Fixed bug #10310 : Hover slider description does not reset when moving mouse back
  - Fixed bug #10270 : PMG: Too logn filenames break hover shape / are cut
  - Fixed bug #10257 : PMG: Hover does not expand group
  - Fixed bug #10269 : PMG: Scrollbar overlays some objects at participant hover
  - Fixed bug #10317 : PMG: script in title breaks hover layout
  - Fixed bug #10272 : PMG: Custom view shows days as module header (switcher)
* Fri Nov 16 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10040 : E-Mail insert picture from hdd, layout broken
* Fri Nov 16 2007 - jan@open-xchange.org
  - Fixed bug #9458 : IE7: E-Mail: Javascript error when opening the e-mail window
  - Fixed bug #10267 : PMG: Cancel confirmation popup misaligned in popup windows
* Fri Nov 16 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #10211 : FETCH failed: Out of sync: Trying to fetch expunged message causes GUI-errors
* Thu Nov 15 2007 - jan@open-xchange.org
  - Fixed bug #9923 : Appointment notification doesn't disappear if appointment was deleted in the meantime
  - Fixed bug in Menu Sub Hover in IE6/7
  - Fixed bug #9528 : InfoStore: Panel section "Version" gets disabled when the item is locked
  - Fixed bug #9864 : Direct link to a document disables commands
  - Fixed bug #10065 : Calendar: Error during drag and create apppointments when moving cursor out of the calendar area
  - Fixed bug #9366 : Single RMB on Whole-Day appointment shows greyed-out context menu in Day/WW View
  - Fixed bug #9469 : Display effects should only be anabled on left mouse button click
  - Fixed bug #10205 : Some typos in ox.pot
* Thu Nov 15 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #10244: Module view does not update when selecting a folder without object read permission
* Thu Nov 15 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10055 : Tasks, InfoStore, Calendar, Contacts: Print preview shows "undefined" as title
* Wed Nov 14 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10190 : Moving contacts does not work in PimpMyGUI
  - Fixed bug #9722 : Horizontal scrolling in global addressbook's card view doesn't work at all
* Wed Nov 14 2007 - jan@open-xchange.org
  - Fixed bug #9517 : Visual effects: Panel dropdown for additional flags behaves different from other panels
  - Fixed bug #9556 : IE6, Calendar, Dayview, Workweekview, Default timerange not used
* Tue Nov 13 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10112 : contacts: phone number not saved without error
  - Fixed bug #9890 : Contacts: Changes to contact not saved when changing input fields with "TAB" key rapidly
  - Fixed bug #10011 : Task data isn't duplicated
* Tue Nov 13 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9813 : Folder: JS error on first module change if module root folder not visible
* Tue Nov 13 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #7830 : Configuration Infostore: H-Split vs. Split
  - Fixed bug #10097 : IE6: Picture "cancel" button on contact creation does not work
  - Fixed bug #9976 : L3: upper part before the week number the letters 'KW' make no sense in french
  - Fixed bug #9991 : [L3]settings, user preselected in rights
  - Fixed bug #9887 : Reminder popup: "Remind again" dropdown misaligned
  - Partially fixed bug #9195 : Success message for moved folders
  - Fixed bug #10031 : Button and Header in "Edit Appointment" Dialog not correct
  - Fixed bug #9889 : Contacts: Display name not constructed when dragging the strings into the textboxes
  - Fixed bug #9482 : Delivery receipt triggered for own mails in drafts folder
  - Fixed a bug that the view didn't refresh if you create a new draft within the drafts folder
  - Fixed a bug that the flag, which indicate that a message should marked as read, wasn't set when creating a new draft (requires an additional server fix)
* Mon Nov 12 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10127 : adress not correctly supplied to viamichelin
* Mon Nov 12 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #10018 : GUI gets broken when selecting non-existing IMAP folder
* Mon Nov 12 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #10104 : background color of selected options is too dark
  - Fixed bug #10115 : portal: print option in panel without any function
  - Fixed bug #10013 : Unable to download infostore attachment with "%" in filename
  - Fixed bug #10042 : FETCH failed: Out of sync: Trying to fetch expunged message
* Fri Nov 09 2007 - jan@open-xchange.org
  - Fixed bug #9940 : E-Mail: Search not cleared when changing folders
* Thu Nov 08 2007 - jan@open-xchange.org
  - Fixed bug #10102 : RMB menue not usable because of hover
* Mon Nov 05 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #10043 : E-Mail many receipients in to field cause too long input fields
  - Fixed bug #9160 : IE7: E-Mail: "To:" text field grows in width when adding recipients
* Wed Oct 31 2007 - jan@open-xchange.org
  - Fixed bug #9912 : Appointment confirmation popup can't be opened via context menu
* Wed Oct 31 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9941 : View source doesn't work in email detail popup
  - Fixed bug #9357 : Mail: Symbol for exisiting attachment not always shown when forwarding a mail
  - Fixed bug #9612 : Print button in popup view doesn't work
* Mon Oct 29 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9881 : Portal page entries not visible after following a external infostore link
* Mon Oct 29 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9911 : IE: Browser crashes when closing the 'New Contact' window directly after opening it
* Mon Oct 29 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9900 : Linebreaks are displayed as <BR>
  - Fixed bug #9952 : E-Mail: Opening an e-mail via double click from list view fails within Script Error
  - Partially fixed bug #9456 : Build 6300: Configuration: 'Preferences' is not translated in containment tree
  - Fixed bug #9905 : French "Add user" dialog does not show "OK" "Cancel" correctly because of linebreak
  - Fixed bug #9918 : Unable to flag E-Mails in shared folders (courier)
  - Fixed bug #9858 : Some typos - privat vs. private
* Thu Oct 18 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9595 : L3: Ordner nicht gefunden: -1 during abort folder creation
  - Fixed bug #9824 : deleting email folder doesn't update view
* Thu Oct 18 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9650 : Rendering issue with "your browser is not supported"
  - Fixed bug #9854 : [L3] mailbody printed as "undefined"
  - Fixed bug #9534 : Insert mode overwrites line breaks
  - Fixed bug #7240 : [IE] Browser asks to leave the current page when downloading task attachment
* Mon Oct 15 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9250 : L3: infostore documents as email attachments are not visible
* Fri Oct 12 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9539 : "Tags" information string does not fit the view and produced scrollbars
  - Fixed bug #9601 : Tasks: If you delete a task in 'Detail' view some error message appear cause focus is lost.
* Fri Oct 12 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9476 : Cancel button in 'Add Attachment' dialog doesn't work
  - Fixed bug #9563 : [IE] "ctd_participants" error when switching from ww-view to team-view
  - Fixed bug #9490 : No re-selection in folder tree after deleting infostore subfolder
  - Fixed bug #9579 : Unable to move appointment to 31. of the previous month if current month has 30 days.
  - Fixed bug #8931 : mini calendar bolded days off by 1 day
* Fri Oct 12 2007 - jan@open-xchange.org 
  - Fixed bug #9432 : [IE-7] js-error after java.lang.NumberFormatException and 'Error Messages' window can't be opened
  - Fixed bug #9244 : L3: infostore layout broken when items are locked
  - Fixed bug #9532 : "Option" dropdown is misaligned in all views
* Fri Oct 12 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9485 : Contacts: 'Comma' inserted into display name although only lastname is set
  - Fixed bug #9479 : Cancel button in 'add contact picture' dialog missing
  - Fixed bug #9411 : [L3] email setting "Benachrichtigen bei Lesebestätigung?" not clear
  - Fixed bug #9712 : XSS weakness in InfoStore
  - Fixed bug #9799 : mark mail as unread function fires many requests
  - Fixed bug #9621 : "Email" in module headline and expanded module view
  - Partially fixed bug #9700 : Portal page - E-Mail field - No displaying the newest unread received mails
* Tue Oct 09 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9727 : [L3] No admin permission found on creating a new public folder
* Tue Oct 09 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #9347 : Invisible picture overlaying the H-Split and V-Split disables content area interaction
* Tue Oct 09 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9562 : [Always] FF: Contacts - Change of name not saved when cursor stays in last name field
  - Fixed bug #9605 : [Always] Contacts - Change of name not saved when cursor stays in first name field
* Thu Sep 20 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9486 : E-Mail: Pressing 'Delete' very fast in a row results in JS error
  - Fixed bug #9142 : E-Mail: Second deletion fails if user enters e-mail module via start page
* Wed Sep 19 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9507 : [Always] Jscript Error while assigning flag to appointment
  - Fixed bug #9538 : IE: Configuration/Tags: Tag creation popup unusable
  - Fixed bug #9562 : [Always] FF: Contacts - Change of name not saved when cursror stays in last name field
* Wed Sep 19 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9176 : IE6, IE7: Login via https shows warning
* Mon Sep 17 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8533 : [L3] contacts having a private but no business email address can't be used for appointments
* Thu Sep 13 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9430 : Tasks: java.lang.NumberFormatException: if you try to save a new (empty) task without duedate
  - Fixed bug #9444 : E-Mail: Some minor layout issues
  - Fixed bug #9344 : Add attachments dialogs contains 'Attachment' as label on german environment
  - Fixed bug #9448 : Generating displayname by autocomplete at GUI contacts module
  - Fixed bug #9208 : Contacts: Contact header not refreshed in detail view
  - Fixed bug #9374 : Calendar - Mandatory fields should be marked as such
* Thu Sep 13 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9434 : Email: js-error if you hit 'Remove' button in attachment section without added any attachment
  - Fixed bug #9429 : "Done" tasks are not consistently shown at the portal view
  - Fixed bug #9422 : Error when creating IMAP folders due to duplicate "save"
* Wed Sep 12 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9358 : Appointment hover information is always shown below the cursor
  - Fixed bug #9151 : InfoStore: Following link to InfoItem from e-mail doesn't provide full path to item
  - Fixed bug #9353 : Login Screen is not localized
  - Fixed bug #9301 : Horizontal lines in detail views incosistent
* Wed Sep 12 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9284 : Calendar: Problems with participants without displayname (1)
  - Fixed bug #9285 : Calendar: Problems with participants without displayname (2)
  - Fixed bug #9286 : Calendar: Problems with participants without displayname (3)
  - Fixed bug #9181 : E-Mail: Auto complete doesn't work if multiple address books contain similar entries
  - Removed any mandatory field from the contact module (see bug #9224)
* Tue Sep 11 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9038 : French: Help -> "Format des messages :" shown in dropdown menu
  - Fixed bug #9376 : [Always] Mail: qa@open-xchange.com cannot be entered as a recipient
* Tue Sep 11 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9302 : Attachment Window (list) has no horizontal scroll bar
  - Fixed bug #9373 : Calendar - New Apppoinment: After entering wrong dates saving is no more possible
* Mon Sep 10 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9336 : Containment tree do only have "handcursor" on folder-icons but should also have it on folder-names
  - Fixed bug #9339 : Unread counter does not update when using "Empty Folder" featur
  - Fixed bug #9337 : [IE] Infostore H-Split shows horizontal scrollbar
* Mon Sep 10 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9338 : "Print" does not work in contact detail view after switching from a secondary tab
  - Fixed bug #9348 : JS Error on view change
  - Fixed bug #9355 : Initial sort for E-Mail sort is not correct
  - Fixed bug #7511 : "Tentative" participant status is not readable (color)
  - Fixed bug #9287 : Calendar: 'undefined' should be replayed by e-mail address for external participants without display name
* Fri Sep 07 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9297 : Configuration/E-Mail: Cursor not automatically in new signature popup
  - Fixed bug #9309 : open forwarded mail via double-lmb-click, jscript error, display distorted
  - Fixed bug #9315 : Dragpoint in h-split can be moved out of the grid area in email module
  - Fixed bug #9251 : L3: not necessary scroll bars
  - Fixed bug #9332 : Unable to send E-Mail
  - Fixed bug #9334 : [SMOKE] Tasks can't be saved
  - Fixed bug #9335 : [SMOKE] Contacts can't be saved when birthday is set
* Fri Sep 07 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9321 : Infostore: Can't save infostore item anymore after hit 'Cancel' in comment versions popUp
  - Fixed bug #9319 : IE6, dialogs to choose users distorted
* Fri Sep 07 2007 - jan@open-xchange.org 
  - Fixed bug #9329 : Owner can't assign flags on locked infostore items
  - Fixed bug #9327 : impossible to assign flags from drop down menu after selecting multiple info items
* Thu Sep 06 2007 - jan@open-xchange.org
  - Fixed bug #9178 : Autologin not localized (German)
  - Fixed bug #9310 : Calendar: Title 'Folder properties' not translated
* Thu Sep 06 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9293 : timezone, calendar-monthview shifted current day
  - Fixed bug #9306 : IE7: Foldertree doesn't show horizontal scrollbar automatically
* Thu Sep 06 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9296 : Tasks: Reminder field in "New Task" window looks bad with IE
  - Partially fixed bug #9256 : Object with empty subject displayed with title "null"
  - Fixed bug #9289 : Calendar: Week view shows appointments not in complete width
* Wed Sep 05 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9249 : Start page: If you hit RMB on some a appointment you will jumped to 'Detail' view but this was only possible on LMB
  - Fixed bug #7714 : All modules: No selection in foldertree when entering the options by clicking the triangle icon in the upper right corner
  - Fixed bug #9257 : Configuration, Changes only saved after confirmation-dialogue
  - Fixed bug #9268 : Calendar: Unable to create appointment named "New appointment" via "drag and create"
  - Fixed bug #9260 : Node was not found after moving folder per d&d
  - Fixed bug #9274 : Task: Column names in detail view are in english on german environmen
  - Fixed bug #9259 : IE7: Add participants popup distorted after changing contact folder
  - Fixed bug #9261 : IE6: Unable to change contact folder in "Select Participants" popup
  - Fixed bug #9280 : No success/unsuccess message if a new subfolder was created
* Wed Sep 05 2007 - jan@open-xchange.org
  - Fixed bug #8977 : wrong mouse curser in calendar 
  - Fixed bug #9273 : E-Mail: "E-Mail" section in panel is expanded at wrong location
  - Fixed bug #9265 : Configuration/Options: Second column too far on the right side
  - Fixed bug #9277 : Calendar: Conflict appointment can't be saved after time was changed so that appointment do not conflict anymore
* Wed Sep 05 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9081 : Tasks: "Notify participants by email" should be enabled by default
  - Fixed bug #9262 : "New Document" misleading
  - Fixed bug #9276 : Typo in ox.pot - InfoBox
  - Fixed bug #9264 : Configuration: "Do you want to permanently remove the deleted E-Mails?" does not suit to the other options
  - Fixed bug #9171 : IE7: Runtime error when GUI tries to show the "unconfirmed appointment" popup
  - Fixed bug #9185 : IE7: E-Mail: Detail window popup doesn't show e-mail message
* Tue Sep 04 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8428 : email headers not shown after scrolling
* Tue Sep 04 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9215 : Import: OX-GUI no response after several clicks in import section with a bad import upload file
  - Fixed bug #9236 : Javascript error when pressing save for mail attachment
  - Fixed bug #9174 : IE6, Config -> E-Mail -> Optionen, scrollbar needed
  - Fixed bug #9245 : E-Mail: Initial sort order wrong
* Tue Sep 04 2007 - jan@open-xchange.org
  - New experimental function for menu animations
* Tue Sep 04 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #9000 : Startpage Calendar entries cut
  - Fixed bug #9246 : Start page: Start time for all appointments is set to 00:00
* Mon Sep 03 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6036 : [1u1] calendar, team view on mouse over, only time is shown
  - Fixed bug #9009 : Moving infostore folder via d&d duplicates foldertree
  - Fixed bug #9056 : Folder tree: Unable to expand subfolders during drag & drop
  - Fixed bug #9011 : Configuration: scrollbar isn't calculated properly, can't scroll far enough
* Mon Sep 03 2007 - jan@open-xchange.org
  - Fixed bug #9201 : No white background for the "New object" dropdown menu
  - Fixed bug #9200 : "New object" dropdown does not hide on second click
* Mon Sep 03 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8065 : [1u1][IE6] infostore, listview is corrupted
* Mon Sep 03 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9218 : Tasks: Mouseover tooltip "S" in list view for recurring tasks
  - Fixed bug #9172 : E-Mail, Double-LMB-click to open e-mail in detailview, try to close window via "Fenster abbrechen"
  - Fixed bug #9225 : Tasks tab detail: Please remove vertical bar in 'New Task' window
* Fri Aug 31 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9170 : IE6, Calendar, weekview, separators missing
* Fri Aug 31 2007 - jan@open-xchange.org
  - Fixed bug #9182 : IE6, No hoverpopups in calendar or teamview
  - Fixed bug #9196 : E-Mail: Wrong confirmation popup when emptying trash folder
  - Fixed bug #8977 : wrong mouse curser in calendar
  - Fixed bug #9193 : IE6, teamview suddenly broken, javascript error shown
* Fri Aug 31 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9188 : "New E-Mail" mouseover tooltip for new e-mail button in panel not translated
  - Fixed bug #9119 : JavaScript error when trying to log in using IE6
  - Fixed bug #9171 : IE7: Runtime error when GUI tries to show the "unconfirmed appointment" popup
  - Fixed bug #9180 : IE7: Select participants / users popups misaligned
  - Fixed bug #9162 : Language configuration handling not usable
  - Changed fallback language from de_DE to en_US
* Thu Aug 30 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9153 : IE: Contacts: First column too wide in contacts phonelist view
  - Fixed bug #9158 : Inconsistence in detail view of distribution lists
* Thu Aug 30 2007 - jan@open-xchange.org
  - Fixed bug #9145 : Error when newly created folder is saved automatically
  - Fixed bug #9144 : Tasks: New subfolder doesn't appear in folder selection dialogue
  - Fixed bug #9168 : IE6, Calendar Panel-view broken
  - Fixed bug #9164 : IE6, new panel with quickinfo as default overlaps content-area
  - Fixed bug #9167 : IE6, Dropdown options from startpage not working
* Wed Aug 29 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9124 : Comments cannot be deleted from tasks
* Tue Aug 28 2007 - stefan.preuss@open-xchange.org
  - Changed the search default selection at the sent folder to the 'To' field
* Tue Aug 28 2007 - jan@open-xchange.org
  - Added experimental function for animations fading in/out popups
* Mon Aug 27 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9052 : Multi-day appointments show wrong times in week view
  - Fixed bug #9053 : Multi-day appointments show wrong times in month view
  - Fixed bug #8488 : Shared IMAP folders - group rights are not saved
  - Fixed [folder] : parentCache is not defined, after editing the rights of calendar folder
  - Fixed bug #9058 : Searching in task folder switches content layout
  - Fixed [folder] : move mail folder causes server error
* Mon Aug 27 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8255 : Infostore: Bad update-GUI bug after login and direct jump to infostore item detail view + hit delete
  - Fixed bug #9076 : InfoStore: "Root" folder "InfoStore" and "UserStore" selectable in select folder dialogue
  - Fixed bug #8863 : E-Mail Auto-Complete: 'Tab'-key selects the highlighted e-mail address and moves to next control
  - Fixed bug #8257 : No textbox selection after chosen recipients in webmail
* Mon Aug 27 2007 - jan@open-xchange.org
  - Fixed bug #7882 : "Members of" Group not translated to german
  - Fixed bug #9100 : Mail detail popup view does not provide standard "window close" layout
  - Fixed bug #7451 : Calendar: Scrolling timerange via dragging an appointment not working/unresponsive
  - Fixed bug #8977 : wrong mouse curser in calendar
  - Fixed bug #8894 : Move IMAP (sent or draft) folder in an other subfolder does not work
* Fri Aug 24 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #9054 : Firefox: Tasks: 'Status' & 'Priority' dropdowns have no border at the right side  
  - Fixed [combobox] : layout fixed
* Fri Aug 24 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9082 : Calendar: 'New -> Document' not working
  - Fixed bug #9098 : Adding ressources as particpants throws a JS error
  - Fixed bug #9099 : Opening unread E-Mail in popup window does not mark E-Mail as read
* Fri Aug 24 2007 - jan@open-xchange.org
  - Fixed bug #7605 : E-mail: IMAP folder access rights ignored in drag & drop hint
  - Fixed bug #9086 : Popup windows distorted when more than 4 panel rows displayed
  - Fixed bug #8683 : Availability and team view don't need ":00" everywhere
  - Fixed bug #9088 : Folder is not getting changed when deleting current folder
  - Fixed bug #8402 : Configuration tree does not update when modifying IMAP folders.
  - Fixed bug #9081 : Tasks: "Notify participants by email" should be enabled by default
  - Fixed bug #9009 : Moving infostore folder via d&d duplicates foldertree
  - Fixed bug #8843 : IE: Drag&Drop folders in folder tree leads to selecting everything in the way to target folder
  - Fixed bug #9079 : new taskfolder shows up as duplicate when editing a task
* Thu Aug 23 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8621 : Please remove political incorrect variables from JavaScript
  - Fixed bug #8952 : Horizontal line at E-Mail Editor is removed when using <tab> key to navigate
  - Fixed bug #9002 : E-Mail Richtext Editor shows horizontal lines when scrolling a message
  - Fixed bug #9074 : Unable to save a file attached to an Object
* Thu Aug 23 2007 - jan@open-xchange.org
  - Fixed bug #8940 : innconsistent naming of public tasks folders 
  - Fixed bug #7926 : Wrong time in Messagebox "Historie der Fehlermeldungen"
  - Fixed bug #9075 : Infostore, Panel-Versions has no entries
  - Fixed bug #9066 : Calendar: Reminder shows wrong duration till appointment
  - Fixed bug #9015 : When adding partcipants to a new task, the number of participants will not increase
  - Fixed bug #9077 : Setting client timezone to UTC-5 breaks minicalendar
  - Fixed bug #9056 : Folder tree: Unable to expand subfolders during drag & drop
* Thu Aug 23 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8956 : Select infostore-item in listview delete in detailview
  - Fixed bug #9037 : InfoStore: "The requested item does not exist" after deleting the last item in folder
* Wed Aug 22 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8773 : New Window headline  "New Email"
* Wed Aug 22 2007 - jan@open-xchange.org
  - Fixed bug #8851 : IE: Checkboxes have white background in the series popup for appointments
  - Fixed bug in Foldertree in combination with OX_Refresh
  - Fixed bug #9022 : 'Show QuickInfo' option has wrong state in popup windows
  - Fixed bug #4641 : Wrong popup for adding team members displayed in configuration
  - Fixed bug #8835 : H-Resizer - not needed
* Wed Aug 22 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #9024 : RT-Editor: Color Picker not translated
* Tue Aug 21 2007 - suphi.basdemir@open-xchange.com
  - Fixed [move] : Folder tree not updated and scrollbar in popup content
  - Fixed bug #8929 : Create Object with attachment, press save again (except webmail)
  - Fixed bug #9012 : JSON error when duplicating task (firefox only)
* Tue Aug 21 2007 - jan@open-xchange.org
  - Fixed bug #8986 : E-Mail: Can't switch to mail folder by clicking the number of unread mails in the folder tree
  - Fixed bug #8990 : Firefox: English time dropdowns not shown completely in "New Appointment / Availability" tab page
  - Fixed bug #8958 : stretch separator-line on portalpage
  - Fixed bug #8960 : Align foldertree-bottom-div with tasks-bottom-div when neither infobox nor minicalender is activated
  - Fixed bug #8964 : Cleanup starpage
  - Fixed bug #9001 : Unread E-Mails are not shown at the Infobox 
* Tue Aug 21 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8983 : E-Mail: 'Ascending' never changes to 'descending' when changing the sort order
  - Fixed bug #8867 : Bad translation for "Other Infostore Folders" quickinfo text
  - Fixed bug #8966 : Email used at "New E-Mail" in english translation
  - Fixed bug #8967 : "New mail" used for "New E-Mail" tooltip
  - Fixed bug #4370 : Firefox - No cursor inside a textfield
* Mon Aug 20 2007 - jan@open-xchange.org
  - Fixed bug #8857 : Tag creation popup: Cursor not in textfield automatically
  - Fixed bug #8796 : IE: Calendar day view: Layout problems in the headers
  - Fixed bug #8800 : InfoStore: 'Version' -> 'Delete' in panel enabled although no version is selected
  - Fixed bug #8932 : Rendering problems in FreeBusy interface on ie7 
  - Fixed bug #8974 : Option to be changed: Show number of cards..
  - Fixed bug #8963 : Icons in two-column panel sections are not equal aligned
  - Fixed bug #8979 : drop-down list is to large
  - Fixed bug #8959 : Panel, align new-object buttons
* Mon Aug 20 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8973 : Setting signature multiple times deletes message text
* Mon Aug 20 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8968 : Folder tree not available when clicking on 'Move' in panel
* Fri Aug 17 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8928 : javascript error after creating contact with attachment
  - Fixed bug #7437 : No "success/unsuccess" message if folder was moved
  - Fixed bug #8954 : Unable to open the context menu on E-Mail subfolders
* Fri Aug 17 2007 - jan@open-xchange.org
  - Fixed bug #8941 : Fixed bug # :Wrong naming of public calendar folders
  - Fixed bug #8684 : Team configuration doesn't ask to save before leaving the view.
  - Fixed bug #8946 : Calendar: Time frame shows 14:00...15:00...16:00 for user which has set language to 'English' and time zone to 'America/New York
  - Fixed bug #8682 : Use for appointment" in Availability tab doesn't copy the date.
  - Fixed bug #8953 : Firefox: If minimum fontsize is set calendar day and workweekview is broken
* Fri Aug 17 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8950 : IE6 Start page: Black-bar between folder tree and mini calendar after login
  - Fixed bug #8955 : Help not available
* Thu Aug 16 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8138 : Calendar view: I can't switch to next month
  - Fixed bug #8877 : Webmail offering: Mini Calendar not implemented as specified
* Thu Aug 16 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8908 : Load Icon isn't displayed after login
  - Fixed bug #8914 : Missing Attachment image in webmail
  - Fixed bug #8925 : Modularisation: Webmail, can't move e-mails via panel
* Thu Aug 16 2007 - jan@open-xchange.org
  - Fixed bug #8906 : Modularisation: Standard Plus -> Basic -> Standard Plus, Infostore still hidden
  - Fixed bug #8902 : New/Edit window toolbar does not use size of portal toolbar
  - Fixed bug #8913 : Modularisation from Standard to Basic: If the default calendar view was set to 'Teamday view' after downgrade the user still see 'Teamday view' in calendar
  - Fixed bug #8909 : unable to follow direct link to task
  - Fixed bug #8683 : Availability and team view don't need ":00" everywhere
* Thu Aug 16 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8899 : Public Folders: Folder tree get's duplicated if you create a new public folder with inherite folder rights and no folder administrator
  - Fixed bug #8848 : "My Infostore" folder is not updated after folder creation
  - Fixed bug #8887 : IMAP folders: 'Inbox' is grey out as destination if you try to move an IMAP folder
  - Fixed bug #8870 : [L3] Folder permissions: Possible to add yourself several times to folder permissions
* Thu Aug 16 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8724 : [dev] action=list request for a nonexistent object returns an empty array
* Wed Aug 15 2007 - stefan.preuss@open-xchange.org
  - Fixed Bug #8855 : Incorrect window caption for Infostore Item
  - Fixed bug #8861 : JS Error when trying to set task status to -25%
  - Fixed bug #7527 : (mail) in sent mail folder sorting for recipients do not work
  - Fixed bug #7130 : (Mail) update view problem changing from startpanel to mail module
  - Fixed bug #8758 : "Draft" folder shows "From" addresses as at H/V-Split
  - Fixed bug #7541 : E-Mail V-Split spacing is inconsitent
  - Fixed bug #7514 : Concerns the spam function: get an error message, when some external imap client removes messages
  - Fixed bug #8625 : white page follow while print a mail
* Wed Aug 15 2007 - jan@open-xchange.com
  - Fixed bug #8857 : Tag creation popup: Cursor not in textfield automatically
  - Fixed bug #8858 : 'Select Tags' popup: Hand cursor everywhere and not only over a tag
  - Fixed bug #8596 : AJAX interface does not respond when selecting many E-Mail
  - Fixed bug #8865 : Contacts: Default option for number of rows not set to 'auto'
  - Fixed bug #8864 : Inconsistent naming in Quick Settings and Configuration options
  - Fixed bug #8879 : Webmail offering: Expanded module view shows 'E-Mail' twice
  - Fixed bug #8891 : Preferences E-Mail: If you set the 'default signature' hook for a signature and leave preferences the hook will not be saved as set
  - Fixed bug #8883 : Webmail offering: Ugly disabled radio button in configuration
  - Fixed bug #8893 : Modularisation Basic: It's possible to create 'Teams' in 'Preferences' -> 'Calendar' but this should not be possible
  - Fixed bug #8896 : it is possible to move a 'locked' file
* Wed Aug 15 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8070 : Missing translation for "Versions" in infostore detail view
* Wed Aug 15 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8862 : Configuration/E-Mail: 'New Signature' dialog not aligned correctly
* Wed Aug 15 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8852 : 'Select participants / recipients' popup: inconsistent placing of the content
  - Fixed bug #8874 : Infostore: 'Send as Link' do not work. Link will not be added to E-Mail with IE
* Tue Aug 14 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8826 : [Always] InfoStore: Locked InfoItem 'deletable' via 'Del' keypress
  - Fixed bug #8810 : Calendar: JS-Error if 'search participants'-window will be closed using the red 'X' button
  - Fixed bug #8488 : Shared IMAP folders - group rights are not saved    
  - Fixed bug #8829 : IE: Calendar: Month view not refreshed properly when switching calendar folders
  - Fixed bug #8801 : Duplicate headline shown when searching for share users
* Tue Aug 14 2007 - jan@open-xchange.org
  - Fixed bug #8818 : Email move: Closing 'select move target folder' - Window using the red 'X' is not possible
  - Fixed bug #8831 : Calendar: Work week list view shows no appointments when accessed after day list view
  - Performance fixes in Menu
  - Fixed bug #8835 : H-Resizer - not needed
  - Fixed bug #8833 : Calendar day view: 'Whole Day' appointments not refreshed properly
  - Fixed bug #8846 : Calendar day view: Cancel creating new appointment unsing inplace-editing causes js-error
  - Fixed bug #8794 : Panel isn't displayed with four rows
* Tue Aug 14 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8828 : [Always] IE: Contacts: Unable to remove attachment from contact
  - Fixed bug #8540 : Moving a group of infoitems where one item is locked doesn't provide error message
* Tue Aug 14 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8754 : HTML Editor not disabled if "Plain Text" is selected as E-Mail format
* Mon Aug 13 2007 - jan@open-xchange.org
  - Fixed bug #8747 : Day View does not update
  - Fixed bug #8780 : Close Button for Dialogs (ux_02)
  - Fixed bug #8764 : Configuration Save Error after click on Logout
  - Fixed bug #8781 : Options of Quick Settings at options module
  - Fixed bug #8777 : Function “Empty Folder” at the E-Mail Module
  - Fixed bug #8796 : IE: Calendar day view: Layout problems in the headers
  - Fixed bug #8800 : InfoStore: 'Version' -> 'Delete' in panel enabled although no version is selected
  - Fixed bug #8799 : Contacts: Different naming of the optional fields
  - Fixed confirmation bug in detail view;
  - Fixed bug #8750 : E-Mail autocomplete overwrites different E-Mail address
  - Fixed bug #8809 : Delete IMAP Folders: Wrong confirm message during 'Empty Folder'
  - Fixed bug #8807 : Panel Linking: User can't 'delete' linking between two objects
  - Fixed bug #8474 : [Always] Panel: Dropdown arrow to expand 'Linking' section doesn't appear
* Mon Aug 13 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8765 : [FF] Unable to download Infostore attachments in detail view
  - Fixed bug #8789 : Containment Tree: JS-Error at E-Mail->'Inbox'
  - Fixed bug #8751 : E-Mail folders are not updating on manual/automatic reload
  - Fixed bug #8778 : Design changes by folder rights dialog  
  - Show no unread messages message  
  - Fixed bug #8783 : Design changes by the select dialogs
* Mon Aug 13 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8779 : Picture for contacts
  - Fixed bug #8773 : New Window headline  "New Email"
  - Fixed bug #8774 : Function changes by the select dialogs
  - Fixed bug #8819 : Email: 'Show E-Mail source' only works the first time
* Mon Aug 13 2007 - Viktor.Pracht@open.xchange.org
  - Fixed bug #8752 : [IE] Lower sidepanel slider is not completely shown
  - Fixed bug #8775 : Redesign of the create Signature dialog
  - Fixed bug #8757 : [FF] Obsolete vertical scrollbar shown in V-Split on Firefox
  - Fixed bug #8772 : Drag point to resize sections with the mouse
  - Fixed bug #8817 : Automated testing not working anymore due to missing java script value
* Mon Aug 13 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8753 : Crazy tab order for "New E-Mail" window
  - Fixed bug #8776 : Reminder value is always set to 15 even if no reminder was set while editing an appointment
  - Fixed Bug #8770 : No colored line shown when replying to a HTML E-Mail
  - Fixed bug #8786 : Mail is HTML encoded even if not wanted
  - Fixed bug #8766 : Editor to write mails unusable
  - Fixed bug #8811 : Unable to store mail attachments
  - Fixed bug #8815 : Email: Add picture to E-Mail do not work with IE (js-error)
  - Fixed bug #8771 : Broken umlauts at the RT Editor "New Document" function
  - Fixed bug #8787 : Email: JS-Error using E-Mail adress autocomplete function
  - Fixed a problem with overlaying Select elements at the address book in the New E-Mail dialog
  - Fixed bug 8627 : Quoted mail parts are broken after first reply
  - Added some padding to the editor window and changed the font-size to 9pt.
* Fri Aug 10 2007 - suphi.basdemir@open-xchange.com
  - [distribution list] fixed bug, when editing in detail view
* Fri Aug 10 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #8745 : E-Mail: AutoComplete doesn't quote personal adresses
* Fri Aug 10 2007 - jan@open-xchange.org
  - Fixed bug #8744 : GUI Contact panel: No contact is selected but the "copy" icon is active
* Thu Aug 09 2007 - suphi.basdemir@open-xchange.com
  - [contact] fixed line breaks in comment field
* Wed Aug 08 2007 - stefan.preuss@open-xchange.org
  - Implemented item from SP3: New HTML-Editor
  - Implemented item from SP3: Auto complete functionality
* Wed Aug 08 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8428 : email headers not shown after scrolling
* Mon Aug 06 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #4430 : Selected format not shown when composing an email
* Mon Aug 06 2007 - jan@open-xchange.org
  - Fixed bug in with default team view
  - Fixed bug #7451 : Calendar: Scrolling timerange via dragging an appointment not working/unresponsive
* Mon Aug 06 2007 - suphi.basdemir@open-xchange.com
  - [ie6] Fixed bug with minicalendar in new windows
  - Implemented item from SP3: error message change by Tasks
  - Fixed bug #7550 : Sending mail with CC fails under special circumstances
  - [ie6] Fixed layout attachment dialog
  - Fixed bug #7405 : Inconsistent bahaviour of "in place editing" an appointment's title in Firefox / IE
* Fri Aug 03 2007 - jan@open-xchange.org
  - Fixed bug #8264 : "User settings" menu broken
  - Fixed bug #8684 : Team configuration doesn't ask to save before leaving the view.
  - Fixed bug #8688 : [dev] JAvaScript error: myappointments has no properties
  - Fixed bug #8674 : Appointment confirmation dialog (English) - Wording "a" -> "an"
  - Fixed bug #8675 : Appointment confirmation dialog (English) - Wording "a" -> "an"
  - Fixed bug #8682 : "Use for appointment" in Availability tab doesn't copy the date.
* Thu Aug 02 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8662 : Switching to a linked doesn't work in the UI
  - Fixed bug #8596 : AJAX interface does not respond when selecting many E-Mail
  - Fixed bug #7848 : [1u1] Folder update aborted: User .. must not grant "create subfolder" permission for another user on shared folde  
  - Fixed bug #8619 : Cant move infostore folder  
  - Fixed bug #8429 : Calendar, month, arrow (if several appts. exist) doens't work  
  - Fixed bug #8402 : Configuration tree does not update when modifying IMAP folders.  
  - Fixed bug #8481 : Unable to keep on moving infostore folders in "My Infostore folder"
  - Fixed bug #8520 : subscribing a shared folder requires admin privs
  - Fixed bug #8608 : Empty context menu is visible in folder selection
  - Fixed bug #8579 : Title of infostore objects are displayed wrapped
  - Fixed bug #8471 : Folder selection frame kept when selecting other folders  
  - Fixed bug #7599 : Folder icon disappears when "cutting" in "My Infostore Folder"
  - Fixed bug #7609 : "New Subfolder" name does not update when creating multiple folders  
  - Fixed bug #8135 : Folder options not completely shown on first try  
* Thu Aug 02 2007 - jan@open-xchange.org
  - Fixed bug #5950 : [FIREFOX] Day view is damaged when changing calendar interval
  - Fixed bug #7714 : All modules: No selection in foldertree when entering the options by clicking the triangle icon in the upper right corner
  - Fixed bug #8476 : [Always] Panel: Dropdown arrow to expand 'Linking' section doesn't appear
  - Fixed bug #8306 : Task: Direct link in e-mail does not get past "dynamic resizing"
  - Fixed bug #7621 : E-mail: Wrong cursor in the 'Mark as' submenu
  - Fixed bug #8191 : Translation - 'New' Images in Panel aren't centered
  - Fixed bug #7194 : [1u1] series appointmen can't be moved in month view by drag and drop
* Thu Aug 02 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7879 : Calendar/Team View: Calendarweek header not aligned correctly
  - Fixed bug #8546 : Infostore: Wrong version information when displaying the detail view a second time
* Thu Aug 02 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8330 : Session expired - no redirect to login page
* Wed Aug 01 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8648 : 'Add to addressbook' must be 'Add to address book'
  - Fixed bug #8563 : [1u1] tasks, detail view flags can't be set
  - Fixed bug #7575 : Task: 'New Task' window bad GUI with IE-7
* Wed Aug 01 2007 - jan@open-xchange.org
  - Fixed bug #8640 : 2 Javascript errors on login
  - Fixed bug #8634 : [Webmail] - It isn't able to hide the InfoBox.
  - Fixed bug #8650 : [Webmail] - 'Erdbeer-Vic' found
* Wed Aug 01 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8621 : Please remove political incorrect variables from JavaScript
  - Fixed bug #8641 : QuickInfo for private folders speaks about shared folders in the Basic configuration
  - Fixed bug #7956 : [1u1] Ordner0 für die Aufgabe 1 konnte nicht gefunden werden. (TSK-0017,818715658-139041)
* Wed Aug 01 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6221 : wrong bg-colour, Creating new folder, tab "Ãœbersicht"
  - Fixed bug #8613 : Not possible to grant "all users" permission to read an infostore folder 
  - Fixed bug #8632 : JS Error when moving a message
  - Fixed bug #8643 : [Webmail] - It isn't able to hide the InfoBox
  - Fixed bug #8607 : Performance - Search context menu value of dynamic fields unknown
* Tue Jul 31 2007 - suphi.basdemir@open-xchange.com
  - fixed bug, when moved contact in detail view, with the edit dialog
  - Fixed bug #8605 : ICal Import is not disabled in configuration
* Tue Jul 31 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #7706 : [1u1][IE6] email, resize problem in new email window
  - Implemented sorting of mails by read/unread
  - Fixed bug #8616 : menu item action in context menu on infostore item doesnt work
* Tue Jul 31 2007 - jan@open-xchange.org
  - Fixed bug #8604 : Configuration for start page is not disabled
  - Fixed bug #8615 : Mail Attachment button missing in Webmail Package
* Mon Jul 30 2007 - suphi.basdemir@open-xchange.com
  - fixed bug, when moved appointment in detail view, with the edit dialog
* Mon Jul 30 2007 - jan@open-xchange.org
  - Fixed bug #8208 : Tasks: Gui shows Fatal Error if user cancel setting series
* Fri Jul 27 2007 - suphi.basdemir@open-xchange.com
  - Implemented item from SP3: Function changes by the select dialogs
  - Fixed bug #8180 : No site leaving warning when logout hoverbox is visible
  - Fixed bug #4821 : Avalability cannot be checked when editing appointment
* Fri Jul 27 2007 - Viktor.Pracht@open-xchange.org
  - Implemented item from SP3: Problems by creation of Tags
  - Implemented item from SP3: Delete of selected attachments
* Fri Jul 27 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #3970 : [Polish] Date picker should pre-select the saved date
* Thu Jul 26 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8502 : Error after moving task through edit dialog
* Thu Jul 26 2007 - jan@open-xchange.org
  - Tuning Performance
  - Implemented Modularization things
  - Implement item from SP3: Buttons text for actions (open new windows)
  - Implement item from SP3: Design changes for the appointment/Serial appointment Pop up
  - Implement item from SP3: Displaying of selected time frame
  - Implement item  SP3: Design changes of the appointment serial dialog
  - Fixing bug in new foldertree with d&d.
  - Fixing bug ux_02
  - Implement item from SP3: Function Empty Folder at the Email Module
* Thu Jul 26 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8539 : link from the CC to mailexchange makes gui english for german users
* Wed Jul 25 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8548 : [dev] "Tags" button in the new contact popup does nothing
  - Fixed bug #8462 : Participant popup window broken.
* Wed Jul 25 2007 - Viktor.Pracht@open-xchange.org
  - Implemented item from SP3: Design problems at the New e-Mail dialog
  - Implemented item from SP3: New Window headline  “New E-Mail”
  - Implemented item from SP3: Design changes by the select dialogs
* Tue Jul 24 2007 - suphi.basdemir@open-xchange.com
  - Implemented item 27 from SP3: Create new objects by click at empty area
  - Implemented item 17 from SP3: Design changes at the search module
* Tue Jul 24 2007 - Viktor.Pracht@open-xchange.org
  - Implemented item 14 from SP3: Redesign of the create Signature dialog
  - Implemented item 20 from SP3: Reminder setting – Default 15 minutes
  - Implemented item 21 from SP3: Design changes at the select tag dialog
* Mon Jul 23 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug ux_08: external vs. internal contacts
  - Implemented item 28 from SP3: Picture for contacts
  - Fixed bug #8535 : destination contact folder not selectable by LMB on a email address
  - Implemented item 26 from SP3: Options setting – Contacts
* Mon Jul 23 2007 - Viktor.Pracht@open-xchange.org
  - Implemented item 12 from SP3: Not clear Errormessage by upload
  - Fixed bug #8523 : Infostore list view does not show scrollbars if list is populated
* Fri Jul 20 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #5912 : Contact Modul - Remove scrollbars of all displayd fields at the detail views
* Wed Jul 18 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8483 : Charset error when doubleclicking on E-Mail Sender/Recipient in Webmail
* Wed Jul 18 2007 - Viktor.Pracht@open-xchange.org
  - Implemented item 3 from SP3: Space Problems at the Sidebar
  - Implemented item 4 from SP3: Drag point to resize sections with the mouse
  - Implemented item 19 from SP3: Header at tables – Tooltips missing
* Wed Jul 18 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8492 : IE7: Memory leak in calendar month view
* Tue Jul 17 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug innerHTML : in contacts first step
* Tue Jul 17 2007 - stefan.preuss@open-xchange.com
  - Added new HTML Editor (TinyMCE)
* Mon Jul 16 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8455 : [IE] contacts, edit window, letters are not in the middle of the letterbox
* Wed Jul 11 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7246 : [IE7] E-mail: Wichtigkeit dropdown-list has wrong z-index
  - Fixed bug #7251 : Asking for one object in delete question if selected multiple objects
  - Fixed bug #6202 : search for *, create app, try to delete the app
  - Fixed refreshing after delete an appointment, in the cb of a multiple request
* Wed Jul 11 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8364 : Shared Email (IMAP) folders: Wrong gui handling during folder subscription
* Tue Jul 10 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #8354 : Error when attempting to save user settings
  - Fixed bug #8345 : logout button does not work
* Tue Jul 10 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8115 : [IE] Datepicker is heavily misaligned in appointment creation/modification window
  - Fixed bug #8249 : Yearly recurring appointment must reuse date information
  - Fixed bug #8158 : Reminder information is not shown in task views
  - Fixed bug #8165 : Tasks: Column header "End date" in list views wrong (need translation, too)
  - Fixed bug #8163 : New appointment window: Particpants and attachments tab page corrupted
* Mon Jul 09 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8243 : Calendar: Week view shows wrong day as "current day"
  - Fixed bug #8271 : Create an appointment from portal-page, new-app.-window not closed automatically
  - Fixed bug #4357 : recipient list for appointments should be ordered alphabetically
* Mon Jul 09 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8261 : Sharing Folders: No icons for 'users' and 'groups' in rights tab
  - Fixed bug #7445 : Tasks: Error TSK-0017 when changing a task's folder in the edit window
  - Fixed bug #7749 : Calendar - Public Folder - New appointment - the private folder is displayed
  - Fixed bug #7848 : [1u1] Folder update aborted: User .. must not grant "create subfolder" permission for another user on shared folde  
* Sat Jul 07 2007 - stefan.preuss@open-xchange.com
  - Added new 'animated' image to the load sequence of the start page and every new page
  - Fixed bug #7551 : Warning for not supported browser is always English
* Fri Jul 06 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7995 : Infostore: Move infostore folders via drag&drop do not work properly
  - Fixed bug #8095 : Drag & Drop behavior at foldertree
* Fri Jul 06 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #8298 : English errormessage by edit of serie appointments
  - Fixed bug #7928 : Email: Signature and vcard are duplicated if draft is resumed
* Thu Jul 05 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8255 : Infostore: Bad update-GUI bug after login and direct jump to infostore item detail view + hit delete
  - Fixed bug #7404 : (infostore) search filter to add users to folder rights is not resetted  
  - Fixed bug #7605 : E-mail: IMAP folder access rights ignored in drag & drop hint
  - Fixed bug #7717 : Doubleclick on 31. creates appointment on 01. in month view
  - Fixed bug #7775 : Cannot delete multiple versions in infostore
* Thu Jul 05 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8279 : Calendar week-view: Bad usability during selecing appointments the second time
  - Fixed bug #8296 : By creation of an appointment, notification must acitvated by default
  - Fixed bug #5074 : Telefon (geschÃ¤ftlich) does not fit to the Phonelist header
* Wed Jul 04 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8021 : contact images in Edit window aren't refreshed
  - Fixed bug #8075 : "edit contact" window does not close
  - Fixed dbl in empty livegrid creates new object (Calendar, Tasks, Contacs, Infostore, Mail)
  - Fixed bug #7758 : [1u1] calendar list view, double click below your appointments gives a json error
  - Fixed bug #8286 : [dev] Infostore: double-click without selected elements.
  - Fixed bug #8288 : [dev] Mail: double-click without selected elements.
  - Fixed bug #7983 : Tasks: DLMB in H-Split if no task are created causes jscript error and start page is not loaded
  - Fixed bug #7733 : Tasks: Bad error message during setting flags
* Tue Jul 03 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #8188 : Cannot edit contacts
  - (minicalendar) 2nd click to kw produce js error
* Mon Jul 02 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #8147 : Autologin blocked due to wrong client IP address
* Fri Jun 22 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8118 : Infostore: JSerror during moving items from infostore folder to subfolder	
* Thu Jun 21 2007 - jan@open-xchange.org
  - Fixed bug #7810 : flags for some imap folders enabled in production
  - Fixed bug #7724 : Calendar - Workweek - Failure by displaying appointmens
  - Fixed bug #7712 : [1u1] calendar "verfï¿½gbarkeit" wrong clock display in drop down "von"
  - Fixed bug #7353 : Infostore: Wrong mouse icon and panel functions if two items should be locked/unlocked and one item is allready locked
  - Fixed bug #7926 : Wrong time in Messagebox "Historie der Fehlermeldungen"
  - Fixed bug #6249 : [TC #1224] Availability of participants, dropdown-menu has wrong entries
  - Fixed bug #7479 : Checkbox 'Show quickinfo' at the right side of the panel has no effect?
  - Fixed bug #7467 : Calendar Team-view: 'Choose Team' should be grey out in panel if no team is available
  - Fixed bug #7708 : [1u1] portal layout pannel line too long and dead link
  - Fixed bug #7601 : Imprecise clickable area in calendar Free/Busy view (back/forward)
* Thu Jun 21 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #8074 : ACL settings not disabled in GUI when imapSupportsACL=false
  - Fixed bug #7579 : Appointment: External participants not shown in edit view
  - Fixed bug #8060 : Calendar entries from on the last day of the month doesnt show in the next month  
* Thu Jun 21 2007 - Viktor Pracht@open-xchange.org
  - Fixed bug #8065 : [1u1][IE6] infostore, listview is corrupted
  - Fixed bug #7594 : Browser detection / check unstable
  - Fixed bug #8108 : Reminder - "Termin in 2.7333746643518517 Wochen"
* Wed Jun 20 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7721 : Calendar week view: DLMB on the 01.06.2007 shows the 01.07.2007 in 'New appointment' window
  - Fixed bug 8084 : Address book not populating
  - Fixed bug 8092 : In correct time sorting when apt made in month view (additional fixed sorting from series appointments in calendar month view)
* Wed Jun 20 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7776 : Refresh does not work in tab infostore/versions
  - Fixed bug #5102 : InfoStore: No 'Edit' actions possible in details view / versions tab
* Wed Jun 20 2007 - Viktor.Pracht@open-xchange.org
  - Implemented displaying of participants without an email address.
* Tue Jun 12 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7620 : Tasks H-Split: Function 'Print' causes jserror and do not work
* Thu May 31 2007 - jan@open-xchange.org
  - Fixed bug #7271 : Empty appointment breaks day view
* Fri May 25 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7581 : [Always][IE] Edit contact/distribution list opens in switched views
  - Fixed bug #7577 : [ALWAYS]Tasks: Description in H-Split is shown not complete with IE-7
* Fri May 25 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #7583 : Unable to send E-Mail via direct link on a adress
* Thu May 24 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7544 : Tab "links" is not shown
* Thu May 24 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #7547 : [1u1] java script cann access login name and password in html mails
  - Fixed bug #7351 : Infostore: Multiple selected items cannot be sent as attachment/link
  - Removed "fr_FR" from language selection (will come later with a PTF).
* Wed May 23 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7520 : [1u1] infostore item not deleted when removing a version before
  - Fixed bug #7532 : Calendar: Informations hover cause javascript error if appointment title is 'null'
  - Fixed bug #4793 : Double click to create new appointment does not work in views week and week view
  - Fixed bug #7508 : Appointment hoverboxes are misaligned in day/work-week view
* Wed May 23 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #7533 : Email: In V-split view some javascript error appear if hit on 'order by' little arrow
* Tue May 22 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7481 : Wrong quickinfo for ABC select bar in module contacts
  - Fixed bug #6013 : [IE6] New E-Mail format dropdown fields are shown if setting is "Plain Text"
  - Fixed bug #7495 : Can't logout after login through a direkt link
  - Fixed bug #7504 : Posibility to make ocurrences of a "private" appointment series non-private
  - Fixed bug #7109 : Configuration/Import: Import success count is wrong
  - Fixed bug #6723 : Email: Move "I-Beam" cursor in To,CC field not possible if hit Reply or Reply all from panel
* Tue May 22 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6293 : Missing parameter timestamp (for links)
  - Fixed bug #7500 : [1u1]calendar, selecting the same participant multiple times makes one not deleteable
  - Fixed bug #7400 : Create, edit Infostore-Item, popup-window broken display  
  - Fixed bug #7501 : [1u1] infostore versions tab in detail view not updated
  - Fixed bug #7506 : [1u1] infostore RMB menue on version in version tab empty
  - Fixed bug #5959 : [1u1] GUI Styleguide start page and email with IE-6
* Mon May 21 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7432 : Delete key doesn't check access rights.
  - Import of Outlook CSV file
* Mon May 21 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7355 : Infostore: RMB -> 'Open' do open still the same file if view was changed from H-Split to List and back to H-Split
  - Fixed bug #7422 : Infostore tab order is inconsistent
  - Fixed bug #7415 : Folder rights: Duplicate folder error message if assigning access rights twice
  - Fixed bug #7434 : Folder will not be moved via Drag&Drop in containment tree but green 'OK' icon is shown
  - Fixed bug #7466 : [IE7] Calendar, month mark appointment, change subject
  - Fixed bug #7445 : Tasks: Error TSK-0017 when changing a task's folder in the edit window
* Mon May 21 2007 - jan@open-xchange.org
  - Fixed bug #7417 : [IE7] Calendar, Groupappointment Hover -> JScript-Error
  - Fixed bug #7360 : duplicate task via context menu is not possible...
  - Fixed bug #7419 : RMB on linked object shows empty context menu
  - Fixed bug #7414 : Infostore: Enabled panel functions don't equal enabled RMB context menu funtions
  - Fixed bug #7436 : [IE] "broken image" icon shown when dragging a object out of the foldertree
  - Fixed bug #7454 : [1u1][IE6] contacts, printing does create error message, printing not possible
  - Fixed bug #7455 : Calendar: Change confirmation comment will not be saved for appointment
  - Fixed bug #7464 : JS Error when RMB on a E-Mail attachment in secondary windows
* Mon May 21 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #7420 : Inconsitent naming at the linking tab
* Fri May 18 2007 - jan@open-xchange.org
  - Fixed bug #7375 : The default for "Read acknowledgment" should be "yes"
  - Fixed bug #7372 : A JSONArray text must start with '[' at character 1 of false
  - Fixed bug #7378 : [SMOKE] detail view of task participants broken
  - Fixed bug #6246 : Possible to quit team view configuration without saving
  - Fixed bug #7353 : Infostore: Wrong mouse icon and panel functions if two items should be locked/unlocked and one item is allready locked
* Fri May 18 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #7373 : E-Mail: No difference in behavior for "Notify on read acknowledgment?" yes or no
  - Fixed bug #7379 : [Smoke] Infostore List-view empty
* Wed May 16 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6258 : Mailer dropps "References" and "In-Reply-To" headers
  - Fixed bug #5988 : Calendar week-view: GUI Styleguide
  - Fixed bug #7358 : open context menu on multi selection doesn't work in contacts card view
* Wed May 16 2007 - jan@open-xchange.org
  - Fixed bug #7194 : [1u1] series appointmen can't be moved in month view by drag and drop
  - Fixed bug #7330 : Infostore: RMB 'send as attachment' function causes multiple window opening
  - Fixed bug #7359 : Calendar day view: Hover shows "NaN" in start and endtime
  - Fixed bug #7360 : duplicate task via context menu is not possible...
* Wed May 16 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7020 : [InfoStore] Not possible to create a subfolder in InfoStore in some screenflows
* Wed May 16 2007 - stefan.preuss@open-xchange.com
  - Fixed bug #7357 : (mail) priority indication not displayed if >=2 recipients in to field
* Tue May 15 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7209 : (mail) new mail - clicking "To" the "select recipient" dialogue is not opened if error message is displayed
  - Fixed bug #7286 : [1u1]contacts drag and drop from global and private address book buggy
  - Fixed bug #7300 : [ALWAYS] Linking: Link 5 objects causes bad gui (...) in list view
* Tue May 15 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7285 : [1u1] settings "Verwerfen" is not working for Folders&Permissions
  - Fixed bug #7316 : Calendar month view: Bad GUI if too many appointments listed on 1024x768 resolution  
  - Fixed bug #4706 : User rights dialog talks about participants and resources  
* Tue May 15 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #5737 : [1u1] mail wrong mouse icon on mouse over attachment
  - Fixed bug #7313 : E-Mail: Sort indicator icon not updated when changing views
* Tue May 15 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #4170 : i can open a edit window twice for the same contact
  - Fixed bug #7312 : Calendar - Reminder - Spelling (German)
* Tue May 15 2007 - jan@open-xchange.org
  - Fixed bug #7278 : Calendar Modul - Inline editing - Blinking cursor icon is missing
* Mon May 14 2007 - suphi.basdemir@open-xchange.com
  - show source in mail, optimized popup with cb
  - Fixed bug #7245 : Distribution lists are not getting updated
  - Fixed bug #3910 : Inconsistent behaviour of cancel messages
* Mon May 14 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #7220 : (mail) no refresh of list after a mail has been moved
  - Fixed bug #6818 : [IE6] Horizontal seperator marks text when moving
  - Fixed bug #7222 : (mail) RMB context menu is not closed with LMB in Mail Body
* Mon May 14 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #7267 : [Always] (mail) forwarding mails with attachment the attachment ist lost
  - Fixed bug #5771 : Login is not localized if Browser is installed in other Language
  - Fixed bug #6789 : Mail list is not updated if I reset a search (V-Split)
  - Fixed bug #7283 : (infostore) not possible to send an attachment from infoitem via mail
  - Fixed bug #7244 : Tasks: Create/delete task in outlook, check in groupware h-split
  - Fixed bug #6324 : Email: if emails will be delete from 'trash' no "Are you sure you want to delete" message appear
* Sat May 12 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #4661 : Mail: V-Split: No sorting according to date?
  - Fixed bug #7218 : (mail) in v-split view the priority indication in the list is wrong
  - Fixed bug #7239 : (mail) mail signatures cannot be added to body manually
* Fri May 11 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7221 : Calendar: javascript errors in 'New Appointment' window 
  - Fixed bug #4952 : [1u1] Email - Lists cannot be sorted by flag
* Fri May 11 2007 - jan@open-xchange.org
  - Fixed bug #4742 : Icons for deleted / undeleted E-Mail are missing
  - Fixed bug #7098 : (infostore) changing from start pane it is not possible to delete infostore items
  - Fixed bug #7219 : (mail) not possible to delete a mail in detail view (js-error)
  - Fixed bug #7231 : RMB do not work in any view
  - Fixed bug #7225 : Folder Tree: After D&D the folder stays selected
  - Fixed bug #7236 : [IE-7] Calendar work-week: Curious possibility creating new appointments
  - Fixed bug #7181 : Dragging of appointments in day view broken
  - Fixed bug #7232 : Option Modul - RMB-Menues - Function "Switch to" is always enabled
* Fri May 11 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7090 : Calendar: Search clear do not 'clear' the search result
  - Fixed bug #3867 : InfoStore - Detail view missing filesize, created, created by
* Fri May 11 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #6762 : Scrollbar scale is not updated when switching folders
* Fri May 11 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #7233 : [IE] Documail is broken in IE Browsers
  - Fixed bug #6978 : DirectLinks don't work anymore
* Thu May 10 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7205 : [1u1] contact printview Geburtstag and Jahrestag wrong
  - Fixed bug #7206 : [1u1]contacts switching from one to another contact does not clear attachments in detail view
  - Fixed bug #7187 : Calender Modul - Hover Design change
* Thu May 10 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #5475 : Move an Email or delete an email in the Inbox results in empty "detail section"
  - Fixed bug #7174 : [1u1][IE6] layout infostore corrupt
* Thu May 10 2007 - stefan.preuss@open-xchange.org
  - Fixed an JS Error when opening the new message window and you have a default signature enabled
  - Fixed bug #7195 : Please change wording for Option
  - Fixed bug #6647 : E-Mail: No sorting of messages possible in 'V Split' view
* Wed May 09 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #4339 : IE7 - CSS-error leads to grey frames surrounding each checkbox
  - Fixed bug #7193 : Contacts: Tab order for "Anniversary" is wrong
* Wed May 09 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #4523 : after a mail is deleted no mail is selevted and displayed
* Wed May 09 2007 - jan@open-xchange.org
  - Fixed bug #7198 : [1u1] SPAM/HAM not deactivated in RMB menu
  - Fixed bug #7204 : [1u1][IE6] mouse over datepicker birthday wrong
* Wed May 09 2007 - stefan.preuss@open-xchange.org
  - Fixed Bug #6009 : [IE6] E-Mail: H-Split still holds message after changing to empty folder
  - Fixed bug #5784 : E-Mail: H-Split/V-Split text pane should be empty when selection is empty
  - Fixed bug #6969 : Login indictaor is not layout-consistent with the login screen
  - Fixed bug #7197 : [1u1] Option "Attach vCard" does not work
* Wed May 09 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7163 : Fehlermeldung: MSG-0054: Missing field: folder
  - Fixed bug #7188 : Calender Modul - Team view - Different colours at day and workweek  
  - Fixed bug #6174 : Infostore: Locking infoitem in versions tab removes header of infoitem
  - Fixed bug #7201 : Email: Rename folders causes javascript error
  - Fixed bug #7189 : Calendar: Negative attachment counter
* Tue May 08 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #5950 : [FIREFOX] Day view is damaged when changing calendar interval
  - Fixed bug #6817 : Disabled input boxes are not grey out in IE-6
  - Fixed bug #7176 : Tab pages: Style for the tab-title texts wrong
* Tue May 08 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7061 : Saving a new subfolder a second time leads to JS Error
  - Fixed bug #7113 : Infostore: javascript error if switch ox-modules quickly
  - Fixed bug #7133 : All Moduls - Select folder dialog - different behavio  
* Tue May 08 2007 - jan@open-xchange.org
  - Fixed bug #6888 : Calendar: RMB function 'Change confirmation' do not save users text input for accept/decline
  - Fixed bug #7138 : Popup windows: Double-LMB on error messages doesn't work
  - Fixed bug #7120 : Option 'Bestätigungsfenster für neue Termine anzeigen' is set to 'no' for new users
  - Fixed bug #7145 : Option "Show confirmation popup for new appointments?" not at the calender options
  - Fixed bug #6914 : Create appointment in folder without write permission - wrong folder path
  - Fixed bug #6686 : Possible to quit team view configuration without saving
  - Fixed bug #6852 : E-Mail: Drag & Drop: Canceling behaves not as expected
* Tue May 08 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #7183 : All folders - Folder empty notification isn't centrally
  - Fixed bug #7185 : Error Message Popup
* Mon May 07 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6875 : Distribution list: specification guidelines are not implemented
  - Fixed bug #5934 : Participants counter wrong for duplicated tasks
  - Fixed bug #5991 : Tasks: Flag is not duplicated
  - Fixed bug #7109 : Configuration/Import: Import success count is wrong
  - Fixed bug #7127 : (tasks) Name of logged in user is not written in panel title
  - Fixed bug #7055 : Contact Card Layout is not correct for US
* Mon May 07 2007 - jan@open-xchange.org
  - Fixed bug #7115 : Configuration/Import: 'Save' button needs to be changed
* Mon May 07 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7104 : InfoStore/Contacts: No warning popup when closing the new/edit object window
  - Fixed bug #6797 : My Infostore folder not marked as forbidden in move/duplicate dialogs for non-infostore items  
  - Fixed bug #4620 : Infostore subfolders should be marked with the 'shortcut' arrow in the folder tree
  - Fixed bug #6805 : When moving folders in private infostore the other representation becomes inconsistent
  - Fixed bug #7129 : Unable to edit folder if a sibling folder exists with same name  
  - Fixed bug #6929 : Shortcut 'My Infostore' is always collapsed when select folder dialogue is opened  
  - Fixed bug #6673 : First Shared Folder doesn't appear on refresh
* Mon May 07 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #6837 : [IE6] "New $module" window detail views have inconsistent spacing
* Fri May 04 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6234 : [1u1] Tasks, Annotations in Detail-View are displaced
  - Fixed bug #7072 : Contacts sorting: You can't sort for 'Phone (Business)' and 'Cell Phone' in list view
  - Fixed bug #7076 : (tasks) - wrong task is opened for editing in detailed view
  - Fixed bug #6985 : Contacts: Attachment not saved after uploading a picture the server can't handle
  - Fixed bug #7110 : Configuration/Import: Page never resets
* Fri May 04 2007 - jan@open-xchange.org
  - Fixed bug #4803 : [1u1] [IE6] panel help texts do not work
  - Fixed bug #5809 : Tasks: Deleting a task of search results doesn't work
  - Fixed bug #4433 : Mailer strips spaces displaying or replying to an email
  - Fixed bug #7094 : Calendar: Edit, delete and move not disabled in panel in team view
  - Fixed bug #7096 : E-Mail: Unable to abort drag & drop to another folder
  - Fixed bug #7097 : [1u1] not the selected but the first tag is deleted
  - Fixed bug #7099 : Infostore: "Send as attachment", "Send as Link" not translated in the RMB context menu
  - Fixed bug #7100 : Configuration: Calendar/Tasks: "Mail-Benachrichtigung fï¿½r ..." should be changed to "E-Mail Benachrichtigung fï¿½r ..."
  - Fixed bug #6884 : Cannot move whole-day appointment from public to private folder
  - Fixed bug #7103 : Word "Comment" too often in the version comment popup
  - Fixed bug #7054 : Error when adding another admin to private folder
  - Fixed bug #6729 : Calendar: Informations popUp causes javascript error if "All Groups and Users" are added to appointment
  - Fixed bug #6752 : Change of title reverted after click outside appointment
  - Fixed bug #6847 : Permanantly remove your deleted emails?
* Fri May 04 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7082 : Calendar, recurring appointment, scroll back in monthview, appointment shown as doubled
  - Fixed bug #7020 : [InfoStore] Not possible to create a subfolder in InfoStore in some screenflows
  - Fixed bug #7108 : Infostore: Multiple selected items can not be locked/unlocked
* Fri May 04 2007 - Viktor.Pracht@open-xchange.org
  - Fixed Bug #4481 : "Display emoticons as graphics" broken
  - Fixed bug #4733 : Email: Focus of selected email get lost if changing view
* Fri May 04 2007 - stefan.preuss@open-xchange.org
  - Fixed Bug #7015 : Email: delete attachment is not grayed out when no attachment is selected
  - Fixed Bug #5462 : Config: line wrap option in email module does not show expected result
  - Fixed Bug #7114 : Configuration/Import: Importing tasks imports appointments
  - Fixed Bug #7059 : Clicking link to infoitem opens start page
  - Fixed Bug #6991 : [always] (eMail) bcc-recipient is not listed in sent mails folder
  - Fixed Bug #7101 : [1u1] [IE6] calendarweek is written CW for german users
  - Fixed Bug #6963 : HTML Editor seems to crash on complicated HTML
  - Fixed Bug #7065 : Wrong mouse cursor in the folder tree's context menu
* Thu May 03 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #7018 : Whole-Day appointments can only be drag'n'drop'ed in work-week view
  - Fixed bug #6053 : Email: (Fast) Delete emails causes javascript-error
* Thu May 03 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7060 : Unable to drag&drop folders
  - Fixed bug #6319 : Tasks: Participants popup talks about resources
  - Fixed bug #6916 : [1u1]wrong sorting of appointments on the portal page  
* Thu May 03 2007 - jan@open-xchange.org
  - Fixed bug #7058 : "Reset" button does not work in team-view
  - Fixed bug #6988 : Calendar: Subject-text "New Appointment" not selected after creating a new appointment via mousedrag
  - Fixed bug #6246 : Possible to quit team view configuration without saving
* Thu May 03 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6114 : [IE6] Error messages in the panel pulls attachment field out of align
* Wed May 02 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6984 : Contacts: Tab order for 'Telex' is wrong
  - Fixed bug #7021 : Create, Edit whole day appointment and change to monthview
  - Fixed bug #7013 : Calendar. recurring appointment, monthview not updated properly
  - Fixed bug #6995 : IE 7, Calendar, month-view isn't refreshed properly
  - Fixed bug #7011 : Context menus are not shown in the tasks module
  - Fixed bug #6993 : [contacts] not possible to add contacts zu distribution list via double click
* Wed May 02 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6987 : Wrong mouse cursor in 'Help' popup menu
* Wed May 02 2007 - jan@open-xchange.org
  - Fixed bug #7006 : Yearly recurring appointments, "Every 1. undefined"
  - Fixed bug #7022 : Calendar, Workweek-view, no mouse-over popups
  - Fixed bug #7049 : Calendar: Availability tab shows no participants
  - Fixed bug #6992 : IE7- Calendar, teamview, day; no appointments are shown  
  - Fixed bug #6919 : E-Mail: 'Show Source' is not translated
  - Fixed bug #6939 : Format type of error messages must be changed
  - Fixed bug #6996 : Email can't be printed
* Wed May 02 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #7010 : Calendar. can't add second participant to appointment
  - Fixed bug #7019 : Once a participant has been added to a private appointment it cannot be saved  
  - Fixed bug #7045 : [always] contents of deleted infostore folder are displayed in center pane (refresh problem)
  - Fixed bug #6977 : Mail messages list on portal page isn't shown completely  
* Mon Apr 30 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6983 : [IE6] Start Page: JS Error directly after login or click on Refresh
  - Fixed bug #6453 : Attachment view does not apply scrollbars
* Fri Apr 27 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6817 : Disabled input boxes are not grey out in IE-6
  - Fixed bug #6840 : [IE6] Infostore "Version Comment" field is "null" by default
  - Fixed bug #6813 : Infostore: Version Notice popUp is not a text area
  - Fixed bug #6685 : task changed in detailview isn't properly updated in list or h-split
* Fri Apr 27 2007 - jan@open-xchange.org
  - Fixed bug #6868 : Calender Modul - Different behaviour by creating new appt. (Day view/work week view)
  - Fixed bug #6784 : Flag not updated in mail
* Fri Apr 27 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6843 : [IE6] Infostore attachments are opened in the same browser window
  - Fixed bug #6887 : Infostore "Creator" field is incorrect when working with two users in one folder
* Fri Apr 27 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6780 : Copied mail appears in new folder only after reload
  - Fixed bug #6900 : E-Mail folder contents not updated when clicking a folder
* Fri Apr 27 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #6832 : [IE6] V-Split does not show Date if To/CC holds multiple recipients
  - Fixed bug #6831 : [IE6] H-Split does not show CC and Date if To/CC holds multiple recipients
* Thu Apr 26 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6828 : [IE6] Scrollbars in "Add Recipient" dialog are misaligned
  - Fixed bug #6930 : E-Mail Modul - Displaying problem of recipient dialog, and changing design
  - Fixed bug #6903 : Calender Modul - Isn't possible to change whole day appointments with one click at day view
* Thu Apr 26 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6921 : Calendar Detail view: No footer information for appointment
  - Fixed bug #4370 : Firefox - No cursor inside a textfield (fixed in attachment dialog)
  - Fixed bug #6917 : Calendar: 'Select Folder' popup in new appointment window not completly visible and usable with 1024x768  
* Thu Apr 26 2007 - jan@open-xchange.org
  - Fixed bug #6883 : Cannot move serial appointment from private to public calendar
  - Fixed bug #6714 : Some english strings in source code need to be changed. (partially fixed)
  - Fixed bug #6949 : E-Mail Modul - Panel V-Split - Print functionality not active
  - Fixed bug #6934 : Restoring of defined spam mails not possible
  - Fixed bug #5948 : "Options" dropdown is misaligned and not closed in IE
  - Fixed bug #6824 : New appointment disappears in work-week view when using LMB
  - Fixed bug #6775 : Message total not updated when moving mail message
  - Fixed bug #6770 : No information shown that a E-Mail has been replied
* Wed Apr 25 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6865 : Calendar: Scrollbar missing on participants tab in detail view of appointment
  - Fixed bug #6896 : Detail view: background color of the tab row should be changed
  - Fixed bug #6697 : Tasks: User name not displayed
  - Fixed bug #5937 : Tasks: Detail and H-Split view not aligned correctly
* Wed Apr 25 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #4419 : No cursor in entry fields
  - Fixed bug #6889 : Calendar: Month & week view: Mouse cursor changes to 'hand' when bein over another appointment during drag&drop operation
* Wed Apr 25 2007 - jan@open-xchange.org
  - Fixed bug #6391 : Teilnehmer "löschen"
  - Fixed bug #5734 : Tasks: No 'Options' popup when clicking the triangle icon in the upper right corner of the main area
  - Fixed bug #6177 : Infostore: 'Edit' in panel is enabled for a locked document in detail view
  - Fixed bug #6932 : Calender Modul - Each Calender - Work week view - Always the list-icon displayed
  - Fixed bug #6774 : Folder Drag&Drop shows incorrect icon
* Wed Apr 25 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6645 : Change IE6 Login Process to minimize Performance Issues
  - Fixed bug #5780 : [IE6] there is no visible sign when user logs in
* Tue Apr 24 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6859 : Calendar week view: After deleting one appointment the GUI duplicate an appointment on other day
  - Fixed bug #6858 : [IE] Distribution list window "Cancel" does not work
  - Fixed bug #6853 : [FIREFOX] No cursor in distribution list view
  - Fixed bug #6860 : Initial Tasks folder location is empty on the GUI
  - Fixed bug #5890 : Concurrence error shown when changing flags for appointment
  - Fixed bug #6912 : Create contact in folder without write permission - window does not load
  - Fixed bug #6915 : Create task in folder without write permission - JSON error
  - Fixed bug #6819 : Select task detailview and you are stuck
* Tue Apr 24 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6841 : Start page: Mouse cursor change into I-Beam if you move it on the calendar section
  - Fixed bug #6621 : [1u1]portal, modules not up to date
  - Fixed bug #6863 : Search results can't be discarded.
  - Fixed bug #6895 : Items is shown in the "Add users" temporary list are duplicated when deleting one
  - Fixed bug #6894 : "Select users" hoverbox is not updated in the main browser window
  - Fixed bug #6834 : Start page: Section tasks column 'priority' missing
* Tue Apr 24 2007 - jan@open-xchange.org
  - Fixed bug #6888 : Calendar: RMB function 'Change confirmation' do not save users text input for accept/decline
  - Fixed bug #6759 : Preset appointment time does not correspond to time periods in the dropdown menu
  - Fixed bug #6231 : tag_undefined.gif is missing
  - Fixed bug #6811 : Subfolders do not represent the selected folder as headline
  - Fixed bug #6873 : Calendar: No 'hand' cursor on date left/right in query page
  - Fixed bug #6799 : Multi-select RMBs do not work in any module
  - Fixed bug #6757 : "Tags" hovermenu is misaligned and cannot be closed
  - Fixed bug #6761 : "Select Recipient" hoverbox is misaligned
  - Fixed bug #6914 : Create appointment in folder without write permission - wrong folder path
  - Fixed bug #6875 : Distribution list: specification guidelines are not implemented, (fixed part)
  - Fixed bug #6922 : Email: Mark email as "Spam" function on RMB not available
  - Fixed bug #6874 : Options Modul - Panel - There is displayed the Section "Search"
  - Fixed bug #6464 : Unable to log out when following a infostore link
* Tue Apr 24 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6867 : Cursor for icons in the upper right corner should change to the 'hand' cursor
  - Fixed bug #6886 : Firefox: E-Mail: 'Priority' dropdown box has no border on the bottom
* Mon Apr 23 2007 - jan@open-xchange.org
  - Added context menu for attachments in mail.
  - Added send as link, send as attachment and open attachment to infostore rmb context menu.
  - Fixed bug #6803 : Configuration: Sent email notification for appointments and tasks on wrong page
  - Fixed bug #6822 : RMB Menus show "I-Beam" on selecting entries
  - Fixed bug #6826 : Infostore only knows "Lock" in RMB
  - Fixed bug #6830 : Contacts: RMB function 'Duplicate' leads to 'Delete'
  - Fixed bug #6838 : Calendar New Appointment: On 'Availability' tab the column 'participant' is not translated on german environment
  - Fixed bug #6839 : View of forwarded E-Mail attachments lack the "E-Mail" section in Panel
  - Fixed bug #6321 : Calendar work week view: no hand cursor for further appointments
  - Fixed bug #4262 : Different whole day appointmens are shown in different views
  - Fixed bug #6402 : Edit signatue popup, cursor only visible when 7 characters from left border
  - Fixed bug #6850 : Calendar RMB menue: 'Change confirmation' on german environment
  - Fixed bug #6864 : Section 'Search' stays visible in panel after switching from any module to startpage
* Mon Apr 23 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6821 : E-Mail: "Show Source" shows rendered HTML E-Mails
  - Fixed bug #5319 : InfoBox: Direct Link to the Inbox is missing
* Mon Apr 23 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6815 : Email: Created subfolder can't be deleted,moved,renamed
  - Fixed bug #6317 : Send "As link" broken in InfoStore detailed view
  - Fixed bug #6807 : Start page: Horizontal bars on task,appointment,infostore sections
* Mon Apr 23 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6233 : [1u1] tasks, wrong behaviour on save when fields are not filled correctly in detail view
  - Fixed bug #5987 : All Modules: Sorting search results doesn't work (done in all modules)
  - Fixed bug #6519 : [1u1] tasks: Changing a Task-Series to a Single-Task has no effect.	
* Fri Apr 20 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6121 : [1u1] Dropdown Menu Does Not Show Selected Values
  - Fixed bug #6795 : Email drafts: If you edit some draft with attachments added and delete one attachment then all attachments will be deleted
  - Fixed bug #6804 : Contact Cards must be selected at the title to Drag&Drop
  - Fixed bug #6782 : "Sent" E-Mail folder holds "Received" header
  - Fixed bug #6800 : Contact highlighted, but Panel deactivated
* Fri Apr 20 2007 - jan@open-xchange.org
  - Some performance fixes for menu.
  - Fixed bug #6755 - No RMB available in month view.
  - Fixed bug #6769 - No RMB available in week view.  
  - Fixed bug #6778 - Unable to add attachments for E-Mails.
  - Fixed bug #6760 - "Show source" icon has a very tiny clickable area
  - Fixed bug #6766 - "spambutton" Error message when saving the E-Mail configuration
  - Fixed bug #6794 - Inconsistent implementation of "drag&create" appointment in day-view
  - Fixed bug #6776 - Missing cursor in appointment series settings
  - Fixed bug #6802 - Select objects via RMB
  - Fixed bug #6758 - Initial state of "Starts/Ends at" dropdown menu does not correspond with time in the textfields
  - Fixed bug #6810 - Help dropdown list has inconsistent coloring
* Fri Apr 20 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6767 : Only one object of every module is shown in the "Portal" overview
  - Fixed Bug #6765 : "Subscribed" status is not saved when switching views in configuration
* Fri Apr 20 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6808 : Start page: Preferences icon must be removed from GUI
  - Fixed bug #6806 : Start page: Infobox overlay the %-Bar after Login in IE-6
* Thu Apr 19 2007 - andreas.mayer@open-xchange.com
  - Bug #5987 : All Modules: Sorting search results doesn't work (not fixed in tasks yet)
* Wed Apr 18 2007 - dirk.hartman@open-xchange.com
  - Fixed bug #5019 : Switched + and - buttons
* Wed Apr 18 2007 - stefan.preuss@open-xchange.org
  - Major 'Infobox' layout improvements and code optimizations
  - As specified, removed the 'Undock' option for the Infobox
* Wed Apr 18 2007 - jan@open-xchange.org
  - Fixed bug #11141 : changing participants in appointments broken
  - Fixed bug #11153 : Distribution list windows do not open
  - Fixed bug #11154 : Content of infostore detail view not shown when following Links
* Tue Apr 17 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #4953 : [1u1] Email - Delete key not supported in H-Split/V-Split
  - Fixed bug #6716 : Calendar week view: No information popUp appear for all day appointments
  - Fixed bug : Calendar day view: No information popUp appear for all day appointments
* Tue Apr 17 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6724 : Login uses GET method causing password to be logged.
  - Optimized the i18n setLanguage function. Reuse an already loaded i18n JS files
    from the opener if possible.
* Tue Apr 17 2007 - jan@open-xchange.org
  - Fixed bug #11157 : "Empty Folder" does not refresh the folder content
  - Fixed bug #11141 : changing participants in appointments broken
  - Fixed bug #11129 : Mail forward/Mail answer dialog - check boxes not working
  - Fixed bug #11131 : Mail forward/Mail answer dialog - options check box (4th line) interfers with the frame
* Mon Apr 16 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6656 : Calendar Detailview: Description is not listed completly (line break error)
  - Fixed bug #6658 : Calendar Detailview: If you hit 3 times the refresh button participants will get duplicated multiple times
* Mon Apr 16 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6696 : [1u1] Email: Uploadquota exceeded not displayed in GUI
* Fri Apr 13 2007 - suphi.basdemir@open-xchange.com
  - Added new feature "Data import (appointment, task and contact)"
  - Added new Feature "View mail source"
  - Fixed bug #4090 : E-Mail: E-Mail header - Arrow to expand the header is missing
  - Added new feature "Mark mail as Spam"
* Thu Apr 12 2007 - dirk.hartmann@open-xchange.com
  - Fixed bug #5809: deleting a task object from a search result doesn't work
* Wed Apr 11 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug : error handling after posted new contact with wrong image
* Tue Apr 10 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug : Update selection after "mark as" im mail module
  - Fixed bug #4439 : Mark as ... moves focus/selection to first message in list
  - Fixed bug #6200 : Target of hyperlinks to infostore items are shown after manual refresh only
* Wed Apr 04 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #5927 : Tasks: 'Participants' and 'Attachments' tab not updated after editing the task
  - Fixed bug #4949 : Email: Drafts List not updated after "Save Draft"
  - Fixed bug #6320 : Can't remove end date when editing task
  - Fixed bug #6360 : Contacts: Some fields are missing in 'Detail'-View
* Wed Apr 04 2007 - andreas.mayer@open-xchange.com
  - folder permissions live grid implemented
* Wed Apr 04 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6248 : Email: Replying a message in folder "R & D" doesn't work
  - Fixed bug #4733 : Email: Focus of selected email get lost if changing view
  - Fixed bug #4959 : Email: Panel "Mark as" looses selection
  - Fixed bug #5501 : marking message as new does not work (in 6029)
  - Fixed bug #5383 : Mail Modul - Each new mail is automatically marked as "read"
* Tue Apr 03 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #5795 : Infobox: mouseover shows "arrow" for the icon in the upper right corner
  - Fixed bug #4990 : Translation: Tasks - Participants - Add participants
  - Fixed bug #6463 : Infostore: Current indicator is not translated
  - Fixed bug #6318 : InfoStore: Cursor should be in the version comments popup when saving
  - Fixed bug #6160 : Attachment indicator (staple) is shown when not selecting a attachment
  - Fixed bug #4972 : E-Mail: A message with long subject is cut after 256 chars and displays
    with additional space characters in the subject
  - Fixed some major layout issues on the new message page like the
    missing resize of the rte editor, hiding the attachment area and some more
* Tue Apr 03 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #5705 : Infostore: Version info dialog should have standard popup-style
* Mon Apr 02 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6496 : Reminder of 10 minutes gets reverted by OX Server
* Mon Apr 02 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #6450 : livegrid.resize: Invalid pixelHeight: 0 ($module) when resizing H-Split
* Mon Apr 02 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #4488 : sort of mails are different in H-SPlit and V-Split
  - Fixed bug #5022 : Default sorting in Webmail still shows "From"
  - Fixed bug #5088 : IE7 - E-Mail: Editor produces double line breaks
* Fri Mar 30 2007 - suphi.basdemir@open-xchange.com
  - Fixed refreshing contact detail view, when creating new contact
* Fri Mar 30 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #4475 : Infobox does not update
  - Fixed bug #5614 : E-Mail folder does not change state if E-Mail has been read
  - Fixed bug #6559 : Owner removed from appointment when created in public folder and participant is added
* Fri Mar 30 2007 - jan@open-xchange.org
  - Fixed bug #6523 : Calendar: Confirm appointment window bad gui
  - Whole day appointment drag&drop in workweek and implace editing
* Fri Mar 30 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #6232 : [1u1] Tasks, Reminder contains the English words "hours and" for German users
* Thu Mar 29 2007 - suphi.basdemir@open-xchange.com
  - Fixed updating mail folder and mailcheck after deleting multiple emails
  - Fixed part bug #5392 : E-Mail Modul - New mail dialog - Downsize priorities to low, normal, high
  - Fixed detailview appointment comment field
* Thu Mar 29 2007 - stefan.preuss@open-xchange.org
  - Fixed bug #6173 : IE7: E-Mail / V-Split view: vertical scrollbar not shown correctly
  - Fixed bug #6049 : Email Detail-View: Styleguide and inconsistencies between IE6, Firefox and IE-7
  - Fixed over-lying attachment area in mail V-Split
* Wed Mar 28 2007 - suphi.basdemir@open-xchange.com
  - Fixed table-height in Contacts card view
  - Fixed bug in search contact in card view and switch to phonelist
* Tue Mar 27 2007 - markus.wagner@open-xchange.com
  - Fixed layout of login screen
  - Fixed bug #6407 : Calendar Settings: Setting start of working time to 10:00
  	 and end of working time to 7:00 causes bad day view gui
  - Fixed layout in new appointment, contact and task window
* Tue Mar 27 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6326 : Can't copy mail from the detail view
  - Fixed move bug in view calendar detail
* Mon Mar 26 2007 - suphi.basdemir@open-xchange.com
  - updateMailCounter when mark as in multiple messages and when fetch a single mail in default.INBOX
  - updateMailCounter in the undocked window
  - Fixed bug #6517 (part, module contact) : Fast clicks causes wrong entry to be deleted from list
  - Fixed bug #6532 : Task description swallows Newlines in H-Split and Detail View
* Mon Mar 26 2007 - markus.wagner@open-xchange.com
  - restructure the complete new appointment dialog
* Fri Mar 23 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #5374 : Switching to English leaves the left pane in German
* Thu Mar 22 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6002 : Calendar - Week View - Entries should be ordered by time
  - Fixed bug #5929 : Attachment counter wrong for duplicated objects
  - accept email receive, added subject to the confirm window
* Thu Mar 22 2007 - markus.wagner@open-xchange.com
  - changed drag & drop handling in day view
  - Fixed bug #6489 : it is not possible to edit an appointment
  - add contextmenu to dayview
  - Layout changes
* Thu Mar 22 2007 - jan@open-xchange.org 
  - Fixed bug #6275 : Availability information uses wrong colour
  - Fixed bug #6484 : Confirm an appointment window don't show the owner
* Wed Mar 21 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #5148 : Mail Modul - Dialog after double click on mail - Section Flag doesn't works
  - Fixed bug #5992 : Contacts: Allow drag and drop move of contact cards
* Tue Mar 20 2007 - suphi.basdemir@open-xchange.com
  - print appointment detail, added missing fields
  - search address window for distribution list and new mail, changed html structure in DL
* Mon Mar 19 2007 - suphi.basdemir@open-xchange.com
  - Clear old Subject, when no subject is setting in mail
  - Error handling, when mail copy caused error
  - Fixed bug #5978 : Contact Card view only shows 4 rows
* Fri Mar 16 2007 - andreas.mayer@open-xchange.com
  - folder tree state caching for folder selection dialogues implemented
  - cancel button in version comment dialogue included, design improved
  - renamed folder to folder preferences in the config tree
  - imap rights maping implemented
* Fri Mar 16 2007 - Viktor.Pracht@open-xchange.org
  - Rewrote the LiveGrid. Probably broke everything else.
* Thu Mar 15 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #5890 : Concurrence error shown when changing flags for appointment
  - Fixed popup (polish) : headline border in new Mail
  - Fixed forwarding from email (inline) : deleting an attachment causes error
  - Fixed forwarding from email (attachment): name of attachment
  - Fixed bug #5737 : [1u1] mail wrong mouse icon on mouse over attachment
  - Fixed bug doubleclick on added attachment in new Mail
  - Fixed bug #6118 : [1u1][IE6] email, check box for v-card can not be checked in the middle
  - Fixed bug #6206 : [1u1] Paper-Clip in Mail Without Attachment
* Thu Mar 15 2007 - andreas.mayer@open-xchange.com
  - context menu for config folder tree implemented
* Wed Mar 14 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug in detail Appointment, timestamp update
  - Fixed bug #6409 : V-Split shows invalid E-Mail size format
  - Fixed bug #6234 : [1u1] Tasks, Annotations in Detail-View are displaced
* Wed Mar 14 2007 - andreas.mayer@open-xchange.com
  - implemented DnD in month view and week view
  - implemented mail folder subscription
* Tue Mar 13 2007 - markus.wagner@open-xchange.com
  - Fixed bug #6398 : add users popup, entries aren't sorted properly in list
  - Fixed bug #6397 : add users popup, e-mail adresses are missing
  - sort group members in New Appointment
* Tue Mar 13 2007 - Viktor.Pracht@open-xchange.org
  - Fixed bug #6127 : Log mesage when "missing session cookie"
* Mon Mar 12 2007 - markus.wagner@open-xchange.com
  - Fixed bug #6375 : Saving a appointment with not set date leads to Javascrip error
  - removed comma
  - search in all folder in calendar
* Fri Mar 09 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6169 : Tasks: Error TSK-0017 after moving a task and switching the view
  - Fixed bug #6213 : Infostore: Can't set 'Version information' if uploading file attached to task or appointment
  - Fixed bug #6223 : Message "Ihre Einstellungen wurden gespeichert" directly followed by an error
  - Fixed bug #5000 : All modules: Unnecessary commas inserted when adding a tag
  - Fixed bug #5100 : InfoStore: Column 'Current' of the version history not visible with 1024x768
* Fri Mar 09 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6279 : [1u1] email, old email content shown when switching back
* Fri Mar 09 2007 - markus.wagner@open-xchange.com
  - revoked suphis layout changes (Fixed (polish) : new Appointment Popup for Ubuntu 6.10 (FF), broken line)
  - Fixed bug #6367 : Appointment information does not fit into two rows
  - optimized code in dayview at the same time
  - add ids in participants.xml
* Thu Mar 08 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #4771 : 'Select Recipients' popup: Selection is not really selected after clicking 'Clear'
  - Fixed bug #5777 : [1u1] highlighted(marked) text is displayed inconsistent
  - Fixed bug #6090 : Calendar: Appotinment reminder-picker list is to short.
  - Fixed (polish) : new Appointment Popup for Ubuntu 6.10 (FF), broken line
  - Fixed bug #6041 : Contacts - Phone List only shows Last Name
  - Fixed bug #5623 : Build 6033!!!! Javascript error's
  - Fixed bug #4175 : Contacts: Missing mandatory fields on other tabs not shown
* Thu Mar 08 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6036 : [1u1] calendar, team view on mouse over, only time is shown
  - Fixed bug #3980 : Deleting public folders does not work -- change behavior of delete button
  - Fixed bug #6150 : Translation - Folder -> Properties (added i18n tags, must be translated)
* Thu Mar 08 2007 - markus.wagner@open-xchange.com
  - Fixed bug #6281 : Edit one appointment of series destroys it
  - partially fixed bug #5087 : Terminology of Private Flag
  - removed hardcoded timestamp in newAppointment.js
* Thu Mar 08 2007 - jan@open-xchange.org
  - Fixed bug #6281 : Implementation of Drag&Drop in Calendar Workweek
* Wed Mar 07 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6323 : No scrollable window
  - Fixed bug #5074 : Telefon (geschäftlich) does not fit to the Phonelist header
  - Fixed bug #6204 : Email: The 'To' field can't be browse so recipients are not viewable
  - Fixed bug #6096 : Contact cards need more padding for last line
* Wed Mar 07 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6203 : Calendar: All day appointments could not be edit/delete/opened from month-view
* Tue Mar 06 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6195 : Email: English error message clicking on 'To'- Button
  - Fixed bug #6404 : InfoBox throws configGetKey JS error message
  - Fixed quota view, when used is 1000 kb, then stay there 0.97 mb
  - Fixed bug #6207 : calendar weekview, LMB-click marks wrong appointment as selected
* Tue Mar 06 2007 - markus.wagner@open-xchange.com
  - Fixed bug #4464 : [Polish] Notification of participants too close to reminder
* Mon Mar 05 2007 - suphi.basdemir@open-xchange.com
  - Fixed bug #6258 : Mailer dropps "References" and "In-Reply-To" headers
  - Fixed bug #6085 : Links page of detail view not translated
  - Fixed bug #6145 : [TC #1810] IE7 - changing flag of appointment in detailview leads to error
* Mon Mar 05 2007 - jan@open-xchange.org
  - Fixed bug #6035 : begin to fix (display the group in folder props)
* Mon Mar 05 2007 - markus.wagner@open-xchange.com
  - Fixed bug #6128 : Trying to delete an appointment does not result in error message
  - Fixed bug #6202 : search for *, create app, try to delete the app
  - Fixeg bug #6129 : Trying to move an appointment without appropriate rights does not reset the GUI
  - fixed bug with wrong start date when creating an appointment
* Fri Mar 02 2007 - suphi.basdemir@open-xchange.com
  - Optimized contact selection in Card and Phonelist, when create new Contact or DL
  - Fixed bug #4336 : Mail->New Flags can not be set and are not displayed
  - Fixed bug #6062 : Email: CC-Field is not shown in H-Split and V-Split
* Fri Mar 02 2007 - jan@open-xchange.org
  - Fixed bug #6205: [1u1][IE6] tasks, Bad window dimensions when duplicating
  - Fixed bug #6102 : Free/Busy does not refresh view when "participants" is unchecked
  - Fixed bug #6176 : [1u1] Groups in "Availability" are expanded incorrect
  - Fixed bug #5504 : Series information not shown in detail view
  - Fixed bug #8Panel isn't displayed with four rows
  - Fixed bug #6162 : [IE6] Unable to logout when server does not reponse
  - Fixed bug #6226 : Build 6048: Email Preferences: Entering and leaving email preferences without changing anything throws save yes/no window
  - Fixed bug #8839 : [Always] Calendar: Possible to move private appointment to shared folder of another user
  - Fixed bug #8851 : IE: Checkboxes have white background in the series popup for appointments
* Fri Mar 02 2007 - markus.wagner@open-xchange.com
  - Fixed bug #5067 : appointment with group added as participants, status whether accepted or declined can't be seen
  - Fixed bug #6138 : [TC #1227]Calendar listview workweek includes Sa
  - Fixed bug #6180 : listview - month february shows appointments from march
  - removed 6 from Open-Xchange Server 6 (title and about)
  - Fixed bug #4357 : recipient list for appointments should be ordered alphabetically
  - Fixed bug #6224 : Unable to set flags to single appointment from appointment series
* Fri Mar 02 2007 - andreas.mayer@open-xchange.com
  - Fixed bug #6099 : Team view is trapped in current month
  - Fixed bug #6140 : [TC #1807] Team view not updated properly  
* Wed Feb 28 2007 - stefan.preuss@open-xchange.org
  - Fixed a build problem caused by a wrong placed white space
* Mon Feb 26 2007 - stefan.preuss@open-xchange.org
  - initial Changelog
* Thu Jul 27 2006 - jan@open-xchange.org
  - Implemented some functions for SP3
  - Fixed bug #6352 : Series duration not set properly
  - Fixed bug #6752 : Change of title reverted after click outside appointment
  - Fixed bug #7476 : Calendar: Scrolling timerange via dragging an appointment does not work in Dayview
  - Fixed bug #7790 : Inconsistency in drag&drop of calendar day/work-week view
  - Fixed bug #6482 : Calendar - Dayview - Shifted display of time frames
  - Fixed bug #7467 : Calendar Team-view: 'Choose Team' should be grey out in panel if no team is available
  - Fixed bug #6069 : Calendar: Dayview and Workweek-View not similar with timerange label
  - Fixed bug #8016 : [dev] Clone Workweek for dayview in Calendar
  - Fixed bug #5151 : Terminology of options
  - Fixed bug #8445 : [dev] Race condition in access to iframes.
  - Fixed bug #8145 : Calendar: Availability timeline is false (depends on browser font-size)
* Tue Jul 04 2006 - Viktor.Pracht@open-xchange.org
  - Fixed bug #7446 : Infostore: Multiple selection will not be set back
* Sun May 14 2006 - jan@open-xchange.com
  - Fixed bug #7242 : "Save changes" check missing for signatures
  - Fixed bug #7252 : Unable to change confirmation of tasks via context menu
  - Fixed bug #7271 : Empty appointment breaks day view	
  - Fixed bug #7272 : Moving an appointment changes end time
  - Fixed bug #6714 : Some English strings in source code need to be changed	
  - Fixed bug #7077 : Calendar Team View: No information hover if time range is set to 'Day'		
* Mon Mar 20 2006 - jan@open-xchange.org
  - Fixed bug #5771 : Login is not localized
  - Fixed bug #6287 : group 0, not properly shown in groupware
  - Fixed bug #6352 : Series duration not set properly
* Sun Mar 19 2006 - jan@open-xchange.org
  - Fixed bug #5664: IE7 recurring appointment, dropdown boxes in recurrence settings have wrong z-index
  - New Contextmenu Implementation
  - Drag&Drop Implementation for calendar views
  - Fixed bug #6246: Possible to quit team view configuration without saving
  - Fixed bug #6249: [TC #1224] Availability of participants, dropdown-menu has wrong entries
  - Fixed bug #4796: [Polish] Appointments have no bottom border in work week view
  - Fixed bug #4853: Calendar tooltip info is not formatted very well
  - Fixed bug #5848: Drop down menues in all modules have bad css
  - Fixed bug #5999: "Move" icon in contacts is enabled even if the functionality is disabled
  - Fixed bug #6393: Confirmation popup - Displaying of the folder of the appointment
  - Fixed bug #6137: Save of settings after logout - InfoBox/Quickinfo
* Sun Mar 19 2006 - Viktor.Pracht@open-xchange.org
  - Fixed bug #4954 : Email - Cursor keys not supported in list views
