/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * 
 */

var toggleCollapsed = emptyFunction;
var toggleCollapsedPanel = emptyFunction;

(function() {

    var module_icons = {};
    var num_icons = 0;
    var initialised = false;
    var active_module;
    var images = {};
    var divs = {};
    var open, closed, parent;
    var available = true;
    var closedHeight = 0;
    var expanded = false;
    var miniEnabled, infoEnabled;

    /**
     * Adds a module icon at the top of the left side panel.
     * @param {Object} icon A module icon object. The default implementations of
     * unimplemented methods are added to the object.
     *
     * Icon object fields:
     *
     * name: A unique name of the module. No special characters are allowed.
     * text: A human-readable, untranslated name of the module.
     * prio: A numeric priority which determines the relative position of icons.
     *       Icons with lower values are put to the left of icons with higher
     *       values.
     *
     * Icon object methods:
     *
     * getPath(selected): Returns the path of a 24px*24px module icon. selected
     *       is set to true to get the icon for a currently selected module.
     *       If theme adjustments are necessary, they must be performed by this
     *       method.
     *       If not implemented, a default theme-specific path is derived from
     *       the module name.
     * onClick(): Called as a function when the user clicks on the icon.
     *       If not implemented, a switch to the module with the same name is
     *       performed.
     */
    addModuleIcon = function(icon) {
        if (!icon.getPath) icon.getPath = defaultPath;
        if (!icon.onClick) icon.onClick =
            icon.disable ? upsell(icon) : defaultClick(icon);

		  if (!module_icons[icon.name]) num_icons++;
        module_icons[icon.name] = icon;
        
        if (initialised) {
            addIcons([icon]);
            redrawIcons(sortIcons(module_icons));
            resizeIcons();
        }
    }
    
    function defaultPath(selected) {
    	
    	if (this.name == "calendar"){
    		var currentDate = new Date(now()).getUTCDate();
        	var suffix = module_icons[this.name].disable ? "img/"+this.name+"/mod_"+this.name+"_d.gif" : selected ? "img/"+this.name+"/dayicons/mod_"+this.name+"-"+currentDate+"_sel.gif" : "img/"+this.name+"/dayicons/mod_"+this.name+"-"+currentDate+".gif";
        	return getFullImgSrc(suffix);
		} else {
			var suffix = module_icons[this.name].disable ? "_d.gif" : selected ? "_sel.gif" : ".gif";
        	return getFullImgSrc("img/" + this.name + "/mod_" + this.name + suffix);		
		}
    }

    function upsell(icon) {
        return function() {
            // Proposed guideline: the event parameter identifies the config
            // path of the feature.
            triggerEvent("Feature_Not_Available", "modules/" + icon.name);
        };spExpanded
    }
    
    function defaultClick(icon) {
        return function() {
            if (activemodule == "configuration") {
                configuration_askforSave(switchMod);
            } else {
                switchMod();
            }
            function switchMod() {
                activemodule = icon.name;
                switch (icon.name) {
                    case "mail":
                    	// iterating through available mail accounts and
                    	// select first we found. if we found nothing we throw an error
                    	oMainFolderTree.cache.do_load_subfolders("1", oMainFolderTree.cache.find_folder("1"), {}, 
                    		function(e) { 
                    			var found = false;
                    			for (var i in mail_accounts.data.data) {
                    				var acc = mail_accounts.data.data[i];                    				
                    				if (acc && oMainFolderTree.cache.fast_access["default" + acc.id]) {
                    					var separator = configGetKey("modules.mail.defaulteparator") || "/";
                    					setActiveFolder("default" + acc.id + separator + "INBOX", null, true);
                    					triggerEvent("OX_Switch_Module", icon.name, "newfolder");
                    					found = true;
                    					break;
                    				}			
                    			}
                    			if (!found) {
                    				newAlert(_("The E-Mail module is not available"), 
             					   	       _("Unable to establish a connection to the E-Mail server. Possible reasons: the mail server is (temporarily) down or there are network connection problems. To prevent further errors the module has been disabled. Please contact your administrator."), /**i18n**/
             					   	       null);
                    				return;
                    			}
                    		}
                    	);
                        break;
                    case "configuration": 
                        activefolder = configGetKey("folder.configuration");
                        triggerEvent("OX_Switch_Module", icon.name, "newfolder");
                        break;
                    case "portal":
                        activefolder = undefined;
                        triggerEvent("OX_Switch_Module", icon.name, "newfolder");
                        break;
                    default:
                        setActiveFolder(configGetKey("folder")[icon.name], null, true);
                    	triggerEvent("OX_Switch_Module", icon.name, "newfolder");
                }                
            }
        };
    }

    function addIcons(icons) {
        for (var i = 0; i < icons.length; i++) {
            var icon = icons[i];
            var selected = active_module == icon.name;
            images[icon.name] = {
                collapsed: img(icon, selected),
                expanded: img(icon, selected)
            };           
            var text = addTranslated(icon.text);
            var div = divs[icon.name] = newnode("div", 0,
                { id: "sp_o_" + icon.name },
                [images[icon.name].expanded, text]);
            images[icon.name].collapsed.id = "sp_c_" + icon.name;
            if (icon.disable) div.className += " font-color-disabled";
            if (selected)
                div.className = "background-color-PMG-selection-elements";
            addDOMEvent(div, "click", icon.onClick);
            addDOMEvent(images[icon.name].collapsed, "click", icon.onClick);
        }
    }
    
    function img(icon, selected) {
        var text = _(icon.text);
        return newnode("img", 0, { src: icon.getPath(selected), width: 24,
            height: 24, alt: text, title: text });
    }

    function sortIcons(icons) {
        var sorted = new Array(num_icons);
        var i = 0;
        for (var name in icons) sorted[i++] = (icons[name]);
        sorted.sort(function(a, b) { return a.prio - b.prio; });
        return sorted;
    }

    function redrawIcons(icons) {
        removeChildNodes(open);
        removeChildNodes(closed);
        for (var i = 0; i < icons.length; i++) {
            open.appendChild(divs[icons[i].name]);
            closed.appendChild(images[icons[i].name].collapsed);
        }
    }

    function resizeIcons() {
        var newHeight = parent.clientWidth;
        if (newHeight != closedHeight) {
            closedHeight = newHeight;
            setCollapsed();
        }
        var newAvailable = body.offsetHeight > 768;
        if (newAvailable == available) return;
        var display;
        if (newAvailable)
            display = "block";
        else {
            display = "none";
            if (expanded) toggleCollapsed('modules_selection');
        }
        if ($("collapse_arrow")) $("collapse_arrow").style.display = display;
        available = newAvailable;
    };

    register("OX_Configuration_Loaded", function() { 
    	showNode("modules_selection");   	
        open = $("modules_open");
        closed = $("modules_closed");
        parent = $("modules_selection");
    
        register("OX_Switch_Module", switchModule);
        register("OX_Switch_View", function(view) {
            switchModule(view.split("/")[0]);
        });

        var sorted = sortIcons(module_icons);
        for (var i = 0; i < sorted.length; i++) {
            if (!sorted[i].disable) {
                active_module = sorted[i].name;
                break;
            }
        }
        addIcons(sorted);
        redrawIcons(sorted);

        register("LanguageChanged", function() {
            for (var i in images) {
                with (images[i]) {
                    collapsed.alt = collapsed.title = _(module_icons[i].text);
                    expanded.alt = expanded.title = _(module_icons[i].text);
                }
            }
        });
        
        resizeEvents.register("Resized", resizeIcons);
    
        toggleCollapsed = function() {
            expanded = !expanded;
            setCollapsed();
        }
        
        toggleCollapsedPanel = function() {	
        	if (menu_showsidepanel) {
            	miniEnabled = $('menu_portal_minicalendar_checkbox').checked;
            	infoEnabled = $('menu_portal_mail_checkbox').checked;
            	hideNode("folder_tree");
        		hideNode("loggedinUser");
            } else {
        		if (active_module != "configuration") showNode("folder_tree");           	
        		showNode("loggedinUser");
            }

        	getElement($("test0008").firstChild).style.visibility = menu_showsidepanel ? "hidden" : "visible";
        	$("sidepanel_dragpoint").style.display = menu_showsidepanel ? "none" : "";
        	
        	if (menu_showsidepanel && miniEnabled) {
        		setTimeout(function() { triggerEvent('OX_Show_MiniCalendar',false); });
            } else if (!menu_showsidepanel && miniEnabled) {
            	setTimeout(function() { triggerEvent('OX_Show_MiniCalendar',true); });
            }
        	
        	if (menu_showsidepanel && infoEnabled) {
        		setTimeout(function() { triggerEvent('OX_Show_Mail_Panel',false); });
            } else if (!menu_showsidepanel && infoEnabled) {
            	setTimeout(function() { triggerEvent('OX_Show_Mail_Panel',true); });
            }
        	
        	menu_showsidepanel = !menu_showsidepanel;
         	
        	$("toggle_sidepanel_img").src = getFullImgSrc("img/arrows/" + (menu_showsidepanel ? "arrow_double_gray_left.gif" : "arrow_double_gray_right.gif"));
            resizeSplit("sidesplit", menu_showsidepanel ? "19.1em" : "2.9em");            
        }

        initialised = true;
    });

    function switchModule(name) {    	
        if (active_module == name) return;
        if (images[active_module]) {
            images[active_module].collapsed.src =
                images[active_module].expanded.src =
                module_icons[active_module].getPath(false);
            divs[active_module].className = "";
        }
        if (images[name]) {
            images[name].collapsed.src = images[name].expanded.src =
                module_icons[name].getPath(true);
            divs[name].className = "background-color-PMG-selection-elements";
        }
        active_module = name;
        
        if (active_module == "configuration") {
        	$("toggle_sidepanel_img").style.display = "none"; 
        	if (!menu_showsidepanel) toggleCollapsedPanel();
        } else {
        	$("toggle_sidepanel_img").style.display = "";
        }
    }

    function setCollapsed() {
        var w = parent.clientWidth;
        //open.style.display = expanded ? "" : "none";
        //closed.style.display = expanded ? "none" : "";
        var size = expanded
            ? 4 + 26 * num_icons
            : 4 + 26 * Math.min(num_icons,
                Math.ceil(num_icons / Math.floor((w - 4) / 31)));
        resizeSplit("modules_selection", size + "px");
    }
    
    registerModuleStatic("contacts", "Contacts", 40); /*i18n*/
	registerModuleStatic("calendar", "Calendar", 30); /*i18n*/
	registerModuleStatic("mail", "E-Mail", 20); 	   /*i18n*/
	registerModuleStatic("portal", "Start Page", 10); 	   /*i18n*/
	registerModuleStatic("infostore", "InfoStore", 60); /*i18n*/
	registerModuleStatic("tasks", "Tasks", 50); /*i18n*/
    
})();

fileloaded();