/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

function fnQueue() {
	this.queue = new Object();
}
fnQueue.prototype = {
	push:function(idParam,functionParam) {
		if(this.queue[idParam] != undefined) {
			this.queue[idParam].push(functionParam);
			return true;
		} else {
			this.queue[idParam] = new Array();
			this.queue[idParam].push(functionParam);
			return false;
		}
	},
	exe: function(idParam,objParam) {
		if(this.queue[idParam]) {
			for(i=0; i<this.queue[idParam].length; i++) {
				var nextFN = this.queue[idParam][i];
				nextFN(objParam);
			}
			delete this.queue[idParam];
		}		
	}
}

function foldertreeState(oState) {
	this.state = oState;
	this.links = new Object();
}
foldertreeState.prototype = {
	setState: function(oState) {
		var Self = this;
		this.links = new Object();
		function cl_state(stateParam) {
			var newObj = new Object();
			for (var nIndx in stateParam) {
				var newIndx = nIndx.split('$')[1];
				if((nIndx.split('$')[2] == "link"))
					Self.links[newIndx] = true;
				newObj[newIndx] = cl_state (stateParam[nIndx]);
			}
			return newObj;
		}
		this.state = cl_state (oState);
	},
	getState: function(sPrefix) {
		var Self = this;
		function mk_state(stateParam) {
			var newObj = new Object();
			for(var nIndx in stateParam) {
				var newIndx = sPrefix + '$' + nIndx;
				newObj[newIndx] = mk_state (stateParam[nIndx]);
			}
			return newObj;
		}
		return mk_state (this.state);
	}
}
var optFolderState = new foldertreeState({1:{},2:{}});

//Folder Object Definition
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
 * class cFolder combines all attributes of a Folder,  
 * attributes must be set in constructer during folder creation
 */
function cFolder(sIdParam, sModuleParam, sNameParam, sContainedInfoParam,
        bContainsSubfoldersParam, nTimeStampParam, aPermissionsParam, 
        sTypeParam, oOwnRightsParam, bDefaultFolderParam, nUnreadParam,
        nOwnerIdParam, nSubscribedParam, nCapabilities) {
	this.sId = sIdParam;
	this.sModule = sModuleParam;
	this.sName = sNameParam;
	this.sContainedInfo = sContainedInfoParam;
	this.bContainsSubfolders = bContainsSubfoldersParam;
	this.nTimeStamp = nTimeStampParam;
	this.aPermissions=aPermissionsParam; 
	this.oOwnRights=oOwnRightsParam; 
	this.enabled = true;
	this.sType = sTypeParam;
	this.bDefaultFolder = bDefaultFolderParam;
	this.nUnread = nUnreadParam;
	this.owner_id = nOwnerIdParam;
	this.subscribed = nSubscribedParam;
	this.capabilities = nCapabilities;
	this.bLink = false;
}

/**
 * @return {Array} - an array with [0] the closed and [1] the opened icon
 */
function getIconImagePath(sParentId, sId, sModule, bLink, bREnabledIMAP, bDefaultFolder) {
	var sImageSRC = new Array(2);
	if (bLink && sModule == 'infostore') {
		var tmp = (bREnabledIMAP) ? "img/folder/myinfostore.gif" : "img/folder/myinfostore_dis.gif";
		sImageSRC[0] = getFullImgSrc(tmp);
        sImageSRC[1] = sImageSRC[0];
        			
	} else if (sModule == 'system' && sId == 1 || sParentId==10 && bDefaultFolder && sModule == 'infostore') {
		tmp = (bREnabledIMAP) ? "img/folder/user.gif" : "img/folder/user_dis.gif";
		sImageSRC[0] = getFullImgSrc(tmp);
        sImageSRC[1] = sImageSRC[0];
        				
	} else if (sModule == 'system' && String(sId).match(/^default(\d+)?/)) {
		var tmp = (bREnabledIMAP) ? "img/folder/mail.gif" : "img/folder/mail_dis.gif";
        sImageSRC[0] = getFullImgSrc(tmp);
        sImageSRC[1] = sImageSRC[0];
        
	} else if (sModule == 'system' && sId == 2) {
		var tmp = (bREnabledIMAP) ? "img/folder/public.gif" : "img/folder/public_dis.gif";
        sImageSRC[0] = getFullImgSrc(tmp);
        sImageSRC[1] = sImageSRC[0];
        		
	} else if (sModule == 'system' && sId == 3) {
		var tmp = (bREnabledIMAP) ? "img/folder/shared.gif" : "img/folder/shared_dis.gif";
        sImageSRC[0] = getFullImgSrc(tmp);
        sImageSRC[1] = sImageSRC[0];
				
	} else if (sModule != 'system') {		
		if (sModule == 'mail') {
			var myObject = configGetKey("mail.folder");					
			if (corewindow.mail_accounts != undefined && corewindow.mail_accounts.data && 
					corewindow.mail_accounts.data.get(corewindow.getMailAccountIdByFolder(sId)) && 
					corewindow.getMailAccountIdByFolder(sId) != 0) {
				myObject = corewindow.mail_accounts.data.get(corewindow.getMailAccountIdByFolder(sId));
			}
			for (var eachMailFolder in myObject) {
				if (sId == (myObject[eachMailFolder + "_fullname"] || myObject[eachMailFolder])) {
					switch (eachMailFolder) {
						case "inbox":
						      var tmp = (bREnabledIMAP) ? "img/folder/inbox.gif" : "img/folder/inbox_dis.gif";
						      sImageSRC[0] = getFullImgSrc(tmp);
						      sImageSRC[1] = sImageSRC[0];
					 		  break;
						case "sent_fullname":
						case "sent":	
						      var tmp = (bREnabledIMAP) ? "img/folder/outbox.gif" : "img/folder/outbox_dis.gif";
                              sImageSRC[0] = getFullImgSrc(tmp);
                              sImageSRC[1] = sImageSRC[0];
                              break;
						case "trash_fullname":
						case "trash":	
						      var tmp = (bREnabledIMAP) ? "img/folder/garbage.gif" : "img/folder/garbage_dis.gif";
                              sImageSRC[0] = getFullImgSrc(tmp);
                              sImageSRC[1] = sImageSRC[0];
                              break;
						case "drafts_fullname":
						case "drafts":
						      var tmp = (bREnabledIMAP) ? "img/folder/draft.gif" : "img/folder/draft_dis.gif";
                              sImageSRC[0] = getFullImgSrc(tmp);
                              sImageSRC[1] = sImageSRC[0];
                              break;
						case "spam_fullname":
						case "spam":
						      var tmp = (bREnabledIMAP) ? "img/folder/spam.gif" : "img/folder/spam_dis.gif";
                              sImageSRC[0] = getFullImgSrc(tmp);
                              sImageSRC[1] = sImageSRC[0];
                              break;
						case "ham_fullname":
						case "ham":	
						      var tmp = (bREnabledIMAP) ? "img/folder/ham.gif" : "img/folder/ham_dis.gif";
                              sImageSRC[0] = getFullImgSrc(tmp);
                              sImageSRC[1] = sImageSRC[0];
                              break;								 																 									 											 											 		
						default:	
						      var tmp = (bREnabledIMAP) ? "img/folder/folder_closed.gif" : "img/folder/folder_closed_dis.gif";
		                      sImageSRC[0] = getFullImgSrc(tmp);
		                      tmp = (bREnabledIMAP) ? "img/folder/folder_opened.gif" : "img/folder/folder_opened_dis.gif";
		                      sImageSRC[1] = getFullImgSrc(tmp);
					}
					break;
				} else {
					var tmp = (bREnabledIMAP) ? "img/folder/folder_closed.gif" : "img/folder/folder_closed_dis.gif";
			        sImageSRC[0] = getFullImgSrc(tmp);
			        tmp = (bREnabledIMAP) ? "img/folder/folder_opened.gif" : "img/folder/folder_opened_dis.gif";
			        sImageSRC[1] = getFullImgSrc(tmp);
				}
			}
			
		} else {
			var tmp = (bREnabledIMAP) ? "img/folder/"+sModule+".gif" : "img/folder/"+sModule+"_dis.gif";
            sImageSRC[0] = getFullImgSrc(tmp);
            sImageSRC[1] = sImageSRC[0];
        }
		
	} else {
		var tmp = (bREnabledIMAP) ? "img/folder/folder_closed.gif" : "img/folder/folder_closed_dis.gif";
        sImageSRC[0] = getFullImgSrc(tmp);
        tmp = (bREnabledIMAP) ? "img/folder/folder_opened.gif" : "img/folder/folder_opened_dis.gif";
        sImageSRC[1] = getFullImgSrc(tmp);
	}	
	
	return sImageSRC;			
}
 
function getFolderOwner(folder) {
	var owner = config.identifier;
	var _tmpF = oMainFolderTree.cache.find_folder(folder);
 	if (_tmpF && (_tmpF.oxfolder.data.type == 1 || _tmpF.oxfolder.data.type == 3) && 
 	    _tmpF.oxfolder.data.created_by) {
 		owner = _tmpF.oxfolder.data.created_by;
 	}
 	return owner;
}

/**
 * Fetch folder information using multiple request
 * @param folderIDs - An array of folder ids
 * @param columns - String of columns which should be fetched (optional). If null a default set will be used.
 * @param callback - Callback wich will be executed after the server delivers the reponse
 */
function doAjaxFetchFolder(folderIDs, columns, callback) {
    var sCols =  columns || oMainFolderTree.cache.columns;        
    var sAjaxRequest = AjaxRoot + "/multiple?session=" + session;
    var finalArr = new Array();
    for (var i=0; i<folderIDs.length; i++) {
    	finalArr.push({ module: "folder", action: "get", id: folderIDs[i], folder: folderIDs[i], columns: sCols });
    }    
    newFolderJson.put(sAjaxRequest, finalArr, null, callback);
}

function doAjaxUpdateRequest(sId, oFolder, nTimeStamp, callback, err_handlr) {
	var sAjaxRequest = AjaxRoot + "/folders?action=update"
        + "&id=" + getUrlEncodedString(sId)
        + (configContainsKey("modules.folderstorage") ? "&tree=1" : "")
        + "&session=" + session
	if (nTimeStamp != undefined) {
		sAjaxRequest += "&timestamp=" + nTimeStamp;
	}
	newFolderJson.put(sAjaxRequest, oFolder, null,callback,err_handlr);			
}

function doAjaxNewFolderRequest(parentNodeId ,oFolder, callback, callbackERR) {
    var sAjaxRequest = AjaxRoot + "/folders?action=new"
       + "&folder_id=" + getUrlEncodedString(parentNodeId) 
       + (configContainsKey("modules.folderstorage") ? "&tree=1" : "")
       + "&session=" + session;
    newFolderJson.put(sAjaxRequest, oFolder, null, callback, callbackERR);        
}

function doAjaxRemoveFolderRequest(aFolders, nTimeStamp, callback) {
    var sAjaxRequest = AjaxRoot + "/folders?action=delete"
    			+ (configContainsKey("modules.folderstorage") ? "&tree=1" : "")
    			+ "&session=" + session;
    if (nTimeStamp != undefined) {    	
        sAjaxRequest += "&timestamp=" + nTimeStamp;
    }
    newFolderJson.put(sAjaxRequest, aFolders, null, callback);  
}

function computePerm(nBits, nOffset) {
    return (nBits >> nOffset) & (nOffset >= 28 ? 1 : 127);
}

function FolderPath(module) {   
    this.module = module;
    this.folderId = null;
    this.nodeId = null;
    this.className = "linkstyle-headline";
    this.classNameD = "font-style-low";
    this.events = new Array();
    this.cb = function(module, folderId) {
            return function() {
                triggerEvent("OX_Direct_Linking", module, 
                    { module: module, folder: folderId });
            }                
        }
    this._cancelDraw=false;
    this.additionalNode;
}

FolderPath.prototype = {
    setFolderId: function(folderId) {
        this.folderId = folderId;
    },  
    drawDOMNode: function(nodeId, folderId) {
        if (nodeId) this.nodeId = nodeId;
        if (folderId) this.folderId = folderId;
        if (!$(this.nodeId) || !folderId || this._cancelDraw) return;
        this._cancelDraw = true;
        var Self = this;
        this.clear();   
        function fn_folder(sPath) {
            for (var i = sPath.length-1; i >= 0; i--) {                   
                oMainFolderTree.cache.get_folder(sPath[i].id, (function(sPath) {
                	return function(e) {
                		if (sPath.id == 1) {
                			internalCache.getUsers([config.identifier],
                					function(resp) {
                						sPath.title = resp[config.identifier].display_name;
                					}
                			);
                		}
	                	var ids = configGetKey("folder");
				        var replacedname = "";
				        switch (sPath.id) {
				            case ids.tasks:
				                replacedname = "Tasks"; /*i18n*/
				                break;
				            case ids.calendar:
				                replacedname = "Calendar"; /*i18n*/
				                break;
				            case ids.contacts:
				                replacedname = "Contacts"; /*i18n*/
				                break;
				        }
	                    var read = computePerm(e.oxfolder.data.own_rights,7) > 0;
	                    var myNode = newnode("span", 0, { className: read  ? Self.className : Self.classNameD },
	                        [ document.createTextNode(replacedname ? _(replacedname) : sPath.title) ]);
	                    if (read) {
	                        var fcb = (Self.cb)(e.oxfolder.data.module, sPath.id);
	                        addDOMEvent(myNode, "click", fcb);
	                        Self.events.push(["click", fcb]);
	                    } 
	                    $(Self.nodeId).appendChild(myNode);
	                    if (i>0) {
	                    	$(Self.nodeId).appendChild(document.createTextNode(" / "));
	                    } else if (Self.additionalNode != undefined) {
	                    	$(Self.nodeId).appendChild(Self.additionalNode);
	                    }
                	}
                })(sPath[i]));
            }
            Self._cancelDraw=false;
        }               
        oMainFolderTree.get_folder_path_array(this.folderId, fn_folder);        
    },
    drawSearch: function(module, searchTerm) {
    	if (!this.nodeId || this.module != module) return;
    	this.clear();
    	var myNode = newnode("span", 0, 0, [ document.createTextNode(format(_("Results for \"%s\""), searchTerm)) ]);
    	$(this.nodeId).appendChild(myNode);
    },
    clear: function() {
        if (!$(this.nodeId)) return;
        for (var i=0; i< this.events.length; i++) {
            removeDOMEvent($(this.nodeId), this.events[i][0], this.events[i][1]);
        }
        this.events = new Array();
        removeChildNodes($(this.nodeId));
    }
}

fileloaded();