/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */
register("Loaded",function() {
	if(!$("menu_picture")) return;
    var menu = new PulldownMenu($("menu_picture_contextmenu"));
    var items = [{
        text: "E-Mail"/*i18n*/, icon: "img/mail/mail.gif",
        event: "OX_NEW_MAIL", module: "mail"
    }, {
        text: "Appointment"/*i18n*/, icon: "img/calendar/calendar.gif",
        event: "OX_Before_Create_Calendar", module: "calendar"
    }, {
        text: "Contact"/*i18n*/, icon: "img/contacts/contacts.gif",
        event: "OX_Before_Create_Contact", module: "contacts"
    }, {
        text: "Distributionlist"/*i18n*/, icon: "img/menu/distributionlist.gif",
        event: "OX_Before_Create_Distributionlist", module: "contacts", 
        picture: "distributionlist"
    }, {
        text: "Task"/*i18n*/, icon: "img/tasks/tasks.gif",
        event: "OX_Before_Create_Task", module: "tasks"
    }, {
        text: "InfoStore Item"/*i18n*/, icon: "img/infostore/infostore.gif",
        event: "OX_Before_Create_InfoStore", module: "infostore"
    }];
    for (var i in items) {
        (function(item) {
            var menuitem = (new MenuItem(item.text, function() {
                triggerEvent(item.event);
            })).setIcon(item.icon);
            var key = "modules." + item.module + ".module";
            var picture = item.picture || item.module;
            menuitem.onShow = function() {
                this.setVisible(   configGetKey(key)
                                && modulesinpicturemenu[picture]);
            };
            menu.addItem(menuitem);
        })(items[i]);
    }
});

var globalContextMenus = {};
var globalSearchMenu;

var menudisableattachment=false;
var menucountunlockable=0;
var menucountlockable=0;
var menucounteditable=0;
var menucountselected=0;
var menucountconfirm=0;
var menucountsubselected=0;
var menunestedmessage=false;
var menucountsubselectedmembers;
var menuisdraftfolder=false;
var menuselectedobjects=new Array();
var menuselectedfolders=new Object();
var menuglobalzaehler=0;
corechangeSelected();
function menuisActive(id) {
	if($(id)) {
		if(!($(id).style.display == "none"))
			return true; 
	}
	return false;
}
function corechangeSelected()
{
	
	register("OX_Selected_Nested",function (nestedbool) {
		menunestedmessage=nestedbool;
	});
	register("OX_Selected_Draft",function (draftbool) {
		menuisdraftfolder=draftbool;
	});
	register("Selected",function (selected) {
		function acb(ofolder) {
			menuselectedfolders=ofolder;
			triggerEvent("OX_SELECTED_ITEMS_CHANGED",menucountselected);
			triggerEvent("OX_SELECTION_CHANGED",menucountselected);
		}
		if(!equals(menuselectedobjects,selected)) {		
			menucountselected=selected.length;
			menuselectedobjects=selected;
			var checkFolders=new Array();
			for(var i=0;i<menuselectedobjects.length;i++) {
				checkFolders.push(menuselectedobjects[i].folder || menuselectedobjects[i].folder_id);
			}
			if(checkFolders.length>0) {
				oMainFolderTree.fetchAndGetFolders(checkFolders,acb);
			} else {
				menuselectedfolders=new Array();
				triggerEvent("OX_SELECTED_ITEMS_CHANGED",menucountselected);
				triggerEvent("OX_SELECTION_CHANGED",menucountselected);
			}
		}
	});
	register("Confirmation_Changed",function(selected) {
		menucountconfirm = selected;
		triggerEvent("OX_SELECTION_CHANGED_CONFIRM",menucountconfirm);
	});
	register("SubSelected",function(selected,disable) {
		menucountsubselected=selected;
		if(disable) { menudisableattachment=true; } else { menudisableattachment=false; }
		triggerEvent("OX_SELECTED_SUBSELECTION_CHANGED",menucountsubselected);
		triggerEvent("OX_SELECTION_CHANGED",menucountsubselected);
	});
	register("SubSelectedTeamMember",function(selected) {
		menucountsubselectedmembers=selected;
		triggerEvent("OX_SELECTED_SUBSELECTION_CHANGED",menucountsubselected);
		triggerEvent("OX_SELECTION_CHANGED",menucountsubselected);
	});
	register("OX_Selected_Member",function(selected) {
		triggerEvent("SubSelected",selected.length);
	});
	register("OX_Lockable",function(lock,unlock,editlock) {
		menucountlockable=lock;
		menucountunlockable=unlock;
		menucounteditable=editlock;
	})
}
function initContents(modules) {

    function createCoreMenu() {
        var menu = new PulldownMenu($("menu_new_options_menu_img"));
        
        var search = (new MenuItem("Search"/*i18n*/, function() {
            changeDisplayDynamic("menu_search_global", this.getChecked());
        })).setChecked(false);
        menu.addItem(search);
        
        var search2 = (new MenuItem("Search"/*i18n*/, function() {
            changeDisplayDynamic("menu_search_mail", this.getChecked());
        })).setChecked(false);
        menu.addItem(search2);
        
        var separator = new MenuSeparator();
        menu.addItem(separator);
        
        var infobox = (new MenuItem("Show InfoBox"/*i18n*/, function() {
            triggerEvent("OX_Show_Mail_Panel", this.getChecked());
        })).setChecked(false);
        menu.addItem(infobox);
        
        var quickinfo = (new MenuItem("Show QuickInfo"/*i18n*/, function() {
            triggerEvent("OX_Show_Help_Panel", this.getChecked());
        })).setChecked(false);
        menu.addItem(quickinfo);
        
        var minicalendar = (new MenuItem("Show Minicalendar"/*i18n*/, function() {
            triggerEvent("OX_Show_MiniCalendar", this.getChecked());
        })).setChecked(false);
        menu.addItem(minicalendar);
    
        menu.onShow = function() {
            var path = currentpath2.join("/");
            if(dynamiccontents[currentpath2[0]]) {
                for(var i = 0; i < dynamiccontents[currentpath2[0]].length; i++) {
                    var el = dynamiccontents[currentpath2[0]][i];
                    if(path.indexOf(el.view) == 0) {
                        search.setChecked(el.display!="none");
                        search2.setChecked(el.display!="none");
                        break;
                    }
                }
            }
            infobox.setChecked(menu_showmail);
            quickinfo.setChecked(menu_showhelp);
            minicalendar.setChecked(menu_showmini);
    
            search.setVisible(inViews({
                tasks: { list: 1, split: 1, search: 1 },
                infostore: { list: 1, split: 1 },
                calendar: { calendar: 1, list: 1 },
                contacts: { cards: 1, phonelist: 1 }
            }));
            search2.setVisible(inViews({
                mail: { list: 1, hsplit: 1, vsplit: 1 }
            }));
            separator.setVisible(search.visible || search2.visible);
    
            function inViews(views) {
                return    currentpath2[0] in views
                       && currentpath2[1] in views[currentpath2[0]];
            }  
        };
    }
    
    function createQuickInfoMenu() {
        var menu = new PulldownMenu($("menu_new_options_menu_img"));
        var quickinfo = (new MenuItem("Show QuickInfo"/*i18n*/, function() {
            triggerEvent("OX_Show_Help_Panel", this.getChecked());
        })).setChecked(false);
        menu.addItem(quickinfo);
        menu.onShow = function() { quickinfo.setChecked(menu_showhelp); };
    }
	
	switch (modules) {
		case "core": 
			register("Loaded",function() {
					initDisplay("tasks/list","menu_search_global");
					initDisplay("tasks/split","menu_search_global");
					initDisplay("tasks/search","menu_search_global");
					initDisplay("infostore/list","menu_search_global");
					initDisplay("infostore/split","menu_search_global");
					initDisplay("mail/list","menu_search_mail");
					initDisplay("mail/hsplit","menu_search_mail");
					initDisplay("mail/vsplit","menu_search_mail");
					initDisplay("calendar/calendar","menu_search_global");
					initDisplay("calendar/list","menu_search_global");
					initDisplay("contacts/cards","menu_search_global");
					initDisplay("contacts/phonelist","menu_search_global");				
				createCoreMenu();
				menuportalloaded();
				menumailloaded();
				menucalendarloaded();	
				menucontactloaded();
				menutasksloaded();		
				menuinfostoreloaded();		
				menuconfigurationloaded();		
				menugloballoaded();
			});
			
			register("OX_Configuration_Loaded_Complete",function() {
				setTimeout(function() {
					if(configContainsKey("gui.portal.tooltip"))	{
						var tmp=configGetKey("gui.portal.tooltip");
						triggerEvent("OX_Show_Help_Panel",tmp);
					}
					if(configContainsKey("gui.portal.infobox")) {
						var tmp=configGetKey("gui.portal.infobox");
						triggerEvent("OX_Show_Mail_Panel",tmp);
					}
					if(configContainsKey("gui.portal.minicalendar")) {
						var tmp=configGetKey("gui.portal.minicalendar");
						triggerEvent("OX_Show_MiniCalendar",tmp);
					}
				},0);
			});
			register("SubSelected",changeAttachments);
			register("OX_Switched",function() {changeAttachments(menucountsubselected)});
			register("OX_menu_Change_Height",function() {changeAttachments(menucountsubselected)});
			register("OX_SELECTION_CHANGED_CONFIRM",changeConfirm);
			register("OX_Switched",onmenuchangeHeightorSelectedGlobal);
			register("OX_Selected_Draft",onmenuchangeHeightorSelectedMail);
			register("OX_SELECTED_ITEMS_CHANGED",onmenuchangeHeightorSelectedGlobal);
			register("OX_menu_Change_Height",onmenuchangeHeightorSelectedGlobal);
			menuregisterPortalContents();
			menuregisterMailContents();
			menuregisterCalendarContents();
			menuregisterContactContents();
			menuregisterTaskContents();
			if(configGetKey("modules.infostore.module")) {
				menuregisterInfoStoreContents();
			}
			menuregisterConfigurationContents();
			break;
		
		case "mail_new": 
			register("Loaded", function () {
                mailnewonload();
				initDisplay("mail_new","menu_mail_new_attachment");			
				createQuickInfoMenu();
			});
			register("OX_menu_Change_Height",mailnewattachmentchangeHeight);
			register("OX_Switched",mailnewattachmentchangeHeight);			
            register("SubSelected",mailnewattachmentchangeHeight);
			register("OX_SELECTED_SUBSELECTION_CHANGED",mailnewattachmentchangeHeight);					
			
			register("OX_Show_Help_Panel",function(bool) {
				menu_showhelp = bool;
			});
			break;
		
		case "mail_detail": 
			register("Loaded",function() {
				createQuickInfoMenu();
				addOnClose($('menu_mail_move_foldertree'),function () { $('menu_mail_move_foldertree').style.display="none"; });
				menumaildetailloaded();
				menugloballoaded();
			});
			menuregisterMailContents();
			register("OX_Selected_Draft",onmenuchangeHeightorSelectedMail);
			register("SubSelected",changeAttachments);
			register("OX_Switched",function() { changeAttachments(menucountsubselected)});
			register("OX_menu_Change_Height",function() {changeAttachments(menucountsubselected)});
			register("OX_Show_Help_Panel",function(bool) {
				menu_showhelp = bool;
			});
			register("OX_Switched",onmenuchangeHeightorSelectedTags);
			register("OX_Switched",onmenuchangeModulePicture);
			register("OX_SELECTED_ITEMS_CHANGED",onmenuchangeHeightorSelectedTags);	
			register("OX_menu_Change_Height",onmenuchangeHeightorSelectedTags);
			
			break;
		
		case "calendar_new": 
			register("Loaded", function() {
				calendarnewonload();
				createQuickInfoMenu();
			});
			
			register("OX_menu_Change_Height",calendarnewattachmentchangeHeight);
			register("OX_Switched",calendarnewattachmentchangeHeight);
			register("OX_SELECTED_SUBSELECTION_CHANGED",calendarnewattachmentchangeHeight);
			register("OX_menu_Change_Height",calendarnewparticipantchangeHeight);	 
			register("OX_SELECTED_SUBSELECTION_CHANGED",calendarnewparticipantchangeHeight);
			register("OX_Switched",calendarnewparticipantchangeHeight);
			register("OX_Show_Help_Panel",function(bool) {
				menu_showhelp=bool;
			});
			
			break;
		
		case "contact_new":  
			register("Loaded", function() {
				createQuickInfoMenu();
			});
			menuregisterContactNewContents();
			register("OX_menu_Change_Height",calendarnewattachmentchangeHeight);
			register("SubSelected",calendarnewattachmentchangeHeight);
			register("OX_Switched",calendarnewattachmentchangeHeight);
			register("OX_menu_Change_Height",contactnewchangeHeight);
			register("SubSelected",contactnewchangeHeight);
			register("OX_Switched",contactnewchangeHeight);
			register("OX_Show_Help_Panel",function(bool) {
				menu_showhelp=bool;
			});
			break;
		
		case "infostore_new": 
			register("Loaded", function() {
				createQuickInfoMenu();
			});
			register("OX_Show_Help_Panel",function(bool) {
				menu_showhelp=bool;
			});
			break;
		
		case "task_new": 
			register("Loaded", function() {
				createQuickInfoMenu();
				tasknewonload();
			});
			register("OX_menu_Change_Height",tasknewparticipantchangeHeight);	 
			register("SubSelected",tasknewparticipantchangeHeight);
			register("OX_Switched",tasknewparticipantchangeHeight);
			register("OX_menu_Change_Height",calendarnewattachmentchangeHeight);
			register("OX_Switched",calendarnewattachmentchangeHeight);
			register("SubSelected",calendarnewattachmentchangeHeight);
			register("OX_Show_Help_Panel",function(bool) {
				menu_showhelp=bool;
			});
			break;	
	}
}

register("OX_Change_InfoStore_Detail_View",function(tab) {
 //triggerEvent("OX_Switched",tab);
});

/****************************************************************************************************/
/*** Debug Function ********************************************************************************/
/****************************************************************************************************/
function menudebugloaded()
{
	fillComboBoxDebug();
}
var combo1;
function fillComboBoxDebug()
{
	/* Language */
	//var myelement=document.getElementById("menu_global_debug_language");
	//combo1=new ComboBox("menu_global_debug_language_combobox","100%","OX_Change_Language");	
	combo1 = new ComboBox3(window, "menu_global_debug_language", "100px", 0, true, "OX_Change_Language", null);
	combo1.addElement("English","EN");
	combo1.addElement("German","DE");
	combo1.getDomNode();
	//myelement.appendChild(combo1.getDomNode());
}
menuregisterDebugContents();
function menuregisterDebugContents()
{
	register("OX_Change_Language",
	function(langu)
	{
		setLanguage(langu);
		reloadDynamicContent();
	});
	register("OX_Execute_Function",
	function() {
		var test=document.getElementById("menu_global_debugfield").value;
		eval(test);
	});
}


/****************************************************************************************************/
/*** Global Function ********************************************************************************/
/****************************************************************************************************/
function menu_display_views(module,modulecontent,checkenabled,enabled, id) {
	if (oldGecko) {
		var tmp= $(id +"_active") || $(id +"_notactive") || $(id +"_disabled") || false;
		if(!tmp) { return; }
	 	if(tmp.parentNode.parentNode.parentNode.style.width) {
			tmp.parentNode.parentNode.parentNode.style.width="";
		}
	}
	if (menuglobalzaehler < menuiteration) {
		if(checkenabled) {
			if($(id+ "_active")) {
				if(enabled) {
					 if($(id + "_active").style.display != "") { $(id + "_active").style.display= ""; } 
				} else {
					 if($(id + "_active").style.display != "none") { $(id + "_active").style.display= "none"; } 
				}
			}
			if($(id+ "_notactive")) {
				if(enabled) {
					 if($(id + "_notactive").style.display != "none") { $(id + "_notactive").style.display= "none"; } 
				} else {
					 if($(id + "_notactive").style.display != "") { $(id + "_notactive").style.display= ""; } 
				}
			}
			if($(id+ "_disable")) {
				if($(id + "_disable").style.display != "none") { $(id + "_disable").style.display= "none"; } 
			}	
		} 
		else {
			if($(id+ "_disable")) {
				if($(id + "_disable").style.display != "") { $(id + "_disable").style.display= ""; } 
			}
			if($(id+ "_active")) {
				if($(id + "_active").style.display != "none") { $(id + "_active").style.display= "none"; } 
			}
			if($(id+ "_notactive")) {
				if($(id + "_notactive").style.display != "none") { $(id + "_notactive").style.display= "none"; } 
			}
		}
		menuglobalzaehler++;
	} 
	else {
		if($(id+ "_active")) {
			if($(id + "_active").style.display != "none") { $(id + "_active").style.display= "none"; } 
			if(checkenabled && enabled) {
				menuarrows[module][modulecontent].push(id +"_active");		
			}
		}
		if($(id+ "_notactive")) {
			if($(id + "_notactive").style.display != "none") { $(id + "_notactive").style.display= "none"; } 
			if(checkenabled && !enabled) {
				menuarrows[module][modulecontent].push(id +"_notactive");		
			}
		}
		if($(id+ "_disable")) {
			if($(id + "_disable").style.display != "none") { $(id + "_disable").style.display= "none"; } 
			if(!checkenabled) {
			//	menuarrows[module][modulecontent].push(id +"_disable");		
			}
		}
	}
	if (oldGecko) {
		setTimeout(function() {
			if(tmp.parentNode.parentNode.offsetWidth!=tmp.parentNode.parentNode.parentNode.clientWidth) {
				tmp.parentNode.parentNode.parentNode.style.width=tmp.parentNode.parentNode.offsetWidth+"px";
			}
		},0);
	}
}
function menu_display_contents(module,modulecontent,enabled, id) {
	if (oldGecko) {
		$(id).parentNode.parentNode.parentNode.style.width = "";
	}
	try {		
		if (menuglobalzaehler < menuiteration) {
			if (document.getElementById(id)) {
				if (enabled) {
					if ($(id).style.display != "") { 
						$(id).style.display= ""; 
					} 
					menuglobalzaehler++;
				} else {
					if($(id).style.display != "none") { 
						$(id).style.display= "none"; 
					} 
				}
			}
			if (document.getElementById(id + "_na")) {
				if (enabled) {
					if($(id + "_na").style.display != "none") { 
						$(id + "_na").style.display= "none"; 
					} 
				} else {
					if($(id + "_na").style.display != "") { 
						$(id + "_na").style.display= ""; 
					} 
					menuglobalzaehler++;	
				}
			}
		} else {
			if ($(id + "_na")) {
				if($(id + "_na").style.display != "none") { 
					$(id + "_na").style.display = "none"; 
				} 
			}
			if ($(id)) {
				if($(id).style.display != "none") { 
					$(id).style.display= "none"; 
				} 
			}
			if (enabled) {
				if ($(id)) {
					menuarrows[module][modulecontent].push(id);
				}
			}	
		}
		$(id).parentNode.parentNode.parentNode.style.width="";
		
	} catch (e) { }
	
	if (oldGecko) {
		setTimeout(function() {
			$(id).parentNode.parentNode.parentNode.style.width = $(id).parentNode.parentNode.offsetWidth + "px";
		},0);
	}
}
var oFolderTreeMenu2;
var aFolderTreeArray = new Object();
function createMenuPopUpTree(elementid,moduletype,executeFunction) {
	if ($ALL(elementid+"_content") ) { 
		removeChildNodes($ALL(elementid+"_content")) 
	}
	if (moduletype == "folder") {
		aFolderTreeArray[elementid] = null;
		oFolderTreeMenu2 = null;
	}

	oFolderTreeMenu2 = new cFolderTree($(elementid+"_content"), executeFunction, false, oMainFolderTree.cache,
 								optFolderState.getState(elementid+"_content"));	
	aFolderTreeArray[elementid] = oFolderTreeMenu2;
	if (moduletype != "folder") {
		oFolderTreeMenu2.enabled_modules = {};
		oFolderTreeMenu2.enabled_modules[moduletype] = true;
        oFolderTreeMenu2.enable_check_fn = function(folder) {
            return (folder.oxfolder.data.own_rights & 127) >= 2;
        };								
	}
	if (moduletype == "folder") {
		var foldertoMove = null;		
		oMainFolderTree.cache.get_folder(configfolder,
			function (foldertoMove) {
				function fn_enable_move(targetFolder) {
					return moveAllowed(foldertoMove.parent,foldertoMove, targetFolder,true);
				}
				oFolderTreeMenu2.enable_check_fn = fn_enable_move;
				oFolderTreeMenu2.load();		
			});			
	} else {			
		oFolderTreeMenu2.load();
	}
	oFolderTreeMenu2.setSaveConfiguration(optFolderState);	
}
/*** Rights Function ********************************************************************************/
function menucheckRight(right)
{
	return menuhasRight(menuselectedobjects,right);	
}
function menuhasRightandLoad(selectedobjects,right,cbtrue,cbfalse) {
	function loaded(resp) {
		if(menuhasRight(selectedobjects,right,resp)) { if(cbtrue) cbtrue(); }
		else { if(cbfalse) cbfalse(); }
	}
	var checkFolders=new Array();
	for(var i in selectedobjects) {
		if(selectedobjects[i].folder) {
			checkFolders.push(selectedobjects[i].folder);
		} else {
			checkFolders.push(selectedobjects[i].folder_id);
		}
	}
	if(checkFolders.length>0) {
		oMainFolderTree.fetchAndGetFolders(checkFolders,loaded);
	} else {
		if(menuhasRight(selectedobjects,right)) {
			if(cbtrue) cbtrue();
		} else {
			if(cbfalse) cbfalse();
		}
	}
}
function menuhasRight(selectedobjects,right,resp) {
    right = { READ: 7, WRITE: 14, DELETE: 21, ADMIN: 28, USER: 29 }[right];
    if (!right) return false;
    function getFolder(folder) {
        var oFolder = oMainFolderTree.cache.fast_access[folder];
        if(oFolder != undefined && menuselectedfolders[folder]) {
            oFolder = menuselectedfolders[folder];
        } else if(oFolder != undefined && resp && resp[folder]) {
            oFolder = resp[folder];
        }
        return oFolder && oFolder.oxfolder.data;
    }
    var me = configGetKey("identifier");
    var rights = {};
    for (var i in selectedobjects) {
        var o = selectedobjects[i];
        var fid = o.folder || o.folder_id;
        if (!rights[fid]) {
            var folder = getFolder(fid);
            if (!folder) return false;
            switch (rights[fid] = computePerm(folder.own_rights, right)) {
                case 0:
                    return false;
                case 1:
                    if (right >= 28) rights[fid] = 2;
            }
        }
        if (rights[fid] == 1 && o.created_by != me) return false;
    }
 	return true;	
}

/*** Enhancement Menu Functions *********************************************************************/
function createEnhancementMenu(enhancementid,idofelement,module)
{
	createArrowinMenu(enhancementid,idofelement,module);
	createEvents(enhancementid,idofelement,module);
}
function createArrowinMenu(enhancementid,idofelement,module)
{
    var mytr = newnode("tr", 0, { id: enhancementid + "_arrow" }, [
        newnode("td", {
            textAlign: "center", verticalAlign: "middle",
            height: arrowheight + "em", lineHeight: arrowheight +"em",
            margin: 0, fontSize: "1px"
        }, { className: "arrowheight" }, [
            newnode("img", { height: "4px", width: "8px" },
                { src: getFullImgSrc("img/arrows/arrow-down.gif") })
        ])
    ]);
    var mytable = newnode("table", { textAlign: "center" }, {
        id: enhancementid + "_enhancementtable", cellPadding: 0, cellSpacing: 0,
        border: 0, className: "width100 arrowheight"
    }, [newnode("tbody", 0, 0, [mytr])]);
    addTMPId(mytable);
    addTMPId(mytr);
    var trigger = $(enhancementid);
    if(idofelement=="menu_mail" || idofelement == "menu_contact" || idofelement == "menu_infostore") {
        trigger.appendChild(newnode("div", { position: "absolute" },
            { id: enhancementid + "_div" }, [mytable]));
        trigger = mytable;
    } else {
        trigger.appendChild(mytable);		
    }
    var menu = new PulldownMenu(trigger);
    menu.onShow = function() {
        createPopUpMenuEnhancement(enhancementid, idofelement, module, this);
    };
}

function createEvents(enhancementid,idofelement,module)
{
	var all=false;
	if(module=="global")
	{
		all=true;
	}
	register("OX_menu_Change_Height",function ()
	{
		if(menuisActive(idofelement))
			showArrowPopUpMenu(enhancementid,idofelement,module);
	});
	register("OX_SELECTION_CHANGED",function ()
	{
		if(menuisActive(idofelement))
			showArrowPopUpMenu(enhancementid,idofelement,module);
	});
	register("OX_Switched",function ()
	{
		if(menuisActive(idofelement))
			showArrowPopUpMenu(enhancementid,idofelement,module);
		
	});	
	register("SubSelected",function ()
	{
		if(menuisActive(idofelement))
			showArrowPopUpMenu(enhancementid,idofelement,module);
	});
	register("OX_Lockable",function () {
		if(menuisActive(idofelement))
			showArrowPopUpMenu(enhancementid,idofelement,module);
	});
}

function showArrowPopUpMenu(enhancementid, idofelement, module) {
	if (menuarrows[module] && menuarrows[module][idofelement] && menuarrows[module][idofelement].length > 0) {		
		if ($ALL(enhancementid + "_div")) {
			var enhwidth = 0;
			if (enhancementid.match(/^menu_mail/)) {
				enhwidth = $("menu_mail").offsetWidth+$("menu_mail2").offsetWidth;
			} else if (enhancementid.match(/^menu_infostore/)) {
				enhwidth = $("menu_infostore").offsetWidth+$("menu_infostore2").offsetWidth;
			} else {
				enhwidth = $("menu_contact").offsetWidth+$("menu_contact2").offsetWidth;
			}
			$ALL(enhancementid+"_div").style.width = enhwidth + "px";
		} 
		$ALL(enhancementid+"_arrow").style.display = "";
	} else if ($ALL(enhancementid+"_arrow")) {
		$ALL(enhancementid+"_arrow").style.display = "none";		
	}
}

function createPopUpMenuEnhancement(enhancementid, idofelement, module, menu) {
	menu.removeAllItems();
	if(menuarrows[module])
	{
		if(menuarrows[module][idofelement])
		{
			if(menuarrows[module][idofelement].length>0)
			{
				for(var zaehler=0; zaehler < menuarrows[module][idofelement].length;zaehler++) {
					var onetr=$ALL(menuarrows[module][idofelement][zaehler]);
					var textvalue;
					var imagevalue;
					var eventvalue=function() {};
					var noimage=false;
					
					var tmp=onetr.getElementsByTagName("div");
					if(tmp.length>1) {	textvalue=tmp[1].firstChild.nodeValue; noimage=false; } 
					else if (tmp.length>0) { textvalue=tmp[0].firstChild.nodeValue; }
					
					tmp=onetr.getElementsByTagName("img");
					if(tmp.length>0) { imagevalue=tmp[0].getAttribute("src"); }
					
					if(onetr.getAttribute("onclick")) { eventvalue=onetr.getAttribute("onclick"); }
					
					var lasttext=onetr.id.split("_")[onetr.id.split("_").length-1];
					
                    var item;
                    if (onetr.oxSubmenu) {
                        var submenu = new PopupMenu();
                        onetr.oxSubmenu(submenu);
                        item = new MenuItem(textvalue || "", submenu);
                    } else {
                        item = new MenuItem(textvalue || "",
                            (function(tmpevent) {
                                return function() {
                                    if (   tmpevent
                                        && tmpevent.constructor == Function)
                                    {
                                        tmpevent();
                                    } else {
                                        eval(tmpevent);
                                    } 
                                }
                            })(eventvalue));
                    }
                    if (imagevalue) {
                        item.setIcon(imagevalue.replace(/^.*?themes\/\w+\//, ""));
                    }
                    menu.addItem(item);
				}
			}
		}
	}
}

/****************************************************************************************************/
/*** Portal Function ********************************************************************************/
/****************************************************************************************************/
var menu_showmail=false;
var menu_showhelp=false;
var menu_showmini=false;
var menu_showsidepanel=true;
menuarrows["portal"]=new Array();
function menuportalloaded() {
	createEnhancementMenu("menu_portal_enhancement","menu_portal_quick_settings","portal");
	
}
function menuregisterPortalContents()
{
	register("OX_menu_Change_Height",onmenuchangeHeightPortal);
	register("OX_Switched",onmenuchangeHeightPortal);
	register("OX_Switched",onmenuchangeContentsPortal);
	
	register("OX_Show_Mail_Panel",function(bool) {
		if($("menu_portal_mail_checkbox")) {
			$("menu_portal_mail_checkbox").checked = $("menu_portal_mail_checkbox").defaultChecked = bool;
		}
		//configSetKey("gui.portal.infobox",bool);
		menu_showmail=bool;
	});
	register("OX_Show_Help_Panel",function(bool) {
		if($("menu_portal_help_checkbox1")) {
			$("menu_portal_help_checkbox1").checked = $("menu_portal_help_checkbox1").defaultChecked = bool;
		}
		//configSetKey("gui.portal.tooltip",bool);
		menu_showhelp=bool;
	});
	register("OX_Show_MiniCalendar",function(bool) {
		if($("menu_portal_minicalendar_checkbox")) {
			$("menu_portal_minicalendar_checkbox").checked = $("menu_portal_minicalendar_checkbox").defaultChecked = bool;
		}
		//configSetKey("gui.portal.infobox",bool);
		menu_showmini=bool;
	});
	
}
function onmenuchangeHeightPortal() {
	if (menuisActive("menu_portal_quick_settings"))	
		onmenuchangeHeightPortalMainContent(menuiteration,menucountselected);

}
function onmenuchangeHeightPortalMainContent(iteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["portal"]["menu_portal_quick_settings"]=new Array();	
	menu_display_contents("portal","menu_portal_quick_settings", true, "menu_portal_quick_settings_mailpanel");
	menu_display_contents("portal","menu_portal_quick_settings", true, "menu_portal_quick_settings_helppanel");
	menu_display_contents("portal","menu_portal_quick_settings", true, "menu_portal_quick_settings_minicalendar");
}
function onmenuchangeContentsPortal() {
	if (menuisActive("menu_picture"))
		onmenuchangeModulePicture();
}

function onmenuchangeModulePicture() {
	var oldnode, newnode, prioold;
	for (zaehler in modules) {
		if (configGetKey("modules."+ modules[zaehler]["name"] + ".module") && 
				$("menu_big_"+modules[zaehler]["name"]) && 
				$("menu_big_"+modules[zaehler]["name"]).offsetWidth != 0) {
			if (oldnode) { 
				oldnode.style.width="0px"; 
			}
			oldnode = $("menu_big_"+modules[zaehler]["name"]);
			prioold = modules[zaehler]["priority"];
		}
	}
	for (zaehler in modules) {		
		if (modules[zaehler]["name"] == "configuration") continue; //Break not a valid module
		if (modules[zaehler]["name"] == activemodule) {
			if ((configGetKey("modules."+[modules[zaehler]["name"]]+".module") && activemodule != "portal") || 
					((activemodule == "portal" && configGetKey("modules.mail.module")))) {
				if($("menu_big_"+modules[zaehler]["name"])) {
					newnode = $("menu_big_"+modules[zaehler]["name"]);
					((modules[zaehler]["priority"]) < prioold) ? prioold = -1: prioold = 1; 	
				}
			}
		}
	}
	if (!newnode) {
		for (zaehler in modules) {
			if (configGetKey("modules."+ modules[zaehler]["name"] + ".module") && 
					$("menu_big_"+modules[zaehler]["name"])) {
				newnode = $("menu_big_"+modules[zaehler]["name"]);
				break;
			}
		}
	}
	startrotate(oldnode, newnode, prioold);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////
/****************************************************************************************************/
/*** Mail Function **********************************************************************************/
/****************************************************************************************************/
//////////////////////////////////////////////////////////////////////////////////////////////////////
menuarrows["mail"]=new Array();
var menumailfoldertreecopy=false;
function menumaildetailloaded() {	
	createEnhancementMenu("menu_mail_enhancement","menu_mail","mail");
	if ($("menu_dyn_cancel") && $("menu_dyn_close")) {
        $("menu_dyn_cancel").style.display="none";
        $("menu_dyn_close").style.display="";
    }
}

function menumailloaded()
{
	menumaildetailloaded();
	addOnClose($('menu_mail_move_foldertree'),function () { $('menu_mail_move_foldertree').style.display="none"; });
	createEnhancementMenu("menu_mail_view_enhancement","menu_mail_view","mail");
	
	// create "Mark as" submenu
	var markas_submenu = new PopupMenu();
	var entries = {
	        seen: "Read", /*i18n*/ unseen: "Unread", /*i18n*/
	        answer: "Answered", /*i18n*/ answered: "Unanswered", /*i18n*/
	        "delete": "Deleted", /*i18n*/ undelete: "Undeleted" /*i18n*/
	};
	(function fillItems(menu) {
        var items = {};
        for (var i in entries) {
            var item = items[i] = new MenuItem(entries[i], (function(flag) {
                return function() { triggerEvent("OX_Mail_Flag", flag); };
            })(i));
            menu.addItem(item);
        }
        menu.onShow = function() {
            var r = menucheckRight("READ");
            items.seen.setVisible(r);
            items.unseen.setVisible(r);
            var d = menucheckRight("DELETE");
            items["delete"].setVisible(d);
            items.undelete.setVisible(d);
            var w = menucheckRight("WRITE");
            items.answer.setVisible(w);
            items.answered.setVisible(w);
        };
    })(markas_submenu);
	
	var menu = globalContextMenus.mail = new ContextMenu();
    function one() { this.setEnabled(this.getContext().count == 1); }
    function many() { this.setEnabled(this.getContext().count > 0); }
    var items = [
    {
        text: "Reply"/*i18n*/, icon: "img/mail/reply",
        event: "OX_Mail_Reply", show: one
    }, {
        text: "Reply all"/*i18n*/, icon: "img/mail/reply_all",
        event: "OX_Mail_ReplyAll", show: one
    }, {
        text: "Forward"/*i18n*/, icon: "img/mail/forward",
        event: "OX_Mail_Forward", show: many
    }, {
        text: "Delete"/*i18n*/, icon: "img/menu/delete",
        event: "OX_Mail_Delete", show: many
    }, {
        text: "Print"/*i18n*/, icon: "img/menu/print",
        event: "OX_Print", show: many
    }, {
        //-----------------------
    }, {
        text: "Mark as"/*i18n*/, icon: "img/mail/mark_as",
        items: markas_submenu, show: many
    }, {
        //-----------------------
    }, {
        text: "Save"/*i18n*/, icon: "img/menu/save_as_link",
        event: "OX_Mail_SaveMail", show: one
    }, {
        text: "Copy"/*i18n*/, icon: "img/menu/copy_mail",
        event: "OX_Mail_Copy", show: one
    }, {
        text: "Move"/*i18n*/, icon: "img/menu/mail_move",
        event: "OX_Mail_Move", show: one
    }, {
        //-----------------------
    }, {
        text: "Edit draft"/*i18n*/, icon: "img/menu/edit_draft",
        icon_d: "img/dummy.gif", event: "OX_Mail_Edit_Draft",
        show: function() {
            this.setVisible(menuisdraftfolder);
            this.setEnabled(this.getContext().count == 1);
        }
    }, {
        text: "Show source"/*i18n*/, icon: "img/menu/view_emailsource",
        event: "OX_Mail_Show_Source", show: one
    }, {
        text: "Spam"/*i18n*/, icon: "img/mail/spam",
        event: "OX_Mail_Spam", show: function() { 
            this.setVisible(   this.getContext().count > 0
                            && configGetKey("mail.spambutton")
                            && checkSpamFolder("SPAM")
                            && getMailAccountIdByFolder(this.getContext().getSelected()[0].folder_id) == 0);
        }
    }, {
        text: "No Spam"/*i18n*/, icon: "img/menu/ham",
        icon_d: "img/menu/ham.gif", event: "OX_Mail_Ham",
        show: function() {
            this.setVisible(   menucountselected > 0
                            && configGetKey("mail.spambutton")
                            && checkSpamFolder("HAM")
                            && getMailAccountIdByFolder(this.getContext().getSelected()[0].folder_id) == 0);
        }
    }];
    for (var i in items) {
        (function(def) {
            if (def.text) {
                var item = new MenuItem(def.text,
                        def.event ? function() { triggerEvent(def.event); } :
                            def.items
                );
                item.setIcon(def.icon + ".gif", def.icon_d || def.icon + "_d.gif");
                item.onShow = def.show;
            } else {
                var item = new MenuSeparator();
            }
            menu.addItem(item);
        })(items[i]);
    }
}
function menuregisterMailContents()
{
	register("OX_Mail_Move",menumailmoveclicked);
	register("OX_Mail_Copy",menumailcopyclicked);
	register("OX_SELECTED_ITEMS_CHANGED",onmenuchangeHeightorSelectedMail);
	register("OX_menu_Change_Height",onmenuchangeHeightorSelectedMail);
	register("OX_Switched",onmenuchangeHeightorSelectedMail);
}	
function menumailmoveclicked()
{
	menumailfoldertreecopy=false;
	createMenuPopUpTree("menu_mail_move_foldertree","mail",doMailsFolder);	
	document.getElementById("menu_mail_move_foldertree").style.display="";
} 
function menumailcopyclicked()
{
	menumailfoldertreecopy=true;
	createMenuPopUpTree("menu_mail_move_foldertree","mail",doMailsFolder);	
   	document.getElementById("menu_mail_move_foldertree").style.display="";
} 
function doMailsFolder(ofolder)
{
	var selectedfolderid= ofolder.oxfolder.data.id;
	if(menumailfoldertreecopy) {
		triggerEvent("OX_Object_Copy",selectedfolderid);
	} else {
		triggerEvent("OX_Object_Move",selectedfolderid);
	}
	document.getElementById("menu_mail_move_foldertree").style.display="none";
}

function onmenuchangeHeightorSelectedMail()
{
	if(menuisActive("menu_mail_structure")) 	
		onmenuchangeMailStructure(menuiteration,currentpath2[2],menucountselected);
	if(menuisActive("menu_mail_view")) 	
		onmenuchangeMailView(menuiteration,currentpath2[1],menucountselected);
	if(menuisActive("menu_mail"))	
		onmenuchangeHeightMailMainContent(menuiteration,menucountselected);
}
function onmenuchangeMailStructure(iteration,item,selecteditems)
{
	if(item == "threaded")
	{
		$("menu_mail_structure_threaded_active").style.display="";
		$("menu_mail_structure_threaded_notactive").style.display="none";
		$("menu_mail_structure_unthreaded_active").style.display="none";
		$("menu_mail_structure_unthreaded_notactive").style.display="";
	}
	else if(item == "unthreaded")
	{
		$("menu_mail_structure_threaded_active").style.display="none";
		$("menu_mail_structure_threaded_notactive").style.display="";
		$("menu_mail_structure_unthreaded_active").style.display="";
		$("menu_mail_structure_unthreaded_notactive").style.display="none";
	}
}
function onmenuchangeMailView(iteration,value,selecteditems)
{
	menuglobalzaehler=0;
    menuarrows["mail"]["menu_mail_view"]=new Array();	
	menu_display_views("mail","menu_mail_view",true,value == "hsplit", "menu_mail_views_split");
	menu_display_views("mail","menu_mail_view",true,value == "vsplit", "menu_mail_views_split2");
	menu_display_views("mail","menu_mail_view",true,value == "list", "menu_mail_views_list");
	menu_display_views("mail","menu_mail_view",selecteditems==1,value == "detail", "menu_mail_views_detail");
}
function checkSpamFolder(type) {
	for(var i in menuselectedobjects) {
		var folder = menuselectedobjects[i].folder;
		if(!folder) folder= menuselectedobjects[i].folder_id;
		switch(type) {
			case "SPAM":
				if(folder == configGetKey("mail.folder.spam")) {
					return false;
				}			
				break;
			case "HAM":
				if(folder != configGetKey("mail.folder.spam")) {
					return false;
				}
				break;
			default:
				return false;
		}
	}
	return true;
}

function isNestedMailMessage() {	
	if (activemodule == "mail_detail" && menuselectedobjects && menuselectedobjects.length) {		
		return menuselectedobjects[0].type != undefined && menuselectedobjects[0].type == "isNestedMessage";		
	}
	return false;
}

function onmenuchangeHeightMailMainContent(iteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["mail"]["menu_mail"]=new Array();
	menu_display_contents("mail","menu_mail",selecteditems == 1 && menuisdraftfolder, "menu_mail_draft_edit");
	menu_display_contents("mail","menu_mail",selecteditems == 1, "menu_mail_reply");
	menu_display_contents("mail","menu_mail",selecteditems == 1, "menu_mail_reply_all");
	menu_display_contents("mail","menu_mail",selecteditems > 0, "menu_mail_forward");
    menu_display_contents("mail","menu_mail",selecteditems > 0 && activemodule != "mail_detail" , "menu_mail_copy");
    menu_display_contents("mail","menu_mail",selecteditems == 1, "menu_mail_savemail");
	menu_display_contents("mail","menu_mail",selecteditems == 1 && !isNestedMailMessage(), "menu_mail_showsource");
	menuglobalzaehler=0;
	menu_display_contents("mail","menu_mail",selecteditems > 0 && !isNestedMailMessage(), "menu_mail_delete");
	menu_display_contents("mail","menu_mail",isPrintableView(currentpath2.join('/')),"menu_mail_print");
    menu_display_contents("mail","menu_mail",selecteditems > 0 && configGetKey("mail.spambutton") && checkSpamFolder("SPAM") && !isNestedMailMessage() && getMailAccountIdByFolder(activefolder) == 0,  "menu_mail_spam");
    menu_display_contents("mail","menu_mail",selecteditems > 0 && configGetKey("mail.spambutton") && checkSpamFolder("HAM") && !isNestedMailMessage() && getMailAccountIdByFolder(activefolder) == 0,  "menu_mail_ham");	
    menu_display_contents("mail","menu_mail",selecteditems > 0 && !isNestedMailMessage(),  "menu_mail_mark");	
	menu_display_contents("mail","menu_mail",selecteditems > 0 && activemodule != "mail_detail" , "menu_mail_move");	
}

/****************************************************************************************************/
/*** Calendar Function ******************************************************************************/
/****************************************************************************************************/
function multipleconfirmcalendar(objects) {
	var myobjects=new Array();
	for (var i in objects) {
		myobjects.push(new AcceptDenyObject("calendar",objects[i]));
	}
	if(myobjects.length) {
		var myad=new AcceptDeny(false);
		myad.changeConfirm(myobjects);
	}
}
register("OX_Calendar_Change_Confirm",multipleconfirmcalendar);
menuarrows["calendar"]=new Array();
function menucalendarloaded()
{	
	addOnClose($('menu_calendar_move_foldertree'),function () { $('menu_calendar_move_foldertree').style.display="none"; });

    var menu = globalContextMenus.calendar = new ContextMenu();
    var contextData = [];
    var count = Value(), writable = Value(), deletable = Value();
    var confirmable = Value(), acceptDenyVisible = Value();

    var edit = new MenuItem("Edit", /*i18n*/
        function() { triggerEvent('OX_Calendar_Edit'); });
    edit.setIcon("img/menu/edit.gif", "img/menu/edit_d.gif");
    edit.setEnabledF(function() { return count() == 1 && writable(); });
    menu.addItem(edit);

    var del = new MenuItem("Delete", /*i18n*/
        function() { triggerEvent('OX_Calendar_Delete'); });
    del.setIcon("img/menu/delete.gif", "img/menu/delete_d.gif");
    del.setEnabledF(function() { return count() > 0 && deletable(); });
    menu.addItem(del);
    
    menu.addItem(new MenuSeparator());

    var confirm = new MenuItem("Change confirmation"/*i18n*/, function() {
        var objects = new Array(contextData.length);
        for (var i = 0; i < objects.length; i++) {
            objects[i] = new AcceptDenyObject("calendar", contextData[i]);
        }
        (new AcceptDeny(true)).showConfirmation(objects);
    });
    confirm.setIcon("img/menu/global_confirmation_change.gif",
                    "img/menu/global_conf_change_d.gif");
    confirm.setEnabledF(function() {
        return count() > 0 && !acceptDenyVisible() && confirmable();
    });
    menu.addItem(confirm);

    menu.onShow = function() {
        acceptDenyVisible.set(AcceptDeny.visible);
        var objects = clone(this.getContext().getSelected());
        count.set(objects.length);
        if (!objects.length) return;
        for (var i = 0; i < objects.length; i++) {
            objects[i].module = "calendar";
            objects[i].folder_id = objects[i].folder;
            delete objects[i].folder;
        }
        writable.clear();
        deletable.clear();
        confirmable.clear();
        var collection = { columns: ["created_by", "users", "title", "location",
                                     "start_date", "end_date"],
                           objects: objects };
        OXCache.newRequest(null, "calendar", collection, null, responseData);
        function responseData(data) {
            contextData = data.objects;
            writable.set(menuhasRight(contextData, "WRITE"));
            deletable.set(menuhasRight(contextData, "DELETE"));
            if (!writable.value) {
                confirmable.set(false);
            }
        	var folder = oMainFolderTree.cache.fast_access[activefolder];
        	var me = folder.oxfolder.data.type == 3 ? folder.oxfolder.data.created_by : configGetKey("identifier");
            for(var i in contextData) {
                var users = contextData[i].users;
                CheckUsers: {
                    for(var j = 0; j < users.length; j++) {
                        if (users[j].id == me) {
                        	confirmable.set(true);
                        	break CheckUsers;
                        }
                    }
                    confirmable.set(false);
                    return;
                }
            }            
        }
    };
    
    // Team view context menu
    var menu = globalContextMenus.teamview = new ContextMenu();
    var edit = new MenuItem("Edit", /*i18n*/
        function() { triggerEvent('OX_Calendar_Edit'); });
    edit.setIcon("img/menu/edit.gif", "img/menu/edit_d.gif");
    edit.setEnabledF(function() { return count() == 1; });
    menu.addItem(edit);

    var del = new MenuItem("Delete", /*i18n*/
        function() { triggerEvent('OX_Calendar_Delete'); });
    del.setIcon("img/menu/delete.gif", "img/menu/delete_d.gif");
    del.setEnabledF(function() { return count() > 0; });
    menu.addItem(del);
    
    menu.onShow = function() {
        // get number of selected appointments
        var c = this.getContext().numSelected();
        count.set(c);
    };
	
	createEnhancementMenu("menu_calendar_enhancement","menu_calendar","calendar");
	createEnhancementMenu("menu_calendar_timerange_enhancement","menu_calendar_timerange","calendar");
	createEnhancementMenu("menu_calendar_views_enhancement","menu_calendar_views","calendar");
	createEnhancementMenu("menu_calendar_teammember_enhancement","menu_calendar_teammember","calendar");
}

function menuregisterCalendarContents()
{
	register("OX_Calendar_Move",menucalendarmoveclicked);
	register("OX_Switched",onmenuchangeHeightorSelectedCalendar);
	register("OX_menu_Change_Height",onmenuchangeHeightorSelectedCalendar);
	register("OX_SELECTED_ITEMS_CHANGED",onmenuchangeHeightorSelectedCalendar);
	register("OX_SELECTED_SUBSELECTION_CHANGED",onmenuchangeSubSelectedCalendar);
}
function menucalendarmoveclicked()
{
	createMenuPopUpTree("menu_calendar_move_foldertree","calendar",moveCalendarFolder);
	document.getElementById("menu_calendar_move_foldertree").style.display="";
} 
function moveCalendarFolder(ofolder)
{
	var selectedfolderid= ofolder.oxfolder.data.id;
	triggerEvent("OX_Object_Move",selectedfolderid);
	document.getElementById("menu_calendar_move_foldertree").style.display="none";
}
function onmenuchangeHeightorSelectedCalendar()
{
	if(menuisActive("menu_calendar")) 
		onmenuchangeHeightCalendarMainContent(menuiteration,menucountselected);
	if(menuisActive("menu_calendar_views"))		
		onmenuchangeHeightCalendarViewContent(menuiteration,currentpath2[1],menucountselected);
	if(menuisActive("menu_calendar_timerange"))		
		onmenuchangeHeightCalendarTimerangeContent(menuiteration,currentpath2[2],menucountselected);
	if(menuisActive("menu_calendar_teammember"))
		onmenuchangeHeightCalendarTeamContent(menuiteration,menucountsubselected);
}
function onmenuchangeSubSelectedCalendar(selected)
{
	if(activemodule=="calendar")
	{
		onmenuchangeHeightCalendarTeamContent(menuiteration,selected);
	}
}

function onmenuchangeHeightCalendarTimerangeContent(iteration,value,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["calendar"]["menu_calendar_timerange"]=new Array();
	menu_display_views("calendar","menu_calendar_timerange",true,value == "day", "menu_calendar_timerange_day");
	menu_display_views("calendar","menu_calendar_timerange",true,value == "workweek", "menu_calendar_timerange_workweek");
	menu_display_views("calendar","menu_calendar_timerange",true,value == "month", "menu_calendar_timerange_month");
	menu_display_views("calendar","menu_calendar_timerange",true,value == "week", "menu_calendar_timerange_week");
	menu_display_views("calendar","menu_calendar_timerange",currentpath2[1] != "list" ,value == "custom", "menu_calendar_timerange_custom");
}
function onmenuchangeHeightCalendarViewContent(iteration,value,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["calendar"]["menu_calendar_views"]=new Array();	
    menu_display_views("calendar","menu_calendar_views",true,value == "calendar", "menu_calendar_views_calendar");
    menu_display_views("calendar","menu_calendar_views",configGetKey("modules.calendar.calendar_freebusy") && configGetKey("modules.calendar.calendar_teamview"),value == "team", "menu_calendar_views_team");	
	menu_display_views("calendar","menu_calendar_views",true,value == "list", "menu_calendar_views_list");
	menu_display_views("calendar","menu_calendar_views",selecteditems==1,value == "detail", "menu_calendar_views_detail");
}
function onmenuchangeHeightCalendarMainContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["calendar"]["menu_calendar"]=new Array();
	menu_display_contents("calendar","menu_calendar",selecteditems == 1 && menucheckRight("WRITE"), "menu_calendar_edit");
	menu_display_contents("calendar","menu_calendar",selecteditems > 0 && menucheckRight("DELETE"), "menu_calendar_delete");
	menu_display_contents("calendar","menu_calendar",isPrintableView(currentpath2.join('/')), "menu_calendar_print");
	menu_display_contents("calendar","menu_calendar",selecteditems > 0 && menucheckRight("DELETE"), "menu_calendar_move");		
}
function onmenuchangeHeightCalendarTeamContent(menuiteration,selected) {
	menuglobalzaehler=0;
	menuarrows["calendar"]["menu_calendar_teammember"]=new Array();
	menu_display_contents("calendar","menu_calendar_teammember",true, "menu_calendar_teammember_add");
	menu_display_contents("calendar","menu_calendar_teammember",selected>0, "menu_calendar_teammember_remove");
	menu_display_contents("calendar","menu_calendar_teammember",configContainsKey("gui.calendar.teams") && configGetKey("gui.calendar.teams").length, "menu_calendar_teammember_change");
	menu_display_contents("calendar","menu_calendar_teammember",true, "menu_calendar_teammember_add_team");
}
register("OX_Calendar_Team_Add_Team",calendar_teams_add_team_clicked);
function calendar_teams_add_team_clicked() {
	triggerEvent('OX_Switch_View','configuration/calendar/teams');
}

///////////////////////////////////////////////////////////////////////////////////////////////////////
/****************************************************************************************************/
/*** Task Function ******************************************************************************/
/****************************************************************************************************/
function multipleconfirmtask(objects) {
	var myobjects=new Array();
	for (var i in objects) {
		myobjects.push(new AcceptDenyObject("tasks",objects[i]));
	}
	if(myobjects.length) {
		var myad=new AcceptDeny(false);
		myad.changeConfirm(myobjects);
	}
}
register("OX_Task_Change_Confirm",multipleconfirmtask);

var menucomboboxsearch1;
menuarrows["tasks"]=new Array();
function menutasksloaded()
{
	addOnClose($('menu_tasks_move_foldertree'),function () { $('menu_tasks_move_foldertree').style.display="none"; });
	createEnhancementMenu("menu_tasks_enhancement","menu_tasks","tasks");
}

function menuregisterTaskContents()
{
	register("OX_Task_Move",menutaskmoveclicked);
	register("OX_Switched",onmenuchangeHeightorSelectedTask);
	register("OX_SELECTED_ITEMS_CHANGED",onmenuchangeHeightorSelectedTask);
	register("OX_menu_Change_Height",onmenuchangeHeightorSelectedTask);
	register("OX_Task_Search",onmenusearchTask);
}
function onmenusearchTask() 
{
	var mysearchfield=menucomboboxsearch1.getValue();
	var mysearchparam=document.getElementById("menu_search_tasks_searchfield").value;
	triggerEvent("OX_Task_Standard_Search",activefolder,mysearchfield,mysearchparam);
}
register("OX_Task_Standard_Search",todoSearchTask);

function todoSearchTask(folder,mysearchfield,mysearchparam)
{
	alert("TODO: Hier Suche in Folder "+ folder +" im Feld "+mysearchfield+" nach "+mysearchparam);
}
function menutaskmoveclicked()
{
	createMenuPopUpTree("menu_tasks_move_foldertree","tasks",moveTasksFolder);
	document.getElementById("menu_tasks_move_foldertree").style.display="";
} 
function moveTasksFolder(ofolder)
{
	var selectedfolderid= ofolder.oxfolder.data.id;
	triggerEvent("OX_Object_Move",selectedfolderid);
	document.getElementById("menu_tasks_move_foldertree").style.display="none";
}

function onmenuchangeHeightorSelectedTask()
{
	if(menuisActive("menu_tasks_views"))		
		onmenuchangeTaskView(menuiteration,currentpath2[1],menucountselected);
	if(menuisActive("menu_tasks"))		
		onmenuchangeHeightTaskContent(menuiteration,menucountselected);	
}
function onmenuchangeTaskView(iteration,value,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["tasks"]["menu_tasks_views"]=new Array();
    menu_display_views("tasks","menu_tasks_views",true,value == "split", "menu_tasks_views_split");
	menu_display_views("tasks","menu_tasks_views",true,value == "list", "menu_tasks_views_list");
    menu_display_views("tasks","menu_tasks_views",selecteditems==1,value == "detail", "menu_tasks_views_detail");
}
function onmenuchangeHeightTaskContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["tasks"]["menu_tasks"]=new Array();
	menu_display_contents("tasks","menu_tasks",selecteditems == 1 && menucheckRight("WRITE"), "menu_tasks_edit");
	menu_display_contents("tasks","menu_tasks",selecteditems > 0 && menucheckRight("DELETE"), "menu_tasks_delete");
	menu_display_contents("tasks","menu_tasks",isPrintableView(currentpath2.join('/')), "menu_tasks_print");
	menu_display_contents("tasks","menu_tasks",selecteditems > 0 && menucheckRight("DELETE"), "menu_tasks_move");
	menu_display_contents("tasks","menu_tasks",selecteditems > 0 && menucheckRight("WRITE"), "menu_tasks_mark_as_done");
	menu_display_contents("tasks","menu_tasks",selecteditems == 1 && menucheckRight("WRITE"), "menu_tasks_duplicate");
	// update confirm button too
	onmenuchangeHeightGlobalConfirmContent(iteration, Math.min(menucountconfirm, selecteditems));
}
	//////////////////////////////////////////////////////////////////////////////////////////////////////
/****************************************************************************************************/
/*** Contact Function ******************************************************************************/
/****************************************************************************************************/
menuarrows["contacts"]=new Array();
var menucontactfoldertreecopy=false;
function menucontactloaded()
{
	createEnhancementMenu("menu_contact_enhancement","menu_contact","contacts");
	createEnhancementMenu("menu_contacts_views_enhancement","menu_contacts_views","contacts");
	
	addOnClose($('menu_contacts_move_foldertree'),function () { $('menu_contacts_move_foldertree').style.display="none"; });	
    var menu = globalContextMenus.contacts = new ContextMenu();
    var count = Value(), writable = Value(), deletable = Value();
    
    // Edit contact
    var edit = new MenuItem("Edit", /*i18n*/
        function() { triggerEvent('OX_Contact_Edit'); });
    edit.setIcon("img/menu/edit.gif", "img/menu/edit_d.gif");
    edit.setEnabledF(function() { return count() == 1 && writable(); });
    menu.addItem(edit);
    
    // Delete contact
    var del = new MenuItem("Delete", /*i18n*/
        function() { triggerEvent('OX_Contact_Delete'); });
    del.setIcon("img/menu/delete.gif", "img/menu/delete_d.gif");
    del.setEnabledF(function() { return count() > 0 && deletable(); });
    menu.addItem(del);
    
    // Use contact as template
    var template = new MenuItem("Use as template", /*i18n*/
        function() { triggerEvent('OX_Contact_Duplicate'); });
    template.setIcon("img/menu/duplicate_contacts.gif",
                     "img/menu/duplicate_contacts_d.gif");
    template.setEnabledF(function() { return count() == 1 && writable(); });
    menu.addItem(template);
    
    // Send contact as vCard
    var sendVCard = new MenuItem("Send as vCard", /*i18n*/
        function() { triggerEvent('OX_Contact_SendVCard'); });
    sendVCard.setIcon("img/mail/forward.gif", "img/mail/forward_d.gif");
    sendVCard.setEnabledF(function() { return count() > 0 });
    menu.addItem(sendVCard);

    // context menu - onShow handler
    menu.onShow = function() {
        var collection = { columns: ["created_by"],
                           objects: this.getContext().getSelected() };
        count.set(collection.objects.length);
        if (!count.value) return;
        OXCache.newRequest(null, "contacts", collection, null, responseData);
        function responseData(data) {
            writable.set(menuhasRight(data.objects, "WRITE"));
            deletable.set(menuhasRight(data.objects, "DELETE"));
        }
    };
}
function menuregisterContactContents()
{
	register("OX_Contact_Move",menucontactmoveclicked);
	register("OX_Contact_Copy",menucontactcopyclicked);
	register("OX_Switched",onmenuchangeHeightorSelectedContact);
	register("OX_SELECTED_ITEMS_CHANGED",onmenuchangeHeightorSelectedContact);
	register("OX_menu_Change_Height",onmenuchangeHeightorSelectedContact);
}
function menucontactmoveclicked()
{
	createMenuPopUpTree("menu_contacts_move_foldertree","contacts",doContactsFolder);
	document.getElementById("menu_contacts_move_foldertree").style.display="";
	menucontactfoldertreecopy=false;
} 
function menucontactcopyclicked()
{
	createMenuPopUpTree("menu_contacts_move_foldertree","contacts",doContactsFolder);
	document.getElementById("menu_contacts_move_foldertree").style.display="";
	menucontactfoldertreecopy=true;
} 
function doContactsFolder(ofolder)
{
	var selectedfolderid= ofolder.oxfolder.data.id;
	if(menucontactfoldertreecopy)
	{
		triggerEvent("OX_Object_Copy",selectedfolderid);
	} else {
		triggerEvent("OX_Object_Move",selectedfolderid);
	}
	document.getElementById("menu_contacts_move_foldertree").style.display="none";
}
function onmenuchangeHeightorSelectedContact()
{
	if(menuisActive("menu_contacts_views"))
		onmenuchangeContactView(menuiteration,currentpath2[1],menucountselected);
	if(menuisActive("menu_contact"))
		onmenuchangeHeightContactContent(menuiteration,menucountselected);
    if(menuisActive("menu_contacts_send"))
        onmenuchangeContactSend(menuiteration,menucountselected);
}
function onmenuchangeContactView(iteration,value,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["contacts"]["menu_contacts_views"]=new Array();
	menu_display_views("contacts","menu_contacts_views",true,value == "cards", "menu_contacts_views_cards");
	menu_display_views("contacts","menu_contacts_views",true,value == "phonelist", "menu_contacts_views_phonelist");
	menu_display_views("contacts","menu_contacts_views",selecteditems==1,value == "detail", "menu_contacts_views_detail");
}
function onmenuchangeContactSend(iteration,selecteditems) {
    menuglobalzaehler=0;
    menuarrows["contacts"]["menu_contacts_send"]=new Array();
    menu_display_contents("contacts","menu_contacts_send",selecteditems > 0 && menucheckRight("READ"), "menu_contact_sendvcard");
}
function onmenuchangeHeightContactContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["contacts"]["menu_contact"]=new Array();
	menu_display_contents("contacts","menu_contact",selecteditems == 1 && menucheckRight("WRITE"), "menu_contact_edit");
	menu_display_contents("contacts","menu_contact",selecteditems > 0 && menucheckRight("DELETE"), "menu_contact_delete");
	menu_display_contents("contacts","menu_contact",isPrintableView(currentpath2.join('/')), "menu_contact_print");
	menuglobalzaehler=0;
	menu_display_contents("contacts","menu_contact",selecteditems == 1 && menucheckRight("WRITE"), "menu_contact_duplicate");
	menu_display_contents("contacts","menu_contact",selecteditems > 0 && menucheckRight("DELETE"), "menu_contact_move");
	menu_display_contents("contacts","menu_contact",selecteditems > 0 && menucheckRight("READ") , "menu_contact_copy");
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
/****************************************************************************************************/
/*** InfoStore Function ******************************************************************************/
/****************************************************************************************************/
menuarrows["infostore"]=new Array();

function menuinfostoreloaded() {
	createEnhancementMenu("menu_infostore_enhancement","menu_infostore","infostore");
	addOnClose($('menu_infostore_move_foldertree'),
		function () { 
			$('menu_infostore_move_foldertree').style.display="none"; 
		}
	);

    var menu = globalContextMenus.infostore = new ContextMenu();
    var contextData = [];
    var count = Value(), readable = Value(), writable = Value();
    var editable = Value(), deletable = Value(), lockable = Value();
    var unlockable = Value(), hasFile = Value();;
    
    var edit = new MenuItem("Edit", /*i18n*/
        function() { triggerEvent('OX_InfoStore_Edit'); });
    edit.setIcon("img/menu/edit.gif", "img/menu/edit_d.gif");
    edit.setEnabledF( function() {
        return count() == 1 && writable() && editable();
    });
    menu.addItem(edit);
    
    var del = new MenuItem("Delete", /*i18n*/
        function() { triggerEvent('OX_InfoStore_Delete'); });
    del.setIcon("img/menu/delete.gif", "img/menu/delete_d.gif");
    del.setEnabledF(function() {
        return count() > 0 && lockable() && deletable();
    }); 
    menu.addItem(del);
    
    menu.addItem(new MenuSeparator());
    
    var lock = new MenuItem("Lock", /*i18n*/
        function() { triggerEvent('OX_InfoStore_Lock'); });
    lock.setIcon("img/menu/sperren.gif", "img/menu/sperren_d.gif");
    lock.setEnabledF(function() {
        return count() > 0 && writable() && lockable();
    });
    menu.addItem(lock);
    
    var unlock = new MenuItem("Unlock", /*i18n*/
        function() { triggerEvent('OX_InfoStore_Unlock'); });
    unlock.setIcon("img/menu/entsperren.gif", "img/menu/entsperren_d.gif");
    unlock.setEnabledF(function() {
        return count() > 0 && writable() && unlockable();
    });
    menu.addItem(unlock);
    
    menu.addItem(new MenuSeparator());
    
    var attach = new MenuItem("Send as attachment", /*i18n*/
        function() { triggerEvent('OX_InfoStore_Send_Attachment'); });
    attach.setIcon("img/menu/alsanlagesenden.gif",
                   "img/menu/alsanlagesenden_d.gif");
    attach.setEnabledF(function() { return count() > 0 && readable(); });
    menu.addItem(attach);
    
    var link = new MenuItem("Send as link", /*i18n*/
        function() { triggerEvent('OX_InfoStore_Send_Link'); });
    link.setIcon("img/menu/save_as_link.gif", "img/menu/save_as_link_d.gif");
    link.setEnabledF(function() { return count() > 0 && readable() && ("infostore_sendLink" in window);  });
    menu.addItem(link);
    
    var open = new MenuItem("Open"/*i18n*/, function() {
        triggerEvent('OX_InfoStore_Open_Attachment', contextData);
    });
    open.setIcon("img/mail/open_ISattachment.gif",
                 "img/mail/open_ISattachment_d.gif");
    open.setEnabledF(function() { return count() == 1 && hasFile(); });
    menu.addItem(open);
    
    var save = new MenuItem("Save"/*i18n*/, function() {
        triggerEvent("OX_InfoStore_Save_Attachment", contextData);
    });
    save.setIcon("img/menu/attachment_save.gif",
                 "img/menu/attachment_save_d.gif");
    save.setEnabledF(function() { return count() == 1 && hasFile(); });
    menu.addItem(save);
    
    menu.onShow = function() {
        var collection = {
            columns: ["created_by", "modified_by", "locked_until", "file_size",
                      "filename"],
            objects: this.getContext().getSelected()
        };
        count.set(collection.objects.length);
        if (!count.value) return;
        readable.clear();
        writable.clear();
        editable.clear();
        deletable.clear();
        lockable.clear();
        unlockable.clear();
        hasFile.clear();
        OXCache.newRequest(null, "infostore", collection, null, responseData);
        function responseData(data) {
            contextData = data.objects;
            var l = true, ul = true, e = true;
            var me = configGetKey("identifier");
            for (var i in contextData) {
                var item = contextData[i];
                if (!item.locked_until) ul = false; else {
                    l = false;
                    if (item.modified_by != me) {
                        e = false;
                        if (item.created_by != me) ul = false;
                    }
                }
            }
            lockable.set(l);
            unlockable.set(ul);
            editable.set(e);
            readable.set(menuhasRight(contextData, "READ"));
            writable.set(menuhasRight(contextData, "WRITE"));
            deletable.set(menuhasRight(contextData, "DELETE"));
            hasFile.set(count.value == 1 && readable.value && hasAttachment(contextData));
        }
    };

	function hasAttachment(myobjects) {
		for(var i in myobjects) {
			if(!(myobjects[i]["file_size"]>0)) {
				return false;
			}
		}
		return true;
	}
}
function menuregisterInfoStoreContents()
{
	register("OX_InfoStore_Move",menuinfostoremoveclicked);
	register("OX_Switched",onmenuchangeHeightorSelectedInfoStore);
	register("OX_SELECTED_ITEMS_CHANGED",onmenuchangeHeightorSelectedInfoStore);
	register("OX_menu_Change_Height",onmenuchangeHeightorSelectedInfoStore);
	register("SubSelected",onmenuchangeSubSelectedInfoStore);
	register("OX_Search_InfoStore",onmenusearchInfoStore);
	register("OX_Lockable",onmenuchangeLocks);
}
function onmenusearchInfoStore() 
{
	var mysearchparam=document.getElementById("menu_search_infostore_searchfield").value;
	var mysearch=new Object();
	mysearch["pattern"]=mysearchparam;
	triggerEvent("OX_InfoStore_Search",mysearch);
}
function menuinfostoremoveclicked()
{
	register("OX_InfoStore_Move",menuinfostoremoveclicked);
	createMenuPopUpTree("menu_infostore_move_foldertree","infostore",moveInfoStoreFolder);
	document.getElementById("menu_infostore_move_foldertree").style.display="";
} 
function moveInfoStoreFolder(ofolder)
{
	var selectedfolderid= ofolder.oxfolder.data.id;
	triggerEvent("OX_Object_Move",selectedfolderid);
	document.getElementById("menu_infostore_move_foldertree").style.display="none";
}
function onmenuchangeLocks() {
	onmenuchangeHeightorSelectedInfoStore();
}
function onmenuchangeHeightorSelectedInfoStore()
{
	if(menuisActive("menu_infostore"))
		onmenuchangeHeightInfoStoreMainContent(menuiteration,menucountselected);
	if(menuisActive("menu_infostore_views"))
		onmenuchangeInfoStoreView(menuiteration,currentpath2[1],menucountselected);
	if(menuisActive("menu_infostore_send"))		
		onmenuchangeHeightInfoStoreSendContent(menuiteration,menucountselected);
	if(menuisActive("menu_global_tags"))
		onmenuchangeHeightGlobalTagsContent(menuiteration,menucountselected);
	if(menuisActive("menu_infostore_version"))
		onmenuchangeHeightInfoStoreVersionContent(menuiteration,menucountsubselected);
	
}
function onmenuchangeSubSelectedInfoStore(selected)
{
	if(menuisActive("menu_infostore_version"))
		onmenuchangeHeightInfoStoreVersionContent(menuiteration,selected);
	
}
function onmenuchangeInfoStoreView(iteration,value,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["infostore"]["menu_infostore_views"]=new Array();
    menu_display_views("infostore","menu_infostore_views",true,value == "split", "menu_infostore_views_split");
	menu_display_views("infostore","menu_infostore_views",true,value == "list", "menu_infostore_views_list");	
//	triggerEvent("OX_Switched",value);
}
function onmenuchangeHeightInfoStoreVersionContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["infostore"]["menu_infostore_version"]=new Array();
	menu_display_contents("infostore","menu_infostore_version",selecteditems == 1 && menucheckRight("WRITE") && (menucountselected == menucountlockable+menucounteditable), "menu_infostore_version_current"); //TODO:CHECK RIGHT WRITE
	menu_display_contents("infostore","menu_infostore_version",selecteditems > 0 && menucheckRight("WRITE") && (menucountselected == menucountlockable+menucounteditable), "menu_infostore_version_delete"); //TODO:CHECK RIGHT WRITE
}
function onmenuchangeHeightInfoStoreMainContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["infostore"]["menu_infostore"]=new Array();
	menu_display_contents("infostore","menu_infostore",selecteditems > 0 && menucheckRight("DELETE") && (selecteditems == menucountlockable+menucounteditable), "menu_infostore_move"); 
	menu_display_contents("infostore","menu_infostore",selecteditems > 0 && menucheckRight("WRITE") && (menucountlockable==selecteditems), "menu_infostore_log"); 
	menu_display_contents("infostore","menu_infostore",selecteditems > 0 && menucheckRight("WRITE") && (menucountunlockable==selecteditems), "menu_infostore_unlog"); 
	menuglobalzaehler=0;
	menu_display_contents("infostore","menu_infostore",selecteditems == 1 && menucheckRight("WRITE") && (selecteditems == menucountlockable+menucounteditable), "menu_infostore_edit"); 
	menu_display_contents("infostore","menu_infostore",selecteditems > 0 && menucheckRight("DELETE") && (selecteditems == menucountlockable+menucounteditable), "menu_infostore_delete"); 
	menu_display_contents("infostore","menu_infostore",isPrintableView(currentpath2.join('/')), "menu_infostore_print"); 
}
function onmenuchangeHeightInfoStoreSendContent(iteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["infostore"]["menu_infostore_send"]=new Array();
	menu_display_contents("infostore","menu_infostore_send", configGetKey("modules.mail.module") && selecteditems > 0, "menu_infostore_send_attachment"); 
	menu_display_contents("infostore","menu_infostore_send", configGetKey("modules.mail.module") && selecteditems > 0, "menu_infostore_send_link"); 
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
/****************************************************************************************************/
/*** Global Function ******************************************************************************/
/****************************************************************************************************/

menuarrows["global"]=new Array();

function menugloballoaded()
{
	createEnhancementMenu("menu_global_tags_enhancement","menu_global_tags","global");
	createEnhancementMenu("menu_global_attachments_enhancement","menu_global_attachments","global");
	
    var menu = globalContextMenus.attachments = new ContextMenu();
    
    var open = new MenuItem("Open", /*i18n*/
        function() { menu_doAttachmentOpen(); });
    open.setIcon("img/menu/attachment_open.gif",
                 "img/menu/attachment_open_d.gif");
    menu.addItem(open);
    
    var save = new MenuItem("Save as", /*i18n*/
        function() { triggerEvent('OX_Attachment_Save'); });
    save.setIcon("img/menu/attachment_save.gif",
                 "img/menu/attachment_save_d.gif");
    menu.addItem(save);

    var info = new MenuItem("Save in InfoStore", /*i18n*/
        function() { triggerEvent('OX_Attachment_SaveInfoStore'); });
    info.setIcon("img/infostore/infostore_save.gif",
                 "img/infostore/infostore_save_d.gif");
    info.disabled_action = function() {
        if (configGetKey("modules.infostore.module")) return false;
        triggerEvent("Feature_Not_Available",
                     "modules/infostore/mail/save_to_infostore");
    };
    menu.addItem(info);
    
    menu.onShow = function() {
        var enabled = menucountsubselected == 1 && !menudisableattachment
                   && menucheckRight("READ");
        open.setEnabled(enabled);
        save.setEnabled(!menudisableattachment
                && menucheckRight("READ") && (menucountsubselected == 1 || (activemodule == "mail" || activemodule == "mail_detail" && menucountsubselected >= 1)));
        info.setEnabled(enabled && configGetKey("modules.infostore.module"));
    };
}
function onmenuchangeHeightorSelectedGlobal()
{
	onmenuchangeHeightorSelectedTags();
}
function onmenuchangeHeightorSelectedTags() {
	onmenuchangeHeightGlobalTagsContent(menuiteration,menucountselected);	
}
function changeConfirm() {
	if(menuisActive("menu_global_confirmation")) {
		onmenuchangeHeightGlobalConfirmContent(menuiteration,menucountconfirm);
	}
}
function changeAttachments(select)
{
	if(menuisActive("menu_global_attachments")) {
		onmenuchangeHeightGlobalAttachmentsContent(menuiteration,menucountsubselected);
	}
}
function onmenuchangeHeightGlobalConfirmContent(menuiteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["global"]["menu_global_confirmation"] = new Array();
	menu_display_contents("global","menu_global_confirmation",selecteditems == 1 && !AcceptDeny.visible, "menu_global_confirmation_change"); 
}
function onmenuchangeHeightGlobalAttachmentsContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["global"]["menu_global_attachments"] = new Array();
	menu_display_contents("global","menu_global_attachments",selecteditems == 1 && menucheckRight("READ") && !menudisableattachment , "menu_global_attachments_open"); 
	menu_display_contents("global","menu_global_attachments",(selecteditems == 1 || ((activemodule=="mail" || activemodule=="mail_detail") && selecteditems >= 1)) && menucheckRight("READ") && !menudisableattachment, "menu_global_attachments_save"); 
	menu_display_contents("global","menu_global_attachments",configGetKey("modules.infostore.module") && selecteditems == 1 && menucheckRight("READ") && !menudisableattachment, "menu_global_attachments_saveinfostore"); 
}	
function menu_doAttachmentOpen() {
	(menunestedmessage) ? triggerEvent("OX_Attachment_Open_Nested") : triggerEvent("OX_Attachment_Open");
}
function onmenuchangeHeightGlobalTagsContent(iteration,selecteditems){
	
	menuglobalzaehler=0;
	menuarrows["global"]["menu_global_tags"]=new Array();
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag0"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag1"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag2"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag3"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag4"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag5"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag6"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag7"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag8"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag9"); 
	menu_display_contents("global","menu_global_tags",selecteditems > 0 && menucheckRight("WRITE") && ((activemodule!="infostore" && activemodule != "mail" && activemodule != "mail_detail" && true) || (activemodule=="infostore" && (selecteditems == menucountlockable+menucounteditable) || ((activemodule == "mail" || activemodule == "mail_detail" && !isNestedMailMessage()) && menucheckRight("USER")))), "menu_global_tags_tag10"); 
}
/****************************************************************************************************/
/*** Configuration Function ******************************************************************************/
/****************************************************************************************************/
menuarrows["configuration"]=new Array();
function menuconfigurationloaded()
{
	addOnClose($('menu_configuration_folder_folderpopup'),function () { $('menu_configuration_folder_folderpopup').style.display="none"; });
	createEnhancementMenu("menu_configuration_adminright_change_enhancement","menu_configuration_adminright","configuration");
	createEnhancementMenu("menu_configuration_folderright_folder_enhancement","menu_configuration_folderright_folder","configuration");
	createEnhancementMenu("menu_configuration_objectright_delete_enhancement","menu_configuration_objectright_delete","configuration");
	createEnhancementMenu("menu_configuration_objectright_read_enhancement","menu_configuration_objectright_read","configuration");
	createEnhancementMenu("menu_configuration_objectright_write_enhancement","menu_configuration_objectright_write","configuration");
	createEnhancementMenu("menu_configuration_settings_categories_enhancement","menu_configuration_settings_categories","configuration");
	createEnhancementMenu("menu_config_portal_external_enhancement","menu_config_portal_external","configuration");
	createEnhancementMenu("menu_config_mail_signatures_enhancement","menu_config_mail_signatures","configuration");
	createEnhancementMenu("menu_configuration_teams_teams_enhancement","menu_configuration_teams_teams","configuration");
}
function menuregisterConfigurationContents()
{
	register("OX_Configuration_Change_Right",onmenuchangeRight);
	register("OX_Configuration_Move_Folder",menuconfigurationfolderclicked);
	register("OX_Switched",changeRightHeightorSelectedConfigurationFolder);
	register("SubSelected",changeRightHeightorSelectedConfigurationFolder);
	register("OX_Config_Folder_Changed",changeRightHeightorSelectedConfigurationFolder);
	register("OX_Show_Rights",setRights);
	register("OX_menu_Change_Height",changeRightHeightorSelectedConfigurationFolder);
	register("OX_Switched",configurationmailsignatureschangeHeight);
	register("SubSelected",configurationmailsignatureschangeHeight);
	register("OX_menu_Change_Height",configurationmailsignatureschangeHeight);
	register("OX_Switched",configurationportalchangeHeight);
	register("SubSelected",configurationportalchangeHeight);
	register("OX_menu_Change_Height",configurationportalchangeHeight);
	register("OX_Switched",configurationsettingscategorieschangeHeight);
	register("SubSelected",configurationsettingscategorieschangeHeight);
	register("OX_menu_Change_Height",configurationsettingscategorieschangeHeight);
	register("OX_Switched",configurationmailteamschangeHeight);
	register("SubSelected",configurationmailteamschangeHeight);
	register("SubSelectedTeamMember",configurationmailteamschangeHeight);
	register("OX_menu_Change_Height",configurationmailteamschangeHeight);
}	
function menuconfigurationfolderclicked(){
	createMenuPopUpTree("menu_configuration_folder_folderpopup","folder",menu_moveFolder);
	document.getElementById("menu_configuration_folder_folderpopup").style.display="";
} 
function menu_moveFolder(ofolder) {
	var selectedfolderid= ofolder.oxfolder.data.id;
	triggerEvent("OX_Folder_Move",ofolder);
	document.getElementById("menu_configuration_folder_folderpopup").style.display="none";
	
}
function configurationsettingscategorieschangeHeight() {
	if(menuisActive("menu_configuration_settings_categories"))
			onmenuchangeHeightConfigurationSettingsCategories(menuiteration,menucountsubselected);
}
function onmenuchangeHeightConfigurationSettingsCategories(menuiteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["configuration"]["menu_configuration_settings_categories"] = new Array();
	menu_display_contents("configuration","menu_configuration_settings_categories",true, "menu_configuration_settings_categories_add"); 
	menu_display_contents("configuration","menu_configuration_settings_categories",selecteditems==1, "menu_configuration_settings_categories_edit"); 
	menu_display_contents("configuration","menu_configuration_settings_categories",selecteditems>0, "menu_configuration_settings_categories_remove"); 
	
}
function configurationportalchangeHeight() {
	if(menuisActive("menu_config_portal_external")) 
		onmenuchangeHeightConfigurationPortalSettings(menuiteration,menucountsubselected);
}
function configurationmailsignatureschangeHeight()
{
	if(menuisActive("menu_config_mail_signatures")) 
		onmenuchangeHeightConfigurationMailSignatures(menuiteration,menucountsubselected);
}
function configurationmailteamschangeHeight() {
	if(menuisActive("menu_configuration_teams_teams")) 
		onmenuchangeHeightConfigurationTeamsTeamsSettings(menuiteration,menucountsubselected);
}
function onmenuchangeHeightConfigurationMailSignatures(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["configuration"]["menu_config_mail_signatures"] = new Array();
	menu_display_contents("configuration","menu_config_mail_signatures",true, "menu_config_mail_signatures_add_signature"); 
	menu_display_contents("configuration","menu_config_mail_signatures",selecteditems == 1, "menu_config_mail_signatures_edit_signature"); 
	menu_display_contents("configuration","menu_config_mail_signatures",selecteditems > 0, "menu_config_mail_signatures_remove_signature"); 
}	
function onmenuchangeHeightConfigurationPortalSettings(menuiteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["configuration"]["menu_config_portal_external"] = new Array();
	menu_display_contents("configuration","menu_config_portal_external",true, "menu_config_portal_external_add"); 
	menu_display_contents("configuration","menu_config_portal_external",(selecteditems == 1), "menu_config_portal_external_edit"); 				
	menu_display_contents("configuration","menu_config_portal_external",selecteditems > 0, "menu_config_portal_external_remove"); 
	menuglobalzaehler=0;	
	menu_display_contents("configuration","menu_config_portal_external",selecteditems > 0, "menu_config_portal_external_enable"); 	
	menu_display_contents("configuration","menu_config_portal_external",selecteditems > 0, "menu_config_portal_external_disable"); 		
}
function onmenuchangeHeightConfigurationTeamsTeamsSettings(menuiteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["configuration"]["menu_configuration_teams_teams"] = new Array();
	menu_display_contents("configuration","menu_configuration_teams_teams",true, "menu_configuration_teams_teams_add_team"); 
	menu_display_contents("configuration","menu_configuration_teams_teams",selecteditems == 1, "menu_configuration_teams_teams_edit_team"); 
	menu_display_contents("configuration","menu_configuration_teams_teams",selecteditems > 0, "menu_configuration_teams_teams_remove_team"); 
}
/****************************************************************************************************/
/*** Folder Functions Function ******************************************************************************/
/****************************************************************************************************/

rightsstate = {
	OXRIGHTSREAD: 0,
	OXRIGHTSWRITE: 0,
	OXRIGHTSDELETE: 0,
	OXRIGHTSFOLDER: 0
};

function setRights(var1,var2,var3,var4,var5)
{
	onmenuchangeRight("FOLDER",var1);
	onmenuchangeRight("READ",var2);
	onmenuchangeRight("WRITE",var3);
	onmenuchangeRight("DELETE",var4);
	onmenuchangeRight("ADMIN",var5);
}
function changeRightHeightorSelectedConfigurationFolder()
{
	if(menuisActive("menu_configuration_objectright_read")) 
		onmenuchangeHeightRightsContentReadObject(menuiteration,rightsstate["OXRIGHTSREAD"],menucountsubselected);
	if(menuisActive("menu_configuration_objectright_write")) 
		onmenuchangeHeightRightsContentWriteObject(menuiteration,rightsstate["OXRIGHTSWRITE"],menucountsubselected);
	if(menuisActive("menu_configuration_objectright_delete")) 
		onmenuchangeHeightRightsContentDeleteObject(menuiteration,rightsstate["OXRIGHTSDELETE"],menucountsubselected);
	if(menuisActive("menu_configuration_folderright_folder")) 
		onmenuchangeHeightRightsContentFolderObject(menuiteration,rightsstate["OXRIGHTSFOLDER"],menucountsubselected);
	if(menuisActive("menu_configuration_adminright")) 
		onmenuchangeHeightRightsChangeRights(menuiteration,rightsstate["OXRIGHTSADMIN"],menucountsubselected);
	if(menuisActive("menu_configuration_user")) {
		onmenuchangeHeightRightsTeamUser(menuiteration,null,menucountsubselected);
	}
	if(menuisActive("menu_configuration_folder")) {
		onmenuchangeHeightRightsFolder(menuiteration,null,menucountsubselected);
	}
	
}

function onmenuchangeRight(righttype,value)
{
	if(righttype=="READ") {
		rightsstate["OXRIGHTSREAD"]=value;
		onmenuchangeHeightRightsContentReadObject(menuiteration,rightsstate["OXRIGHTSREAD"],menucountsubselected);
	} else if(righttype=="WRITE") {
		rightsstate["OXRIGHTSWRITE"]=value;
		onmenuchangeHeightRightsContentWriteObject(menuiteration,rightsstate["OXRIGHTSWRITE"],menucountsubselected);
	} else if(righttype=="DELETE") {
		rightsstate["OXRIGHTSDELETE"]=value;
		onmenuchangeHeightRightsContentDeleteObject(menuiteration,rightsstate["OXRIGHTSDELETE"],menucountsubselected);
	} else if(righttype=="FOLDER") {
		rightsstate["OXRIGHTSFOLDER"]=value;
		onmenuchangeHeightRightsContentFolderObject(menuiteration,rightsstate["OXRIGHTSFOLDER"],menucountsubselected);
	} else if(righttype=="ADMIN") {
		rightsstate["OXRIGHTSADMIN"]=value;
		onmenuchangeHeightRightsChangeRights(menuiteration,rightsstate["OXRIGHTSADMIN"],menucountsubselected);
	}
}
function onmenuchangeHeightRightsTeamUser(iteration,value,selecteditems) {
	menuarrows["configuration"]["menu_configuration_user"]=new Array();
	menuglobalzaehler=0;
	oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
		var haveadminrights = (configparentfolder != -1 && getFolderRightCreateSubFolders(oFolder)) 
				|| (configparentfolder == -1 && getFolderRightFolderAdmin(oFolder));
				
				
		//check here shared functionality and enable add user button, if the shared folder functionality is enabled. 
		var haveadminrights2 = (configGetKey("modules.folder.read_create_shared_folders") 
					|| (!configGetKey("modules.folder.read_create_shared_folders") && configGetKey("modules.folder.public_folders") && oFolder.oxfolder.data.type==5));
		
		menu_display_contents("configuration","menu_configuration_user",haveadminrights && haveadminrights2, "menu_configuration_user_add"); 
		menu_display_contents("configuration","menu_configuration_user",haveadminrights && haveadminrights2 && selecteditems>0 , "menu_configuration_user_remove"); 
	});
}
function onmenuchangeHeightRightsFolder(iteration,value,selecteditems) {
	menuarrows["configuration"]["menu_configuration_folder"]=new Array();
	menuglobalzaehler=0;
	oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
		var haveadminrights = (configparentfolder == -1 && getFolderRightFolderAdmin(oFolder));
		menu_display_contents("configuration","menu_configuration_folder",haveadminrights, "menu_configuration_folder_move"); 
		menu_display_contents("configuration","menu_configuration_folder",haveadminrights, "menu_configuration_folder_delete"); 
	});
}

function onmenuchangeHeightRightsChangeRights(iteration,value,selecteditems)
{
	menuarrows["configuration"]["menu_configuration_adminright"]=new Array();
	menuglobalzaehler=0;
	oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
		var haveadminrights = (configparentfolder != -1 && getFolderRightCreateSubFolders(oFolder)) || (configparentfolder == -1
																			&& getFolderRightFolderAdmin(oFolder));
	var noprivatefolder = (configfolder != 1 && oFolder.oxfolder.data.type != 1) 
	menu_display_views("configuration","menu_configuration_adminright",selecteditems == 1 && haveadminrights && noprivatefolder,value == 0,"menu_configuration_adminright_none"); 
	menu_display_views("configuration","menu_configuration_adminright",selecteditems == 1 && haveadminrights && noprivatefolder,value == 1,"menu_configuration_adminright_admin"); 
	});
}
function onmenuchangeHeightRightsContentFolderObject(iteration,value,selecteditems)
{
	menuarrows["configuration"]["menu_configuration_folderright_folder"]=new Array();
	menuglobalzaehler=0;
	oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
		var haveadminrights = (configparentfolder != -1 && getFolderRightCreateSubFolders(oFolder)) 
													|| (configparentfolder == -1 && getFolderRightFolderAdmin(oFolder));
		menu_display_views("configuration","menu_configuration_folderright_folder",selecteditems == 1 && haveadminrights,value == 0,"menu_configuration_folderright_folder_none"); 
		menu_display_views("configuration","menu_configuration_folderright_folder",selecteditems == 1 && haveadminrights,value == 1,"menu_configuration_folderright_folder_visible"); 
		menu_display_views("configuration","menu_configuration_folderright_folder",selecteditems == 1 && haveadminrights,value == 2,"menu_configuration_folderright_folder_visible_objects"); 
		menu_display_views("configuration","menu_configuration_folderright_folder",selecteditems == 1 && haveadminrights,value == 4,"menu_configuration_folderright_folder_create_subfolder"); 
		menu_display_views("configuration","menu_configuration_folderright_folder",selecteditems == 1 && haveadminrights,value == 64,"menu_configuration_folderright_folder_admin"); 	
	});
}
function onmenuchangeHeightRightsContentDeleteObject(iteration,value,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["configuration"]["menu_configuration_objectright_delete"]=new Array();
	oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
		var haveadminrights = (configparentfolder != -1 && getFolderRightCreateSubFolders(oFolder)) 
													|| (configparentfolder == -1 && getFolderRightFolderAdmin(oFolder));
		menu_display_views("configuration","menu_configuration_objectright_delete",selecteditems == 1 && haveadminrights,value == 0,"menu_configuration_objectright_delete_none"); 
		menu_display_views("configuration","menu_configuration_objectright_delete",selecteditems == 1 && haveadminrights,value == 1,"menu_configuration_objectright_delete_own"); 
		menu_display_views("configuration","menu_configuration_objectright_delete",selecteditems == 1 && haveadminrights,value == 2,"menu_configuration_objectright_delete_all"); 
		menu_display_views("configuration","menu_configuration_objectright_delete",selecteditems == 1 && haveadminrights,value == 64,"menu_configuration_objectright_delete_admin"); 
	});

}
function onmenuchangeHeightRightsContentWriteObject(iteration,value,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["configuration"]["menu_configuration_objectright_write"]=new Array();
	oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
		var haveadminrights = (configparentfolder != -1 && getFolderRightCreateSubFolders(oFolder)) || (configparentfolder == -1 && getFolderRightFolderAdmin(oFolder));
		menu_display_views("configuration","menu_configuration_objectright_write",selecteditems == 1 && haveadminrights,value == 0,"menu_configuration_objectright_write_none"); 
		menu_display_views("configuration","menu_configuration_objectright_write",selecteditems == 1 && haveadminrights,value == 1,"menu_configuration_objectright_write_own"); 
		menu_display_views("configuration","menu_configuration_objectright_write",selecteditems == 1 && haveadminrights,value == 2,"menu_configuration_objectright_write_all"); 
		menu_display_views("configuration","menu_configuration_objectright_write",selecteditems == 1 && haveadminrights,value == 64,"menu_configuration_objectright_write_admin"); 
	});
}
function onmenuchangeHeightRightsContentReadObject(iteration,value,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["configuration"]["menu_configuration_objectright_read"]=new Array();
	oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
		var haveadminrights = (configparentfolder != -1 && getFolderRightCreateSubFolders(oFolder)) || (configparentfolder == -1 && getFolderRightFolderAdmin(oFolder));
		menu_display_views("configuration","menu_configuration_objectright_read",selecteditems == 1 && haveadminrights,value == 0,"menu_configuration_objectright_read_none"); 
		menu_display_views("configuration","menu_configuration_objectright_read",selecteditems == 1 && haveadminrights,value == 1,"menu_configuration_objectright_read_own"); 
		menu_display_views("configuration","menu_configuration_objectright_read",selecteditems == 1 && haveadminrights,value == 2,"menu_configuration_objectright_read_all"); 
		menu_display_views("configuration","menu_configuration_objectright_read",selecteditems == 1 && haveadminrights,value == 64,"menu_configuration_objectright_read_admin"); 
	});
}
/***************************************************************** End **************************************/
/************************************************************************************************************/
/*** New Object Functions ***********************************************************************************/
/************************************************************************************************************/
/************************************************************************************************************/
/*** Mail Functions  ****************************************************************************************/
/************************************************************************************************************/
menuarrows["mail_new"]=new Array();
function mailnewonload() {
	createEnhancementMenu("menu_new_mail_view_enhancement","menu_new_mail_view","mail_new");
}
function mailnewattachmentchangeHeight()
{
	if($("menu_mail_new_attachment")) {
		onmenuchangeHeightMailNewAttachmentContent(menuiteration,menucountsubselected);
	}
	if ($("menu_new_mail_view")) {
		onmenuchangeHeightMailNewView(menuiteration,menucountsubselected);
	}
}
function onmenuchangeHeightMailNewAttachmentContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
    menuarrows["mail_new"]["menu_mail_new_attachment"]=new Array();
    menu_display_contents("mail_new","menu_mail_new_attachment",true, "menu_mail_new_add_attachment");
    menu_display_contents("mail_new","menu_mail_new_attachment",selecteditems > 0, "menu_mail_new_remove_attachment");
} 
function onmenuchangeHeightMailNewView(iteration,selecteditems) {
	menuglobalzaehler=0;
    menuarrows["mail_new"]["menu_new_mail_view"]=new Array();
    menu_display_contents("mail_new","menu_new_mail_view",true, "menu_new_mail_view_fromfield");
	menu_display_contents("mail_new","menu_new_mail_view",true, "menu_new_mail_view_ccfield");
	menu_display_contents("mail_new","menu_new_mail_view",true, "menu_new_mail_view_bccfield");
	menu_display_contents("mail_new","menu_new_mail_view",true, "menu_new_mail_view_optionsfield");
}
/****************************************************************************************************/
/*** Calendar Functions  ******************************************************************************/
/****************************************************************************************************/
menuarrows["calendar_new"]=new Array();
function calendarnewonload() {
	createEnhancementMenu("menu_calendar_new_participant_enhancement","menu_calendar_new_participant","calendar_new");
}

function calendarnewattachmentchangeHeight()
{
	if(menuisActive("menu_calendar_new_attachment")) 
		onmenuchangeHeightCalendarNewAttachmentContent(menuiteration,menucountsubselected);
}
function calendarnewparticipantchangeHeight()
{
	if(menuisActive("menu_calendar_new_participant")) 
		onmenuchangeHeightCalendarNewParticipantContent(menuiteration,menucountsubselected);
}
function onmenuchangeHeightCalendarNewAttachmentContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["calendar_new"]["menu_calendar_new_attachment"]=new Array();
	menu_display_contents("calendar_new","menu_calendar_new_attachment",(configContainsKey("modules.infostore.module") && configGetKey("modules.infostore.module") == true), "menu_calendar_new_attachment_add_attachment");
	menu_display_contents("calendar_new","menu_calendar_new_attachment",(configContainsKey("modules.infostore.module") && configGetKey("modules.infostore.module") == true && selecteditems > 0), "menu_calendar_new_attachment_delete");
} 
function onmenuchangeHeightCalendarNewParticipantContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["calendar_new"]["menu_calendar_new_participant"]=new Array();
	menu_display_contents("calendar_new","menu_calendar_new_participant", (configContainsKey("participants.showDialog") && configGetKey("participants.showDialog") == true), "menu_calendar_new_participant_add_participant");
	menu_display_contents("calendar_new","menu_calendar_new_participant", (configContainsKey("participants.showDialog") && configGetKey("participants.showDialog") == true), "menu_calendar_new_participant_add_external");
	menu_display_contents("calendar_new","menu_calendar_new_participant", (configContainsKey("participants.showDialog") && configGetKey("participants.showDialog") == true && selecteditems > 0), "menu_calendar_new_participant_delete");	
}
/****************************************************************************************************/
/*** Task Functions  ******************************************************************************/
/****************************************************************************************************/
menuarrows["task_new"]=new Array();
function tasknewonload() {
	createEnhancementMenu("menu_task_new_participant_enhancement","menu_task_new_participant","task_new");
}
function tasknewparticipantchangeHeight()
{
	if(menuisActive("menu_task_new_participant")) {
		onmenuchangeHeightTaskNewParticipantContent(menuiteration,menucountsubselected);
	}
}
function onmenuchangeHeightTaskNewParticipantContent(iteration,selecteditems)
{
	menuglobalzaehler=0;
	menuarrows["task_new"]["menu_task_new_participant"]=new Array();
	menu_display_contents("task_new","menu_task_new_participant", (configContainsKey("participants.showDialog") && configGetKey("participants.showDialog") == true), "menu_task_new_participant_add_participant");
	menu_display_contents("task_new","menu_task_new_participant", (configContainsKey("participants.showDialog") && configGetKey("participants.showDialog") == true), "menu_task_new_participant_add_external");
	menu_display_contents("task_new","menu_task_new_participant", (configContainsKey("participants.showDialog") && configGetKey("participants.showDialog") == true && selecteditems > 0), "menu_task_new_participant_delete");

	
} 
/****************************************************************************************************/
/*** Contact Functions  ******************************************************************************/
/****************************************************************************************************/
menuarrows["contact_new"]=new Array();
function menuregisterContactNewContents()
{
	register("OX_SELECTED_SUBSELECTION_CHANGED",contactnewchangeHeight);
}	
function contactnewchangeHeight()
{
	if(menuisActive("menu_new_contact_distributionlist")) {
		onmenuchangeHeightContactDistributionListContent(menuiteration,menucountsubselected);
	}
	if(menuisActive("menu_contact_new_picture")) {
		onmenuchangeHeightContactPictureContent(menuiteration,menucountsubselected);
	}
}
function onmenuchangeHeightContactDistributionListContent(iteration,selecteditems){
	menuglobalzaehler=0;
	menuarrows["contact_new"]["menu_contact_new_distributionlist"]=new Array();
	menu_display_contents("contact_new","menu_contact_new_distributionlist",true, "menu_new_contact_distributionlist_ic");
	menu_display_contents("contact_new","menu_contact_new_distributionlist",true, "menu_new_contact_distributionlist_em");
	menu_display_contents("contact_new","menu_contact_new_distributionlist",selecteditems>0, "menu_new_contact_distributionlist_delete");
} 
function onmenuchangeHeightContactPictureContent(iteration,selecteditems) {
	menuglobalzaehler=0;
	menuarrows["contact_new"]["menu_contact_new_picture"]=new Array();
	menu_display_contents("contact_new","menu_contact_new_picture",true, "menu_contact_new_picture_add");
	menu_display_contents("contact_new","menu_contact_new_picture",true, "menu_contact_new_picture_remove");
} 
function call_triggerEventFunction() 
{
	oMainFolderTree.cache.get_folder((configparentfolder!=-1)?configparentfolder:configfolder,function (oFolder){
		triggerEvent('OX_Configuration_Add_User',oFolder);
	});
}
fileloaded();
function getStackTrace() {
    var result = '';

    if(true) { // Mozilla, not ECMA
        // fake an exception so we can get Mozilla's error stack
        var testExcp;
        try
        {
            foo.bar;
        }
        catch(testExcp)
        {
            var stack = parseErrorStack(testExcp);
            result += '> ' + stack[3] + '\n';
        }
    }
    return result;
}
function parseErrorStack(excp)
{
    var stack = [];
    var name;

    if (!excp || !excp.stack)
    {
        return stack;
    }

    var stacklist = excp.stack.split('\n');

    for (var i = 0; i < stacklist.length - 1; i++)
    {
        var framedata = stacklist[i];

        name = framedata.match(/^(\w*)/)[1];
        if (!name) {
            name = 'anonymous';
        }

        stack[stack.length] = name;
    }
    // remove top level anonymous functions to match IE

    while (stack.length && stack[stack.length - 1] == 'anonymous')
    {
        stack.length = stack.length - 1;
    }
    return stack;
}

function setButtonMenuElement1(node) {
	if(node) {
		var divsinelement=node.getElementsByTagName("div");
		for(var i=0;i<divsinelement.length;i++) {
			divsinelement[i].style.position="relative";
			divsinelement[i].style.top="2px";
			divsinelement[i].style.left="2px";
		}
	}
}
function resetButtonMenuElement1(node) {
	if(node) {
		var divsinelement=node.getElementsByTagName("div");
		for(var i=0;i<divsinelement.length;i++) {
			divsinelement[i].style.top="0px";
			divsinelement[i].style.left="0px";
		}
	}
}
function setButtonMenuElement2(node) {
	if(node) {
		var divsinelement=node.getElementsByTagName("img");
		for(var i=0;i<divsinelement.length;i++) {
			divsinelement[i].style.position="relative";
			divsinelement[i].style.top="2px";
			divsinelement[i].style.left="2px";
		}
	}
}
function resetButtonMenuElement2(node) {
	if(node) {
		var divsinelement=node.getElementsByTagName("img");
		for(var i=0;i<divsinelement.length;i++) {
			divsinelement[i].style.top="0px";
			divsinelement[i].style.left="0px";
		}
	}
}
function setButtonMenuElement3(node) {
	if(node) {
		node.style.top="2px";
		node.style.left="9px";
	}
}
function resetButtonMenuElement3(node) {
	if(node) {
		node.style.top="0px";
		node.style.left="7px";
	}
}
function makeButtonElement1(node) {
	if(node) {
		var allelements=node.getElementsByTagName("tr");
		for(var t=0;t<allelements.length;t++) {
			if(allelements[t].id && allelements[t].id.indexOf("_na")==-1 && allelements[t].id.indexOf("_disable")==-1 && allelements[t].id.indexOf("_active")==-1 && allelements[t].id.indexOf("menu_mail_flags_") != 0) {	
				setDOMMenuElement1(allelements[t]);
			}
		}
	}
}
function makeButtonElement2(node) {
	if(node) {
		var allelements=node.getElementsByTagName("tr");
		for(var t=0;t<allelements.length;t++) {
			if(allelements[t].id && allelements[t].id.indexOf("_na")==-1 && allelements[t].id.indexOf("_disable")==-1 && allelements[t].id.indexOf("_active")==-1 && allelements[t].id.indexOf("_arrow") == -1) {	
				setDOMMenuElement2(allelements[t]);
			}
		}
	}
}
function setDOMMenuElement1(mynode) {
	if(mynode) {
		addDOMEvent(mynode,"mousedown",function(e) {
			if (e.button != undefined && e.button == RightButton) return;
			setButtonMenuElement1(mynode);
		});
		addDOMEvent(mynode,"mouseup",function(e) {
			resetButtonMenuElement1(mynode);
		});
		addDOMEvent(mynode,"mouseout",function(e) {
			resetButtonMenuElement1(mynode);
		});
	}
}
function setDOMMenuElement2(mynode) {
	if(mynode) {
		addDOMEvent(mynode,"mousedown",function(e) {
			if (e.button != undefined && e.button != RightButton) return;
			setButtonMenuElement2(mynode);
		});
		addDOMEvent(mynode,"mouseup",function(e) {
			resetButtonMenuElement2(mynode);
		});
		addDOMEvent(mynode,"mouseout",function(e) {
			resetButtonMenuElement2(mynode);
		});
	}
}
function setDOMMenuElement3(mynode) {
	if(mynode) {
		addDOMEvent(mynode,"mouseup",function(e) {
			resetButtonMenuElement3(mynode);
		});
		addDOMEvent(mynode,"mouseout",function(e) {
			resetButtonMenuElement3(mynode);
		});
		addDOMEvent(mynode,"mousedown",function(e) {
			if (e.button != undefined && e.button != RightButton) return;
			setButtonMenuElement3(mynode);
		});
	}
}
