/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * 
 */
 
/*
 * External Routing Service
 * @{Object} the main service object
 * @property name {Sting}: name from service
 * @property logo {Sting}: path to the logo service
 * @property getDirection {function}: param is a object, this function opens the service
 * 
 */

/* External Service Google routing planner */
(function() {
	var googlePlannerObject = {};
	googlePlannerObject.name = "Google";
	googlePlannerObject.logo = getFullImgSrc("img/dummy.gif");
	googlePlannerObject.getDirection = function(obj) {
		if(obj.Data)
			var myObject = obj.Data;
		else {
			triggerEvent("OX_New_Error", 4, _("No routing data available"));
			return;
		}
		if(myObject.toCountry == "") {
			var toCountryStr = "";
		} else 
			var toCountryStr = objRoutingPlanner.countries[myObject.toCountry];
		
		if(myObject.fromCountry == "") {
			var fromCountryStr = "";
		} else 
			var fromCountryStr = objRoutingPlanner.countries[myObject.fromCountry];
	
		var targetUrl = "http://maps.google.de/?ie=UTF8&om=1&spn=0.006299,0.010345&source=embed&saddr="+encodeURIComponent(myObject.fromStreet)+","+
						encodeURIComponent(myObject.fromZip)+","+encodeURIComponent(myObject.fromCity)+","+encodeURIComponent(fromCountryStr)+"&daddr="+
						encodeURIComponent(myObject.toStreet)+","+encodeURIComponent(myObject.toZip)+","+encodeURIComponent(myObject.toCity)+","+encodeURIComponent(toCountryStr);
		window.open(targetUrl, "Google");
	}
	objRoutingPlanner.registerRoutingPlanner(googlePlannerObject);
	
	
	/* External Service Falke routing planner */
	var falkPlannerObject = {};
	falkPlannerObject.name = "Falk";
	falkPlannerObject.logo = getFullImgSrc("img/dummy.gif");
	falkPlannerObject.CountryIsoCodes = {"AL":"ALB","AD":"AND","BE":"BEL","BA":"BIH","BG":"BGR","DK":"DNK","DE":"DEU","EE":"EST","FI":"FIN","FR":"FRA","GI":"GIB","GR":"GRC","GB":"GBR","IE":"IRL","IT":"ITA","HR":"HRV","LV":"LVA","LI":"LIE","LT":"LTU","LU":"LUX","MK":"MKD","MD":"MDA","MC":"MCO","NL":"NLD","NO":"NOR","AT":"AUT","PL":"POL","PT":"PRT","RO":"ROM","RU":"RUS","SM":"SMR","SE":"SWE","CH":"CHE","RS":"SCG","SK":"SVK","SI":"SVN","ES":"ESP","CZ":"CZE","UA":"UKR","HU":"HUN","TR":"TUR","VA":"VAT","BY":"BLR"};
	falkPlannerObject.getDirection = function(obj) {
		if(obj.Data)
			var myObject = obj.Data;
		else {
			triggerEvent("OX_New_Error", 4, _("No routing data available"));
			return;
		}
		if(myObject.toCountry == "") {
			triggerEvent("OX_New_Error", 4, _("Please select a country for the destination address"));
			return;
		} else if(myObject.fromCountry == "") {
			triggerEvent("OX_New_Error", 4, _("Please select a country for the start address"));
			return;
		}
		var targetUrl = "http://www.falk.de/baseservices/do/htRouteService?selOptimizationType=90&selCar=0&isArrivalTime=false&dateTime=&startService=1&"
							+"station%5B0%5D.street="+escape(myObject.fromStreet)+"&station%5B0%5D.zip="+myObject.fromZip+"&station%5B0%5D.city="
							+escape(myObject.fromCity)+"&station%5B0%5D.country.isoCode="+this.CountryIsoCodes[myObject.fromCountry]
							+"&station%5B1%5D.street="+escape(myObject.toStreet)+"&station%5B1%5D.zip="+myObject.toZip+"&station%5B1%5D.city="
							+escape(myObject.toCity)+"&station%5B1%5D.country.isoCode="+this.CountryIsoCodes[myObject.toCountry];
		
		if(this.CountryIsoCodes[myObject.toCountry] == undefined) {
			triggerEvent("OX_New_Error", 4, format(_("Error: %1$s doesn't support routing to %2$s"), "Falk", objRoutingPlanner.countries[myObject.toCountry]));
		} else if(this.CountryIsoCodes[myObject.fromCountry] == undefined) {
			triggerEvent("OX_New_Error", 4, format(_("Error: %1$s doesn't support routing from %2$s"), "Falk", objRoutingPlanner.countries[myObject.fromCountry]));
		} else
			window.open(targetUrl, "Falk");
	}
	objRoutingPlanner.registerRoutingPlanner(falkPlannerObject);
	
	
	/* External Service ViaMichelin routing planner */
	var viaMichelinPlannerObject = {};
	viaMichelinPlannerObject.name = "ViaMichelin";
	viaMichelinPlannerObject.logo = getFullImgSrc("img/dummy.gif");
	viaMichelinPlannerObject.CountryIsoCodes = {"AL":"1025337","AD":"856","BE":"000000311","BA":"1025343","BG":"001025340","DK":"000001473","DE":"000000240","EE":"001860861","FI":"000001792","FR":"000001424","GR":"001945835","GB":"1138","IE":"000000919","IT":"000000612","HR":"1752","LV":"001851089","LI":"000000108","LT":"001851066","LU":"000000247","MK":"1025334","MD":"1025352","MC":"852","NL":"000000285","NO":"000001574","AT":"000000106","PL":"000001743","PT":"000000669","RO":"001025349","RU":"1851058","SM":"318","SE":"000001507","CH":"000000185","RS":"1713472","SK":"1697","SI":"1746","ES":"000000844","CZ":"000001694","UA":"1749","HU":"1741","TR":"002059154","VA":"2066810","BY":"1794"};
	viaMichelinPlannerObject.getDirection = function(obj) {
		if(obj.Data)
			var myObject = obj.Data;
		else {
			triggerEvent("OX_New_Error", 4, _("No routing data available"));
			return;
		}
		if(myObject.toCountry == "") {
			triggerEvent("OX_New_Error", 4, _("Please select a country for the destination address"));
			return;
		} else if(myObject.fromCountry == "") {
			triggerEvent("OX_New_Error", 4, _("Please select a country for the start address"));
			return;
		}
		var targetUrl = "http://www.viamichelin.com/viamichelin/deu/dyn/controller/ItiWGPerformPage?intItineraryType=1&"
							+"strStartAddress="+escape(myObject.fromStreet)+"&strStartCP="+myObject.fromZip+"&strStartCity="+escape(myObject.fromCity)+"&strStartCityCountry="
							+this.CountryIsoCodes[myObject.fromCountry]
							+"&strDestAddress="+escape(myObject.toStreet)+"&strDestCP="+myObject.toZip+"&strDestCity="+escape(myObject.toCity)+"&strDestCityCountry="
							+this.CountryIsoCodes[myObject.toCountry];
		if(this.CountryIsoCodes[myObject.toCountry] == undefined) {
			triggerEvent("OX_New_Error", 4, format(_("Error: %1$s doesn't support routing to %2$s"), "ViaMichelin", objRoutingPlanner.countries[myObject.toCountry]));
		} else if(this.CountryIsoCodes[myObject.fromCountry] == undefined) {
			triggerEvent("OX_New_Error", 4, format(_("Error: %1$s doesn't support routing from %2$s"), "ViaMichelin", objRoutingPlanner.countries[myObject.fromCountry]));
		} else
			window.open(targetUrl, "ViaMichelin");
	}
	objRoutingPlanner.registerRoutingPlanner(viaMichelinPlannerObject);
	
	
	/* External Service Map24 routing planner */
	var map24PlannerObject = {};
	map24PlannerObject.name = "Map24";
	map24PlannerObject.logo = getFullImgSrc("img/dummy.gif");
	map24PlannerObject.getDirection = function(obj) {
		if(obj.Data)
			var myObject = obj.Data;
		else {
			triggerEvent("OX_New_Error", 4, _("No routing data available"));
			return;
		}
		if(myObject.toCountry == "") {
			triggerEvent("OX_New_Error", 4, _("Please select a country for the destination address"));
			return;
		} else if(myObject.fromCountry == "") {
			triggerEvent("OX_New_Error", 4, _("Please select a country for the start address"));
			return;
		}
		var targetUrl = "http://link2.map24.com/?newroute=1&"
							+"sstreet="+escape(myObject.fromStreet)+"&szip="+myObject.fromZip+"&scity="+escape(myObject.fromCity)+"&scountry="+myObject.fromCountry
							+"&dstreet="+escape(myObject.toStreet)+"&dzip="+myObject.toZip+"&dcity="+escape(myObject.toCity)+"&dcountry="+myObject.toCountry
							+"&mid=LINK2&lid=9567c3d9";
		window.open(targetUrl, "ViaMichelin");
	}
	objRoutingPlanner.registerRoutingPlanner(map24PlannerObject);
})();
fileloaded();