var oCi_import_data = null;
var importDataFolderTree = null;
var importFolderId = -1;

register("Loaded", function () {
	addOnClose($("window_import_status"), function() { oCi_import_data.closeWindow(); }); 
});

registerView("configuration/import",
	function () { 
		showNode("config_import"); 
		$("config_import").style.display="block";
	},
	function() { 		
		oCi_import_data = new Ci_import_data();
		oCi_import_data.createCombobox();
		if(!config.modules.calendar.module || !config.modules.tasks.module) {
			$("cs_import_ical").disabled = "disabled";
			$('cs_import_vcard').checked = true;
		} else {
			$('cs_import_ical').checked = true;
			if (importFolderDestination != null && importFolderDestination.oxfolder.data.module == "contacts"){
				$('cs_import_vcard').checked = true;
				oCi_import_data.combobox.disable();
				oCi_import_data.action="VCARD";
			} else if (importFolderDestination != null && importFolderDestination.oxfolder.data.module == "tasks"){
				oCi_import_data.combobox.setKey("tasks");
			}
		}
		oCi_import_data.form = $('form_config_import');
		oCi_import_data.form.file.value="";
		register("OX_SAVE_OBJECT",uploadImportData);
	},
	function() {
		unregister("OX_SAVE_OBJECT",uploadImportData);
		unregister("cb_importComboChanged",cb_importComboChanged);
		unregister('cb_importComboCSVChanged', cb_importComboCSVChanged);
	},
	function () { 
		hideNode("config_import"); 
		$("config_import").style.display="none"; 
		oCi_import_data.closeWindow();
	},
	function () { }
);

function uploadImportData() {
	if(!oCi_import_data.process)
		oCi_import_data.uploadData();
}

function Ci_import_data() {
	this.action = "ICAL";
	this.folder = configGetKey("folder.calendar");
	this.combobox = null;
	this.process = false;
	$("fileImportInput").disabled = false;
	$("cimp_header").firstChild.nodeValue=getconfigPathSelected().substring(1);	
}

function cb_importComboChanged() {
	if(oCi_import_data.action == "ICAL")
		oCi_import_data.changeStatus("ical");	
}

function cb_importComboCSVChanged() {
	if(oCi_import_data.action == "CSV" || oCi_import_data.action == "OUTLOOK_CSV")
		oCi_import_data.changeStatus("csv");	
}

Ci_import_data.prototype = {
	uploadData : function() {	
		this.form = $('form_config_import');
		this.uri = AjaxRoot + "/import?action="+this.action+"&session="+session+"&folder="+importFolderId //this.folder;	
		this.form.action = this.uri; 
		this.form.target="dlIframe"
		if(this.form.file.value=="") {
			triggerEvent("OX_New_Error", 4, _("Please select a file to import"));
		}
		else {
			this.process = true;
			this.form.submit();
			$("fileImportInput").disabled = true;
		}
	}, 
	createCombobox : function() {
		var cbText = new Array();
		cbText[0] = "Appointments"; /*i18n*/
		cbText[1] = "Tasks"; /*i18n*/
		cbText[2] = "Comma Separated"; /*i18n*/
		cbText[3] = "Outlook file"; /*i18n*/
		this.combobox = new ComboBox3(window, "import.combobox.module", "20em", 
			0, true, "cb_importComboChanged", null);
		this.combobox.addElement(cbText[0],"calendar");
		this.combobox.addElement(cbText[1],"tasks");
		this.combobox.getDomNode();
		if(!config.modules.calendar.module || !config.modules.tasks.module)
			this.combobox.disable();
		register('cb_importComboChanged', cb_importComboChanged);
		this.comboboxCSV = new ComboBox3(window, "import.combobox.csv", "20em", 
			0, true, "cb_importComboCSVChanged", null);
		this.comboboxCSV.addElement(cbText[2],"CSV");
		this.comboboxCSV.addElement(cbText[3],"OUTLOOK_CSV");
		this.comboboxCSV.getDomNode();
		this.comboboxCSV.disable();
		register('cb_importComboCSVChanged', cb_importComboCSVChanged);
		
		if (importFolderDestination != null) {
			setFolder(importFolderDestination.oxfolder.data.id);
		} else {
			setFolder(configGetKey("folder.calendar") || configGetKey("folder.contacts"));
		}
	},
	
	openWindow: function() {
		showNode("disable_background_window");
		$("disable_background_window").style.display="block";
		showNode("config_popups_win");
		$("config_popups_win").style.display="block";
		showNode("window_import_status");
		centerPopupWindow($("window_import_status"));
		$("window_import_status").style.display="block";
	}, 
	
	closeWindow: function() {
		hideNode("window_import_status");
		$("window_import_status").style.display="none";
		hideNode("config_popups_win");
		$("config_popups_win").style.display="none";
		hideNode("disable_background_window");
		var childs=	$("disable_background_window").childNodes;
		var closeall=true;
		for(var i=0;i<childs.length;i++) {
			if(childs[i].tagName && childs[i].tagName == "DIV") {
				if(childs[i].style.display && childs[i].style.display!= "none" ) {
					closeall=false;
				}
			}
		}
		if(closeall) {
			$("disable_background_window").style.display="none";
		}
		$("cms_import_status").firstChild.data = "";
		$("cms_import_log").value = "";
		this.form.reset();
	},
	
	changeStatus : function(suffix) {
		var Self = this;
		switch(suffix) {
			case 'ical'		 	: 	Self.action = "ICAL";
									
									Self.combobox.enable();
									Self.comboboxCSV.disable();
													
									Self.folder  = configGetKey("folder."+Self.combobox.getKey());
									
									if (importFolderDestination == null || importFolderDestination.oxfolder.data.module == "contacts")
										setFolder(Self.folder);
									else
										setFolder(importFolderDestination.oxfolder.data.id);
									
									break;
				
			case 'vcard' 		: 	Self.action = "VCARD";
									Self.folder = configGetKey("folder.contacts");
									
									Self.combobox.disable();
									Self.comboboxCSV.disable();

									if (importFolderDestination == null || importFolderDestination.oxfolder.data.module != "contacts")
										setFolder(Self.folder);
									else
										setFolder(importFolderDestination.oxfolder.data.id);
									
									break;
			
			case 'csv' 			: Self.action = Self.comboboxCSV.getKey();
									Self.folder = configGetKey("folder.contacts");
									Self.comboboxCSV.enable();
									Self.combobox.disable();

									if (importFolderDestination == null || importFolderDestination.oxfolder.data.module != "contacts")
										setFolder(Self.folder);
									else
										setFolder(importFolderDestination.oxfolder.data.id);
									
									break;
		}
	}
}

function import_getWarningsAsString(warnings) {
    var retVal = [];
    for (var i = 0; i < warnings.length; i++) {
        retVal.push(escapeHTML(formatError(warnings[i], "%2$s (%1$s, %3$s)")) + "\n");
    }
    return retVal.join();
}

function callback_import(arg) {
	var textM = "";
	oCi_import_data.process = false;
	$("fileImportInput").disabled = false;
	
	if (arg.error) {
		newServerError(arg);
	} else if (arg.data && arg.data.length != 0) {
		var successfullImported = 0;
		var importLog = "";
		
		for (var i=0; i<arg.data.length; i++) {
			if (arg.data[i].error) {				
				importLog += escapeHTML(formatError(arg.data[i], "%2$s (%1$s, %3$s)")) + "\n";
				if (arg.data[i].warnings && arg.data[i].warnings.length) {
					importLog += import_getWarningsAsString(arg.data[i].warnings);
				}
				if (arg.data[i].category && arg.data[i].category == 13){
				    successfullImported++;
				}
			} else if (arg.data[i].warnings && arg.data[i].warnings.length) {
                importLog += import_getWarningsAsString(arg.data[i].warnings);
            } else {
				successfullImported++;
			}
		}
		
		$("cms_import_log").value = importLog.length != 0 ? importLog : _("None");
		// #. %d is the number of successfully imported data records
		textM = format(_("Successfully imported: %d"), successfullImported);		
		oCi_import_data.openWindow();
	} else {
		oCi_import_data.closeWindow();
		triggerEvent("OX_New_Error", 4, _("Internal Error: The server didn't provide any data."));
	}
	$("cms_import_status").firstChild.data = textM;
}

function toggleConfigTree(){
	if (document.getElementsByName('cs_import_type')[0].checked == true){
		clickedItem = configGetKey("folder.calendar");
	} else {
		clickedItem = configGetKey("folder.contacts");
	}
	
	initImportTree();
	
	if ($("TreeDialogImportForlder").style.display == "none"){
		$("TreeDialogImportForlder").style.display = "block";
		$("TreeDialogImportForlder").style.top = "230px";
		$("TreeDialogImportForlder").style.left = "420px";
	}else{
		$("TreeDialogImportForlder").style.display = "none";
	}
		
}

function initImportTree() {		
		
	importDataFolderTree = null;
	removeChildNodes($("folder_tree_info"));
	importDataFolderTree = new cFolderTree(	$('folder_tree_info'),
										folderConfigAction,										
										false,
										oMainFolderTree.cache,
										optFolderState.getState('folder_tree_info'));
	if (document.getElementsByName('cs_import_type')[0].checked == true){
		if (oCi_import_data.combobox.getKey() == "calendar"){
			importDataFolderTree.enabled_modules = {calendar:true};
		} else {
			importDataFolderTree.enabled_modules = {tasks:true};
		}
	} else {
		importDataFolderTree.enabled_modules = {contacts:true};
	}
	importDataFolderTree.setSaveConfiguration(optFolderState);	
	importDataFolderTree.load();
}


function cb_getpath(sPath) {
	document.getElementsByName('importFolderInput')[0].value = sPath;
	
}

function setFolder(fId){
	importFolderId = fId;
	oMainFolderTree.get_folder_path(fId, cb_getpath);
}

function folderConfigAction(ofolder) {
	importFolderDestination = ofolder;
	var OXFolder = ofolder.oxfolder;
	toggleConfigTree();
	clickedItem = OXFolder.data.id;
	setFolder(clickedItem);
}

fileloaded();