/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerProxy
implements Receiver,
Locator {
    private PipelineConfiguration pipe;
    private String systemId;
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    private LocationProvider locationProvider;
    private int depth = 0;
    private boolean requireWellFormed = false;
    private boolean undeclareNamespaces = false;
    private Stack elementStack = new Stack();
    private Stack namespaceStack = new Stack();
    protected AttributeCollectionImpl pendingAttributes;
    private int pendingElement = -1;
    private int currentLocationId;
    private static final String marker = "##";

    public void setUnderlyingContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public ContentHandler getUnderlyingContentHandler() {
        return this.handler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
        this.locationProvider = pipelineConfiguration.getLocationProvider();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws XPathException {
    }

    public void setOutputProperties(Properties properties) throws XPathException {
        String string = properties.getProperty("{http://saxon.sf.net/}require-well-formed");
        if (string != null) {
            this.requireWellFormed = string.equals("yes");
        }
        if ((string = properties.getProperty("undeclare-prefixes")) != null) {
            this.undeclareNamespaces = string.equals("yes");
        }
    }

    public boolean isRequireWellFormed() {
        return this.requireWellFormed;
    }

    public void setRequireWellFormed(boolean bl) {
        this.requireWellFormed = bl;
    }

    public boolean isUndeclareNamespaces() {
        return this.undeclareNamespaces;
    }

    public void setUndeclareNamespaces(boolean bl) {
        this.undeclareNamespaces = bl;
    }

    public void open() throws XPathException {
        this.pendingAttributes = new AttributeCollectionImpl(this.getPipelineConfiguration().getConfiguration().getNamePool());
        if (this.handler == null) {
            throw new DynamicError("ContentHandlerProxy.startDocument(): no underlying handler provided");
        }
        try {
            this.locationProvider = this.getPipelineConfiguration().getLocationProvider();
            this.pendingAttributes.setLocationProvider(this.locationProvider);
            this.handler.setDocumentLocator(this);
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
        this.depth = 0;
    }

    public void close() throws XPathException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
    }

    public void startDocument(int n) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        ++this.depth;
        if (this.depth <= 0 && this.requireWellFormed) {
            this.notifyNotWellFormed();
        }
        this.pendingElement = n;
        this.currentLocationId = n3;
        this.namespaceStack.push(marker);
    }

    public void namespace(int n, int n2) throws XPathException {
        if (n == 65537) {
            return;
        }
        NamePool namePool = this.pipe.getConfiguration().getNamePool();
        String string = namePool.getPrefixFromNamespaceCode(n);
        String string2 = namePool.getURIFromNamespaceCode(n);
        if (!this.undeclareNamespaces && "".equals(string2) && !"".equals(string)) {
            return;
        }
        try {
            this.handler.startPrefixMapping(string, string2);
            this.namespaceStack.push(string);
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        int n5 = this.pendingAttributes.getIndexByFingerprint(n & 0xFFFFF);
        if (n5 < 0) {
            this.pendingAttributes.addAttribute(n, n2, ((Object)charSequence).toString(), n3, n4);
        } else {
            this.pendingAttributes.setAttribute(n5, n, n2, ((Object)charSequence).toString(), n3, n4);
        }
    }

    public void startContent() throws XPathException {
        try {
            NamePool namePool = this.pipe.getConfiguration().getNamePool();
            if (this.depth > 0 || !this.requireWellFormed) {
                String string = namePool.getURI(this.pendingElement);
                String string2 = namePool.getLocalName(this.pendingElement);
                String string3 = namePool.getDisplayName(this.pendingElement);
                this.handler.startElement(string, string2, string3, this.pendingAttributes);
                this.elementStack.push(string);
                this.elementStack.push(string2);
                this.elementStack.push(string3);
                this.pendingAttributes.clear();
                this.pendingElement = -1;
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof XPathException) {
                throw (XPathException)exception;
            }
            if (exception instanceof SchemaException) {
                throw new DynamicError(exception);
            }
            throw new DynamicError(sAXException);
        }
    }

    public void endElement() throws XPathException {
        String string;
        if (this.depth > 0) {
            try {
                string = (String)this.elementStack.pop();
                String string2 = (String)this.elementStack.pop();
                String string3 = (String)this.elementStack.pop();
                this.handler.endElement(string3, string2, string);
            }
            catch (SAXException sAXException) {
                throw new DynamicError(sAXException);
            }
        }
        while (!(string = (String)this.namespaceStack.pop()).equals(marker)) {
            try {
                this.handler.endPrefixMapping(string);
            }
            catch (SAXException sAXException) {
                throw new DynamicError(sAXException);
            }
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        boolean bl;
        this.currentLocationId = n;
        boolean bl2 = bl = (n2 & 1) != 0;
        if (bl) {
            this.setEscaping(false);
        }
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                if (!Whitespace.isWhite(charSequence)) {
                    this.notifyNotWellFormed();
                }
            } else {
                this.handler.characters(((Object)charSequence).toString().toCharArray(), 0, charSequence.length());
            }
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
        if (bl) {
            this.setEscaping(true);
        }
    }

    protected void notifyNotWellFormed() throws XPathException {
        DynamicError dynamicError = new DynamicError("The result tree cannot be supplied to the ContentHandler because it is not well-formed XML");
        dynamicError.setErrorCode("SXCH0002");
        throw dynamicError;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        this.currentLocationId = n;
        try {
            this.handler.processingInstruction(string, ((Object)charSequence).toString());
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        this.currentLocationId = n;
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(((Object)charSequence).toString().toCharArray(), 0, charSequence.length());
            }
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException);
        }
    }

    private void setEscaping(boolean bl) {
        try {
            this.handler.processingInstruction(bl ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.locationProvider.getLineNumber(this.currentLocationId);
    }

    public int getColumnNumber() {
        return -1;
    }
}

