/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

var oUnreadCounterStorage = null;
var newFolderJson = new JSON();
var disableNodeActions = false; //Edit modus
var folderTreeFolderToMove = -1;
var configfolder;
var oMainFolderTree;
var nSelectedIdStorage = null;
var virtualFolderId = "__ox_virtualFolderNode";

function quickTreeUpdate() {
	oMainFolderTree.update();
	if (oUnreadCounterStorage) {
		oUnreadCounterStorage.update();
	}
}

function saveFolderStateInConfig(id) {      
    configSetKey('gui.FolderTreeState', oMainFolderTree.getState());
}

register("OX_Configuration_Load_Foldertree", loadFolderTree);
register('OX_Refresh', quickTreeUpdate);
registerView("configuration",
	function() {
		$("folder_tree").style.display="none";
	},
	null,
	function() {
		$("folder_tree").style.display="block";
	},
	null
);

var nTimeOutScrollTree;
function loadFolderTree(stateTree,nSelectedIdStorage) {
	var aFolderViewSettings = new Object();
	var aFolderViewSettingsBM = new Object();
	var disableOther=false;
	var oFolderTreeState = new Object();
	if (configContainsKey('gui.FolderTreeState')) oFolderTreeState = configGetKey('gui.FolderTreeState');	

	/*
	 * sub-context folder creation hack
	 * @todo: should be replaced as soon as we have a new context-menu which 
	 * supports sub-context menus from the scratch!  
	 */ 	
	var contDiv = newnode("div",{ display:"none", position:"absolute", zIndex:"1001" },{ className: "PopupMenuDiv background-color-popup-menu border-color-popup-menu font-size-small" });
	var subFolderPopup = new Popup($("everything"), contDiv);
	subFolderPopup.opt = null;
	
	/**
	 * key handler, used to remove the virtual node if ESC
	 * has been pressed while entering a name!
	 */
	var fn_subfolder_keyHandler = function(event) {
		if (event == undefined || event.keyCode != 27) return;		
		var parentFolder = removeVirtualFolder(virtualFolderId);
		if (parentFolder) {
			oMainFolderTree.update_sub_tree(parentFolder);			
		}
	}	
    register("OX_Dummy", fn_subfolder_keyHandler);
	
	/*
	 * click handler when selecting a folder type
	 */
    var fn_subfolder_click = function(e, type) {
    	contextAction(1,e,subFolderPopup.opt,type);
    	if (!subFolderPopup || !subFolderPopup.div) return;
            setTimeout(function() {
                  subFolderPopup.div.style.display="none"; 
                }, 50);
    }
    /*
     * sub-context mouse-over handler
     * enables the sub-context popup
     */
    var fn_subfolder_mouseover = function(e, node, opt) {
    	if (opt) subFolderPopup.opt = opt;
        // sub-context menu still enabled, so return
        if (subFolderPopup.div.style.display == "block") return;

        // check folder permission, are we allowed to create sub-folders on the parent node?
        var canCreateFolder = true;
        var oFolderN = oMainFolderTree.get_folder_by_node_id(opt.id);
        var module = "mail", id;
        if(oFolderN != undefined) {
	        var OXFolder = oFolderN.oxfolder;
	        var oFolder  = OXFolder.data;
	        var oRights  = oFolder.own_rights;
	        var oNode = opt;      	        
	        if((getPermAsString(true, oRights, 0).bit < 4 && oFolder.module != 'mail') || 
	           (oFolder.module == 'mail') && !(getPermAsString(false, oFolder.own_rights, 0).bit>=4)) {
	            canCreateFolder = false;   
	        }
	        module = oFolder.module;
	        // module system and name default is the parent root mail folder
	        if (oFolder.module == "system" && String(oFolder.id).match(/^default/)) module = "mail";            	        
        } else {
        	canCreateFolder = false;
        }
        
        if (!canCreateFolder) return; // no permission, no popup

        // draw popup rows
        subFolderPopup.clear();
        subFolderPopup.append(_("E-Mail"), function(e) { 
	        fn_subfolder_click(e, "mail");
	    }, null, !(canCreateFolder & configGetKey("modules.mail.module") & (module == "mail")));
	    subFolderPopup.append(_("Calendar"), function(e) { 
	        fn_subfolder_click(e, "calendar");
	    }, null, !(canCreateFolder & configGetKey("modules.calendar.module") & (module != "mail" && module != "infostore")));
	    subFolderPopup.append(_("Tasks"), function(e) { 
	        fn_subfolder_click(e, "tasks");
	    }, null, !(canCreateFolder & configGetKey("modules.tasks.module") & (module != "mail" && module != "infostore")));
	    subFolderPopup.append(_("Contacts"), function(e) { 
	        fn_subfolder_click(e, "contacts");
	    }, null, !(canCreateFolder & configGetKey("modules.contacts.module") & (module != "mail" && module != "infostore")));
	    subFolderPopup.append(_("Infostore"), function(e) { 
            fn_subfolder_click(e, "infostore");
        }, null, !(canCreateFolder & configGetKey("modules.infostore.module") & module == "infostore"));

    	var found = false;
    	try {
            for (var n = e.relatedTarget || e.toElement; n; n = n.parentNode) {
                if ((node && n == node.div) || n == subFolderPopup.div) found = true;
            }                                
        } catch (ex) { }
        if (!found) return; // parent doesn't match so nothing to do
        
        // enable sub-context popup
        subFolderPopup.div.style.width = node.div.offsetWidth + "px";
        subFolderPopup.div.style.left = getAbsolutePositionLeft(node.div) + node.div.offsetWidth + "px";
        subFolderPopup.div.style.top = getAbsolutePositionTop(node.div) + "px";
        subFolderPopup.div.style.display="block";
        
        /*
	    displayAt(subFolderPopup.div,
	       getAbsolutePositionLeft(node.div) + node.div.offsetWidth + "px",
	       getAbsolutePositionTop(node.div) + "px");
        */
    };
    /*
     * sub-context mouse-out handler
     * hides the sub-context popup
     */
	var fn_subfolder_mouseout = function(e, node, opt) {
		if (opt) subFolderPopup.opt = opt;	// updating selected folder information
        if (subFolderPopup.div.style.display == "none") return;
		try {
			for (var n = e.relatedTarget || e.toElement; n; n = n.parentNode) {
                if ((node && n == node.div) || n == subFolderPopup.div) return;
			}                
        } catch (ex) { }
        //fade(subFolderPopup.div,100,0,500);
        subFolderPopup.div.style.display = "none";
	};
	// leaving the popup div should close the sub-context popup
    addDOMEvent(subFolderPopup.div, "mouseout", fn_subfolder_mouseout);
    // global click should close the sub-context popup as well    
    addDOMEvent(body, "click", function() {     	       
		    	if (!subFolderPopup || !subFolderPopup.div) return;
	            setTimeout(function() {
	                  subFolderPopup.div.style.display="none"; 
	                }, 50);
            });
	
	// new folder
    var sNode = addContextNode(
        contextmenu_createImgDiv("New subfolder" /*i18n*/,
            getFullImgSrc("img/folder/newfolder.gif"),
            getFullImgSrc("img/folder/newfolder_d.gif"),
            getFullImgSrc("img/arrows/arrow_darkgrey_right.gif"),
            getFullImgSrc("img/arrows/arrow_gray_right.gif")),
        ["folder_tree_tree"],
        function() {
        	return true;            
        },
		function (entryobject,optparam) {
			var oFolderN = oMainFolderTree.get_folder_by_node_id(optparam.id);
			if(oFolderN == undefined)
				return false;
			var OXFolder = oFolderN.oxfolder;			
			//TODO check it before
			oMainFolderTree.set_dashed(optparam);
			var oFolder  = OXFolder.data;
			var oRights  = oFolder.own_rights;
			var oNode = optparam;
			if((getPermAsString(true, oRights, 0).bit < 4 && oFolder.module != 'mail') || (oFolder.module == 'mail') 
													&& !(getPermAsString(false, oFolder.own_rights, 0).bit>=4)) {
				return false;	
			}
			return true;
		}, null, contextmenu_setDisabled, fn_subfolder_mouseover,
		fn_subfolder_mouseout, null, contextmenu_setEnabled, null, null,
		"folder_tree_tree_new_folder_sub");
	
    // subscribe folder
    addContextNode(contextmenu_createImgDiv("Subscribe folder",/*i18n*/
        getFullImgSrc("img/dummy.gif"),getFullImgSrc("img/dummy.gif")),
        ["folder_tree_tree"],
        function(event,loadparams,optparam) { 
            SubscribeFolder.openWindow();
        },
        function(entryparams,optparam) {
            return true;
        },
        function(entryparams,optparam) {
            var myfolder=oMainFolderTree.get_folder_by_node_id(optparam.id);
            if (myfolder && myfolder.oxfolder.data.module=="mail") {
                return true;
            } 
            return false;   
        },
        contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
        
    /* send as link */
    addContextNode(contextmenu_createImgDiv("Send as link", /*i18n*/
        getFullImgSrc("img/menu/save_as_link.gif"),getFullImgSrc("img/menu/save_as_link_d.gif")),["folder_tree_tree"],
        function(event,loadparams,optparam) {         	
        	var myfolder=oMainFolderTree.get_folder_by_node_id(optparam.id);
        	if (myfolder && myfolder.oxfolder.data) {        	
                infostore_sendLink([{ data: { folder_id: myfolder.oxfolder.data.id, module: myfolder.oxfolder.data.module }}]);
        	}
        }, function(entryparams,optparam) {
            var oFolderN = oMainFolderTree.get_folder_by_node_id(optparam.id);
	        if(oFolderN == undefined)
	            return false;
	        var OXFolder = oFolderN.oxfolder;
            var rights=OXFolder.data.own_rights;
            var myrights = computePerm(rights,7);
            if((myrights && myrights>0)) {
                return true;
            }
	        return false;
        },null,contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
    
	addContextLine(null,["folder_tree_tree"]);
	
	// delete
	addContextNode(contextmenu_createImgDiv("Delete",/*i18n*/
		getFullImgSrc("img/menu/delete_folder.gif"),getFullImgSrc("img/menu/delete_folder_d.gif")),["folder_tree_tree"],function(event,loadparams,optparam) { contextAction(2,event,optparam); },
	function(entryparams,optparam) {
		var oFolderN = oMainFolderTree.get_folder_by_node_id(optparam.id);
		if(oFolderN == undefined)
			return false;
		var OXFolder = oFolderN.oxfolder;	
		if(!deleteAllowed(OXFolder)) { return false; }
		return true;
	},null,contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
	
	// rename
	addContextNode(contextmenu_createImgDiv("Rename",/*i18n*/
		getFullImgSrc("img/folder/renamefolder.gif"),getFullImgSrc("img/folder/renamefolder_d.gif")),["folder_tree_tree"],function(event,loadparams,optparam) { contextAction(3,event,optparam); 	stopEvent(event);		 },
	function(entryparams,optparam) {
		var oFolderN = oMainFolderTree.get_folder_by_node_id(optparam.id);
		if(oFolderN == undefined)
			return false;
		var OXFolder = oFolderN.oxfolder;	
		if(!renamingAllowed(OXFolder)) { return false; }
		return true;
	},null,contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
	
	// cut
	addContextNode(contextmenu_createImgDiv("Cut",/*i18n*/
		getFullImgSrc("img/folder/cutfolder.gif"),getFullImgSrc("img/folder/cutfolder_d.gif")),["folder_tree_tree"],function(event,loadparams,optparam) { contextAction(5,event,optparam); },
	function(entryparams,optparam) {
		var oFolderN = oMainFolderTree.get_folder_by_node_id(optparam.id);
		if(oFolderN == undefined)
			return false;
		var OXFolder = oFolderN.oxfolder;			
		if(!deleteAllowed(OXFolder)) { return false; }
		return true;
	},null,contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
	
	// paste
	addContextNode(contextmenu_createImgDiv("Paste",/*i18n*/
		getFullImgSrc("img/folder/pastefolder.gif"),getFullImgSrc("img/folder/pastefolder_d.gif")),["folder_tree_tree"],function(event,loadparams,optparam) { contextAction(6,event,optparam); },
	function(entryparams,optparam) {
		var oFolderN = oMainFolderTree.get_folder_by_node_id(optparam.id);
		if(oFolderN == undefined)
			return false;
		var OXFolder = oFolderN.oxfolder;				
		if(folderTreeFolderToMove == -1 || !moveAllowed (folderTreeFolderToMove.parent, 
														folderTreeFolderToMove,
														oFolderN)) { return false; }
		return true;
	},null,contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
	
	// single line
	addContextLine(null,["folder_tree_tree"],
	function(entryparams,optparam) {
		var oFolderN = oMainFolderTree.get_folder_by_node_id(optparam.id);
		if(oFolderN == undefined)
			return false;
		var OXFolder = oFolderN.oxfolder;					
		if (OXFolder.data.module=="mail") {
			var rights=OXFolder.data.own_rights;
			var myrights = computePerm(rights,21);
			if((myrights && myrights>0)) {
				return true;
			}
		} 
		return false;	
	});	
	
	// empty folder
	addContextNode(contextmenu_createImgDiv("Empty folder",/*i18n*/
		getFullImgSrc("img/folder/empty_folder.gif"),getFullImgSrc("img/folder/empty_folder_d.gif")),["folder_tree_tree"],function(event,loadparams,optparam) { contextAction(8,event,optparam); },
	function(entryparams,optparam) {
		return true;
	},function(entryparams,optparam) {
		var myfolder=oMainFolderTree.get_folder_by_node_id(optparam.id);
		if (myfolder && myfolder.oxfolder.data.module=="mail") {
			var rights=myfolder.oxfolder.data.own_rights;
			var myrights = computePerm(rights,21);
			if((myrights && myrights>0)) {
				return true;
			}
		} 
		return false;	
	},contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
	
	// single line
	addContextLine(null,["folder_tree_tree"]);	
	addContextNode(contextmenu_createImgDiv("Properties",/*i18n*/
		getFullImgSrc("img/folder/propertiesfolder.gif"),getFullImgSrc("img/folder/propertiesfolder_d.gif")),["folder_tree_tree"],function(event,loadparams,optparam) { contextAction(7,event,optparam); },
	function(entryparams,optparam) {
		return true;
	},null,contextmenu_setDisabled,null,null,null,contextmenu_setEnabled);
	
		
	if(!oMainFolderTree) {
		oMainFolderTree = new cFolderTree($('folder_tree'),folderAction, true,new ox_folder_cache(),
																				oFolderTreeState);
		oMainFolderTree.select_for_action = true;
		oMainFolderTree.inplace_enabled = true;
		oMainFolderTree.show_new_messages = true;
		oMainFolderTree.enable_quick_info = true;
		oMainFolderTree.toggle_cursor = true;	
		oMainFolderTree.context_menu_enabled = true;
		oMainFolderTree.register_update = true;
		oMainFolderTree.load();
		oUnreadCounterStorage = new unreadCounterStorage(oMainFolderTree);
		oUnreadCounterStorage.events.register("Count_Changed",setUnreadNumber);		
		triggerEvent("updateAllNewMailNumbers_Created");
	}

	if (oUnreadCounterStorage) {
		oUnreadCounterStorage.update();		
	}

	oMainFolderTree.tree.events.register("OX_Tree_State_Changed", saveFolderStateInConfig);
	//register scrolling targets
	var oFolderTreeScrollDiv = $('folder_tree');
	function treeScrollUp()
	{		
		if(!oFolderTreeScrollDiv.scrollTop && oFolderTreeScrollDiv.scrollTop!=0)
		{
			oFolderTreeScrollDiv.scrollTop = 0;
		}
		else (oFolderTreeScrollDiv.scrollTop-15 < 0)
	 	{
			oFolderTreeScrollDiv.scrollTop = oFolderTreeScrollDiv.scrollTop - 15;
	 	}
		nTimeOutScrollTree = setTimeout(treeScrollUp,150);
	}
	function treeScrollDown() {				
		if (!oFolderTreeScrollDiv.scrollTop && oFolderTreeScrollDiv.scrollTop != 0) {
			oFolderTreeScrollDiv.scrollTop = 0;
		} else {
			oFolderTreeScrollDiv.scrollTop = oFolderTreeScrollDiv.scrollTop + 15;
	 	}
		nTimeOutScrollTree = setTimeout(treeScrollDown,150);		
	}
	var emptyfunction = function() {}
	var callbacks = new Object();
	callbacks["folder/1"]=emptyfunction;
	callbacks["folder/2"]=emptyfunction;
	callbacks["folder/3"]=emptyfunction;
	callbacks["folder/7"]=emptyfunction;
	callbacks["mailaddress"]=emptyfunction;
	callbacks["calendar"]=emptyfunction;
	callbacks["tasks"]=emptyfunction;
	callbacks["infostore"]=emptyfunction;
	callbacks["mail"]=emptyfunction;
	callbacks["contacts"]=emptyfunction;
	callbacks["CALENDAR_MONTH"]=emptyfunction;	

	registerTarget($("test0008"),callbacks,null,null,treeScrollUp);
	registerTarget($("test0009"),callbacks,null,null,treeScrollDown);	
	function cleartreeScrollTimeOut() {
		if(nTimeOutScrollTree != undefined)
			clearTimeout(nTimeOutScrollTree);		
	}
	addDOMEvent($("test0008"), "mouseout", cleartreeScrollTimeOut);
	addDOMEvent($("test0009"), "mouseout", cleartreeScrollTimeOut);	
	//addDOMEvent($("test0008"), "mousedown", cleartreeScrollTimeOut);
	//addDOMEvent($("test0009"), "mousedown", cleartreeScrollTimeOut);		
}

/**
 * Execute if folder clicked
 */
function folderAction(cacheFolder, treeNode) {
	var OXFolder = cacheFolder.oxfolder;
	var sameFolder = false;
	var sModule =  OXFolder.data.module;
	if (sModule == "system" && OXFolder.data.id == "default") {
		// If user clicks on the root folder 'E-Mail' we directly jump to the inbox
        activemodule = "mail";
        setActiveFolder(configGetKey("modules.mail.defaultFolder.inbox"), function() {
        	   triggerEvent("OX_Switch_Module", "mail");
        	});
        return;
	} else if (onlyParentFunc(OXFolder)) {
		// folder has no read permission, so we just open/close it	
		treeNode.setOpen(!treeNode.open);
		return;		
	}
	
	// select folder, change module and so on ...
	sameFolder = (activefolder == OXFolder.data.id);
	activemodule = sModule;
	activefolder = OXFolder.data.id;	
	triggerEvent("OX_Switch_Module", sModule, (sameFolder ? "samefolder" : "newfolder"), activefolder);
}

//Execute if context menu item clicked
function contextAction(nNumber,evt,node,type) {
	var oTreeNode = node;
	var aTmp2 = oTreeNode.id.split('$');

	var sFolderId = node.data.sId;
	var sModule = node.data.sModule;

	switch (nNumber) {
		case 1:
			//var bNew = true;
			//viewProperties(node,bNew);
			createNewFolderInpl(node,type);
			break;
		case 4:
			editFolder(node.widgetId);
			break;
		case 3:
			node.inpl_edit.on();		
			break;												
		case 2:
			//if the parent does not contain timestamp (oldnamespace imap), use lattest timestamp from tree	
			//nTimeStampRem = oTreeNode.data.timestamp;			
			removeFolder(oMainFolderTree.getFolderID(oTreeNode.id));
			break;
		case 7:
			var bNew = false;
			viewProperties(oTreeNode,bNew);
			break;		
		case 5:
			cutFolder(oTreeNode);
			break;					
		case 6:
			insertFolder(node);
			break;		
		case 8:
			emptyFolder(node);       							
	}
}

/*function to create new folders with inplace method*/
function createNewFolderInpl(parentFolderNode,type) {
	var parentId = parentFolderNode.id.replace(/\$link$/,"");
	var oCacheFolder = oMainFolderTree.get_folder_by_node_id(parentId);	
	function uniqueName(aChildren,sName) {
		for (var nChild in aChildren) {			
			var oCurrChild = oMainFolderTree.get_folder_by_node_id(parentFolderNode.children[nChild].id)			
			if(sName == oCurrChild.oxfolder.data.title)
				return false;		
		}
		return true;
	}
	// inherit rights only if folder isn't a sytem folder (type 5)
	var inheritRights = oCacheFolder.oxfolder.data.type != 5;	
	var aPermissionArray = getNewFolderPerms(oCacheFolder.oxfolder,inheritRights);
	
	/*
	 * give admin permissions to the creator of a folder
	 * if its _not_ a shared folder! then we just inherit the
	 * permissions from the parent folder.
	 */
	if (oCacheFolder.oxfolder.data.type != 3) {
		for (i in aPermissionArray) {
			if (aPermissionArray[i].entity == configGetKey("identifier")) {        
	            aPermissionArray.splice(i,1);
			}
		}
		aPermissionArray.push({ group : false,
		                        bits  : Math.pow(2,6) + Math.pow(2,13) + Math.pow(2,20) + Math.pow(2,27) + Math.pow(2,28),                   
	                            entity: configGetKey("identifier") });
	}
	
	var oFolder  = new Object();
	oFolder['title'] = _("New Folder");
	oFolder["module"]=type;     
    oFolder["id"] = virtualFolderId;
	oFolder['permissions'] = aPermissionArray;		
	oFolder['subscribed'] = 1;
	oFolder["subfolder"] = false;
	oFolder["subscr_subflds"] = false;
	oFolder["summary"] = null;
	oFolder["unread"] = null;		
    oMainFolderTree.display_folder(oCacheFolder.oxfolder.data.id, function() {
    	parentFolderNode = oMainFolderTree.nodes[parentFolderNode.id.replace(/\$link$/,"")];
        oMainFolderTree.scroll_to(parentFolderNode);
        oMainFolderTree.expand_node(parentFolderNode, function() {
        	function cb_final() {
        		// hack to get childrens of main infostore folder
        		// instead of the my-infostore folder
        		if (parentId.match(/^folder_tree\$60/)) {
        			oCacheFolder = oMainFolderTree.get_folder_by_node_id(parentId);
        		}
                var nCounter = 1;
                while(!uniqueName(parentFolderNode.children, oFolder['title'])) {
                	oFolder['title'] = _("New Folder") + " " + nCounter;     
                    nCounter++;
                }
                if (oCacheFolder.children == undefined) oCacheFolder.children = new Object();	                
                oCacheFolder.children[oFolder["id"]] = { 
                              oxfolder: { data: oFolder, ENABLED: true, timestamp: null }, 
                              parent: parentFolderNode, children: null 
                          };
                          
                oMainFolderTree.cache.fast_access[oFolder["id"]] = oCacheFolder.children[oFolder["id"]];  
                oMainFolderTree.update_sub_tree(oCacheFolder);
                oMainFolderTree.set_selected(oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])]);
                oMainFolderTree.set_dashed(oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])]);
                setTimeout(function() {
                    oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])].inpl_edit.really_edit_check=false;
                    oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])].inpl_edit.on();
                }, 0);
            }
            if (!parentFolderNode.open) parentFolderNode.setOpen(true);
            setTimeout(cb_final, 0);
        });
    });	
}

function cutFolder(node) {	
	var oCacheFolder = oMainFolderTree.get_folder_by_node_id(node.id);
    if (folderTreeFolderToMove != oCacheFolder) {
        if(folderTreeFolderToMove != -1) {
            var oldNode = folderTreeFolderNodeToMove;
            oldNode.closedIcon = enableIcon(oldNode.closedIcon);
            oldNode.openIcon = enableIcon(oldNode.openIcon);
            oldNode.updateIcon();
        }
        //store id
        folderTreeFolderToMove = oCacheFolder;
        folderTreeFolderNodeToMove = node;
        //change image
        node.closedIcon = disableIcon(node.closedIcon);
        node.openIcon = disableIcon(node.openIcon);	
        node.updateIcon();
        //TODO Cancel
    }
}

function enableIcon(sIcon) {
	var sOldIcon = sIcon;	
	var aTMP = sOldIcon.split('/');
	var newIcon = '';
	for (nInd = 0; nInd < aTMP.length; nInd++) {
		if (nInd < aTMP.length-1) {
			newIcon += aTMP[nInd] + '/';
		} else {
			var aTMP2 = aTMP[nInd].split('.');
			var sEnd = aTMP2[1];
			var aTMP3 = aTMP2[0].split('_');
			for (ind2 = 0; ind2 < aTMP3.length; ind2++){
				if(ind2 < aTMP3.length-1 && ind2 == 0) {
					newIcon += aTMP3[ind2];
				} else if (ind2 < aTMP3.length-1) {
					newIcon += '_' + aTMP3[ind2];
				} else {
					newIcon += '.'+sEnd;
				}
			}
		}
	}	
	return newIcon;					
}

function insertFolder(node) {	
	var targetFolder = oMainFolderTree.get_folder_by_node_id(node.id);
	//reset image
	if (folderTreeFolderToMove != -1) {
		var	currFolder = folderTreeFolderToMove;
		var sImageSRC = getFullImgSrc("img/folder/folder_closed.gif");									
		node.closedIcon = sImageSRC;
		folderServerMove(currFolder.parent,currFolder,targetFolder,false);
	}
}

function emptyFolder(node) {
	var targetNode = node;
	var text="";
	if(!configGetKey("mail.deletemail") && oMainFolderTree.getFolderID(node.id) != configGetKey("mail.folder.trash")) {
		text="Are you sure you want to delete all E-Mails? Deleted E-Mails will be moved to the Trash."; /*i18n*/
	} else {
		text="Are you sure you want to permanently delete all E-Mails? Permanently deleted E-Mails can not be recovered."; /*i18n*/
	}
	function cbok() {
		var id;
		var folderobject;
		function cbcache(myid) {
			folderobject=myid
			newFolderJson.put(AjaxRoot + "/mail?action=clear&session="+session, [id],null,
			function(cb){
				if (cb.data.length) { }
				oMainFolderTree.update(null,true,function () { });
				triggerEvent("OX_Folder_Cleared",id);	
				if (oUnreadCounterStorage) oUnreadCounterStorage.update();
			});
		}
		id=oMainFolderTree.getFolderID(node.id);
		oMainFolderTree.cache.get_folder(id,cbcache);
	}
	newConfirm(_("Empty folder"),_(text),AlertPopup.YESNO,null,null,cbok,null,null);
}

function editFolder(node) {
	propertiesPopUp = newWindow("editProps.html", getWindowOptions());
	propertiesPopUp.focus();
}

var oChangedParentFolder = null;
function viewProperties(node,bNew) {		
	var oCacheFolder = oMainFolderTree.get_folder_by_node_id(node.id);
	var OXFolder = oCacheFolder.oxfolder;
	var sFolderId = OXFolder.data.id;	
	setActiveFolder(sFolderId);
	activemodule = 'configuration';			
	configparentfolder = (bNew)?sFolderId:-1;
	oChangedParentFolder = configparentfolder;
	configfolder = sFolderId;
	if(configparentfolder != -1) {
		var bRightsSupported = true;
		if ((oCacheFolder.oxfolder.data.module == "mail" || oCacheFolder.oxfolder.data.id == "default")	 //check capabilities here
										 && !(oCacheFolder.oxfolder.data.capabilities & Math.pow(2,0)))
			bRightsSupported = false;		
		if (bRightsSupported) {
			openNewDialog(function (bY) {openJumpToNewForm(oCacheFolder,bY,true);}, oCacheFolder);
		} else {
			openJumpToNewForm(oCacheFolder,false,true)
		}
	} else {
		fn_actionFolder(oCacheFolder);
	}	
}

/**
 * Renaming folder part 
 */
var editableNode;
function renameFolder(sId,oFolder) {	
	oMainFolderTree.cache.get_folder(sId, function(oCacheFolder) {
		function cb_rename_fd(arg) {
            removeVirtualFolder(virtualFolderId);			
			if (!arg.error) {				
				// redraw view and, if possible, scroll to new position
                oMainFolderTree.update(null, (oCacheFolder.oxfolder.data.module=="mail"), function() {
				    if (arg.data) {				    	
				    	oMainFolderTree.display_folder(arg.data, function() {				    		
				    		if (activefolder && sId && sId == activefolder) {
	                            oMainFolderTree.scroll_to(
	                                oMainFolderTree.nodes[oMainFolderTree.getDOMID(arg.data)]
	                            );	                           
	                            setActiveFolder(arg.data, null, true);
	                            folderAction(oMainFolderTree.cache.fast_access[arg.data]);
				    		}
				    	});
				    }
				});
			}
		}
		if (oCacheFolder != undefined) {
			// if it's the virtual folder node we do have to fire-up a new call 
			// instead of an update
		    if (sId && sId == virtualFolderId) {		    	
		    	var parentId = oMainFolderTree.get_folder_by_node_id(oCacheFolder.parent.id.replace(/\$link$/,"")).oxfolder.data.id;
		    	// prepare folder object for the new request
		    	var nFolder = clone(oCacheFolder.oxfolder.data);
		    	nFolder.title = oFolder.title;
		    	delete(nFolder.id);
		    	delete(nFolder.subscr_subflds);
		    	delete(nFolder.subfolder);
		    	delete(nFolder.summary);
		    	delete(nFolder.unread);
		    	delete(nFolder.type);
	            doAjaxNewFolderRequest(parentId, nFolder, cb_rename_fd, cb_rename_fd);	        
	        } else {
	        	// if the parent does not contain timestamp (oldnamespace imap), 
                // use lattest timestamp from tree
                var nTimeStampRename = oCacheFolder.oxfolder.timestamp || oMainFolderTree.cache.timestamp;
	        	doAjaxUpdateRequest(sId,oFolder, nTimeStampRename, cb_rename_fd);
	        }
		}
	});
}

/**
 * Deleting folder part
 */
function removeFolder(folderId, optional_fn) {
	function cbyes() {
		oMainFolderTree.cache.get_folder(folderId, function(oCacheFolder) {
			function cb_remove_fd(arg) {
				if (!arg.error) {
	                oMainFolderTree.update(null, (oCacheFolder.oxfolder.data.module=="mail"), function() {
	                	var parentFolder = oCacheFolder.parent.id ? 
                                oMainFolderTree.get_folder_by_node_id(oCacheFolder.parent.id) : 
                                oCacheFolder.parent;
                        // We select the parent folder of the prior deleted folder ONLY if the user 
                        // isn't on the portal and the prior deleted folder is still selected.
	                	if (parentFolder && activemodule != "portal" && activefolder == folderId) {
	                        // If the parent is one of the system folder on the root level, we take 
	                        // one of the default folders of the current active module. 		
	                        var pId = parentFolder.oxfolder.data.id;	                        
	                        if (parentFolder.oxfolder.data.module=="system" && 
	                            configContainsKey("folder."+activemodule)) {
	                           pId = configGetKey("folder."+activemodule);
	                           parentFolder = oMainFolderTree.cache.fast_access[pId];
	                        }
	                        setActiveFolder(pId, null, true);
	                        folderAction(parentFolder);
	                	}
	                });
					if(optional_fn) optional_fn();
				} else {
					newServerError(arg);
				}
			}
			var nTimeStamp = oCacheFolder.oxfolder.timestamp || oMainFolderTree.cache.timestamp;
			doAjaxRemoveFolderRequest([ oCacheFolder.oxfolder.data.id ], nTimeStamp, cb_remove_fd);	
		});
	}
	newConfirm(_("Delete Folder"),
	       _('Are you sure you want to delete the selected folder?'),
	       AlertPopup.YESNO, null, null, cbyes, null);
}

/**
 * Removing the virtual folder node
 * @param {String} The folder id
 * @return null, or the parent folder object
 */
function removeVirtualFolder(folderID) {
    var folderObj = oMainFolderTree.cache.find_folder(folderID);
    if (!folderObj) return; // nothing found
    
    // remove node from fast access cache
    delete(oMainFolderTree.cache.fast_access[folderID]);
    
    // remove node from DOM tree
    if (folderObj.parent) {
    	folderObj.parent.removeChild(oMainFolderTree.nodes[oMainFolderTree.getDOMID(folderID)]);
        delete(oMainFolderTree.nodes[oMainFolderTree.getDOMID(folderID)]);
    }
    
    // remove node from folder cache
    var parentFolder = folderObj.parent ? oMainFolderTree.get_folder_by_node_id(folderObj.parent.id) : null;	
    if (parentFolder && parentFolder.children) {
    	delete(parentFolder.children[folderID])
    	if (isEmpty(parentFolder.children)) parentFolder.children = null;
    }
    
    return parentFolder;
}

fileloaded();