/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.admin.console;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;


/**
 * {@link AppRunner}
 *
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 *
 */
public class AppRunner {
    private static final String MAIN = "main";

    private static final ExecutorService executionService = Executors.newSingleThreadExecutor();
    
    public void run(Class<?> klass, String...arguments) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InterruptedException {
        Method method = grabMain(klass);
        executeMain(method, arguments);
    }

    private void executeMain(Method mainMethod, String[] arguments) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InterruptedException {
        List<Callable<Object>> list = new ArrayList<Callable<Object>>();
        list.add(new MethodCall(mainMethod, null, (Object) arguments));
        
        List<Future<Object>> all = executionService.invokeAll(list, 60  , TimeUnit.SECONDS);
        if(!all.get(0).isDone()) {
            throw new IllegalStateException("Execution was terminated prematurely.");
        }
    
    }

    private Method grabMain(Class<?> klass) throws SecurityException, NoSuchMethodException {
        return klass.getMethod(MAIN, String[].class);
    }
    
    private static final class MethodCall implements Callable<Object> {

        private Method method;
        private Object object;
        private Object[] arguments;
        
        public MethodCall(Method method, Object object, Object...arguments) {
            this.method = method;
            this.object = object;
            this.arguments = arguments;
        }
        
        public Object call() throws Exception {
            return method.invoke(object, arguments);
        }
        
    }
}
