
# norootforbuild
#!BuildIgnore: post-build-checks
BuildRequires:  ant ant-nodeps ant-apache-regexp ant-trax gettext-devel unzip
Name:           open-xchange-lang
BuildArch:	noarch
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-1.5.0-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%if %{?fedora_version} <= 8
BuildRequires:  java-devel-icedtea saxon
%endif
%endif
Version:	6.14.0.0
%define		ox_release 8
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          I18N
License:        Creative Commons Attribution-Noncommercial-Share Alike 2.5 Generic
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Package containing i18n helper functions
Requires:	open-xchange-gui
#

#------------------------------------------------------------------------------------------
#%package -n	open-xchange-lang-ja-jp
#Group:          I18N
#Summary:	Package containing translation for ja_JP
#
#%description -n open-xchange-lang-ja-jp
#Package containing translation for ja_JP
#
#Authors:
#--------
#    Open-Xchange
#
#%package -n	open-xchange-gui-lang-ja-jp
#Group:          I18N
#Summary:	Package containing translation for ja_JP
#Requires:	open-xchange-lang
#
#%description -n open-xchange-gui-lang-ja-jp
#Package containing translation for ja_JP
#
#Authors:
#--------
#    Open-Xchange

#------------------------------------------------------------------------------------------
#%package -n	open-xchange-lang-pl-pl
#Group:          I18N
#Summary:	Package containing translation for pl_PL
#
#%description -n open-xchange-lang-pl-pl
#Package containing translation for pl_PL
#
#Authors:
#--------
#    Open-Xchange
#
#%package -n	open-xchange-gui-lang-pl-pl
#Group:          I18N
#Summary:	Package containing translation for pl_PL
#Requires:	open-xchange-lang
#
#%description -n open-xchange-gui-lang-pl-pl
#Package containing translation for pl_PL
#
#Authors:
#--------
#    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-es-es
Group:          I18N
Summary:	Package containing translation for es_ES

%description -n open-xchange-lang-es-es
Package containing translation for es_ES

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-es-es
Group:          I18N
Summary:	Package containing translation for es_ES
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-es-es
Package containing translation for es_ES

Authors:
--------
    Open-Xchange


#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-nl-nl
Group:          I18N
Summary:	Package containing translation for nl_NL

%description -n open-xchange-lang-nl-nl
Package containing translation for nl_NL

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-nl-nl
Group:          I18N
Summary:	Package containing translation for nl_NL
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-nl-nl
Package containing translation for nl_NL

Authors:
--------
    Open-Xchange



#------------------------------------------------------------------------------------------
%description

Package containing i18n helper functions

Authors:
--------
    Open-Xchange

%prep
%setup -q -n %{name}-%{version}

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif
mkdir -p %{buildroot}/opt/open-xchange/etc/i18n.d
mkdir -p %{buildroot}/opt/open-xchange/i18n
mkdir -p %{buildroot}/%{docroot}/ox6/lang
mkdir -p %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/
install -m 644 etc/i18nfunctions.sh %{buildroot}/opt/open-xchange/etc/i18nfunctions.sh
export ANT_OPTS="-Dfile.encoding=UTF-8"
ant gui-lang
for lang in es_ES nl_NL; do
	DLANG=${lang/_*}
	test -e $lang/lang.name && \
		install -m 644 $lang/lang.name %{buildroot}/opt/open-xchange/etc/i18n.d/$lang.name
	test -e $lang/server.${lang}.po && \
		install -m 644 $lang/server.${lang}.po \
		%{buildroot}/opt/open-xchange/i18n/server.${lang}.po
	test -e lang/${lang}.js && \
		install -m 644 lang/${lang}.js \
		%{buildroot}/%{docroot}/ox6/lang/${lang}.js
	test -e $lang/tinymce_lang_pack.${lang}.zip && \
		unzip $lang/tinymce_lang_pack.${lang}.zip \
			-d %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/ && \
	find %{buildroot}/%{docroot}/ox6/3rdparty/tinymce -type f -name "*${DLANG}*.js" \
		-printf '"%p"\n' > filelist_${DLANG} && \
		perl -pi -e 's;%{buildroot}/;;' filelist_${DLANG}
done


%clean
%{__rm} -rf %{buildroot}

#------------------------------------------------------------------------------------------
#%post -n open-xchange-gui-lang-ja-jp
#. /opt/open-xchange/etc/i18nfunctions.sh
#addLang ja_JP
#
#%postun -n open-xchange-gui-lang-ja-jp
#. /opt/open-xchange/etc/i18nfunctions.sh
#removeLang ja_JP

#------------------------------------------------------------------------------------------
#%post -n open-xchange-gui-lang-pl-pl
#. /opt/open-xchange/etc/i18nfunctions.sh
#addLang pl_PL
#
#%postun -n open-xchange-gui-lang-pl-pl
#. /opt/open-xchange/etc/i18nfunctions.sh
#removeLang pl_PL

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-es-es
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang es_ES || true

%postun -n open-xchange-gui-lang-es-es
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang es_ES || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-nl-nl
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang nl_NL || true

%postun -n open-xchange-gui-lang-nl-nl
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang nl_NL || true

%files
%defattr(-,root,root)
%dir /opt/open-xchange/etc
%dir /opt/open-xchange/etc/i18n.d
/opt/open-xchange/etc/i18nfunctions.sh
%doc ChangeLog

#------------------------------------------------------------------------------------------
#%files -n open-xchange-lang-ja-jp
#%defattr(-,root,root)
#%dir /opt/open-xchange/i18n
#/opt/open-xchange/i18n/server.ja_JP.po

#%files -n open-xchange-gui-lang-ja-jp -f filelist_ja
#%defattr(-,root,root)
#%dir %{docroot}/ox6/lang
#%{docroot}/ox6/lang/ja_JP.js


#------------------------------------------------------------------------------------------
#%files -n open-xchange-lang-pl-pl
#%defattr(-,root,root)
#%dir /opt/open-xchange/i18n
#/opt/open-xchange/i18n/server.pl_PL.po
#
#%files -n open-xchange-gui-lang-pl-pl -f filelist_pl
#%defattr(-,root,root)
#%dir %{docroot}/ox6/lang
#%{docroot}/ox6/lang/pl_PL.js

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-es-es
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.es_ES.po

%files -n open-xchange-gui-lang-es-es -f filelist_es
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/es_ES.js
/opt/open-xchange/etc/i18n.d/es_ES.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-nl-nl
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.nl_NL.po

%files -n open-xchange-gui-lang-nl-nl -f filelist_nl
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/nl_NL.js
/opt/open-xchange/etc/i18n.d/nl_NL.name

%changelog
* Mon Sep 14 2009 - choeger@open-xchange.com
 - Bugfix #14499 -  Dutch and Spanish cannot be selected at the UI after
   installing the corresponding language packs
