/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

(function() {
	var team = {}; // actually, this is a hash!

    // returns hash
    getTeamList = function() { return team; }; 
    
    // returns array
    getTeamArray = function() {
        var members = [];
        for (var id in team) { members.push(team[id]); }
        return members;
    };
    
    getTeamMember = function(id) { return team[id]; };
    
    setTeam = function(members, silent) {
        team = {};
        addToTeam(members, silent);
    };
    
    hasTeamMembers = function() {
        for (var id in team) return true;
        return false;
    }
    
    // added to work with new scalable team view
    // members must be a hash (key=id:type, value=member)
    importTeam = function(members) {
        team = members;
    };

    removeFromTeam = function(members, silent) {
        for (var i in members)
            delete team[members[i].id + ":" + members[i].type];
        if (!silent) triggerEvent("OX_Teammember_Changed", team);
    };
    
    addToTeam = function(members, silent) {
        var groups = [];
        for (var i in members) {
            var member = members[i];
            switch (member.type) {
                case 1:
                case 3:
                    team[member.id + ":" + member.type] = member;
                    break;
                case 2:
                    groups.push(member);
            }
        }
        if (groups.length) {
            internalCache.getObjects(groups, resolvedGroups(silent));
        } else {
            if (!silent) triggerEvent("OX_Teammember_Changed", team);
        }
    };
    
    function resolvedGroups(silent) {
        return function(groups) {
            var set = {};
            for (var i in groups) {
                var members = groups[i].members;
                for (var j in members) set[members[j]] = true;
            }
            var ids = [];
            for (var i in set) ids.push(Number(i));
            internalCache.getUsers(ids, resolvedUsers(silent));
        };
    }
    
    function resolvedUsers(silent) {
        return function(users) {
            for (var i in users) {
                team[i + ":1"] = {
                    id: users[i].id, type: 1,
                    display_name: users[i].display_name
                };
            }
            if (!silent) triggerEvent("OX_Teammember_Changed", team);
        };
    }

})();

var firstteam=true;
function filldefaultteam() {
    // required to cooperate with scalable team view (prevent overriding its team)
    var currentTeam = getTeamList();
    // check whether or not there are members
	if (currentTeam.length == 0 && firstteam) {
		var teams=new Array();
		if (configContainsKey("gui.calendar.teams")) {
			teams=configGetKey("gui.calendar.teams");
		}
        for(var i=0;i<teams.length;i++) {
			if(teams[i].team_default) {
                setTeam(teams[i].children, true);
				break;
			}
		}
		firstteam=false;
	}
}

var ctd_participants = null;
var team_participants_selected=new Array();
var team_change_menu;

function team_initContent() {
	team_createParticipantsPopUp();
    if (!team_change_menu) {
        team_change_menu =
            new PulldownMenu($("menu_calendar_teammember_change"));
        team_change_menu.onShow = function() {
            this.removeAllItems();
            var teams = configGetKey("gui.calendar.teams");
            if (teams) for (var i = 0; i < teams.length; i++) {
                this.addItem(new MenuItem(teams[i].name, (function(team) {
                    return function() {
                        team_participants_selected = [];
                        setTeam(team);
                    };
                })(teams[i].children)));
            }
        };
    }
}

function team_removeTeammembers() {
	removeFromTeam(team_participants_selected);
}

function team_changeTeammembers() {
    if(ctd_participants) {
        ctd_participants.openAddParticipantsWindow();
    }
}

function team_storeSelectedMember(response) {
	team_participants_selected=response;
	triggerEvent("SubSelected",team_participants_selected.length);
}

function team_createParticipantsPopUp() {
	ctd_participants = new ParticipantsSmall(null,addToTeam,true,true,true,false,"Select Users", /*i18n*/
						false,false,false,true); 
}

var oTeamWeek;
var TWPartPopup;
function goToNextTeamWeek(nDirection) {
    if(nDirection>0)
        oTeamWeek.next();
    else
        oTeamWeek.back();
        
    if (oMiniCalendar) oMiniCalendar.setSelectedByDate(activeYear, activeMonth, activeDay);
}

function teamWeekAddTeammember(oMemberHM) {
    if (oTeamWeek) {
        oTeamWeek.updateMemberList(oMemberHM);
    }
}

function unloadTeamWeek() {
    unregister("OX_Teammember_Changed",teamWeekAddTeammember);
    resizeEvents.unregister("Resized",resizeTeamWeekHeader);    
}

function loadTeamWeek() {
    register("OX_Teammember_Changed",teamWeekAddTeammember);
    if (!oTeamWeek) {
        oTeamWeek = new teamWeek();
    } else {
        oTeamWeek.set_current_week();
        oTeamWeek.updateHeader();
    }   
    resizeTeamWeekHeader();
    resizeEvents.register("Resized",resizeTeamWeekHeader);
    
    var team = getTeamList();
    if (team) {
        oTeamWeek.updateMemberList (team);
    }
    
    var hover=new Hover($("teamWeekBody"),OXAppointmentHover.getContent().node);
	calendarhovers["teamworkweek"]=hover;
	hover.setSize(OXAppointmentHover.contentobject.node);
	
	hover.getTarget = function (node) {
        try {
            while (node) {
                if (node.getAttribute("ox_object_id")) {
                    return node.parentNode ? node : null;
                }
                node = node.parentNode;
            }
        } catch (e) { /*see default implementation*/ }
    };
    /* event fired when getTarget found a node with valid attributes */
    hover.onShow = function (node) {
        OXAppointmentHover.actualHover = this;
        var ref       = node.getAttribute("ox_rowId");
        var folder_id = node.getAttribute("ox_folder_id");
        var object_id = node.getAttribute("ox_object_id");
        var rec_pos   = node.getAttribute("ox_rec_pos");
        if (object_id != undefined && folder_id != undefined) {
            // we have a folder and a object id so we can use the regular hover
            OXAppointmentHover.refillContent(object_id, folder_id, rec_pos);
        } else if (ref != undefined && oTeamWeek && oTeamWeek.app_assoc[ref]) {
            // we don't have read permission so we just show content we are allowed to            
            // disable tabs we don't need
            OXAppointmentHover.slider.getTabById("participants").show(false);
            OXAppointmentHover.slider.getTabById("attachments").show(false);
            OXAppointmentHover.slider.getTabById("others").show(false);
            OXAppointmentHover.refillContentByObject(oTeamWeek.app_assoc[ref]);
        }
    }
    hover.onHide = function (node) {
      // re-enable tabs for later use
      OXAppointmentHover.slider.getTabById("participants").show(true);
      OXAppointmentHover.slider.getTabById("attachments").show(true);
      OXAppointmentHover.slider.getTabById("others").show(true);
    }    
}

function resizeTeamWeekHeader() {
    var e1=$("teamWeekBody");
    var mywidth=e1.offsetWidth;
    if(!mywidth)
    $("teamWeekTableHead").style.width=mywidth+"px";
}

function clickMemberTeamWeek(index, e) {
    if (e.shiftKey && oTeamWeek.getSelected().length >= 0) {
    	// holds shift?    	
    	var startIndex = oTeamWeek.selected_member[oTeamWeek.getSelected()[0].id];
    	oTeamWeek.selectNone(); // unselect all
    	oTeamWeek.selectMember(Math.min(startIndex, index), 
				Math.max(startIndex, index));
    } else if (oTeamWeek.member_assoc["team_week_row_" + index]) {
    	// multiple?
        if (!(Mac ? e.metaKey : e.ctrlKey)) {
        	oTeamWeek.selectNone();
        }
    	if (oTeamWeek.selected_member[oTeamWeek.member_assoc["team_week_row_" + index].id] != null) {
 	    	// <ctrl> and click on selected row	        
	        $ALL("u_team_week_" + index).parentNode.className = "teamWeekColMemberSecond border-color-design";
	        delete oTeamWeek.selected_member[oTeamWeek.member_assoc["team_week_row_" + index].id];
	    } else {
	    	oTeamWeek.selectMember(index, index);
	    }
    }    
}

function dblClickMemberTeamWeek(e) {
    if (!oTeamWeek || !oTeamWeek.selected_member.length) return; 
    function getTarget(node) {
		function getNode(actualnode) {
			if (actualnode.getAttribute("ox_time")) {
				return actualnode;
			}
			return;
		}
		while (node) {
			var element=getNode(node);
			if (element) {
				return element;
			}
			try {
			   node = node.parentNode;
			} catch (e) { 
				node = null;
			} 
		}
		return;
	}
    var date = new Date(Date.UTC(activeYear, activeMonth, activeDay, 0, 0, 0));
	// setting clicked date
    var node = getTarget(e.srcElement || e.target);
	if (node && node.getAttribute("ox_time")) {
		date = new Date(oTeamWeek.monday.getTime()
				+ (864e5 * parseInt(node.getAttribute("ox_time"))));
		date.setUTCHours(new Date().getHours())
		date.setUTCMinutes(0);
	}
    // trigger new window with clicked paramter
	calendar_createNewAppointment(
			date,
			activefolder,false,
			{ "data"  : [[0, 0, oTeamWeek.selected_member[0].display_name, 0, oTeamWeek.selected_member[0].id, 0, 0, oTeamWeek.selected_member[0].type]], 
				  "module": "contacts" });
	stopEvent(e);
}

/////////////////////////////////////////////////////////////////////////
function teamWeek()
{
    this.template = $('team_week_row');
    this.container_id = 'teamWeekTableContent';
    this.container = newnode('tbody',0,{width:'100%'});
    this.membercount = 0;
    this.memberlist;
    
    this.selected_member = {};
    
    this.member_assoc = new Object();
    this.app_assoc = new Object();  
    
    this.full_data_aps = new Object();
    
    this.calendar_tool;
    this.kw;
    this.monday;
    this.friday;
    
    this.set_current_week();
    this.updateHeader();
    
    this.app_collector = new Object();
}


teamWeek.prototype = {
	set_current_week:function ()
	{
	    this.calendar_tool = new calendarTool(activeMonth,activeYear);
	    this.kw = this.calendar_tool.getKW(activeYear,activeMonth,activeDay);
	    var oDateLoc = new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0));
	    this.monday = new Date(getDayInSameWeek(oDateLoc, weekStart) * 864e5);
	    this.friday = new Date(this.monday.getTime());
	    this.friday.setDate(this.friday.getDate()+5);
	},
	next:function ()
	{
	    var oDateLoc = new Date();
	    oDateLoc.setUTCDate(1);
	    oDateLoc.setUTCHours(0);
	    oDateLoc.setUTCFullYear(activeYear);
	    oDateLoc.setUTCMonth(activeMonth);
	    oDateLoc.setUTCDate(activeDay);
	    oDateLoc.setUTCDate(oDateLoc.getUTCDate()+7);
	    activeDay = oDateLoc.getUTCDate();
	    activeMonth = oDateLoc.getUTCMonth();
	    activeYear = oDateLoc.getUTCFullYear();
	    this.set_current_week();        
	    this.updateAppointmentView();
	},  
	back:function ()
	{   
	    var oDateLoc = new Date();
	    oDateLoc.setUTCDate(1);
	    oDateLoc.setUTCHours(0);
	    oDateLoc.setUTCFullYear(activeYear);
	    oDateLoc.setUTCMonth(activeMonth);
	    oDateLoc.setUTCDate(activeDay);
	    oDateLoc.setUTCDate(oDateLoc.getUTCDate()-7);
	    activeDay = oDateLoc.getUTCDate();  
	    activeMonth = oDateLoc.getUTCMonth();
	    activeYear = oDateLoc.getUTCFullYear();
	    this.set_current_week();    
	    this.updateAppointmentView();   
	
	},
	updateHeader:function()
	{
	    removeChildNodes($('teamWeekHead'));
	    var oTextNode = document.createTextNode(this.kw + ' ' + this.calendar_tool.curr_date.getFullYear());
	    $('teamWeekHead').appendChild(oTextNode);
	    var startDate = new Date(this.monday);
	    for(var indx=1;indx<=5;indx++)
	    {
	        var sHeaderId = 'teamWeekCol_header_' + indx;
	        removeChildNodes($(sHeaderId));
	        var oTextNode = document.createTextNode(formatDate(startDate,"dateday"));       
	        $(sHeaderId).appendChild(oTextNode) ;
	        startDate.setUTCDate(startDate.getUTCDate()+1);
	    }
	},
	updateAppointmentView:function()
	{
	    this.clearAppView();
	    this.fetchAppointments(this.memberlist);
	    this.updateHeader();
	},
	clearAppView:function ()
	{   
	    for(var ikey in this.member_assoc)
	    {
	        for(var indx=1;indx<6;indx++)
	        {
	            var sId = 'd'+indx + '_team_week_' + ikey.split('_')[3];
	            var oParentDiv = document.getElementById(sId);
	            while(oParentDiv.childNodes.length>0)
	            {
	                oParentDiv.removeChild(oParentDiv.firstChild);
	            }
	            oParentDiv.innerHTML = '&#xa0;';            
	        }
	    }
	    this.app_collector = new Object();  
	},
	drawAppointments:function (oAppointments,nRowId)
	{
	    var sPostfix = nRowId.split('_')[3];    
	    this.app_collector[sPostfix] = new Array();
	    function duplicate_app(app) {
	        var copyApp = new Object();
	        copyApp["id"] = app.id;
	        copyApp["folder_id"] = app.folder_id;
	        copyApp["start_date"] = app.start_date;
	        copyApp["end_date"] = app.end_date;
	        copyApp["shown_as"] = app.shown_as;                                                         
	        copyApp["full_time"] = app.full_time;
	        copyApp["created_by"] = app.created_by;
	        copyApp["full_time"] = app.full_time;
	        copyApp["title"] = app.title
	        copyApp["recurrence_position"] = app.recurrence_position;
	        return copyApp;
	    }
	    for (var indx=0; indx<oAppointments.data.length; indx++) {	    		    	
	        var tApp = duplicate_app(oAppointments.data[indx]);	        
	        var sIdAp = 'app_d_' + nRowId + '_' + indx;
	        
	        this.app_assoc[sIdAp] = (this.full_data_aps[tApp.id]==undefined) ? tApp : this.full_data_aps[tApp.id];
	        
	        /*
	         * set appointment start day to the start day of this week
	         * if it starts before monday        
	         */
	        if (tApp.start_date < this.monday.getTime()) {
	            tApp.start_date = this.monday.getTime();
	        }
	        /*
	         * set appointment end day to the end day of this week
	         * if it ends after this friday      
	         */
	        if (tApp.end_date > this.friday.getTime()) {
	            tApp.end_date = this.friday.getTime();
	        }
	        
	        var oDateStart = new Date(tApp.start_date);
	        var oDateEnd = new Date(tApp.end_date); 
	        var nStartDay = oDateStart.getUTCDay();
	        var nEndDay = oDateEnd.getUTCDay();
	        var appDuration = Math.ceil(tApp.end_date/864e5) - Math.floor(tApp.start_date/864e5);       
	 
	        if (appDuration == 1) {
	            tApp.assoc_id = sIdAp;
	            this.collectAppointment(nStartDay,sPostfix,tApp);  
	            
	        } else {
	            for (var nNumDay=nStartDay; nNumDay<(nStartDay+appDuration); nNumDay++) {
	            	var tApp2 = duplicate_app(tApp);
	                if (nNumDay == nStartDay) {
	                    var oDateStart = new Date(tApp2.start_date);
	                    oDateStart.setUTCHours(0);
	                    oDateStart.setUTCMinutes(0);
	                    oDateStart.setUTCSeconds(0);    
	                    oDateStart.setUTCDate(oDateStart.getUTCDate()+1);
	                    tApp2.end_date = oDateStart.getTime();
	                    
	                } else if (nNumDay == nEndDay && nStartDay < nEndDay) {
	                    var oDateStart = new Date(tApp2.end_date);
	                    oDateStart.setUTCHours(0);
	                    oDateStart.setUTCMinutes(0);
	                    oDateStart.setUTCSeconds(0);    
	                    tApp2.start_date = oDateStart.getTime();
	                    
	                } else {                
	                    var oDateStart = new Date(tApp2.start_date);
	                    var oDateEnd = new Date(tApp2.start_date);                                        
	                    oDateStart.setUTCHours(0);
	                    oDateStart.setUTCMinutes(0);
	                    oDateStart.setUTCSeconds(0);    
	                    oDateEnd.setHours(0);
	                    oDateEnd.setMinutes(0);
	                    oDateEnd.setSeconds(0);                     
	                    oDateStart.setUTCDate(oDateStart.getUTCDate()+nNumDay);                 
	                    oDateEnd.setUTCDate(oDateStart.getUTCDate()+nNumDay+1);                                     
	                    tApp2.start_date = oDateStart.getTime();              
	                    tApp2.end_date = oDateEnd.getTime();                                  
	                }
	                tApp2.assoc_id = sIdAp;
	                this.collectAppointment(nNumDay,sPostfix,tApp2);
	            }
	        }
	    }
	},
	doDraw:function ()
	{
	    for(var sKey in this.app_collector)
	    {
	        var aAppointments = this.app_collector[sKey];
	        for(var nDay in aAppointments)
	        {
	            var oList = this.getLineList(aAppointments[nDay]);
	            this.drawList(oList,sKey,nDay);
	        }
	    }
	},
	getPrio:function (number)
	{
	    var aPrio = new Array(-1,4,3,1,0,2);    
	    for(var indx=0;indx<aPrio.length;indx++)
	    {
	        if(aPrio[indx] == number)
	            return indx;    
	
	    }
	},
	getLineList:function (aApp)
	{   
	    var oDataStart = new Object();
	    oDataStart.x = 0;
	    oDataStart.type = -1;
	    oDataStart.appid = -1;      
	    var oDataEnd = new Object();    
	    oDataEnd.x = 100;
	    oDataEnd.type = -1;
	    oDataEnd.appid = -1;    
	    var oList = new js_list();
	    oList.push(oDataStart);
	    oList.push(oDataEnd);
	    //Sort all appointments by start date
	    function sort_fn(a,b){
	        if(a.start_date < b.start_date)
	            return -1;
	        else            
	            return 1;   
	    }
	    aApp.sort(sort_fn);
	    for(var nindx=0;nindx<aApp.length;nindx++)
	    {
	
	        var currApp = aApp[nindx];
	        var sAppId = currApp.assoc_id;
	        var oStartDate = new Date(aApp[nindx].start_date);
	        var oEndDate = new Date(aApp[nindx].end_date);      
	
	        var nHoursStart = oStartDate.getUTCHours();
	        var nMinutesStart = oStartDate.getUTCMinutes();
	        var nHoursEnd = oEndDate.getUTCHours();
	        var nMinutesEnd = oEndDate.getUTCMinutes();
	        if(nHoursStart == 0 && nMinutesStart == 0)
	            var currStartX = 0.5;
	        else
	            var currStartX = Math.round(((nHoursStart * 60 + nMinutesStart) * 100) / (24 * 60));
	            
	        if(nHoursEnd == 0 && nMinutesEnd == 0)
	            var currEndX = 99.5;
	        else
	            var currEndX = Math.round(((nHoursEnd * 60 + nMinutesEnd) * 100) / (24 * 60));
	    
	
	        //find start position       
	        var listnode = oList.first;
	        while(listnode.data.x <= currStartX)
	        {           
	            listnode = listnode.next;
	        }   
	    
	        var oDataStart = new Object();
	        oDataStart.x = currStartX;
	        oDataStart.type = currApp.shown_as; 
	        oDataStart.appid = sAppId;
	        var nTypeBefore = listnode.previous.data.type;      
	        var nAppIdBefore = listnode.previous.data.appid;            
	
	        if(this.getPrio(oDataStart.type) < this.getPrio(nTypeBefore))   
	        {
	            if(this.getPrio(listnode.data.type) < this.getPrio(oDataStart.type) 
	                && listnode.data.x < currEndX)
	            {               
	                currStartX = listnode.data.x;
	                nTypeBefore = listnode.data.type;
	                nAppIdBefore= listnode.data.appid;
	                oDataStart.x = currStartX;
	                listnode = listnode.next;
	            }
	            else continue;
	        }
	
	        //if previous point equal current point, remove it      
	        if(listnode.previous.data.x == currStartX)      
	        {   
	            oList.remove(listnode.previous);
	        }
	        oList.insert_before(listnode,oDataStart);
	        //find end position
	        while(listnode.data.x <= currEndX)
	        {   
	        //  nTypeBefore = listnode.data.type;
	            listnode.data.type = oDataStart.type;
	            listnode = listnode.next;
	        }   
	        if(listnode.previous.data.x == currEndX)        
	        {   
	            oList.remove(listnode.previous);
	        }
	        var oDataEnd = new Object();
	        oDataEnd.x = currEndX;
	        if(listnode.data.x == 100)
	        {
	            nTypeBefore = -1;
	        }
	        oDataEnd.type = nTypeBefore;    
	        oDataEnd.appid = nAppIdBefore;      
	        oList.insert_before(listnode,oDataEnd);     
	    }
	    //this.print_list(oList);
	    return oList;
	},
	
	print_list: function (oList) {
	    var ocurrNode = oList.first;
	    var nC = 0;
	    while (ocurrNode.next != null)
	    {
	        ocurrNode = ocurrNode.next;
	        nC++;
	    }
	},
	
	drawList: function (oList, nId, nDay) {
	    var sContainerId = 'd'+nDay+'_team_week_' + nId;
	    var oParentDiv =  document.getElementById(sContainerId);
	    if(oParentDiv == undefined)
	        return;
	    removeChildNodes(oParentDiv);
	    
	    var lItem = oList.first;    
	    var nNumItems = oList.number;
	    var Coeff = (100 - Math.round(nNumItems/2)-1)/100; // compute with space
	    while(lItem.next != null) {       
	        var appid_l = lItem.data.appid;
	        var size = lItem.next.data.x - lItem.data.x;
	        size *= Coeff;
	        var type = lItem.data.type;
	        var oDiv = newnode('div');      
	        oDiv.className = 'colorBlockTWV workTimeBackground';
	        switch (type) {
		        case 1:
		            oDiv.className += " appointmentRESERVED";
		            break;
		        case 2:
		            oDiv.className += " appointmentTEMPORARY";
		            break;
		        case 3:
		            oDiv.className += " appointmentABSENT";
		            break;
		        case 4:
		            oDiv.className += " appointmentFREE";
		            break;
		        default:
		            //oDiv.className += " appointmentShowAsNone";
		            break;
	        }
	        oDiv.style.width = size + "%";
	        oDiv.innerHTML = '&#xa0;';
	        if (appid_l == -1) {
	        	oDiv.removeAttribute("id");
	        } else {
	        	oDiv.id = appid_l;
	        	var app = this.app_assoc[appid_l];
	        	if (app) {
	        		oDiv.setAttribute("ox_rowId", appid_l);
	        		oDiv.setAttribute("ox_object_id", app.id);
	        		if (app.folder_id) oDiv.setAttribute("ox_folder_id", app.folder_id);
	        		if (app.recurrence_position) oDiv.setAttribute("ox_rec_pos", app.recurrence_position);
	        	}
	        }
	        oParentDiv.appendChild(oDiv);
	        var oSpacerDiv = newnode('div');
	        oSpacerDiv.className = 'colorBlockTWV workTimeBackground';
	        oSpacerDiv.style.width = '0.5%';
	        oParentDiv.appendChild(oSpacerDiv);     
	        lItem = lItem.next;
	    }
	},
	
	collectAppointment: function (nDay,sPostfix,oApp) {
	    if (oApp.start_date < this.monday.getTime() && 
	        oApp.end_date < this.monday.getTime() || oApp.start_date > this.friday.getTime() && 
	        oApp.end_date > this.friday.getTime()) {
	        return;
	    }
	    //exclude saturday and sunday
	    if (nDay==0 || nDay==6) {
	        return;
	    }
	    if(!this.app_collector[sPostfix][nDay]) {
	        this.app_collector[sPostfix][nDay] = new Array();
	    }
	    this.app_collector[sPostfix][nDay].push(oApp);
	},
	
	fetchAppointments: function (aUpdtMember) {
	    if (!aUpdtMember || isEmpty(aUpdtMember)) return; // no members requested   
	    var Self = this;
	    var aJsonArray = new Array();
	    for(var sKeyAssoc in aUpdtMember)
	    {
	        var oRequestObject = new Object();
	        oRequestObject['module'] = "calendar";
	        oRequestObject['action'] = 'freebusy';
	        oRequestObject['id'] = aUpdtMember[sKeyAssoc].id;
	        oRequestObject['type'] = aUpdtMember[sKeyAssoc].type;
	        oRequestObject['start'] = this.monday.getTime();
	        oRequestObject['end']= this.friday.getTime();   
	        aJsonArray.push(oRequestObject);
	    }
	
	    function callback(responseobj) {
	        if (responseobj.error) {
	        	newServerError(responseobj, 4);
	        	
	        } else {
	            //fetch full data here
	            function sub_callback(arg){
	                //prepare and set data
	                for(var nFullDataApp=0;nFullDataApp < arg.data.length;nFullDataApp++) {
	                    var tmpdata = arg.data[nFullDataApp];
	                    Self.full_data_aps[tmpdata[0]] = 
	                        new CalendarWorkWeekObject(tmpdata[0],tmpdata[1],tmpdata[2],tmpdata[3],tmpdata[4],tmpdata[5],tmpdata[6],tmpdata[7],tmpdata[8],tmpdata[9],tmpdata[10],tmpdata[11],tmpdata[12],tmpdata[13],tmpdata[14],tmpdata[15],tmpdata[16]);
	                }
	                var nIndx = 0;
	                // iterate through requested member list
	                for (var mkey in aUpdtMember) {
	                    // iterate through internal member list to map the server response              
	                    for (var nkey in Self.member_assoc) {
	                        // check if member already in list and (re-)draw appointment
	                        if (Self.member_assoc[nkey].id == aUpdtMember[mkey].id) {
	                            Self.drawAppointments(responseobj[nIndx],nkey);
	                            break;
	                        }
	                    }
	                    nIndx++;
	                }
	                Self.doDraw();
	            }
	            var calendarwwfields = new Array(1,20, 207, 206, 2, 200, 201, 202, 203, 209, 220, 401, 402, 102, 400, 101);
	            var sAjaxReq = AjaxRoot + "/calendar?action=all&session=" + session + "&start=" + Self.monday.getTime() + "&end=" 
	                                                        + Self.friday.getTime() + "&columns=" +calendarwwfields.toString();         
	            json.get(sAjaxReq,null,sub_callback);
	        }
	    }   
	    json.put(AjaxRoot + "/multiple?session=" + session,aJsonArray,null,callback);
	},
	
	updateMemberList: function (oMemberHM) {
	    var bMemberAddd = false;
	    if (oMemberHM) {
	        this.memberlist = oMemberHM;
	    }
	
	    //remove member
	    for (var sKeyAssoc in this.member_assoc) {
	        if (!this.memberlist[this.member_assoc[sKeyAssoc].id + ":" + this.member_assoc[sKeyAssoc].type]) {
	            this.removeMember(sKeyAssoc, this.member_assoc[sKeyAssoc].id);
	        }
	    }
	    
	    //check member
	    for (var sKey in this.memberlist) {
	        var bFound = false;
	        //search for members
	        for(var sKeyAssoc in this.member_assoc) {
	            if(this.member_assoc[sKeyAssoc].id == sKey.split(':')[0]) {
	                bFound = true;
	                break;
	            }
	        }
	        //add member        
	        if (!bFound) {
	            this.addMember(this.memberlist[sKey]);          
	            bMemberAddd = true;
	        }
	    }
	//  if(bMemberAddd)
	        this.updateAppointmentView(this.member_assoc);
	},
	
	addMember: function (oMember) {
		var Self = this;
	    var oTeml = this.template.cloneNode(true);
	    oTeml.id += '_' + this.membercount; 
	    var arr = oTeml.getElementsByTagName("div");
	    for (var i in arr) {    	
	    	var div = arr[i];
	    	if (div.id == "u_team_week") {
	            div.appendChild(document.createTextNode(oMember.display_name));
	            // prevent moz element selection
	            div.parentNode.onselectstart = function() { return false; };
	            div.parentNode.style.MozUserSelect = "none";
	            var wrapper = (function(index) {
	                return function(e) {
	                    clickMemberTeamWeek(index, e); 
	                };
	            })(Self.membercount);
	            addDOMEvent(div.parentNode, "click", wrapper);
	    	} else if (div.setAttribute) {
	    		div.setAttribute("ox_time", String(i-1));
	    		addDOMEvent(div, "dblclick", dblClickMemberTeamWeek);    		
	    	} 
	    	if (div.id) {
	    		div.id += "_" + this.membercount;
	    	}
	    }
	    this.container.appendChild(oTeml);
	    if(!this.membercount)
	        $(this.container_id).appendChild(this.container);
	    this.member_assoc['team_week_row' + '_' + this.membercount] = oMember;      
	    this.membercount++;
	    resizeTeamWeekHeader();
	},
	
	/**
	 * set selection by index from to
	 * @param from {num} the start index
	 * @param to   {num} the end index
	 */
	selectMember: function (from, to) {
		for (var i = from; i <= to; i++) {
			var row = this.member_assoc["team_week_row_" + i];		
			this.selected_member[row.id] = i;
			$ALL("u_team_week_" + i).parentNode.className += " background-color-selection-elements font-weight-high font-color-selected";
		}
		triggerEvent('OX_Selected_Member', this.getSelected());
	},
	
	getSelected: function() {
	    var selection = [];
	    for (var id in oTeamWeek.selected_member) {
	        selection.push(this.member_assoc["team_week_row_" + oTeamWeek.selected_member[id]]);
	    }
	    return selection;
	},
	
	/**
	 * un-select all
	 */
	selectNone: function() {
	    for (var id in this.selected_member) {
	        $ALL("u_team_week_" + this.selected_member[id]).parentNode.className = "teamWeekColMemberSecond border-color-design";
	        delete this.selected_member[id];
	    }
	},
		
	/**
	 * removes a member from the list
	 * @param row_id {String} the row_id
	 * @param user_id {String} the id of the user
	 */
	removeMember: function(row_id, user_id) {
	    var oSelTr = document.getElementById(row_id);
	    this.container.removeChild(oSelTr);	    
	    delete this.member_assoc[row_id];
	    delete this.selected_member[user_id];
	    triggerEvent("OX_Selected_Member", this.getSelected());
	}

}


///////////////////////////////////////////////////////
//Liste

function list_obj()
{
    this.next;
    this.previous;
    this.data;
}
function js_list()
{
    this.first = null;
    this.last = null;
    this.next_ = null;
    this.previous_ = null;
    this.number = 0;    
}
js_list.prototype = {
push:function (aData)
{
    var oItem = new list_obj();
    oItem.next = null;      
    oItem.previous = this.previous_;    
    oItem.data = aData;
    
    if(this.previous_!=null)
        this.previous_.next = oItem;
    this.previous_ = oItem;
    if(!this.first)
        this.first = oItem;
    this.last = oItem;          
    this.number++;  
},
insert_before:function(oBeforeItem,aData)
{
    var oItem = new list_obj(); 
    oItem.previous = oBeforeItem.previous;
    oItem.next = oBeforeItem;       
    oItem.data = aData;
    oBeforeItem.previous.next = oItem;
    oBeforeItem.previous = oItem;
    this.number++;
},
remove:function(oItem)
{
    oItem.previous.next = oItem.next;   
    oItem.next.previous = oItem.previous;
    oItem = null;
    delete oItem;
    this.number--;
}
}

fileloaded();