
# norootforbuild
%define         configfiles     configfiles.list

Name:           open-xchange-gui-mobile
BuildArch: 	noarch
#!BuildIgnore: post-build-checks
Version:	1.0.0
%define		ox_release 21
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        Creative Commons Attribution-Noncommercial-Share Alike 2.5 Generic
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Package containing the Open-Xchange Mobile GUI
%if 0%{?suse_version}
Requires:	php5 php5-curl php5-json php5-mcrypt php5-gettext
%endif
%if 0%{?fedora_version} || 0%{?rhel_version}
Requires:	
%endif
#

%description
Package containing the Open-Xchange Mobile GUI

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html/ox6-mobile
%else
%define docroot /srv/www/htdocs/ox6-mobile
%endif

make DESTDIR=%{buildroot} HTDOCDIR=%{docroot} install
rm -f %{configfiles}
find %{buildroot}/%{docroot} -type f -not -name config.php -printf '"%p"\n' > %{configfiles}
perl -pi -e 's;%{buildroot}/;;' %{configfiles}


%clean
%{__rm} -rf %{buildroot}

%files -f %{configfiles}
%defattr(-,root,root)
%dir %{docroot}
%config(noreplace) %{docroot}/config.php

%changelog
* Tue May 12 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #13586 : Login fails on Nokia Business Phone E71
  - Fixed bug #13587 : Login fields overlap with prompts on Nokia Business Phone E71
* Mon Apr 06 2009 - stefan.preuss@open-xchange.com
  - Using first name and last name in the detail view of a contact instead of display name
  - Fixed broken layout if appointment or task title or location is empty 
  - Fetching all appointments from all folders now where user is also a participant
* Tue Mar 31 2009 - manuel.kraft@open-xchange.com
  - BUGFIX #13400 Error message when accepting cookies is disabled
* Thu Mar 12 2009 - stefan.preuss@open-xchange.com
  - Fixed bug that private or business address won't be shown if one field hasn't been set
* Wed Mar 11 2009 - stefan.preuss@open-xchange.com
  - Contacts detail view: switched position of work and private address to be consistent to the e-mail addresses
  - Contacts detail view: hide single fields of the address if no data given
* Tue Mar 10 2009 - manuel.kraft@open-xchange.com
  - BUGFIX: Added utf8 as charset encoding for all pages. Was corrupt on nokia device.
* Mon Mar 09 2009 - manuel.kraft@open-xchange.com
  - BUGFIX: Fixed wrong display date in tasks when no start/end date set
  - Useability: Added better layout for detail and list view on bad mobile browsers.
  - Useability: Made whole table items clickable instead of just using text as the link
* Mon Mar 02 2009 - manuel.kraft@open-xchange.com
  - Added cookie feature to remember user and password
  - Added encryption of cookies via mcrypt extension
  - BUGFIX: Fixed "umlaute" problem in listview of calendar
  - Added config option to add webkit devices on demand (android already in list)
  - Reorganized Repository
* Tue Oct 28 2008 - stefan.preuss@open-xchange.com
  - Starting adding device specific parts
  - Included iUi API for Iphone support
* Tue Oct 14 2008 - stefan.preuss@open-xchange.com
  - Added stylesheet, javascript and image resources
  - Optimized header and content generation
  - New design of the top menu
  - Added iphone specific resize events and redraw view when changing orientation
  - Disable logo when view width is below 320px* Mon Mar 10 2008 - stefan.preuss@open-xchange.com
  - Login also checks possible GET parameter
  - Moved Calendar to the top of the module list on the main page
  - Fixed white border around module icons when background changed
  - The last name in the contacts list view will be shown bold now
  - Moved field completed above the field status in the tasks detail view
  - Changed some date formats in the calendar detail view depending on the duration of the appointment
  - Fixed broken layout if a task note contains a long line without line breaks
  - Fixed a problem that all day appointments always shown on the bottom instead on the top in the list view
  - Appointment list view now show all appointments of the current day  
  - Fixed a single line shown in the contact detail view if a 'section' has no data (e.g. business or private address)
  - Hide notes field in appointment detail view if its empty
* Sun Mar 09 2008 - stefan.preuss@open-xchange.com
  - Fixed 'text-overflow: ellipsis' bug in list views
  - Loading compressed iui stylesheet now
  - Added appointment time frame and location in list view 
  - Slightly adjusted scrolling speed
  - New design of the task detail view
