/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

register("OX_Configuration_Settings_Changed_Language",cs_changedLanguage);
register("OX_Configuration_Settings_Changed_Timezone",cs_changedTimezone);
register("OX_Configuration_Settings_Changed_GUI",cs_changedGui);
register("OX_Configuration_Settings_Changed_Mail",cs_changedMail);
register("OX_Configuration_Settings_Changed_Modules",cs_changedModules);
register("OX_Configuration_Settings_Changed_Calendar_Notification",cs_changedCalendarNotification);
register("OX_Configuration_Settings_Changed_Task_Notification",cs_changedTaskNotification);
register("OX_Configuration_Settings_Changed_Region_Date", cs_region_date_changed);

function cs_changedMail() {
	configuration_changed_fields["mail"]=true;
}
function cs_changedModules() {
	configuration_changed_fields["modules"]=true;
}
function cs_changedGui() {
	configuration_changed_fields["gui"]=true;
}
function cs_changedTimezone() {
	configuration_changed_fields["timezone"]=true;
}
function cs_changedLanguage() {
	configuration_changed_fields["language"]=true;
}
function cs_changedCalendarNotification() {
	configuration_changed_fields["calendarnotification"]=true;
}
function cs_changedTaskNotification() {
	configuration_changed_fields["tasknotification"]=true;
}
function getBoolofInt(myint) {
	if(myint!=0) 
		return true;
	return false;
}
function getValueofRadioBox(nameofradios) {
	var allelements = document.getElementsByName(nameofradios);
	var returnvalue = 0;
	for (var i=0; i<allelements.length; i++) {
		if (allelements[i].checked) {
			return parseInt(allelements[i].value);
		} 
	}
}
function getStringofRadioBox(nameofradios) {
	var allelements = document.getElementsByName(nameofradios);
	var returnvalue = 0;
	for (var i=0; i<allelements.length; i++) {
		if (allelements[i].checked) {
			return allelements[i].value;
		} 
	}
}
function setIntofRadioBox(nameofradios,value){
	var allelements = document.getElementsByName(nameofradios);
	for (var i=0; i<allelements.length; i++) {
		if (parseInt(allelements[i].value) == value) {
			allelements[i].checked=true;
			break;
		} 
	}
}
function setValueofRadioBox(nameofradios,value) {
	if(value==true) { value=1; }
	if(value==false) { value=0; }
	var allelements = document.getElementsByName(nameofradios);
	for (var i=0; i<allelements.length; i++) {
		if (parseInt(allelements[i].value) == value) {
			allelements[i].checked=true;
			break;
		} 
	}
}
function setStringofRadioBox(nameofradios,value) {
	if(value==true) { value=1; }
	if(value==false) { value=0; }
	var allelements = document.getElementsByName(nameofradios);
	for (var i=0; i<allelements.length; i++) {
		if (allelements[i].value == value) {
			allelements[i].checked=true;
			break;
		} 
	}
}
registerView("configuration/settings",
	function() { 
		showNode("config"); 
		$("config").style.display="block";
	},
		
	function() { 
 	    register("OX_SAVE_OBJECT",cs_saveConfiguration);
		register("OX_Cancel_Object",cs_cancelConfiguration);
		register("LanguageChanged",cs_changeHeader);
		//init config
		markConfigTreeNode('configuration/settings');
		cs_enter(); 
        changeTab('tabConfiguration1', 'panelConfiguration1');
        $("panelConfiguration1").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";        
		cs_region_enter();
	},
	function() { 
		//configuration_askforSave();
 	    unregister("OX_SAVE_OBJECT",cs_saveConfiguration);
		unregister("OX_Cancel_Object",cs_cancelConfiguration);
		unregister("LanguageChanged",cs_changeHeader);
		cs_leave();
	},
	function() { 
		hideNode("config"); 
		$("config").style.display="none";
		$("tabConfiguration1").style.display="none";
		$("panelConfiguration1").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";
	
	},
	function() { 
		cs_enter();
		cs_region_enter(); 
	}
);

function cs_changeHeader() {
	if(currentpath2.join("/") == "configuration/settings") {
		$("cs_header").firstChild.nodeValue=getconfigPathSelected().substring(1);
	}
}

var configSettingsTabsList = new Array('tabConfiguration1','tabConfiguration2');
var configSettingsPanelsList = new Array('panelConfiguration1','panelConfiguration2');
var configSettingsEventList = null;
	
function cs_saveConfiguration() {
	if(configuration_changed_fields["timezone"]) {
		configSetKey("timezone",cs_timezone.getKey());
	}
	if(configuration_changed_fields["language"]) {
		configSetKey("language",cs_language.getKey());
		setLanguage(configGetKey("language"));
		cs_region_enter();
	}
	if(configuration_changed_fields["gui"]) {
		/*
		var selectedTheme = cs_theme.getKey();
		if (selectedTheme != configGetKey("gui.theme").path && configContainsKey("modules.themes." + selectedTheme)) {
			triggerEvent("OX_New_Info",4,_("Theme will be applied after a new login."));
			configSetKey("gui.theme", { name: configGetKey("modules.themes")[selectedTheme], path: selectedTheme });
		}
		*/
			
 		configSetKey("gui.global.save",getValueofRadioBox("cs_saveconfig"));
		configSetKey("gui.global.autorefresh",cs_autorefresh.getKey());
		configSetKey("gui.portal.tooltip",getBoolofInt(getValueofRadioBox("cs_showquickinfo")));
		configSetKey("gui.portal.infobox",getBoolofInt(getValueofRadioBox("cs_showinfobox")));
		configSetKey("gui.portal.minicalendar",getBoolofInt(getValueofRadioBox("cs_showminicalendar")));
		configSetKey("gui.effects.fading",getBoolofInt(getValueofRadioBox("cs_enableeffects")));
		configSetKey("gui.effects.global",getBoolofInt(getValueofRadioBox("cs_enableeffects")));
		configSetKey("gui.effects.hover.portal",getBoolofInt(getValueofRadioBox("cs_enablehoverportal")));
		configSetKey("gui.effects.hover.mail",getBoolofInt(getValueofRadioBox("cs_enablehovermail")));
		configSetKey("gui.effects.hover.calendar",getBoolofInt(getValueofRadioBox("cs_enablehovercalendar")));
		configSetKey("gui.effects.hover.contacts",getBoolofInt(getValueofRadioBox("cs_enablehovercontacts")));
		configSetKey("gui.effects.hover.tasks",getBoolofInt(getValueofRadioBox("cs_enablehovertasks")));
		configSetKey("gui.effects.hover.infostore",getBoolofInt(getValueofRadioBox("cs_enablehoverinfostore")));
		configSetKey("gui.effects.hover.speed",getValueofRadioBox("cs_hoverspeed"));	
		configSetKey("gui.global.region.time.predefined",getValueofRadioBox("cs_time_predefined"));
		if(getValueofRadioBox("cs_time_predefined") == 0) {
			if($("cs_time_userdefined:0").checked) {
				configSetKey("gui.global.region.time.format", "hh:mm a");
				configSetKey("gui.global.region.time.format_hour", "hh a");
				configSetKey("gui.global.region.time.format_suffix", true);
			}
			else {				
				configSetKey("gui.global.region.time.format", "HH:mm");
				configSetKey("gui.global.region.time.format_hour", "HH:mm");
				configSetKey("gui.global.region.time.format_suffix", false);
			}
		}
		configSetKey("gui.global.region.date.predefined",getValueofRadioBox("cs_date_predefined"));
		if(getValueofRadioBox("cs_date_predefined") == 0) {
			configSetKey("gui.global.region.date.format_selected_index", cs_dateformat.getSelectedIndex());
			configSetKey("gui.global.region.date.separator", cs_date_separator.getKey());
			var current_date_separator = cs_date_separator.getKey();
			var current_date_format = cs_dateformat.getKey();
			if(current_date_separator && current_date_separator != "default") {
				current_date_format = current_date_format.replace(/\W/g,current_date_separator);
			}
			configSetKey("gui.global.region.date.format", current_date_format);
		}
	}
	triggerEvent("OX_Save_Configuration",false,false);
}

function cs_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	configuration_changed_fields["language"]=false;
	configuration_changed_fields["timezone"]=false;
	cs_enter();	
}

function cs_region_enter() {
	/* time format */
	if(configContainsKey("gui.global.region.time.predefined") && configGetKey("gui.global.region.time.predefined")==0) {
		$("cs_time_userdefined:0").disabled = false;
		$("cs_time_userdefined:1").disabled = false;
		$("cs_time_predefined:0").checked = true
		var current_time_format = configGetKey("gui.global.region.time.format");
	} else {
		$("cs_time_userdefined:0").disabled = true;
		$("cs_time_userdefined:1").disabled = true;
		$("cs_time_predefined:1").checked = true
		var current_time_format = _("HH:mm");
	}
	if(current_time_format.indexOf("a") != -1) {
		$("cs_time_userdefined:0").checked = true;
	} else {
		$("cs_time_userdefined:1").checked = true;
	}
	$("cs_region_time_sample").value = formatDate(new Date(now()), "time");
	
	
	/* date format */
	if(configContainsKey("gui.global.region.date.predefined") && configGetKey("gui.global.region.date.predefined")==0) {
		$("cs_date_predefined:0").checked = true
		var triggerNoEvent = true;
		cs_dateformat.setSelectedIndex(configGetKey("gui.global.region.date.format_selected_index"),triggerNoEvent);
		cs_date_separator.setKey(configGetKey("gui.global.region.date.separator"),triggerNoEvent);
		cs_dateformat.enable();
		cs_date_separator.enable();
	} else {
		cs_dateformat.disable();
		cs_date_separator.disable();
		$("cs_date_predefined:1").checked = true
	}
	$("cs_region_date_sample").value = formatDate(new Date(now()), "date");
}

function cs_region_set_time_format() {
	if($("cs_time_predefined:0").checked == true) {
		$("cs_time_userdefined:0").disabled = false;
		$("cs_time_userdefined:1").disabled = false;	
		var current_time_format = ($("cs_time_userdefined:0").checked) ? "hh:mm a" : "HH:mm";
		
	} else {
		$("cs_time_userdefined:0").disabled = true;
		$("cs_time_userdefined:1").disabled = true;
		var current_time_format = _("HH:mm");
		if(current_time_format.indexOf("a") != -1) {
			$("cs_time_userdefined:0").checked = true;
		} else {
			$("cs_time_userdefined:1").checked = true;
		}
	}
	$("cs_region_time_sample").value = formatDateTime(current_time_format, new Date(now()));
}

function cs_region_set_date_format() {
	if($("cs_date_predefined:0").checked == true) {
		cs_dateformat.enable();
		cs_date_separator.enable();
		var current_date_format = cs_dateformat.getKey();	
		var current_date_separator = cs_date_separator.getKey();	
	} else {
		cs_dateformat.disable();
		cs_date_separator.disable();
		var current_date_format = _("yyyy-MM-dd");
		var current_date_separator = false;
	}
	if(current_date_separator && current_date_separator != "default") {
		current_date_format = current_date_format.replace(/\W/g,current_date_separator);
	}
	$("cs_region_date_sample").value = formatDateTime(current_date_format, new Date(now()));
}

function cs_region_date_changed() {
	triggerEvent('OX_Configuration_Settings_Changed_GUI');
	cs_region_set_date_format()
}

function cs_enter() {	
	if(!cs_init_bool) {
		cs_init();
		cs_init_bool=true;
	}
	if(configContainsKey("language")) {
		cs_language.setKey(configGetKey("language"));
		configuration_changed_fields["language"]=false;
	}	
	if(configContainsKey("timezone")) {
		cs_timezone.setKey(configGetKey("timezone"));
		configuration_changed_fields["timezone"]=false;
	}
	/*
	if(configContainsKey("gui.theme")) {
		cs_theme.setKey(configGetKey("gui.theme").path);
		configuration_changed_fields["gui"]=false;
	}
	*/
	cs_autorefresh.setKey(configGetKey("gui.global.autorefresh"));
	if(configContainsKey("gui.global.save")) {
		setIntofRadioBox("cs_saveconfig",configGetKey("gui.global.save"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.portal.tooltip")) {
		setIntofRadioBox("cs_showquickinfo",configGetKey("gui.portal.tooltip"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.portal.infobox")) {
		setIntofRadioBox("cs_showinfobox",configGetKey("gui.portal.infobox"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.global")) {
		setIntofRadioBox("cs_enableeffects",configGetKey("gui.effects.global"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.portal.minicalendar")) {
		setIntofRadioBox("cs_showminicalendar",configGetKey("gui.portal.minicalendar"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.portal")) {
		setIntofRadioBox("cs_enablehoverportal",configGetKey("gui.effects.hover.portal"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.mail")) {
		setIntofRadioBox("cs_enablehovermail",configGetKey("gui.effects.hover.mail"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.calendar")) {
		setIntofRadioBox("cs_enablehovercalendar",configGetKey("gui.effects.hover.calendar"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.contacts")) {
		setIntofRadioBox("cs_enablehovercontacts",configGetKey("gui.effects.hover.contacts"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.tasks")) {
		setIntofRadioBox("cs_enablehovertasks",configGetKey("gui.effects.hover.tasks"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.infostore")) {
		setIntofRadioBox("cs_enablehoverinfostore",configGetKey("gui.effects.hover.infostore"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.speed")) {
		setIntofRadioBox("cs_hoverspeed",configGetKey("gui.effects.hover.speed"));
		configuration_changed_fields["gui"]=false;
	}
	$("cs_header").firstChild.nodeValue=getconfigPathSelected().substring(1);
	setTabLists(configSettingsTabsList, configSettingsPanelsList, null);
} 

function cs_enableallhover() {
		setIntofRadioBox("cs_enablehoverportal",1);
		setIntofRadioBox("cs_enablehovermail",1);
		setIntofRadioBox("cs_enablehovercalendar",1);
		setIntofRadioBox("cs_enablehovercontacts",1);
		setIntofRadioBox("cs_enablehovertasks",1);
		setIntofRadioBox("cs_enablehoverinfostore",1);
		configuration_changed_fields["gui"]=true;
}

function cs_disableallhover() {
		setIntofRadioBox("cs_enablehoverportal",0);
		setIntofRadioBox("cs_enablehovermail",0);
		setIntofRadioBox("cs_enablehovercalendar",0);
		setIntofRadioBox("cs_enablehovercontacts",0);
		setIntofRadioBox("cs_enablehovertasks",0);
		setIntofRadioBox("cs_enablehoverinfostore",0);
		configuration_changed_fields["gui"]=true;
}

function cs_init() {
    if(!configGetKey("modules.portal.module")) { $("cs_portal_hover").style.display="none"; }
    if(!configGetKey("modules.mail.module")) { $("cs_mail_hover").style.display="none"; }
    if(!configGetKey("modules.calendar.module")) { $("cs_calendar_hover").style.display="none"; }
    if(!configGetKey("modules.contacts.module")) { $("cs_contacts_hover").style.display="none"; }
    if(!configGetKey("modules.tasks.module")) { $("cs_tasks_hover").style.display="none"; }
    if(!configGetKey("modules.infostore.module")) { $("cs_infostore_hover").style.display="none"; }
	
	var myarray=configGetKey("reloadtimes");
	cs_autorefresh = new ComboBox3(window, "cs_autorefresh", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
	cs_autorefresh.addElement("Never",0);/*i18n*/
	var mTmp = function(n) { return function() { return getInterval(n); }; };
	if(configContainsKey("reloadtimes")) {
		for(var i=0;i<myarray.length;i++) {
			if(!myarray[i]== 0) {
				cs_autorefresh.addElement("",(myarray[i]/60000),mTmp(myarray[i]));
			}
		}
	}
	cs_autorefresh.getDomNode();
	
	// fake cb to prevent combobox translation 
	function cb_tmpLang(element) {
		return function() {
			return element;
		}
	}
	
	cs_language = new ComboBox3(window, "cs_language", "15em", 0, true, "OX_Configuration_Settings_Changed_Language", 3);
	for(var i in corewindow.all_languages) {
		if (i) cs_language.addElement(corewindow.all_languages[i], i,
		                       cb_tmpLang(corewindow.all_languages[i]));	
	}
	cs_language.getDomNode();
	
	cs_timezone = new ComboBox3(window, "cs_timezone", "25em", 1, true, "OX_Configuration_Settings_Changed_Timezone", 8);
	for(var i=0;i<timezones.length;i++) {
		cs_timezone.addElement(timezones[i], timezones[i].replace(/ /g, "_"));	
	}
	cs_timezone.getDomNode();
	
	cs_dateformat = new ComboBox3(window, "cs_dateformat", "9em", 0, true, "OX_Configuration_Settings_Changed_Region_Date", 8);
	cs_dateformat.addElement("M/d/yyyy"/*i18n*/, 	"M/d/yyyy");
	cs_dateformat.addElement("M/d/yy"/*i18n*/, 		"M/d/yy");
	cs_dateformat.addElement("MM/dd/yy"/*i18n*/, 	"MM/dd/yy");
	cs_dateformat.addElement("MM/dd/yyyy"/*i18n*/, 	"MM/dd/yyyy");
	cs_dateformat.addElement("yy/MM/dd"/*i18n*/, 	"yy/MM/dd");
	cs_dateformat.addElement("dd/MM/yyyy"/*i18n*/, 	"dd/MM/yyyy");
	cs_dateformat.addElement("dd/MM/yy"/*i18n*/, 	"dd/MM/yy");
	cs_dateformat.addElement("dd.MM.yyyy"/*i18n*/,	"dd.MM.yyyy");	
	cs_dateformat.addElement("dd.MM.yy"/*i18n*/, 	"dd.MM.yy");
	cs_dateformat.addElement("d.MM.yy"/*i18n*/, 	"d.MM.yy");
	cs_dateformat.addElement("d.M.yy"/*i18n*/, 		"d.M.yy");
	cs_dateformat.addElement("d.M.yyyy"/*i18n*/, 	"d.M.yyyy");
	cs_dateformat.addElement("label|yyyy-MM-dd"/*i18n*/, 	"yyyy-MM-dd");
	cs_dateformat.addElement("dd-MMM-yy"/*i18n*/, 	"dd-MMM-yy");
	cs_dateformat.getDomNode();
	
	cs_date_separator = new ComboBox3(window, "cs_dateseparator", "9em", 0, true, "OX_Configuration_Settings_Changed_Region_Date", 3);
	cs_date_separator.addElement("default"/*i18n*/, 	"default");
	cs_date_separator.addElement("/", 				"/");
	cs_date_separator.addElement(".", 				".");
	cs_date_separator.addElement("-", 				"-");
	cs_date_separator.getDomNode();
    
	/*
    var themes = [];
    var themeconfig = configGetKey("modules.themes");
    if (themeconfig) {
    	for (i in themeconfig) {
    		themes.push({ name: themeconfig[i], path: i });
    	}
        themes.sort(function(a, b) { 
        	   return (a.name.toUpperCase() < b.name.toUpperCase() ? -1 : 1); 
        	});
    } else {
        themes.push({ name: "Default", path: "default" });
    }
    
	cs_theme = new ComboBox3(window, "cs_theme", "25em", 0, true, "OX_Configuration_Settings_Changed_GUI", 3);
	for(var i=0;i<themes.length;i++) {
		cs_theme.addElement(themes[i].name, themes[i].path);	
	}	
    cs_theme.getDomNode();
    */
}

function cs_leave() { }
var cs_init_bool=false;
var cs_language;
var cs_autorefresh;
var cs_timezone;
//var cs_theme;
var cs_dateformat;
var cs_date_separator;

fileloaded();