/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

(function() {
    var team = [];

    getTeamList = function() { return team; };
    
    getTeamMember = function(id) { return team[id]; };
    
    setTeam = function(members, silent) {
        team = [];
        addToTeam(members, silent);
    };

    removeFromTeam = function(members, silent) {
        for (var i in members)
            delete team[members[i].id + ":" + members[i].type];
        if (!silent) triggerEvent("OX_Teammember_Changed", team);
    };
    
    addToTeam = function(members, silent) {
        var groups = [];
        for (var i in members) {
            var member = members[i];
            switch (member.type) {
                case 1:
                case 3:
                    team[member.id + ":" + member.type] = member;
                    break;
                case 2:
                    groups.push(member);
            }
        }
        if (groups.length) {
            internalCache.getObjects(groups, resolvedGroups(silent));
        } else {
            if (!silent) triggerEvent("OX_Teammember_Changed", team);
        }
    };
    
    function resolvedGroups(silent) {
        return function(groups) {
            var set = {};
            for (var i in groups) {
                var members = groups[i].members;
                for (var j in members) set[members[j]] = true;
            }
            var ids = [];
            for (var i in set) ids.push(Number(i));
            internalCache.getUsers(ids, resolvedUsers(silent));
        };
    }
    
    function resolvedUsers(silent) {
        return function(users) {
            for (var i in users) {
                team[i + ":1"] = {
                    id: users[i].id, type: 1,
                    display_name: users[i].display_name
                };
            }
            if (!silent) triggerEvent("OX_Teammember_Changed", team);
        };
    }

})();

var firstteam=true;
function filldefaultteam() { 
	if(firstteam) {
		var teams=new Array();
		if(configContainsKey("gui.calendar.teams")) {
			teams=configGetKey("gui.calendar.teams");
			
		}
        for(var i=0;i<teams.length;i++) {
			if(teams[i].team_default) {
                setTeam(teams[i].children, true);
				break;
			}
		}
		firstteam=false;
	}
}
register("OX_Configuration_Loaded_Complete",
function() {
	var mydivs=$("ctd_timeline_scroller").getElementsByTagName("div");
	for(var i=0;i<mydivs.length-1;i++) {
		
		mydivs[i].firstChild.nodeValue =
            formatDate(new Date(i * 36e5 /* ms/h */), "onlyhour");
	}
	ctd_scroll();
});
var team_participants_selected=new Array();
var ctd_date=new Date();

var ctd_participants = null;
var ctd_storages=new Object();
var ctd_calendar_objects=new Object();
var ctd_myteams=new Array();
function ctd_createKeyfromUserObject(object) {
	return ""+object.id+":"+object.type+"";
}

//TODO 
/** ctd_reset = true if Configuration_Changed */
//register("Loaded",);
register("OX_Calendar_Teammember_Add",team_changeTeammembers);
register("OX_Calendar_Teammember_Remove",team_removeTeammembers);
register("OX_Calendar_Team_Change",team_onchangeTeam);
register("OX_Selected_Member",team_storeSelectedMember);

function team_initContent() {
	team_createParticipantsPopUp();
}
function team_onchangeTeam() {
	popup($("menu_calendar_teammember_teams_popup"));
	var teamtbody=$("menu_calendar_teammember_teams_popup_content");
	removeChildNodes(teamtbody);
	myteams=new Array();
	if(configContainsKey("gui.calendar.teams")) {
		myteams=configGetKey("gui.calendar.teams");
	}
	var newelement;
	for(var i=0;i<myteams.length;i++) {
		newelement=$("cal_teams_template").cloneNode("true");
		newelement.id="cal_new_team-"+i;
		newelement.getElementsByTagName("div")[0].firstChild.nodeValue=myteams[i].name;
		teamtbody.appendChild(newelement);
	}
}
function ctd_selectPermanentTeam(element) {
	$("menu_calendar_teammember_teams_popup").style.display="none";
    team_participants_selected=new Array();
    setTeam(myteams[element.split("-")[1]].children);
}

function team_removeTeammembers() {
	removeFromTeam(team_participants_selected);
}
function team_changeTeammembers() {
	ctd_participants.openAddParticipantsWindow(); 
}
function team_storeSelectedMember(response) {
	team_participants_selected=response;
	triggerEvent("SubSelected",team_participants_selected.length);
}
function team_createParticipantsPopUp() {
	ctd_participants = new ParticipantsSmall(null,addToTeam,true,true,true,false,"Select Users", /*i18n*/
						false,false,false,true); 
}

var template_content_oneline; 

var ctd_reset=true;


/** Execute when display **/
function ctd_startContent() {
	triggerEvent("Selected",0);
	ctd_date = new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0));
	ctd_updateDateHeader();	
	register("OX_Teammember_Changed",ctd_membersChanged);
	if(ctd_reset) {
		ctd_createTemplates();
		ctd_reset=false;
	}
	ctd_reload();
	ctd_scroll();
}
function ctd_leaveContent() {
	unregister("OX_Teammember_Changed",ctd_membersChanged);
}
function ctd_membersChanged(allmembers) {
	ctd_reloadTeamUsers(allmembers);
}
function goToNextTeamDay(days) {
	ctd_date.setUTCDate(ctd_date.getUTCDate()+days);
	ctd_updateDateHeader();
	ctd_reload();
}
function ctd_updateDateHeader() {
	var d = $("ctd_time");
	activeMonth= ctd_date.getUTCMonth();
	activeYear = ctd_date.getUTCFullYear();
	activeDay = ctd_date.getUTCDate();
	oMiniCalendar.setSelectedByDate(activeYear, activeMonth, activeDay);
	d.firstChild.nodeValue=formatDate(ctd_date,"dateday");	
}
function ctd_changeTeammember(element) {
	for(i=0;i<team_participants_selected.length;i++) {
		var myid="ctd_"+ctd_createKeyfromUserObject(team_participants_selected[i]);
		if(document.getElementById(myid)) {
			document.getElementById(myid).className="";
		}		
	}
	var elemid=element.id.substring(4,element.id.length);
	var member = getTeamMember(elemid);
    if(member) {
		
		triggerEvent("OX_Selected_Member",[member]);
	}
	for(i=0;i<team_participants_selected.length;i++) {
		var myid="ctd_"+ctd_createKeyfromUserObject(team_participants_selected[i]);
		if(document.getElementById(myid)) {
			document.getElementById(myid).className="background-color-selection-elements font-weight-high font-color-selected";
		}		
	}
}
function ctd_fillTeammemberField(userObject) {
	var tmp;
	if(userObject) {
		tmp=$("ctd_template_users").cloneNode(true);
		tmp.id="ctd_"+ctd_createKeyfromUserObject(userObject);
		tmp.getElementsByTagName("div")[1].firstChild.nodeValue=userObject.display_name;
        tmp.getElementsByTagName("img")[0].src = getFullImgSrc("img/calendar/" +
            ({ 1: "user", 2: "group", 3: "ressourcen" }[userObject.type]
             || "user") + ".gif"); 
	}
	else {
		tmp=$("ctd_template_users_empty").cloneNode(true);
		tmp.id="ctd_empty";
	}
	return tmp;
}
function ctd_reload() {
    addToTeam([]);
}
function ctd_clearView() {
	for (var i in ctd_storages) {
		for(i2=0;i2<ctd_storages[i].divs.length;i2++) {
			var tmp=ctd_storages[i].divs[i2];
			tmp.parentNode.removeChild(tmp);
		}
	}
	ctd_storages=new Object();
	ctd_calendar_objects=new Object();
}

function ctd_reloadTeamUsers(response) {
	ctd_clearView();
	triggerEvent("OX_Selected_Member",new Array());
	var teams=$("ctd_teammembers");
	removeChildNodes(teams);
	var teamsbody=document.createElement("tbody");
	var contents=$("ctd_content");
	removeChildNodes(contents);
	var contentsbody=document.createElement("tbody");
	
	for (key in response) {
		if(response[key].type<5) {
			ctd_storages[key]=new Object();
			ctd_storages[key].userobject=response[key];
			ctd_storages[key].divs=new Array();
			ctd_storages[key].divs[0]=ctd_fillTeammemberField(response[key]);
			ctd_storages[key].divs[1]=template_content_oneline.cloneNode(true);
			teamsbody.appendChild(ctd_storages[key].divs[0]);
			contentsbody.appendChild(ctd_storages[key].divs[1]);	
		} else {
			delete response[key];
		}
	}
	teamsbody.appendChild(ctd_fillTeammemberField(null));
	teams.appendChild(teamsbody);
	contents.appendChild(contentsbody);
	fillFreeBusyRequest(response);
}
var ctd_freebusy_requests=new Object();
function fillFreeBusyRequest(response) {
	var ctd_freebusy_objects=new Object();
	ctd_freebusy_objects["request"] = new Array();
	ctd_freebusy_objects["objects"] = new Array();

	for(zaehler in response)
	{
		var requestObject = new Object();
		requestObject['module'] = "calendar";
		requestObject['action'] = 'freebusy';
		requestObject['id'] = response[zaehler].id;
		requestObject['type'] = response[zaehler].type;
		requestObject['start'] = ctd_date.getTime();
		requestObject['end']= ctd_date.getTime()+(1000*60*60*24);	
		ctd_freebusy_objects["request"].push(requestObject);
		ctd_freebusy_objects["objects"].push(response[zaehler]);
	}
	if(!ctd_freebusy_objects["request"].length>0) {
	 return;
	}
	json.put(AjaxRoot + "/multiple?session=" + session,ctd_freebusy_objects["request"],null,ctd_freeBusyResponse);
	function ctd_freeBusyResponse(response) {
		for(var i=0;i<response.length;i++) {
			ctd_storages[ctd_createKeyfromUserObject(ctd_freebusy_objects["objects"][i])]["freebusy_response"]=response[i].data;
		}
		var requestObject = new Object();
		requestObject["module"] = "calendar";
		requestObject['action'] = 'all';
		requestObject['start'] = ctd_date.getTime();
		requestObject['end']= ctd_date.getTime()+(1000*60*60*24);	
		var calendarwwfields = new Array(1,20, 207, 206, 2, 200, 201, 202, 203, 209, 220, 401, 402, 102, 400, 101);
		requestObject['columns'] = calendarwwfields.toString();		

		var requests=new Array();
		requests.push(requestObject);
		json.put(AjaxRoot + "/multiple?session=" + session,requests,null,ctd_getAllObjects);
	}
	function ctd_getAllObjects(response) {
		var oneresponse=response[0].data;

		for(var i=0;i<oneresponse.length;i++) {
			var tmpdata=oneresponse[i];
			ctd_calendar_objects[tmpdata[0]] = new CalendarWorkWeekObject(tmpdata[0],tmpdata[1],tmpdata[2],tmpdata[3],tmpdata[4],tmpdata[5],tmpdata[6],tmpdata[7],tmpdata[8],tmpdata[9],tmpdata[10],tmpdata[11],tmpdata[12],tmpdata[13],tmpdata[14],tmpdata[15],tmpdata[16]);
		}
		ctd_showObjects();
	}
}
function ctd_showObjects() {
	for (user in ctd_storages) {
		var myappointments=ctd_storages[user].freebusy_response;
		ctd_storages[user].matrix=new Array((Math.round((1000*60*60*24)/(1000*60*15))));
		for(z1=0;z1<ctd_storages[user].matrix.length;z1++)
		{
			ctd_storages[user].matrix[z1]=new Array();
		}
		if(myappointments) {
			for(var i=0;i<myappointments.length;i++) {
				ctd_drawAppointments(user,myappointments[i]);
			}
		}
	} 
}
function ctd_drawAppointments(user,appointmentfreebusy) {
	var myobject=appointmentfreebusy;
	if(ctd_calendar_objects[myobject.id]) {
		myobject=ctd_calendar_objects[myobject.id];
	}
	else
	{
		myobject.start_date=new Date(myobject.start_date);
		myobject.end_date=new Date(myobject.end_date);
	}
	ctd_drawAppointment(user,myobject);
}
var ctd_idcounter=0;
function ctd_drawAppointment(user,calendarobject)
{
	var ctdline=10;
	var myinterval=1000*60*15;
	var oneday=1000*60*60*24;
	var myintervalcounts=Math.round(oneday/myinterval);
	
	var showappointment=true;
	//Object Zaehler

	// Startdate Correction Complete Appointment
	// Setze Startzeit des Termins um , falls er vor meiner Anzeige beginnt
	var sdt=calendarobject["start_date"].getTime();
	if(sdt<ctd_date.getTime()) {
		calendarobject["start_date"]=new Date(ctd_date.getTime());
		sdt=calendarobject["start_date"].getTime();
	}
	// Setze Endzeit des Termins um , falls er nach meiner Anzeige beginnt
	var edt=calendarobject["end_date"].getTime();
	if(edt>ctd_date.getTime()+1*(oneday)) {
		calendarobject["end_date"]=new Date(ctd_date.getTime()+(1*oneday));
		edt=calendarobject["end_date"].getTime();
	}
	var sdttmp=sdt;
	while(sdttmp<edt)
	{
		showappointment=true;
		var longstart  =   (sdttmp % oneday);
		var startpoint =   Math.round(longstart/myinterval);
		var edttmp=edt;
		var longend= (edt % oneday);
		var endpoint   =   Math.round(longend/myinterval);
		// An diesem Tag nicht zu Ende
		if(sdttmp - (sdttmp % oneday) + oneday <= edt) {
			endpoint = myintervalcounts;							
		} 
		// Check Place Allocation
		
		var tiefe=0;  			//Place
		var allelements=0;		//AllElements
	
		for (zaehler=startpoint;zaehler<endpoint;zaehler++) {
			var maxelements = ctd_storages[user].matrix[zaehler].length;
			if(allelements<maxelements) {
				allelements=maxelements;
			} 
			if(ctd_storages[user].matrix[zaehler][tiefe]) {
				tiefe++;
				zaehler=startpoint;
				if(tiefe==2) {
					showappointment=false;	
					break;
				}
			}
		}
		if(!showappointment){
		//	document.getElementById("cwwmoreappointments"+sdd).style.display="";
		} else {
			var myappointment=$("ctd_appointment_template").cloneNode(true);
			myappointment.id=+calendarobject.folder_id +"-"+calendarobject.id+"-"+ctd_idcounter;
			ctd_idcounter++
			var appointmentcontainer=ctd_storages[user].divs[1].getElementsByTagName("div")[0];
		
		//FILL APPOINTMENTS
			var ddivs=myappointment.getElementsByTagName("div");
			// Shown As 
			switch (calendarobject.shown_as) {
				case 1:
					ddivs[0].className="appointmentRESERVED";
					break;
				case 2:
					ddivs[0].className="appointmentTEMPORARY";
					break;
				case 3:
					ddivs[0].className="appointmentABSENT";
					break;
				case 4:
					ddivs[0].className="appointmentFREE";
					break;
			}
			// Title 
			if(calendarobject.title) {
				ddivs[1].firstChild.nodeValue=calendarobject.title;
			}
			else {
				ddivs[1].firstChild.nodeValue="";
			}
			// Recurrence Type 
			if(calendarobject.recurrence_type) {
				if(calendarobject.recurrence_type!=0) {
					ddivs[2].style.paddingLeft="7px";
					ddivs[2].innerHTML="<img src='"+getFullImgSrc("img/calendar/calendar_series.gif")+"'></img>";
				}
			}		
			// Tagging 
			if(calendarobject.color_label && calendarobject.color_label!=0) {
				ddivs[3].style.display = "block";
				ddivs[3].style.paddingLeft="7px";
				ddivs[3].innerHTML="<img src='"+getFullImgSrc("img/menu/tag_"+calendarobject["color_label"]+".gif")+"' alt='tag' />";
			} else 
				ddivs[3].style.display = "none";
			if(calendarobject.private_flag) {
				ddivs[4].style.display = "block";
				ddivs[4].innerHTML="<img src='"+getFullImgSrc("img/private_flag.gif")+"' alt='private' />";
			} else {
				ddivs[4].style.display = "none";
			}	
			//New Element is Latest
			if(allelements<tiefe+1) {
				allelements=tiefe+1;
			}
			appointmentcontainer.appendChild(myappointment);
			for(zaehler=startpoint;zaehler<endpoint;zaehler++)
			{
				ctd_storages[user].matrix[zaehler][tiefe]=new MatrixObject(calendarobject.folder_id,calendarobject.id,calendarobject.recurrence_id,myappointment.id);
				for(superzaehler=allelements;superzaehler>=0;superzaehler--) {
					//REDRAW ALL APPOINTMENTS IF EXISTS
					if(ctd_storages[user].matrix[zaehler][superzaehler])	
					{
						myappointment.style.width=((endpoint-startpoint)*ctdline)-2+"px";	
						myappointment.style.left=startpoint*ctdline+"px";
						ctd_redrawAppointment(allelements,superzaehler,ctd_storages[user].matrix[zaehler][superzaehler].element_id);					
					}						
				}
			}
			
		}
		if(sdt==sdttmp) {
			sdttmp = sdttmp - (sdttmp % oneday);
		}
		sdttmp = sdttmp+oneday;
	}
}
function ctd_redrawAppointment(elementlength,position,elementid) {
	var d=document.getElementById(elementid);
	d.style.height=(Math.round(100/elementlength)-4)+"%";
	d.style.top=(Math.round(100/elementlength)*position)+"%";
}	
function ctd_createTemplates() {
	var startworktime  = 1000*60*60*8;
	var endworktime  = 1000*60*60*18;
	ctd_createCalendarContent(startworktime,endworktime);
}
function ctd_createCalendarContent(startworktime,endworktime) {
	var templateofftime =$("ctd_template_contentofftime");
	var templateworktime=$("ctd_template_contentworktime");
	template_content_oneline=document.createElement("tr");
	for (var i=0;i<24;i++) {
		if(((i*1000*60*60)<startworktime) || ((i*1000*60*60)>=endworktime)) {
			var mytemp=templateofftime.cloneNode(true);
			mytemp.id="";
			if(i==0) {
				mytemp.getElementsByTagName("div")[0].style.position="relative";
			}
			template_content_oneline.appendChild(mytemp);
		} else {
			var mytemp=templateworktime.cloneNode(true);
			mytemp.id="";
			if(i==0) {
				mytemp.getElementsByTagName("div")[0].style.position="relative";
			}
			template_content_oneline.appendChild(mytemp);
		}
	}
}
function ctd_scroll() {
	var scroll1=$("ctd_scroller");
	$("ctd_participants_scroller").scrollTop= (scroll1.scrollTop) ;
	$("ctd_timeline_scroller").scrollLeft=(scroll1.scrollLeft) + 20;
}
fileloaded();