/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import java.util.Date;
import net.freeutils.tnef.GUID;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

public class MAPIValue {
    int type;
    RawInputStream rawData;

    public MAPIValue(int type, RawInputStream data, int length) throws IOException {
        this.type = type;
        this.rawData = new RawInputStream(data, 0L, (long)length);
        data.skip(length);
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return (int)this.rawData.getLength();
    }

    public byte[] getData() {
        byte[] b = null;
        try {
            b = this.rawData.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return b;
    }

    public RawInputStream getRawData() throws IOException {
        return new RawInputStream(this.rawData);
    }

    public String toString() {
        try {
            Object o = this.getValue();
            if (o instanceof RawInputStream) {
                o = ((RawInputStream)o).toString();
            } else if (o instanceof byte[]) {
                o = TNEFUtils.toHexString((byte[])o, 512);
            }
            return String.valueOf(o);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.toString());
        }
    }

    public Object getValue() throws IOException {
        Object o = null;
        RawInputStream ris = new RawInputStream(this.rawData);
        switch (this.type) {
            case 1: {
                o = null;
                break;
            }
            case 2: {
                o = new Short((short)ris.readU16());
                break;
            }
            case 3: {
                o = new Integer((int)ris.readU32());
                break;
            }
            case 11: {
                o = new Boolean(ris.readU32() != 0L);
                break;
            }
            case 4: {
                o = new Float(Float.intBitsToFloat((int)ris.readU32()));
                break;
            }
            case 10: {
                o = new Integer((int)ris.readU32());
                break;
            }
            case 7: 
            case 64: {
                if (ris.getLength() != 8L) break;
                long time = ris.readU64();
                time = time / 10L / 1000L;
                o = new Date(time -= 11644473600000L);
                break;
            }
            case 5: {
                o = new Double(Double.longBitsToDouble(ris.readU64()));
                break;
            }
            case 6: 
            case 20: {
                o = new long[]{ris.readU32(), ris.readU32()};
                break;
            }
            case 72: {
                o = ris.toByteArray();
                break;
            }
            case 30: {
                o = ris.readString((int)ris.getLength());
                break;
            }
            case 31: {
                o = ris.readStringUnicode((int)ris.getLength());
                break;
            }
            case 0: 
            case 258: {
                o = ris;
                break;
            }
            case 13: {
                GUID iid = new GUID(ris.readBytes(16));
                o = ris;
                if (!iid.equals(MAPIProp.IID_IMESSAGE)) break;
                o = new TNEFInputStream(ris);
                break;
            }
            default: {
                throw new IOException("Unknown MAPI type: " + this.type);
            }
        }
        return o;
    }
}

