/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;

public class TNEFInputStream {
    static boolean ignoreChecksum = "true".equalsIgnoreCase(System.getProperty("jtnef.checksum.ignore"));
    InputStream in;
    int key;

    static void setChecksumIgnore(boolean ignore) {
        ignoreChecksum = ignore;
    }

    public TNEFInputStream(InputStream in) throws IOException {
        this.in = in;
        long signature = this.readU32();
        if (signature != 574529400L) {
            throw new IOException("Invalid TNEF signature 0x" + Long.toHexString(signature).toUpperCase() + " (not a valid TNEF stream)");
        }
        this.key = this.readU16();
    }

    public TNEFInputStream(File file) throws IOException {
        this(new RawInputStream(file));
    }

    public TNEFInputStream(String filename) throws IOException {
        this(new File(filename));
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    protected int readU8() throws IOException {
        int b = this.in.read();
        if (b == -1) {
            throw new IOException("Unexpected end of stream");
        }
        return b;
    }

    protected int readU16() throws IOException {
        return TNEFUtils.getU16(this.readU8(), this.readU8());
    }

    protected long readU32() throws IOException {
        return TNEFUtils.getU32(this.readU8(), this.readU8(), this.readU8(), this.readU8());
    }

    public Attr readAttr() throws IOException {
        RawInputStream rawData;
        int level = this.in.read();
        if (level == -1) {
            return null;
        }
        if (level != 1 && level != 2) {
            throw new IOException("Invalid TNEF level type: " + level);
        }
        int typeAndName = (int)this.readU32();
        int length = (int)this.readU32();
        if (this.in instanceof RawInputStream) {
            RawInputStream ris = (RawInputStream)this.in;
            rawData = new RawInputStream(ris, 0L, (long)length);
            if (ris.skip(length) != (long)length) {
                throw new IOException("Unexpected end of stream");
            }
        } else {
            int read;
            byte[] buf = new byte[length];
            for (int total = 0; total < length; total += read) {
                read = this.in.read(buf, total, length - total);
                if (read >= 0) continue;
                throw new IOException("Unexpected end of stream");
            }
            rawData = new RawInputStream(buf, 0L, (long)length);
        }
        int checksum = this.readU16();
        if (!ignoreChecksum && checksum != TNEFUtils.calculateChecksum(rawData)) {
            throw new IOException("Invalid checksum on attribute");
        }
        Attr attr = new Attr((byte)level, TNEFUtils.attType(typeAndName), TNEFUtils.attID(typeAndName), rawData);
        return attr;
    }

    public int getKey() {
        return this.key;
    }
}

