/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.override.internal.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import org.codehaus.annogen.override.ElementId;
import org.codehaus.annogen.override.JavadocElementIdPool;
import org.codehaus.annogen.override.internal.ElementIdImpl;
import org.codehaus.annogen.view.internal.IndigenousAnnoExtractor;
import org.codehaus.annogen.view.internal.javadoc.JavadocAnnogenTigerDelegate;
import org.codehaus.annogen.view.internal.javadoc.ParameterJavadocIAE;
import org.codehaus.annogen.view.internal.javadoc.ProgramElementJavadocIAE;
import org.codehaus.jam.provider.JamLogger;

public class JavadocElementIdPoolImpl
implements JavadocElementIdPool {
    private JavadocAnnogenTigerDelegate mJTiger;

    public JavadocElementIdPoolImpl(JamLogger logger) {
        this.mJTiger = JavadocAnnogenTigerDelegate.create(logger);
    }

    public ElementId getIdFor(ProgramElementDoc ped) {
        if (ped == null) {
            throw new IllegalArgumentException("null ped");
        }
        IndigenousAnnoExtractor iae = ProgramElementJavadocIAE.create(ped, this.mJTiger);
        if (ped instanceof PackageDoc) {
            return ElementIdImpl.forPackage(iae, ped.name());
        }
        if (ped instanceof ClassDoc) {
            return ElementIdImpl.forClass(iae, ped.name());
        }
        if (ped instanceof FieldDoc) {
            return ElementIdImpl.forField(iae, ped.containingClass().name(), ped.name());
        }
        if (ped instanceof ConstructorDoc) {
            return ElementIdImpl.forConstructor(iae, ped.containingClass().name(), this.getSignature((ExecutableMemberDoc)((ConstructorDoc)ped)));
        }
        if (ped instanceof MethodDoc) {
            return ElementIdImpl.forMethod(iae, ped.containingClass().name(), ped.name(), this.getSignature((ExecutableMemberDoc)((MethodDoc)ped)));
        }
        throw new IllegalStateException(ped.getClass().getName());
    }

    public ElementId getIdFor(ExecutableMemberDoc emd, int paramNum) {
        if (emd == null) {
            throw new IllegalArgumentException("null emd");
        }
        IndigenousAnnoExtractor iae = ParameterJavadocIAE.create(emd, paramNum, this.mJTiger);
        return ElementIdImpl.forParameter(iae, emd.containingClass().name(), emd.name(), this.getSignature(emd), paramNum);
    }

    private String[] getSignature(ExecutableMemberDoc emd) {
        if (emd == null) {
            throw new IllegalArgumentException("null emd");
        }
        Parameter[] params = emd.parameters();
        if (params == null || params.length == 0) {
            return new String[0];
        }
        String[] out = new String[params.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = params[i].name();
        }
        return out;
    }
}

