/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2006 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.groupware.tx;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractService implements Service {
	
	private final Map<Long,Object> txIds = new HashMap<Long,Object>();
	private final Map<Long,StackTraceElement[]> startedTx = new HashMap<Long,StackTraceElement[]>();
	
	protected abstract Object createTransaction()throws TransactionException;
	protected abstract void commit(Object transaction) throws TransactionException;
	protected abstract void rollback(Object transaction)throws TransactionException;

    private static final boolean rememberStacks = false;

    public void startTransaction() throws TransactionException {
		final long id = Thread.currentThread().getId();
		
		if(txIds.containsKey(Long.valueOf(id))){
			throw new TransactionException("There is already a transaction active at this moment", startedTx.get(Long.valueOf(id)));
		}
		
		final Object txId = createTransaction();
		
		txIds.put(Long.valueOf(id),txId);
		if(rememberStacks) {
            startedTx.put(Long.valueOf(id),Thread.currentThread().getStackTrace());
	    }
    }
	
	public void commit() throws TransactionException{
		commit(getActiveTransaction());
	}
	
	public void rollback() throws TransactionException{
		rollback(getActiveTransaction());
	}
	
	protected Object getActiveTransaction(){
		return txIds.get(Long.valueOf(Thread.currentThread().getId()));
	}
	
	public void finish() throws TransactionException{
		txIds.remove(Long.valueOf(Thread.currentThread().getId()));
		if(rememberStacks) {
            startedTx.remove(Long.valueOf(Thread.currentThread().getId()));
        }
	}
	
}
