/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */
 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Folder Tree Object Definition
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
 * 
 * */
var oMainFolderTree;
function cFolderTree(DOMNode, actionTree, enableDND,cache_param,state)
{
	this.cache = cache_param;
	this.tree = null;
	this.state = state;
	this.enabled_modules = {system:true,calendar:true,contacts:true,tasks:true,mail:true,infostore:true};
	this.dom_node = DOMNode;
	this.selected_node = null;
	this.events = new Events();
	this.dnd_enabled = enableDND;
	this.inplace_enabled = false;
	this.select_for_action = false;	
	this.context_menu_enabled = false;	
	this.show_new_messages = false;
	this.show_unsubscribed = false;
	this.check_read_right = true;
	this.toggle_cursor = false;
	this.register_update = false;
	this.saveConfObj = null;
	this.tree = new Tree(this.dom_node,this.state,DOMNode.id+"_tree");
	var Self = this;
	this.enable_check_fn = function (){ return true; };
	this.action_node = function (arg) {
		var oFolder = Self.cache.find_folder(Self.getFolderID(arg.id));
        if (Self.enabled_modules[oFolder.oxfolder.data.module] && Self.enable_check_fn(oFolder)) {
        	actionTree(oFolder,arg);
			//check read right befor			
			if (Self.select_for_action && 
			    (!Self.check_read_right || Self.check_read_right && computePerm(oFolder.oxfolder.data.own_rights,7)>0)) {
				Self.set_selected(arg);
			}
		} else {
			if(!arg.open) arg.setOpen(true);
		}
	};
											
	this.tree.events.register ("OX_Tree_Expand",function (node,fn_opt){Self.expand_node(node,fn_opt);});
	this.tree.events.register ("OX_Tree_Node_Click",Self.action_node);
	this.tree.events.register('OX_Tree_State_Changed',function (){Self.saveConfiguration();});
	// Disable foldertree text in foldertree
	DOMNode.onselectstart = function () { var tmp=menuselectstart ; menuselectstart = false;  return tmp; }  
	addDOMEvent(DOMNode, "mousedown", function (e) {
        if (e.button == LeftButton && !menumousedown) cancelDefault(e);
        menumousedown = false;
    });
	
	this.nodes = {};
	this.dashed = null;
	this.GALCallbacks = [];
}
cFolderTree.prototype = {
get_folder_path : function (nId,fn_callback){		
	var oF;
	//if folder already in cache
	if(oF = this.cache.find_folder(nId))
	{
		var sPath = "";
		while(oF.parent)
		{
			sPath = oF.oxfolder.data.title + "/" +  sPath;
			oF = oF.parent;
		}	
		fn_callback(sPath);		
	}
	else
		this.cache.load_path(nId,new Join(function (){
										var sPath = "";
										for(var nNumParent=0;nNumParent<this.arg2.length;nNumParent++)
										{
											sPath = this.arg2[nNumParent][1] + "/" +  sPath;
										}
										fn_callback(sPath);}),true);	
},
get_folder_path_array : function (nId,fn_callback){       
    var oF;
    //if folder already in cache
    if(oF = this.cache.find_folder(nId)) {
        var tFolder = new Array();
        while(oF.parent) {
        	tFolder.push({ id: oF.oxfolder.data.id, title: oF.oxfolder.data.title });
            oF = oF.parent;
        }   
        fn_callback(tFolder);     
    }
    else
        this.cache.load_path(nId,new Join(function (){
                                        var tFolder = new Array();
                                        for(var nNumParent=0;nNumParent<this.arg2.length;nNumParent++) {
                                        	tFolder.push({ id: this.arg2[nNumParent][0], title: this.arg2[nNumParent][1] });
                                        }
                                        fn_callback(tFolder);}),true);    
},
set_dashed: function (node){
		if(this.dashed != null)
		{
			this.dashed.text.className = removeClass(this.dashed.text.className,
																"treeHighlightDashed");    
            this.dashed.text.className += " border-color-content-default";
			this.dashed = null;
		}
		if(node)
		{
			this.dashed = node;
			this.dashed.text.className = removeClass(this.dashed.text.className,
                                                                "border-color-content-default");
			this.dashed.text.className += " treeHighlightDashed";
		}
},
destroy : function (){
	/*
	try{
	var aTemp = new Array();
	for(var nChild in this.tree.children)
	{
		aTemp.push(this.tree.children[nChild]);
	}
	for(var nindx=0;nindx<aTemp.length;nindx++)
	{
		this.tree.removeChild(aTemp[nindx]);
	}
	}catch(e){}*/
},
saveConfiguration : function ()
{	
	if(this.saveConfObj != null)	
	{	
		this.saveConfObj.setState(this.tree.getState());
	}
},
setSaveConfiguration : function (oReferObj)
{
	this.saveConfObj = oReferObj;
},	
fetchAndGetFolders : function (afolders,cb_fn){
	var aResult = {};
	function exec_cb() {
		cb_fn(aResult);
	}
	// create join
	var join_all = new Join(exec_cb);
	// add outer join
	var fn_join_outer = join_all.add();
	for(var indx=0; indx<afolders.length; indx++) {
	    // create a wrapper here. otherwise indx might contain the wrong number
	    // when the function is called.
	    var wrapper = (function(index) {
	        return function(arg) {
	            aResult[afolders[index]] = arg;
                fn_join_();
	        };
	    })(indx);
		var fn_join_ = join_all.add();
		// cache is of type "ox_folder_cache"
		this.cache.get_folder(afolders[indx], wrapper);
	}
	fn_join_outer();
},
getVisibleImapFolders : function () {
	var Self = this;
	var aFolderArr = new Array();
	
	function recTravSubTree(oChildr) {
		for (var indx in oChildr) {
			if(oChildr[indx] != undefined && Self.nodes[oChildr[indx].id] != undefined) {
				aFolderArr.push(Self.getFolderID(oChildr[indx].id));
				if (oChildr[indx].open) {
					recTravSubTree(oChildr[indx].children);
				}
			}
		}
	}
	// iterate through imap accounts
	if (mail_accounts && mail_accounts.ids.length != 0) {
		mail_accounts.newIterate(mail_accounts.ids, emptyFunction, 
				function(i, data) { 
					var rootImap = Self.nodes[Self.getDOMID("default") + data.id];
					if (rootImap != undefined) {
						recTravSubTree(rootImap.children);
					}
				}
		);
	} else {
		// something's wrong or mail_accounts is empty ... trying old
		// default account
		var rootImap = this.nodes[Self.getDOMID("default")];
		if (rootImap == undefined)
			return new Array();
		else
			recTravSubTree(rootImap.children);
	}
	
	return aFolderArr;
},
load : function (){
	var Self = this;	
	if(this.cache.folders.root.children == null)
	{
		this.cache.load_folders(this.state,new Join(function (){
            if (Self.cache.GALPresent === undefined) {
                (new JSON).get(AjaxRoot +
                    "/folders?action=list&all=1&columns=1&parent=2&session=" +
                    session, null, function(response) {
                        Self.cache.GALPresent = false;
                        for (var i = 0; i < response.data.length; i++) {
                            if (response.data[i][0] == 6) {
                                Self.cache.GALPresent = true;
                                break;
                            }
                        }
                        callGALCallbacks();
                    });
            } else {
                callGALCallbacks();
            }
            function callGALCallbacks() {
                for (var i = 0; i < Self.GALCallbacks.length; i++) {
                    Self.GALCallbacks[i](Self.cache.GALPresent);
                }
                delete Self.GALCallbacks;
            }
            Self.cache.events.trigger("initialized");
            Self.load_view(this.arg.root,Self.tree);
		}));	
	}
	else
	{
		this.cache.events.trigger("initialized");
		this.load_view(this.cache.folders.root,Self.tree,false,true);
	}
	if(this.register_update)
	{
		this.cache.events.register("Changed",function (arg){Self.update_sub_tree(arg);});
		this.cache.events.register("Deleted",function (arg){Self.delete_node(arg)});
	}
},

/**
 * Waits until the availability of the global address list is determined, then
 * calls the specified callback function.
 * @param {Function} callback The callback function which is called with
 * a single boolean parameter which is true if the global address list is
 * available and false otherwise.
 */
checkGAL: function(callback) {
    if (this.cache.GALPresent === undefined) {
        this.GALCallbacks.push(callback);
    } else {
        callback(this.cache.GALPresent);
    }
},

getFolderID : function (sId){
	var aSplited = sId.split('$');
	var sFolderID = '';
	for(var i=1;i<aSplited.length;i++)
	{
		if(i > 1)
		{
			sFolderID += '$'; 
		}
		sFolderID += aSplited[i];
	}
	return sFolderID.replace(/\$link$/,"");	
},
getDOMID : function (sId){
	return this.dom_node.id+'$'+sId;	
},
display_folder : function (nId,callback_opt){	
	var Self = this;
	var join_inge = new Join(function (){
										var folders = this.arg1;
										var aPath = this.arg2;				
										for(var indx=(aPath.length-1);indx>0;indx--)										
										{							
											var _node = Self.nodes[Self.getDOMID(aPath[indx][0])];
											if(_node && !_node.open)
											{
												_node.setOpen(true);
											}											
										}
										var sDOMFolderID = Self.getDOMID(nId);
										if(callback_opt)
											callback_opt(Self.nodes[sDOMFolderID]);		

									});
	this.cache.load_path(nId,join_inge,true);
},
set_selected : function (oNode){
	if(this.selected_node != null)
	{
		this.selected_node.text.className = removeStyleClass(this.selected_node.text.className,'background-color-PMG-selection-elements');
		this.selected_node.text.className = removeStyleClass(this.selected_node.text.className,'dndOver');
	}
	if(!oNode || !oNode.text)
	{
		this.selected_node = null;
		return;
	}
	oNode.text.className += " background-color-PMG-selection-elements";
	this.selected_node = oNode;
},
scroll_to : function (oNode)
{
	//scroll to the folder
	var nOffsetTop = oNode.div.offsetTop;
	if(this.dom_node.id == "configfoldertempl")
		$('config_folder_tree').scrollTop = nOffsetTop - $('config_folder_tree').offsetHeight/3;
	else
		this.dom_node.scrollTop = nOffsetTop - this.dom_node.offsetHeight/3;
},
load_view : function (oFolders,attPoint,bReplace,bRootOnly){
	var Self = this;
	//store all child node ids in an array
	var aOldChildrenIds = new Object();
	if(bReplace)
	{
		for(var nfolder in attPoint.children)
		{
			aOldChildrenIds[attPoint.children[nfolder].id] = true;
		}
	}
	for(var nFldr in oFolders.children)
	{			
		var OXFolder = oFolders.children[nFldr].oxfolder;
		if(oFolders.children[nFldr].oxfolder.data.module== "mail" && 
			!this.show_unsubscribed && !oFolders.children[nFldr].oxfolder.data.subscribed && !oFolders.children[nFldr].oxfolder.data.subscr_subflds)
		{
			continue;
		}
		var sNodeDOMID = this.getDOMID(OXFolder.data.id);	
		var bEnabled = true;
		if(OXFolder.data.module=='mail') {
			bEnabled = (getPermAsString(false, OXFolder.data.own_rights, 7).bit>=2)
		} else if(!(OXFolder.data.module == "infostore" && (OXFolder.data.id==9 || OXFolder.data.id==10 || OXFolder.data.id==15))) {
			if ((getPermAsString(true, OXFolder.data.own_rights, 0).bit<1
					|| getPermAsString(false, OXFolder.data.own_rights, 7).bit<1) &&  
															OXFolder.data.module != "mail" &&	
																		OXFolder.data.module != "system")
				bEnabled = false;		
			else
				bEnabled = true;						
		}				

		if (oFolders.children[nFldr].parent.oxfolder) {
			var sImageSRC = getIconImagePath(oFolders.children[nFldr].parent.oxfolder.data.id,OXFolder.data.id,
																				OXFolder.data.module,
																				false,bEnabled,
																				OXFolder.data.standard_folder);	
		} else {																						
			var sImageSRC = getIconImagePath(oFolders.children[nFldr].parent,OXFolder.data.id,
																				OXFolder.data.module,															
																				false,bEnabled,
																	OXFolder.data.standard_folder);
		}

		var sShowUnread = (parseInt(OXFolder.data.unread) > 0 && this.show_new_messages)?' (' + String(OXFolder.data.unread) + ')':'';

        var ids = configGetKey("folder");
        var replacedname = "";
        switch (OXFolder.data.id) {
            case ids.tasks:
                replacedname = "Tasks"; /*i18n*/
                break;
            case ids.calendar:
                replacedname = "Calendar"; /*i18n*/
                break;
            case ids.contacts:
                replacedname = "Contacts"; /*i18n*/
                break;
        }
		var oNode = new TreeNode(attPoint, (OXFolder.data.subfolders && 
		(oFolders.children[nFldr].oxfolder.data.subscr_subflds || oFolders.children[nFldr].oxfolder.data.subscr_subflds == null || 
																														this.show_unsubscribed)),
				 sImageSRC[0], sImageSRC[1],
                 replacedname ? addTranslated(replacedname)
                              : OXFolder.data.title,
                 sNodeDOMID, {}, sShowUnread);
		var f = OXFolder.data;
		var me = configGetKey("identifier")
        if (   f["com.openexchange.publish.publicationFlag"]
            ||    f.permissions.length > 1
               && (f.type == 1 || f.module == "infostore" && f.created_by == me))
        {
            oNode.setDecoration([getFullImgSrc("img/folder/shared.png")]);
        }
		if (OXFolder.data.id == 1) {
			if (configGetKey("modules.folder.read_create_shared_folders")) {
				oNode.div.quickinfo="Private folders are under your control and by default no other user has access to your private folders. You may share your private folders to let others look at your private folders. In case you grant other users modification permission, such changes will be done under your name.";/*i18n*/
			} else {
				oNode.div.quickinfo="Private folders are under your control and no other user has access to your private folders."; /*i18n*/
			}
		} else if (OXFolder.data.id == 2) {
			if (configGetKey("modules.folder.public_folders")) {
				oNode.div.quickinfo="Public folders are available for all users or selected user groups as determined by the administrator. The access rights can be denied for individual users or user groups. If a user creates an object in a public folder, he acts on behalf of himself, and the object will be created under his name.";/*i18n*/
			} else {
				oNode.div.quickinfo="Public folders are readable for all users or selected user groups as determined by the administrator."; /*i18n*/
			}
		} else if (OXFolder.data.id == 3) {
			oNode.div.quickinfo="Shared folders are folders where another user has given you access. In case you are allowed to modify items in a shared folder, you make these changes on behalf of the folder's owner.";/*i18n*/
		} else if (OXFolder.data.id == 9) {
			oNode.div.quickinfo="Document sharing, storage & management - The centralisation of documents is the key to teamwork. Combined with version control an organisation can work from a united vision that is always up-to-date."; /*i18n*/
		} else if (OXFolder.data.id == 10) {
			oNode.div.quickinfo="The UserStore includes all shared personal InfoStore folders from other users. This means, if an user shared his InfoStore folder or the subfolder structure, the user can see the objects.";/*i18n*/
		} else if( OXFolder.data.id == 14) {
			oNode.div.quickinfo="Other InfoStore folders contain shared subfolders from parent folders that are not accessible to you.";/*i18n*/
		}
		
		if (parseInt(OXFolder.data.unread) > 0 && this.show_new_messages) {
			oNode.text.className += ' font-style-lable';
		}
		
		if (!bEnabled) {
			oNode.text.className += ' font-style-low font-color-disabled';
		}
		
		if (!this.enabled_modules[OXFolder.data.module] || !(this.enable_check_fn(oFolders.children[nFldr]))) {
			oNode.text.className += " font-color-disabled";
			if(!OXFolder.data.subfolders) {
				oNode.icon.style.cursor = "default";
				oNode.text.style.cursor = "default";	
			}
		}
		
	 	if (this.dnd_enabled) {
			this.register_dnd(oNode);
	 	}
			
		if (this.inplace_enabled) {		
		 	oNode.inpl_edit = new inplaceEdit(oNode.text, 
			 	    OXFolder.data.title, 
					(function(id_cl) {
						return function (sStr,oObj){
                                renameFolder(id_cl,{title:sStr});
                            };
					})(OXFolder.data.id)
				);
		 	//oNode.input_width = "100%";
		}
		
		var oOldNode = this.nodes[sNodeDOMID];
		if (oOldNode != undefined && bReplace && oOldNode.div.parentNode != null && 
		    oOldNode.parent.id == attPoint.id) {
			aOldChildrenIds[sNodeDOMID] = false;
			this.nodes[sNodeDOMID] = oNode;			
			attPoint.replaceChild(oNode,oOldNode);
		} else {
		 	this.nodes[sNodeDOMID] = oNode;
			attPoint.addChild(oNode);
		}
		
		if (this.context_menu_enabled && oNode.tree_id == "folder_tree_tree") {
            (function(node) {
                addDOMEvent(node.table_Node, "contextmenu", function(e) {
                    stopEvent(e);
                    var menu = globalContextMenus.folders;
                    menu.display(e.clientX, e.clientY, { data: node });
                    // Hack until trees get a real selection
                    Self.set_dashed(node);
                    var prev = menu.hide.prev || menu.hide;
                    menu.hide = function() {
                        Self.set_dashed();
                        this.hide = prev;
                        this.hide();
                    }
                    menu.hide.prev = prev;
                });
            })(oNode);
		}
			
		if (this.check_read_right &&
           computePerm(OXFolder.data.own_rights,7) == 0 && !(OXFolder.data.subfolders)) {
			oNode.text.style.cursor = "default";
			oNode.icon.style.cursor = "default";								
		}
			
		//display user name on private folder
		if(OXFolder.data.id == 1) {
			var oObjNode = oNode.textnode;
			internalCache.getUsers([configGetKey("identifier")], 
                function(cbObj) {
				    oObjNode.data = cbObj[configGetKey("identifier")].display_name;
                }					
			);
		}
		
		//mark selected folder
		if(this.selected_node != null && this.selected_node.id == sNodeDOMID) {
			this.set_selected(oNode);
		}
	}
	
	var aNodesToRemove = new Array();
	for(var nOldN in aOldChildrenIds)
	{
		if(aOldChildrenIds[nOldN])
			aNodesToRemove.push(nOldN);
	}
	this.remove_nodes(attPoint,aNodesToRemove);		
	this.events.trigger("created");
},
remove_nodes : function (attPoint,aNodesToRemove){
	for(indx=0;indx<aNodesToRemove.length;indx++)
	{
		attPoint.removeChild(this.nodes[aNodesToRemove[indx]]);
		delete this.nodes[aNodesToRemove[indx]];
	}
},
get_folder_by_node_id : function (node_id)
{
	return this.cache.find_folder(this.getFolderID(node_id));
},
expand_node : function (oNode,fn_opt){
	var Self = this;
	var parentCache = this.get_folder_by_node_id(oNode.id);
	var childrennodes = false;
	for(var i in oNode.children) {
		childrennodes = true;
		break;
	}
	if (parentCache && parentCache.children == null) {
		this.cache.do_load_subfolders(this.getFolderID(oNode.id),parentCache ,{},function (arg)
																{								
																	Self.load_view(arg,oNode,false,true);
																	if(fn_opt)
																		fn_opt();
																}			
		);
	} else { 
		if(!childrennodes) {			
				Self.load_view(parentCache,oNode,false,true);
				if (fn_opt) fn_opt();
		} else if (fn_opt) fn_opt();
	}
	
},

update_sub_tree : function(ofolder) {
	var Self = this;
	var oSubRoot = this.nodes[this.getDOMID(ofolder.oxfolder.data.id)];
	if(ofolder == undefined || oSubRoot == undefined)
		return;
	this.load_view(ofolder,oSubRoot,true);
	this.tree.setState(this.state);
},

delete_node : function (folderID) {
	if (oUnreadCounterStorage) {
		oUnreadCounterStorage.unregister(folderID);
	}
	
    // remove node from fast access cache
    delete(oMainFolderTree.cache.fast_access[folderID]);
	
	var folderObj = oMainFolderTree.nodes[oMainFolderTree.getDOMID(folderID)];
	if (!folderObj) return; // nothing found   
    
    // remove node from DOM tree
    if (folderObj.parent) {
    	folderObj.parent.removeChild(oMainFolderTree.nodes[oMainFolderTree.getDOMID(folderID)]);
        delete(oMainFolderTree.nodes[oMainFolderTree.getDOMID(folderID)]);
    }
    
    // remove node from folder cache
    var parentFolder = folderObj.parent ? oMainFolderTree.get_folder_by_node_id(folderObj.parent.id) : null;	
    if (parentFolder && parentFolder.children) {
    	delete(parentFolder.children[folderID])
    	if (isEmpty(parentFolder.children)) parentFolder.children = null;
    }    
    return parentFolder;
},
register_dnd : function (currentNode) {
		function fn(sFolderId) {
			return function() {
				var dwi = sFolderId;
				return dwi;
			}
		}
		function fn2(sFolderId,node){
			return function (event,dragType,data,mouseposition,targetNode,dropNode)	{
				clearOpenNOdeOver(event,dragType,data,mouseposition,null,dropNode);
				var oMovedfolder = oMainFolderTree.cache.find_folder(data);				
				if(moveAllowed(oMovedfolder.parent,
									oMovedfolder,oMainFolderTree.cache.find_folder(oMainFolderTree.getFolderID(node.id)))) {
					var dwi2 = sFolderId;
					var targetNode = oMainFolderTree.cache.find_folder(dwi2);					
					var currNode = oMainFolderTree.cache.find_folder(data);
					var sourceNode = currNode.parent;
					//targetNode.div.className = removeClass(targetNode.div.className, "dndOver");
					folderServerMove(sourceNode,currNode,targetNode,false);
				}
			}
		}
//OUT
		function clearDNDImagesFolder(e) {
			if (document.getElementById("folder_node_dd")) {
				document.getElementById("folder_node_dd").parentNode.removeChild(document.getElementById("folder_node_dd"));				
			}
		}
		var TImeOutOpen;
		function clearOpenNOdeOver(e,dragType,draggedObjects,mouseposition,OutOpen,dropNode) {
			if (TImeOutOpen) {
				clearTimeout(TImeOutOpen);
			}
			if (dropNode) {
				dropNode.className = removeClass(dropNode.className, "dndOver");	
			} else if (e) {
				var mynode = e.currentTarget || e.srcElement || false;
				if (mynode) {
					mynode.className = removeClass(mynode.className, "dndOver");  
				}
			}
		}
//IN
		function fnOver(node,bNoHighlight) {
			return function (e,dragType,draggedObjects,mouseposition,targetNode) {
				foldertreeenable(e, dragType, draggedObjects, mouseposition, targetNode, node);
				var mynode = e.currentTarget || e.srcElement || false;
				if(!bNoHighlight && !mynode.className.match(/dndOver/)) {
					mynode.className += " dndOver";
				}
				var nnNode = node;
				function setOpenFN() {
					if (!nnNode.open) {
						nnNode.setOpen(true);
					}				
				}
				if (TImeOutOpen) {
					clearTimeout(TImeOutOpen);
				}
				return (TImeOutOpen = setTimeout(setOpenFN,1000));
			}
		}	
		function fnMailAddress(node) {
			return function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {				
				createNewContactfromMail(draggedObjects,node.data.id);
				if(dropNode) {
                    dropNode.className = removeClass(dropNode.className, "dndOver");    
                }
			}
		}			
		var oSubFolder = oMainFolderTree.cache.fast_access[oMainFolderTree.getFolderID(currentNode.id)];
		var oRights = oSubFolder.oxfolder.data.own_rights;
		var tObj = new Object();
		
		if (!(getPermAsString(true, oRights, 0).bit < 4 && oSubFolder.oxfolder.data.module != 'mail')) {
			if (oSubFolder.oxfolder.data.type == 5 && oSubFolder.oxfolder.data.id == 1) {
				tObj["folder/1"] = fn2(oSubFolder.oxfolder.data.id,currentNode);
			} else if (oSubFolder.oxfolder.data.type == 5 && oSubFolder.oxfolder.data.id == 2) {
				tObj["folder/2"] = fn2(oSubFolder.oxfolder.data.id,currentNode);
			} else if (oSubFolder.oxfolder.data.type == 5 && oSubFolder.oxfolder.data.id == 10) {
				tObj["folder/2"] = fn2(oSubFolder.oxfolder.data.id,currentNode);				
			} else {
				tObj["folder/" + oSubFolder.oxfolder.data.type] = fn2(oSubFolder.oxfolder.data.id,currentNode);
			}
		}
                
		/*
		 * check if user has writeObject permissions and if it's not a 
		 * shared folder of module calendar, tasks or contacts. move operations
		 * into a shared folder of the named modules will be declined by the server
		 */
		var tmp_module = oSubFolder.oxfolder.data.module;
		if (computePerm(oRights,0) >= 2 && 
		    !(oSubFolder.oxfolder.data.type == 3 && tmp_module == "tasks")) {			
			/*
			 * user has writeObject permissions on this folder, register event
			 * which handles move operations
			 */
			tObj[oSubFolder.oxfolder.data.module] = (function(folderID) {
				return function(e,dragType,data,mouseposition,targetNode,dropNode) { 
                    clearOpenNOdeOver(e,dragType,data,mouseposition,null,dropNode);
                    if (oSubFolder.oxfolder.data.type == 2) {
                        for (var i in data.currentObjects) {
                            if (data.currentObjects[i].private_flag)
                                return;
                        }
                    }
                    data.endMoving(folderID);
				}
			})(oSubFolder.oxfolder.data.id);
		} else {
			/*
			 * user doesn't have writeObject permissions or it's a shared folder 
			 * so register dummy event
			 */
			tObj[oSubFolder.oxfolder.data.module] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
                clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
            };
		}
			
		if (oSubFolder.oxfolder.data.module != "contacts") { 
			tObj["contacts"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
				clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
			};
		}
		if (oSubFolder.oxfolder.data.module != "tasks") { 
			tObj["tasks"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
				clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
			};
		}
		if (oSubFolder.oxfolder.data.module != "calendar") { 
			tObj["calendar"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
				clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
			};
		}
		if (oSubFolder.oxfolder.data.module != "infostore") { 
			tObj["infostore"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
				clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
			};
		}
		if (oSubFolder.oxfolder.data.module != "mail") { 
			tObj["mail"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
				clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
			};
		}
		if (oSubFolder.oxfolder.data.module == "contacts") { 
			tObj["mailaddress"] = fnMailAddress(oSubFolder.oxfolder);
		} else { 
			tObj["mailaddress"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) { 
				clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
			};
		}
		
		registerTarget(currentNode.text,tObj,null,null,fnOver(currentNode),fnOver(currentNode),clearOpenNOdeOver,true);
		registerTarget(currentNode.icon,tObj,null,null,fnOver(currentNode),fnOver(currentNode),clearOpenNOdeOver,true);
		//No highlighting for plus icons (expand folders)
		registerTarget(currentNode.plus,tObj,null,null,fnOver(currentNode,true),fnOver(currentNode,true),clearOpenNOdeOver,true);			

		if (!(getPermAsString(false, oRights, 28).bit != 1 && 
		   oSubFolder.oxfolder.data.module != 'mail' || oSubFolder.oxfolder.data.standard_folder)) {
			registerSource(currentNode.text, "folder/" + oSubFolder.oxfolder.data.type, fn(oSubFolder.oxfolder.data.id),null,null, foldertreedisable, defaultdisabledremove);
			registerSource(currentNode.icon, "folder/" + oSubFolder.oxfolder.data.type, fn(oSubFolder.oxfolder.data.id), null,null,foldertreedisable, defaultdisabledremove);											
		}
	},
	action_node: emptyFunction,
	getState: function() { 
		return this.tree.getState(); 
	},
	update: function (arg_1, arg_2, arg_3) { 
		this.cache.update(arg_1,arg_2,arg_3); 
	}
}

function setActiveFolder(sFolderId,fn,bScrollTo) {
	if(sFolderId) {		
		activefolder = sFolderId;
		function cb_load_path(node) {
			if(fn) fn(node);
			oMainFolderTree.set_selected(node);		
			if(bScrollTo) oMainFolderTree.scroll_to(node);		
		}
		oMainFolderTree.display_folder(sFolderId,cb_load_path);
	}
}

/**
 * check if a folder has no object read permissions
 * common for root folders and system folders
 */
function onlyParentFunc(OXFolder) {
	return computePerm(OXFolder.data.own_rights, 7) == 0;
}

function isDefaultMailFolder(sFolderId) {
	var oDefaultMailFldrs = configGetKey("mail.folder");
	for (var nfldr in oDefaultMailFldrs) {
		if (oDefaultMailFldrs[nfldr] == sFolderId) {
			return true;
		}
	}
	return false;
}

function renamingAllowed(OXFolder) {
	oRights = OXFolder.data.own_rights;
	if ((OXFolder.data.module != 'mail' && 
        (computePerm(oRights, 28) != 1 || OXFolder.data.standard_folder || OXFolder.data.module == 'system')) || 
        (OXFolder.data.module == 'mail' && 
        (!(computePerm(oRights, 28)==1) || isDefaultMailFolder(OXFolder.data.id)))) {
		return false;	
	}
	return true;
}

function deleteAllowed(OXFolder) {
	oRights = OXFolder.data.own_rights;	
	if ((OXFolder.data.module != 'mail' && 
	    (computePerm(oRights, 28) != 1 || OXFolder.data.standard_folder) || 
	    (OXFolder.data.module == 'mail' && 
	    (!(computePerm(oRights, 28)==1) || isDefaultMailFolder(OXFolder.data.id))))) {
		return false;
	}
	return true;	
}

function moveAllowed (parentFolder1, folder1, targetFolder1, bIgnoreEqualTarget) {
	var parentFolder=parentFolder1.oxfolder;
	var folder=folder1.oxfolder;
	var targetFolder=targetFolder1.oxfolder;
	// source == parent of folder to move
	// target = targetfolder
	// folder = folder itself
	if (parentFolder.data.id == targetFolder.data.id && !bIgnoreEqualTarget) return false;
	//Prevent moving into folder itself
	if (folder.data.id == targetFolder.data.id) return false;
	//Prevent moving shared folders 
	if (folder.data.type == 3 || targetFolder.data.type == 3) return false;
	//Prevent moving system folders
	if (folder.data.type == 5) return false;
	//Prevent moving private folders to other folders than private folders
	if (folder.data.type == 1 && (targetFolder.data.type != 1 && targetFolder.data.id != 1 )) return false; 
	//Prevent moving public folders to other folders than public folders
	if (folder.data.type == 2 && (targetFolder.data.type != 2 && targetFolder.data.id != 2)) return false;
	//Prevent moving folders to other not allowed modules
	if (folder.data.module != targetFolder.data.module) {
		if (folder.data.module == "mail" && !(targetFolder.data.module=="system") || folder.data.module == "infostore") 
            return false; 
		if ((folder.data.module == "calendar" || folder.data.module=="tasks" || folder.data.module=="contacts") &&
            !(targetFolder.data.module=="calendar" || targetFolder.data.module=="tasks" || targetFolder.data.module=="contacts" || targetFolder.data.module=="system"))
            return false; 
	}
	
	//Check targetfolder is subfolder of folder
	var aparent=targetFolder1.parent;
	while (aparent) {
		if (aparent.oxfolder && aparent.oxfolder.data.id == folder.data.id) return false;
		aparent = aparent.parent 
	}
	//Check rights Admin right source folder and create subfolders targetfolder
	if (computePerm(folder.data.own_rights, 28) != 1 || computePerm(targetFolder.data.own_rights, 0) < 4) 
        return false;
	
	return true;
}

function folderServerMove(sourceFolder, Folder, targetFolder, bOnlyServerMove, fn_cb_fm) {
		if (sourceFolder.oxfolder.data.id == targetFolder.oxfolder.data.id || 
            Folder.oxfolder.data.id == targetFolder.oxfolder.data.id) return;

		var oFolder = new Object();
		oFolder['folder_id'] = targetFolder.oxfolder.data.id ;
		function cb_move_folder(arg) {
			if(arg && arg.error) return;
			triggerEvent("OX_New_Info", 4, _("Folder was moved successfully"));				
			folderTreeFolderToMove = -1;
			if (Folder.oxfolder.data.module == "mail") {
				oMainFolderTree.update(null, true, function() {
					oMainFolderTree.display_folder(targetFolder.oxfolder.data.id);
                });
			} else {
				oMainFolderTree.update(null, false, function() {
					oMainFolderTree.display_folder(Folder.oxfolder.data.id);
				});
			}
			if (fn_cb_fm) fn_cb_fm();
		}
		doAjaxUpdateRequest(Folder.oxfolder.data.id, 
                oFolder,Folder.oxfolder.timestamp, cb_move_folder, function(){});
}

function setAfterLabelByFolderId(sFolderId, str, bBold) {
	var oNode = oMainFolderTree.nodes[oMainFolderTree.getDOMID(sFolderId)];
	if(oNode == undefined) return;
	oNode.afterLabel.innerHTML = str;	
	if(bBold) {	
		oNode.text.className = removeClass(oNode.text.className,'font-style-lable');
		oNode.text.className += ' font-style-lable';
	} else {		
		oNode.text.className = removeClass(oNode.text.className,'font-style-lable');
	}
}

function setUnreadNumber(sFolderId, nUnreadNumber) {
	if (nUnreadNumber > 0)
		setAfterLabelByFolderId(sFolderId, '&nbsp;(' + String(nUnreadNumber) + ')', true);
	else		
		setAfterLabelByFolderId(sFolderId, '',false);	
}

function getFolderRightFolderAdmin(ofolder) {	
	return (ofolder.oxfolder.data.own_rights & Math.pow(2,28)) ? true : false;	
}

function removeStyleClass(sClasses,sClassToRemove) {
	var sNewClasses = '';	
	var aTMP = sClasses.split(' ');
	for(var nInd=0;nInd < aTMP.length;nInd++) {
		var sCl = aTMP[nInd];
		if(sCl != sClassToRemove)
			sNewClasses += ' ' + sCl;
	}
	return sNewClasses;
}

function getFolderRightCreateSubFolders(ofolder) {
	var oLocOwnRights = ofolder.oxfolder.data.own_rights;
	var bPermFolderBit = computePerm(oLocOwnRights, 0);	
	return (bPermFolderBit>=4)?true:false;	
}

function disableIcon(sIcon) {
	var sOldIcon = sIcon;	
	var aTMP = sOldIcon.split('/');
	var newIcon = '';
	for (nInd=0; nInd<aTMP.length; nInd++)	{
		if (nInd < aTMP.length-1) {
			newIcon += aTMP[nInd] + '/';
		} else {
			var aTMP2 = aTMP[nInd].split('.');
			newIcon += aTMP2[0] + '_dis.'+ aTMP2[1];
		}
	}	
	return newIcon;					
}

function getPermAsString(bFolder, nBits, nOffset) {
    switch (nOffset) {
        case 28:
        case 29:
            return f(1, { 0: "No"/*i18n*/, 1: "Yes"/*i18n*/ });
        case 0:
            return f(127, { 0: "none"/*i18n*/, 1: "see"/*i18n*/,
                            2: "create objects"/*i18n*/,
                            4: "create subfolders"/*i18n*/,
                            64: "admin"/*i18n*/ });
        default:
            return f(127, { 0: "none"/*i18n*/, 1: "own"/*i18n*/,
                            2: "all"/*i18n*/, 64: "admin"/*i18n*/ });
    }
    function f(mask, strings) {
        nBits = (nBits >> nOffset) & mask;
        return { string: _(strings[nBits]), bit: nBits };
    }
}

/**
 * Constructor of the subscribe E-Mail folder dialog
 */
function SubscribeFolder() { };
SubscribeFolder.changedFolders = new Array(); // temp storage for changed items
SubscribeFolder.listFolder = function (myFolder, cNode) {
    for (var i in myFolder.children) {
        var OXFolder = myFolder.children[i];
        // no mail folder, so ignore it ...
        if (OXFolder.oxfolder.data && OXFolder.oxfolder.data.module == "mail") {	        	
        	SubscribeFolder.addFolderToList(OXFolder, cNode);        	
        } 
    }                                               
    $("subscribe_folder_status").style.display="none";

};
SubscribeFolder.addFolderToList = function (OXFolder, contentNode) {
	var sNode = newnode("td",{ width: "18px" },0,
                       [
                           newnode("img",{ verticalAlign: "middle" },{ className: OXFolder.oxfolder.data.subfolders ? "tree-children" : "tree-nochildren", 
                                src: OXFolder.oxfolder.data.subfolders ? getFullImgSrc("img/plus.gif") : getFullImgSrc("img/noplus.gif")})
                       ]
                   );
    sNode.onclick = (function(folder, node) {
    	   return function() {
    	   	   if (!folder.oxfolder.data.subfolders) return;
    	   	   if (node.firstChild.src.match(/plus.gif/)) {
    	   	   	   $("subscribe_folder_status").style.display="block";
    	   	   	   $("subscribe_folder_status").style.top="19px";             
                   var tNode = newnode("div",{marginLeft: "18px", whiteSpace: "nowrap"},0);
	               node.parentNode.parentNode.parentNode.parentNode.appendChild(tNode);            
	               oMainFolderTree.cache.do_load_subfolders(folder.oxfolder.data.id, oMainFolderTree.cache.find_folder(folder.oxfolder.data.id), {}, 
	                  function(arg) {
	                     node.firstChild.src=getFullImgSrc("img/minus.gif");
	                     node.firstChild.className="tree-nochildren";
	                     SubscribeFolder.listFolder(arg, tNode);
	                  });
    	   	   } else {    	   	   	   
    	   	   	   node.parentNode.parentNode.parentNode.parentNode.removeChild(node.parentNode.parentNode.parentNode.nextSibling);
                   node.firstChild.src=getFullImgSrc("img/plus.gif");
                   node.firstChild.className="tree-children";   	   	   	
    	   	   }
    	   }
    	   
        })(OXFolder, sNode);
	var iNode = newnode("input",0,{ type: "checkbox",
	           id: "sub_folder_" + OXFolder.oxfolder.data.id, 
		       oxid: OXFolder.oxfolder.data.id,		       
		       className: "noborder"
	       });
	/*
	 * setting checked attribute only if folder is subscribed
	 */ 
	if (OXFolder.oxfolder.data.subscribed == true) {
		iNode.setAttribute("checked", "checked");
	}  
	iNode.onchange = (function(node) {
                        return function() {
                        	SubscribeFolder.addChangedItem( { id: node.oxid, data: { subscribed: node.checked ? 1 : 0 } });
                        }
                    })(iNode);
	contentNode.appendChild(
	   newnode("div", 0, { className: "tree-div" }, [
	       newnode("table",{borderCollapse:"collapse",borderWidth:"0",borderSpacing:"0",width:"100%"},0,
	           [   
	               newnode("tbody",{width:"100%"},0,
		               [
					       newnode("tr",0,0,
					           [
					               sNode,
					               newnode("td",{ width: "18px" },0,[
					                   newnode("img",{ verticalAlign: "middle" },{ src: getFullImgSrc("img/folder/folder_closed.gif") })]
					               ),
					               newnode("td",0,0,[ document.createTextNode(OXFolder.oxfolder.data.title) ]),
					               newnode("td",{ width: "30px", verticalAlign: "middle" },0,[ iNode ])
					           ])
					   ])
			     ])
	       ])
        );
    /*
     * Workaround to fix checkbox selection bug in IE
     * As long as the node hasn't been appended to the DOM tree IE6 will ignore
     * setting the checked attribute. A timeout takes care that the node will be
     * appended first.
     */
    if (OXFolder.oxfolder.data.subscribed == true) {
    	setTimeout(function() { 
    		iNode.setAttribute("checked", "checked");
    	}, 0);
    }
}
SubscribeFolder.addChangedItem = function(item) {
	for (var i = 0; i < SubscribeFolder.changedFolders.length; i++) {
		if (SubscribeFolder.changedFolders[i].id == item.id) {
		  SubscribeFolder.changedFolders.splice(i, 1);
		  break;
		}
	}
	item["module"] = "folder";
	item["action"] = "update";
	SubscribeFolder.changedFolders.push(item);
}
SubscribeFolder.saveChanges = function () {
	if (SubscribeFolder.changedFolders.length == 0) {
		SubscribeFolder.closeWindow();
		return;
	}
	$("subscribe_folder_status").style.display="block";
	$("subscribe_folder_status").style.top="19px"; 
	newFolderJson.put(AjaxRoot + "/multiple?session=" + session, SubscribeFolder.changedFolders, null, 
	   function(data) {	   	   
	   	   oMainFolderTree.update(null,true, function() {
	   	   	   SubscribeFolder.closeWindow();
	   	   })
	   });
}
SubscribeFolder.openWindow = function () {		
	var scrollBar = mail_accounts.ids.length > 3 ? 4 : null;	
	var accSel = new ComboBox3(window, "subscribe_folder_account", "20em", 0, true, "cb_subscribe_folder_acc_chd", scrollBar);
	mail_accounts.newIterate(mail_accounts.ids, emptyFunction, 
		function(i, data) { 
			accSel.addElement(data.name, "default"+data.id);
		}
	);
	accSel.getDomNode();
	register("cb_subscribe_folder_acc_chd", SubscribeFolder.changeAccount);
	SubscribeFolder.changeAccount(accSel.getKey());
}
SubscribeFolder.changeAccount = function(id) {
	SubscribeFolder.changedFolders = new Array(); 
    showNode("disable_background_window");
    $("disable_background_window").style.display="block";
    removeChildNodes($("subscribe_folder_content"));
    $("subscribe_folder_status").style.display="block";
    $("subscribe_folder_status").style.top="19px"; 
    oMainFolderTree.cache.do_load_subfolders(id, oMainFolderTree.cache.find_folder(id), {}, 
            function(arg) {
               SubscribeFolder.listFolder(arg, $("subscribe_folder_content"));
            });    
    showNode("subscribe_folder");
    centerPopupWindow($("subscribe_folder"));
    $("subscribe_folder").style.display="block";
}
SubscribeFolder.closeWindow = function () {
	unregister("cb_subscribe_folder_acc_chd", SubscribeFolder.changeAccount);
	SubscribeFolder.changedFolders = new Array();
    hideNode("subscribe_folder");
    $("subscribe_folder").style.display="none"; 
    hideNode("disable_background_window");
    $("disable_background_window").style.display="none";
}
fileloaded();