/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

function  portalExternalItem(sId,sModule,oDOMContainerDiv,oDOMHeaderDiv,oParams,oAdj,oCell,oResizeDiv,sUrl){
	this.module = sModule;
	this.id = sId;
	this.resize_div = oResizeDiv;
	this.adjust = oAdj;
	
	this.autorefresh  = false;
	this.standalone = false;
	
	this.params = oParams;
	
	this.oDOMTD = oCell;
	this.container = oDOMContainerDiv;
	this.header = oDOMHeaderDiv;
	this.newportal = true;
	
	this.uwa;
	this.url = sUrl;
	
	this.privheader;
	
	this.extern = true;
}
portalExternalItem.prototype = {
	getHTML: function (){
	
	this.privheader = newnode('div',{paddingLeft:"4px",textAlign:"left",height:"1.6em",width:"100%",overflow:"hidden",whiteSpace:"nowrap"},
									{className:"font-style-headline background-color-additional-content"});	
	this.privheader.appendChild(newnode('div',{paddingLeft:"30px"},0,[addTranslated(this.module)]));
	this.header.appendChild(this.privheader);
	this.container.style.overflow = "hidden";	
	this.appendFrame();
	},
	deleteFrame: function (){
		removeChildNodes(this.container);
		this.uwa = null;
		/*
		this.uwa = oIfrExt.contentWindow.getWDG(this.container,this.url,this.params);
		this.uwa.setPreferencesValues(this.params);	
		*/
	},
	appendFrame:function (){
		this.uwa =new UWAWidget({ inline: false,id:this.id, container: this.container,
														    moduleUrl: this.url, standalone: this.standalone } );
		this.uwa.setConfiguration( { 'title':'',  'borderWidth':'0', 
							    'color':'#aaaaaa', 'displayTitle':false, 'displayFooter':false } );	 
//		this.uwa = oIfrExt.contentWindow.getWDG(this.container,this.url,this.params);
		this.uwa.setPreferencesValues(this.params);				
	},
	update_content:function (newdata){
		this.uwa.setPreferencesValues(newdata.parameter);
		this.uwa.moduleUrl = newdata.url;
		this.uwa.updateIframeUrl();
		removeChildNodes(this.privheader);
		this.module = newdata.title;
		var oHeaderTextNode = document.createTextNode(this.module);
		this.privheader.appendChild(newnode('div',{paddingLeft:"30px"},0,[oHeaderTextNode]));		
		
		this.autorefresh = newdata.autorefresh;
	},
	disable : function (){
	
	},
	update: function ()
	{
		if(this.autorefresh)
			this.uwa.updateIframeUrl();		
	}
};

function portalItem(sModule,oDOMContainerDiv,oDOMHeaderDiv,limitParam,oAdj,oCell,oResizeDiv)
{
	this.module = sModule;
	this.id = this.module;
	this.resize_div = oResizeDiv;
	this.adjust = oAdj;
	this.oDOMTD = oCell;
	this.container = oDOMContainerDiv;
	this.header = oDOMHeaderDiv;
	this.newportal = true;
	
 	this.limit_count = limitParam;
 	this.live_grid = null;

	//comma separated list of columns which be displayed
	this.columns = initColumns(sModule);
	this.sDate = 0;
	this.error;
	this.data = new Array();	
	this.id_assoc = new Object();
	this.timestamp;
	
	this.sort = initSortParam(sModule);
	this.order = initOrderParam(sModule);
	
	this.column_heads = initColHeads(sModule);
	this.column_functions = initColFunctions(sModule);
	this.col_width = getArrayWidth(sModule);
	var Self = this;
	this.style = getStyle(sModule);
	this.ranges = getRanges(sModule);
	var UserArray = new Array();	
	function getRanges(sModule)
	{
							
		var aRanges = new Array();
		switch (sModule){
			case "calendar":					
					var t = new Date();		
					t.setUTCHours(0);	
					t.setUTCMinutes(0);
					t.setUTCSeconds(0);
					var nStartDay = t.getUTCDay();
					tend = new Date(t);
					tend.setUTCDate(tend.getUTCDate()+1);					
					for(var nIndx=nStartDay;nIndx<=7;nIndx++)
					{
						if(nIndx == nStartDay)
							var sHeadName = "Today"; /*i18n*/
						else
							var sHeadName = weekdays.untranslated[t.getUTCDay()];
						var lgObj = Self.createLg(sHeadName);
						aRanges.push({name:sHeadName,range:{start:t.getTime(),end:tend.getTime()},limit:Infinity,lg:lgObj.lg,section:lgObj.section});
						t.setUTCDate(t.getUTCDate()+1);						
						tend.setUTCDate(tend.getUTCDate()+1);
					}
					tend.setUTCDate(tend.getUTCDate()-1);
					tnextend = new Date(tend);
					tnextend.setUTCDate(tnextend.getUTCDate()+7);
					var lgObj = Self.createLg("Next Week");
					aRanges.push({name:"Next Week", /*i18n*/
					    range:{start:tend.getTime(),end:tnextend.getTime()},limit:Infinity,lg:lgObj.lg,section:lgObj.section});
					var tnextyear = new Date();			
					tnextyear.setUTCHours(0);
					tnextyear.setUTCMinutes(0);			
					tnextyear.setUTCSeconds(0);						
					tnextyear.setUTCFullYear(tnextyear.getUTCFullYear()+1);
					tnextyear.setUTCDate(tnextyear.getUTCDate()+1);		
					var lgObj = Self.createLg("Later");	
					aRanges.push({name:"Later", /*i18n*/
					    range:{start:tnextend.getTime(),end:tnextyear.getTime(),limit:Self.limit_count},lg:lgObj.lg,section:lgObj.section});
					break;
			case "tasks":
					var t = new Date();		
					t.setUTCHours(0);	
					t.setUTCMinutes(0);
					t.setUTCSeconds(0);
					var nStartDay = t.getUTCDay();
					tend = new Date(t);
					tend.setUTCDate(tend.getUTCDate()+1);					
					for(var nIndx=nStartDay;nIndx<=7;nIndx++)
					{
						if(nIndx == nStartDay)
							var sHeadName = "Today"; /*i18n*/
						else
							var sHeadName = weekdays.untranslated[t.getUTCDay()];						
						var lgObj = Self.createLg(sHeadName);
						aRanges.push({name:sHeadName,range:{start:t.getTime(),end:tend.getTime()},limit:Infinity,lg:lgObj.lg,section:lgObj.section});							
						t.setUTCDate(t.getUTCDate()+1);						
						tend.setUTCDate(tend.getUTCDate()+1);
					}
					tend.setUTCDate(tend.getUTCDate()-1);
					tnextend = new Date(tend);
					tnextend.setUTCDate(tnextend.getUTCDate()+7);
					var lgObj = Self.createLg("Next Week");
					aRanges.push({name:"Next Week", /*i18n*/
					    range:{start:tend.getTime(),end:tnextend.getTime()},limit:Infinity,lg:lgObj.lg,section:lgObj.section});	
					var lgObj = Self.createLg("Later");						
					aRanges.push({name:"Later", /*i18n*/
					    range:{start:tnextend.getTime(), end:null},limit:Self.limit_count,lg:lgObj.lg,section:lgObj.section});
					break;				
			case "mail": 
					var lgObj = Self.createLg("Inbox");				
					aRanges = [{name:"Inbox",range:{folder:"INBOX"},limit:Self.limit_count,lg:lgObj.lg,section:lgObj.section}];			
					break;			
			case "infostore": 
					var lgObjMy = Self.createLg("My Infostore");						
					var lgObjAll = Self.createLg("All folders");							
					aRanges = [{name:"My Infostore", /*i18n*/
					    range:{folder:configGetKey("folder.infostore")},limit:Self.limit_count,lg:lgObjMy.lg,section:lgObjMy.section},
													{name:"All folders", /*i18n*/
													    range:{},limit:Self.limit_count,lg:lgObjAll.lg,section:lgObjAll.section}];			
					break;			
		}
		return aRanges;		
	}
	
	function doNothing(arg)
	{
		return document.createTextNode(arg || "");
	}
	
	function setUser(arg,DOMtd)
	{
		var aIds = new Array();
		var TT = DOMtd;
		aIds.push(arg);
		function fillTds(result){
			TT.innerHTML = result[arg].display_name;
		}
		internalCache.getUsers(aIds,fillTds);	
		/*
		UserArray[UserArray.length] = {uid:arg,div:DOMtd};
		
		if(UserArray.length > 4)
		{
			loadUser();
		}
		*/
		return document.createTextNode('');
	}
	
	function loadUser()			
	{
		/*
		var aIds = new Array();aIds.push(UserArray[i].uid);
		for(var i=0;i<UserArray.length;i++)		
		{
			aIds.push(UserArray[i].uid);
		}
		
		function fillTds(arg)
		{
			for(var nEntr2=0;nEntr2<UserArray.length;nEntr2++)		
			{

				for(var userID in arg)
				{
					if(userID == UserArray[nEntr2].uid)
					{		
						UserArray[nEntr2].div.firstChild.data = arg[userID].display_name;
												
					}
				}
			}	
		}		*/
//		internalCache.getUsers(aIds,fillTds);	
	}
	
	
	
	function setDate(arg)
	{		
		var dateString = "";
		if (null != arg) dateString = formatDate(arg, "date");
		return document.createTextNode(dateString);
	}
	function setDateTime(arg)
	{
		var dateString = "";
		if (null != arg) dateString = formatDate(arg, "date")  + " " + formatDate(arg, "time");
		return document.createTextNode(dateString);
	}
	
	function setTime(arg)
	{
		var timeString = '';
		if (null != arg) timeString = formatDate(arg, "time");
		return document.createTextNode(timeString);
	}
	
	function setPriority(arg,td)
	{
		var DOMImg;
		if (arg == 3) 
		{
			DOMImg = newnode('img',0,{ src: getFullImgSrc("img/tasks/taskprio3.gif") });
		}
		else if (arg == 1) 
			DOMImg = newnode('img',0,{ src: getFullImgSrc("img/tasks/taskprio1.gif") });
		else 
			DOMImg = newnode('img',0,{ src: getFullImgSrc("img/tasks/taskprio2.gif") });
		return DOMImg;
	}
	function setMailAdress(arg)
	{
		return document.createTextNode(arg ? getAdressString(arg,true) : "");
	}
	function getArrayWidth(sModuleParam)
	{
		var aWidth = new Array();
		switch (sModuleParam){
			case "calendar": aWidth = {201:"7em",401:"6em",200:""};break;
			case "tasks": aWidth ={200:"",202:"7em",309:"5em"};break;
			case "mail": aWidth = {603:"",607:"",610:"12em"};break;			
			case "infostore": aWidth = {700:"",3:"",5:"8em"};break;			
			default: oFunctions = new Object();
		}
		return aWidth;
	}
	function getStyle(sModuleParam)
	{
		var aWidth = new Array();
		switch (sModuleParam){
			case "calendar": aWidth = {201:{color:"gray"},401:{color:"gray"},200:{}};break;
			case "tasks": aWidth ={200:{},201:{},202:{color:"gray"},309:{}};break;
			case "mail": aWidth = {603:{},607:{color:"gray"},610:{color:"gray"}};break;			
			case "infostore": aWidth = {700:{},3:{color:"gray"},5:{color:"gray"}};break;			
			default: oFunctions = new Object();
		}
		return aWidth;
	}
	function initColFunctions(sModuleParam)
	{	
		var oFunctions;
		switch (sModuleParam){
			case "calendar": oFunctions = {201:setDate,401:setTime,200:doNothing};break;
			case "tasks": oFunctions = {201:setDate,200:doNothing,202:setDate,309:setPriority};break;			
			case "mail": oFunctions = {603:setMailAdress,607:doNothing,610:setDateTime};break;	
			case "infostore": oFunctions ={700:doNothing,3:setUser,5:setDate};break;
			default: oFunctions = new Object();
		}
		return oFunctions;
	}
	function initColHeads(sModuleParam)
	{
		var oHeads;
		switch (sModuleParam){
			case "calendar": oHeads = {201:"Start date" /*i18n*/
										,401:"Start time", /*i18n*/
										200:"Description" /*i18n*/
										};break;
			case "tasks": oHeads = {201:"Start date", /*i18n*/
									200:"Subject", /*i18n*/
									202:"End date", /*i18n*/
									309:"Priority" /*i18n*/
									};break;			
			case "mail": oHeads = {603:"From", /*i18n*/
									607:"Subject", /*i18n*/
									610:"Received" /*i18n*/
									};break;	
			case "infostore": oHeads ={700:"Title", /* no i18n, see Evil hack below */
										3:"Changed by", /*i18n*/
										5:"Changed on" /*i18n*/
										};break;
			default: oHeads = new Object();
		}
		return oHeads;
	}
	
	function initSortParam(sModuleParam)
	{
		var nSortColumn;
		switch (sModuleParam){
			case "calendar": nSortColumn = '201';break;
			case "tasks": nSortColumn = '202';break;			
			case "mail": nSortColumn = "610";break;	
			//4 = creation date
			case "infostore": nSortColumn = "5";break;
			default: nSortColumn = "";
		}
		return nSortColumn;
	}	
	function initOrderParam(sModuleParam)
	{
		var sSortOrder = '';
		if((sModuleParam == 'calendar') || (sModuleParam == 'tasks'))
		{
			sSortOrder = 'asc';
		}
		else if(sModuleParam == 'infostore' || (sModuleParam == 'mail'))
		{
			sSortOrder = 'desc';		
		}
		return sSortOrder;
	}
	function initColumns(sModuleParam)
	{
		var sColumns;
		switch (sModuleParam){
			case "calendar": sColumns = "1,20,201,401,200,207";break;
			case "tasks": sColumns = "1,20,202,309,200,301";break;			
			case "mail": sColumns = "600,601,603,607,610";break;
			case "infostore": sColumns = "1,20,700,3,5";break;
			default: sColumns = "";
		}
		return sColumns;
	}	
}

portalItem.prototype = {
	setColumns: function(sColumns) 
	{
		this.columns = sColumns;
	},
	setError: function (oRespData)
	{		
		this.error = oRespData;
	},
	setData: function (oData,index,nTimestemp)
	{
		this.data = oData;
		this.timestamp = nTimestemp;
		this.ranges[index]["data"] = oData;
		this.ranges[index]["timestamp"] = nTimestemp;				
	},
	update: function ()
	{
		if(this.error)
		{			
			newServerError(this.error);		
			return;
		}		
		var bContentPresent = false;
		for(var dataIndx in this.ranges)			
		{
			if(this.ranges[dataIndx].data.length > 0)
				bContentPresent = true;							
			if(this.ranges[dataIndx]["lg"] == undefined)
				this.createLg(this.ranges[dataIndx]);	
			else			
				this.update_grid(this.ranges[dataIndx]);	
		}
		if(this.portletEmptyMSG)
			this.portletEmptyMSG.style.display = (!bContentPresent)?"block":"none";
	},
	disable : function (){
		for(var dataIndx in this.ranges)
		{
			if(this.ranges[dataIndx]["lg"])
				this.ranges[dataIndx]["lg"].disable();
		}
	},
	getHTML: function ()
	{	
		this.portletEmptyMSG = 	newnode("div",
									{display: "none", position: "absolute", textAlign: "center", 
									 width: "100%", marginTop: "5px"}, {className:"font-color-disabled"},
									[addTranslated("No Items available")]); /*i18n*/	
		addDOMEvent(this.portletEmptyMSG, "selectstart", function (e){stopEvent(e);return false;});
		addDOMEvent(this.portletEmptyMSG, "drag", function (e){stopEvent(e);return false;});							
		this.container.appendChild(this.portletEmptyMSG);
		var newportalHeader = newnode('div',{paddingLeft:"4px",textAlign:"left",height:"1.6em",width:"100%",overflow:"hidden",whiteSpace:"nowrap"}
		,{className:"portal-header-box-background font-style-headline background-color-additional-content"});		
		newportalHeader.appendChild(newnode('img',{position:"absolute"},{ src: getFullImgSrc("img/"+this.module+"/mod_"+this.module+".gif") }));
		newportalHeader.appendChild(newnode('div',{paddingLeft:"30px"},0,[addTranslated(getNameModule(this.module))]));
		
										
		this.header.appendChild(newportalHeader);		
	},
	getRequests : function (){
		//reset old data
		this.data = new Array();	
		var aAllRequests = new Array();
		for(var nRange=0;nRange<this.ranges.length;nRange++)
		{
			//create request objects
			var oRequestObj = new Object();
			var oRequestBody = new Object();		
			oRequestBody['pattern'] = '';
			oRequestObj['module'] = this.module;
			if(this.module == 'mail')	
			{
				oRequestObj['action'] = 'newmsgs';
				oRequestObj['folder'] = configGetKey('mail.folder.inbox');
			}
			else if(this.module == 'calendar')	
			{
				oRequestObj['action'] = 'newappointments';
			}
			else
				oRequestObj['action'] = 'search';		
			oRequestObj['columns'] = this.columns;		
			oRequestObj['sort'] = this.sort;		
			oRequestObj['order'] = this.order;

			//limit required
			oRequestObj['limit'] = (this.ranges[nRange].limit == Infinity)?9999:this.ranges[nRange].limit;
			if(this.module == 'calendar' || this.module == 'tasks')
			{
				var oDate = new Date();			
				oDate.setUTCHours(0);
				oDate.setUTCMinutes(0);			
				oDate.setUTCSeconds(0);						
				oRequestObj['start'] = oDate.getTime();
				oDate.setUTCFullYear(oDate.getUTCFullYear()+1);
				oDate.setUTCDate(oDate.getUTCDate()+1);			
				oRequestObj['end'] = oDate.getTime();
			}
			for(var nProp in this.ranges[nRange].range){				
				oRequestObj[nProp] = this.ranges[nRange].range[nProp];
			}
			oRequestObj['data'] = oRequestBody;		
			aAllRequests.push(oRequestObj);
		}
		return aAllRequests;
	},
	getLgColDef: function (nColumnNum,index){
		var fn = this.column_functions[nColumnNum];
		var resObj = new Object();
		if(nColumnNum == 401)
			resObj =  {
				text: this.column_heads[nColumnNum],
				i18n: this.column_heads[nColumnNum] != "Title" || "description", // Evil hack				
				width: this.col_width[nColumnNum],
				style: this.style[nColumnNum],				
				set: function  (div, text){
					removeChildNodes(div);
					div.appendChild((text[3])?document.createTextNode(""):fn(text[2],div));	
				},
				clear: LiveGrid.makeClear("")
			};
		else if(nColumnNum == 200 && this.module == "tasks")
			resObj =  {		
				text: this.column_heads[nColumnNum],
				i18n: true,
				width: this.col_width[nColumnNum],				
				style: this.style[nColumnNum],				
				set: function  (div, content){
					if (!div.firstChild) {
						div.appendChild(document.createTextNode("\u00a0"));
					}
					if (content[4]) {
						div.firstChild.data = content[4];
						if (content[5] && content[5] == 100) {
							div.className = "cell font-color-disabled";
							div.style.textDecoration = "line-through";							
						} else if (content[2] && getDays(new Date()-new Date(content[2])) > 0) {
							div.style.textDecoration = "line-through";
							div.style.color = "red";
						} else {
							div.className = "cell";
							div.style.textDecoration = "none";
						}
					} else {
						div.firstChild.data = "\u00a0";
					}
				},
				clear: LiveGrid.makeClear("")				
			};
		else
			resObj =  {
				index: index,	
				text: this.column_heads[nColumnNum],
				i18n: true,		
				style: this.style[nColumnNum],		
				width: this.col_width[nColumnNum],
				set: function  (div, text){
					removeChildNodes(div);
					div.appendChild(fn(text,div));	
				},
				clear: LiveGrid.makeClear("")
			};
		if(resObj["width"] == '')
		{
			delete resObj["width"];
		}
		return resObj;
	},
	createLg: function (sHeadName)
	{
		var oDOMHead;
		var oDOMBody;	
		var oTableNewSection = newnode("table",{width:"100%"},{ cellpadding:"0",cellspacing:"0"},
								[newnode("tbody",0,0
											,[newnode('tr',0,0,[oDOMHead = newnode('td')]),
														newnode('tr',0,0,[oDOMBody = newnode('td')])])]);
		//create live grid definition array
		var aColumnNums = this.columns.split(',');
		var aColDefs = new Array();
		for(var nColumn=0;nColumn<aColumnNums.length;nColumn++)
		{
			if(aColumnNums[nColumn].length>0 && nColumn>1 && 
							(this.column_heads[aColumnNums[nColumn]] != undefined))			
				aColDefs.push(this.getLgColDef(aColumnNums[nColumn],nColumn));
		}
		var selection =new Selection();
		var sectionLG = new LiveGrid(aColDefs,selection);
		sectionLG.mousedown_cb = function(e) { if(e.button == LeftButton) sectionLG.mousedown(e); };
		sectionLG.selected_cb = function(count) {
				sectionLG.events.trigger("Selected", count);
		};
		//no style update to disable visible selection
		sectionLG.updateStyles = function () {};
		sectionLG.insertRow = function(index) {
			var row = this.rows[index] =
				this.rowcache.length ? this.rowcache.pop() : this.createRow();
			row.tr.className = "tr";
			row.tr.style.display = "";		
			row.tr.style.top = (index * this.rowHeight) + "px";
			row.tr.oxRowIndex = index;
			this.unfetched[index] = true;
		}
		var Self = this;
		sectionLG.events.register("Selected",function (ids)
			{		
					
				if(sectionLG.selection.getSelected()[0])
				{
					var s_str = sectionLG.selection.getSelected()[0];
					var oIdObj = new Object();
					oIdObj['id'] = s_str.split('_')[0];	
					//TMP MUST BE REMOVED WHEN OBJECTCACHE IS USED
					if(Self.module) {
						oIdObj["module"]=Self.module;
					}
					oIdObj['folder'] = s_str.split('_')[1];
					//END OF TMP
					oIdObj['folder_id'] = s_str.split('_')[1];
					oIdObj['recurrence_position'] = s_str.split('_')[2];		
					triggerEvent('OX_Portal_Click_Item',Self.module,oIdObj);
				}
			});
		
		sectionLG.emptylivegridtext=getEmptyText(this.module);	
		if(!this.newportal)
			this.header.appendChild(sectionLG.getHeader());
		else
		{
			sectionLG.getHeader();					
			var newportalHeader = newnode('div',{borderBottom:"1px solid",paddingLeft:"2px",textAlign:"left",
							height:"1.6em",width:"100%",overflow:"hidden",whiteSpace:"nowrap"},{className:"font-style-lable background-color-content border-color-design"});
			newportalHeader.appendChild(addTranslated(sHeadName));
			oDOMHead.appendChild(newportalHeader);				
		}		
		this.container.appendChild(oTableNewSection);
		sectionLG.getTable(oDOMBody);
		sectionLG.emptyMessage.style.position = "relative";
		sectionLG.emptyMessage.style.textAlign = "left";
		sectionLG.emptyMessage.style.paddingLeft = "8px";
		sectionLG.emptyMessage.style.color = "silver";
		sectionLG.heightDiv.style.cursor = "pointer";
		sectionTB = oTableNewSection;
		if(this.module == "calendar") {
			var hv = sectionLG.addHover(OXAppointmentHover.getContent().node, function(id) {
				OXAppointmentHover.actualHover=hv;
				sectionLG.storage.newIterate([id], emptyFunction, set);
				function set(i, data) {	
					OXAppointmentHover.refillContent(id.split('_')[0],id.split('_')[1],id.split('_')[2]);					
				}
			});
			hv.setSize(OXAppointmentHover.contentobject.node);
		} else if(this.module == "tasks") {
			var hv = sectionLG.addHover(OXTaskHover.getContent().node, 
			function(id) {
				OXTaskHover.accordion.setHover(hv);
				var sFolder = id.split('_')[1];
				var sId = id.split('_')[0];	
				sectionLG.storage.newIterate([id], emptyFunction, set);
				function set(i, data) {	
					OXTaskHover.refillContent(id.split('_')[0],id.split('_')[1]);					
				}
			});
			hv.setSize(OXTaskHover.contentobject.node);
		} else if(this.module == "infostore") {
			var hv = sectionLG.addHover(OXInfostoreHover.getContent().node, 
			function(id) {
				OXInfostoreHover.accordion.setHover(hv);
				var sFolder = id.split('_')[1];
				var sId = id.split('_')[0];	
				sectionLG.storage.newIterate([id], emptyFunction, set);
				function set(i, data) {	
					OXInfostoreHover.refillContent(id.split('_')[0],id.split('_')[1]);					
				}
			});
			hv.setSize(OXInfostoreHover.contentobject.node);
		} else if(this.module == "mail") {
			var hv = sectionLG.addHover(OXMailHover.getContent().node, 
			function(id) {
				OXMailHover.accordion.setHover(hv);
				var sFolder = id.split('_')[1];
				var sId = id.split('_')[0];	
				sectionLG.storage.newIterate([id], emptyFunction, set);
				function set(i, data) {
					OXMailHover.refillContent(id.split('_')[0],id.split('_')[1]);					
				}
			});
			hv.setSize(OXMailHover.contentobject.node);
		}
 		return {lg:sectionLG,section:sectionTB};
	},
	update_grid: function (aData){
		if(this.module == "calendar")
			var storage = new Storage(0, [],null,null,null,null,function (x){
							return x[0]+'_'+x[1]+'_'+x[(x.length-1)];
				});							
		else
			var storage = new Storage(0, [],null,null,null,null,function (x){
							return x[0]+'_'+x[1];
				});			
		storage.append(aData.data);	
		//aData['lg'].parent.style.height = aData.data.length * 1.6 + "em";
		//aData['lg'].showFocus = function (){};
		if(aData.data.length == 0)
			aData['section'].style.display = "none";
		else
			aData['section'].style.display = "";
		aData['lg'].disablehover=!configGetKey("gui.effects.hover.portal");	
		aData['lg'].enable(storage);	
	}

}
function getEmptyText(sModule)
{
	var sModuleName;
	switch (sModule){
		case 'calendar' : sModuleName = "No appointments today"; /*i18n*/ break;
		case 'mail' : sModuleName = "No new E-Mails in this folder"; /*i18n*/ break;
		case 'tasks' : sModuleName = "No tasks today"; /*i18n*/ break;
		case 'infostore' : sModuleName = "No Info Items in this folder"; /*i18n*/ break;
		default: sModuleName = "";		
	}
	return sModuleName;
}
function getNameModule(sModule)
{
	var sModuleName;
	switch (sModule){
		case 'calendar' : sModuleName = "Calendar"; /*i18n*/ break;
		case 'mail' : sModuleName = "E-Mail"; /*i18n*/ break;
		case 'tasks' : sModuleName = "Tasks"; /*i18n*/ break;
		case 'infostore' : sModuleName = "InfoStore"; /*i18n*/ break;
		default: sModuleName = "&#xa0;";		
	}
	return sModuleName;
}
fileloaded();