/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/portal/layout",
	function () { 
		showNode("config_portal"); 
		$("config_portal").style.display="block"; },
	function() { 
		register("OX_SAVE_OBJECT",cp_saveConfiguration);
		register("OX_Cancel_Object",cp_cancelConfiguration);
		
		cp_enter();
	},
	function() {
		//configuration_askforSave();
		unregister("OX_SAVE_OBJECT",cp_saveConfiguration);
		unregister("OX_Cancel_Object",cp_cancelConfiguration);		
		cp_leave();
	},
	function () { 
		hideNode("config_portal"); 
		$("config_portal").style.display="none"; },
	function () { cp_enter();}
);

var cp_init_bool=false;
var cp_internalcontents=new Object();
var config_portal_mail;
var config_portal_calendar;
var config_portal_infostore;
var config_portal_tasks;

function cp_saveConfiguration() {
	if(configuration_changed_fields["gui"]) {
		config_portal_fillContents();
		configSetKey("gui.portal.internalcontents",cp_internalcontents);
		configSetKey("gui.effects.hover.portal",getBoolofInt(getValueofRadioBox("config_portal_enablehoverportal")));
	}
	bPortalConfigChanged = true;
	triggerEvent("OX_Save_Configuration",false,false);
}
function cp_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	cp_enter();	
}
function cp_init() {
	config_portal_mail=new ComboBox3(window, "config_portal_mail", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", null);
	config_portal_mail.addElement("Hide",0);/*i18n*/
	config_portal_mail.addElement("Show 5 elements",5);/*i18n*/
	config_portal_mail.addElement("Show 10 elements",10);/*i18n*/
	config_portal_mail.addElement("Show 15 elements",15);/*i18n*/
	config_portal_mail.addElement("Show 20 elements",20);/*i18n*/
	config_portal_mail.getDomNode();
	if(!configGetKey("modules.mail.module")) {
		config_portal_mail.disable();
	}
	
	config_portal_calendar=new ComboBox3(window, "config_portal_calendar", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", null);
	config_portal_calendar.addElement("Hide module window",0);/*i18n*/
	config_portal_calendar.addElement("Show 5 elements",5);
	config_portal_calendar.addElement("Show 10 elements",10);
	config_portal_calendar.addElement("Show 15 elements",15);
	config_portal_calendar.addElement("Show 20 elements",20);
	config_portal_calendar.getDomNode();
	if(!configGetKey("modules.calendar.module")) {
		config_portal_calendar.disable();
	}
	
	config_portal_infostore=new ComboBox3(window, "config_portal_infostore", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", null);
	config_portal_infostore.addElement("Hide",0);
	config_portal_infostore.addElement("Show 5 elements",5);
	config_portal_infostore.addElement("Show 10 elements",10);
	config_portal_infostore.addElement("Show 15 elements",15);
	config_portal_infostore.addElement("Show 20 elements",20);
	config_portal_infostore.getDomNode();
	if(!configGetKey("modules.infostore.module")) {
		config_portal_infostore.disable();
	}

	config_portal_tasks=new ComboBox3(window, "config_portal_tasks", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", null);
	config_portal_tasks.addElement("Hide module window",0);/*i18n*/
	config_portal_tasks.addElement("Show 5 elements",5);/*i18n*/
	config_portal_tasks.addElement("Show 10 elements",10);/*i18n*/
	config_portal_tasks.addElement("Show 15 elements",15);/*i18n*/
	config_portal_tasks.addElement("Show 20 elements",20);/*i18n*/
	config_portal_tasks.getDomNode();
	if(!configGetKey("modules.tasks.module")) {
		config_portal_tasks.disable();
	}
}
function cp_leave() {	
}
register("OX_Configuration_Loaded",function() {
	var cp_internalcontents=new Array();
    if(configContainsKey("gui.portal.internalcontents")) {
		cp_internalcontents=configGetKey("gui.portal.internalcontents");
		if(!cp_internalcontents.push) {
			cp_internalcontents=new Array();
		}		
	}
	for(var i in modulesview) {
		var temp1=false;
		for(var i2=0;i2<cp_internalcontents.length;i2++) {
			if(cp_internalcontents[i2].module==modulesview[i].name) {
				if(!cp_internalcontents[i2].adj || !cp_internalcontents[i2].adj.ww) { cp_internalcontents[i2].adj=modulesview[i].adj; }
				temp1=true;
			}
		}
		if(!temp1) {
			var tmp =new Object();
			tmp.external=false;
			tmp.module=modulesview[i].name;
			tmp.header=modulesview[i].text;
			tmp.visible=true;
			tmp.params=new Object();
			tmp.params.limit=modulesview[i].limit;	
			tmp.adj=modulesview[i].adj;
			cp_internalcontents.push(tmp);
		}
	}
	for(var indx=0;indx<cp_internalcontents.length;indx++)	
	{
		if(!configGetKey("modules."+cp_internalcontents[indx].module+".module"))		
		{
			cp_internalcontents.splice(indx,1);
		}
	}
	configSetKey("gui.portal.internalcontents",cp_internalcontents);
});
function cp_enter() {
	if(!cp_init_bool) {
		cp_init();
		cp_init_bool=true;
	}
	cp_internalcontents=new Array();
	if(configContainsKey("gui.portal.internalcontents")) {
		cp_internalcontents=configGetKey("gui.portal.internalcontents");
		if(!cp_internalcontents.push) {
			cp_internalcontents=new Array();
		}		
	}
	for (var i=0;i<cp_internalcontents.length;i++) {
		switch(cp_internalcontents[i].module) {
			case "mail":
				if(configGetKey("modules.mail.module")) {
					config_portal_mail.setKey(cp_internalcontents[i].params.limit);
				}
				break;
			case "calendar":
				if(configGetKey("modules.calendar.module")) {
					config_portal_calendar.setKey(cp_internalcontents[i].params.limit);
				}
				break;
			case "tasks":
				if(configGetKey("modules.tasks.module")) {
					config_portal_tasks.setKey(cp_internalcontents[i].params.limit);
				}
				break;
			case "infostore":
				if(configGetKey("modules.infostore.module")) {
					config_portal_infostore.setKey(cp_internalcontents[i].params.limit);
				}
				break;
		}
	}
	if(configContainsKey("gui.effects.hover.portal")) {
		setIntofRadioBox("config_portal_enablehoverportal",configGetKey("gui.effects.hover.portal"));
		configuration_changed_fields["gui"]=false;
	}
	configuration_changed_fields["gui"]=false;
	$("config_portal_header").firstChild.nodeValue=getconfigPathSelected().substring(1);
}
function config_portal_fillContents() {
	
	var mailvalue=config_portal_mail.getKey();
	var calendarvalue=config_portal_calendar.getKey();
	var infostorevalue=config_portal_infostore.getKey();
	var tasksvalue=config_portal_tasks.getKey();
	
	var oldconf=configGetKey("gui.portal.internalcontents");
	for(var i=0;i<oldconf.length;i++) {
		switch(oldconf[i].module) {
			case "calendar":
				if(calendarvalue!=0) { oldconf[i].visible=true; } else { oldconf[i].visible=false; }
				if(!oldconf[i].params) { oldconf[i].params=new Object(); }
				oldconf[i].params.limit=calendarvalue;
				break;
			case "tasks":
				if(tasksvalue!=0) { oldconf[i].visible=true; } else { oldconf[i].visible=false; }
				if(!oldconf[i].params) { oldconf[i].params=new Object(); }
				oldconf[i].params.limit=tasksvalue;
				break;
			case "infostore":
				if(infostorevalue!=0) { oldconf[i].visible=true; } else { oldconf[i].visible=false; }
				if(!oldconf[i].params) { oldconf[i].params=new Object(); }
				oldconf[i].params.limit=infostorevalue;
				break;
			case "mail":
				if(mailvalue!=0) { oldconf[i].visible=true; } else { oldconf[i].visible=false; }
				if(!oldconf[i].params) { oldconf[i].params=new Object(); }
				oldconf[i].params.limit=mailvalue;
				break;

		}
	}
	var myobject=new Object();
	myobject.params=new Object();
	myobject.external=false;
	cp_internalcontents=oldconf;
}
fileloaded();