/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * @author Markus Wagner <markus.wagner@open-xchange.com>
 * 
 */

var completedetailappointment;
var aDetailFieldsToClear = {};
var idsAppParticipantForSelected = new Array();
var a_d_timestamp = 0;
var a_d_participantGrid = null;	
var objAppDetailParticipants = null;
var refAppDetailParticipantTab = null;
var gridatt = null;
var currentAppointmentDetailTab = 'appointment';
var aPrintDetailApp = new Array();
function caldetail_change_Confirm() {
	var calconfirm=new AcceptDeny(true);
	calconfirm.showConfirmation([new AcceptDenyObject("calendar",completedetailappointment)]);
}
/********************************** Tab Appointment *****************************************************************/
register("OX_Calendar_Switch_Detail",function(param) { menuswitchCalendarDetail(param) });
function detailAppointmentOnload(callback)
{
	/********************************** Tabs *****************************************************************/

	/**
	 * global vars for detail appointment view
	 */
	a_d_tabsList = new Array('tabAppointmentDetail1','tabAppointmentDetail2', 'tabAppointmentDetail3');
	a_d_panelsList = new Array('panelAppointmentDetail1','panelAppointmentDetail2', 'panelAppointmentDetail3');
	a_d_eventList =
			new Array(	['OX_Calendar_Switch_Detail','overview'],
						['OX_Calendar_Switch_Detail','participant'],
						['OX_Calendar_Switch_Detail','attachment']);
	
	//register tabs
	setTabLists(a_d_tabsList, a_d_panelsList, a_d_eventList);
	//var eventList =	null;
	//changeTab('tabAppointmentDetail1', 'panelAppointmentDetail1');
	

//	/* Grid for Attachments */
//	gridatt = makeDetailAppointmentAttachmentGrid();

	var json = new JSON();
	var recurrencePosition = (selectedAppointment.recurrence_position) ? selectedAppointment.recurrence_position : 0;
	
	json.get(AjaxRoot + "/calendar?action=get&session=" + session 
									+"&id="+selectedAppointment.id
									+"&folder="+selectedAppointment.folder
									+"&recurrence_position="+recurrencePosition+"&"
		,
		null,
		function(fieldsToGet) {
			if (fieldsToGet) {				
				objAppDetailParticipants = new AppDetailParticipants();
				if(!refAppDetailParticipantTab) {
					refAppDetailParticipantTab = new ObjAppDetailParticipantTab();
					refAppDetailParticipantTab.makeGrid();
				}
				if(storageCache && storageCache.current)
					storageCache.current.timestamp = fieldsToGet.timestamp;
				completedetailappointment=fieldsToGet.data;
				triggerEvent("Confirmation_Changed",0);
				for(var i=0;i<completedetailappointment.users.length;i++) {
					if(completedetailappointment.users[i].id==configGetKey("identifier")) {
						triggerEvent("Confirmation_Changed",1);
					}
				}
				//clear all fields
				var tmpDivToClear = null;
				for (idDetailFieldsToClear in aDetailFieldsToClear) 
				{
					if(aDetailFieldsToClear[idDetailFieldsToClear] == "set" && $(idDetailFieldsToClear).firstChild)
						$(idDetailFieldsToClear).firstChild.data = " "; 
					else if(aDetailFieldsToClear[idDetailFieldsToClear] == "setInput")	
						$(idDetailFieldsToClear).value = " "; 	
				}
				removeChildNodes($("a_d_note")); // clean-up notes
				
				var participantTabDiv = $("a_d_count_participants");
				
				if(!fieldsToGet.data['participants']) {
					participantTabDiv.firstChild.data = "0";
				}
				
				//hide next button for participants
				$("a_d_participants_more").style.display = 'none';
				
				//reset fields
				aDetailFieldsToClear = {};
		
				a_d_timestamp = fieldsToGet.timestamp;
				lastUpdateOfCalendarTimestamp = fieldsToGet.timestamp;
				aPrintDetailApp = [];
				if (fieldsToGet.data.number_of_attachments)
				{
					$('a_d_count_attachment').firstChild.nodeValue = fieldsToGet.data.number_of_attachments;
				} else {
					$('a_d_count_attachment').firstChild.nodeValue = "0";
				}
				
				if (fieldsToGet.data.color_label) {
					$("tagImgAppointmentDetail").src = getFullImgSrc("img/menu/tag_"+fieldsToGet.data.color_label+".gif");
				} else {
					$("tagImgAppointmentDetail").src = getFullImgSrc("img/menu/tag_0.gif");
				}
				if (fieldsToGet.data.private_flag) {
					$("privateflagImgAppointmentDetail").src = getFullImgSrc("img/private_flag.gif");
				} else {
					$("privateflagImgAppointmentDetail").src = getFullImgSrc("img/dummy.gif");
				}
				var myseries=new SeriesObject(fieldsToGet.data,true);
				$("a_d_series").firstChild.data = myseries.getSeriesString();
				if (fieldsToGet.data.recurrence_type > 0) {
					$("seriesflagImgAppointmentDetail").src = getFullImgSrc("img/calendar/calendar_series.gif");		
				} else {
					$("seriesflagImgAppointmentDetail").src = getFullImgSrc("img/dummy.gif");
				}
				
				var sText = "";
				var nText = "";
				for(a_d_data in fieldsToGet.data){
					switch (a_d_data) {
						case 'title':
							$("a_d_title").firstChild.data = fieldsToGet.data[a_d_data];	
							aDetailFieldsToClear["a_d_title"] = "set"; //for deleting the next time, when show detail								
							aPrintDetailApp[0] = Print.createTitle(fieldsToGet.data[a_d_data]);
							aPrintDetailApp[1] = Print.createLine("5px");
							aPrintDetailApp[2] = Print.createEmpty();
							break;
						case 'location':
							$("a_d_location").firstChild.data = fieldsToGet.data[a_d_data];
							aDetailFieldsToClear["a_d_location"] = "set";						
							aPrintDetailApp[3] = Print.createContent(_("Location:"),fieldsToGet.data[a_d_data]);
							break;
						case 'note':
						    removeChildNodes($("a_d_note"));
                            var nText = fieldsToGet.data[a_d_data] ? fieldsToGet.data[a_d_data].split("\n") : "";
			                for (var i in nText) {
			                    $("a_d_note").appendChild(document.createTextNode(nText[i]));
			                    $("a_d_note").appendChild(newnode("br"));
			                }
			                nText = null;
							aDetailFieldsToClear["a_d_note"] = "set";	
							aPrintDetailApp[6] = Print.createContent(_("Description:"),fieldsToGet.data[a_d_data]);
							break;
						case 'start_date':	
							var startDate = new Date(fieldsToGet.data[a_d_data]);
							this.start = startDate.getUTCHours() + "." + (parseInt((startDate.getUTCMinutes()/15), 10)*25);	// startdate for calculating
							
							if (fieldsToGet.data['full_time']) {
								this.starthuman = formatDate(startDate, "date");
							} else {
								this.starthuman = formatDate(startDate, "datetime");//startDate.getUTCHours() + ":" + parseInt(startDate.getUTCMinutes()/15, 10)*15;	// human readable start time
								if((this.starthuman.length - (this.starthuman.lastIndexOf(":"))) < 3)
									this.starthuman += "0";
							}
							
							sText = this.starthuman;
							$("a_d_begins").firstChild.data = sText;
							aPrintDetailApp[4] = Print.createContent(_("Start date:"),sText);
							var sStartText = (fieldsToGet.data["title"] ? fieldsToGet.data["title"] : "") + " - " + this.starthuman;
							aDetailFieldsToClear["a_d_begins"] = "set";
							
							activeYear = startDate.getUTCFullYear();
							activeMonth = startDate.getUTCMonth();
							activeDay = startDate.getUTCDate();
							if (oMiniCalendar) oMiniCalendar.setSelectedByDate(activeYear, activeMonth, activeDay);

							break;
						case 'end_date':
							var endDate = new Date(fieldsToGet.data[a_d_data]);
							
							if(fieldsToGet.data['full_time']) {
								var endDateNew = endDate - 86400000;
								this.endhuman = formatDate(endDateNew, "date");
							} else {
								this.endhuman = formatDate(endDate, "datetime");//endDate.getUTCHours() + ":" + parseInt(endDate.getUTCMinutes()/15)*15;	// human readable end time
							}
							var sText = this.endhuman;
							$("a_d_ends").firstChild.data = sText;	
							aPrintDetailApp[5] = Print.createContent(_("End:"),this.endhuman);
							
							var sEndText = " "  + _("to") + " " + this.endhuman;
							
							aDetailFieldsToClear["a_d_ends"] = "set";	
							aDetailFieldsToClear["a_d_headline"] = "set";	
							break;
							
						case 'participants':
							(callback) ? objAppDetailParticipants.callback = callback : objAppDetailParticipants.callback = null;
							objAppDetailParticipants.oParticipantResources = fieldsToGet.data[a_d_data];	
							objAppDetailParticipants.writeCountParticipants();
							objAppDetailParticipants.pushArray();
							var ids=clone(objAppDetailParticipants.idUserArr);
							internalCache.getUsers(ids,transit_a_d_fnSetUserColumn);															
							break;
							
						case 'folder_id':
						
							function cb_fdrpath(sText)
							{
								$("a_d_folder").firstChild.data = sText;
							}
							oMainFolderTree.get_folder_path(fieldsToGet.data[a_d_data],cb_fdrpath);
							break;
							
						case 'shown_as':
							var newClassName = "";
							var sShownAs = "";
							switch (fieldsToGet.data[a_d_data]) {
								case 1	:	newClassName = "appointmentRESERVED";
											sShownAs = _("reserved");
											aPrintDetailApp[7] = Print.createContent(_("Display as:"),_("reserved"));
											break;
											
								case 2	:	newClassName = "appointmentTEMPORARY";
											sShownAs = _("temporary");
											aPrintDetailApp[7] = Print.createContent(_("Display as:"),_("temporary"));
											break;
											
								case 3	:	newClassName = "appointmentABSENT";
											sShownAs = _("absent on business");
											aPrintDetailApp[7] = Print.createContent(_("Display as:"),_("absent on business"));
											break;
											
								case 4	:	newClassName = "appointmentFREE";
											sShownAs = _("free");
											aPrintDetailApp[7] = Print.createContent(_("Display as:"),_("free"));
											break;			
									
								default	:	newClassName = "appointmentNONE";
											break;		
											
							}
							
							$("a_d_show_as_color").className = newClassName;
							$("a_d_show_as").firstChild.data = sShownAs;	
							aDetailFieldsToClear["a_d_show_as"] = "set";	
							break;
							
						case 'alarm':
							if(fieldsToGet.data[a_d_data] >= 0) {									
								var sConvertedTime = getInterval(fieldsToGet.data[a_d_data] * 60 * 1000);
								$("a_d_alarm").firstChild.data = sConvertedTime;		
								aDetailFieldsToClear["a_d_alarm"] = "set";
							}
							break;
							
						case 'categories':
							$("a_d_categories").firstChild.data = fieldsToGet.data[a_d_data];
							aPrintDetailApp[8] = Print.createContent(_("Tags:"),fieldsToGet.data[a_d_data]);	
							aDetailFieldsToClear["a_d_categories"] = "set";
							break;
							
						case 'users':
							objAppDetailParticipants.usersD = fieldsToGet.data[a_d_data];
							break;
						case 'created_by':
							internalCache.getUsers([fieldsToGet.data[a_d_data]],	function (arg)
							{
								if(fieldsToGet.data[a_d_data] && arg[fieldsToGet.data[a_d_data]]) {
									$("a_d_created_by").firstChild.data = arg[fieldsToGet.data[a_d_data]].display_name;	
									aDetailFieldsToClear["a_d_created_by"] = "set";
								} else if(arg) {
									for(i in arg) {
										$("a_d_created_by").firstChild.data = arg[i].display_name;	
										aDetailFieldsToClear["a_d_created_by"] = "set";
									}
								}
							});
							break;
							
						default:
							break;
					}
				}

				writeBottomString(fieldsToGet.data,"app_detail_bot");
				$("a_d_headline").firstChild.data = sStartText + sEndText;
			}
			
		},
		function(error) {
			triggerEvent("OX_Switch_View", configGetKey("gui.calendar.view"));
			return true;
		}
	); 
}

/* Participant object */
function AppDetailParticipants() {
	this.oParticipantResources = null;
	this.idUserArr = new Array();
	this.idGroupArr = new Array();
	this.idResourceArr = new Array();
	this.sText = "";
	this.nText = null;
	this.nPart = 0;
	this.gridData = new Array();
	this.gridIndex = 0;
	this.idForExternal = 1;
	this.usersD = null;
	this.callback = null;
}

AppDetailParticipants.prototype = {
	writeCountParticipants : function () {
		this.sText = this.oParticipantResources.length;
		$("a_d_count_participants").firstChild.data = this.sText;
	},
	pushArray : function () {
		for(i=0; i < this.oParticipantResources.length; i++)
		{
				/*
				 * type 1 user
				 * type 2 user group
				 * type > 2 resource
				 * */
			switch (this.oParticipantResources[i].type) {
				case 1:		this.idUserArr.push(this.oParticipantResources[i].id);
							break;
							
				case 2: 	this.idGroupArr.push(this.oParticipantResources[i].id);
							break;
							
				case 3: 	this.idResourceArr.push(this.oParticipantResources[i].id);
							break;
							
				case 5: 	this.idUserArr.push(this.oParticipantResources[i]);
							break;
			}						
		}
	},
	writeMoreButton : function() {
		$("a_d_participants_more").style.display = 'inline';
		$("a_d_participants_more").style.display = 'block';
	},
	writeMoreButtonResource : function() {
		$("a_d_participants_more_resources").style.display = 'inline';
		$("a_d_participants_more_resources").style.display = 'block';
	},
	a_d_fnSetUserColumn : function (arg) {
		
		for(var i=0; i < this.idUserArr.length; i++) {
			if(this.nPart < 6 ) {	
				if(arg[this.idUserArr[i]]) {
					this.sText = arg[this.idUserArr[i]].display_name;										
					$("a_d_participants_" + (this.nPart+1)).firstChild.data = this.sText										
					aDetailFieldsToClear["a_d_participants_" + (this.nPart+1)] = "set";						
					this.nPart++;				
				} else if(typeof this.idUserArr[i] == "object") {	
					this.sText = this.idUserArr[i].display_name || this.idUserArr[i].mail || _("unkown");										
					$("a_d_participants_" + (this.nPart+1)).firstChild.data = this.sText										
					aDetailFieldsToClear["a_d_participants_" + (this.nPart+1)] = "set";	
					this.nPart++;
				}					
			} else {
				this.writeMoreButton();
			}
			
			if(typeof this.idUserArr[i] == "number") {
				this.gridData[this.gridIndex] = new Array();
				this.gridData[this.gridIndex].push(arg[this.idUserArr[i]].id);
				this.gridData[this.gridIndex].push("user");
				this.gridData[this.gridIndex].push(arg[this.idUserArr[i]].display_name);		
				this.gridIndex++;
				aPrintDetailApp.push(Print.createContent(_("Participant:"),arg[this.idUserArr[i]].display_name || arg[this.idUserArr[i]].mail));	
			} else {
				this.gridData[this.gridIndex] = new Array();
				this.gridData[this.gridIndex].push(this.idForExternal + "ext");
				this.gridData[this.gridIndex].push("user_extern");
				this.gridData[this.gridIndex].push(this.idUserArr[i].display_name || this.idUserArr[i].mail);		
				this.gridIndex++;
				this.idForExternal ++;
				aPrintDetailApp.push(Print.createContent(_("Participant:"),this.idUserArr[i].display_name || this.idUserArr[i].mail));
			}			
		}

		this.gridData.sort(function(a,b){
			if (a[2] && b[2]) {
				return a[2].toLowerCase() < b[2].toLowerCase() ? -1 : 1;
			} else {
				return -1;
			}
		});
		
		var Self = this;
		
		setTimeout(
			function() {
				if(Self.usersD)
				refAppDetailParticipantTab.users= Self.usersD;
				//refAppDetailParticipantTab.appendToStorage(); Moved to enableGrid
			},20
		);
		setTimeout(
			function(){
				internalCache.getGroups(objAppDetailParticipants.idGroupArr,transit_a_d_fnSetGroupColumn)
			}, 0
		);
	},
	a_d_fnSetGroupColumn : function (arg)
	{
		var tmp_grouplength = new Array();
		var tmp_userToGet = new Array();
		for(var i=0; i < this.idGroupArr.length; i++)
		{
			if(this.nPart < 6 ) 
			{										
				this.sText = arg[this.idGroupArr[i]].display_name;								
				$("a_d_participants_" + (this.nPart+1)).firstChild.data = this.sText										
				aDetailFieldsToClear["a_d_participants_" + (this.nPart+1)] = "set";		
				this.nPart++;									
			}
			else
			{
				this.writeMoreButton();
			}
			this.gridData[this.gridIndex] = new Array();
			this.gridData[this.gridIndex].push(arg[this.idGroupArr[i]].id);
			this.gridData[this.gridIndex].push("group");
			this.gridData[this.gridIndex].push(arg[this.idGroupArr[i]].display_name);	
			this.gridData[this.gridIndex].push("group");
			this.gridData[this.gridIndex].push("");
			tmp_grouplength[this.idGroupArr[i]] = this.gridIndex + 1;
			this.gridIndex += (arg[this.idGroupArr[i]].members.length + 1);
			for(tz in arg[this.idGroupArr[i]].members)
				tmp_userToGet.push({id : arg[this.idGroupArr[i]].members[tz], type : 1});
		}
		var Self = this;
		internalCache.getObjects(tmp_userToGet, function(cb){
			for(gr in tmp_grouplength){
				var tmp_members = new Array();
				var start = tmp_grouplength[gr];
				for(me in arg[gr].members){
					tmp_members[tmp_grouplength[gr]] = new Array();
					tmp_members[tmp_grouplength[gr]].push(arg[gr].members[me] + "gm" + arg[gr].id);
					tmp_members[tmp_grouplength[gr]].push("groupMember");
					tmp_members[tmp_grouplength[gr]].push(cb[arg[gr].members[me]].display_name);
					tmp_grouplength[gr]++;
				}
				tmp_members.sort(function(a,b){
					if (a[2] && b[2]) {
						return a[2].toLowerCase() < b[2].toLowerCase() ? -1 : 1;
					} else {
						return -1;
					}
				});
				for(var z=0; z<tmp_members.length;z++){
					if(tmp_members[z]) {
						Self.gridData[start] = tmp_members[z];
						start++;
					}
				}
			}
		});
		setTimeout(
			function(){
				if(objAppDetailParticipants && objAppDetailParticipants.idResourceArr) {
					internalCache.getResources(objAppDetailParticipants.idResourceArr,transit_a_d_fnSetResourceColumn)
				}
			}, 0
		);
	},
	a_d_fnSetResourceColumn : function (arg)
	{
		for(var i=0; i < this.idResourceArr.length; i++)
		{
			if(i < 2 ) 
			{										
				this.sText = arg[this.idResourceArr[i]].display_name;									
				$("a_d_resources_" + (i+1)).firstChild.data = this.sText										
				aDetailFieldsToClear["a_d_resources_" + (i+1)] = "set";		
			}
			else
			{
				this.writeMoreButtonResource();
			}
		this.gridData[this.gridIndex] = new Array();
		this.gridData[this.gridIndex].push(arg[this.idResourceArr[i]].id);
		this.gridData[this.gridIndex].push("ressourcen");	
		this.gridData[this.gridIndex].push(arg[this.idResourceArr[i]].display_name);	
		this.gridData[this.gridIndex].push("ressourcen");	
		this.gridData[this.gridIndex].push("");
		this.gridIndex++;
		}
		var Self = this;
		if(Self.callback) {
			setTimeout(
				function() {
					Self.gridIndex = 0;
					Self.callback();
				},50
			);
		}
	}
}

function transit_a_d_fnSetUserColumn(arg) {
	objAppDetailParticipants.a_d_fnSetUserColumn(arg);
}
function transit_a_d_fnSetGroupColumn(arg) {
	objAppDetailParticipants.a_d_fnSetGroupColumn(arg);
}
function transit_a_d_fnSetResourceColumn(arg) {
	objAppDetailParticipants.a_d_fnSetResourceColumn(arg);
}

/********************************** Tab Participants *****************************************************************/

function ObjAppDetailParticipantTab() {
	this.users = null;
	this.list = $("a_d_listParticipants");
	this.listHeader = $("a_d_listParticipantsHeader");
	this.myAppPStorage = null;
	this.myAppPStorage = new Storage(0, []);
}

ObjAppDetailParticipantTab.prototype = {
	
	makeGrid : function () {		
	
		if (a_d_participantGrid) {
			removeChildNodes(this.list);
			a_d_participantGrid = null;
		}
		
		a_d_participantGrid = new LiveGrid([
					{	
						text: "&#160;",
						sortable: false,
						width: "16px",
						style: {padding: 0},
						set: function(div,text) 
							{
								if (div) {
									removeChildNodes(div);
									if(text != "groupMember") {
										div.appendChild(newnode("img", 0, {src : getFullImgSrc("img/calendar/" + text + ".gif"), alt : "participant"}));
									}
									else
										div.appendChild(newnode("img", 0, {src : getFullImgSrc("img/dummy.gif"), alt : "participants", width: "16", height: "16"}));
								}
							},
						clear: LiveGrid.makeClear("..."),
						index:1
					},{	
						text: _("Participants"),
						sortable: false,
						width: "30%",
						set: function(div, text){
							if(div){
								if(text[1] == "groupMember"){
									removeChildNodes(div);
									div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/user.gif"), alt: "Group Member"}));
									div.appendChild(document.createTextNode("\u00a0" + text[2]));
								} else {
									removeChildNodes(div);
									div.appendChild(document.createTextNode(text[2]));
								}
							}
						},
						clear: LiveGrid.makeClear("...")
					}, {
						text: _("Status"),
						sortable: false,
						width: "10%",
						set: function(div,text) {
							if (div) {
								removeChildNodes(div);
								switch(text) {
									case 0	:	div.appendChild(document.createTextNode(_("waiting")));
													break;
													
									case 1	:	div.appendChild(newnode("span", 0, {className : "appointmentACCEPTED"}, [document.createTextNode(_("accepted"))]));
													break;
													
									case 2	:	div.appendChild(newnode("span", 0, {className : "appointmentDECLINED"}, [document.createTextNode(_("declined"))])); 
													break;
													
									case 3	:	div.appendChild(newnode("span", 0, {className : "appointmentTENTATIVE"}, [document.createTextNode(_("tentative"))]));
													break;
													
									default	:	div.appendChild(document.createTextNode("\u00a0"));
													break;
								}
							}
						},
						clear: LiveGrid.makeClear("..."),
						index: 3
					}, {
						text: _("Comment"),
						sortable: false,
						set: LiveGrid.defaultSet,
						clear: LiveGrid.makeClear("..."),
						index: 4
					}
		], new Selection());

		this.listHeader.appendChild(a_d_participantGrid.getHeader());
		a_d_participantGrid.getTable(this.list);
	},
	
	appendToStorage : function() {	
		for(var i = 0; i < objAppDetailParticipants.gridData.length; i++) {
			for (var t = 0; t < this.users.length; t++) {
				
				if(objAppDetailParticipants.gridData[i][0].toString().indexOf("gm") < 0){
					if(this.users[t].id == objAppDetailParticipants.gridData[i][0]) {
						objAppDetailParticipants.gridData[i].push(this.users[t].confirmation);
						objAppDetailParticipants.gridData[i].push(this.users[t].confirmmessage || "");	
					}
				} else {
					if(this.users[t].id == objAppDetailParticipants.gridData[i][0].split("gm")[0]) {
						objAppDetailParticipants.gridData[i].push(this.users[t].confirmation);
						objAppDetailParticipants.gridData[i].push(this.users[t].confirmmessage || "");	
					}
				}
			}			
		}
	},
	
	enableGrid : function () {
		this.appendToStorage();
		// copy to an array, because the gridData is a hashmap!!!
		var tmp_participants = new Array();
		for(var i=0; i<objAppDetailParticipants.gridData.length;i++) {			
			tmp_participants[i] = objAppDetailParticipants.gridData[i];
		}
		this.myAppPStorage.append(tmp_participants);
		//enable the grid
		a_d_participantGrid.enable(this.myAppPStorage); 
	},
	
	disableGrid	: function() {
		this.myAppPStorage.remove(0,objAppDetailParticipants.gridData.length);
		a_d_participantGrid.disable(); 
	}
}

var gridAttachmentAppDetail = null;
function makeDetailAppointmentAttachmentGrid() {
		var nId = selectedAppointment.id;
		var nFolder = selectedAppointment.folder;
		gridatt = new attachmentGrid("a_d_Attachments",nId,nFolder,1);	
}

/*
 * Print Detail Appointment
 * 
 * */
function calendar_printDetail(){
	var title = aPrintDetailApp[0] && aPrintDetailApp[0].title ? aPrintDetailApp[0].title : "";
	var detailCalendarPrint = new Print(title);
	detailCalendarPrint.printDetail(aPrintDetailApp);
}

fileloaded();