/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

var internalCachejson= new JSON(); 
register("OX_Refresh",function () {
	if(internalCache.cache_allrequests.length==0) {
		internalCache.mrulist=new MRUList(internalCache.size);		
	}
});
function Cache(size) {
	this.size=size;
	this.executezaehler=0;
	this.cache_request_id=new Object();
	this.cache_allrequests=new Array();
	this.mrulist = new MRUList(size);
	this.openrequests=0;
	this.idsreturn = new Object();
	this.ressourcefromserver=new Array();
	this.userfromserver=new Array();
	this.groupfromserver=new Array();
}
Cache.prototype = 
{
	getUsers : function(ids,cb) {
		var newarray=new Array();
		for(var i=0;i<ids.length;i++) {
			var newobject=new Object();
			newobject.id=parseInt(ids[i]);
			newobject.type=1;
            if (!isNaN(newobject.id)) newarray.push(newobject);
		}
		this.getObjects(newarray,cb);
	},
	getGroups : function(ids,cb) {
		var newarray=new Array();
		for(var i=0;i<ids.length;i++) {
			if (isNaN(ids[i])) continue;
			var newobject=new Object();
			newobject.id=parseInt(ids[i]);
			newobject.type=2;
			newarray.push(newobject);
		}
		this.getObjects(newarray,cb);
	},
	getResources : function(ids,cb) {
		var newarray=new Array();
		for(var i=0;i<ids.length;i++) {
			if (isNaN(ids[i])) continue;
			var newobject=new Object();
			newobject.id=parseInt(ids[i]);
			newobject.type=3;
			newarray.push(newobject);
		}
		this.getObjects(newarray,cb);
	},
	getObjects : function(ids,cb) 
	{
		var Self=this;
		var myobject=new Object();
		myobject.ids=ids;
		myobject.cb=cb;
		Self.cache_allrequests.push(myobject);
		Self.ressourcefromserver=new Array();
		Self.userfromserver=new Array();
		Self.groupfromserver=new Array();
		
		if(!ids) return;
		for(i=0;i<ids.length;i++) {
			var myobject=ids[i];
			myobject.id=parseInt(myobject.id);
			switch(myobject.type) {
				case 1:
					var key=Self.mrulist.get(myobject.id);
					if(!key) {
						if(!(Self.cache_request_id[myobject.id+":"+myobject.type])) {
							Self.userfromserver.push(myobject.id);	
						}
					}
					else {
						Self.idsreturn[myobject.id+":"+myobject.type] = key;
					}
					break;
				case 2:
					var key=Self.mrulist.get(myobject.id);
					if(!key) {
						if(!(Self.cache_request_id[myobject.id+":"+myobject.type])) {
							Self.groupfromserver.push(myobject.id);
						}
					} else {
						if(!(Self.cache_request_id[myobject.id+":"+myobject.type])) {
							Self.idsreturn[myobject.id+":"+myobject.type] = key;
						}
					}
					break;
				case 3:
					var key=Self.mrulist.get(myobject.id);
					if(!key) {
						if(!(Self.cache_request_id[myobject.id+":"+myobject.type])) {
							Self.ressourcefromserver.push(myobject.id);
						}
					} else {
				//		Self.idsreturn[myobject.id] = key;
					}
					break;
					
			}
			Self.cache_request_id[myobject.id+":"+myobject.type]=true;
		}
				
		if(Self.userfromserver.length>0) {
			 var cache_addUsers = function(allrequests) {
                var daten=allrequests.data;
				for (var i=0;i<daten.length;i++) {    
                    var myobject={id : daten[i][0] , user_id : daten[i][3] || daten[i][0], display_name : daten[i][1] , email1 : daten[i][2] }
                    myobject["type"] = 1;
					Self.addObject(myobject.id,myobject);
                    Self.idsreturn[myobject.id+":1"]=myobject;
                }
                Self.openrequests--;
                if(Self.openrequests==0) {
                    Self.executeCb();
                }
            }
            var requestArray = new Array();
            for(var zahl=0;zahl<Self.userfromserver.length;zahl++) {
                requestArray.push(Self.userfromserver[zahl]);
            }   
            Self.openrequests++;
			
            internalCachejson.put(AjaxRoot + "/user?session=" + session +
                "&action=list&columns=524,500,555,614", requestArray, null,
                cache_addUsers);

//            cache_addUsers({ data: [] });
		}
		if(Self.groupfromserver.length>0) {
		  cache_addGroup = function(allrequests) {
                for (var i=0;i<allrequests.length;i++) {    
                    var myobject=allrequests[i].data;
                    if(myobject.id==0) {
                        myobject=check0GroupDisplayName(myobject);
                    }
                    myobject["type"] = 2;
                    Self.addObject(myobject.id,myobject);
                    Self.idsreturn[myobject.id+":2"]=myobject;
                }
                Self.openrequests--;
                if(Self.openrequests==0) {
                    Self.executeCb();
                }
            }
            var requestArray = new Array();
            for(zahl=0;zahl<Self.groupfromserver.length;zahl++) 
            {
                var requestObject = new Object();
                requestObject['module'] = "group";
                requestObject['action'] = 'get';
                requestObject['id'] = Self.groupfromserver[zahl];   
                requestArray.push(requestObject);
            }   
            Self.openrequests++;                                
            internalCachejson.put(AjaxRoot + "/multiple?session=" + session,requestArray,null,cache_addGroup);
        }
		if(Self.ressourcefromserver.length>0) {
			cache_addRessource = function(allobjects) {
				for(var i=0;i<allobjects.length;i++) {
					if(allobjects[i].data) {
					   var oneobject=allobjects[i].data;
                        oneobject.type=3;
                        Self.addObject(oneobject.id,oneobject);
                        //TODO: this can be deleted as soon as the server response just only contains the requested data
                    }	
				}
				Self.openrequests--;
				if(Self.openrequests==0) {
					Self.executeCb();
				}
			}
			var requestArray = new Array();   
			for(var i=0;i<Self.ressourcefromserver.length;i++) 
            {
                var requestObject = new Object();
                requestObject['module'] = "resource";
                requestObject['action'] = 'get';
                requestObject['id'] = Self.ressourcefromserver[i];   
                requestArray.push(requestObject);
            }
            Self.openrequests++;                                
            internalCachejson.put(AjaxRoot + "/multiple?session=" + session,requestArray,null,cache_addRessource);
		}
		if(Self.openrequests==0) {
			Self.executeCb();
		}
	},
	addObject : function(userid,newobject) 
	{
		this.mrulist.set(userid, newobject);
	},
	executeCb : function () {
		var Self = this;
		for(;this.executezaehler<this.cache_allrequests.length;) {
			if(this.openrequests==0) {
				var returnarray=new Object();
				var mycb=this.cache_allrequests[this.executezaehler].cb;
				for(var zaehler2=0;zaehler2<this.cache_allrequests[this.executezaehler].ids.length;zaehler2++) {
					var persid=this.cache_allrequests[this.executezaehler].ids[zaehler2].id;
					var perstype=this.cache_allrequests[this.executezaehler].ids[zaehler2].type;
					if(persid == 0) {
						var melem=Self.mrulist.get(persid) || Self.idsreturn[persid+":"+perstype];
						if(!melem) {
							returnarray[this.cache_allrequests[this.executezaehler].ids[zaehler2].id]=check0GroupDisplayName({ id : 0 });
						} else {
							returnarray[this.cache_allrequests[this.executezaehler].ids[zaehler2].id]=melem;
						}
					} else {
						returnarray[this.cache_allrequests[this.executezaehler].ids[zaehler2].id]=Self.mrulist.get(persid) || Self.idsreturn[persid+":"+perstype];
					}
				}				
				this.executezaehler++								
				mycb(returnarray);
			} else {
				return;
			}
		}
		if(this.openrequests==0) {
            this.idsreturn=new Object();
        }
		this.cache_allrequests=new Array();
		this.cache_request_id=new Object();
		this.executezaehler=0;
	}
}
var group0name = "All users"; /*i18n*/
function check0GroupDisplayName(object) {
	if(object && object.id==0) {
		object.display_name=_(group0name);
	}
	return object;	
}
var internalCache = new Cache(2000);
fileloaded();