/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2006 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.data.conversion.ical.ical4j.internal.calendar;

import static net.fortuna.ical4j.model.Property.CLASS;
import static net.fortuna.ical4j.model.property.Clazz.CONFIDENTIAL;
import static net.fortuna.ical4j.model.property.Clazz.PRIVATE;
import static net.fortuna.ical4j.model.property.Clazz.PUBLIC;
import java.util.List;
import java.util.TimeZone;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.Clazz;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ConversionWarning.Code;
import com.openexchange.data.conversion.ical.ical4j.internal.AbstractVerifyingAttributeConverter;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.contexts.Context;

/**
 * {@link Klass} - Represents the attribute converter for <code>"CLASS"</code> element.
 * 
 * @author Francisco Laguna <francisco.laguna@open-xchange.com>
 */
public class Klass<T extends CalendarComponent, U extends CalendarObject> extends AbstractVerifyingAttributeConverter<T, U> {

    /**
     * Default constructor.
     */
    public Klass() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    public boolean isSet(final U cObj) {
        return cObj.containsPrivateFlag();
    }

    /**
     * {@inheritDoc}
     */
    public void emit(final int index, final U cObj, final T component, final List<ConversionWarning> warnings,
            final Context ctx) throws ConversionError {
        if (cObj.getPrivateFlag()) {
            component.getProperties().add(PRIVATE);
        } else {
            component.getProperties().add(PUBLIC);
        }
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasProperty(final T component) {
        return component.getProperty(CLASS) != null;
    }

    public void parse(final int index, final T component, final U cObj, final TimeZone timeZone, final Context ctx,
            final List<ConversionWarning> warnings) throws ConversionError {
        final Clazz clazz = (Clazz) component.getProperty(CLASS);
        /*
         * Parse non-empty value
         */
        if (PRIVATE.equals(clazz) || CONFIDENTIAL.equals(clazz)) {
            cObj.setPrivateFlag(true);
        } else if (PUBLIC.equals(clazz)) {
            cObj.setPrivateFlag(false);
        } else {
            final String value = clazz.getValue();
            if (isEmpty(value)) {
                warnings.add(new ConversionWarning(index, Code.EMPTY_CLASS, new Object[0]));
            } else {
                warnings.add(new ConversionWarning(index, Code.UNKNOWN_CLASS, value));
            }
        }
    }

    private static boolean isEmpty(final String str) {
        if (null == str) {
            return true;
        }
        final char[] chars = str.toCharArray();
        boolean empty = true;
        for (int i = 0; empty && i < chars.length; i++) {
            empty = Character.isWhitespace(chars[i]);
        }
        return empty;
    }

}
