
# norootforbuild
#!BuildIgnore: post-build-checks
BuildRequires:  ant ant-nodeps ant-apache-regexp ant-trax gettext-devel unzip
Name:           open-xchange-lang-community
BuildArch:	noarch
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-1.5.0-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%if %{?fedora_version} <= 8
BuildRequires:  java-devel-icedtea saxon
%endif
%endif
Version:	6.12.0.0
%define		ox_release 8
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          I18N
License:        Creative Commons Attribution-Noncommercial-Share Alike 2.5 Generic
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
#
Summary:        Open-Xchange Community translations

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-community-pl-pl
Group:          I18N
Summary:	Package containing translation for pl_PL

%description -n open-xchange-lang-community-pl-pl
Package containing translation for pl_PL

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-community-pl-pl
Group:          I18N
Summary:	Package containing translation for pl_PL
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-community-pl-pl
Package containing translation for pl_PL

Authors:
--------
    Open-Xchange


#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-community-ca-es
Group:          I18N
Summary:	Package containing translation for ca_ES

%description -n open-xchange-lang-community-ca-es
Package containing translation for ca_ES

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-community-ca-es
Group:          I18N
Summary:	Package containing translation for ca_ES
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-community-ca-es
Package containing translation for ca_ES

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-community-tr-tr
Group:          I18N
Summary:	Package containing translation for tr_TR

%description -n open-xchange-lang-community-tr-tr
Package containing translation for tr_TR

Authors:
--------
    Ismet Sonmez

%package -n	open-xchange-gui-lang-community-tr-tr
Group:          I18N
Summary:	Package containing translation for tr_TR
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-community-tr-tr
Package containing translation for tr_TR

Authors:
--------
    Ismet Sonmez

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-community-ko-ko
Group:          I18N
Summary:	Package containing translation for ko_KO

%description -n open-xchange-lang-community-ko-ko
Package containing translation for ko_KO

Authors:
--------
    Andrew Park

%package -n	open-xchange-gui-lang-community-ko-ko
Group:          I18N
Summary:	Package containing translation for ko_KO
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-community-ko-ko
Package containing translation for ko_KO

Authors:
--------
    Andrew Park

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-community-da-dk
Group:          I18N
Summary:	Package containing translation for da_DK

%description -n open-xchange-lang-community-da-dk
Package containing translation for da_DK

Authors:
--------
    Caspar Milan Nielsen
    Thomas Johansen

%package -n	open-xchange-gui-lang-community-da-dk
Group:          I18N
Summary:	Package containing translation for da_DK
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-community-da-dk
Package containing translation for da_DK

Authors:
--------
    Caspar Milan Nielsen
    Thomas Johansen

#------------------------------------------------------------------------------------------
%package -n     open-xchange-lang-community-it-it
Group:          I18N
Summary:        Package containing translation for it_IT

%description -n open-xchange-lang-community-it-it
Package containing translation for it_IT

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-community-it-it
Group:          I18N
Summary:        Package containing translation for it_IT
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-community-it-it
Package containing translation for it_IT

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n     open-xchange-lang-community-sv-sv
Group:          I18N
Summary:        Package containing translation for sv_SV

%description -n open-xchange-lang-community-sv-sv
Package containing translation for sv_SV

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-community-sv-sv
Group:          I18N
Summary:        Package containing translation for sv_SV
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-community-sv-sv
Package containing translation for sv_SV

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n     open-xchange-lang-community-pt-br
Group:          I18N
Summary:        Package containing translation for pt_BR

%description -n open-xchange-lang-community-pt-br
Package containing translation for pt_BR

Authors:
--------
    Taisei

%package -n     open-xchange-gui-lang-community-pt-br
Group:          I18N
Summary:        Package containing translation for pt_BR
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-community-pt-br
Package containing translation for pt_BR

Authors:
--------
    Taisei


#------------------------------------------------------------------------------------------
%description

Package containing i18n helper functions

Authors:
--------
    Open-Xchange

%prep
%setup -q -n %{name}-%{version}

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif
mkdir -p %{buildroot}/opt/open-xchange/etc/i18n.d
mkdir -p %{buildroot}/opt/open-xchange/etc
mkdir -p %{buildroot}/opt/open-xchange/i18n
mkdir -p %{buildroot}/%{docroot}/ox6/lang
mkdir -p %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/
export ANT_OPTS="-Dfile.encoding=UTF-8"
ant gui-lang
for lang in pl_PL ca_ES tr_TR ko_KO da_DK it_IT sv_SV pt_BR; do
	DLANG=${lang/_*}
	test -e $lang/lang.name && \
		install -m 644 $lang/lang.name %{buildroot}/opt/open-xchange/etc/i18n.d/$lang.name
	test -e $lang/server.${lang}.po && \
		install -m 644 $lang/server.${lang}.po \
		%{buildroot}/opt/open-xchange/i18n/server.${lang}.po
	test -e lang/${lang}.js && \
		install -m 644 lang/${lang}.js \
		%{buildroot}/%{docroot}/ox6/lang/${lang}.js
	test -e $lang/tinymce_lang_pack.${lang}.zip && \
		unzip $lang/tinymce_lang_pack.${lang}.zip \
			-d %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/ && \
	find %{buildroot}/%{docroot}/ox6/3rdparty/tinymce -type f -name "*${DLANG}*.js" \
		-printf '"%p"\n' > filelist_${DLANG} && \
		perl -pi -e 's;%{buildroot}/;;' filelist_${DLANG}
done


%clean
%{__rm} -rf %{buildroot}

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-pl-pl
. /opt/open-xchange/etc/i18nfunctions.sh
addLang pl_PL

%postun -n open-xchange-gui-lang-community-pl-pl
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang pl_PL

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-ca-es
. /opt/open-xchange/etc/i18nfunctions.sh
addLang ca_ES

%postun -n open-xchange-gui-lang-community-ca-es
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang ca_ES

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-tr-tr
. /opt/open-xchange/etc/i18nfunctions.sh
addLang tr_TR

%postun -n open-xchange-gui-lang-community-tr-tr
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang tr_TR

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-ko-ko
. /opt/open-xchange/etc/i18nfunctions.sh
addLang ko_KO

%postun -n open-xchange-gui-lang-community-ko-ko
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang ko_KO

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-da-dk
. /opt/open-xchange/etc/i18nfunctions.sh
addLang da_DK

%postun -n open-xchange-gui-lang-community-da-dk
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang da_DK

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-it-it
. /opt/open-xchange/etc/i18nfunctions.sh
addLang it_IT

%postun -n open-xchange-gui-lang-community-it-it
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang it_IT

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-sv-sv
. /opt/open-xchange/etc/i18nfunctions.sh
addLang sv_SV

%postun -n open-xchange-gui-lang-community-sv-sv
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang sv_SV

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-community-pt-br
. /opt/open-xchange/etc/i18nfunctions.sh
addLang pt_BR

%postun -n open-xchange-gui-lang-community-pt-br
. /opt/open-xchange/etc/i18nfunctions.sh
removeLang pt_BR


#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-pl-pl
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.pl_PL.po

%files -n open-xchange-gui-lang-community-pl-pl -f filelist_pl
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/pl_PL.js
/opt/open-xchange/etc/i18n.d/pl_PL.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-ca-es
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.ca_ES.po

%files -n open-xchange-gui-lang-community-ca-es -f filelist_ca
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ca_ES.js
/opt/open-xchange/etc/i18n.d/ca_ES.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-tr-tr
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.tr_TR.po

%files -n open-xchange-gui-lang-community-tr-tr -f filelist_tr
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/tr_TR.js
/opt/open-xchange/etc/i18n.d/tr_TR.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-da-dk
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.da_DK.po

%files -n open-xchange-gui-lang-community-da-dk -f filelist_da
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/da_DK.js
/opt/open-xchange/etc/i18n.d/da_DK.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-ko-ko
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.ko_KO.po

%files -n open-xchange-gui-lang-community-ko-ko -f filelist_ko
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ko_KO.js
/opt/open-xchange/etc/i18n.d/ko_KO.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-it-it
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.it_IT.po

%files -n open-xchange-gui-lang-community-it-it -f filelist_it
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/it_IT.js
/opt/open-xchange/etc/i18n.d/it_IT.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-sv-sv
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.sv_SV.po

%files -n open-xchange-gui-lang-community-sv-sv -f filelist_sv
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/sv_SV.js
/opt/open-xchange/etc/i18n.d/sv_SV.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-community-pt-br
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.pt_BR.po

#%files -n open-xchange-gui-lang-community-pt-br -f filelist_pt
%files -n open-xchange-gui-lang-community-pt-br
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/pt_BR.js
/opt/open-xchange/etc/i18n.d/pt_BR.name

