/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <Viktor.Pracht@open-xchange.org>
 * 
 */

var temporary = {};

temporary.Tabs = function() {
    ox.UI.Widget.call(this);
    this.labelParent = $("tabPanelsFDProps");
    this.tabParent = $("tabcontentsFDProps");
    this.tabs = [];
    var Self = this;
    registerView("configuration/folder",
        function() {
            Self.folder = oMainFolderTree.cache.find_folder(activefolder).
                oxfolder.data;
            if (!Self.initialized) {
                if (Self.init) Self.init();
                Self.addContent();
            }
        },
        function() { Self.enter(); },
        function() { Self.leave(); },
        null,
        function(newfolder) {
            var tab = Number(currentpath2[2]) == currentpath2[2];
            $("tab_props3").style.display = tab ? "" : "none";
            if (!Self.folder || activefolder != Self.folder.id) {
                Self.leave();
                Self.folder = oMainFolderTree.cache.find_folder(activefolder).
                    oxfolder.data;
                Self.enter();
            }
        });
};

temporary.Tabs.prototype = extend(ox.UI.Widget, {
    addContent: function() {
        var Self = this;
        ox.UI.Widget.prototype.addContent.call(this);
        for (var i = 0; i < this.tabs.length; i++)
            this.realizeTab(this.tabs[i]);
    },
    
    addTab: function(tab) {
        this.tabs.push(tab);
        tab.setParent(this);
        tab.setViewID("configuration/folder/" + this.tabs.length);
        if (this.initialized) this.realizeTab(tab);
    },
    
    labelClass: "tabPanel tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default",

    activeLabelClass: "tabPanelHi tabPanelHiColor background-color-content font-style-lable border-color-content-default",
    
    realizeTab: function(tab) {
        tab.labelNode = newnode("div", 0, { className: this.labelClass }, [
            newnode("span", 0, { className: "folderpropertiesTab" },
                [document.createTextNode("\xa0")]),
            newnode("span", 0, 0, [
                typeof(tab.label) == "function" || typeof(tab.label) == "string"
                    ? addTranslated(tab.label) : tab.label
            ])
        ]);
        var Self = this;
        this.labelParent.insertBefore(tab.labelNode,
                                      $("temporary.folderTabs.cleaner"));
        registerView(tab.viewID, null, function() {
            ox.Configuration.View.current = tab;
            tab.labelNode.className = Self.activeLabelClass;
            $("tab_props3").appendChild(tab.content);
            tab.enter();
        }, function() {
            tab.leave();
            $("tab_props3").removeChild(tab.content);
            tab.labelNode.className = Self.labelClass;
            ox.Configuration.View.current = null;
        }, null, function() {
            tab.leave();
            tab.enter();
        });
        addDOMEvent(tab.labelNode, "click", function(e) {
            Self.current = tab;
            changeTab("tab_props3", "");
            triggerEvent("OX_Switch_View", tab.viewID);
        });
        if (tab.init) tab.init();
        tab.addContent();
    },

    enter: function() {},
    
    leave: function() {},

    saveView: function() { this.current.saveView(); },
    
    cancelView: function() { this.current.cancelView(); },
    
    viewModified: function() {
        for (var i = 0; i < this.tabs.length; i++)
            if (this.tabs[i].viewModified()) return true;
        return false;
    }
    
});

temporary.Tab = function(label) {
    this.label = label;
    ox.UI.Container.apply(this);
}

temporary.Tab.prototype = extend(ox.Configuration.Page, {
    applyVisible: function() {
        this.labelNode.style.display = this.isVisible ? "" : "none";
    },
    setViewID: function(viewID) {
        this.viewID = viewID;
        changeDisplay(viewID, "menu_save");
    }
});

temporary.VTab = function(label, size) {
    this.label = label;
    this.size = size;
    ox.UI.Container.call(this);
}

temporary.VTab.prototype = extend(ox.Configuration.VSplit, {
    applyVisible: temporary.Tab.prototype.applyVisible,
    setViewID: temporary.Tab.prototype.setViewID
});

register("Loaded", function() {
    temporary.folderTabs = new temporary.Tabs();
});