/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

var refToMain = window.opener;
var contactDetailId = 0;
var activefolderLocal = "";
var activemoduleLocal = corewindow.activemodule;
var session = null;
var lastTimestamp = 0;
var modulPopup = "new";
var contact_object = {};
var color_label = 0;
var myDistrListAdressBook = null;
var myDistrListExternEmails = null;
var distrListDataFromSearchResult = {};
var distruGrid = null;
var distruBigGrid = null;
var distibutionMenu = null;
var configGetKey = corewindow.configGetKey;
var configSetKey = corewindow.configSetKey;
var configContainsKey = corewindow.configContainsKey;
var clickedItem = "";
var clickedItemForSave = "";
var json = null;
var messageOnCancel = false;
var newContactId = 0;
var savePending = false;
var dataFromDb;
/********************************** before on unload *****************************************************************/

function unloadMessage(){
	var messageCloseWindow = _("Do you really want to discard your changes and close the window?");
    return messageCloseWindow;
}

function setBeforeUnload(on){
    window.onbeforeunload = (on) ? unloadMessage : null;
    messageOnCancel = on;
}

//setBeforeUnload(true);
/********************************** Init *****************************************************************/

function closeWindow() {
	function cbyes() {
		window.onbeforeunload=null;
		window.close();			
	}
	if(messageOnCancel) {
		var messageCloseWindow = _("Do you really want to discard your changes and close the window?");
		newConfirm(_("Close Window"),messageCloseWindow,AlertPopup.YESNO,null,null,cbyes,null);		
	} else
		cbyes();
}

var internalCache = null;
var config = null;
/**
 * init() onLoad
 */
register("Loaded", newDistributionListOnload);
function newDistributionListOnload() {
	internalCache = corewindow.internalCache;
	config = corewindow.config;
			
	distrFromAddressbookLive(); //init myDistrListAdressBook	
	myDistrListExternEmails = new DistrListExtEmail();	
}

function initDistributionListLoaded() {
	activemodule='contact_new';
	initContents('contact_new');
	initAll();
	window.setTimeout(function() {
		var themeStyle = corewindow.oxThemeStyle || { name: "Default", path: "default" };
			
		loadCSSFileForNewWindow("themes/"+themeStyle.path+"/css/global.css");
		loadCSSFileForNewWindow("themes/"+themeStyle.path+"/css/popup.css");
		loadCSSFileForNewWindow("themes/"+themeStyle.path+"/css/bgimages.css");
	},0);
}

register("Loaded",viewDistributionMenu);
function viewDistributionMenu() {		
	activefolderLocal = corewindow.activefolder;
	session = corewindow.session;
	activemodule="contact_new";	
	json = new JSON();	
	register("OX_SAVE_OBJECT", saveContact);
	register("OX_Cancel_Object", closeWindow);
    
    register("OX_Object_Distributionlist_Internal_Contact", 
    	function() {
    		participants.openAddParticipantsWindow();    		
    		triggerEvent('searchContacts');
			if($("distribution_extern_emails"))
				$("distribution_extern_emails").style.display = 'none';
    	}
    );
    
    register("OX_Object_Distributionlist_External_Mail", 
    	function() {
            myDistrListExternEmails.clearList(); 
    		myDistrListExternEmails.showDialog();
    		$('extern_displayname').focus();
    	}
    );
    
    register("OX_Object_Distributionlist_Delete", 
    	function() {
    		distruBigGrid.deleteIDs(distruBigGrid.selection.getSelected());
    	}
    );
    
	if(window.location.hash != "") {
		setModulPopup();	
	}	
	folderPath();
	loadingComplete();

	triggerEvent("OX_Switch_View","contact_new/distributionlist");
	triggerEvent("OX_menu_Change_Height",true);
};

registerView("contact_new/distributionlist",
    null,
	function () {
		setTimeout(function() {	$("last_name").focus();	},0);
	},
	null,
	null,
	function () {
		setTimeout(function() {	$("last_name").focus();	},0);
	});


/********************************** Distribution List *****************************************************************/

function checkPermission(oFolderPermissions) {
	var oPermissions = oFolderPermissions.oxfolder.data.own_rights;
	var nPermission = getPermAsString(true, oPermissions, 0).bit;
	return nPermission;
}

function folderPath() {
	if(activefolderLocal && activefolderLocal != "" && activemoduleLocal =="contacts"){
		clickedItemForSave = activefolderLocal;
	} else {
		clickedItemForSave = corewindow.configGetKey("folder.contacts");
	}
	
	corewindow.oMainFolderTree.cache.get_folder(clickedItemForSave,function (ofolder){
		var nPermission = checkPermission(ofolder);
		
		if(nPermission < 2) {
			triggerEvent("OX_New_Error", 4, _("You do not have write permission for this folder. The new contact will be saved in your personal contacts folder. "));
			clickedItemForSave = configGetKey("folder.contacts");
		}
		
		corewindow.oMainFolderTree.get_folder_path(clickedItemForSave, cb_DLgetpath);
		
		var folderViewSettingsNewContact = new Object();
		var folderViewSettingsNewContactById = new Object();
		//Disable Email... 
		folderViewSettingsNewContact["mail"] = 4;
		folderViewSettingsNewContactById["default"] = 4;
		folderViewSettingsNewContact["contacts"] = 8;
		folderViewSettingsNewContact["calendar"] = 4;
		folderViewSettingsNewContact["tasks"] = 4;
		folderViewSettingsNewContact["infostore"] = 4;
		if(!dlTreeLoaded){
			newDlFolderTree = new cFolderTree(	$('folder_tree_info'),
											folderDLAction,										
											false,
											corewindow.oMainFolderTree.cache,
											corewindow.optFolderState.getState('folder_tree_info'));
			newDlFolderTree.enabled_modules = {contacts:true};	
			newDlFolderTree.setSaveConfiguration(corewindow.optFolderState);				

			newDlFolderTree.load();
			dlTreeLoaded = true;
		}		
	});					
}

function cb_DLgetpath(sPath) {
	document.getElementsByName('newDL_folder')[0].value = sPath;
}	

function folderDLAction(ofolder) {
	toggleTreePath();
	clickedItemForSave = ofolder.oxfolder.data.id;
	newDlFolderTree.get_folder_path(clickedItemForSave, cb_DLgetpath);
	
	/*
	 * folderType: z.B. shared...
	if(newContactFolderTree.getNodeByFolderId(clickedItem).data.sType != 1){
		$("newappointment_personal_tr").style.visibility = "hidden";
	} else {
		$("newappointment_personal_tr").style.visibility = "visible";
	}
	* */
}

var dlTreeLoaded = false;
var dlTreeVisible = false;

function showTree(){
	$("treeDialogNewDL").style.display = "block";	
}

function hideTree(){
	$("treeDialogNewDL").style.display = "none";	
}

function toggleTreePath(){
	if(!dlTreeVisible){
		$("treeDialogNewDL").style.display = "block";
		dlTreeVisible = true;
		if(!dlTreeLoaded){
			newDlFolderTree.load(corewindow.optFolderState.getState('folder_tree_info'));
			dlTreeLoaded = true;
			}
	}
	else{
		$("treeDialogNewDL").style.display = "none";
		dlTreeVisible = false;
	}
}

function callback_new(arg) {
	if(arg.error)
	{
		newServerError(arg);
	}
	else
	{
		finalFunction();
	}	
}

function callback_update(arg)
{
	if(arg.error)
	{
		newServerError(arg);
	}
	else
	{
		finalFunction();
	}
}


/*********** DL - Extern Email *********/

/**
 * Distribution List for external E-Mail adresses constructor
 */
function DistrListExtEmail() {	
	// init livegrid and new storage for external e-mail addresses
	this.selection = new Selection();
	this.storage = new Storage(0, [], 0, 0, 0, 0, function(external) { return external.id; });
	this.grid = new LiveGrid([
        { 
            text: "Name",
            i18n: true,
            clear: LiveGrid.makeClear(""),
            set: function(div, external) {
                if (div.firstChild)
                    div.firstChild.data = external.display_name;
                else
                    div.appendChild(document.createTextNode(external.display_name));
            }
        },
        {
            text: "E-Mail",
            i18n: true,
            clear: LiveGrid.makeClear(""),
            set: function(div, external) {
                if (div.firstChild)
                    div.firstChild.data = external.email;
                else
                    div.appendChild(document.createTextNode(external.email));
            }
        }
    ], this.selection);
    this.grid.emptylivegridtext = "";
    
    // add livegrid header and content to dom node
    $("dist.ext.mail.grid.header").appendChild(this.grid.getHeader());
    this.grid.getTable($("dist.ext.mail.grid"));
}

DistrListExtEmail.prototype = {
	
	/**
	 * Displays the external E-Mail Dialog
	 */
	showDialog: function() {        
        this.grid.enable(this.storage);
	    $("floatingdivParticipants").style.display = 'none';
	    centerPopupWindow($("distribution_extern_emails"));
        $("distribution_extern_emails").style.display = 'block';
	},	
	
	/**
	 * Closes the external E-Mail Dialog
	 */
	closeDialog: function() {
		$("distribution_extern_emails").style.display = 'none';
		this.grid.disable();
	},
	
	/**
	 * Resets the list of external e-mail addresses
	 */
	clearList: function(){
		$('extern_displayname').value = "";
        $('extern_email').value = "";
		this.storage.remove(0, this.storage.ids.length);
	},
	
	/**
	 * Adds a new external e-mail address to the list
	 * @param displayName The display name
	 * @param email The e-mail address (required)
	 */
	addToList: function(display_name, email) {
		display_name = trimStr(display_name || "");
		email = trimStr(email);
		this.storage.append([{ 'id': this.storage.ids.length, 'display_name': display_name, 'email': email }]);		
	}
}

/**
 * Closes the external E-Mail Dialog and clears the temp list.
 */
function closeExternalEmailDialog() {
	myDistrListExternEmails.clearList(); 
	myDistrListExternEmails.closeDialog();
}

/**
 * Gets the display name and email address from the page, validates and 
 * adds it to the list. Afterwards the fields on the page gets cleared
 * or fucused. 
 */
function addExternalEmailToList() {
	var disp = trimStr($('extern_displayname').value || ""); 
	var email = trimStr($('extern_email').value || "");
	var goahead = function(disp, email) {
        $("extern_email").className = removeClass($("extern_email").className, "border-color-error");
        myDistrListExternEmails.addToList(disp, email);
        $('extern_displayname').value = "";
        $('extern_email').value = "";
	}
	if (email.length == 0) {
        if (!$("extern_email").className.match(/border-color-error/gi)) 
            $("extern_email").className += " border-color-error";
        newAlert(_("Error"), _("Please enter a valid E-Mail address!"), function() {
        	   $("extern_email").focus();
            });
    } else if (!corewindow.validateEmail(email)) {
    	if (!$("extern_email").className.match(/border-color-error/gi))  	
            $("extern_email").className += " border-color-error";
        newConfirm(_("Error"),_("The E-Mail address you have entered seems not to be valid. Would you like to add it anyway?"),AlertPopup.YESNO,null,null,
            function() { goahead(disp, email); }, function () { $("extern_email").focus(); });
    } else {        
        goahead(disp, email);
        setFocus($('extern_displayname'));
    }
}

/**
 * Append the external added email addresses to the big grid.
 */
function appendExternalToBigGrid() {
	
	var data = myDistrListExternEmails.storage;
	// loop items
	data.newIterate(data.ids, null, function(key, item) {
		// copy items
		distruBigGrid.storage.append([{
			// use negative id for temporary contacts
			'id': -distruBigGrid.storage.ids.length,
			'display_name': item.display_name,
			'email': item.email
		}]);
	});
}

// to move
var participants = null;

/*********** DL - From Adressbook *********/
function distrFromAddressbookLive() {
	// selection
	var selection = new Selection();
	// storage
	var storage = new Storage(0, [], 0, 0, 0, 0, function(external) { return external.id; });
	// live grid
	distruBigGrid = new LiveGrid([
        { 
            text: "Name",
            i18n: true,
            clear: LiveGrid.makeClear(""),
            set: function(div, external) {
                if (div.firstChild)
                    div.firstChild.data = external.display_name;
                else
                    div.appendChild(document.createTextNode(external.display_name));
            }
        },
        {
            text: "E-Mail",
            i18n: true,
            clear: LiveGrid.makeClear(""),
            set: function(div, external) {
                if (div.firstChild)
                    div.firstChild.data = external.email;
                else
                    div.appendChild(document.createTextNode(external.email));
            }
        }
    ], selection);
			
	distruBigGrid.emptylivegridtext = "";	
    // add livegrid header and content to dom node
    $("newDistrListLiveHeader").appendChild(distruBigGrid.getHeader());
    distruBigGrid.getTable($("newDistrListLive"));    
    distruBigGrid.enable(storage);
    
    // what to do when select a appointment
	distruBigGrid.events.register("Selected", function(ids) {		
		var count = distruBigGrid.selection.getSelected().length;		
		triggerEvent("SubSelected", count);
	});
	
	distruBigGrid.events.register("Delete", function(ids) {
		triggerEvent("OX_Object_Distributionlist_Delete");
	});
    
    // ------------------------------------------------------------------------
	folderOwner = configGetKey("identifier");
	
	// use ParticipantsSmall (without its own LiveGrid)
	participants = new ParticipantsSmall(
		null,
		// callback function to process contacts provided by the popup window
		function(items) {
			// loop items
			for(i = 0; i < items.length; i++) {
				// shortcut
				var item = items[i];
				// type
				switch (item.type) {
					// user
					case 1:
						// duplicate?
						if ( typeof(storage.indices[item.id]) == 'undefined' ) {
							// add to list
							storage.append([{ 
								'id': item.id,
								'display_name': item.display_name || "",
								'email': item.mail
							}]);
						}						
						break;
						
					// contact
					case 5:
						// duplicate?
						if ( typeof(storage.indices[item.id]) == 'undefined' ) {
							// add to list
							storage.append([{ 
								'id': item.id,
								'display_name': item.display_name || "",
								'email': item.mail
							}]);
						}
						break;
				}
			}
		},
		// showUser, showGroup, showResource, showFolder, title, id, singleFolderSearch
		true, false, false, true, "Select Contacts", folderOwner); /*i18n*/
	
	initParticipantContent();
}

function distributionlistContact() {
		var searchString = $('distr_search').value;
		myDistrListAdressBook.searchstring = searchString;
					
		myDistrListAdressBook.getResult();
		distruGrid.events.register("Activated", function(ids){		
			});
		
		distruGrid.events.register("Selected", function(ids){
				myDistrListAdressBook.numberOfSelection = ids;	
			});
}

function addDistrToList() {
	if (myDistrListAdressBook) {
		myDistrListAdressBook.addToList('bySelection');
	}	
}

function addAllDistrToList() {
	if (myDistrListAdressBook) {
		myDistrListAdressBook.addToList('all');
	}	
}


/********************************** Save Contact *****************************************************************/
/**
 * triggerEvent -> save Button
 * switch: new, edit, dublicate, newmember
 */
function saveContact()
{
	if(savePending) return;
	else savePending = true;
	
	if(modulPopup == "new" || modulPopup == "duplicate")
	{
		writeNewContact();
	} else if(modulPopup == "edit")
	{
        
        /********************************** update Contact ********************************************************/	
		
		contact_object.last_name = $('last_name').value;
		contact_object.display_name = $('last_name').value;
		contact_object.folder_id = clickedItemForSave;
		
		var cb_put = function() {
			json.put(AjaxRoot + "/contacts?action=update&session=" + session + 
				"&id=" + contactDetailId + "&folder=" + activefolderLocal + 
				"&timestamp="+lastTimestamp,
				contact_object, 
				null, 
				function(updatedFields)
				{	
					if(updatedFields) {
						if(updatedFields.error) {
							//error
						} else {
							finalFunction();
						}
					}
				}
			);
		}
		
		getDistrForSave(cb_put);

		
	}
}

/*
 * build contact_object.distribution_list for save 
 * */

function getDistrForSave(callback) {
	
	var data = distruBigGrid.storage;
	var tmpDistObj = new Array();
	// loop items
	data.newIterate(data.ids, null, function(key, obj) {
		// collect items
		tmpDistObj.push({
			// positive id=user/contact; negative id=temp-id for external users
			"id": obj.id < 0 ? "" : obj.id,
			"display_name": obj.display_name,
			"mail": obj.email, 
			"mail_field" : 1
		});		
	});
	// done...
	contact_object.distribution_list = tmpDistObj;
	contact_object.color_label = color_label || 0;
	
	// callback
	if(callback) callback();
}


/********************************** set var Module *****************************************************************/
/**
 * Init Popup for setting the Modul
 * @param {String} parameters from the url 
 */
function setModulPopup(params) {
	
	/////////
	// Modul Edit or Duplicate
	if (url['modul'] && url['modul'] == "edit") 	{
			modulPopup = "edit";
			contactDetailId = url['id'];
			activefolder = url['folder'];
			session = url['session'];
			currentView = url['currentView'];
			fillFieldById();		
	} else if(url['modul'] && url['modul'] == "duplicate") {
			modulPopup = "duplicate";
			contactDetailId = url['id'];
			activefolder = url['folder'];
			session = url['session'];
			currentView = url['currentView'];
			fillFieldById();		
	} else {
		// disable loading screen
        $("loading_data_bg").style.display="none";
	}
	
}

/********************************** get ContactById *****************************************************************/

/**
 * fill the Fields which comes from DB 
 * id is a Param in the url, see {@link setModulPopup}
 */
function fillFieldById() {
	
	// load distribution list (ajax call)
	new JSON().get(
		AjaxRoot + "/contacts?action=get&session=" + session +
		"&id=" + contactDetailId + "&folder=" + activefolderLocal, null,
		// callback to process the JSON response
		function(response) {
			
			// remember response (used by dialog closer)
			dataFromDb = response;
			
			// shortcut			
			var d = response.data;			
			
			// set "last_name" (text field) -> name of the distribution list
			$('last_name').value = d['last_name'];
			// set "display_name" (hidden field)
			$('display_name').value = d['last_name'];
			
			// set color label
			if (d['color_label']) color_label = d['color_label'];

			if (d['distribution_list']) {
				// shortcut
				var dl = d['distribution_list'];				
				// loop entries
				for(i = 0; i < dl.length; i++ ) {
					// add to storage (live grid)
					distruBigGrid.storage.append([{ 
						'id': dl[i].id || -distruBigGrid.storage.ids.length,
						'display_name': dl[i].display_name || "",
						'email': dl[i].mail || ""
					}]);
				}				
			}
			
			// remember timestamp
			lastTimestamp = response.timestamp;

			// disable loading screen
		    $("loading_data_bg").style.display="none";
		}
	);
}


/********************************** Write new Contact *****************************************************************/
/**
 * Write all filled fields in DB
 * json.put -> contact_object
 */
function writeNewContact() {
	if($("last_name").value == "") {
		triggerEvent("OX_New_Error", 4, _("Mandatory Field(s) missing!"));
		$("last_name").className += " borderDefault border-color-error";
		$("last_name").focus();
		savePending = false;	
	} else {		
		contact_object.last_name = $('last_name').value;
		contact_object.display_name = $('last_name').value;
		contact_object.folder_id = clickedItemForSave;
				
		var tmpString = new Array;
		contact_object.distribution_list = tmpString; //mark as Distribution List
		getDistrForSave();
				
		json.put(AjaxRoot + "/contacts?action=new" + 
				"&session=" + refToMain.session + 
				"&folder=" + clickedItemForSave , 
				contact_object, null, function(idObj){
				if(idObj) {	
					newContactId = idObj.data.id;
					finalFunction();
				}
			});
	}
}


function finalFunction() {
	
	if(modulPopup == "new" || modulPopup == "duplicate") {
		// new/duplicate
		setBeforeUnload(false);
		corewindow.OXContactMapping.createObject(contact_object);
		corewindow.closeContactPopUp(window, clickedItemForSave);
	} else if(modulPopup = "edit") {
		// 	edit
		setBeforeUnload(false);
		corewindow.OXContactMapping.editObjects([dataFromDb.data],
            corewindow.clone(contact_object, window));
		corewindow.closeContactPopUp(window, clickedItemForSave);
    }
}