/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan@open-xchange.org>
 * 
 */
register_Calendar();

var activeDate=new Date();
var activeDay=activeDate.getDate();
var activeMonth=activeDate.getMonth();
var activeYear=activeDate.getFullYear();
var calendarFolderPath;

/*********************************************************************************************************************/
var selectedAppointment=new Object();
var calendarSelection = new Selection();

calendar_serializeid = function(x) {
	return x.folder + "." + x.id + "." + (x.recurrence_position || 0) 
	       + "." + (x.recurrence_id || 0) + "." + (x.created_by || 0);
};
calendar_makeID = function (x) {
	var mObj = { id: x[0], folder: x[1] };	
	if (x[2] != undefined) { 
		mObj["recurrence_position"]=x[2]; 
	}
	if (x[3] != undefined) {
		mObj["recurrence_id"]=x[3];
	}
	if (x[4] != undefined) {
        mObj["created_by"]=x[4];
    }
	return mObj;
}

var calendarhovers=new Object();
function register_Calendar() {
	
	registerView("calendar",null,
	function () { 
		register("OX_New_Search", calendarSearch); 		
	},
	function () { 
		unregister("OX_New_Search", calendarSearch); 
	},
	function () {
		menuclearSearch();
	});
	registerView("calendar/calendar/day",
		function() { 
			showNode("calendarWorkweek"); 
		}, 
		function() { 
			maxappointmentsperday=configGetKey("gui.calendar.day.numberofappointments");
			cwwdaysinweek = 1;
			var oDateLoc = new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0));			    
			startofweek=oDateLoc.getUTCDay();
			if (oMiniCalendar) oMiniCalendar.setSelectedByDate(activeYear, activeMonth, activeDay);
			
			unregister("OX_Create_Object",default_calendar_create_object);
			register("OX_Create_Object",default_calendar_workweek_create_object);		
 			cwwenable();
            displayNameDayView();       
            calendarFolderPath.drawDOMNode("calendarofworkweekview", activefolder);
			showCalendarWorkweek();
			register("OX_Add_Flag", calendarAddTag);
			if (calendarhovers["daywwcustom"] && configGetKey("gui.effects.hover.calendar")) {
				calendarhovers["daywwcustom"].enable();
				calendarhovers["daywwcustom2"].enable(); 
			}			
		 }, 
		 function() {
		 	if (calendarhovers["daywwcustom"]) { 
		 		calendarhovers["daywwcustom"].disable(); 
		 		calendarhovers["daywwcustom2"].disable(); 
		 	}
		 	unregister("OX_Create_Object",default_calendar_workweek_create_object);		 	
 			register("OX_Create_Object",default_calendar_create_object);
 			cwwdisable();
 			calendarFolderPath.clear();
		 	unregister("OX_Add_Flag", calendarAddTag);	
		 },
		function() { 
			hideNode("calendarWorkweek"); 
		},
		function() { 
			var oDateLoc = new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0));	
			startofweek=oDateLoc.getUTCDay();
			displayNameDayView();
			calendarFolderPath.drawDOMNode("calendarofworkweekview", activefolder);		
			showCalendarWorkweek();
		}
	);
	registerView("calendar/calendar/workweek",
		function() { 
			showNode("calendarWorkweek"); 
		}, 
		function() { 
 			maxappointmentsperday=configGetKey("gui.calendar.workweek.numberofappointments");
			cwwdaysinweek = configGetKey("gui.calendar.workweek.countdays");
			startofweek=configGetKey("gui.calendar.workweek.startday");
			unregister("OX_Create_Object",default_calendar_create_object);
			register("OX_Create_Object",default_calendar_workweek_create_object);	
			calendarFolderPath.drawDOMNode("calendarofworkweekview", activefolder);	 	
			displayNameDayView();		
 			cwwenable();
			showCalendarWorkweek();		
			if(calendarhovers["daywwcustom"] && configGetKey("gui.effects.hover.calendar")) { 
				calendarhovers["daywwcustom"].enable(); 
				calendarhovers["daywwcustom2"].enable(); 
			}
			register("OX_Add_Flag", calendarAddTag);
		}, 
		function() {
 			if (calendarhovers["daywwcustom"]) { 
 				calendarhovers["daywwcustom"].disable(); 
 				calendarhovers["daywwcustom2"].disable(); 
 			}
			unregister("OX_Create_Object",default_calendar_workweek_create_object);		 	
 			register("OX_Create_Object",default_calendar_create_object);
 			calendarFolderPath.clear();
			cwwdisable()
		 	unregister("OX_Add_Flag", calendarAddTag);	
		},
        function() { 
			hideNode("calendarWorkweek");
		},
		function() {
			displayNameDayView();
			calendarFolderPath.drawDOMNode("calendarofworkweekview", activefolder);	
			showCalendarWorkweek();
		}
	);
	registerView("calendar/calendar/custom",
		function() { showNode("calendarWorkweek"); }, 
		function() { 
 			maxappointmentsperday=configGetKey("gui.calendar.custom.numberofappointments");
			cwwdaysinweek = configGetKey("gui.calendar.custom.countdays");
			var oDateLoc = new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0));	
			startofweek=oDateLoc.getUTCDay();
			unregister("OX_Create_Object",default_calendar_create_object);
			register("OX_Create_Object",default_calendar_workweek_create_object);
			calendarFolderPath.drawDOMNode("calendarofworkweekview", activefolder);		 	
			displayNameDayView();		
 			cwwenable();
			showCalendarWorkweek();
			if (calendarhovers["daywwcustom"] && configGetKey("gui.effects.hover.calendar")) { 
				calendarhovers["daywwcustom"].enable(); 
				calendarhovers["daywwcustom2"].enable(); 
			}		
			register("OX_Add_Flag", calendarAddTag);
		 }, 
		 function() {
 			if (calendarhovers["daywwcustom"]) { 
 				calendarhovers["daywwcustom"].disable(); 
 				calendarhovers["daywwcustom2"].disable(); 
 			}
			unregister("OX_Create_Object",default_calendar_workweek_create_object);		 	
 			register("OX_Create_Object",default_calendar_create_object);
			cwwdisable()
			calendarFolderPath.clear();
		 	unregister("OX_Add_Flag", calendarAddTag);	
		 },
		function() { 
			hideNode("calendarWorkweek");
		},
		function() {
			var oDateLoc = new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0));	
			startofweek=oDateLoc.getUTCDay();
			calendarFolderPath.drawDOMNode("calendarofworkweekview", activefolder);
			displayNameDayView();		
			showCalendarWorkweek();
		}
	);
	var firstmonthview=false;
	registerView("calendar/calendar/month",
		function() { 
			showNode("calendarMonth");
			$("calendarMonth").style.display="block"; 
		}, 
		function() {
			if(!firstmonthview) { 
				firstmonthview=true;
				var hover=new Hover($("calmain"),OXAppointmentHover.getContent().node);
				calendarhovers["month"]=hover;	
				hover.setSize(OXAppointmentHover.contentobject.node);
				hover.getTarget = function (node) {
                    try {
    					while (node) {
    						if(node.oxcalobj) {
                                return node.parentNode ? node : null;
                            }
    						node = node.parentNode;
    					}
                    } catch (e) { /*see default implementation*/ }
                };
				hover.onShow = function (node) {
					OXAppointmentHover.actualHover=this;
					var splitid=node.oxcalobj.split("-");
					return OXAppointmentHover.refillContent(splitid[1],splitid[0],splitid[2]);	
				} 
			} 
			if(configGetKey("gui.effects.hover.calendar") && calendarhovers["month"]) {
				calendarhovers["month"].enable();
			}
			calendarFolderPath.drawDOMNode("calendarofmonthview", activefolder);
			displayNameDayView();	  
			register('OX_Refresh',refreshMonthView);
		  	register("OX_Add_Flag", calendarAddTag);
			resizeEvents.register("Resized",resizeWeekSections);
			unregister("OX_Create_Object",default_calendar_create_object);
			register("OX_Create_Object",default_calendar_workweek_create_object);		
		  	loadMonthView();
		 }, 
		 function() {
		 	if (calendarhovers["month"]) { 
		 		calendarhovers["month"].disable(); 
		 	}
		 	unregister('OX_Refresh',refreshMonthView);
		 	unregister("OX_Add_Flag", calendarAddTag);
			register("OX_Create_Object",default_calendar_create_object);
			unregister("OX_Create_Object",default_calendar_workweek_create_object);		 	
		 	resizeEvents.unregister("Resized",resizeWeekSections);
		 	calendarFolderPath.clear();
		 },
		function() { 
			hideNode("calendarMonth");
			$("calendarMonth").style.display="none";
		},
		function() {
			calendarFolderPath.drawDOMNode("calendarofmonthview", activefolder);
			displayNameDayView();
			refreshMonthView(true);		
            resizeEvents.register("Resized",resizeWeekSections);	
		}
	);
	registerView("calendar/calendar/week",
		function() { 
			showNode("calendarWeek");
			$("calendarWeek").style.display=""; }, 
		function() { 
			calendarFolderPath.drawDOMNode("calendarofweekview", activefolder);
			displayNameDayView(); 	
			unregister("OX_Create_Object",default_calendar_create_object);
			register("OX_Create_Object",default_calendar_workweek_create_object);		
			objWeekCalendarTool.init();
			register("OX_Add_Flag", calendarAddTag);
		 }, 
		 function() {
		 	if(calendarhovers["week"]) { 
		 		calendarhovers["week"].disable(); 
		 	}
			register("OX_Create_Object",default_calendar_create_object);
			unregister("OX_Create_Object",default_calendar_workweek_create_object);	
		 	unregister("OX_Add_Flag", calendarAddTag);
		 	calendarFolderPath.clear(); 	
		},
		function() { 
			hideNode("calendarWeek");
			$("calendarWeek").style.display="none"; },
		function() {
			calendarFolderPath.drawDOMNode("calendarofweekview", activefolder);
			displayNameDayView();
			objWeekCalendarTool.init();
		}
	);
	
	function calendarteamdayrefresh() {
		displayNameDayView();
		ctd_startContent();	
	}
	
	registerView("calendar/team/day",
		function() { 
			showNode("calendarTeamDay");
			if(ctd_participants == null)
				team_initContent();
			$("calendarTeamDay").style.display=""; 
		}, 
		function() { 
			filldefaultteam();
			ctd_startContent()			
			register("OX_Refresh", calendarteamdayrefresh);			
			register("OX_Add_Flag", calendarAddTag);
			if (configGetKey("gui.effects.hover.calendar") && calendarhovers["teamday"]) {
				calendarhovers["teamday"].enable();
			}
		}, 
		function() {
		    ctd_leaveContent();	
			unregister("OX_Refresh", calendarteamdayrefresh);
		    unregister("OX_Add_Flag", calendarAddTag);
		    if (calendarhovers["teamday"]) {
				calendarhovers["teamday"].disable();
			}
		},
		function() { 
			hideNode("calendarTeamDay");
			$("calendarTeamDay").style.display="none";
		},
		function() {
			displayNameDayView();
			ctd_startContent();	
		}
	);
	
	function calendarteamweekrefresh() {
		displayNameDayView();
		loadTeamWeek();
	}
	
	registerView("calendar/team/workweek",
		function() { 
			showNode("calendarTeamWeek");
			if(ctd_participants == null)
			{
				$("calendarTeamWeek").style.display=""; 
				team_initContent();
			}}, 
		function() { 
			register("OX_Refresh", calendarteamweekrefresh);
			filldefaultteam();
			displayNameDayView();
			loadTeamWeek();
			if (configGetKey("gui.effects.hover.calendar") && calendarhovers["teamworkweek"]) {
				calendarhovers["teamworkweek"].enable();
			}
		 }, 
		 function() {
		 	unloadTeamWeek();
		 	if (calendarhovers["teamworkweek"]) {
				calendarhovers["teamworkweek"].disable();
			}
		 },
		function() { 
			unregister("OX_Refresh", calendarteamweekrefresh);
			hideNode("calendarTeamWeek");
			$("calendarTeamWeek").style.display="none";
		},
		function() { 
			displayNameDayView();
			loadTeamWeek(); 
		}
	);
	registerView("calendar/list",
		function() { 
			showNode("calendarList");
			$("calendarList").style.display=""; 
		}, 
		function() {			
			register("OX_Print",calendar_printList); 
			register("OX_Add_Flag", calendarAddTag);
		}, 
		 function() {
		 	calendarFolderPath.clear();
		 	disableCalendarGrid();
		 	unregister("OX_Print",calendar_printList);
		 	unregister("OX_Add_Flag", calendarAddTag);
		 },
		function() { 
			hideNode("calendarList");
			$("calendarList").style.display="none";
		}
	);
	registerView("calendar/list/day",
		null, 
		function() {
			calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
			cwwdaysinweek = 1; 
			if(!calendarGrid){
				initCalenderLiveGridOnLoad();
			}
			initLiveGridCalendar("day");
		 }, 
		 null,
		 null,
		 function() {
		 	calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
		 	displayNameDayView();
		 	initLiveGridCalendar("day"); 
		 }
	);
	registerView("calendar/list/workweek",
		null, 
		function() {
			calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
			cwwdaysinweek = configGetKey("gui.calendar.workweek.countdays");
            startofweek=configGetKey("gui.calendar.workweek.startday");
			if(!calendarGrid){
				initCalenderLiveGridOnLoad();
			}
			initLiveGridCalendar("workweek");
		 }, 
		 null,
		 null,
		 function() { 
		 	initLiveGridCalendar("workweek");
		 	calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
		 	displayNameDayView(); 
		 }
	);
	registerView("calendar/list/month",
		null, 
		function() {
			calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
			if(!calendarGrid){
				initCalenderLiveGridOnLoad();
			}
			initLiveGridCalendar("month");
		 }, 
		 null,
		 null,
		 function() {
		 	calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
		 	displayNameDayView();
		 	initLiveGridCalendar("month"); 
		 }
	);
	registerView("calendar/list/week",
		null, 
		function() {
			calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
			if(!calendarGrid){
				initCalenderLiveGridOnLoad();
			}
			initLiveGridCalendar("week");
		 }, 
		 null,
		 null,
		 function() {
		 	calendarFolderPath.drawDOMNode("calendaroflistview", activefolder);
		 	displayNameDayView();
		 	initLiveGridCalendar("week"); 
		 }
	);
	registerView("calendar/list/search",
		null, 
		function() { 
			if (!calendarGrid){
				initCalenderLiveGridOnLoad();
			}
			initLiveGridCalendar("search");
			register("OX_Delete_Search", calendarDeleteSearch);			
			if (lastCalendarSearch) {			   
               setTimeout(function() {
               	    calendarFolderPath.nodeId="calendaroflistview";
                	calendarFolderPath.drawSearch(lastCalendarSearch.module, lastCalendarSearch.searchstring);
                },0);
            }			
		 }, 
		 function() {
		 	calendarFolderPath.clear();	 	
	 		unregister("OX_Delete_Search", calendarDeleteSearch);
		 },
		 null
	);
	registerView("calendar/detail",
		function() { 
			showNode("calendarAppointmentDetail");
			$("calendarAppointmentDetail").style.display=""; }, 
		function() { 
			register("OX_Refresh",reloadAppDetailView);
			register("OX_AcceptDeny_Changed",reloadAppDetailView);
			register("OX_Confirmation_Change",caldetail_change_Confirm);
			if(selectedAppointment.length && selectedAppointment.length == 1) {
				selectedAppointment = selectedAppointment[0];
			}
			if(selectedAppointment.id)
			{
				detailAppointmentOnload();									
			}			
			
			if(typeof selectedAppointment == 'undefined' || selectedAppointment == '')
			{
				triggerEvent("OX_New_Error", 4, _("No Appointment selected."));
			}
			register("OX_Add_Flag", calendarAddTag);	
		 }, 
		 function() {
		 	//LEAVE
			unregister("OX_Refresh",reloadAppDetailView);
			unregister("OX_AcceptDeny_Changed",reloadAppDetailView);
			unregister("OX_Confirmation_Change",caldetail_change_Confirm);
			unregister("OX_Add_Flag", calendarAddTag);
			objAppDetailParticipants = null;
		 },
		function() { 			
			hideNode("calendarAppointmentDetail");
			$("calendarAppointmentDetail").style.display="none";
		}
	);
	registerView("calendar/detail/overview",
		function() {
			register("OX_Print",calendar_printDetail);
			$("tabAppointmentDetail1").style.display="block";
			$("panelAppointmentDetail1").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";			
		},
		null, 
		null,
		function() {
			unregister("OX_Print",calendar_printDetail);
			$("tabAppointmentDetail1").style.display="none";
			$("panelAppointmentDetail1").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";			
		}
	);
	registerView("calendar/detail/participant",
		function() {
			$("tabAppointmentDetail2").style.display="block";
			$("panelAppointmentDetail2").className="tabPanelHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";			
		}, 
		function() { 
			refAppDetailParticipantTab.enableGrid();
			currentAppointmentDetailTab = 'PARTICIPANT';
		 }, 
		function() {
			if(a_d_participantGrid && a_d_participantGrid.storage) {
				refAppDetailParticipantTab.disableGrid();
			}
		},
		function() {
			$("tabAppointmentDetail2").style.display="none";
			$("panelAppointmentDetail2").className="tabPanel tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";			
		}
	);
	var attachmentGridLoaded = false;
	registerView("calendar/detail/attachment",
		function() {
			$("tabAppointmentDetail3").style.display="block";
			$("panelAppointmentDetail3").className="tabPanelHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";			
		}, 
		function() {
			if(!attachmentGridLoaded)
			{
				makeDetailAppointmentAttachmentGrid();
				attachmentGridLoaded = true;
			}
			else
				gridatt.enableGrid();
			gridatt.getAttachments(selectedAppointment.id,selectedAppointment.folder);				
		}, 
		 function() {
		 	if(attachmentGridLoaded)
				gridatt.disableGrid();
		},
 		function() {
			$("tabAppointmentDetail3").style.display="none";
			$("panelAppointmentDetail3").className="tabPanel tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";			
		}

	);				
}
var ctd_tv_members;
register("Loaded",function() {
	// preparing currently selected members for later use in new appointment, see US532
	register("OX_Teammember_Changed",
			function(members) { 
				var _mem = [];
				for (var i in members) {
					_mem.push([0, 0, members[i].display_name, 0, members[i].id, 0, 0, members[i].type]);
				}
				ctd_tv_members = {};				
				ctd_tv_members["data"] = _mem;
				ctd_tv_members["module"] = "contacts";
			}
	);
	
    calendarFolderPath = new FolderPath("calendar");

    var ids = ["arrowForCWVOptions", "arrowForCWWVOptions",
        "arrowForCMVOptions", "arrowForTDVOptions", "arrowForTWWVOptions",
        "arrowForCLVOptions", "arrowForCDetailVOptions"];
    for (var i in ids) {
        var menu = new PulldownMenu($(ids[i]));
        menu.addItem((new MenuItem("Options"/*i18n*/, showOptions))
                      .setIcon("img/folder/settings.gif"));
    }

    function showOptions() { 
        var elem=currentpath2.join("/");
        if(elem.indexOf("calendar/calendar") == 0 || elem.indexOf("calendar/detail") == 0 || elem.indexOf("calendar/list") == 0) { 
            triggerEvent("OX_Switch_View","configuration/calendar/preferences");
        } else if(elem.indexOf("calendar/team") == 0) { 
            triggerEvent("OX_Switch_View","configuration/calendar/teams");
        }   
    }
});

/*********************************************************************************************************************/
var calendar_activeallfolders=true;
registerPrintView("calendar/list/day");
registerPrintView("calendar/list/workweek");
registerPrintView("calendar/list/month");
registerPrintView("calendar/list/week");
registerPrintView("calendar/list/search");
registerPrintView("calendar/detail/overview");

function calendar_printList() {
	globalprint.printLiveGrid(calendarGrid);
}

function default_calendar_create_object(module,folder) {
	if (module=="calendar") {
		var d=new Date();
		var myinterval=15;
		d.setUTCDate(1);
		d.setUTCMonth(activeMonth);
		d.setUTCFullYear(activeYear);
		d.setUTCDate(activeDay);
		d.setUTCHours(d.getHours());
		var mymin=d.getUTCMinutes();
		if(mymin % myinterval) {
			mymin=mymin - (mymin % myinterval)+ myinterval;
		}
		d.setUTCMinutes(mymin);		
		calendar_createNewAppointment(d, folder, false, 
				(currentpath2.join("/").match(/^calendar\/team\//) ? ctd_tv_members : null));	
	}
}

function calendar_createNewAppointment(startdate,infolder,wholeday,oFromMail) {	
	var checkfolder;
	var wholeday=wholeday;
	var folder_id_tocheck  = (infolder)?infolder:((activefolder)?activefolder:config.folder.calendar);
	oMainFolderTree.cache.get_folder(folder_id_tocheck,function (checkfolder){
		calendar_createNewAppointmentCb(checkfolder);
	});

	function calendar_createNewAppointmentCb(myfolder) {		
		if (myfolder.oxfolder.data.module != "calendar") {
			triggerEvent("OX_New_Error",4,_("Can not create appointment in a folder other than appointment folder"));
			
		} else {
			var wholeDay=wholeday;
			if(!startdate) {
				startdate=new Date();
			}
			// Private folder or shared then add owner to list of participants
			if(myfolder.oxfolder.data.type == 1 || myfolder.oxfolder.data.type == 3) {
				var userId = myfolder.oxfolder.data.created_by;
			} else {
				var userId = configGetKey('identifier');
			}
			if(!wholeDay){
				var windowRef = newWindow("newAppointment.html#modul=new&folder_id="+infolder+"&view="+currentCalendarView+"&start_date="+startdate.getTime()+"&folderOwner="+userId, getWindowOptions());
				if(oFromMail)
				{
					windowRef.sFromModule = oFromMail.module;										
					windowRef.oFromMail = oFromMail.data;
				}				
			} else {
				newWindow("newAppointment.html#modul=new&folder_id="+infolder+"&view="+currentCalendarView+"&start_date="+startdate.getTime()+"&full_time="+wholeDay+"&folderOwner="+userId, getWindowOptions());
			}				
		}
	}
}

var detailAppointmentLoading = false;
	
function reloadAppDetailView(opt_fn, target_folder) {
	
	function cb_reloadAppDetail() {
		detailAppointmentLoading = false;		
		if(currentCalendarTagProgress)
			endProgressCalendarTagging();
		if(opt_fn)
			opt_fn();
	}
	
	if(!detailAppointmentLoading) {
		detailAppointmentLoading = true;	
		
		triggerEvent("OX_Switch_View", "calendar/detail/overview");	
		
		if(selectedAppointment.length && selectedAppointment.length == 1) {
			selectedAppointment = selectedAppointment[0];
		}
		if(selectedAppointment.id)
		{			
			if(target_folder && activefolder != target_folder) {
				var cb_setActiveFolder = function(node) {
					
					triggerEvent("Selected", [selectedAppointment]);
					detailAppointmentOnload(cb_reloadAppDetail);
				}
				selectedAppointment.folder = target_folder;
				setActiveFolder(target_folder,cb_setActiveFolder);
			} else {
				detailAppointmentOnload(cb_reloadAppDetail);
			}
												
		}
	}
}

registerModule("calendar", "Calendar",30); /*i18n*/
registerModuleView("calendar","Calendar",5,{x:0,y:0,ww:1,hw:1});
//TODO
register("OX_New_OXObject",function(mymodule,folder) {
	if(mymodule== "calendar") {
		calendar_createNewAppointment(new Date(Date.UTC(activeYear, activeMonth, activeDay,0,0,0)),folder,false);
	}
});
register("OX_Calendar_Edit", openAppointmentPopup);
register("OX_Calendar_Delete", deleteAppointment);
var currentCalendarRange = "";
var currentCalendarView = "CALENDAR";

	//   1 object_id
	//  20 folder_id
	// 100 categories
	// 101 private flag
	// 200 title
	// 201 start_date
	// 202 end_date
	// 203 description
	// 209 recurrence type 0=none 1=daily 2=weekly 3=monthly 4=yearly
	// 217 notification
	// 220 participents
	// 400 location
	// 401 full_time
	// 402 shown_as	
	// 403 colorlabel
	

fieldsToGet = new Array(1, 20, 207, 206, 2, 200, 201, 202, 203, 220, 401, 402, 209, 400, 101, 102);

function calObj(objFromServer){
	
	var count = 0;
	var startDate;
	this.id = objFromServer[count++];	// objectID			
	this.folderID = objFromServer[count++];	// folderID
	
	for(var q = 2; q < fieldsToGet.length; q++){
		switch (fieldsToGet[q]) {
			case 100:
				this.categories = objFromServer[count++];	// categories
				break;
			case 101:
				this.private_flag = objFromServer[count++];
				break;
			case 102:
				this.color = objFromServer[count++];	// color label
				break;
			case 200:
				this.title = objFromServer[count++];	// title				
				break;
			case 201:
				startDate = new Date(objFromServer[count]);
				this.startDate = new Date(objFromServer[count++]);
				this.start = parseInt(((startDate.getUTCHours() * 60) + startDate.getUTCMinutes())/(60/hoursplit));
				this.starthuman = formatDate(startDate, "time");	// human readable start time
				if((this.starthuman.length - (this.starthuman.lastIndexOf(":"))) < 3)
					this.starthuman = this.starthuman + "0";
				if(this.starthuman.length < 5)
					this.starthuman = "0" + this.starthuman;
				break;
			case 202:
				var endDate = new Date(objFromServer[count]);
				this.endDate = new Date(objFromServer[count++]);
				this.endhuman = formatDate(endDate, "time");	// human readable end time
				var activeDate = (new Date(activeYear, activeMonth, activeDay)).getTime();
				var startDateTmp = (new Date(startDate.getUTCFullYear(), startDate.getUTCMonth(), startDate.getUTCDate())).getTime();
				var endDateTmp = (new Date(endDate.getUTCFullYear(), endDate.getUTCMonth(), endDate.getUTCDate())).getTime();
				if(startDateTmp != endDateTmp){
					if(startDateTmp == activeDate && endDateTmp > activeDate){
						endDate.setUTCMonth(activeMonth);
						endDate.setUTCDate(activeDay);
						endDate.setUTCHours(24);
						endDate.setUTCMinutes(0);
					} else if(startDateTmp < activeDate && endDateTmp > activeDate){
							if(startDate.getUTCDate() != 31){
								startDate.setUTCMonth(activeMonth);
								startDate.setUTCDate(activeDay);
							} else {
								startDate.setUTCDate(activeDay);
								startDate.setUTCMonth(activeMonth);
							}
							startDate.setUTCHours(0);
							startDate.setUTCMinutes(0);
							startDate.setUTCSeconds(0);
							if(endDate.getUTCDate() != 31){					
								endDate.setUTCMonth(activeMonth);
								endDate.setUTCDate(activeDay);
							} else {
								endDate.setUTCDate(activeDay);
								endDate.setUTCMonth(activeMonth);
							}
							endDate.setUTCHours(24);
							endDate.setUTCMinutes(0);
							endDate.setUTCSeconds(0);
							this.start = startDate.getUTCHours() + "." + (parseInt((startDate.getUTCMinutes()/15), 10)*25);	// startdate to calculating
					} else if(startDateTmp < activeDate && endDateTmp == activeDate) {
							if(startDate.getUTCDate() != 31){
								startDate.setUTCMonth(activeMonth);
								startDate.setUTCDate(activeDay);
							} else {
								startDate.setUTCDate(activeDay);
								startDate.setUTCMonth(activeMonth);
							}
							startDate.setUTCHours(0);
							startDate.setUTCMinutes(0);
							this.start = startDate.getUTCHours() + "." + (parseInt((startDate.getUTCMinutes()/15), 10)*25);	// startdate to calculating
					}
				}
				this.start = Number(this.start);
				var minutes = ((endDate.getTime() - startDate.getTime())/60000);
				this.end = minutes/(60/hoursplit); // duration for calculating;
				//TODO calculate the correct length dependent on the hoursplit
				if(this.end > 24*hoursplit)
					this.end = 24*hoursplit-this.start;
				if(this.end == 0)
					this.end += 1;
				if((this.endhuman.length - (this.endhuman.lastIndexOf(":"))) < 3)
					this.endhuman = this.endhuman.substring(0, this.endhuman.indexOf(":")) + ":0" + this.endhuman.substring(this.endhuman.indexOf(":")+1);					
				break;
			case 203:
				this.discription = objFromServer[count++];	// discription
				break;
			case 207:
				this.recurrence_position = objFromServer[count++];
				break;				
			case 209:
				this.recurrence_type = objFromServer[count++];
				break;				
			case 217:
				this.notification = objFromServer[count++];
				break;
			case 220:
				this.participants = objFromServer[count++];
				break;
			case 400:
				this.locat = objFromServer[count++];		// location
				break;
			case 401:
				this.fulltime = objFromServer[count++];	// hole day appointment
				break;	
			case 402:
				this.shown = objFromServer[count++];	// 
				break;
			case 206:
                this.recurrence_id = objFromServer[count++]; 
                break;
            case 2:
                this.created_by = objFromServer[count++];
            default:            
				break;
		}
	}
}	

function displayNameDayView(){
	oMainFolderTree.cache.get_folder(activefolder,displayNameDayViewCb);
}

function calendar_getAllFoldersAttribute() {	
	return configGetKey("gui.calendar.allfolders") && calendar_activeallfolders;
}

function displayNameDayViewCb(oFolder) {
	calendar_activeallfolders = false;
	if (oFolder.oxfolder.data.type == 1 || oFolder.oxfolder.data.type == 3){
        calendar_activeallfolders = oFolder.oxfolder.data.type == 1 ? true : false;
    }	
	if (oFolder.oxfolder.data.created_by) {
		internalCache.getUsers([oFolder.oxfolder.data.created_by], function(cbObj){
			if(oFolder.oxfolder.data.type == 1 || oFolder.oxfolder.data.type == 3) {
				if (oFolder.oxfolder.data.type == 1) {
					$("allAppointmentListViewDiv").style.visibility = "visible";
					$("allAppointmentsWeekViewDiv").style.visibility = "visible";
					$("allAppointmentsWorkWeekViewDiv").style.visibility = "visible";
					$("allAppointmentsMonthViewDiv").style.visibility = "visible";
					calendar_activeallfolders=true;
				} else {
					$("allAppointmentListViewDiv").style.visibility = "hidden";
					$("allAppointmentsWeekViewDiv").style.visibility = "hidden";
					$("allAppointmentsWorkWeekViewDiv").style.visibility = "hidden";
					$("allAppointmentsMonthViewDiv").style.visibility = "hidden";
					calendar_activeallfolders=false;
				}
			} else if (oFolder.oxfolder.data.type == 2) {
				$("allAppointmentListViewDiv").style.visibility = "hidden";
				$("allAppointmentsWeekViewDiv").style.visibility = "hidden";
				$("allAppointmentsWorkWeekViewDiv").style.visibility = "hidden";
				$("allAppointmentsMonthViewDiv").style.visibility = "hidden";
				calendar_activeallfolders=false;
			}
		});
	}
}

function showAllAppointments(){
	if(calendar_getAllFoldersAttribute()){
		$("allAppointmentListView").checked = "";
		configSetKey("gui.calendar.allfolders",false);
		if(currentpath2[1] == "list") {
			initLiveGridCalendar(currentpath2[2]);
		}
	} else {
		$("allAppointmentListView").checked = "checked";
		configSetKey("gui.calendar.allfolders",true);
		if(currentpath2[1] == "list") {
			initLiveGridCalendar(currentpath2[2]);
		} 		
	}
}

function openMailToApp(oDate, oMailObjects, sMod) {
	if (sMod == "contacts") {
		var aIds=new Array();
		for(var indx=0; indx<oMailObjects.length; indx++) {
			aIds.push({id:oMailObjects[indx].id,folder:oMailObjects[indx].folder || oMailObjects[indx].folder_id});
		}
		json.put(AjaxRoot + '/contacts?action=list&session='+session+"&columns="+"1,20,500,555,524,556,557",aIds,null,function (arg){
			calendar_createNewAppointment(oDate,configGetKey("folder.calendar"),false,{module:sMod,data:arg.data});		
		});
	} else if (sMod == "mail") {
		if (oMailObjects.length > 5) {
			oMailObjects = oMailObjects.slice(0,4);
		}
		var collection={};
        collection.objects = oMailObjects;
        collection.columns = OXMailMapping.GETPLAIN;
        OXCache.newRequest(null, "mail", collection, null,
        function (daten) {
            if (daten.objects.length) {
                calendar_createNewAppointment(oDate,configGetKey("folder.calendar"),false,{module:sMod,data:daten.objects});
            }
        });
	} else {
		calendar_createNewAppointment(oDate,configGetKey("folder.calendar"),false,{module:sMod,data:oMailObjects});
	}
}

function openAppointmentPopup(e) {
	triggerEvent("OX_Clear_All_Edit_Lines");	
	var selappoint;

	function edit_whole_series() {
		var app_id = selappoint.recurrence_id || selappoint.id;
		appointmentPopup=newWindow("newAppointment.html#modul=edit&view="+currentCalendarView+"&id="+app_id+"&recurrence_position=0&folder_id="+selappoint.folder, getWindowOptions(), selappoint);
	}
	function edit_single_series() {
		appointmentPopup=newWindow("newAppointment.html#modul=edit&view="+currentCalendarView+"&id="+selappoint.id+"&recurrence_position="+selappoint.recurrence_position+"&folder_id="+selappoint.folder+"&singleappointment=yes", getWindowOptions(), selappoint);
	}
	function edit_single_appointment() {
		appointmentPopup=newWindow("newAppointment.html#modul=edit&view="+currentCalendarView+"&id="+selappoint.id+"&recurrence_position=0&folder_id="+selappoint.folder, getWindowOptions(), selappoint);
	}
	
	if(selectedAppointment.length){
		selappoint=selectedAppointment[0];
	} else {
		selappoint=selectedAppointment;
	}
    if (!menucheckRight("WRITE")) {
        triggerEvent("OX_New_Error", 4,
            _("You do not have write permission for this object."));
    } else if(   selappoint.recurrence_position > 0 && selappoint.recurrence_id
              && selappoint.recurrence_id == selappoint.id)
    {
		newConfirm(_("Edit Appointment"),_("Do you want to edit the whole series or a single series appointment? Please note when changing a serial appointment, exceptions to the series are reset."),AlertPopup.SERIESBUTTON,null,null,null,null,edit_whole_series,edit_single_series);
	} else {
		edit_single_appointment();
	}
	if (e) { stopEvent(e) };
}
function deleteAppointment(){
	var timestamplocal = new Date().getTime()
	if (activemodule == "calendar") {
		if (currentpath2[1] == "list" && calendarGrid.storage.timestamp) {
			timestamplocal = calendarGrid.storage.timestamp;
		} else if (lastUpdateOfCalendarTimestamp) {
			timestamplocal = lastUpdateOfCalendarTimestamp;
		}
	}
	
	todelete=[];
	if(selectedAppointment.length){
		todelete=selectedAppointment;
	} else { 
		todelete[0]=selectedAppointment;
	}
	for(var i = 0; i<todelete.length;i++){
		if(todelete[i].id.toString().indexOf("_")  != -1)
			todelete[i].id = todelete[i].id.substring(0,todelete[i].id.indexOf("_"));
	}
	var isseries=false;
	for(var x=0; x<todelete.length; x++) {
		if (todelete[x].recurrence_position > 0 && todelete[x].recurrence_id != null) {
			isseries=true;
			break;
		}
	}
	
	var fn_afterDelete_Appoitment = function(cb) {
		triggerEvent("OX_Refresh_Mini_Calendar");
		for(var i=0; i<cb.length;i++){
			if(cb[i] && cb[i].error){
				newServerError(cb[i],4);	
			}
		}
		window.setTimeout(function() {
			if(currentpath[0] == "calendar") {
				if(currentpath2[1] == "calendar") {
					window.setTimeout("storageCache.update()", 300);
				} else if(currentpath2[1] == "list") {
					if(currentpath2[2] != "search") {
						storageCache.update();
					} else {
						calendarSearch(lastCalendarSearch.module, lastCalendarSearch.searchstring, null, null, lastCalendarSearch.folder);
					}
				} else if(currentpath2[1] == "detail") {
					triggerEvent("OX_Switch_View",configGetKey("gui.calendar.view"));
				}
			} 
			selectedAppointment={};	
			triggerEvent("Selected",new Array());
		},0);
	}
	
	function delete_single_series() {
		var multipleArray = [];
		for(var i = 0; i < todelete.length; i++){
			multipleArray[i] = {action : "delete", module : "calendar", timestamp : timestamplocal, data : todelete[i]};
		}
		json.put(AjaxRoot + "/multiple?session="+session +"&continue=true", multipleArray, null, fn_afterDelete_Appoitment);	
	}
	function delete_whole_series() {
		var multipleArray = [];
		var deleteobject=new Object();
		var newtodelete=new Array();
		for(var i = 0; i < todelete.length; i++){	
			if(!deleteobject[todelete[i].folder+":"+todelete[i].id]) {
				deleteobject[todelete[i].folder+":"+todelete[i].id]=true;
				newobject=new Object();
				newobject.id=todelete[i].recurrence_id || todelete[i].id;
				newobject.folder=todelete[i].folder;
				newtodelete.push(newobject);
			}
		}
		for (var i=0; i<newtodelete.length; i++) {	
			multipleArray[i] = { action : "delete", module : "calendar", timestamp : timestamplocal, data : newtodelete[i]};
		}
		json.put(AjaxRoot + "/multiple?session="+session +"&continue=true", multipleArray, null, fn_afterDelete_Appoitment);
	}
	if (todelete.length==1) {
		if (isseries) {
			newConfirm(_("Delete Appointment"),_("Do you want to delete the whole series or a single series appointment ?"),AlertPopup.SERIESBUTTON,null,null,null,null,delete_whole_series,delete_single_series);
		} else {
			newConfirm(_("Delete Appointment"),_("Are you sure you want to delete the selected item?"),AlertPopup.YESNO,null,null,delete_whole_series,null,null);
		}
	} else {
		if (isseries) {
			newConfirm(_("Delete Appointment"),_("Do you want to delete the whole series or a single series appointments?"),AlertPopup.SERIESBUTTON,null,null,null,null,delete_whole_series,delete_single_series);
		} else {
			newConfirm(_("Delete Appointment"),_("Are you sure you want to delete the selected items?"),AlertPopup.YESNO,null,null,delete_whole_series,null,null);
		}
		
	}
}
function cancelConflict(){
	$("appointmentConflictWindow").style.display = "none";
	storageCache.update();
}
function ignoreConflict(){
	if(dragObjDayView){
		dragAppointmentDayView.ignore_conflicts = true;
		json.put(AjaxRoot + "/calendar?action=update&session=" + session + "&id=" + dragObjDayView.id + "&timestamp=" + lastUpdateOfCalendarTimestamp + "&folder=" + dragObjDayView.folder, dragAppointmentDayView, null, function(cb){
				if(!cb.error && !cb.data.conflicts){
					storageCache.update();
				}
			});
	}
	dragObjDayView = null;
	$("appointmentConflictWindow").style.display = "none";
}

fileloaded();