/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Ben Pahne <ben.pahne@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

//menuhasRightandLoad([{ folder_id: 6, id: configGetKey("contact_id")}], "WRITE", ct_userdata_Init, function() { return false; });

function plugin_userData_init() {
	var old_user_data;

	// we have to check if parent node configuration/user already exists
	// @todo: This shouldn't be done by using private methods. VP has to add 
	// some function to check for existing nodes!
	var innerNodeFound = false;
	if (ox.Configuration && ox.Configuration.nodes) {
	    for (i in ox.Configuration.nodes) {
	      if (ox.Configuration.nodes[i].id == "configuration/user") {
	        innerNodeFound = true;
	      }
	    }
	}
	 
	// parent node doesn't exists, so we create it
	if (!innerNodeFound)
	   new ox.Configuration.InnerNode("configuration/user", _("User"));
	
	var node2 = new ox.Configuration.LeafNode("configuration/user/personal",_("Personal Data"));
	var page2 = new ox.Configuration.Page(node2, _("Change Personal Contact Information"))
	  
	var intro2 = new ox.UI.Text(_("Modify your account information."));
	page2.addWidget(intro2);
	
	var display_name = new ox.UI.Input(_("Display name *"));
	page2.addWidget(display_name, "display_name");
	  
	var first_name = new ox.UI.Input(_("First name"));
	page2.addWidget(first_name, "first_name");
	
	var second_name = new ox.UI.Input(_("Second name"));
	page2.addWidget(second_name, "second_name");
	
	var last_name = new ox.UI.Input(_("Surname"));
	page2.addWidget(last_name, "last_name");
	
	// var suffix = new ox.UI.Input(_("Suffix"));
	// page2.addWidget(suffix , "suffix");
	
	
	// var title = new ox.UI.Input(_("Title"));
	//  page2.addWidget(title , "title");
	
	var street_home = new ox.UI.Input(_("Street (Home)"));
	page2.addWidget(street_home , "street_home");
	
	var postal_code_home = new ox.UI.Input(_("Postcal Code (Home)"));
	page2.addWidget(postal_code_home , "postal_code_home");
	
	var city_home = new ox.UI.Input(_("City (Home)"));
	page2.addWidget(city_home , "city_home");
	
	var state_home = new ox.UI.Input(_("State (Home)"));
	page2.addWidget(state_home , "state_home");
	
	// var country_home = new ox.UI.Input(_("Country (Home)"));
	// page2.addWidget(country_home , "country_home");
	
	var birthday = new ox.UI.Input(_("Birthday"));
	page2.addWidget(birthday , {
		get:function(data, value) {
			var longTime = parseDateString(value);
			if(longTime == null) {
				data.birthday = null;
			} else {
				data.birthday = longTime.getTime();
			}
		},
		set:function(data){
			return formatDate(new Date(data.birthday), "date");
		}
	});
	
	//  var marital_status = new ox.UI.Input(_("Marital Status"));
	//  page2.addWidget(marital_status , "marital_status");
	
	var company = new ox.UI.Input(_("Company"));
	page2.addWidget(company , "company");
	
	//  var department = new ox.UI.Input(_("Department"));
	//  page2.addWidget(department , "department");
	
	
	//  var position = new ox.UI.Input(_("Position"));
	//  page2.addWidget(position , "position");
	
	var street_business = new ox.UI.Input(_("Street (Business)"));
	page2.addWidget(street_business , "street_business");
	
	var postal_code_business = new ox.UI.Input(_("Postal Code (Business)"));
	page2.addWidget(postal_code_business , "postal_code_business");
	
	var city_business = new ox.UI.Input(_("City (Business)"));
	page2.addWidget(city_business , "city_business");
	
	var state_business = new ox.UI.Input(_("State (Business)"));
	page2.addWidget(state_business , "state_business");
	
	// var country_business = new ox.UI.Input(_("Country (Business)"));
	// page2.addWidget(country_business , "country_business");
	
	var telephone_business1 = new ox.UI.Input(_("Telephone (Business)"));
	page2.addWidget(telephone_business1 , "telephone_business1");
	
	var fax_business = new ox.UI.Input(_("Fax (Business)"));
	page2.addWidget(fax_business , "fax_business");
	 
	// var telephone_company = new ox.UI.Input(_("Telephone (Company)"));
	// page2.addWidget(telephone_company , "telephone_company");
	 
	var telephone_home1 = new ox.UI.Input(_("Telephone (Home)"));
	page2.addWidget(telephone_home1 , "telephone_home1");
	 
	// var fax_home = new ox.UI.Input(_("Fax (Home)"));
	// page2.addWidget(fax_home , "fax_home");
	
	var cellular_telephone1 = new ox.UI.Input(_("Mobile"));
	page2.addWidget(cellular_telephone1 , "cellular_telephone1");
	
	//var mandatory_fields = new ox.UI.Text(_("(Fields marked with a * must be filled)"));
	//page2.addWidget(mandatory_fields);
	 
	var last_mod;
	page2.load = function (cont) {
	    var collection={};
	    collection.columns=null;
	    collection.objects=[OXContactMapping.createKeyFromObject({"module" : "contacts" ,"folder_id" : 6, id : configGetKey("contact_id")})];
	    var getuserdata=OXCache.newRequest(null,"contacts",collection, null, function (data) {
	        if (data.objects[0]){
				old_user_data = clone(data.objects[0]);
	            //var myObject = clone(data.objects[0]);
	            last_mod=data.objects[0].timestamp;
	            cont(data.objects[0]);
	        }
	    }); 
	} 
	  
	page2.save = function (data, cont){
	    ox.JSON.put(AjaxRoot + "/contacts?action=update&session=" + session + "&id="+configGetKey("contact_id")+"&folder="+6+"&timestamp="+last_mod, data, plugin_userData_print_message);
		function plugin_userData_print_message(reply) {
			ox.Configuration.info(_("Your contact information have been saved."));
			last_mod = reply.timestamp || last_mod;
			var cacheData = clone(data);
			cacheData.timestamp = last_mod;
			corewindow.OXContactMapping.editObjects([old_user_data],cacheData);
			cont();
		}
	    
	}
}

if (configGetKey("modules.contacts.module")) plugin_userData_init();