/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * 
 */
var mail_count;
var mailCheck = null;
var quotaInfo;

register("Loaded", function() {
    register("OX_Show_Mail_Panel",resizeInfoBoxContent);
    register("OX_Show_MiniCalendar",resizeInfoBoxContent);
    register("updateAllNewMailNumbers_Created", function() {
        oUnreadCounterStorage.events.register("Default_Count_Changed",setUnreadMessageText);   
    });
    
    // add click on infobox unread message text only once you've logged in
    var mcc = $("container_mailcheck");
    addDOMEvent(mcc,"click", function() {
        activemodule = "mail";
        setActiveFolder(configGetKey("mail.folder.inbox"));
        triggerEvent("OX_Switch_Module", "mail");
    });
    setTimeout(function(){},0);
});

register("OX_Changed_DefaultIMAP_Unread", setUnreadMessageText);
register("LanguageChanged", resizeInfoBoxContent);

function QuotaBar(infoxBoxContentNode) {
    this._infoBoxContentNode = infoxBoxContentNode;
    this._quotaContainer = {};
    this._barNodeTmpl = newnode("div",0,{ className:"quotabar_cont" },
           [ 
             newnode("div",{ flt:"right", position:"relative", margin:"0px 5px" },0,[ document.createTextNode(" ")]),
             newnode("div",{ position:"absolute", overflow:"hidden" },{ className:"quotabar border-color-design" },
                       [
                           newnode("img",{ width:"100%", height:"100%" },{ src:getFullImgSrc("img/quota.png") }),
                           newnode("div",{ left:"1%" },{ className:"percent_quota2"}),
                           newnode("div",0,{ className:"percent_quota2" },
                           [
                               document.createTextNode(" ")
                           ]),
                           newnode("div",0,{ className:"percent_quota_bar" },
                           [                               
                               newnode("div",{ left:"1%" },{ className:"percent_quota1" }),
                               newnode("div",0,{ className:"percent_quota1" },
                               [
                                   document.createTextNode(" ")
                               ])
                           ])
                       ]
                    )            
           ]);
    this._fReqObj = [];
}

QuotaBar.prototype = {
    
    /**
     * init QuotaBar 
     */
    init: function() {
        this.update();
    },
    
    /**
     * registers a new bar
     * @param {String} id - A unique id
     * @param {String} module - The module name
     * @param {Object} i18n - 
     * @param {Object} fieldMap - field name mapping object
     */
    registerBar: function(id, module, i18n, fieldMap) {
        if (!this._quotaContainer[module] || !this._quotaContainer[module].length) {
            this._quotaContainer[module] = [];
            this._fReqObj.push({ module:"quota", action:module});
        }
        var _modInfo = { id: id, i18n: i18n, barNode: this._barNodeTmpl.cloneNode(true), field_map: fieldMap };     
        this._quotaContainer[module].push(_modInfo);
        this._infoBoxContentNode.appendChild(_modInfo.barNode);     
    },
    
    /**
     * unregister a bar with the given id
     * @param {String} id - The ID of the bar
     */
    unregisterBar: function(id) {
        for (var i in this._quotaContainer) {
            for (var ia in this._quotaContainer[i]) {
                if (this._quotaContainer[i][ia].id == id) {
                    this._infoBoxContentNode.removeChild(this._quotaContainer[i][ia].barNode);
                    delete(this._quotaContainer[i][ia]);
                    this._fReqObj = [];
                    for (var ia in this._quotaContainer) {
                        this._fReqObj.push({ module:"quota", action:ia});                   
                    }
                }
            }
        }
    },
    
    /**
     * updates each registered bar. if field count is -1 or -1024 for any registered
     * bar it will be unregistered.
     * @see HTTP API, section Quota
     */
    update: function() {
        if (!this._fReqObj.length) {
            return;
        }
        var Self = this;
        new JSON().put(AjaxRoot + '/multiple?session='+session,
              Self._fReqObj,
              null,
              function(data) {
                   if (!data.length || data.length != Self._fReqObj.length) {
                       return; // todo: handle no data or empty response
                   }
                   for (var i=0; i < data.length; i++) {      
                       for (ia in Self._quotaContainer[Self._fReqObj[i].action]) {                       	   
                           var tBar = Self._quotaContainer[Self._fReqObj[i].action][ia];
                           var tQuota = data[i].data[tBar.field_map.quota];
                           var tUsage = data[i].data[tBar.field_map.usage];
                           if (!data[i].data || tQuota == undefined || tQuota == -1024 || tQuota == -1) {
                               Self.unregisterBar(tBar.id);
                               continue;
                           }
                           Self.drawBar(tBar, tQuota, tUsage);
                       }
                   }
                   resizeInfoBoxContent();
              });
    },
    
    /**
     * draws each bar
     * @private
     */
    drawBar: function(barObj, quota, usage) {
        var percent = (usage / quota) * 100;
        percent = Math.round(percent * 100) / 100;
        if (percent > 100) percent = 100; //round problems -> 100,01% to 100%
        barObj.barNode.getElementsByTagName("DIV")[0].firstChild.data=format(barObj.i18n.total[0], barObj.i18n.total[1](quota), barObj.i18n.total[1](usage));
        if (!barObj.barNode.getElementsByTagName("DIV")[2].firstChild) {
            barObj.barNode.getElementsByTagName("DIV")[2].appendChild(addTranslated(barObj.i18n.title));
            barObj.barNode.getElementsByTagName("DIV")[5].appendChild(addTranslated(barObj.i18n.title));
        }        
        barObj.barNode.getElementsByTagName("DIV")[4].style.left = percent+"%";        
        barObj.barNode.getElementsByTagName("DIV")[6].firstChild.data = percent+"%";
        var qs = (45-percent);
        var qa = qs-44 >= 0 && qs-44 <= 1 ? 1 : qs-44;
        barObj.barNode.getElementsByTagName("DIV")[5].style.left=qa+"%";
        barObj.barNode.getElementsByTagName("DIV")[6].style.left=qs+"%";
        barObj.barNode.getElementsByTagName("DIV")[3].firstChild.data = percent+"%";
    }
}

register("OX_Configuration_Loaded", function() {
    quotaInfo = new QuotaBar($("infobox_body"));  
    if (configGetKey("modules.mail.module")) {
        quotaInfo.registerBar("mail_storage", "mail", 
              { title: "E-Mail:", 
                total: [ "%1$s", bytesToString ]
              }, 
              { usage:"use", quota:"quota" });
        quotaInfo.registerBar("mail_count", "mail", 
              { title: "E-Mail:", 
                total: [ "%1$s", function(val) { return val; } ]
              }, { usage:"countuse", quota:"countquota" });
    }
    if (configGetKey("modules.infostore.module")) {
        quotaInfo.registerBar("filestore", "filestore", 
              { title: "File:", 
                total: [ "%1$s", bytesToString ]
              }, { usage:"use", quota:"quota" });
    }
    quotaInfo.init();
    register("OX_Refresh", function() {
        quotaInfo.update(); 
    });
});

function setUnreadMessageText(sFolderId,mail_count_PARAM) {
    var mcc = $("container_mailcheck");
    if (mcc == null) {
    	return;
    } else if (configGetKey("mail.folder.inbox") == null) {
    	// looks like the module mail is disabled or broken
    	mcc.style.height="0em";
    	return;
    }

    mail_count = mail_count_PARAM;
    if (!mailCheck || true) {
        removeChildNodes(mcc);
        if(0 <= mail_count ) {
            mailCheck = new I18nNode(function() {
                if (0 == mail_count)
                    return _("No unread E-Mail.");
                else
                    return format(ngettext("You have %s unread E-Mail.",
                               "You have %s unread E-Mails.",mail_count),
                               mail_count);
            });
            mcc.appendChild(mailCheck.node);
        }
    } else {
        mailCheck.update();                     
    }
    resizeInfoBoxContent();
}

/*
 * this storage contains information about unread messages in the default inbox
 * and all visible imap folders
 */
function unreadCounterStorage() {
    this.count_hashmap = new Object();
    this.events = new Events();
}

unreadCounterStorage.prototype = {
    register : function (folderId) {
        if(this.count_hashmap[folderId] == undefined)
            this.count_hashmap[folderId] = -1;
    },
    unregister : function (folderId) {
        //do not unregister the default folder
        if(configGetKey("mail.folder.inbox") != folderId)
            delete this.count_hashmap[folderId];
    },
    /*
     * register visible folders and add default imap folder
     */
    register_visible : function () {
        var aVisFoldersArr = oMainFolderTree.getVisibleImapFolders();
        for(var indx=0;indx < aVisFoldersArr.length;indx++)
        {
            this.register(aVisFoldersArr[indx]);
        }
        //fix server bug here: do not send request if imap server unreachable       
        if (configGetKey("mail.folder.inbox") != null) {
            this.register(configGetKey("mail.folder.inbox"));
        } else if ($("container_mailcheck")) {
        	$("container_mailcheck").style.height="0em";
        }       
    },
    update : function () {
        var Self = this;
        this.register_visible();
        this.count_hashmap;
        //do it all with multiple request - collect multiple request here
        var aRequests = new Array();
        for(var sKey in this.count_hashmap)
        {
            var oRequestObj = new Object();     
            oRequestObj["module"] = "folder";
            oRequestObj["action"] = "get";
            oRequestObj['id'] = sKey;
            oRequestObj['folder'] = sKey;       
            oRequestObj['columns'] = "1,311";       
            aRequests.push(oRequestObj);
        }
        function cb_mult_num(arg) { 
            //var oResults = new Object();  
            for(var indx=0;indx<arg.length;indx++)
            {
                if(arg[indx] && arg[indx].data)
                    Self.set(arg[indx].data['id'],arg[indx].data['unread']);
            }
        }   
        var multJson = new JSON();  
        var sAjaxRequest = AjaxRoot + '/multiple?session='+session;

        multJson.put(sAjaxRequest,aRequests,null,cb_mult_num);      
    },
    set : function (folderId,value) {
            this.count_hashmap[folderId] = value;
            this.events.trigger("Count_Changed",folderId,value);
            
            if(configGetKey("mail.folder.inbox") == folderId)
            {
                this.events.trigger("Default_Count_Changed",folderId,value);
            }   
    }
}

var infoBoxBelowFolders=-1;
function resizeInfoBoxContent() {
    var size = 0;
    
    if ((menu_showmini || menu_showmail) && $("bottom_dragpoint").offsetHeight == 0) {
        $("bottom_dragpoint").className="bg_horizontal border-background-default";        
        $("bottom_dragpoint").style.height="7px";
        $("bottom_dragpoint").style.borderBottomWidth="5px";
        $("bottom_dragpoint").style.borderBottomStyle="solid";
        $("sidesplit").style.bottom="5px";
        resizeSplit("bottom_dragpoint","7px");
        
    } else if (!menu_showmini && !menu_showmail && $("bottom_dragpoint").offsetHeight != 0) {
        $("bottom_dragpoint").className="bg_dummy border-background-default";
        $("bottom_dragpoint").style.height="0px";
        $("bottom_dragpoint").style.borderBottomWidth="0px";
        $("bottom_dragpoint").style.borderBottomStyle="none";
        $("sidesplit").style.bottom="5px";
        resizeSplit("bottom_dragpoint","0em");
    }
    
    // enable / disable mini calendar only if really changed!
    if (menu_showmini) {
        size += 16;
        if ($("calendarMini").offsetHeight == 0) {
            showNode("calendarMini");
            resizeSplit("calendarMini","16em"); 
        }
        
    } else if (!menu_showmini && $("calendarMini").offsetHeight != 0) {     
        showNode("mailCheck");
        resizeSplit("calendarMini","0em");        
        hideNode("calendarMini");
    }
    
    if (menu_showmail) {
        var tsize = 0;
        if ($("mailCheck").offsetHeight == 0) {
            showNode("mailCheck");
        }
        if (menu_showmini) {
        	resizeSplit("calendarMini","16em");
        	$("mailCheck").style.top="6px";
        	tsize=6;
        }        
                
        tsize+=$("infobox_header").offsetHeight;
        tsize+=$("infobox_body").offsetHeight;
        tsize+=$("infobox_bottom").offsetHeight;
        size+=(tsize)/pxPerEm;
        
    } else if (!menu_showmail && $("mailCheck").offsetHeight != 0) {
        hideNode("mailCheck");
    }
    
    if (infoBoxBelowFolders != size) {
        resizeSplit("below_folders", size+"em");
        infoBoxBelowFolders = size;
    }
}

fileloaded();