/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;

public abstract class ADBHelperDataSource
implements OMDataSourceExt {
    protected QName parentQName;
    protected Object bean;
    protected String helperClassName;
    HashMap map = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected ADBHelperDataSource(Object bean, QName parentQName, String helperClassName) {
        this.bean = bean;
        this.parentQName = parentQName;
        this.helperClassName = helperClassName;
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((OutputStream)output);
        this.serialize(xmlStreamWriter);
        xmlStreamWriter.flush();
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        this.serialize(xmlStreamWriter);
        xmlStreamWriter.flush();
    }

    public abstract void serialize(XMLStreamWriter var1) throws XMLStreamException;

    public XMLStreamReader getReader() throws XMLStreamException {
        try {
            Class<?> helperClass = Class.forName(this.helperClassName);
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("javax.xml.namespace.QName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Method method = helperClass.getMethod("getPullParser", classArray);
            return (XMLStreamReader)method.invoke(null, this.bean, this.parentQName);
        }
        catch (ClassNotFoundException e) {
            throw new XMLStreamException(e);
        }
        catch (NoSuchMethodException e) {
            throw new XMLStreamException(e);
        }
        catch (IllegalAccessException e) {
            throw new XMLStreamException(e);
        }
        catch (InvocationTargetException e) {
            throw new XMLStreamException(e);
        }
    }

    public Object getObject() {
        return this.bean;
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.getXMLBytes(encoding));
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat format = new OMOutputFormat();
        format.setCharSetEncoding(encoding);
        try {
            this.serialize(baos, format);
        }
        catch (XMLStreamException e) {
            new OMException((Throwable)e);
        }
        return baos.toByteArray();
    }

    public void close() {
        this.parentQName = null;
        this.bean = null;
    }

    public OMDataSourceExt copy() {
        return null;
    }

    public Object getProperty(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public Object setProperty(String key, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.put(key, value);
    }

    public boolean hasProperty(String key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }
}

