/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2006 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.impl.AbstractMailFuncs;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mailaccount.MailAccountException;
import com.openexchange.mailaccount.UnifiedINBOXManagement;
import com.openexchange.server.ServiceException;
import com.openexchange.server.services.ServerServiceRegistry;

/**
 * {@link UnifiedINBOXEnablement}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public class UnifiedINBOXEnablement implements PreferencesItemService {

    private static final org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory.getLog(UnifiedINBOXEnablement.class);

    /**
     * Default constructor.
     */
    public UnifiedINBOXEnablement() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    public String[] getPath() {
        return new String[] { "modules", "mail", "unifiedinbox" };
    }

    /**
     * {@inheritDoc}
     */
    public IValueHandler getSharedValue() {
        return new AbstractMailFuncs() {

            public boolean isAvailable(final UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            protected Boolean isSet(final UserSettingMail settings) {
                final UnifiedINBOXManagement management;
                try {
                    management = ServerServiceRegistry.getInstance().getService(UnifiedINBOXManagement.class, true);
                } catch (final ServiceException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(e.getMessage(), e);
                    }
                    return Boolean.FALSE;
                }
                try {
                    return Boolean.valueOf(management.getUnifiedINBOXAccountID(settings.getUserId(), settings.getCid()) >= 0);
                } catch (final MailAccountException e) {
                    LOG.error(e.getMessage(), e);
                    return Boolean.FALSE;
                }
            }

            @Override
            protected void setValue(final UserSettingMail settings, final String value) {
                final boolean enable = Boolean.parseBoolean(value);
                final UnifiedINBOXManagement management;
                try {
                    management = ServerServiceRegistry.getInstance().getService(UnifiedINBOXManagement.class, true);
                } catch (final ServiceException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(
                            new StringBuilder().append(enable ? "Enabling" : "Disabling").append(" of Unified INBOX for user ").append(
                                settings.getUserId()).append(" in context ").append(settings.getCid()).append(" aborted: ").append(
                                e.getMessage()),
                            e);
                    }
                    return;
                }
                try {
                    final int userId = settings.getUserId();
                    final int cid = settings.getCid();
                    if (enable) {
                        if (management.getUnifiedINBOXAccountID(userId, cid) < 0) {
                            management.createUnifiedINBOX(userId, cid);
                        }
                    } else {
                        management.deleteUnifiedINBOX(userId, cid);
                    }
                } catch (final MailAccountException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        };
    }

}
