var tab = new temporary.VTab(newnode("span", 0, 0, [
    addTranslated(_("Subscriptions")),
    newnode("span", { background: "orange", marginLeft: "5px", padding: "2px",
                      MozBorderRadius: "2px", WebkitBorderRadius: "2px",
                      color:"white" }, 0, [document.createTextNode(_("Beta"))])
]), 0.2);
temporary.folderTabs.addTab(tab);

var widgets = {
    input: function(def) { return new ox.UI.Input(def.displayName); },
    password: function(def) { return new ox.UI.Password(def.displayName); },
    checkbox: function(def) { return new ox.UI.CheckBox(def.displayName); },
    text: function(def) { return new ox.UI.Text(def.displayName); },
    link: function(def) {
        var link = new ox.UI.Widget();
        link.default_value = "";
        link.addContent = function() {
            this.anchor = newnode("a", 0,
                { href: this.default_value, target: "_blank" },
                [document.createTextNode(this.default_value)]);
            this.node = this.parent.addCells(noI18n(def.displayName),
                                             this.anchor);
            ox.UI.Widget.prototype.addContent.apply(this, arguments);
        };
        link.set = function(value) {
            this.anchor.href = value;
            this.anchor.firstChild.data = value;
        };
        link.get = function() { return this.anchor.firstChild.data; };
        return link;
    }
};

tab.init = function() {
    var sources, modules, onInit;
    
    var old_enter = temporary.folderTabs.enter;
    temporary.folderTabs.enter = function() {
        tab.setVisible(Boolean(modules && this.folder.module in modules &&
                               this.folder.own_rights & (127 << 14)));
        old_enter.call(this);
        if (sources) initSelect(); else onInit = initSelect;
    };
    
    ox.JSON.get(AjaxRoot + "/subscriptionSources/?action=all"
        + "&columns=id,displayName,icon,module,formDescription&session="
        + session, function(reply) {
            sources = {};
            modules = {};
            for (var i in reply.data) {
                var s = reply.data[i];
                var source = { id: s[0], displayName: s[1], icon: s[2],
                               module: s[3], formDescription: s[4] };
                sources[source.id] = source;
                var module = modules[source.module];
                if (!module) {
                    module = modules[source.module] = {};
                    if (temporary.folderTabs.folder.module == source.module)
                        tab.setVisible(true);
                }
                module[source.id] = source;
            }
            if (onInit) onInit();
        });

    // Left panel
    
    var selection = new Selection();
    var grid = new LiveGrid([{
        text: _("Name"),
        index: 1,
        clear: LiveGrid.makeClear(""),
        set: LiveGrid.defaultSet
    }], selection);
    grid.emptylivegridtext = _("No subscriptions configured");
    tab.list = grid;
    
    var storage = new Storage(0, []);

    tab.enableList = function() {
        ox.JSON.get(AjaxRoot +
            "/subscriptions?action=all&columns=id,displayName&folder=" +
            this.parent.folder.id + "&entityModule=" +
            this.parent.folder.module + "&session=" + session,
            function(reply) {
                storage.remove(0, storage.ids.length);
                storage.append(reply.data);
                grid.enable(storage);
            });
    };
    
    function load(id, cont) {
        ox.JSON.get(AjaxRoot + "/subscriptions?action=get&id=" + id +
            "&session=" + session, function(reply) { cont(reply.data); });
    }

    tab.load = function(cont) { load(selection.getSelected()[0], cont); };
    
    tab.save = function(data, cont) {
        if ("id" in data) {
            ox.JSON.put(AjaxRoot + "/subscriptions/?action=update&session=" +
                session, data, function(reply) {
                    load(data.id, function(data) {
                        storage.localUpdate([data.id], function(old) {
                            return [data.id, data.displayName];
                        });
                        cont(data);
                    });
                });
        } else {
            ox.JSON.put(AjaxRoot + "/subscriptions/?action=new&session=" +
                session, data, function(reply) {
                    load(reply.data, function(data) {
                        storage.append([[data.id, data.displayName]]);
                        cont(data);
                    });
                });
        }
    };
    
    menuarrows[tab.viewID] = {};

    var menu = MenuNodes.createSmallButtonContext("subscribe.subscriptions",
        _("Subscriptions"));
    MenuNodes.createSmallButton(menu, "subscribe.subscriptions.add", _("Add"),
        getFullImgSrc("img/menu/add_category.gif"),
        getFullImgSrc("img/menu/add_category_d.gif"),
        function() { tab.addNew({}); });
    MenuNodes.createSmallButton(menu, "subscribe.subscriptions.remove", _("Remove"),
        getFullImgSrc("img/menu/remove_category.gif"),
        getFullImgSrc("img/menu/remove_category_d.gif"), confirmDelete);
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(tab.viewID, "subscribe.subscriptions");

    var menu2 = MenuNodes.createSmallButtonContext("subscribe.refresh",
        _("Refresh"));
    MenuNodes.createSmallButton(menu2, "subscribe.refresh.refresh", _("Refresh"),
        getFullImgSrc("img/toolbar/tb_loading.gif"),
        getFullImgSrc("img/toolbar/tb_loading.gif"),
        function() {
            var img = $("subscribe.refresh.refresh").getElementsByTagName("img")[0];
            img.src = getFullImgSrc("img/toolbar/ox_animated.gif");
            ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="
                + entry.id + "&folder=" + tab.parent.folder.id + "&session="
                + session, stopAnim, stopAnim);
            function stopAnim() {
                img.src = getFullImgSrc("img/toolbar/tb_loading.gif");
            }
        });
    addMenuNode(menu2.node, MenuNodes.FIXED, 32);
    changeDisplay(tab.viewID, "subscribe.refresh");
    
    menuarrows[tab.viewID] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[tab.viewID]["subscribe.subscriptions"] = [];
        menu_display_contents(tab.viewID, "subscribe.subscriptions", true,
            "subscribe.subscriptions.add");
        menu_display_contents(tab.viewID, "subscribe.subscriptions", deleteenabled,
            "subscribe.subscriptions.remove");
    });

    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Subscription", "Delete Subscriptions",
                            selection.count)(),
            ngettext(
                "Are you sure you want to delete the selected subscription?",
                "Are you sure you want to delete the selected subscriptions?",
                selection.count)(),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        var ids = selection.getSelected();
        ox.JSON.put(AjaxRoot + "/subscriptions?action=delete&session=" + session,
            ids, function(reply) { storage.removeIDs(ids); });
    }

    // Right panel
    
    var select = new ox.UI.ComboBox(_("Source"));
    select.changed = function() { entry.updateSelect(); };
    if (sources) initSelect(); else onInit = initSelect;
    function initSelect() {
        var module = tab.parent.folder.module;
        var ids = [], names = [];
        for (var i in sources) {
            var m = sources[i].module;
            if (m == module) {
                ids.push(i);
                names.push(sources[i].displayName);
            }
        }
        select.setEntries(ids, names);
        onInit = undefined;
    }
    
    var entry = new ox.UI.Container();
    entry.addContent = function(node_id) {
        this.childWidth = this.parent.childWidth;
        this.table = newnode("div");
        this.node = this.parent.addRow(this.table);
        ox.UI.Container.prototype.addContent.apply(this, arguments);
    };
    entry.addRow = ox.Configuration.VSplit.prototype.addRow;
    entry.addCells = ox.Configuration.VSplit.prototype.addCells;
    entry.addWidget(select);
    
    entry.updateSelect = function() {
        for (var i = this.children.length - 1; i > 0; i--) {
            this.deleteWidget(entry.children[i]);
        }
        var id = select.get();
        if (id && (id in sources)) {
            var defs = sources[id].formDescription;
            for (var i = 0; i < defs.length; i++) {
                var def = defs[i];
                var widget = widgets[def.widget](def);
                if ("defaultValue" in def)
                    widget.default_value = def.defaultValue;
                this.addWidget(widget, def.name);
            }
        }
    };
    var defaultSet = entry.set;
    entry.set = function(value) {
        // TODO: automatic refresh the first time?
        this.id = value.id;
        menuglobalzaehler = 0;
        menuarrows[tab.viewID]["subscribe.refresh"] = [];
        menu_display_contents(tab.viewID, "subscribe.refresh", value.id,
            "subscribe.refresh.refresh");
        select.set(value.source);
        this.updateSelect();
        defaultSet.call(this, value[value.source]);
    };
    var defaultGet = entry.get;
    entry.get = function() {
        var id = select.get();
        if (!id) return;
        var value = {
            source: id,
            folder: tab.parent.folder.id,
            entityModule: tab.parent.folder.module,
            entity: { folder: tab.parent.folder.id }
        };
        value[value.source] = defaultGet.call(this);
        if (this.id) value.id = this.id;
        return value;
    };
    tab.addWidget(entry, ox.Configuration.Group.NoField);
    var subscriptiondur = new ox.UI.Text("");
    subscriptiondur.addContent = function() {
    	this.text = newnode("div",{lineHeight:"1.2em",marginTop:"1.5em"});
    	this.text.innerHTML = _("<b>Approximate Duration for Subscriptions</b><br/><br/>Subscribing to contacts that are not delivered by another Open-Xchange Server (i.e. OXMF) may take some time. <br/>Importing 100 contacs from Xing takes about 5 minutes for example.<br/><br/>We are continually improving this functionality. Future releases (without the beta tag) will work significantly faster.");
        this.node = this.parent.addRow(this.text,true);
        ox.UI.Widget.prototype.addContent.apply(this, arguments);
    };
    tab.addWidget(subscriptiondur);
};