/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Dirk Hartmann <dirk.hartmann@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

/*
 * TODO captain:
 *  - Usage of tmpDetailRequest may needs to be optimized, aka grid.selection vs. cache new/modified callbacks
 *    right now we use the grid selection event to get new objects, we should change that so we get them by object cache
 *    this also would give us the advantage to be informed when the selected object changed
 */

registerModule("tasks", "Tasks",50); /*i18n*/
registerModuleView("tasks", "Tasks",5,{x:1,y:1,ww:1,hw:1});
registerPrintView("tasks/list");
registerPrintView("tasks/split");
registerPrintView("tasks/split/overview");
var json = new JSON(); // argh, very bad making such vars public!
var completedetailtask;
var activeTaskId = new Array();
var tasksTabsList;
var tasksPanelsList;
var tasksEventList;
var attachmentWindow = 0;
var taskTmpStorage;
var latestRenderedTask = null;
var objTaskDetailParticipants = null;
var refTaskDetailParticipantTab = null;
var taskParticipantsGrid = null;
var taskParticipantsGrid2 = false;
var tasksFolderPath;

var tasksSelection = new Selection();
var tasksSelection2= new Selection2();
var tmpDetailRequest;
(
function() {
    function fn_add_Tag_tasks(tag){
        if (activemodule == "tasks") {
            var selected=tasksSelection2.getSelected();
            if (currentpath[1] == "detail" && completedetailtask) {
                selected[0]["timestamp"] = completedetailtask.timestamp || 0;
            }
            OXTaskMapping.setTag(tag,selected);
        }
    }
    register("Loaded",init_Tasks);
    
    register("OX_Tasks_Switch_Split_Detail",function(param) { 
    	menuswitchTaskDetail(param) 
    });
    
    function init_Tasks() {
    	tasksFolderPath = new FolderPath("tasks");
    	tasksTabsList = new Array('tasktab1','tasktab2', 
    	       'tasktab4');
        tasksPanelsList = new Array('taskpanel1','taskpanel2',
               'taskpanel4');
        tasksEventList = new Array(
                ['OX_Tasks_Switch_Split_Detail','overview'],
                ['OX_Tasks_Switch_Split_Detail','participant'],
                /* ['OX_Tasks_Switch_Split_Detail','history'], */                
                ['OX_Tasks_Switch_Split_Detail','attachment']
        );        
    }
    registerView("tasks",
    		null,
    		null,
            function() {
                if (tmpDetailRequest) {
                    OXCache.unregister(tmpDetailRequest.uniqueName);
                    delete(tmpDetailRequest);
                }
            },
            function () { 
                menuclearSearch();
                triggerEvent("Selected",[]);
            }
    );
    
    registerView("tasks/search",
         function() { 
            showNode("taskslist");  
            $("taskslist").style.display=""; 
         }, 
         function() {
            register("OX_New_Search", taskSearch);
            register("OX_Delete_Search", taskSearchDelete);
         }, 
         function() {
            if (gridlist.collection) gridlist.disable();
            unregister("OX_New_Search", taskSearch);
         },
		 function() { 
		    hideNode("taskslist");  
		    $("taskslist").style.display="none";
            unregister("OX_Delete_Search", taskSearchDelete);
            unregister("OX_New_Search", taskSearch);
         },
		 null
    );
    
    registerView("tasks/list",
        function() {
            showNode("taskslist");  
            $("taskslist").style.display=""; 
        }, 
        function() {    	 	
            var criteria= { "folder_id" : activefolder };
            gridlist.disablehover=!configGetKey("gui.effects.hover.tasks");
            gridlist.enable(criteria);            
            tasksFolderPath.drawDOMNode("taskoflistview", activefolder);
            tasks_setFocus(gridlist);
            register("OX_Print",printTasks);
            register("OX_New_Search", taskSearch);
            register("OX_Add_Flag", fn_add_Tag_tasks);
            register("OX_Delete_Search", taskSearchDelete);
            register("OX_Task_MarkAsDone", tasks_markAsDone);
         }, 
         function() {
         	tasksFolderPath.clear();
            if (gridlist) gridlist.disable();
            unregister("OX_Add_Flag", fn_add_Tag_tasks);    
            unregister("OX_New_Search", taskSearch);
            unregister("OX_Print",printTasks);     
            unregister("OX_Delete_Search", taskSearchDelete);
            unregister("OX_Task_MarkAsDone", tasks_markAsDone);
            latestRenderedTask=null;
         },
         function() { 
            hideNode("taskslist");  
            $("taskslist").style.display="none";
         },
         function(changeFolder) { 
        	if (changeFolder != undefined) {
	            var criteria = { "folder_id" : activefolder };
	            gridlist.disablehover=!configGetKey("gui.effects.hover.tasks");
	            gridlist.enable(criteria);	            
	            tasksFolderPath.drawDOMNode("taskoflistview", activefolder);
	            tasks_setFocus(gridlist);
        	}
         }
    );
	
    registerView("tasks/split",
            function() {
                showNode("taskssplit");  
                $("taskssplit").style.display="";
            }, 
            function() {
                setTabLists(tasksTabsList, tasksPanelsList, tasksEventList);
                var criteria= { "folder_id" : activefolder };
                gridsplit.disablehover=!configGetKey("gui.effects.hover.tasks");
                gridsplit.enable(criteria);                
                // reselect id if it's a direct link for example
                if (activeTaskId.length && activeTaskId[0].directLink && activeTaskId[0].id) {
                	delete(activeTaskId[0].directLink);
                    gridsplit.selection.selectIDs([ Key.createfromObject(activeTaskId[0]) ]);
                }
                tasksFolderPath.drawDOMNode("taskofsplitview", activefolder);
                expandTaskSplitHeader(configGetKey("gui.tasks.fullsplitheader"));
                
                register("OX_Print",printTasks);
                register("OX_Confirmation_Change", taskdetail_change_Confirm);
                //register("OX_AcceptDeny_Changed", cb_object_changed);  
                register("OX_New_Search", taskSearch);        
                register("OX_Add_Flag", fn_add_Tag_tasks);
                register("OX_Delete_Search", taskSearchDelete);
                register("OX_Task_MarkAsDone", tasks_markAsDone);
                // update confirm button
                triggerEvent("Confirmation_Changed", 0);
             }, 
             function() {
             	tasksFolderPath.clear();          
                if (gridsplit) gridsplit.disable();
                gridsplitTask = false;
                if (tmpDetailRequest) {
                    OXCache.unregister(tmpDetailRequest.uniqueName);
                    delete(tmpDetailRequest);
                }
                unregister("OX_Print",printTasks);
                unregister("OX_Confirmation_Change", taskdetail_change_Confirm);
                //unregister("OX_AcceptDeny_Changed", cb_object_changed);
                unregister("OX_New_Search", taskSearch);                
                unregister("OX_Add_Flag", fn_add_Tag_tasks);
                unregister("OX_Delete_Search", taskSearchDelete);
                unregister("OX_Task_MarkAsDone", tasks_markAsDone);
             },
             function() { 
                hideNode("taskssplit");  
                $("taskssplit").style.display="none";
             },
             function(changeFolder) {
				if (changeFolder != undefined) {
				    var criteria= { "folder_id" : activefolder };
					gridsplit.disablehover=!configGetKey("gui.effects.hover.tasks");
					gridsplit.enable(criteria,false);
					tasksFolderPath.drawDOMNode("taskofsplitview", activefolder);
					tasks_setFocus(gridlist);
					// update confirm button
					triggerEvent("Confirmation_Changed", 0);
				}
             }
    );
    
    registerView("tasks/split/overview",
            function() {
                $("tasktab1").style.display="block";
                $("taskpanel1").className="tabbing_tab_active";
            },
            null,
            null,
            function() {
                $("tasktab1").style.display="none";
                $("taskpanel1").className="tabbing_tab_inactive";
            }
    );
    
    registerView("tasks/split/participant",
            function() {
                $("tasktab2").style.display="block";
                $("taskpanel2").className="tabbing_tab_active";      
            }, 
            function() {
                refTaskDetailParticipantTab.enableGrid();
             }, 
            function() {
                refTaskDetailParticipantTab.disableGrid();
            },
            function() {
                $("tasktab2").style.display="none";
                $("taskpanel2").className="tabbing_tab_inactive";
            }
    );
    
    registerView("tasks/split/attachment",
            function() {
                $("tasktab4").style.display="block";
                $("taskpanel4").className="tabbing_tab_active";      
            }, 
            function() {
                if(!bAttachmentGridCreatedTask) {
                    createAttachmentGridTask();
                    bAttachmentGridCreatedTask = true;
                } else {        
                    oAttachmentGridTask.enableGrid();
                }
                oAttachmentGridTask.getAttachments(activeTaskId[0].id,activeTaskId[0].folder_id);                   
            },
            function() {
                if (bAttachmentGridCreatedTask)              
                    oAttachmentGridTask.disableGrid();
            },
            function() {
                $("tasktab4").style.display="none";
                $("taskpanel4").className="tabbing_tab_inactive";        
            }
    );

    function taskdetail_change_Confirm() {
        var taskconfirm=new AcceptDeny(true);
        taskconfirm.showConfirmation(new AcceptDenyObject("tasks", completedetailtask));
    }
    
    function cb_selection_changed() {
    	// get current task to prevent double selection (-> double rendering)
        var currentTask = activeTaskId.length > 0 ? activeTaskId[0].id : null;
        if (currentTask == latestRenderedTask) return;
       	// remember current task
        latestRenderedTask = currentTask;
        // now process selection
    	if (!tasksSelection2.getSelected().length) return;
    	tasks_setFocus(gridsplit)         
        fn_tasks_getDetails(tasksSelection2.getSelected());        
    }
    
    function tasks_setFocus(grid) {
    	if (grid && grid.collection && tasksSelection2.getSelected().length) {
            var index = grid.collection.getIndex(tasksSelection2.getSelected()[0]);
            grid.focus = index ? index-1 : 0;
            grid.showFocus();
        }
    }
    
    function cb_object_changed() {
        fn_tasks_getDetails(tasksSelection2.getSelected(), true);
    }
    
    function switchToTaskStdView() {
        triggerEvent("OX_Switch_View", configGetKey("gui.tasks.view"));
    }
    
    function switchToTaskSplitView() {
        triggerEvent("OX_Switch_View", "tasks/split");
    }
    function switchToTaskListView() {
        triggerEvent("OX_Switch_View", "tasks/list");
    }
    
    function taskSearch(module, pattern) {
        if (module != "tasks") { return ; }
        var criteria= { "folder_id" : activefolder };
        var search= { "note" : "*"+pattern+"*" , "title" : "*"+pattern+"*", "categories" : "*"+pattern+"*" }
        if (currentpath2[1] == "split") {
          gridsplit.disablehover=!configGetKey("gui.effects.hover.tasks");
          gridsplit.enable(criteria,search,false);
                
        } else if(currentpath2[1] == "list") {
          gridlist.disablehover=!configGetKey("gui.effects.hover.tasks");              
          gridlist.enable(criteria,search,false);
        }
        tasksFolderPath.drawSearch(module, pattern);     
    }
    
    function taskSearchDelete() {
        if (activemodule != "tasks") { return; }
        var criteria= { "folder_id" : activefolder };
        if (currentpath2[1] == "split") {
        	gridsplit.searchActive=false;
        	gridsplit.disablehover=!configGetKey("gui.effects.hover.tasks");
        	gridsplit.enable(criteria);
        	tasksFolderPath.drawDOMNode("taskofsplitview", activefolder);
                
        } else if(currentpath2[1] == "list") {
        	gridlist.searchActive=false;
        	gridlist.disablehover=!configGetKey("gui.effects.hover.tasks");              
        	gridlist.enable(criteria);
        	tasksFolderPath.drawDOMNode("taskoflistview", activefolder);
        }     
    }
    
    var gridlist, gridsplit, gridatt;
    var tmp_participant = null;
    var id = new Array();
    var clear = LiveGrid.makeClear("");
    var portalCall = false;
    
    var bAttachmentGridCreatedTask;
    var oAttachmentGridTask;
    
    function createAttachmentGridTask() {
        //set id and fid for attachments here
        var nId = activeTaskId[0].id;
        var nFolder = activeTaskId[0].folder || activeTaskId[0].folder_id;
        oAttachmentGridTask = new attachmentGrid("taskAttachments",nId,nFolder,4);  
    }
    
    register("OX_Task_Delete", deleteTask);
    register("OX_Task_Edit", editTask);
    register("OX_Task_Duplicate", duplicateTask);
    register("OX_Object_Add_Attachment", addAttachment);

    register("Loaded", function() {
        gridlist = makeGrid("listeTasks",true);
        gridsplit = makeGrid("taskssplitgrid",true);
        
        function addmenu(node) {
            var menu = new PulldownMenu(node);
            var item = new MenuItem("Options", /*i18n*/
                function() {
                    if (currentpath2[0] == "tasks")
                        triggerEvent("OX_Switch_View",
                                     "configuration/tasks/preferences");
                });
            item.setIcon("img/folder/settings.gif");
            menu.addItem(item);
        }
        addmenu($("arrowForTaskOptions"));
        addmenu($("arrowForTaskSplitOptions"));
    });
        
    function tasks_markAsDone() {
    	function cb_changes(object) {
    		if (object["percent_completed"] && object["percent_completed"] == 100) {
    			return null;
    		} else {
    			return { "percent_completed": 100, "status": 3 };
    		}
    	}    	
    	tasks_udpateTasks(tasksSelection2.getSelected(), ["percent_completed"], cb_changes);
    }
    
    /**
     * @todo: this needs to be fairly optimized!
     * we have to decide between ... 
     * a) pre-fetch the needed columns of the selected items,
     * compare them with the changes we want to make and remove them if not changed to
     * keep the final put as small as possible
     * or b) just update all the selected items, no matter if object really changed or 
     * not, which saves all the newRequests to pre-fetch missing columns for comparision 
     * Anyway, we'll have to fix final editObjects call to update cache because right now
     * all selected items would be updated with the last changes!
     */
    function tasks_udpateTasks(ids, columns, cb_changes) {
    	if (ids == undefined || !ids.length) return false;
        var collection={};
        collection.objects=ids;
        collection.columns=columns;
        OXCache.newRequest(null,"tasks",collection,null,
            function(daten) {
            	if (!daten.objects) return;            	
            	var fPutData = new Array(); 
            	var fOCData = null;           	
                for (var i in daten.objects) {
                	var object = daten.objects[i];
                    var timestamp = object["timestamp"] || 0;
                    changes = cb_changes(object);                    
                    if (!changes) continue ; 
                    fOCData = changes;               
                    fPutData.push({
                    	"action": "update",
                    	"module": "tasks",
                    	"folder": object["folder_id"],
                        "id": object["id"],
                        "timestamp": object["timestamp"] || 0,
                    	"data" : fOCData               	
                    });
                }
                if (!fPutData.length || fOCData == null) return;
                new JSON().put(AjaxRoot + "/multiple?session=" + session, 
                       fPutData, null,
                       function(cb) { 
                       	    if (!cb.length) return;
                       	    fOCData["timestamp"] = cb[0]["timestamp"] || 0;
                       	    OXTaskMapping.editObjects(ids,fOCData);
                       }
                    );
            });
    	
    }
    
    function makeGrid(gridName,newlivegrid) {
    	function cb_changes(object) {
            var new_pc = 100;
            var new_status = 3;
            if (object["percent_completed"] && object["percent_completed"] >= 100) {
                new_pc = 0;
                new_status = 1;
            }
            return { "percent_completed": new_pc, "status": new_status };
        }
    	
    	function addCheckBox() {
	        var checkbox = newnode("input", 0, { type: "checkbox", className: "noborder" });
	        addDOMEvent(checkbox, "click", function() {
	        	    if (!tasksSelection2.getSelected().length) return false;
                    tasks_udpateTasks([tasksSelection2.getSelected()[0]], ["percent_completed"], cb_changes);
	        });
	        return checkbox;
	    }
    	
        var me = configGetKey("identifier");
        var constructor= newlivegrid ? LiveGrid2 : LiveGrid;
        var grid = new constructor([ 
            {
                sortable: false,
                name : ["recurrence_type"],
                text: "&#xa0;",
                width: "20px",
                style: { padding: 0, textAlign: "center", verticalAlign: "middle" },
                set: function(div, sequ) {
                    if (!div.firstChild)
                        div.appendChild(document.createElement("img"));
                    if (sequ < 1) {
                        div.firstChild.src = getFullImgSrc("img/tasks/tasks16x16.gif");
                        div.firstChild.alt = "";
                        div.firstChild.style.verticalAlign = "middle";
                    } else {
                        div.firstChild.src = getFullImgSrc("img/tasks/sequence.gif");
                        div.firstChild.alt = _("Series");   /*i18n*/
                        div.firstChild.style.verticalAlign = "middle";
                    }
                },
                clear: function(div) {
                    if (!div.firstChild)
                        div.appendChild(document.createElement("img"));
                    div.firstChild.src = getFullImgSrc("img/tasks/tasks16x16.gif");
                    div.firstChild.alt = "";
                    div.firstChild.style.verticalAlign = "middle";
                }
            },{
                name: ["folder_id", "id", "percent_completed"],
                text: "&#xa0;",
                style: { padding: 0, textAlign: "center", verticalAlign: "middle" },
                width: "20px",
                set: function(div, data) {
                    if (!div.firstChild) div.appendChild(addCheckBox());
                    div.firstChild.style.display = "";
                    div.firstChild.checked = (data["percent_completed"] && data["percent_completed"] >= 100);
                    div.firstChild.disabled =
                        grid.write_own && (data.created_by != me);
                },
                clear: function(div) {
                    if (!div.firstChild) div.appendChild(addCheckBox());
                    div.firstChild.style.display = "none";
                }
            },{ 
                text: "&#160;",
                name : ["private_flag"],
                sortable: false,
                width: "20px",
                style: { padding: 0 },
                set: function(div, text) {
                    if (div.firstChild) {
                        div.firstChild.src = !text ? getFullImgSrc("img/dummy.gif") : getFullImgSrc("img/private_flag.gif");
                        div.firstChild.alt = !text ? "" : _("Private"); /*i18n*/
                    } else
                        div.appendChild(newnode("img", 0,
                            {src: !text ? getFullImgSrc("img/dummy.gif") : getFullImgSrc("img/private_flag.gif"), alt: "", width: "16", height: "16" }));
                },
                clear: function(div) {
                    if (div.firstChild) {
                        div.firstChild.src = getFullImgSrc("img/dummy.gif");
                        div.firstChild.alt = "";
                    } else
                        div.appendChild(newnode("img", 0,
                            {src: getFullImgSrc("img/dummy.gif"), alt: "", width: "16", height: "16"}));
                }
            }, {
                text: "Subject",    /*i18n*/
                i18n: true,
                sortable: true,
                name : ["title","percent_completed"],
                sort: "title",
                set: function(div, object) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (object.title) {
                        div.firstChild.data = object.title;
                        if(object["percent_completed"] && object["percent_completed"] >= 100) {
                        	div.className="cell font-color-disabled";                        	
                            div.style.textDecoration = "line-through";                            
                        } else {
                        	div.className="cell";
                            div.style.textDecoration = "none";
                        }
                    } else {
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "Priority",   /*i18n*/
                name : ["priority"],
                sort : "priority",
                i18n: true,
                sortable: true,
                width: "8%",
                set: function(div, prio) {
                    var src = (prio == 3) ? getFullImgSrc("img/tasks/taskprio3.gif")
                            : (prio == 1) ? getFullImgSrc("img/tasks/taskprio1.gif")
                            : getFullImgSrc("img/tasks/taskprio2.gif");
                    if (!div.firstChild)
                        div.appendChild(newnode("img", 0, {src: src, alt: ""}));
                    else
                        div.firstChild.src = src;
                }, 
                clear: function(div) {
                            if (!div.firstChild)
                                div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/tasks/taskprio2.gif"), alt: ""}));
                            else
                                div.firstChild.src = getFullImgSrc("img/tasks/taskprio2.gif");
                        }
            }, {
                text: "Start date", /*i18n*/
                i18n: true,
                sortable: true,
                sort: "start_date",
                name : ["start_date","percent_completed"],
                width: "14%",
                set: function(div, object) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (object.start_date) {
                        div.firstChild.data = formatDate(object.start_date, "date");
                        if(object["percent_completed"] && object["percent_completed"] >= 100) {
                        	div.className="cell font-color-disabled";
                            div.style.textDecoration = "line-through";
                        } else {
                        	div.className="cell";  
                            div.style.textDecoration = "none";
                        }
                    } else {
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "Due date",   /*i18n*/
                name : ["end_date","percent_completed"],
                sort: "end_date",
                i18n: true,
                sortable: true,
                width: "14%",
                set: function(div, object) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (object.end_date) {
                    	div.style.color = "";
                        div.firstChild.data = formatDate(object.end_date, "date");
                        if(object["percent_completed"] && object["percent_completed"] >= 100) {
                        	div.className="cell font-color-disabled";
                            div.style.textDecoration = "line-through";
                        } else if (getDays(new Date()-new Date(object.end_date)) > 0) {
                            div.style.textDecoration = "none";
                            div.style.color = "red";
                        } else {
                        	div.className="cell";  
                        	div.style.textDecoration = "none";
                        }
                    } else {
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "% finished", /*i18n*/
                i18n: true,
                sortable: true,
                sort: "percent_completed",
                name : ["percent_completed"],
                width: "12%",
                set: function(div, percent_completed) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (percent_completed != undefined) {
                        div.firstChild.data = percent_completed + "%";
                        if (percent_completed >= 100) {
                        	div.className="cell font-color-disabled";
                            div.style.textDecoration = "line-through";
                        } else {
                        	div.className="cell";
                            div.style.textDecoration = "none";
                        }
                    } else {
                    	div.className="cell";
                        div.style.textDecoration = "none";
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "Flag",   /*i18n*/
                name : ["color_label"],
                i18n: true,
                width: "4em",
                sort: "color_label",
                sortable: true,
                set: function(div,text) {
                    if (div)
                        div.innerHTML = "<img src='"+getFullImgSrc("img/menu/tag_"+(text||0)+".gif")+"' alt='' />";
                },
                clear: clear
            }
        ], newlivegrid ? tasksSelection2 : tasksSelection , "tasks");
        
        var contextData = [];
        var count = Value(), writable = Value(), deletable = Value();
        var confirmable = Value();
        var menu = grid.contextmenu = globalContextMenus.tasks = new ContextMenu();
        
        var edit = new MenuItem("Edit", /*i18n*/
            function() { triggerEvent('OX_Task_Edit'); });
        edit.setIcon("img/menu/edit.gif", "img/menu/edit_d.gif");
        edit.setEnabledF(function() { return count() == 1 && writable(); });
        menu.addItem(edit);
        
        var del = new MenuItem("Delete", /*i18n*/
            function() { triggerEvent('OX_Task_Delete'); });
        del.setIcon("img/menu/delete.gif", "img/menu/delete_d.gif");
        del.setEnabledF(function() { return count() > 0 && deletable(); });
        menu.addItem(del);
        
        var copy = new MenuItem("Use as template", /*i18n*/
            function() { triggerEvent('OX_Task_Duplicate'); });
        copy.setIcon("img/menu/task_copy.gif", "img/menu/task_copy_d.gif");
        copy.setEnabledF(function() { return count() == 1 && writable(); });
        menu.addItem(copy);
    
        var done = new MenuItem("Mark as Done", /*i18n*/
            function() { triggerEvent('OX_Task_MarkAsDone'); });
        done.setEnabledF(function() { return count() > 0 && writable(); });
        menu.addItem(done);
        
        menu.addItem(new MenuSeparator());
    
        var confirm = new MenuItem("Change confirmation"/*i18n*/, function() {
            triggerEvent('OX_Task_Change_Confirm', contextData);
        });
        confirm.setIcon("img/menu/global_confirmation_change.gif",
                        "img/menu/global_conf_change_d.gif");
        confirm.setEnabledF(function() { 
        	return count() > 0 && confirmable(); 
        });
        menu.addItem(confirm);
    
        menu.onShow = function() {
            var sel = this.getContext().getSelected();
            count.set(sel.length);
            writable.clear();
            deletable.clear();
            confirmable.clear();
            if (!sel.length) return;

            OXCache.newRequest(null, "tasks",
                { columns: ["created_by"], objects: sel }, null, ownerData);
            function ownerData(data) {
                contextData = data.objects;
                writable.set(menuhasRight(contextData, "WRITE"));
                deletable.set(menuhasRight(contextData, "DELETE"));
            }

            OXCache.newRequest(null, "tasks",
                { columns: ["users"], objects: sel }, null, userData);
            function userData(data) {
                contextData = data.objects;
                for(var i in contextData) {                	
                    var users = contextData[i].users;
                    var me = config.identifier;
                    CheckUsers: {
                        for(var j = 0; j < users.length; j++) {
                            if (users[j].id == me) break CheckUsers;
                        }
                        confirmable.set(false);
                        return;
                    }
                }
                confirmable.set(true);
            }
        };
        
        grid.identification = gridName; 
        
        grid.events.register("Activated", function(ids) {           
            if (ids && ids.length > 0) {
                if(menuhasRight(ids,"WRITE")) {
                    activeTaskId = ids;
                    triggerEvent("OX_Task_Edit");
                } else {
                    triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
                }
            } else {
                triggerEvent("OX_Before_Create_Task");
            }           
        });
        
        grid.events.register("Selected", function(ids) {
        	activeTaskId = id = grid.getSelectedIDs() || [];
            if (ids == 1)  {
                cb_selection_changed();             
            } else if (currentpath2[1]=="split") {
                clearSplitDetails();                
            }
            triggerEvent("Selected", activeTaskId);
        });
        
        grid.events.register("Delete", function() {
                if(menucheckRight("DELETE"))
                    deleteTask()
                else
                    triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
            }       
        );
        $(gridName + "Header").appendChild(grid.getHeader());
        grid.getTable($(gridName));
        var hv = grid.addHover(OXTaskHover.getContent().node, function(id) {
            OXTaskHover.actualHover=hv;
            OXTaskHover.refillContent(id.id,id.folder_id);                  
            
        });
        hv.setSize(OXTaskHover.contentobject.node);
        grid.setSort("end_date","asc");
        return grid;
    }
    
    function editTask() {
        if (currentpath2[1]=="list") {
            activeTaskId = id = gridlist.getSelectedIDs();
        } else  if (currentpath2[1]=="split") {
            activeTaskId = id = gridsplit.getSelectedIDs();
        }
        if (activeTaskId.length == 1) {
            editTask = newWindow("newTask.html#modul=edit&id=" 
                + activeTaskId[0].id 
                + "&session=" 
                + session 
                + "&folder=" 
                + activeTaskId[0].folder_id, getWindowOptions(), activeTaskId[0]);
            if (editTask) editTask.focus();
        }
    }
    
    function duplicateTask() {
        var selected=tasksSelection2.getSelected();
        if (selected.length < 1) {
            triggerEvent("OX_New_Error", 4, _("Please select at least one task!"));
        }
        if (id.length == 1) {
            duplicatetask = newWindow("newTask.html#modul=duplicate&id=" 
                + activeTaskId[0].id 
                + "&session=" 
                + session 
                + "&folder=" 
                + activeTaskId[0].folder_id, getWindowOptions());
            if (duplicatetask) duplicatetask.focus();
        }
    }
    register("OX_Create_Object",createNewTask);
    
    function createNewTask(module,folder) {
        if(module=="tasks") {
            if(!folder)
                folder = configGetKey("folder.tasks");
            newTaskWindow = newWindow("newTask.html#folder="+folder, "width=780px,height=640px,left=5,top=5,resizable=yes");
            newTaskWindow.focus();
        }
    }
    
    function deleteTask() {
        function cbyes() {      
            if (currentpath2[1] == "list") {
                activeTaskId = id = gridlist.getSelectedIDs();            
            } else if (currentpath2[1]=="split") {
                activeTaskId = id = gridsplit.getSelectedIDs();           
            } else if (currentpath2[1]=="search") {
                activeTaskId = id = gridlist.getSelectedIDs();
            } else {
                activeTaskId = id = [completedetailtask];
                switchToTaskStdView();
            }
            OXTaskMapping.deleteObjects(activeTaskId);   
        } 
        var confirmtexttasks=_("Are you sure you want to delete selected item?");
        if(activeTaskId.length>1) {
            confirmtexttasks=_("Are you sure you want to delete selected items?");
        }
        newConfirm(_("Delete Task"),confirmtexttasks,AlertPopup.YESNO,null,null,cbyes,null);
    }
    
    function clearSplitDetails() {
        $("tasks.split.detail_container.content").style.display="none";
        $("tasks.split.detail_container.loading").style.display="none";
        if ($("tasks.split.bottom_str").firstChild) {
        	$("tasks.split.bottom_str").firstChild.data="\u00a0"; // clean bottom str
        }
        /*
        if (currentpath2[1] == "split" && currentpath2[2] != "overview") { 
            triggerEvent("OX_Switch_View", "tasks/split/overview");
        }
        */
    }
    
    function printTasks() {
        if (!tasksSelection2 || activemodule != "tasks") {
        	return;
        } else if (tasksSelection2.count != 1) {
        	if (currentpath2[1] == "split" && gridsplit) {
        		globalprint.printLiveGrid(gridsplit);
        	} else if (gridlist) {
        		globalprint.printLiveGrid(gridlist);
        	}
        	return;
        }    	
    	
        var aPrintDetailTask = new Array();
        aPrintDetailTask = [];
                
        var taskData = completedetailtask;
        var detailTaskPrint = new Print(taskData.title);
        
        /* Tab Details */
        aPrintDetailTask.push(Print.createTitle(taskData.title));
        aPrintDetailTask.push(Print.createLine("5px"));
        aPrintDetailTask.push(Print.createEmpty(true));
        
        if (taskData.priority)
            aPrintDetailTask.push(Print.createPriority(taskData.priority));
            
        aPrintDetailTask.push(Print.createContent(_("% done:"),taskData.percent_completed || "0"));

        if (taskData.start_date)
            aPrintDetailTask.push(Print.createContent(_("Start date:"),formatDate(taskData.start_date, "dateday")));

        if (taskData.end_date)
            aPrintDetailTask.push(Print.createContent(_("End date:"),formatDate(taskData.end_date, "dateday")));

        if (taskData.note)
            aPrintDetailTask.push(Print.createContent(_("Description:"),taskData.note));
        
        /* Tab Details */
        aPrintDetailTask.push(Print.createEmpty());
        aPrintDetailTask.push(Print.createHeader(_("Details:")));
        
        if (taskData.trip_meter)
            aPrintDetailTask.push(Print.createContent(_("Distance:"),taskData.trip_meter));
            
        if (taskData.target_duration)
            aPrintDetailTask.push(Print.createContent(_("Estimated Duration:"),taskData.target_duration + " " + _("minutes")));
            
        if (taskData.actual_duration)
            aPrintDetailTask.push(Print.createContent(_("Current Duration:"),taskData.actual_duration + " " + _("minutes")));

        if (taskData.target_costs)
            aPrintDetailTask.push(Print.createContent(_("Estimated Costs:"), (taskData.target_costs ? round(taskData.target_costs) : "") + " " + taskData.currency));

        if (taskData.actual_costs)
            aPrintDetailTask.push(Print.createContent(_("Current Costs:"), (taskData.actual_costs ? round(taskData.actual_costs) : "") + " " + taskData.currency));

        detailTaskPrint.printDetail(aPrintDetailTask);
    }

    var gridTask = false;
    var gridsplitTask = false;

})();

function fn_tasks_getDetails(objects, forceUpdate) {   
    if (!objects.length || activemodule != "tasks") return;
    
    
    /*
    // check if it's still the same selected object. no need to always
    // add newRequests as changes will be handled by the modified cb.
    // right now this just only work for 1 change, then the modified cb
    // of the cache won't be triggered anymore. have to check this
    if (activeTaskId.length && activeTaskId[0].calculatedHash == 
        tasksSelection2.getSelected()[0].calculatedHash &&
        forceUpdate == undefined) {
        return;
    }
    */
    
    enableTaskLoadingScreen(true);
        
    var collection={}
    collection.objects=[objects[0]];
    collection.columns=null;
    if (tmpDetailRequest) {
        OXCache.unregister(tmpDetailRequest.uniqueName);
        delete(tmpDetailRequest);
    }
    tmpDetailRequest=OXCache.newRequest(null, "tasks", collection, function(daten) {      
        if (!daten || !daten.objects) {
        	enableTaskLoadingScreen(false);
        	return;
        }
        updateTaskSplit(daten.objects[0]);
    }, function(daten) {
        if (!daten || !daten.objects) {
        	enableTaskLoadingScreen(false);
        	return;
        }
        updateTaskSplit(daten.objects[0]);
    }, forceUpdate);
    
}

function expandTaskSplitHeader(fullHeader) {
    if (fullHeader) $('tasks.split.header_ext').style.display = "";
    $("tasks.split.expand_plus").getElementsByTagName("img")[0].src="themes/default/img/" + (fullHeader ? "minus" : "plus") + ".gif";
    configSetKey("gui.tasks.fullsplitheader", fullHeader);    
    var steps = 6*pxPerEm;
    animate(configGetKey("gui.effects.fading") ? 250 : 0, steps, function(stepN) { 
        var an = fullHeader ? stepN : steps-stepN;
        setTimeout(function() { resizeSplit("tasks.split.header_ext", Math.round(an/pxPerEm) + "em"); }, 0);
    }, function() { 
        if (!fullHeader) $('tasks.split.header_ext').style.display = "none";
    });    
}

function resizeTaskSplitHeader(fullHeader) {
   setTimeout(function() { resizeSplit("tasks.split.header_ext", fullHeader ? "6em" : "0em"); }, 0);
}

function enableTaskLoadingScreen(enabled) {
    if (enabled && $("tasks.split.detail_container.content").style.display != "none") {
        $("tasks.split.detail_container.content").style.display="none";
    } else if (!enabled && $("tasks.split.detail_container.content").style.display != "block") {
    	$("tasks.split.detail_container.content").style.display="block";
    }
    if (!enabled && $("tasks.split.detail_container.loading").style.display != "none") {
        $("tasks.split.detail_container.loading").style.display="none";
    } else if (enabled && $("tasks.split.detail_container.loading").style.display != "block") {
        $("tasks.split.detail_container.loading").style.display="block";
    }    
}

var aStatusTask = new Array("Not started","In progress","Done","Waiting","Deferred");
function updateTaskSplit(object) {
    if (!object || activemodule != "tasks") return;
    
	// changing the selection jumps back to overview tab
	if (currentpath2[1] == "split" && currentpath2[2] != "overview") { 
        triggerEvent("OX_Switch_View", "tasks/split/overview");
    }

    if ($("tasks.split.due_today").style.display != "none") {
    	$("tasks.split.due_today").style.display="none";
    }

    aPrintDetailTask = [];
    objTaskDetailParticipants = new TaskDetailParticipants();
    refTaskDetailParticipantTab = new TaskDetailParticipantTab();
    
    writeBottomString(object,"tasks.split.bottom_str");
    triggerEvent("Confirmation_Changed",0);              
    completedetailtask=object;
    
    for (idfield in object) {
        var idvalue = object[idfield];          
        switch (idfield) {
            case "priority":
                  var img = idvalue && idvalue <= 3 ? idvalue : 2; 
                  $("tasks.split." + idfield).src = getFullImgSrc("img/tasks/taskprio" + img + ".gif");
                  continue;
                  break;
            case "note":
                  removeChildNodes($("tasks.split." + idfield));
                  idvalue = idvalue || "";                    
                  var nText = idvalue.split("\n");
                  for (var i in nText) {
                      $("tasks.split." + idfield).appendChild(document.createTextNode(nText[i]));
                      $("tasks.split." + idfield).appendChild(newnode("br"));
                  }
                  continue;
                  break;
            case "status":
                  idvalue = isNaN(idvalue) ? "" : _(aStatusTask[idvalue - 1]);
                  break; 
            case "created_by":
                  $("tasks.split." + idfield).firstChild.data = _("Unknown"); /*i18n*/
                  if (!idvalue) break;
                  var fnSetPrincipal = (function fnSetPrincipal(idfield, idvalue) {
                      return function(arg) {
                          $("tasks.split." + idfield).firstChild.data = arg[idvalue].display_name; 
                      }
                  })(idfield, idvalue);
                  internalCache.getUsers([idvalue],fnSetPrincipal);
                  continue;
                  break; 
            case "percent_completed":
                  idvalue = idvalue != undefined ? idvalue + "%" : null;
                  break;
            case "end_date":
                  var endDate = idvalue;
                  var startDate = object["start_date"];
                  if (endDate && startDate) {
                      idvalue = format(_("Starts on %1$s, due on %2$s."), formatDate(startDate, "date"), formatDate(endDate, "date"));
                  } else if (startDate) {
                      idvalue = format(_("Starts on %s."), formatDate(startDate, "date"));
                  } else if (endDate) {
                      idvalue = format(_("Due on %s."), formatDate(endDate, "date"));
                  } else {
                      idvalue = _("Not set");
                  }
                  
                  // warning headline if task is due
                  if (endDate != undefined && 
                      object["percent_completed"] != undefined && 
                      object["percent_completed"] < 100) {                          
                      var pastDays = getDays(new Date()-new Date(endDate));
                      var text = "";                          
                      switch(pastDays) {
                           case 0:
                               text = _("Due today!");
                               break;
                           case -1:
                               text = _("Due tomorrow.");
                               break;
                           case 1:
                               text = _("Overdue by yesterday.");
                               break;
                           default:
                               if (pastDays < -1) {
                               	    text = format(_("Due in %s days."), Math.abs(pastDays));
                               } else {
                                    text = format(_("Overdue by %s days."), pastDays);
                               }
                               break;
                      }
                      $("tasks.split.due_today.text").firstChild.data=text;        
                      $("tasks.split.due_today").style.display="";
                  }
                  break;
            case "participants":
                  objTaskDetailParticipants.popArray();
                  objTaskDetailParticipants.oParticipantResources = clone(idvalue);  
                  objTaskDetailParticipants.writeCountParticipants();
                  objTaskDetailParticipants.pushArray();	                  
                  $("tasks.split.participants_count").firstChild.data = objTaskDetailParticipants.arrayLength();
                  internalCache.getUsers(objTaskDetailParticipants.idUserArr,fnSetTaskUserColumn);
                  break;
            case "users":
                  // trigger confirmation                      
                  for (var i=0; idvalue && i < idvalue.length; i++) {
                      if (idvalue[i].id == configGetKey("identifier")) { 
                      	triggerEvent("Confirmation_Changed", 1); 
                      	break; 
                      }
                  }
                  objTaskDetailParticipants.usersD = idvalue || "";
                  break;
            case "color_label":
                  var img = idvalue || "0";
                  $("tasks.split." + idfield).src = getFullImgSrc("img/menu/tag_"+img+".gif");
                  continue;
                  break;             
            case "private_flag":
                  var img = idvalue ? "img/private_flag.gif" : "img/dummy.gif";
                  $("tasks.split." + idfield).src = getFullImgSrc(img);
                  continue;
                  break;
            case "actual_duration":
            case "target_duration":
                  idvalue = idvalue ? getInterval(idvalue * 6e4 /* ms/min */) : _("Not set");
                  break;
            case "actual_costs":
            case "target_costs":
                  var currency = object["currency"] || "";
                  idvalue = idvalue && !isNaN(idvalue) ? round(idvalue) + " " + currency : _("Not set");
                  break;
            case "recurrence_type":
                  var img = idvalue ? "img/tasks/sequence.gif" : "img/dummy.gif"; 
                  $("tasks.split." + idfield).src = getFullImgSrc(img);
                  continue;
                  break;
        }
        
        if ($("tasks.split." + idfield)) {
            $("tasks.split." + idfield).firstChild.data = idvalue != null ? idvalue : _("Not set");
        }
    }
    enableTaskLoadingScreen(false);
    resizeTaskSplitHeader(configGetKey("gui.tasks.fullsplitheader"));
}

function addAttachment() {
    if (activeTaskId[0]) {
        xaId = activeTaskId[0].id;
    } else if (id[0]) {
        xaId = id[0].id;
    }
    if (attachmentWindow == 0) {
        var taskAttachment = new Attachment("taskAttachment", activefolder, 4, xaId);
        attachmentWindow = 1;
    }
}

function jumpToTasksConfiguration(){
    triggerEvent("OX_Switch_View","configuration/tasks/preferences");
}

/* Participant object */
function TaskDetailParticipants() {
    this.oParticipantResources = null;
    this.idUserArr = new Array();
    this.idGroupArr = new Array();
    this.idResourceArr = new Array();
    this.sText = "";
    this.nText = null;
    this.nPart = 0;
    this.gridData = new Array();
    this.gridIndex = 0;
    this.idForExternal = 1000000000;
    this.usersD = null;
}

TaskDetailParticipants.prototype = {
    writeCountParticipants : function () {
        this.sText = this.oParticipantResources.length;
        $("tasks.split.participants_count").firstChild.data = this.sText;
    },
    pushArray : function () {
        for(i=0; i < this.oParticipantResources.length; i++)
        {
                /*
                 * type 1 user
                 * type 2 user group
                 * type > 2 resource
                 * */
            switch (this.oParticipantResources[i].type) {
                case 1:  this.idUserArr.push(this.oParticipantResources[i].id);
                            break;
                                                        
                case 2:     this.idGroupArr.push(this.oParticipantResources[i].id);
                            break;
                            
                case 3:     this.idResourceArr.push(this.oParticipantResources[i].id);
                            break;
                            
                case 5:  this.idUserArr.push(this.oParticipantResources[i]);
                            break;                          
                                                
            }                           
        }
    },
    popArray : function () {
        this.idUserArr.length = 0;
        this.idGroupArr.length = 0;
        this.idResourceArr.length = 0;
    },
    writeMoreButton : function() {
        $("a_d_participants_more").style.display = 'inline';
        $("a_d_participants_more").style.display = 'block';
    },
    writeMoreButtonResource : function() {
        $("a_d_participants_more_resources").style.display = 'inline';
        $("a_d_participants_more_resources").style.display = 'block';
    },
    arrayLength : function() {
        var theLength = this.idUserArr.length + this.idGroupArr.length + this.idResourceArr.length;
        return theLength;
    },
    fnSetUserColumn : function (arg) {
        /*
        var i = 0;
        var j = this.gridData.length;
        while (i < j) {
            this.gridData.pop();
            i++;
        }
        */
        for(var i=0; i < this.idUserArr.length; i++) {
            if(this.nPart < 6 ) {   
                if(arg[this.idUserArr[i]]) {                            
                    this.sText = arg[this.idUserArr[i]].display_name;                                       
                    $("a_d_participants_" + (this.nPart+1)).firstChild.data = this.sText                                        
                    aDetailFieldsToClear["a_d_participants_" + (this.nPart+1)] = "set";
                    this.nPart++;               
                }       
            } else {
                this.writeMoreButton();
            }
            if(typeof this.idUserArr[i] == "number") {
                this.gridData[this.gridIndex] = new Array();
                this.gridData[this.gridIndex].push(arg[this.idUserArr[i]].id);
                this.gridData[this.gridIndex].push("user");
                this.gridData[this.gridIndex].push(arg[this.idUserArr[i]].display_name);        
                this.gridIndex++;   
                aPrintDetailTask.push(Print.createContent(_("Participant:"),arg[this.idUserArr[i]].display_name));
            
            } else {
                this.gridData[this.gridIndex] = new Array();
                this.gridData[this.gridIndex].push(this.idForExternal);
                this.gridData[this.gridIndex].push("user_extern");
                this.gridData[this.gridIndex].push(this.idUserArr[i].display_name || this.idUserArr[i].mail);     
                this.gridIndex++;
                this.idForExternal ++;
                aPrintDetailApp.push(Print.createContent(_("Participant:"), (this.idUserArr[i].display_name || this.idUserArr[i].mail)));
            }
        }
        var Self = this;
        setTimeout(
            function() {
                refTaskDetailParticipantTab.users= Self.usersD;
                refTaskDetailParticipantTab.makeGrid();
            },20
        )
        setTimeout(                                                 
            function() {
                internalCache.getGroups(objTaskDetailParticipants.idGroupArr,fnSetTaskGroupColumn);
            },0
        );
    },
    fnSetGroupColumn : function (arg)
    {
        var tmp_grouplength = new Array();
        var tmp_userToGet = new Array();
        for(var i=0; i < this.idGroupArr.length; i++)
        {
            if(this.nPart < 6 ) 
            {                                       
                this.sText = arg[this.idGroupArr[i]].display_name;                              
                $("a_d_participants_" + (this.nPart+1)).firstChild.data = this.sText                                        
                aDetailFieldsToClear["a_d_participants_" + (this.nPart+1)] = "set";     
                this.nPart++;                                   
            }
            else
            {
                this.writeMoreButton();
            }
            this.gridData[this.gridIndex] = new Array();
            this.gridData[this.gridIndex].push(arg[this.idGroupArr[i]].id);
            this.gridData[this.gridIndex].push("group");
            this.gridData[this.gridIndex].push(arg[this.idGroupArr[i]].display_name);   
            this.gridData[this.gridIndex].push("group");
            this.gridData[this.gridIndex].push(""); 
            tmp_grouplength[this.idGroupArr[i]] = this.gridIndex + 1;
            this.gridIndex += (arg[this.idGroupArr[i]].members.length + 1);
            for(tz in arg[this.idGroupArr[i]].members)
                tmp_userToGet.push({id : arg[this.idGroupArr[i]].members[tz], type : 1});
        }
        var Self = this;
        internalCache.getObjects(tmp_userToGet, function(cb){
            for(gr in tmp_grouplength){
                for(me in arg[gr].members){
                    Self.gridData[tmp_grouplength[gr]] = new Array();
                    Self.gridData[tmp_grouplength[gr]].push(arg[gr].members[me] + "gm");
                    Self.gridData[tmp_grouplength[gr]].push("groupMember");
                    Self.gridData[tmp_grouplength[gr]].push(cb[arg[gr].members[me]].display_name);
                    tmp_grouplength[gr]++;
                }
            }
        });
    },
    fnSetResourceColumn : function (arg)
    {
        for(var i=0; i < this.idResourceArr.length; i++)
        {
            if(i < 2 ) 
            {                                       
                this.sText = arg[this.idResourceArr[i]].display_name;                                   
                $("a_d_resources_" + (i+1)).firstChild.data = this.sText                                        
                aDetailFieldsToClear["a_d_resources_" + (i+1)] = "set";     
            }
            else
            {
                this.writeMoreButtonResource();
            }
        this.gridData[this.gridIndex] = new Array();
        this.gridData[this.gridIndex].push(arg[this.idResourceArr[i]].id);
        this.gridData[this.gridIndex].push("ressourcen");   
        this.gridData[this.gridIndex].push(arg[this.idResourceArr[i]].display_name);    
        this.gridData[this.gridIndex].push("ressourcen");   
        this.gridData[this.gridIndex].push("");
        this.gridIndex++;
        }
    }
}

function TaskDetailParticipantTab() {
    this.users = null;
    this.list = $("taskParticipants");
    this.listHeader = $("taskParticipantsHeader");
    this.myTaskPStorage = null;
    this.myTaskPStorage = new Storage(0, []);
}

TaskDetailParticipantTab.prototype = {
    
    makeGrid : function () {        
    
        if (taskParticipantsGrid) 
        {
            this.list.innerHTML = "";
            taskParticipantsGrid = null;
        }
        
        taskParticipantsGrid = new LiveGrid([{  
            text: "&#xa0;",
            sortable: true,
            width: "16px",
            style: {padding: 0},
            set: function(div,text) 
            {
                if (div) {
                    removeChildNodes(div);
                    if(text != "groupMember")
                        div.appendChild(newnode("img", 0, {src : getFullImgSrc("img/calendar/" + text + ".gif"), alt : _("Participant") }));
                    else
                        div.appendChild(newnode("img", 0, {src : getFullImgSrc("img/dummy.gif"), alt : _("Participants"), width: "16", height: "16" }));
                }
            },
            clear: LiveGrid.makeClear(""),
            index:1
        },{ 
            text: "Participants",   /*i18n*/
            i18n:true,
            sortable: true,
            width: "30%",
            set: function(div, text){               
                if (div) {
                    removeChildNodes(div);
                    if(text[1] == "groupMember"){
                        div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/user.gif"), alt: "Group Member"}));
                        div.appendChild(document.createTextNode("\u00a0" + text[2]));
                    } else {
                        div.appendChild(document.createTextNode(text[2]));
                    }
                }
            },
            clear: LiveGrid.makeClear("")
        }, {
            text: "Status", /*i18n*/
            i18n:true,
            sortable: true,
            width: "10%",
            set: function(div,text) {
                if (div) {
                    removeChildNodes(div);
                    switch(text) {
                        case 0  :   div.appendChild(document.createTextNode(_("waiting")));
                                        break;
                                        
                        case 1  :   div.appendChild(newnode("span", 0, {className : "appointmentACCEPTED"}, [document.createTextNode(_("accepted"))]));
                                        break;
                                        
                        case 2  :   div.appendChild(newnode("span", 0, {className : "appointmentDECLINED"}, [document.createTextNode(_("declined"))])); 
                                        break;
                                        
                        case 3  :   div.appendChild(newnode("span", 0, {className : "appointmentTENTATIVE"}, [document.createTextNode(_("tentative"))]));
                                        break;
                                        
                        default :   div.appendChild(document.createTextNode("\u00a0"));
                                        break;
                    }
                }
            },
            clear: LiveGrid.makeClear(""),
            index:3
        }, {
            text: "Comment",    /*i18n*/
            i18n:true,
            sortable: true,
            set: LiveGrid.defaultSet,
            clear: LiveGrid.makeClear(""),
            index:4
        }

        ], new Selection());
        if(taskParticipantsGrid.getHeader()) {
            removeChildNodes(this.listHeader);
            this.listHeader.appendChild(taskParticipantsGrid.getHeader());
        }
        taskParticipantsGrid.getTable(this.list);
    },
    
    appendToStorage : function() {  
        // do not sort because the group members must be shown behind the groups
        /*function sort_fn(a,b)
        {
            if(a[2] < b[2])
                return -1;
            else
                return 1;                           
        }
        objTaskDetailParticipants.gridData.sort(sort_fn);
        */
        for(var i = 0; i < objTaskDetailParticipants.gridData.length; i++) {
            for(var t = 0; t < this.users.length; t++) {
                if(this.users[t].id == objTaskDetailParticipants.gridData[i][0]) {
                    objTaskDetailParticipants.gridData[i].push(this.users[t].confirmation);
                    objTaskDetailParticipants.gridData[i].push(this.users[t].confirmmessage || ""); 
                }
            }           
        }
    },
    
    enableGrid : function () {
        this.appendToStorage();
        var tmp_participants = new Array()
        for(var i = 0; i < objTaskDetailParticipants.gridData.length; i++) {
            tmp_participants[i] = objTaskDetailParticipants.gridData[i];
        }
        this.myTaskPStorage.append(tmp_participants);
        //enable the grid
        if(taskParticipantsGrid) {
            taskParticipantsGrid.enable(this.myTaskPStorage);
        }
    },
    
    disableGrid : function() {
        this.myTaskPStorage.remove(0,objTaskDetailParticipants.gridData.length);
        if(taskParticipantsGrid)
            taskParticipantsGrid.disable(); 
    }
}

function fnSetTaskUserColumn(arg) {
    if (arg) {
    	objTaskDetailParticipants.fnSetUserColumn(arg);
    }
}

function fnSetTaskGroupColumn(arg) {
    objTaskDetailParticipants.fnSetGroupColumn(arg);
}
function fnSetTaskResourceColumn(arg) {
    objTaskDetailParticipants.fnSetResourceColumn(arg);
}
fileloaded();