/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

// global var which holds a common storage with all accounts
// needed later for folder subscribe and updates
var mail_accounts;

register("OX_Configuration_Loaded", function () {
	
	mail_accounts = new Storage(0, [], 0, 0, 0, 0, function(data) { return data.id; });
		
	function loadAccounts(cb) {
		ox.JSON.get(AjaxRoot + "/account?action=all&session=" + session,
	        	// data handler
	            function(reply) {
	                mail_accounts.remove(0, mail_accounts.ids.length);
	                var nData = [];
	                for (var i in reply.data) {
	                	nData.push(mapArray2Object(reply.data[i]));
	                }
	                mail_accounts.append(nData);
	                if (cb) cb();
	            },
	            // error handler
	            function() {
	            	if (cb) cb();
	            	return false; // standard error handler will be called 
	            });
	}
	// load 
	
	loadAccounts(null);
	
	// if not enabled we won't continue
	if (!configGetKey("modules.mailaccount.module")) return;
		
	var node = new ox.Configuration.LeafNode("configuration/mail/accounts", 
			newnode("span",0,0,[ 
			                    newnode("span",0,0,[document.createTextNode(_("Accounts"))]), 
			                    newnode("span",{background:"orange",marginLeft:"5px",padding:"2px",
			                    	MozBorderRadius:"2px",WebkitBorderRadius:"2px",color:"white"},0,
			                    		[ document.createTextNode(_("Beta"))]) 
			                  ]));
	var split = new ox.Configuration.VSplit(node, _("E-Mail Accounts"), 0.28, true);
	
	/*
     * mapping array from server to object
     */
    function mapArray2Object(data) {    	
    	var mObj = {};
    	mObj.id = data[0];
    	mObj.login = data[1];
    	mObj.password = null; //data[2];
    	mObj.mail_url = data[3];
    	mObj.transport_url = data[4];
    	mObj.name = data[5];
    	mObj.primary_address = data[6];
    	mObj.spam_handler = data[7];
    	mObj.trash = data[8];
    	mObj.sent = data[9];
    	mObj.drafts = data[10];
    	mObj.spam = data[11];
    	mObj.confirmed_spam = data[12];
    	mObj.confirmed_ham = data[13];
    	mObj.mail_server = data[14];
    	mObj.mail_port = data[15];
    	mObj.mail_protocol = data[16];
    	mObj.mail_secure = data[17];
    	mObj.transport_server = data[18];
    	mObj.transport_port = data[19];
    	mObj.transport_protocol = data[20];
    	mObj.transport_secure = data[21];
    	mObj.transport_login = data[22];
    	mObj.transport_passord = data[23];
    	mObj.unified_inbox_enabled = data[24];
    	mObj.pop3_refresh_rate = data[31];
    	mObj.pop3_expunge_on_quit = !data[32];
    	mObj.pop3_delete_write_through = data[33];
    	return mObj;
    }	

	/** Init function **/
	split.init = function() {
	    var selection = new Selection();
	    var grid = new LiveGrid([
	        { 
	            text: _("Account name"),
	            clear: LiveGrid.makeClear(""),
	            set: function(div, data) {
	                if (div.firstChild)
	                    div.firstChild.data = data.name || "";
	                else
	                    div.appendChild(document.createTextNode(data.name || ""));                
	            }
	        }
	    ], selection);
	    grid.emptylivegridtext = _("No accounts available");
	    
	    split.list = grid;
	    
	    split.enableList = function() {	    	
	    	loadAccounts(
	    			function() {
		            	grid.enable(mail_accounts);	    				
	    			}
	    	);
	    };
	    
	    split.save = function(data, cont) {
	    	var nData = clone(data);
	    	
	    	// remove some fields if required
	    	if (!trimStr(nData.password).length) {
	    		delete(nData.password);
	    	}
	    	if (!nData.transport_credentials) {
	    		delete(nData.transport_login);
	    		delete(nData.transport_password);
	    	}
	    	delete(nData.transport_credentials);
	    	
	    	nData.pop3_expunge_on_quit = !nData.pop3_expunge_on_quit;
	    	nData.mail_port = parseInt(nData.mail_port);
	    	nData.transport_port = parseInt(nData.transport_port);
	    	nData.transport_protocol = "smtp";
	    	
	    	if ("id" in data) {
	            ox.JSON.put(AjaxRoot + "/account?action=update&session=" +
	                        session, nData, function(reply) {
	            				mail_accounts.localUpdate([data.id], function(old) {
	                                if (!equals(data, old)) return data;
	                            });
	                            ox.Configuration.info(
	                                _("Your settings have been saved."));
	                            // updating folder tree
	            	            oMainFolderTree.cache.update(null, true, null);
	            	            reply.data.pop3_expunge_on_quit=!reply.data.pop3_expunge_on_quit;
	            	            cont(reply.data);
	                        });
	        } else {
	        	nData.trash = "trash";
	        	nData.sent = "sent";
	        	nData.drafts = "drafts";
	        	nData.spam = "spam";
	        	nData.confirmed_spam = "confirmed-spam";
	        	nData.confirmed_ham = "confirmed-ham";
	        	nData.spam_handler = "NoSpamHandler";
	            ox.JSON.put(AjaxRoot + "/account?action=new&session=" +
	                        session, nData, handleNew);
	        }
	    	
	    	function handleNew(reply) {
	    		var data = reply.data;
	    		data.pop3_expunge_on_quit=!data.pop3_expunge_on_quit;
	    		mail_accounts.append([data]);
	            ox.Configuration.info(_("Your settings have been saved."));
	            split.onNew();
	            // updating folder tree
	            oMainFolderTree.cache.update(null, true, null);
	            cont(data);
	        }
	    }
	    
	    split.load = function(cont) {
	    	split.right.scrollTop = 0;
	    	mail_accounts.newIterate(selection.getSelected(), emptyFunction,
	            function(i, data) {
	                if (data.errormsg) return cont();
	                var d = clone(data);
	                cont(d);
	            });
	    };
	    
	    split.onNew = function() {
	    	split.right.scrollTop = 0;
	    	this.addNew({ name: _("New account") });	        
	    };
	    
	    
	    /*** menu items ***/
	    menuarrows[node.id] = {};
	    
	    var rulesmenu = MenuNodes.createSmallButtonContext("mail.accounts",
	        _("Rules"));
	    MenuNodes.createSmallButton(rulesmenu, "mail.accounts.delete",
	        _("Delete"), getFullImgSrc("img/menu/delete.gif"),
	        getFullImgSrc("img/menu/delete_d.gif"), confirmDelete);
	    function confirmDelete() {
	        if (!selection.count) return;
	        newConfirm(ngettext("Delete Account", "Delete Accounts", selection.count),
	            ngettext("Are you sure you want to delete the selected account?",
	                     "Are you sure you want to delete the selected accounts?",
	                     selection.count),
	            AlertPopup.YES | AlertPopup.NO, null, null, handleYes);
	    }
	    function handleYes() {
	    	mail_accounts.newIterate(selection.getSelected(), emptyFunction, handleDelete);
	    }
	    function handleDelete(idx, data) {
	        ox.JSON.put(AjaxRoot + "/account?action=delete&session=" + session,
	            [ data.id ], handleReply);
	        function handleReply(reply) {
	            grid.deleteIDs([data.id]);
	            // updating folder tree
	            oMainFolderTree.cache.update(null, true, null);
	        }
	    }
	    addMenuNode(rulesmenu.node, MenuNodes.FIXED, 31);
	    changeDisplay(node.id, "mail.accounts");
	    
	    register("OX_SELECTED_ITEMS_CHANGED", function() {
	        var deleteenabled = selection.count >= 1;
	        if (grid.storage) {
	            grid.storage.newIterate(selection.getSelected(), emptyFunction, emptyFunction, updateMenu);
	        } else updateMenu();	        
	        function updateMenu() {
	            menuglobalzaehler = 0;
	            menuarrows[node.id]["mail.accounts"] = [];
	            menu_display_contents(node.id, "mail.accounts", deleteenabled,
	                "mail.accounts.delete");
	        }
	    });
	    
	    /*** new/edit fields on the right side ***/
	    
	    /*** blank line ***/
	    var lb = new ox.UI.Widget();
	    lb.addContent = function() {
	        this.node = this.parent.addRow(newnode("br", null, false));
	    };
	    
	    /*** ACCOUNT SETTINGS ***/
	    var account = new ox.Configuration.Group(_("Account Settings"));
	    split.addWidget(account, ox.Configuration.Group.NoField);
	    account.addWidget(new ox.UI.Input(_("Account Name")), "name");    
	    account.addWidget(new ox.UI.Input(_("E-Mail Address")), "primary_address");
	    account.addWidget(new ox.UI.CheckBox(_("Use Unified INBOX for this account")), "unified_inbox_enabled");
	    account.addWidget(lb);
	    
	    /*** SERVER SETTINGS ***/
	    var mail = new ox.Configuration.Group(_("Server Settings")); 
	    split.addWidget(mail, ox.Configuration.Group.NoField);	        
	    
	    function changePort() {
	    	switch(mail_protocol.get()) {
	        	case "imap": 
	        		if (mail_secure.get()) {
	    	    		mail_port.set("993");
	    	    	} else {
	    	    		mail_port.set("143");	    	
	    	    	}
	        		mail_pop_note.setVisible(false);
	        		pop_refresh_rate.setVisible(false);
	        		pop_expunge_on_quit.setVisible(false);
	        		pop_delete_write_through.setVisible(false);
	        		break;
	        	case "pop3":
	        		if (mail_secure.get()) {
	    	    		mail_port.set("995");
	    	    	} else {
	    	    		mail_port.set("110");	    	
	    	    	}
	        		mail_pop_note.setVisible(true);
	        		pop_refresh_rate.setVisible(true);
	        		pop_expunge_on_quit.setVisible(true);
	        		pop_delete_write_through.setVisible(true);
	        		break;
	    	}
	    }
	    	    
	    
	    var mail_protocol = new ox.UI.ComboBox(_("Server Type"));
	    mail_protocol.width = "18.5em";
	    mail_protocol.setEntries(["imap","pop3"], [_("IMAP Mail Server"),_("POP3 Mail Server")]); 
	    mail_protocol.changed = changePort;
	    mail_protocol.default_value = "imap";
	    mail.addWidget(mail_protocol, "mail_protocol");
	    
	    var mail_pop_note = new ox.UI.Text(_("Please note: All messages received from the POP3 account will be stored to a folder on your local IMAP account."));
	    mail_pop_note.disable();
	    mail_pop_note.setVisible(false);
	    mail.addWidget(mail_pop_note, ox.Configuration.Group.NoField);
	    
	    var mail_secure = new ox.UI.CheckBox(_("Use SSL connection"));
	    mail.addWidget(mail_secure, "mail_secure");
	    mail_secure.changed = changePort;
	    
	    mail.addWidget(new ox.UI.Input(_("Server Name")), "mail_server");
	    var mail_port = new ox.UI.Input(_("Server Port"));
	    mail_port.default_value = "143";
	    mail.addWidget(mail_port, "mail_port");
	    
	    mail.addWidget(new ox.UI.Input(_("Login")), "login");
	    mail.addWidget(new ox.UI.Password(_("Password")), "password");
	    
	    var pop_refresh_rate = new ox.UI.ComboBox(_("Check for new messages every 'n' minutes"));
	    pop_refresh_rate.width = "5em";	    
	    pop_refresh_rate.setEntries(["3","5","10","15","30","60","360"], ["3","5","10","15","30","60","360"]);
	    pop_refresh_rate.setVisible(false);
	    mail.addWidget(pop_refresh_rate, "pop3_refresh_rate"); 
	    
	    var pop_expunge_on_quit = new ox.UI.CheckBox(_("Leave messages on server"));
	    pop_expunge_on_quit.setVisible(false);
	    pop_expunge_on_quit.changed = function() {
	    	if (pop_expunge_on_quit.get() == false) {
	    		pop_delete_write_through.set(false);
	    	}
	    	pop_delete_write_through.setEnabled(pop_expunge_on_quit.get());	    	
	    }
	    mail.addWidget(pop_expunge_on_quit, "pop3_expunge_on_quit");
	    
	    var pop_delete_write_through = new ox.UI.CheckBox(_("Deleting messages on local storage also deletes them on server"));
	    pop_delete_write_through.setEnabled(false);
	    mail.addWidget(pop_delete_write_through, "pop3_delete_write_through");
	    
	    mail.addWidget(lb);
	    	    
	    
	    /*** TRANSPORT SETTINGS ***/
	    var transport = new ox.Configuration.Group(_("Outgoing Server Settings (SMTP)"));
	    split.addWidget(transport, ox.Configuration.Group.NoField);
	    
	    var transport_secure = new ox.UI.CheckBox("Use SSL connection");
	    transport.addWidget(transport_secure, "transport_secure");
	    transport_secure.changed = function() {
	    	if (transport_secure.get()) transport_port.set("465");
	    	else transport_port.set("25");
	    };
	    
	    transport.addWidget(new ox.UI.Input(_("Server Name")), "transport_server");
	    
	    var transport_port  = new ox.UI.Input(_("Server Port"));
	    transport_port.default_value = "25";
	    transport.addWidget(transport_port, "transport_port");
	    
	    var transport_credentials = new ox.UI.CheckBox(_("Use username and password"));
	    transport.addWidget(transport_credentials, "transport_credentials");
	    transport_credentials.changed = function(bool) {
	    	var bool = transport_credentials.get();
	    	transport_login.setEnabled(bool);
	    	transport_password.setEnabled(bool);
	    };
	    
	    var transport_login = new ox.UI.Input(_("Login"));	    
		transport.addWidget(transport_login, "transport_login");		
		transport_login.disable();
		
		var transport_password = new ox.UI.Password(_("Password"));
		transport.addWidget(transport_password, "transport_password");
		transport_password.disable();
	    	    
	    /*** BUTTONS ***/
	    split.addWidget(lb);
	        
	    var buttons = new ox.Configuration.HLayout();
	    split.addWidget(buttons);
	    
	    var check_button = new ox.UI.Button(_("Check connection"));
	    check_button.click = function() { 
	    	newAlert(_("Info"), _("Please wait while checking the connection ... This may take a while ..."));
	    	$(globalalert.visibleButtons[0].id).style.display="none";
	    	var data = clone(split.get());
	    	if (selection.getSelected().length == 1) {
	    		data.id = selection.getSelected()[0];
	    		delete(data.password);
	    	}
	    	data.tree = false;
	    	ox.JSON.put(AjaxRoot + "/account?action=validate&session=" + session, data, 
	    			function(reply) {	    				
        				newAlert(_("Info"), reply.data ? _("The connection was successful.") : _("Connection failed! Please check your settings."));
                    },
                    function(reply) {
                    	newAlert(_("Error"), _("Connection failed! Please check your settings: ") + formatError(reply));
                    	return true;
                    });
	    };
	    buttons.addWidget(check_button);
	    
	    var save_button = new ox.UI.Button(_("Save"));
	    save_button.click = function() { split.saveView(); };
	    buttons.addWidget(save_button);
	
	    var cancel_button = new ox.UI.Button(_("Cancel"));
	    cancel_button.click = function() { split.cancelView(); };
	    buttons.addWidget(cancel_button);
	}
});