<?php
/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

/*
 *
 *
 *
 * This file handles all edit and updates regarding calendar, contacts, tasks
 */

session_start();
if(!session_is_registered("ox_data")){ // if does not exist.
  header("location:index.php"); // Re-direct to login
}else{

require ('api/oxapi.php'); // if you wanna use OX HTTP API Functions

    // First check if all needed arguments are given in the POST request
    $obj_id = $_POST['obj_id'];
    $folder_id = $_POST['folder_id'];
    $module = $_POST['module'];
    $action = $_POST['action'];
    $last_modified = $_POST['last_modified'];

    if($obj_id && $folder_id && $module && $action && $last_modified){
        if($module=='calendar'){
          handleCalendarEdit($obj_id,$folder_id,$action,$last_modified);
        }else if($module=='tasks'){
          handleTaskEdit();
        }else if($module=='contacts'){
          handleContactEdit();
        }else{
            // unknown module
          header("location:content.php?code=missing_data_edit");
        }     
    }else{
        // missing POST parameter
      header("location:content.php?code=missing_data_edit");
    }
}


    function handleCalendarEdit($obj_id,$folder_id,$action,$last_modified){
      if($action=='edit_confirmation'){
          handleEditConfirmation($obj_id,$folder_id,$last_modified);
      }
    }

    function handleEditConfirmation($obj_id,$folder_id,$last_modified){
        $oxdata = $_SESSION['ox_data'];
        $status_id = $_POST['conf_status'];
        $status_msg = $_POST['conf_message'];
        updateConfirmationForAppointment($oxdata,$obj_id,$folder_id,$status_id,$status_msg);
        header("location:index.php?module=calendar&view=list");
    }



?>
