<?


/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2007 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Manuel Kraft <manuel.kraft@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */


    session_start();
    $oxdata = $_SESSION['ox_data'];
    $obj_id = $_GET['obj_id'];

    if (!$obj_id) {
        // TODO: THROW ERROR HERE !!!
        return; // let script return
    } else {
        $folder_id = $oxdata['ox_default_folder_tasks'];
        // fetch task data
        try{
            $data = oXGetTask($oxdata,$obj_id,$folder_id);
        }catch(oXSessionTimeoutException $e){
            //echo "Session expired , loggin in again!";
            $session_is_expired = true;
            $oxdata = oXDoLogin($oxdata['ox_host'],$oxdata['ox_user'], $oxdata['ox_passwd'], false);
        }

        if($session_is_expired){
            // data is not defined, seems that session is expired
            $data = oXGetTask($oxdata,$obj_id,$folder_id);
        }
        $start_date = strftime('%a, %e. %b. %Y',strtotime(oXGetDisplayDate($oxdata,$data->start_date,'D d.m.Y H:i')));
        $end_date = strftime('%a, %e. %b. %Y',strtotime(oXGetDisplayDate($oxdata,$data->end_date,'D d.m.Y H:i')));

    }
?>

<div id="tasksDetail" title="<? echo _("Details");?>" class="panel">
    <fieldset>
        <div class="row" style="text-align:left;">
            <? 
               if (!empty($data->title)) {
            ?>
                <div style="padding-bottom:0;font-size:17px;font-weight:bold"><? echo $data->title; ?></div>
            <?
               }
               if ($data->location) {
               ?>
                <div style="color:grey;padding-top:0;padding-bottom:0"><? echo $data->location; ?></div>
               <?
               }
               echo "<div class=\"labelH\">";
               if ($data->start_date || $data->end_date) {
                    if ($data->start_date) {
                        echo _("Begins") . ": " . $start_date;
                        if ($data->end_date) {
                            echo "<br/>";
                        } 
                    }
                    if ($data->end_date) {
                        echo _("Ends") . ": " . $end_date;
                    }
                    echo "<br/>";
               }
               if ($data->priority) {
                    echo _("Priority") . ": ";
                    switch ($data->priority) { 
                        case 1:  
                            echo _("Low"); 
                            break; 
                        case 2: 
                            echo _("Medium"); 
                            break; 
                        case 3: 
                            echo _("High"); 
                            break;
                    };
                    echo "<br/>";              
               }
               if ($data->status) {
                    echo _("Status") . ": ";
                    switch ($data->status) {
                        case 1:
                            echo _("Not started");
                            break;
                        case 2:
                            echo _("In progress");
                            break;
                        case "3":
                            echo _("Done");
                            break;
                        case "4":
                            echo _("Waiting");
                            break;
                        case "5":
                            echo _("Deferred");
                            break;
                   }
                   echo "<br/>";
               }
               if ($data->percent_completed) {
                    echo _("% completed") . ": ";
                    echo $data->percent_completed . "%";                    
               }
               echo "</div>";
            ?>
        </div>
        
        <div class="row">
            <label>Notes</label><br>
            <div class="labelH labelN">
                <? echo nl2br($data->note); ?>
            </div>
        </div>
    </fieldset>
</div>