var oCi_import_data = null;
registerView("configuration/import",
	function () { 
		showNode("config_import"); 
		$("config_import").style.display="block";
	},
	function() { 		
		oCi_import_data = new Ci_import_data();
		oCi_import_data.createCombobox();
		if(!config.modules.calendar.module || !config.modules.tasks.module) {
			$("cs_import_ical").disabled = "disabled";
			$('cs_import_vcard').checked = true;
		} else
			$('cs_import_ical').checked = true;
		oCi_import_data.form = $('form_config_import');
		oCi_import_data.form.file.value="";
		register("OX_SAVE_OBJECT",uploadImportData);
	},
	function() {
		unregister("OX_SAVE_OBJECT",uploadImportData);
		unregister("cb_importComboChanged",cb_importComboChanged);
		unregister('cb_importComboCSVChanged', cb_importComboCSVChanged);
	},
	function () { 
		hideNode("config_import"); 
		$("config_import").style.display="none"; 
		oCi_import_data.resetView();
	},
	function () { }
);

function uploadImportData() {
	if(!oCi_import_data.process)
		oCi_import_data.uploadData();
}

function Ci_import_data() {
	this.action = "ICAL";
	this.folder = configGetKey("folder.calendar");
	this.combobox = null;
	this.process = false;
	$("fileImportInput").disabled = false;
	$("cimp_header").firstChild.nodeValue=getconfigPathSelected().substring(1);	
}

function cb_importComboChanged() {
	if(oCi_import_data.action == "ICAL")
		oCi_import_data.changeStatus("ical");	
}

function cb_importComboCSVChanged() {
	if(oCi_import_data.action == "CSV" || oCi_import_data.action == "OUTLOOK_CSV")
		oCi_import_data.changeStatus("csv");	
}

Ci_import_data.prototype = {
	uploadData : function() {	
		this.form = $('form_config_import');
		this.uri = AjaxRoot + "/import?action="+this.action+"&session="+session+"&folder="+this.folder;
		this.form.action = this.uri; 
		this.form.target="dlIframe"
		if(this.form.file.value=="") {
			triggerEvent("OX_New_Error", 4, _("Please select a file to import"));
		}
		else {
			this.process = true;
			this.form.submit();
			$("fileImportInput").disabled = true;
		}
	}, 
	createCombobox : function() {
		var cbText = new Array();
		cbText[0] = "Appointments"; /*i18n*/
		cbText[1] = "Tasks"; /*i18n*/
		cbText[2] = "Comma Separated"; /*i18n*/
		cbText[3] = "Outlook file"; /*i18n*/
		this.combobox = new ComboBox3(window, "import.combobox.module", "20em", 
			0, true, "cb_importComboChanged", null);
		this.combobox.addElement(cbText[0],"calendar");
		this.combobox.addElement(cbText[1],"tasks");
		this.combobox.getDomNode();
		if(!config.modules.calendar.module || !config.modules.tasks.module)
			this.combobox.disable();
		register('cb_importComboChanged', cb_importComboChanged);
		this.comboboxCSV = new ComboBox3(window, "import.combobox.csv", "20em", 
			0, true, "cb_importComboCSVChanged", null);
		this.comboboxCSV.addElement(cbText[2],"CSV");
		this.comboboxCSV.addElement(cbText[3],"OUTLOOK_CSV");
		this.comboboxCSV.getDomNode();
		this.comboboxCSV.disable();
		register('cb_importComboCSVChanged', cb_importComboCSVChanged);
	},
	resetView : function() {
		$('importLogTable').style.display = "none";
		$('dataImportLogMessage').innerHTML = "";
		var textM = "";
		$('importGreen').firstChild.data = textM;
		this.form.reset();
	},
	changeStatus : function(suffix) {
		var Self = this;
		switch(suffix) {
			case 'ical'		 	: 	Self.action = "ICAL";
									
									Self.combobox.enable();
									Self.comboboxCSV.disable();
													
									Self.folder  = configGetKey("folder."+Self.combobox.getKey());
									break;
				
			case 'vcard' 		: 	Self.action = "VCARD";
									Self.folder = configGetKey("folder.contacts");
									
									Self.combobox.disable();
									Self.comboboxCSV.disable();
									
									break;
			
			case 'csv' 			: Self.action = Self.comboboxCSV.getKey();
									Self.folder = configGetKey("folder.contacts");
									Self.comboboxCSV.enable();
									Self.combobox.disable();
									
									break;
		}
	}
}

function import_getWarningsAsString(warnings) {
	var retVal="";
	for (var i=0; i<warnings.length; i++) {
		retVal += (i+1)+") " + formatError(warnings[i]) + "<br />";
	}
	return retVal;
}

function callback_import(arg) {
	var textM = "";
	oCi_import_data.process = false;
	$("fileImportInput").disabled = false;
	if(arg.error) {
		newServerError(arg);		
	} else if (arg.data && arg.data.length != 0) {
		var successfullImported = 0;
		var importLog = "";
		for(var i=0; i<arg.data.length; i++) {
			if (arg.data[i].error) {
				importLog += formatError(arg.data[i]) + "<br />";
				if (arg.data[i].warnings && arg.data[i].warnings.length) {
					importLog += import_getWarningsAsString(arg.data[i].warnings);
				}	
				if (arg.data[i].category && arg.data[i].category == 13){
				    successfullImported++;
				}			
			} else if (arg.data[i].warnings && arg.data[i].warnings.length) {
                importLog += import_getWarningsAsString(arg.data[i].warnings);
            } else {
				successfullImported++;
			}
		}
		$('importLogTable').style.visibility = "visible";
		$('dataImportLogMessage').innerHTML = importLog;
		// #. %d is the number of successfully imported data records
		textM = format(_("Successfully imported: %d"), successfullImported);
	} else {
		$('importLogTable').style.display = "none";
		triggerEvent("OX_New_Error", 4, _("Internal Error: The server didn't provide any data."));
	}
	$('importGreen').firstChild.data = textM;
}

fileloaded();